globals
[
  selected-car   ;; the currently selected car
]

turtles-own
[
  speed         ;; the current speed of the car
  speed-limit   ;; the maximum speed of the car (different for all cars)
  lane          ;; the current lane of the car
  target-lane   ;; the desired lane of the car
  park-time     ;; the driver's current patience
  park          ;; the driver's probability to be searching for a parking space
  park?         ;; true if the car wants to park
  parked?       ;; true if the car is parked
  leaving?      ;; true if the car is leaving
  just-parked?  ;; true if the car has recently parked
  just-count    ;; time to park
]

to setup
  clear-all
  draw-road
  set-default-shape turtles "car"
  crt number
  [ setup-cars ]
  crt 20
  [ setup-parked ]
  reset-ticks
end

to draw-road
  ask patches
  [
    set pcolor green
    if ((pycor > -1) and (pycor < 2))
    [ set pcolor gray ]
    if ((pycor = 1) and ((pxcor mod 5) = 0)) and (pxcor != -60) and (pxcor != 60)
    [ set pcolor yellow ]
    if ((pycor = 2) or (pycor = -1) or (((pxcor = -1) or (pxcor = 1)) and (pycor < -1)))
    [ set pcolor black ]
    if ((pycor = 2) or (pycor = -1))
    [ set pcolor black ]
    if ((pxcor = 0) and (pycor < 0))
    [ set pcolor gray ]
  ]
end

to setup-parked
  set color blue
  set park? false
  set park 1000
  set parked? true
  setxy (random 120) 1
  set heading 90
  separate-parked
  set heading 180
  set park-time 1 + random parking-time
  set speed-limit  1
  set just-parked? false
end

to separate-parked
  if any? other turtles-here [ fd 1
    separate-parked]
  if (pcolor != yellow) [ fd 1
    separate-parked]
end

to setup-cars
  set color black
  setxy random-xcor 0
  set heading 90
  
  ifelse (gb-park = true)
  [set park random 1000]
  [set park 1000]
  
  ifelse (park > park-ratio * 10)
  [set park? false
   set speed  0.1 + random-float .9
   set speed-limit  1
   set park-time 0
    ]
  [set park? true
   set park-time 1 + random parking-time
   set speed  0.1 + random-float ((park-drive-speed - 10 ) / 100) ;; cars that are looking for a parking space are slower
   set speed-limit  park-drive-speed / 100
   set color red
   ]
  set just-parked? false
  set parked? false
  ;; make sure no two cars are on the same patch
  separate-cars
end

to separate-cars  ;; turtle procedure
  if any? other turtles-here
    [ fd 1
      separate-cars ]
end

;; All turtles look first to see if there is a turtle directly in front of it,
;; if so, set own speed to front turtle's speed and decelerate.  Otherwise, if
;; look-ahead is set for 2, look ahead one more patch and do the same.  If no front
;; turtles are found, accelerate towards speed-limit

to drive
  ;; first determine average speed of the cars
  ask turtles
  [ ifelse (parked? = true)
  [leave-parkspace]
  [
   ifelse ([pcolor] of (patch-at 0 1) = yellow) and (not any? turtles-at 0 1) and (park? = true)
   [park-car]
   [
   ifelse ([pcolor] of (patch-at 1 0) = red)
   [set speed 0]
   [ 
    ifelse (any? turtles-at 1 0)
    [
      set speed ([speed] of (one-of (turtles-at 1 0)))
      decelerate
    ]
    [
      ifelse (look-ahead = 2)
      [
        ifelse (any? turtles-at 2 0)
        [
          set speed ([speed] of (one-of turtles-at 2 0))
          decelerate
        ]
        [accelerate]
      ]
      [accelerate]
    ]
    
    if (speed < 0.01)
    [ set speed 0.01 ]
    if (speed > speed-limit)
    [ set speed speed-limit ]
    
    ;; Control for making sure no one crashes.
    
    if ((xcor + speed > 60) or ((xcor + speed > 0) and  (xcor + speed < 1.1))) and (leaving? = true) [setup-newcars]
    ifelse (any? turtles-at 1 0) and (xcor != min-pxcor - .5)
    [ set speed [speed] of (one-of turtles-at 1 0) ]
    [
      ifelse ((any? turtles-at 2 0) and (speed > 1.0))
      [
        set speed ([speed] of (one-of turtles-at 2 0))
        fd 1
      ]
      [jump speed]
    ]
   ]
  ]
  ]
  ]
  tick
end

to setup-newcars
  set color black
  
  ifelse (gb-park = true)
  [set park random 1000]
  [set park 1000]
  
  ifelse (park > park-ratio * 10)
  [set park? false
   set leaving? true
   set speed  0.1 + random-float .9
   set speed-limit  1
   set park-time 0
    ]
  [set park? true
   set leaving? false
   set park-time 1 + random parking-time
   set speed  0.1 + random-float ((park-drive-speed - 10 ) / 100) ;; cars that are looking for a parking space are slower
   set speed-limit  park-drive-speed / 100
   set color red
   ]

  set parked? false
  ;; make sure no two cars are on the same patch
  separate-cars
end

to park-car
      ask patch-at 0 0
     [set pcolor red]
      set heading 0
      fd 1
      set heading 180
      set leaving? false
      set park? false
      set parked? true
      set color blue 
      set just-parked? true
      set just-count time-to-park
end

to leave-parkspace
 ifelse (just-parked? = true)
 [
   ifelse (just-count > 0)
 [set just-count just-count - 1]
 [ask patch-at 0 -1
      [set pcolor gray]
  set just-parked? false
  set just-count time-to-park
   ]
 ]
 [ 
    ifelse (park-time > just-count)
    [set park-time park-time - 1]
    [
    ifelse (any? turtles-at 0 1) or (park-time > 0)
    [ask patch-at 0 -1
      [set pcolor red]
    set park-time park-time - 1
      ]
    [
      fd 1
      ask patch-at 0 0
     [set pcolor gray]
      set heading 90
      set leaving? true
      set park? false
      set parked? false
      set color black
      set speed  0.1 + random-float .9
      set speed-limit  1
      set park-time 0
    ]
    ]
 ]
end

;; increase speed of cars
to accelerate  ;; turtle procedure
  set speed (speed + (speed-up / 1000))
end

;; reduce speed of cars
to decelerate  ;; turtle procedure
  set speed (speed - (slow-down / 1000))
end
@#$#@#$#@
GRAPHICS-WINDOW
10
50
988
249
60
10
8.0
1
10
1
1
1
0
1
0
1
-60
60
-10
10
1
1
1
ticks
30.0

BUTTON
10
300
115
333
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
12
385
117
418
go
drive
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
11
341
116
374
go once
drive
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
620
480
734
525
average speed
mean [speed] of turtles
2
1
11

SLIDER
165
295
355
328
number
number
0
120
60
1
1
NIL
HORIZONTAL

SLIDER
165
415
355
448
slow-down
slow-down
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
385
340
560
373
park-ratio
park-ratio
0
100
40
1
1
%
HORIZONTAL

SLIDER
165
335
355
368
look-ahead
look-ahead
1
2
1
1
1
NIL
HORIZONTAL

PLOT
620
290
986
466
Car Speeds
Time
Speed
0.0
300.0
0.0
2.5
true
true
"set-plot-y-range 0 ((max [speed-limit] of turtles) + .5)" ""
PENS
"average" 1.0 0 -10899396 true "" "plot mean [speed] of turtles"
"max" 1.0 0 -11221820 true "" "plot max [speed] of turtles"
"min" 1.0 0 -13345367 true "" "plot min [speed] of turtles"

SLIDER
165
375
355
408
speed-up
speed-up
0
100
50
1
1
NIL
HORIZONTAL

SWITCH
385
295
555
328
gb-park
gb-park
0
1
-1000

SLIDER
385
385
560
418
park-drive-speed
park-drive-speed
10
100
30
1
1
NIL
HORIZONTAL

SLIDER
385
430
557
463
parking-time
parking-time
0
1000
100
1
1
NIL
HORIZONTAL

TEXTBOX
385
265
585
290
Parking characteristics
20
0.0
1

TEXTBOX
165
265
355
290
Traffic characteristics
20
0.0
1

TEXTBOX
20
10
170
36
Model
24
0.0
1

TEXTBOX
10
265
160
286
Initialize
20
0.0
1

SLIDER
385
475
557
508
time-to-park
time-to-park
0
100
10
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This project is a model allowing for cars to use on-street parking.  Much like a simpler model of Traffic, this model demonstrates how traffic jams can form, considering different speeds of the cars that are using the street,

As in the traffic model, traffic may slow down and jam without any centralized cause.

## HOW TO USE IT

Click on the SETUP button to set up the cars. Click on GO to start the cars moving. The GO ONCE button drives the car for just one tick of the clock.

The NUMBER slider controls the number of cars on the road. The LOOK-AHEAD slider controls the distance that drivers look ahead (in deciding whether to slow down or change lanes). The SPEED-UP slider controls the rate at which cars accelerate when there are no cars ahead. The SLOW-DOWN slider controls the rate at which cars decelerate when there is a car close ahead.

The GB-PARK (global parking) switcher controls whether cars are allowed to park. The PARK-RATIO slider controls the ratio of the cars that are driving through the street that are actually looking for a parking space. The PARK-DRIVE-SPEED slider controls the speed at which cars that are looking for a parking space drive (it controls the maximum speed; the maximum speed of cars that are not looking for a parking space is 100). The PARKING-TIME controls the number of rounds that a car, once parked, stay in the parking space. Finally the TIME-TO-PARK slider controls the number of rounds a car takes to park once it has found a free parking space.

You may wish to slow down the model with the speed slider to watch the behavior of certain cars more closely.

The AVERAGE-SPEED monitor displays the average speed of all the cars.

The CAR SPEEDS plot displays four quantities over time:  
- the maximum speed of any car - CYAN  
- the minimum speed of any car - BLUE  
- the average speed of all cars - GREEN  

## RELATED MODELS

Traffic Basic
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
setup
repeat 50 [ drive ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
