extensions [matrix]

    ;  6 is the minium age for edu
                               ;  max edu is 20
                               ;  min edu is 10
                               ;  skilled edu > 14
                               ;  unskilled edu 10-14
   ;  according to CPS
   ;  http://www.census.gov/content/dam/Census/library/publications/2016/demo/p20-578.pdf
   ;  working history


globals [       ; average price level
             data
             gini-index
             gini_
             lorenz-points
             n             ; number of turtles
             n_trans       ; number of transfers
             trans_tot
             transfers?    ; default is true
             frustrated_sales? ; default is true
             retire_age
             dead
             filename
             hcount
             edu_skld      ; years to become skld
             grad_count
             tax_rate      ; household tax rate
             GDP_          ; LAGGED GDP
             P-content     ; Phosphorous content in lake
             absorbtion    ; Amount of phosphorous absorbed by lake per sweep
             G             ; govt spending on goods and services

            ;
         ]


turtles-own [
             B         ; budget
             B_        ; lagged budget
             X         ; goods
             X_
             Y         ; future consumption
             alpha     ; preference
             U         ; utility
             working?  ; have a job
             purchase?
             w         ; wages
             wtot
             fs        ; frustrated sales
             tax
             transfers
             edu       ; education
             age       ; age
             inher
             heirs
             unempl      ; unemployment
             in_school?  ;
             aff_schl?     ;


             ]

patches-own
  [Q                   ; output
   Q_                  ; lagged output
   beta                ; elas of output with respect to capital
   K                   ; capital stock
   L                   ; labor demand
   MPL                 ; MPL
   prof                ; residual after paying wages
   inven               ; inven
   inven_              ; inven lagged
   p                   ; price
   p_                  ; price lagged
   costs               ;
   sd                  ; demand for skilled labor
   patch-type          ; "farm", "residential", or "firm"
   P-rate              ; Function of distance from line x=0 (lake), K, and patch type.
   inv                 ; investment
   dinven_list         ; change in inventory list
   gamma
   ext                 ; extrenalities
  ]

to setup
  clear-all
  set tax_rate 0
  set G 0
  set edu_skld 14
  set retire_age 70
  set transfers? true
  set frustrated_sales?  false
  set n 500
  set lorenz-points []
  setup-patches
  setup-turtles
  update-lorenz-and-gini
  set gini_ 0
  reset-ticks
end

to setup-patches
  ask patches
  [
  set pcolor blue - 2
  set beta 0.05 + random-float .35     ;
  set K random 10              ;  some capital stock between 0 and 9
  set inven 5
  set inven_ 0
  set Q 1
  set Q_ 1
  set p 1
  set p_ 1
  set ext 0
  set gamma 0.3 + random-float .4
  if  K = 0
  [set pcolor gray]
 ; Of patches with K > 0,
      ; 40% are farms and
      ; 60% are firms.
      ; Patches with K = 0 are residential.
      ifelse random 10 < 4 [
        set patch-type "farm"
        set pcolor 50 + K            ; color farms with more capital darker.
        ][
        set patch-type "firm"
        set pcolor 100 + K           ;  color firms
        ]
        set patch-type "residential"
    set dinven_list []
  ]
  ;  set skilled labor demand
  ask patches [ set sd skl_lab K]

end

to setup-turtles
  create-turtles  n
  [ set alpha (0.2  +  random-float 0.8)
   set aff_schl? true
   set w 1
   set B 1 + random 4
   setxy random-xcor random-ycor
   set U 1
   set shape "circle"
   set size .5
   set in_school?  false
   set age 6 + random 65
   if in_school? = true [move-to one-of patches with [k = 0]]
   set heirs 1 +  random 10
   set edu yrs_edu age   ; notice passing of data age

  ]
  debug-print
end

   to-report skl_lab [cap]
     let maxK max [K] of patches
     let sd_ 10 +  10 * cap / maxK
     report sd_
   end

  to-report yrs_edu [yrs_age]
    let ed 0
    let edu_max yrs_age - 6    ;  the amount of educuation if stayed in school
    let drop_out yrs_age - 16  ;  years in which dropping out of school is legally possible
    if yrs_age <= 16
     [set ed edu_max set in_school?  true]

    if (yrs_age >= 16 and yrs_age <= 24)
    [ifelse (random-float 1 < (1 - drop_out * .1) )
     [set ed edu_max set in_school?  true ]
     [set ed edu_max - (1 + random drop_out) set in_school?  false ]]

     let tmp_float random-float 1
     ;print tmp_float
   if (yrs_age >= 25 and yrs_age <= 34)  [ifelse tmp_float <  0.109
                                          [set ed 17 + random 4]
                                           [ifelse tmp_float < 0.361
                                            [set ed 16]
                                             [ifelse tmp_float < 0.465
                                              [set ed 14 + random 2]
                                               [ifelse tmp_float < 0.65
                                                [set ed 13 ]
                                                 [ifelse tmp_float < 0.905
                                                   [set ed 12]
                                                    [set ed 11 - random 2]
                                                     ]]]]]
    ;print yrs_age
    ;print ed

     set tmp_float random-float 1
  if (yrs_age >= 35 and yrs_age <= 44)  [ifelse tmp_float  < 0.138
                                          [set ed 17 + random 4]
                                           [ifelse tmp_float  < 0.363
                                            [set ed 16]
                                             [ifelse tmp_float  < 0.467
                                              [set ed 14 + random 2]
                                               [ifelse tmp_float  < 0.628
                                                [set ed 13 ]
                                                  [ifelse tmp_float  < 0.887
                                                   [set ed 12]
                                                    [set ed 11 - random 2]
                                                       ]]]]]
    set tmp_float random-float 1
  if (yrs_age >= 45 and yrs_age <= 64)  [ifelse tmp_float  < 0.121
                                          [set ed 17 + random 4]
                                           [ifelse tmp_float  < 0.32
                                            [set ed 16]
                                             [ifelse tmp_float  < 0.426
                                              [set ed 14 + random 2]
                                               [ifelse tmp_float  < 0.59
                                                [set ed 13 ]
                                                 [ifelse tmp_float  < 0.894
                                                  [set ed 12]
                                                   [set ed 11 - random 2]
                                                       ]]]]]
     set tmp_float random-float 1
   if (yrs_age >= 65)                    [ifelse tmp_float  < 0.113
                                          [set ed 17 + random 4]
                                           [ifelse tmp_float  < 0.267
                                            [set ed 16]
                                             [ifelse tmp_float  < 0.341
                                              [set ed 14 + random 2]
                                               [ifelse tmp_float  < 0.497
                                                [set ed 13 ]
                                                  [ifelse tmp_float  < 0.843
                                                   [set ed 12]
                                                    [set ed 11 - random 2]
                                                       ]]]]]

   ;type " edu = " type ed type " age = " print yrs_age
   report ed
end

to debug-print
   let tmp 16
   repeat 54 [
   type tmp type " = " type  count turtles with [edu < 12 and age = tmp]
   type " of " print count turtles with [age = tmp]
   set tmp tmp + 1
   ]

   type  "total =  " type count turtles with [edu < 12 and age >= 18]
   type " of " print count turtles with [age >= 18]


   type "high school or better " print  precision (100 *  count turtles with
     [edu >= 12 and age >= 25] / count turtles with [age >= 25]) 2

   type "associates or better "  print  precision (100 * count turtles with
     [edu >= 14 and age >= 25] / count turtles with [age >= 25]) 2

   type "college or better "     print  precision (100 * count turtles with
     [edu >= 16 and age >= 25] / count turtles with [age >= 25]) 2

   type "grad " print precision (100 * count turtles with
     [edu >= 18 and age >= 25] / count turtles with [age >= 25]) 2

   end


to go

  if  (abs ( gini-index - gini_)  < .001  ) [ big-data stop ]
  ; update-price                                 ; change price based on inventory adjustment
  save-lagged                                  ; current data as lagged before the rest of go changes it
  retire
  school
  look-for-job                                 ; turtle procedure
  produce                                      ; patch procedure production preceeds consumption
  demand                                       ; turtle procedure uses B from the past
                                                ; get ready for next round
  update-budget                                ; for next period
  update-lorenz-and-gini
  tick
end

  to save-lagged
  set gini_ gini-index

  ask patches
  [
    set dinven_list  lput (inven - inven_)  dinven_list
    if length dinven_list > 100 [set dinven_list butlast dinven_list]
    set inven_ inven
    set p_ p

    let tmp item 2 matrix:forecast-linear-growth dinven_list
  ifelse (tmp >= -.001) [                                          ; positive slope implies positive forecast
    set inv 0
    ;print "don't invest"
    ][
    set inv 1 invest
    ]
   ]

   ask turtles

  [ set aff_schl? true
    set X_ X
    set B_ B
    ifelse working? = false [set unempl unempl + 1][set unempl 0] ; reset unempl if found job
    set working? false
    set purchase?  false
    set age age + 1
    if in_school? = true [set edu edu + 1]
    set in_school? false
    set transfers 0
    set tax 0
  ]
  end

 to retire
 let benefit 0
 ask turtles
 [if age > retire_age
 [set dead dead + 1
   set inher B / ( heirs + 1 )
   set benefit inher
   ;type "inher of turtle " type who type " in the amount of "  print inher
   repeat heirs
     [
    ; type " heirs = " print heirs
     ask one-of other turtles
       [set B B + benefit
     ;   type "inher received by " type who type " in the amount of " print benefit
         ]
     ]

 ;budget of offspring

 set B inher
 set age 1 + random 6
 ;print age
 set edu yrs_edu age
 set alpha alpha + .1 *  (.5 - random-float 1)                 ; Give offspring a new alpha
 if alpha > .9  [set alpha .9 ]   ;  ad hoc
 if alpha < .1  [set alpha .1 ]   ;  ad hoc
   ]
 ]
 end

to school
ask  turtles with [unempl > 4 and edu <= 16 ]
[ let x_min  alpha * B / (2 * mean [p] of patches )  ;  go to starvation consumption
  let yrs_schl  B / x_min   ;  finance school with savings

  ifelse (yrs_schl >= 1) [ set alpha alpha / 2
                    move-to one-of patches with [K = 0]
                    set in_school? true
                     ]

                  [ set in_school? false ]
]
end

to look-for-job
 ask turtles with [in_school? = false]
  [right random 360
   forward 3
   if edu >= [sd] of patch-here
   ;[ if ss > [sd] of patch-here [print "over qualified"]
   ;  if ss = [sd] of patch-here [print "qualified"]

    [set working? TRUE set unempl 0
    ;set color white print working?
    ]
  ]
end

to produce
  ask patches
  [

    set L count turtles-here with [working? = true]    ; each turtle supplies one unit of labor
    ;type " L = " print L
    set Q  K ^ beta * L ^ (1 - beta)                   ; production function
    set inven  inven_ + Q                              ; add Q to inventory
    set Q_ Q

    ifelse L > 0
    [set MPL  ( 1 - beta ) * (K / L)  ^ beta ] ; determine marginal product if producing
    [set MPL 0 set Q 0]                       ; if not then set to zero
    ask turtles-here
    [if (working? = true) [set w p *  MPL]]                          ; this is a nominal wage based on the last price paid
  ifelse Q > 0
   [ set costs  p * MPL * L  set prof p * Q - costs set pcolor green - 1]
   [ set costs 0 set prof 0  set pcolor blue  - 1]
  if K = 0
   [set pcolor gray ]
   if K > 0
   [set ext (Q / K) ^ gamma]
    ]

end

to demand                                   ; since more than one turtle can arrive on the same patch
                                            ; different turtles pay different prices
  ask turtles [
      right random 360                      ; turtle arrives on new patch--may be the second to arrive
      forward 3
      set X alpha * B / [p] of patch-here

      ifelse X <= inven                    ; turtle makes purchase if inventory is sufficient
       [ set purchase?  true
         set inven inven - X]               ; adjust inventory

       [ set  X inven                       ; buy remaining inventory
         set  fs fs + 1                     ; record frustrated sale
         set  inven inven - X               ; should bezero
         if X > 0 [set purchase? true]      ;  don't say purchase is true if the the quantity is zero
       ]      ;
                                            ; now update turtle utility
      set  Y  (1 - alpha) * B               ; compute Y
      set  U X ^ alpha * Y ^ ( 1 - alpha )  ; utility

    if in_school? = true [move-to one-of patches with [k = 0]]; go back to school

  ]
end

  to invest
    ask one-of patches with [inv > 0 ]
    [let d_inv  0.1 * K
      while  [d_inv > 0]
       [let supplier one-of other patches with [inven > 0]
         ifelse (supplier = nobody)
          [set d_inv  0]
          [ifelse  d_inv <  [inven] of supplier
           [set K K + d_inv set d_inv 0
            ask supplier [ set inven inven - d_inv  ]]
          [set K K + [inven] of supplier
            set d_inv d_inv - [inven] of supplier
            ask supplier [ set inven 0]]
       ]
     ]
      set sd skl_lab K  ; upgrade skill demand
    ]
end
  to update-budget
     ask turtles
      [ if purchase? = true
        [set B B - p * X]                   ;  what you didn't spend goes into next period's savings
        ifelse working? = true
        [set B B + w set wtot wtot + w set color blue ]
        [set color red if (in_school? = true) [set color yellow]]
     let prof_sum  sum [prof] of patches
     let B_sum sum [B_] of turtles          ; distribuion is based on this period's savings
     set B  B +  B_ / B_sum * prof_sum

   ;  now tax rich and redistribute to poor  tax rate is exogenous
      ]

     let n_rich 0.2 * n

     let rich max-n-of n_rich turtles [B]

   ask rich
      [
        set tax tax_rate * B
        set B B - tax


      ]

     let n_poor count turtles with [tax = 0]
     let trans_total sum [tax] of turtles
  ask turtles with [tax = 0]
     [set transfers trans_total / n_poor
      set B B + transfers  ]



  end



  to update-price
    ask patches [                            ; increase or decrease price
      if Q != 0 [
      ifelse inven / Q  > inven_ / Q_
      [set p p_ * 0.98 ]
      [set p p_ * 1.02  ]
      ]
    ]
  end


;  make SAM

  to-report C   ; total consumption
    let C_ sum [ p * X ] of turtles with [purchase? = TRUE]
    report C_
  end

  to-report I   ; total investment
    let I_  sum [p * (inven - inven_) ] of patches
    report I_
  end

  to-report VA    ; value added
    let VA_ sum [w] of turtles with [working? = TRUE] + sum [prof] of patches
    report  VA_
  end

   to-report Wages    ; value added
    let Wages_ sum [w] of turtles with [working? = TRUE]
    report  Wages_
  end

  to-report Profits    ; value added

    let Profits_  sum [prof] of patches
    report  Profits_
  end

  to-report Yh   ; household income
    let Yh_ sum [w] of turtles with [working? = TRUE] + sum [prof] of patches + sum [transfers] of turtles
    report  Yh_
  end

  to-report S     ; household
     let S_   sum [w] of turtles with [working? = TRUE] + sum [prof] of patches
            - sum [ p * X ] of turtles with [purchase? = TRUE]
            - sum [tax] of turtles + sum [transfers] of turtles

     report  S_
  end

  to-report GDP
    report  sum [p * Q] of patches  ;
  end

to-report pollution
  let ext_ sum [ext] of patches
  report ext_
end

  to-report Tr
      let Tr_  sum [transfers] of turtles ;
      report Tr_
  end
to-report Yg
      let Yg_  sum [tax] of turtles ;
      report Yg_
  end


  to-report Sg
      let Sg_  Yg  - Tr ;
      report Sg_
  end

  to-report SI-err
    let I_ sum [p * (inven -  inven_) ] of patches
    let delta_wealth  sum [B] of turtles - sum[B_] of turtles
    report  Sg + delta_wealth - I_ ; total savings of turtles minus investment
  end



to big-data
set filename "data.csv"
if hcount = 0
[write-csv filename (list "who" "alpha" "B" "yrs_wk" "yrs_wks" "wtot" "fs" "tax" "transfers" )]
ask turtles [ write-csv filename (list who alpha B wtot fs tax transfers) ]
set hcount hcount + 1
end

to write-csv [ #filename #items ]  ;; #items is a list of the data (or headers!) to write.
 if is-list? #items and not empty? #items
 [ file-open #filename
 ;; quote non-numeric items
 set #items map quote #items
 ;; print the items
 ;; if only one item, print it.
 ifelse length #items = 1 [ file-print first #items ]
 [file-print reduce [ (word ?1 "," ?2) ] #items]
 ;; close-up
 file-close
 ]
 end


 to-report quote [ #thing ]
 ifelse is-number? #thing
 [ report #thing ]
 [ report (word "\"" #thing "\"") ]
 end



 to-report te_rule
   let n_rich 0.2 * n
   let B_tot sum [B] of turtles
   let B_rich sum [B] of max-n-of n_rich turtles [B]
   let te_rule_ B_rich / B_tot
   report te_rule_

 end


;; this procedure recomputes the value of gini-index-reserve
;; and the points in lorenz-points for the Lorenz and Gini-Index plots


to update-lorenz-and-gini
  let sorted-wealths sort [B] of turtles
  let total-wealth sum sorted-wealths
  let wealth-sum-so-far 0
  let index 0
  set gini-index 0
  set lorenz-points []   ;  a list

  ;; now actually plot the Lorenz curve -- along the way, we also
  ;; calculate the Gini index.

  repeat n  [
    set wealth-sum-so-far (wealth-sum-so-far + item index sorted-wealths)
    set lorenz-points lput ((wealth-sum-so-far / total-wealth) * 100) lorenz-points
    set index (index + 1)
    set gini-index
    gini-index +
    (index / n) -
    (wealth-sum-so-far / total-wealth)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
240
10
715
506
15
15
15.0
1
10
1
1
1
0
1
1
1
-15
15
-15
15
1
1
1
ticks
30.0

BUTTON
39
40
123
73
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
126
40
203
73
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
41
162
149
207
Working turtles
count turtles with [working? = true]
3
1
11

MONITOR
40
119
170
164
Producing patches
count patches with [Q > 0]
0
1
11

PLOT
25
349
225
499
Totals
time
totals
0.0
5.0
0.0
5.0
true
true
"" ""
PENS
"GDP" 1.0 0 -16777216 true "" "if sum [Q] of patches > 0 [plot ln sum [Q] of patches]"
"U" 1.0 0 -10899396 true "" "if sum [U] of turtles > 0 [plot ln sum [U] of turtles]"
"p" 1.0 0 -8053223 true "" "plot mean [p] of patches"

BUTTON
132
79
195
112
step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
777
447
834
492
NIL
SI-err
2
1
11

MONITOR
774
136
831
181
C
C
2
1
11

MONITOR
828
136
885
181
I
I
2
1
11

MONITOR
941
135
998
180
GVP
GDP
2
1
11

MONITOR
717
183
774
228
VA
VA
2
1
11

MONITOR
721
408
778
453
GVP
GDP
2
1
11

MONITOR
945
180
1002
225
Yh
VA + sum [Transfers] of turtles
2
1
11

MONITOR
776
404
833
449
Yh
Yh
2
1
11

MONITOR
776
358
833
403
S
S
2
1
11

MONITOR
948
355
1005
400
S_total
S + Sg
2
1
11

MONITOR
837
405
894
450
I
I
2
1
11

TEXTBOX
761
93
911
111
Social Accounting Matrix
11
0.0
1

PLOT
1079
307
1279
457
Wealth Distribution
NIL
NIL
0.0
100.0
0.0
20.0
false
false
"" ""
PENS
"Wealth" 1.0 1 -16777216 true "" "set-plot-x-range 0 max [B] of turtles\nset-plot-y-range 0 count turtles\nset-histogram-num-bars 20\nhistogram [B] of turtles"

MONITOR
899
510
956
555
NIL
te_rule
2
1
11

MONITOR
717
226
774
271
Wages
Wages
2
1
11

MONITOR
946
224
1003
269
Wages
Wages
2
1
11

MONITOR
717
271
774
316
Profits
Profits
2
1
11

MONITOR
947
268
1004
313
Profits
Profits
2
1
11

MONITOR
235
515
325
560
GDP deflator
sum [p * Q] of patches / sum [Q] of patches
5
1
11

PLOT
1079
158
1279
308
Gini
NIL
NIL
0.0
50.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot (gini-index / n) / 0.5"

PLOT
1079
10
1279
160
Lorenz curve
NIL
NIL
0.0
100.0
0.0
100.0
false
false
"" "plot-pen-reset\nset-plot-pen-interval 100 / n\nforeach lorenz-points plot"
PENS
"lorenz" 1.0 0 -2674135 true "" "plot-pen-reset\nset-plot-pen-interval 100 / n\nforeach lorenz-points plot"
"equal" 100.0 0 -16777216 true "plot 0\nplot 100" ""

MONITOR
40
74
97
119
Turtles
count turtles
17
1
11

MONITOR
108
515
181
560
Transfers
trans_tot
3
1
11

MONITOR
181
515
238
560
Tax
sum [tax] of turtles
3
1
11

MONITOR
538
512
595
557
dead
dead
0
1
11

MONITOR
52
514
109
559
inher
sum[inher] of turtles
17
1
11

MONITOR
915
10
965
55
Gini
(gini-index / n) / 0.5
2
1
11

MONITOR
328
514
398
559
In school
count turtles with [in_school? = true]
17
1
11

MONITOR
398
513
455
558
Age
mean [age] of turtles
1
1
11

MONITOR
454
513
537
558
Unemployed
count turtles with [working? = false and in_school? = false]
0
1
11

PLOT
25
200
225
350
Skilled labor
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"skilled" 1.0 0 -16777216 true "" "plot mean [w] of turtles with [edu  >= 14]"
"uskld" 1.0 0 -2674135 true "" "plot mean [w] of turtles with [edu <  14]"

MONITOR
595
512
652
557
grads
grad_count
17
1
11

MONITOR
651
512
708
557
x
mean [x] of turtles
2
1
11

PLOT
968
461
1168
611
Education
NIL
NIL
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"Edu" 1.0 1 -16777216 true "" "set-plot-x-range 1 max [edu] of turtles\nset-histogram-num-bars 20\nhistogram [edu] of turtles"

MONITOR
764
511
830
556
max edu
max [edu] of turtles
0
1
11

MONITOR
831
511
901
556
edu-med
median[edu] of turtles
1
1
11

MONITOR
882
135
939
180
G
G
2
1
11

MONITOR
777
316
834
361
Tax
sum [tax] of turtles
2
1
11

MONITOR
946
312
1003
357
Tax
Yg
2
1
11

MONITOR
895
405
952
450
G tot
G + Tr
2
1
11

MONITOR
884
182
941
227
Tr
sum [transfers] of turtles
2
1
11

MONITOR
892
357
948
402
Sg
Sg
2
1
11

MONITOR
53
558
110
603
K
mean [K] of patches
1
1
11

MONITOR
109
559
169
604
Aff Schl
count turtles with [aff_schl? = false]
17
1
11

MONITOR
705
512
768
557
Skl Dmd
median [sd] of patches
1
1
11

PLOT
1171
461
1371
611
EKC
GDP
Pollution
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot sum [ext] of patches"

MONITOR
1218
610
1337
655
units of pollution
pollution
2
1
11

@#$#@#$#@
## WHAT IS IT?

The construction of this model is described in Tutorial 3 in the NetLogo User Manual.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="B-space EKc" repetitions="4" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>Y</metric>
    <metric>B</metric>
    <metric>B^2</metric>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
