to setup

  ca

  if (Scenario = "Normal")  [
    set O2-difference? false
    set CO-slider 3.5
    set Hb-slider 140
    set SaO2-slider 98
    set SvO2-slider 77
    set O2-DE-slider 0.0015
    set O2-UR-slider 0.975
  ]


  if (Scenario = "Exercises-w/o-correction") [
    set O2-difference? true
    set CO-slider 3.5
    set Hb-slider 140
    set SaO2-slider 98
    set SvO2-slider 77
    set O2-DE-slider 0.0015
    set O2-UR-slider 0.975
  ]

   if (Scenario = "Exercises-with-correction") [
    set O2-difference? true
    set CO-slider 7.0
    set Hb-slider 140
    set SaO2-slider 98
    set SvO2-slider 65
    set O2-DE-slider 0.0008
    set O2-UR-slider 0.975
  ]

   if (Scenario = "Cardiogenic-Shock-w/o-correction") [
    set O2-difference? true
    set CO-slider 1.0
    set Hb-slider 140
    set SaO2-slider 98
    set SvO2-slider 75
    set O2-DE-slider 0.0015
    set O2-UR-slider 0.975
  ]

  if (Scenario = "Cardiogenic-Shock-with-correction") [
    set O2-difference? true
    set CO-slider 1.5
    set Hb-slider 140
    set SaO2-slider 98
    set SvO2-slider 60
    set O2-DE-slider 0.0020
    set O2-UR-slider 0.99
  ]

  if (Scenario = "Hemorrhagic-Shock-w/o-correction") [
    set O2-difference? true
    set CO-slider 2.0
    set Hb-slider 60
    set SaO2-slider 98
    set SvO2-slider 75
    set O2-DE-slider 0.0015
    set O2-UR-slider 0.975
  ]

  if (Scenario = "Hemorrhagic-Shock-with-correction") [
    set CO-slider 2.5
    set Hb-slider 60
    set SaO2-slider 98
    set SvO2-slider 60
    set O2-DE-slider 0.0023
    set O2-UR-slider 0.99
  ]

  system-dynamics-setup

end

to go
  system-dynamics-go
  system-dynamics-do-plot

  tick
end
@#$#@#$#@
GRAPHICS-WINDOW
517
13
561
58
-1
-1
1.1
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

SLIDER
30
339
202
372
SaO2-slider
SaO2-slider
20
100
98.0
1
1
NIL
HORIZONTAL

SLIDER
31
378
203
411
SvO2-slider
SvO2-slider
10
90
75.0
1
1
NIL
HORIZONTAL

SLIDER
32
418
204
451
CO-slider
CO-slider
0.5
10
1.0
0.05
1
NIL
HORIZONTAL

SLIDER
237
417
409
450
Hb-slider
Hb-slider
30
170
140.0
1
1
NIL
HORIZONTAL

SLIDER
236
339
408
372
O2-DE-slider
O2-DE-slider
0.0001
0.0025
0.0015
0.0001
1
NIL
HORIZONTAL

SLIDER
237
379
409
412
O2-UR-slider
O2-UR-slider
0.4
1
0.975
0.005
1
NIL
HORIZONTAL

BUTTON
25
16
88
49
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
103
17
166
50
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
12
68
469
328
DO2 & VO2 over time
time
mL/min
0.0
10.0
0.0
10.0
true
true
"" "if ticks > 30000 [ set-plot-x-range ticks - 30000 ticks]"
PENS
"DO2" 1.0 0 -13840069 true "" ""
"O2 diifference" 1.0 1 -1184463 true ";ifelse (Scenario = \"Hemorrhagic Shock\") or (Scenario = \"Cardiogenic Shock\")\n;[set-current-plot-pen \"O2-difference\"]\n;[ stop plot DO2 - VO2 ]" "if O2-difference? = true [plot  DO2 - VO2]"
"VO2" 1.0 0 -5825686 true "" ""

MONITOR
479
68
613
113
DO2 mL/min/m2
DO2
2
1
11

MONITOR
480
120
615
165
VO2 mL/min/m2
VO2
2
1
11

MONITOR
480
173
614
218
DO2-VO2 difference mL
DO2 - VO2
2
1
11

CHOOSER
259
13
467
58
Scenario
Scenario
"Normal" "Exercises-w/o-correction" "Exercises-with-correction" "Cardiogenic-Shock-w/o-correction" "Cardiogenic-Shock-with-correction" "Hemorrhagic-Shock-w/o-correction" "Hemorrhagic-Shock-with-correction"
3

MONITOR
480
281
617
326
Cardiac Index mL/min/m2
CO + random-float 0.1
2
1
11

MONITOR
481
225
616
270
O2 Extraction Ratio %
ifelse-value ( VO2 / DO2 >= 1.00)\n[100]\n[ VO2 / DO2 * 100 ]
1
1
11

SWITCH
451
355
572
388
O2-difference?
O2-difference?
0
1
-1000

@#$#@#$#@
## WHAT IS IT?

This is a System Dynamics Model. In order to run it you shoulld download and run it on your PC.

Oxygen delivery (DO2) to the tissues/cells and its subsequent consumption (VO2) is crucial for the body functioning and under certain circumstances, even for survival.
 
Physiological mechanisms and controls governing these processes are complex and non-linear with an ultimate objective to supply sufficient oxygen for maintaining an aerobic metabolism under a wide range of external and internal conditions. 

This model is intended to provide a rough approximation of the essential elements of DO2/VO2 system and their interaction at a systemic level in an attempt to ensure an oxygen delivery sufficient to meet oxygen demands under a range of physiological and pathological conditions. 

## HOW IT WORKS

Human oxygen metabolism represents a complex system by which O2 from the atmospheric air is being transported to its main site of physiological use, the mitochondria. On its way to mitochondria O2 passes a number of distinct steps: airways, alveoli, alveolar-capillary membrane, then binds to hemoglobin in the red blood cells, later being transported to the tissues through vessels due to pumping activity of the heart and at the tissue level diffuses through capillary membrane to the interstitial space, then intracellular space and finally reaches mitochondria. For an effective O2 delivery there should be optimal conditions at any of these steps. 

Within a broad range of O2 delivery rates, a more or less constant rate of whole-body O2 consumption (dictated by cellular requirements) is maintained. However, in certain pathological states the relationship between DO2 and VO2 can be altered and can lead to disastrous consequences, especially in critically ill patients.
 
Oxygen is carried in arterial blood dissolved in solution (< 2% when breathing air) and combined with hemoglobin (> 98%). Cardiac output has a crucial role in this process. DO2 can be calculated using the following formula:
 
DO2 = CO x (1,34 x Hb x Sa O2 + PaO2 x 0.003),
 
where 
CO (L/min) – Cardiac Output; 
1,34 – Hufner’s constant (the amount of oxygen (ml) 1 gram of hemoglobin binds); 
Hb (g/L) – hemoglobin level; 
Sa O2 (%)– the arterial Hb oxygen saturation, 
PaO2 (mmHg) – arterial partial pressure of oxygen and 
0.003 – solubility coefficient of oxygen. Since the latter is small the portion of oxygen dissolved in plasma is usually ignored.
 
In a similar way can be calculated the amount of oxygen consumed by tissues (VO2):

VO2 = CO x (1,34 x Hb x (Sa O2 - SvO2)),
 
where SvO2 (%) is the mixed venous Hb oxygen saturation.

Relation between DO2 and VO2 is represented by Oxygen Extraction Ratio: O2ER = VO2/DO2
Along with the above parameters (i.e. DO2, VO2, O2ER) there are additional ones which can help identifying situations when oxygen delivery is not commensurate with tissue metabolic needs. (1) Serum Lactate ≤2 mmol/L, (2) Mixed venous Hb oxygen saturation - SvO2> 65% and Arterial-venous oxygen difference - D (a-v) O2 ≤ 5mL/dL point on an oxygen supply commensurate with tissue consumption.
 
Oxygen delivery is responsive to (patho-) physiological changes in any of the 3 components of DO2 (Hb, oxygenation, and CO) and changes in VO2. In the case of acute hypoxia or acute anemia, CO increases to maintain normal DO2. However, there is almost no acute compensatory mechanism for acute reduction in CO. Acute reduction in DO2 due to a drop in CO (e.g., acute myocardial infarction) when VO2 is unchanged is "compensated" by greater oxygen extraction (ER), resulting in a drop in mixed venous oxygen saturation (SvO2). Oxygen delivery is also responsive to the changing metabolic needs and VO2, exempliﬁed by the increase in DO2 when VO2 increases from rest to exercise (mediated almost completely by an increase of CO). The proportionate increase in DO2 maintains the ratio of delivery to consumption (DO2-VO2 ratio) at approximately 5:1. This DO2-VO2 ratio is high enough that cellular respiration is not supply-dependent, and VO2 is predominantly a function of tissue oxygen demand. Failure to maintain the DO2-VO2 ratio is initially compensated by increased oxygen extraction and fall in mixed venous oxygen content.
 
Below this critical level of DO2 (at a DO2-VO2 ratio of approximately 2:1), VO2 falls in a near-linear fashion with ensuing tissue hypoxia. The cells become almost completely reliant on inefﬁcient anaerobic metabolism, generating adenosine triphosphate (ATP) at relatively low rates, and at the unsustainable cost of acidosis induced by unopposed ATP hydrolysis and lactic acid accumulation. ‘‘Oxygen debt’’ is accompanied by an excessive production of lactic acid, which, in the absence of oxygen, is a metabolic end product. Restoration of DO2 before irreversible tissue death repays this oxygen debt, resulting in transient increase in VO2 as DO2 is increased (producing an apparent supply-dependent increase in oxygen uptake), lactic acidosis is cleared, and organ dysfunction is reversed. In case of prolonged hypoxia irreversible cell damage will not be corrected with an increased DO2 and cellular death will occur.
 
This model tries to reflect DO2-VO2 relation, influenced by a number of parameters which determine DO2 - VO2 or both (e.g. CO, Hb, SaO2, SVO2, etc.). The “mathematical core” of the model is represented by the Lotka-Volterra Equations, a pair of first order, non-linear, differential equations commonly used to describe the dynamics of biological systems in which two species interact (i.e. pray and predator populations):
 
dX/dt = αX - βXY (1)
dY/dt = δXY - γY (2) 

In this model oxygen acts as “pray” and cellular metabolic requirements as “predator/predation” as follows:
 
X - is the number of prey (in this model, DO2) and equation (1) deals with oxygen delivery aspects 

Y - is the number of predator (in this model, VO2) and equation (2) focuses on oxygen consumption 

dX/dt and dY/dt - represent the growth rates of the two entities/phenomena over time; 
t - represents time; 

α, β, γ, δ - are positive real parameters describing the interaction of the two entities/phenomena.
 
αX - represents oxygenation of blood while passing through lung (an “O2 in-flow”, which is added to DO2 stock) and the rate of predation (i.e. O2 uptake) upon the prey is assumed to be proportional to the rate at which the predators and the prey meet (in the actual model this is ‘O2 outflow", the flow which is subtracted from the DO2 stock, and represents the oxygen diffused from the tissue capillaries); this is represented by βXY, where β is denoted as DE (diffusion efficiency).
 
δXY - represents the growth of the predator population and in this model it is the amount of oxygen made available after diffusion from capillaries into the tissue and it is equivalent to βXY or (DO2 * VO2 * DE)
 
γY - represents the loss rate of the predator; in this model it is equvalent to tissue metabolic requirements represented by O2 actually consumed by cells (i.e “O2-utlization” flow calculated as VO2 * O2-UR (Utilization-Rate), not to be confounded with O2 Extraction Ratio).
 
Each flow is calculated in terms of the variables, and stocks that are linked to it. 
As the first step in building this model there were identified “Physiologic conditions” with which equilibrium occurs in the model when neither of the population levels is changing, i.e. when both of the derivatives are equal to 0:
 
X ( α - β ) = 0
- Y ( γY - δX ) = 0 

and Y = α / β ; X = γ / δ or VO2 = (SaO2 - SvO2)/ DE; DO2 = O2-UR / DE , excluding the solution when DO2=VO2=0
 
As a solution was calculated a steady-state with following parameters (CI = 3,5 L/min/m2, SaO2 = 98%, SvO2 = 77%, O2-UR = 0.977, DE = 0.00152). These variables values serve as setting parameters for “Normal” scenario. 


## HOW TO USE IT

Press the buttons: 

(1) Setup: creates basic conditions for the model to run (i.e. erases data from previous runs, sets up the parameters for the selected scenario, etc.). 

(2) Go: starts running the model under selected scenario, performing calculations every time-step showing results of calculations on monitors and plots.
 
Activating/Pressing the above buttons will run the model with initial settings (i.e. “Normal” scenario) 

(3) The chooser is for selecting one of the scenarios out of a list with 7 items: Normal, Exercises without correction, Exercises with correction, Cardiogenic shock without/ or with correction, Hemorrhagic Shock without/ or with correction. The scenario should be selected before pressing ‘Setup’ and ‘Go’ buttons.
 
(4): The plot shows the dynamics of DO2, VO2 and DO2-VO2 difference at any particular time-step during the model run. 

(5), (6), (7), (8), (9) monitors show the values of a number of model outputs and some parameters (i.e. DO2, VO2, DO2-VO2 difference, O2 Extraction Ratio and Cardiac Index) at any particular time-step during the model run. 

The sliders below allow to change some of the equations parameters or variables that influence these parameters: (10) - SaO2, (11) - SvO2, (12) - Hemoglobin, (13) - Cardiac Output (Index), (14) - O2-DE (Diffusion Efficiency), (15) - O2-UR (Utilization Rate). With every of the selected scenario the sliders will be automatically adjusted according to the respective scenario settings. It is possible to adjust the sliders, except the ones for CO and Hb, during runs of the model: 


## THINGS TO NOTICE

At the tissue level oxygen diffuses over relatively short distances from arterioles and capillaries in all directions based on the local PO2 gradient. Oxygen diffusion is limited by oxygen solubility (k), oxygen diffusivity (D), and the PO2 gradient (dPO2/dr). The PO2 gradient drives the net movement of oxygen from a region of high PO2 to a region of low PO2. The oxygen diffusion distance is the distance from the Hb in red blood cells to the mitochondria. The critical oxygen diffusion distance, which is the maximum distance that mitochondria can be away from an oxygen source without impaired function, is determined by these oxygen diffusion parameters and by capillary PO2 and tissue oxygen consumption. 

The intercapillary distance may be increased under hypoxic conditions, particularly ‘‘hypoxic’’ hypoxia (low arterial PO2) and tissue edema (increased vascular permeability or excessive ﬂuid administration). Hence, in the microcirculation, it may be PO2 rather than DO2 (i.e., diffusion rather than convection) that is vital for local tissue oxygenation. Avoiding tissue edema by avoiding excessive ﬂuid loading and early treatment of congestion and arterial hypoxemia may improve tissue/cellular oxygenation. 
In this model the “O2 Diffusion Efficiency” (O2-DE) parameter is a ‘lump variable’ denoting the ‘diffusivity’ issue.
 
All scenarios in the model (except “Normal”) are present in two versions: (1) - without correction and (2) - with" correction. The first version represents a hypothetical situation when a more or less ‘sudden’ change happens in a normally functioning system (e.g. a drop in cardiac output in Cardiogenic shock after a massive myocardial infarction, or an increase in CO with exercises, or a drop in CO and hemoglobin level in Hemorrhagic shock) and the body did not react yet to these changes (denoted by normal values of other parameters (SvO2, O2-DE, O2-UR, etc.).
 
The version with correction includes some changes of model parameters in order to improve the system performance, in terms of DO2 and VO2 ‘physiologic normality’. (e.g. by adjusting SvO2 (decreased in shock states and with exercises); partially restoring CO by the shift of fluid from interstitial space to vascular space in hemorrhagic shock; increasing O2-DE in shock states, or decreasing it in case of exercises).
 
Running different scenarios one can note that this ‘correction’ seems to be efficient in case of exercises, when DO2 stability at higher than ‘resting’ values is achieved accompanied by a stable VO2 values (also higher than in ,resting’ state) with a resulting O2-ER in a normal range, between 20 and 30 percent.
 
In shock states this is not so efficient and although as a result of ‘correction’ the DO2 and VO2 values move toward normal there persist periods of low DO2 what request emergency treatment intervention (e.g. guided volume replacement, RBC transfusion, CO management, etc.).
 
Although the model captures important aspects of DO2-VO2 system it is far from “physiologic reality” at least in terms of DO2 - VO2 dynamics patterns in a particular pathology (e.g. shock) where there are probably less evident periods of ‘negative’ DO2, better illustrated by yellow-color bar plot (i.e. DO2-VO2 Difference). This aspect would be an objective for future refinement of the actual model.
 
O2-DE seems to be a key parameter in this model. And although not much can be done to manipulate O2 ,diffusivity’ at the moment, there might be an unexplored potential for modeling and elaboration of treatment strategies. 


## THINGS TO TRY

After choosing a scenario and pressing the setup button one will see the parameters values settings for the respective scenario on sliders. During the scenario run one can change most of these values and see the resulting effect on main model outputs. It is recommended to pay particular attention to the effect of O2-DE-slider adjustments.
 
Try to observe the sensitivity of the main model outputs (i.e. DO2, VO2 and their ratio) on adjusting O2-DE. 

Try to find the value of the O2-DE which provides the greatest stability of the model in terms of DO2, VO2 and their ratio. For this try to adjust O2-DE after selecting a certain scenario (e.g. “Cardiogenic Shock with correction”) and running this scenario. Do the same but adjust O2-DE but before pressing “Go” button. What is the difference and how it can be explained? 


## EXTENDING THE MODEL

Possible directions for model improvement/refinement and extension would be: 
•	adding new variables for “disaggregation” of ‘diffusivity parameter’ 
•	using a more complex system of equations in order to make the model more ‘physiologically sound’ 
•	extending the model by adding “treatment” options 


## NETLOGO FEATURES

This model uses the System Dynamics Modeler to simulate the Lotka-Volterra equations. Setting of the parameters specific for a certain scenario  is based on the cod in the main code tab. 

## RELATED MODELS

•	Wolf Sheep Predation (System Dynamics) Model, 
•	Wolf Sheep Predation (Docked Hybrid) Model, 
•	Tabonuco Yagrumo Model, all three present in NetLogo model library 

## CREDITS AND REFERENCES

This simple abstract model was developed by Victor Iapascurta, MD. At time of development he was in the Department of Anesthesia and Intensive Care at University of Medicine and Pharmacy in Chisinau, Moldova / ICU at City Emergency Hospital in Chisinau. Please email any questions or comments to viapascurta@yahoo.com 

The model was created in NetLogo 6.0.2, Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL. for CEEA (Committee for European Education in Anaesthesiology) Courses, Chisinau, Moldova, February 7-9, 2018 where the author of the model delivered “Mathematical modeling and computer simulation of biological processes: respiratory system” course. 

Re. concerning medical aspects: 
•	H.S.Lim, Oxygen delivery in cardiogenic shock, Clin. Cardiol.39,8,477–483(2016) Published online in Wiley Online Library (wileyonlinelibrary.com) doi:10.1002/clc.22564 
•	G. Gutierrez et al., Clinical review: Hemorrhagic shock, Critical Care 2004, 8:373-381, doi:10.1186/cc2851) 
 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          