breed [Synoviums Synovium]
breed [Auto-Th1s Auto-Th1]
breed [Inflammations Inflammation]
breed [Tregs Treg]
breed [Autoantibodies Autoantibody]

to setup
  clear-all
  setup-patches
  set-default-shape Inflammations "square" ; inflammation is represented by red squares
  set-default-shape Auto-Th1s "monster" ; autoreactive Th1s (Auto-Th1s) are represented by grey monsters
  set-default-shape Tregs "circle" ; Tregs are represented by green circles
  set-default-shape Autoantibodies "y" ; autoantobodies are represented by a Y
   create-Inflammations 15 ; create the Inflammation, then initialize their variables
  [
    set color white
    set size 0
    setxy random-xcor random-ycor
  ]
  create-Tregs 15 ; create the Tregs, then initialize their variables
  [
    set color green
    set size 1.2
    setxy random-xcor random-ycor
  ]
  create-Auto-Th1s 35 ; create the Auto-Th1s, then initialize their variables
  [
    set color red
    set size 1.5
    setxy random-xcor random-ycor
  ]
  create-Autoantibodies 35 ; create the Autoantibodies, then initialize their variables
  [
    set color black
    set size 2
    setxy random-xcor random-ycor
  ]
  draw-Synoviums ; create the yellow Synovium that is targeted by inflammation
  reset-ticks
end


to setup-patches
  ask patches [ set pcolor pink + 4.5 ] ; set background to light pink
end

to go
  ask Auto-Th1s ; allow Auto-Th1s to move around
  [ wander
bind-Auto-Th1s ; Autoreactive cells cause Synovium inflammation
  ]
  ask Tregs ; allow T-regs to move around
  [ wander
  ]
  ask Autoantibodies ; allow Autoantibodies to move around
  [ wander
  ]
  remove-Auto-Th1s ; T-regs remove Auto-Th1s
  remove-Autoantibodies ; T-regs remove Autoantibodies
    tick
end

to remove-Auto-Th1s ; Green T-regs remove monsters and inflammation subsides
  ask turtles with [color = green]
  [
    ask turtles-here [
      if color = red  [
        if ( random 100 < Treg-effectiveness) [
          die
        ]
      ]
    ]
  ]
end

to remove-Autoantibodies ; Green T-regs remove autoantibodies and inflammation subsides
  ask turtles with [color = green]
  [
    ask turtles-here [
      if color = black  [
        if ( random 100 < Treg-effectiveness) [
          die
        ]
      ]
    ]
  ]
end

to bind-Auto-Th1s ; formation of inflammation
  ask Auto-Th1s with [pycor = (min-pycor) and pxcor <= max-pxcor ][
    hatch 1 [
     set breed Inflammations
     set shape "square"
     set size 1.3
     set color red
  ]]
end

to wander ; T-regs, Auto-Th1s, and Autoantbodies wander
  rt random-float 60 - random-float 60
  fd 1
end

to draw-Synoviums ; creation of Synovium
    ask patches with [pycor = (min-pycor) and pxcor <= max-pxcor ][
    sprout 1 [
     set breed Synoviums
     set shape "square"
     set size 10
     set color yellow + 2.5
    ]
  ]

     ask patches with [pycor = (min-pycor) and pxcor = max-pxcor ][
     sprout 1 [
      set breed Synoviums
      set shape "square"
      set size 10
     set color yellow + 2.5
    ]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
392
57
913
579
-1
-1
15.55
1
10
1
1
1
0
1
0
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
64
10
163
50
To Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
178
10
259
50
to go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
44
56
294
89
Treg-effectiveness
Treg-effectiveness
0
100
85.0
1
1
NIL
HORIZONTAL

PLOT
7
94
366
378
Treg-effectiveness
Time
# of autoreactive cells
0.0
5.0
0.0
5.0
true
true
"" ""
PENS
"Auto-Th1s" 1.0 0 -5987164 true "" "plot count Auto-Th1s"
"Autoantibodies" 1.0 0 -16449023 true "" "plot count autoantibodies"

PLOT
9
390
366
551
Inflammation 
Time
Inflammation
0.0
5.0
0.0
5.0
true
true
"" ""
PENS
"Inflammation" 1.0 0 -2674135 true "" "plot count inflammations"

@#$#@#$#@
## WHAT IS IT?

This model demonstrates how T-regulatory (Treg) effectiveness correlates with inflammation in Rheumatoid Arthritis (RA). 

## LEGEND
"Y" cells = autoantibodies
Grey monsters = autoreactive Th1 cells
Green cells = T-regulatory cells 
Red squares = inflammation 
Yellow = the synovium  

## HOW IT WORKS

Rheumatoid Arthritis is an autoimmune disease. Autoimmunity occurs when the body is no longer able to differentiate between forgein invaders, such as viruses and pathogenic bacteria, from the body's own cells and tissues. This confusion causes the immune system to mistakenly attack the body's own cells and tissues. Autoantibodies and autoreactive T cells are two known contributing factors to the body attacking itself. In RA, autoantibodies and autoreactive T cells cause inflammation in the tissues that surround the joints (the synovium). The autoantibodies and autoreactive T cells can be suppressed, or deleted, by T-regulatory cells. However, in RA, it is known that the effectiveness of these T-regulatory cells can vary. Low T-regulatory effectiveness leads to a high population of autoantibodies, a high population of autoreactive T cells, and elevated inflammation - all playing a role in the progression of Rheumatoid Arthritis. Whereas, a higher T-regulatory effectiveness will enforce a lower population of autoantibodies and autoreactive T cells, in turn, showing decreased levels of inflammation. 
 
Adjust the Treg-effectiveness slider to compare levels of inflammation, autoantibodies, and autoreactive T cells in different Treg effective enviroments.   

## HOW TO USE IT

SETUP: Clears the world and displays autoreactive T cells, autoantibodies, and T-regulatory cells in the presence of a synovium lining a joint within the body. 

GO: Runs the simulation. 

TREG-EFFECTIVENESS SLIDER: The slider displays the effectiveness of Tregs and how successful they are in deleting autoantibodies and autoreactive T cells. A high value represents an efficient Treg population and a lower value represents a less effective Treg population. The effectiveness of the Treg population has an inverse relationship with the amount of inflammation present within the synovium, as well as, the amount of autoantibodies and autoreactive T cells.  

TREG-EFFECTIVENESS PLOT: Plots the number of autoantibodies and autoreactive T cells against time.

INFLAMMATION PLOT: Plots the amount of inflammation against time.

## THINGS TO NOTICE

A large population of autoantibodies and autoreactive T cells, as well as, low Treg-effectiveness will display elevated levels of inflammation. The inflammation decreases as the number of autoantibodies and autoreactive T cells decreases. 

## THINGS TO TRY

Increasing the Treg-effectiveness slider will create a more efficient Treg population. Decreasing the Treg slider will create a dysfunctional Treg population, leading to either a slower deletion or no deletion of autoantibodies and autoreactive T cells when the Treg-effectiveness slider is at 0. This, in turn, will cause inflammation and play a role in the progression of Rheumatoid Arthritis.

## EXTENDING THE MODEL

To create a more realistic Rhemuatoid Arthritis enviroment, try incorporating autoreactive effector B and T cells, as well as, adding other anti-inflammatory regulators, such as the cytokines TGFb and IL-10. Autoreactive effector B and T cells will represent proliferating autoreactive B and T cells that promote inflammation. TGFB and IL-10 will play a similar role to T-regulatory cells, where they will assist in depleting inflammation.  

## NETLOGO FEATURES

The "Tools-->Turtle Shapes Editor-->Import from Library" function allows you to edit the shapes of the turtles within the model

## RELATED MODELS

New Villi Food Model:
http://blog.modelingcommons.org/browse/one_model/5394#model_tabs_browse_info

Adaptive Immunity Model:
http://modelingcommons.org/browse/one_model/5691#model_tabs_browse_info

## CREDITS AND REFERENCES

Gift, S. and J.A. Klemens. (2017). Netlogo Adaptive Immunity Model 1.0. https://github.com/klemensj/Immune.

Wilensky, U. (2006). NetLogo Connected Chemistry 8 Gas Particle Sandbox model. http://ccl.northwestern.edu/netlogo/models/ConnectedChemistry8GasParticleSandbox. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fire
false
0
Polygon -7500403 true true 151 286 134 282 103 282 59 248 40 210 32 157 37 108 68 146 71 109 83 72 111 27 127 55 148 11 167 41 180 112 195 57 217 91 226 126 227 203 256 156 256 201 238 263 213 278 183 281
Polygon -955883 true false 126 284 91 251 85 212 91 168 103 132 118 153 125 181 135 141 151 96 185 161 195 203 193 253 164 286
Polygon -2674135 true false 155 284 172 268 172 243 162 224 148 201 130 233 131 260 135 282

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

monster
true
1
Polygon -7500403 true false 75 150 90 195 210 195 225 150 255 120 255 45 180 0 120 0 45 45 45 120
Circle -16777216 true false 165 60 60
Circle -16777216 true false 75 60 60
Polygon -7500403 true false 225 150 285 195 285 285 255 300 255 210 180 165
Polygon -7500403 true false 75 150 15 195 15 285 45 300 45 210 120 165
Polygon -7500403 true false 210 210 225 285 195 285 165 165
Polygon -7500403 true false 90 210 75 285 105 285 135 165
Rectangle -7500403 true false 135 165 165 270

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

y
true
0
Line -7500403 true 150 150 105 90
Line -7500403 true 150 150 195 90
Line -7500403 true 150 150 150 210
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
