globals
[
  girl-nontwin      ; population of PINK turtles i.e girl NON TWIN
  boy-nontwin       ; population of BLUE turtles i.e boy NON TWIN

  boy-twin          ; population of MAGENTA turtles i.e boy TWIN
  girl-twin         ; population of YELLOW turtles i.e girl NON TWIN
  dead-count

  boy-nontwin-turt        ; percentage of turtles for this agent
  girl-nontwin-turt       ; percentage of turtles for this agent
  boy-twin-turt           ; percentage of turtles for this agent
  girl-twin-turt          ; percentage of turtles for this agent

  percentage-of-twin      ; slider percentage of twins chance
  birth-tick
]

turtles-own
[
  fertility            ; the whole number part of fertility
  fertility-remainder  ; the fractional part (after the decimal point)
  singleton?           ; TRUE/FALSE if singleton or not
  age                  ; agent age default 0
]

to setup
  set toggle-death? true  ; turn option for death ON as default
  clear-output            ; clear output function
  setup-experiment        ; run the to method called 'setup-experiment'
end

to setup-experiment
  clear-globals
  clear-patches
  clear-turtles
  clear-all-plots
  clear-ticks

  if CHOOSE-CREATION = "CREATE TURTLES BY PERCENTAGE" [create]            ; option to create turtles by a percentage
  if CHOOSE-CREATION = "CREATE TURTLES BY COMPUTER GENERATION" [create2]  ; option to create turtles by generation
  if CHOOSE-CREATION = "CREATE TURTLES BY EQUAL AMOUNT" [create3]         ; option to create turtles by equal amount
  set percentage-of-twin  precision (100 - percentage-of-singleton) 4     ; set percentage of twin from singleton difference

  reset-ticks
end

to create
  create-turtles population
  [
    setxy random-xcor random-ycor                           ; randomize turtle locations
    set singleton? false                                    ; singleton set as default false
    set color pink                                          ; set default color to pink
    set size 3                                              ; default size 3
    set shape "person"                                      ; default shape as person
  ]

    let %singleton percentage-of-singleton                  ; percentage of singletons
    let %twin 100 - percentage-of-singleton                 ; percentage of twins = singletons - 100
    let n count turtles                                     ; number of turtles on output

    let singleTurtles round(((%singleton / 100) * n))       ; find the whole number of singletons as %
    let multiTurtles n - singleTurtles                      ; make the twins the other %

    ask n-of singleTurtles turtles [                        ; asking the percentage of singeltons turtles
      set singleton? true                                   ; setting the singletons to true
  ]

    let halfN round(n / 2)                                  ; setting a variable to half of the current population
    ask n-of halfN turtles [                                ; asking for half of the turtles
      ifelse singleton?                                     ; if singleton then set their colors
      [
        set color blue                                      ; setting the color blue if singleton
      ]
      [
        set color magenta                                   ; else set to magenta
      ]
    ]

    ask turtles with [ color = pink ]                       ; asking turtles who are pink
    [
      if not singleton?                                     ; if pink is not singleton
      [
        set color yellow                                    ; set them to yellow
      ]
    ]
end

to create2


  create-turtles population              ; CITING Uri Wilisky, Simple Birth Rates Netlogo 1997.
  [
    setxy random-xcor random-ycor        ; randomize turtle locations
    let r random 100                     ; make r be random number 0 - 99
    set color red                        ; set default color red
    ifelse (r < boy-nontwin-percentage)  ; if r is less than the percentage slider
      [
        set color blue                   ; make them blue
        set singleton? true              ; set singelton to true
    ]
    [
      ifelse (r >= boy-nontwin-percentage) and (r < girl-nontwin-percentage)       ; if r more than last slider and < nextslider
      [
        set color pink                                                             ; set color to pink
        set singleton? true                                                        ; set singleton to true
      ]
    [
        ifelse (r >= girl-nontwin-percentage) and (r < boy-twin-percentage)        ; if r more than last slider and < nextslider
        [
          set color magenta                                                        ; set color to magenta
          set singleton? false                                                     ; set singelton to false
        ]
        [
          if (r >= boy-twin-percentage) and (r < girl-twin-percentage)             ; if r more than last slider and < nextslider
          [
            set color yellow                                                       ; set color to yellow
            set singleton? false                                                   ; set singelton to false
          ]
        ]
      ]
    ]
    set size 3                            ; set size 3
    set shape "person"                    ; set shape to person
  ]
end

to create3
  create-turtles population
  [
    setxy random-xcor random-ycor                      ; randomize turtle locations

    let n count turtles                                ; set n to be number of turtles i.e. population
    let r random 4                                     ; make r to be random number between 0 and 3

    if r = 0 [set color blue set singleton? true]      ; if r is 0 then make turtle blue and set singleton to true
    if r = 1 [set color pink set singleton? true]      ; if r is 1 then make turtle pink and set singleton to true
    if r = 2 [set color magenta set singleton? false]  ; if r is 2 then make turtle magenta and set singleton to false
    if r = 3 [set color yellow set singleton? false]   ; if r is 2 then make turtle yellow and set singleton to false
    set size 3                                         ; set the size of agent to 3
    set shape "person"                                 ; set the shape of agent to person
  ]
end

to go


  ifelse CHOOSE-BIRTHING = "GIVE BIRTH BY ACTUAL MEANS" [reproduce1] [reproduce2]   ; if dropdown equals "" then do command 1 else 2
  tick                                                                              ; make the ticks go increment

  if ticks >= 90 [stop]                                                            ; if ticks more than or equal to 300 stop simulation
  if toggle-death? [death death-age]                                                ; if switch on do to death methods
  set percentage-of-twin 100 - percentage-of-singleton                              ; set the monitor to be exact twin amount for slider
  ask turtles [wander set age 1 + age]
end

to wander
  rt random-float 30 - random-float 30  ; make agent right turn by random float - random float
  fd 1                                  ; make agent go forward by 3
end

to reproduce1                                     ; CITING Uri Wilisky, Simple Birth Rates Netlogo 1997.

let chosen-col [blue pink]                        ; make list to be two color, no twin colors
let chosen-col-twin [magenta yellow]              ; make list to be two color, twin colors

let rg (range 18 80 1)                            ; make a range between 18 and 80, increament by 1

  if ticks > one-of rg  [                         ; if ticks more than one of the numbers in range

ask turtles with [color = pink]                   ; all turtles with the color pink
  [
    set fertility floor girl-nontwin-fertility    ; from the fertility slider get the whole number
    set fertility-remainder girl-nontwin-fertility - (floor girl-nontwin-fertility)                         ; make a variable to be the remainder of the slider

    if any? turtles with [color = blue or color = magenta] in-radius 0.7                                    ; if any turtles who are blue or magenta in radius of 0.7
    [
      ifelse (random-float 100) < (100 * fertility-remainder)                                               ; ifelse for the fertility remainder to decide how to hatch
        [hatch fertility + 1 [ wander ifelse random 100 < chance-of-twin[set color one-of chosen-col-twin set age 0][set color one-of chosen-col set age 0]]]
      [ hatch fertility      [ wander ifelse random 100 < chance-of-twin[set color one-of chosen-col-twin set age 0][set color one-of chosen-col set age 0]]]
      ifelse any? turtles-here with [color = blue or color = pink] [set singleton? true][set singleton? false]     ; if any turtles at this point with color set their singleton attribute
      ]
    ]

  ask turtles with [color = yellow]
  [
    set fertility floor girl-nontwin-fertility ;floor shows nearest whole number
    set fertility-remainder girl-nontwin-fertility - (floor girl-nontwin-fertility)

    if any? turtles with [color = blue or color = magenta] in-radius 0.7
    [
      ifelse (random-float 100) < (100 * fertility-remainder)
        [hatch fertility + 1  [ wander ifelse random 100 < chance-of-twin[set color one-of chosen-col-twin set age 0][set color one-of chosen-col set age 0]]]
      [ hatch fertility     [ wander ifelse random 100 < chance-of-twin[set color one-of chosen-col-twin set age 0][set color one-of chosen-col set age 0]]]
      ifelse any? turtles-here with [color = blue or color = pink] [set singleton? true][set singleton? false]
      ]
    ]
  ]

end

to reproduce2                                     ; CITING Uri Wilisky, Simple Birth Rates Netlogo 1997.

   ask turtles
  [
    ifelse color = pink or color = yellow
    [
      set fertility floor girl-twin-fertility ;floor shows nearest whole number
      set fertility-remainder girl-twin-fertility - (floor girl-twin-fertility)
    ]
    [
      set fertility floor girl-nontwin-fertility
      set fertility-remainder girl-nontwin-fertility - (floor girl-nontwin-fertility)
    ]
    ifelse (random-float 100) < (100 * fertility-remainder)
      [ hatch fertility + 1 [ wander ]]
    [ hatch fertility     [ wander ]]
  ]

end

to death
  let number-of-turtles count turtles             ; make a variable to be number of turtles
  if number-of-turtles <= population [ stop ]     ; if the number of turtles excedes population stop the simulation

  ask turtles                                     ; ask all turtles
  [
    if random-float 100 < chance-to-die [ die ]   ; if random number less than chance to die then kill agents
    set dead-count dead-count + 1                 ; set the deadcount to increament
  ]
end

to death-age
  ask turtles [                    ; ask all turtles
  if age > age-of-death [ die ]]   ; if age is more than slider age then kill turtles
end

to increment-age
  let age-in-ticks birth-tick - ticks
  if (age-in-ticks > 0) and (age-in-ticks mod 5 = 0) [
    set age (1 + age)
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
5
10
417
423
-1
-1
4.0
1
10
1
1
1
0
1
1
1
-50
50
-50
50
1
1
1
ticks
30.0

SLIDER
430
335
805
368
population
population
100
2000
100.0
1
1
people
HORIZONTAL

BUTTON
430
215
500
248
SETUP
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
505
215
560
248
GO
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
1015
195
1215
228
girl-nontwin-fertility
girl-nontwin-fertility
0.0
10.0
1.7
0.1
1
children
HORIZONTAL

PLOT
430
10
805
210
Populations
Generations
Population
0.0
50.0
0.0
1200.0
true
true
"set-plot-y-range 0 floor (population * 1.2)" ""
PENS
"NonTwinGirl" 1.0 0 -2064490 true "" "set girl-nontwin count turtles with [ color = pink ]\nplot girl-nontwin"
"NonTwinBoy" 1.0 0 -13345367 true "" "set boy-nontwin count turtles with [ color = blue ]\nplot boy-nontwin"
"TwinBoy" 1.0 0 -5825686 true "" "set boy-twin count turtles with [ color = magenta ]\nplot boy-twin"
"TwinGirl" 1.0 0 -1184463 true "" "set girl-twin count turtles with [ color = yellow ]\nplot girl-twin"
"TOTAL" 1.0 0 -10899396 true "" "plot count turtles"

MONITOR
815
120
895
165
NonTwinGirl
girl-nontwin / (count turtles) * 100
3
1
11

MONITOR
905
120
985
165
NonTwinBoy
boy-nontwin / (count turtles) * 100
3
1
11

MONITOR
815
170
895
215
TwinBoy
precision (boy-twin / (count turtles) * 100) 4
17
1
11

MONITOR
905
170
985
215
TwinGirl
precision (girl-twin / (count turtles) * 100) 4
17
1
11

SLIDER
1015
35
1215
68
boy-nontwin-percentage
boy-nontwin-percentage
0
100
49.0
1
1
%
HORIZONTAL

MONITOR
170
430
250
475
NIL
dead-count
17
1
11

SLIDER
1015
230
1215
263
girl-twin-fertility
girl-twin-fertility
0.0
10.0
1.7
0.1
1
children
HORIZONTAL

MONITOR
85
430
165
475
gen-count
ticks
17
1
11

MONITOR
5
430
82
475
turtle-count
count turtles
17
1
11

SWITCH
430
255
605
288
toggle-death?
toggle-death?
0
1
-1000

SLIDER
430
375
805
408
percentage-of-singleton
percentage-of-singleton
0
100
96.72
0.1
1
%
HORIZONTAL

TEXTBOX
1000
20
1240
46
** OTHER CREATE TURTLES METHOD **
12
0.0
1

SLIDER
1015
70
1215
103
girl-nontwin-percentage
girl-nontwin-percentage
0
100
65.0
1
1
%
HORIZONTAL

SLIDER
1015
105
1215
138
boy-twin-percentage
boy-twin-percentage
0
100
81.0
1
1
%
HORIZONTAL

SLIDER
1015
140
1215
173
girl-twin-percentage
girl-twin-percentage
0
100
90.0
1
1
%
HORIZONTAL

CHOOSER
630
220
850
265
CHOOSE-CREATION
CHOOSE-CREATION
"CREATE TURTLES BY PERCENTAGE" "CREATE TURTLES BY COMPUTER GENERATION" "CREATE TURTLES BY EQUAL AMOUNT"
2

CHOOSER
630
280
850
325
CHOOSE-BIRTHING
CHOOSE-BIRTHING
"GIVE BIRTH BY ACTUAL MEANS" "GIVE BIRTH COMPUTER GENERATED"
0

MONITOR
800
370
992
415
NIL
precision (percentage-of-twin) 4
17
1
11

SLIDER
430
290
605
323
chance-to-die
chance-to-die
0.00
100.00
11.08
0.10
1
%
HORIZONTAL

SLIDER
430
415
602
448
chance-of-twin
chance-of-twin
0
100
3.35
0.1
1
chance
HORIZONTAL

BUTTON
565
215
620
248
GO
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
615
415
792
448
age-of-death
age-of-death
0
100
62.0
1.0
1
years old
HORIZONTAL

TEXTBOX
1025
300
1280
446
**READ ME**\nSET ALL SLIDERS TO POSITIONS \nAND DROPDOWN OPTIONS BEFORE SIMULATING
20
0.0
1

MONITOR
815
10
892
55
NIL
girl-nontwin
17
1
11

MONITOR
905
10
985
55
NIL
boy-nontwin
17
1
11

MONITOR
815
60
895
105
NIL
girl-twin
17
1
11

MONITOR
905
60
985
105
NIL
boy-twin
17
1
11

TEXTBOX
810
105
1000
123
|---------------------------------------------|
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

Here is a simulation of the birth rates amongt twins. There are multiple populations where agents can move around freely. There are chances of twins being born and even larger chance that a twin wont be born. Here the model can input the twin birth rates from actual live statistics or statistics made by the user.

## HOW TO USE IT

-To use the model you must first select your creation type in the drop down menu.

-Choose the variable statistics you want your agents to reproduce, die or to be created.

-Click SETUP, this allows for the clearing of all outputs and information on screen.

-You must now choose how your agents want to reproduce click from the birthing drop down.

-Before you click GO you have the ability to let the agents die during their simulation.

-Click GO to let the agents simulate.

## Options which can be change 

SLIDER TO CHANCE THE POPULATION OF AGENTS

SLIDER TO CHANGE HOW MANY SINGLETONS AND TWINS ARE POPULATED

SLIDER TO CHANGE THE CHANCE OF HAVING A TWIN

SLIDER TO CHANGE THE CHANCE OF AGENT DEATH

SLIDER TO CHANGE THE MAXIMUM AGE OF AGENT

DROPDOWN FOR WAYS TO GENERATE AGENTS

DROPDOWN FOR WAYS TO REPRODUCE AGENTS


## WHAT TO LOOK OUT FOR

We can model the birth rates for both twin and non twin where we can almost guess generations. However though this model is a chance not a true figure, we can guess what rate twins can be born. Look out for the output graph to see if the rate of twins fluctuates or steady's. Everytime the application simulates the statisitcs will always differ. Look at the slider options to simulate various results.

## CREATOR 

NAME: Daniel Joseph Griffin
STUDENT ID: eeu69a
EMAIL :eeu69a@bangor.ac.uk


-- please note that some of the work was from the help of --

Wilensky, U. (1997). NetLogo Simple Birth Rates model. http://ccl.northwestern.edu/netlogo/models/SimpleBirthRates. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="girl-nontwin-fertility">
      <value value="1.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-twin">
      <value value="3.55"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percentage-of-singleton">
      <value value="96.72"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-to-die">
      <value value="11.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boy-nontwin-percentage">
      <value value="49"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="toggle-death?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="age-of-death">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-twin-fertility">
      <value value="1.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="CHOOSE-CREATION">
      <value value="&quot;CREATE TURTLES BY PERCENTAGE&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-nontwin-percentage">
      <value value="65"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boy-twin-percentage">
      <value value="81"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="CHOOSE-BIRTHING">
      <value value="&quot;GIVE BIRTH BY ACTUAL MEANS&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-twin-percentage">
      <value value="90"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>count turtles</metric>
    <enumeratedValueSet variable="girl-nontwin-fertility">
      <value value="1.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-twin">
      <value value="3.55"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percentage-of-singleton">
      <value value="96.72"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-to-die">
      <value value="11.08"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boy-nontwin-percentage">
      <value value="49"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="population">
      <value value="2000"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="toggle-death?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="age-of-death">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-twin-fertility">
      <value value="1.7"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="CHOOSE-CREATION">
      <value value="&quot;CREATE TURTLES BY PERCENTAGE&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-nontwin-percentage">
      <value value="65"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="boy-twin-percentage">
      <value value="81"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="CHOOSE-BIRTHING">
      <value value="&quot;GIVE BIRTH BY ACTUAL MEANS&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="girl-twin-percentage">
      <value value="90"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
