
breed [investors investor]
breed [public-outreach-specialists public-outreach-specialist]
breed [lowest-opinions lowest-opinion]
breed [low-opinions low-opinion]
breed [lower-opinions lower-opinion]
breed [moderate-opinions moderate-opinion]
breed [higher-opinions higher-opinion]
breed [highest-opinions highest-opinion]

patches-own [
  favorability-level?         ;; indicates level of favorability for cell, -2 for unfavorable, -1 for
                              ;; less favorable, 0 for neutral, 1 for more favorable, 2 for favorable
  favorable-neighbors  ;; counts how many neighboring cells make a favorable match
near-patches
sector  ;; defines the part of the city (1-5)
landuse ;; set's landuse
parcel-size ;; parcel size
impervious-cover
impervious-acreage
ERUs
stormwater-fee
innovation-index
annual-income
annual-fee
annual-max-discount
gallons-runoff-generated
in-lieu-fee
annual-max-credit
BMP-number
BMP-type
BMP-cap-cost
property-value
BMP-footprint
opportunity-cost
OM-BMP-cost
transaction-cost
total-BMP-cost
credit-revenue
payback
constraints-index
wealth-index
pbc
public-outreach-agent-contact
sia-initial
sia-updated
U-initial
U-updated
sia-initial-baseline
sia-initial-income
sia-initial-sector
sia-innovation
green-infrastructure-practiced
acceptance-decision-score
green-infrastructure-decision
implementation-decision-score
impervious-cost
sia-neighboring
sia-plus-east-value
sia-plus-west-value
sia-plus-north-value
sia-plus-south-value
sia-plus-southeast-value
sia-plus-northeast-value
sia-plus-southwest-value
sia-plus-northwest-value
landuse-type
credit-revenue-generated
cluster-number
isolated-adopter
]

to setup
  clear-all
  ask patches with[pxcor < 0 and pycor > 0][set sector 1]
  ask patches with[pxcor > 0 and pycor > 0][set sector 2]
  ask patches with[pxcor < 0 and pycor < 0][set sector 3]
  ask patches with[pxcor > 0 and pycor < 0][set sector 4]
  ask patches with [pxcor = 0 or pycor = 0] [set pcolor 125]
  ask patches with [pxcor > 15] [set pcolor 125]
  ask patches with [pxcor < -15] [set pcolor 125]
  ask patches with [pycor > 12] [set pcolor 125]
  ask patches with [pycor < -12] [set pcolor 125]
  ask patches with [pcolor = 125] [set sector 0]
  ask patch 0 0 [ask patches in-radius 6 [set sector 0]]
  ask patch 0 0 [ask patches in-radius 6 [set pcolor 125]]
  ask patch 0 0 [ask patches in-radius 5 [set sector 5]]
  set muni-demand 0
;  set muni-demand 50000
  set development-demand 0
  set demand-supply-ratio 0
  set indexed-credit-price credit-price
  establish-landuse-patches
  assign-landuse-type
  assign-parcel-size
  assign-impervious-cover
  determine-impervious-acreage
  determine-ERUs
  determine-stormwater-fee
  set-innovation-by-sector
  set-income-by-sector
  assign-landuse-colors
;  sprout-early-adopters
  identify-early-adopters
  determine-annual-stormwater-fee
  determine-annual-max-fee-discount
  determine-gallons-runoff-generated
  determine-in-lieu-fee
  determine-BMP-type
  assign-BMP-type
  determine-captial-cost-of-BMP
  determine-property-values
  estimate-BMP-footprint
  determine-opportunity-cost-of-BMP
  determine-other-BMP-costs
  credit-revenue-potential
  determine-pbc
  determine-payback
  establish-initial-sia-and-uncertainty
  set-property-owner-attributes
  create-outreach-agents
  determine-clusters
  reset-ticks
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;GO ROUTINES;;;;;;;;;;;;;;;;;;;;;;;

to go
  if ticks >= 360 [ stop ]
  relative-algorithm-initial
  relative-algorithm-random
;  neighbors-test
  public-outreach-specialists-move
  determine-clusters
  property-owner-decision-start-point
  determine-muni-demand
  determine-development-demand
  determine-supply-demand-ratio
  determine-indexed-credit-price
  sia-neighboring-plus-setup
  sia-neighboring-plus-add
  sia-neighboring-plus-adjust
  credit-revenue-potential
  determine-payback
  identify-isolated-adopters
;  see-RA-work
;  see-RA-work-turtles
;  see-RA-work-turtles-patches
;  assign-landuse-colors-invested-parcels
  tick
end

to go-RA-work
  if ticks >= 360 [ stop ];
  relative-algorithm-initial
;  relative-algorithm-random
;  neighbors-test
  public-outreach-specialists-move
  property-owner-decision-start-point
  determine-muni-demand
  determine-development-demand
  determine-supply-demand-ratio
  determine-indexed-credit-price
  sia-neighboring-plus-setup
  sia-neighboring-plus-add
  sia-neighboring-plus-adjust
  credit-revenue-potential
  determine-payback
  see-RA-work
;  see-RA-work-turtles
;  see-RA-work-turtles-patches
;  assign-landuse-colors-invested-parcels
  tick
end

to go-RA
  relative-algorithm-initial
  relative-algorithm-random
  tick
end


to go-decide
  property-owner-decision-start-point
  tick
end

;to go-neighbors
;  neighbors-test
;  tick
;end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



to highlight-sectors
ask patches [
  if sector = 0 [set pcolor 125]
  if sector = 1 [set pcolor 134]
  if sector = 2 [set pcolor 75]
  if sector = 3 [set pcolor 15]
  if sector = 4 [set pcolor 95]
  if sector = 5 [set pcolor 45]
   ]
  end

to establish-landuse-patches
  repeat 10 [
;Establish Sector 5 - From Ward 2
let sector-5-LDR (0.062 * count patches with [sector = 5])
ask n-of sector-5-LDR patches with [sector = 5] [set landuse "LDR"]
let sector-5-LMDR (0.227 * count patches with [sector = 5])
ask n-of sector-5-LMDR patches with [sector = 5] [set landuse "LMDR"]
let sector-5-MDR (0.075 * count patches with [sector = 5])
ask n-of sector-5-MDR patches with [sector = 5] [set landuse "MDR"]
let sector-5-HDR (0.051 * count patches with [sector = 5])
ask n-of sector-5-HDR patches with [sector = 5] [set landuse "HDR"]
let sector-5-MU (0.032 * count patches with [sector = 5])
ask n-of sector-5-MU patches with [sector = 5] [set landuse "MU"]
let sector-5-I (0.003 * count patches with [sector = 5])
ask n-of sector-5-I patches with [sector = 5] [set landuse "I"]
let sector-5-O (0.205 * count patches with [sector = 5])
ask n-of sector-5-O patches with [sector = 5] [set landuse "O"]
let sector-5-C (0.140 * count patches with [sector = 5])
ask n-of sector-5-C patches with [sector = 5] [set landuse "C"]
let sector-5-S (0.203 * count patches with [sector = 5])
ask n-of sector-5-S patches with [sector = 5] [set landuse "S"]


;Establish Sector 4 - From Ward 8
let sector-4-LDR (0.148 * count patches with [sector = 4])
ask n-of sector-4-LDR patches with [sector = 4] [set landuse "LDR"]
let sector-4-LMDR (0.258 * count patches with [sector = 4])
ask n-of sector-4-LMDR patches with [sector = 4] [set landuse "LMDR"]
let sector-4-MDR (0.385 * count patches with [sector = 4])
ask n-of sector-4-MDR patches with [sector = 4] [set landuse "MDR"]
let sector-4-HDR (0.030 * count patches with [sector = 4])
ask n-of sector-4-HDR patches with [sector = 4] [set landuse "HDR"]
let sector-4-MU (0.017 * count patches with [sector = 4])
ask n-of sector-4-MU patches with [sector = 4] [set landuse "MU"]
let sector-4-I (0.004 * count patches with [sector = 4])
ask n-of sector-4-I patches with [sector = 4] [set landuse "I"]
let sector-4-O (0.008 * count patches with [sector = 4])
ask n-of sector-4-O patches with [sector = 4] [set landuse "O"]
let sector-4-C (0.077 * count patches with [sector = 4])
ask n-of sector-4-C patches with [sector = 4] [set landuse "C"]
let sector-4-S (0.072 * count patches with [sector = 4])
ask n-of sector-4-S patches with [sector = 4] [set landuse "S"]


;Establish Sector 1 - From Ward 3
let sector-1-LDR (0.598 * count patches with [sector = 1])
ask n-of sector-1-LDR patches with [sector = 1] [set landuse "LDR"]
let sector-1-LMDR (0.084 * count patches with [sector = 1])
ask n-of sector-1-LMDR patches with [sector = 1] [set landuse "LMDR"]
let sector-1-MDR (0.056 * count patches with [sector = 1])
ask n-of sector-1-MDR patches with [sector = 1] [set landuse "MDR"]
let sector-1-HDR (0.033 * count patches with [sector = 1])
ask n-of sector-1-HDR patches with [sector = 1] [set landuse "HDR"]
let sector-1-MU (0.001 * count patches with [sector = 1])
ask n-of sector-1-MU patches with [sector = 1] [set landuse "MU"]
let sector-1-I (0.000 * count patches with [sector = 1])
ask n-of sector-1-I patches with [sector = 1] [set landuse "I"]
let sector-1-O (0.013 * count patches with [sector = 1])
ask n-of sector-1-O patches with [sector = 1] [set landuse "O"]
let sector-1-C (0.041 * count patches with [sector = 1])
ask n-of sector-1-C patches with [sector = 1] [set landuse "C"]
let sector-1-S (0.173 * count patches with [sector = 1])
ask n-of sector-1-S patches with [sector = 1] [set landuse "S"]

;Establish Sector 2 - From Ward 5
let sector-2-LDR (0.243 * count patches with [sector = 2])
ask n-of sector-2-LDR patches with [sector = 2] [set landuse "LDR"]
let sector-2-LMDR (0.279 * count patches with [sector = 2])
ask n-of sector-2-LMDR patches with [sector = 2] [set landuse "LMDR"]
let sector-2-MDR (0.035 * count patches with [sector = 2])
ask n-of sector-2-MDR patches with [sector = 2] [set landuse "MDR"]
let sector-2-HDR (0.009 * count patches with [sector = 2])
ask n-of sector-2-HDR patches with [sector = 2] [set landuse "HDR"]
let sector-2-MU (0.000 * count patches with [sector = 2])
ask n-of sector-2-MU patches with [sector = 2] [set landuse "MU"]
let sector-2-I (0.096 * count patches with [sector = 2])
ask n-of sector-2-I patches with [sector = 2] [set landuse "I"]
let sector-2-O (0.006 * count patches with [sector = 2])
ask n-of sector-2-O patches with [sector = 2] [set landuse "O"]
let sector-2-C (0.120 * count patches with [sector = 2])
ask n-of sector-2-C patches with [sector = 2] [set landuse "C"]
let sector-2-S (0.177 * count patches with [sector = 2])
ask n-of sector-2-S patches with [sector = 2] [set landuse "S"]

;Establish Sector 3 - From Ward 6
let sector-3-LDR (0.007 * count patches with [sector = 3])
ask n-of sector-3-LDR patches with [sector = 3] [set landuse "LDR"]
let sector-3-LMDR (0.447 * count patches with [sector = 3])
ask n-of sector-3-LMDR patches with [sector = 3] [set landuse "LMDR"]
let sector-3-MDR (0.127 * count patches with [sector = 3])
ask n-of sector-3-MDR patches with [sector = 3] [set landuse "MDR"]
let sector-3-HDR (0.042 * count patches with [sector = 3])
ask n-of sector-3-HDR patches with [sector = 3] [set landuse "HDR"]
let sector-3-MU (0.013 * count patches with [sector = 3])
ask n-of sector-3-MU patches with [sector = 3] [set landuse "MU"]
let sector-3-I (0.038 * count patches with [sector = 3])
ask n-of sector-3-I patches with [sector = 3] [set landuse "I"]
let sector-3-O (0.070 * count patches with [sector = 3])
ask n-of sector-3-O patches with [sector = 3] [set landuse "O"]
let sector-3-C (0.202 * count patches with [sector = 3])
ask n-of sector-3-C patches with [sector = 3] [set landuse "C"]
let sector-3-S (0.054 * count patches with [sector = 3])
ask n-of sector-3-S patches with [sector = 3] [set landuse "S"]
  ]
end

;assign parcel size by land use
to assign-parcel-size
ask patches [
  if landuse = "LDR" [set parcel-size exp (random-normal -1.19 1.25)]
  if landuse = "LMDR" [set parcel-size exp (random-normal -1.51 1.21)]
  if landuse = "MDR" [set parcel-size exp (random-normal -1.21 1.38)]
  if landuse = "HDR" [set parcel-size exp (random-normal -0.60 1.07)]
  if landuse = "MU" [set parcel-size exp (random-normal -0.27 1.34)]
  if landuse = "I" [set parcel-size exp (random-normal -0.59 1.22)]
  if landuse = "O" [set parcel-size exp (random-normal -1.39 1.15)]
  if landuse = "C" [set parcel-size exp (random-normal -2.11 1.54)]
  if landuse = "S" [set parcel-size exp (random-normal -0.81 1.68)]
  if parcel-size <= 0 [set parcel-size 0.001]
  set parcel-size precision parcel-size 2
  ]
  end

;assign parcel size by land use
to assign-impervious-cover
ask patches [
;  if landuse = "LDR" [set impervious-cover random-normal 21.2 3.49]
;  if landuse = "LMDR" [set impervious-cover random-normal 27.8 2.88]
;  if landuse = "MDR" [set impervious-cover random-normal 32.6 5.06]
;  if landuse = "HDR" [set impervious-cover random-normal 44.4 8.49]
;  if landuse = "MU" [set impervious-cover random-normal 44.4 8.49]
;  if landuse = "I" [set impervious-cover random-normal 72.2 9.59]
;  if landuse = "O" [set impervious-cover random-normal 72.2 9.59]
;  if landuse = "C" [set impervious-cover random-normal 72.2 9.59]
;  if landuse = "S" [set impervious-cover random-normal 34.4 18.9]
  if landuse = "LDR" [set impervious-cover random-normal 21.2 7.21]
  if landuse = "LMDR" [set impervious-cover random-normal 27.8 9.45]
  if landuse = "MDR" [set impervious-cover random-normal 32.6 11.08]
  if landuse = "HDR" [set impervious-cover random-normal 44.4 15.10]
  if landuse = "MU" [set impervious-cover random-normal 80 27.2]
  if landuse = "I" [set impervious-cover random-normal 72.2 24.55]
  if landuse = "O" [set impervious-cover random-normal 72.2 24.55]
  if landuse = "C" [set impervious-cover random-normal 72.2 24.55]
  if landuse = "S" [set impervious-cover random-normal 34.4 11.70]
  if impervious-cover <= 0 [set impervious-cover 0.01]
  set impervious-cover precision impervious-cover 2
  ]
  end

to determine-impervious-acreage
  ask patches [
    set impervious-acreage impervious-cover / 100 * parcel-size
    set impervious-acreage precision impervious-acreage 2
  ]
end

;determine ERUs
to determine-ERUs
  ask patches [
    if landuse = "S" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "I" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "O" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "C" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "HDR" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "MU" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "MDR" [set ERUs impervious-cover / 100 * parcel-size * 43560 / 1000]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 < 600 [set ERUs 0.6]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 600 and parcel-size * impervious-cover / 100 < 2000 [set ERUs 1]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 2000 and parcel-size * impervious-cover / 100 < 3000 [set ERUs 2.4]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 3000 and parcel-size * impervious-cover / 100 < 7000 [set ERUs 3.8]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 7000 and parcel-size * impervious-cover / 100 < 11000 [set ERUs 8.6]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 11000 [set ERUs 13.5]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 < 600 [set ERUs 0.6]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 600 and parcel-size * impervious-cover / 100 < 2000 [set ERUs 1]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 2000 and parcel-size * impervious-cover / 100 < 3000 [set ERUs 2.4]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 3000 and parcel-size * impervious-cover / 100 < 7000 [set ERUs 3.8]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 7000 and parcel-size * impervious-cover / 100 < 11000 [set ERUs 8.6]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 11000 [set ERUs 13.5]
    set ERUs precision ERUs 1
  ]
  end

;determine monthly stormwater fee
to determine-stormwater-fee
  ask patches [
    if landuse = "S" [set stormwater-fee ERUrate * ERUs]
    if landuse = "I" [set stormwater-fee ERUrate * ERUs]
    if landuse = "O" [set stormwater-fee ERUrate * ERUs]
    if landuse = "C" [set stormwater-fee ERUrate * ERUs]
    if landuse = "HDR" [set stormwater-fee ERUrate * ERUs]
    if landuse = "MU" [set stormwater-fee ERUrate * ERUs]
    if landuse = "MDR" [set stormwater-fee ERUrate * ERUs]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 < 600 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 600 and parcel-size * impervious-cover / 100 < 2000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 2000 and parcel-size * impervious-cover / 100 < 3000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 3000 and parcel-size * impervious-cover / 100 < 7000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 7000 and parcel-size * impervious-cover / 100 < 11000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LMDR" and parcel-size * 43560 * impervious-cover / 100 > 11000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 < 600 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 600 and parcel-size * impervious-cover / 100 < 2000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 2000 and parcel-size * impervious-cover / 100 < 3000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 3000 and parcel-size * impervious-cover / 100 < 7000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 7000 and parcel-size * impervious-cover / 100 < 11000 [set stormwater-fee ERUs * ERUrate]
    if landuse = "LDR" and parcel-size * 43560 * impervious-cover / 100 > 11000 [set stormwater-fee ERUs * ERUrate]
    set stormwater-fee precision stormwater-fee 2
  ]
  end


to determine-clusters
  ask patches with [pcolor = 55]
   [
  if count neighbors with [ pcolor = 55 ] = 0
  [set cluster-number 0.111]
  if count neighbors with [ pcolor = 55 ] = 1
  [set cluster-number 0.222]
  if count neighbors with [ pcolor = 55 ] = 2
  [set cluster-number 0.333]
  if count neighbors with [ pcolor = 55 ] = 3
  [set cluster-number 0.444]
  if count neighbors with [ pcolor = 55 ] = 4
  [set cluster-number 0.555]
  if count neighbors with [ pcolor = 55 ] = 5
  [set cluster-number 0.666]
  if count neighbors with [ pcolor = 55 ] = 6
  [set cluster-number 0.777]
  if count neighbors with [ pcolor = 55 ] = 7
  [set cluster-number 0.888]
  if count neighbors with [ pcolor = 55 ] = 8
  [set cluster-number 1]
  ]
 end

to determine-annual-stormwater-fee
  ask patches [
        set annual-fee stormwater-fee * 12
    set annual-fee precision annual-fee 2
  ]
  end

to determine-annual-max-fee-discount
  ask patches
  [set annual-max-discount  12 * (rebate-amount * stormwater-fee)]
  ask patches
  [set annual-max-discount precision annual-max-discount 2]
end

to determine-gallons-runoff-generated
  ask patches
;  [set gallons-runoff-generated impervious-cover / 100 * parcel-size * 43560 * 144 * 1.2 * 0.004329 * 0.95]
  [set gallons-runoff-generated impervious-cover / 100 * parcel-size * 43560 * 1.2 / 12 * 7.48 * 0.95]
  ask patches
  [set gallons-runoff-generated precision gallons-runoff-generated 0]
end

to determine-in-lieu-fee
  ask patches [
    set in-lieu-fee 1.2 / 12 * (impervious-cover) / 100 * (parcel-size) * 43560 * 7.48 * 0.95 * 3.50
    set in-lieu-fee precision in-lieu-fee 2
;    set annual-max-credit 2.14 * ERUs * 12
;    set annual-max-credit precision annual-max-credit 2
  ]
  end

to determine-BMP-type
  ask patches[
    if landuse = "I" [set BMP-number random 2]
    if landuse = "O" [set BMP-number random 2]
    if landuse = "C" [set BMP-number random 2]
    if landuse = "HDR" [set BMP-number random 2]
    if landuse = "MU" [set BMP-number random 2]
    if landuse = "LDR" [set BMP-number random 3 + 2]
    if landuse = "LMDR" [set BMP-number random 3 + 2]
    if landuse = "S" [set BMP-number random 3 + 2]
    if landuse = "MDR" [set BMP-number random 1 + 5]
  ]
  end

  ;assign BMP type by BMP number (set above) for DDOE BMP Types 3.2 (green roof), 3.3 (rainwater harvesting),
  ;3.4 (impervious surface disconnection), 3.5 (permeable pavement), 3.6 (bioretention), 3.8 (infiltration/planter),
  ;3.9 (open channels - bioswales)
  to assign-BMP-type
    ask patches
    with [BMP-number = 0] [set BMP-type "Green Roof"]
    ask patches
    with [BMP-number = 1] [set BMP-type "Rainwater Harvesting"]
    ask patches
    with [BMP-number = 2] [set BMP-type "Permeable Pavement"]
    ask patches
    with [BMP-number = 3] [set BMP-type "Bioswale"]
    ask patches
    with [BMP-number = 4] [set BMP-type "Bioretention"]
    ask patches
    with [BMP-number = 5] [set BMP-type "Downspout Disconnection"]
    ask patches
    with [BMP-number = 6] [set BMP-type "Flow-Through Planter"]
  end


;assign costs by BMP type
to determine-captial-cost-of-BMP
  ask patches[
    if landuse-type = "non-residential" and BMP-number = 0 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * greenroofcost-Non-Res]
    if landuse-type = "non-residential" and BMP-number = 1 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * cisterncost-Non-Res]
    if landuse-type = "non-residential" and BMP-number = 2 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * permpavecost-Non-Res]
    if landuse-type = "non-residential" and BMP-number = 3 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * bioswalecost-Non-Res]
    if landuse-type = "non-residential" and BMP-number = 4 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * bioretentioncost-Non-Res]
    if landuse-type = "non-residential" and BMP-number = 5 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * downspoutcost-Non-Res]
    if landuse-type = "non-residential"and BMP-number = 6 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * plantercost-Non-Res]
    if landuse-type = "residential" and BMP-number = 0 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * greenroofcost-Res]
    if landuse-type = "residential" and BMP-number = 1 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * cisterncost-Res]
    if landuse-type = "residential" and BMP-number = 2 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 43560 * 1.0 * permpavecost-Res]
    if landuse-type = "residential" and BMP-number = 3 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * bioswalecost-Res]
    if landuse-type = "residential" and BMP-number = 4 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * bioretentioncost-Res]
    if landuse-type = "residential" and BMP-number = 5 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * downspoutcost-Res]
    if landuse-type = "residential"and BMP-number = 6 [set BMP-cap-cost impervious-cover / 100 * parcel-size * 1.0 * 43560 * plantercost-Res]
    set BMP-cap-cost precision BMP-cap-cost 2
  ]
  end

to determine-property-values
;for LDR
ask patches with [sector = 5 and landuse = "LDR"]
  [set property-value 956.61 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "LDR"]
  [set property-value 738.49 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "LDR"]
  [set property-value 328.05 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "LDR"]
  [set property-value 484.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "LDR"]
  [set property-value 154.97 * parcel-size * 43560]
;for LMDR
ask patches with [sector = 5 and landuse = "LMDR"]
  [set property-value 956.61 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "LMDR"]
  [set property-value 738.49 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "LMDR"]
  [set property-value 328.05 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "LMDR"]
  [set property-value 484.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "LMDR"]
  [set property-value 154.97 * parcel-size * 43560]
;for MDR - assuming 10 units per story, so cost per floor
ask patches with [sector = 5 and landuse = "MDR"]
  [set property-value 956.61 * parcel-size * 43560 * 1]
ask patches with [sector = 1 and landuse = "MDR"]
  [set property-value 738.49 * parcel-size * 43560 * 1]
ask patches with [sector = 2 and landuse = "MDR"]
  [set property-value 328.05 * parcel-size * 43560 * 1]
ask patches with [sector = 3 and landuse = "MDR"]
  [set property-value 484.00 * parcel-size * 43560 * 1]
ask patches with [sector = 4 and landuse = "MDR"]
  [set property-value 154.97 * parcel-size * 43560 * 1]
;for HDR - assuming 10 units per story, so cost per floor
ask patches with [sector = 5 and landuse = "HDR"]
  [set property-value 956.61 * parcel-size * 43560 * 1]
ask patches with [sector = 1 and landuse = "HDR"]
  [set property-value 738.49 * parcel-size * 43560 * 1]
ask patches with [sector = 2 and landuse = "HDR"]
  [set property-value 328.05 * parcel-size * 43560 * 1]
ask patches with [sector = 3 and landuse = "HDR"]
  [set property-value 484.00 * parcel-size * 43560 * 1]
ask patches with [sector = 4 and landuse = "HDR"]
  [set property-value 154.97 * parcel-size * 43560 * 1]
;for MU - assuming 10 units per story, so cost per floor
ask patches with [sector = 5 and landuse = "MU"]
  [set property-value 956.61 * parcel-size * 43560 * 1]
ask patches with [sector = 1 and landuse = "MU"]
  [set property-value 738.49 * parcel-size * 43560 * 1]
ask patches with [sector = 2 and landuse = "MU"]
  [set property-value 328.05 * parcel-size * 43560 * 1]
ask patches with [sector = 3 and landuse = "MU"]
  [set property-value 484.00 * parcel-size * 43560 * 1]
ask patches with [sector = 4 and landuse = "MU"]
  [set property-value 154.97 * parcel-size * 43560 * 1]
;for office
ask patches with [sector = 5 and landuse = "O"]
  [set property-value 395.30 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "O"]
  [set property-value 305.16 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "O"]
  [set property-value 135.56 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "O"]
  [set property-value 200.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "O"]
  [set property-value 64.04 * parcel-size * 43560]
;for institutional - assumed to be same as officce
ask patches with [sector = 5 and landuse = "S"]
  [set property-value 395.30 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "S"]
  [set property-value 305.16 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "S"]
  [set property-value 135.56 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "S"]
  [set property-value 200.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "S"]
  [set property-value 64.04 * parcel-size * 43560]
;for commercial
ask patches with [sector = 5 and landuse = "C"]
  [set property-value 494.12 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "C"]
  [set property-value 381.45 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "C"]
  [set property-value 169.45 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "C"]
  [set property-value 250.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "C"]
  [set property-value 80.05 * parcel-size * 43560]
;for industrial
ask patches with [sector = 5 and landuse = "I"]
  [set property-value 256.94 * parcel-size * 43560]
ask patches with [sector = 1 and landuse = "I"]
  [set property-value 198.35 * parcel-size * 43560]
ask patches with [sector = 2 and landuse = "I"]
  [set property-value 88.11 * parcel-size * 43560]
ask patches with [sector = 3 and landuse = "I"]
  [set property-value 130.00 * parcel-size * 43560]
ask patches with [sector = 4 and landuse = "I"]
  [set property-value 41.62 * parcel-size * 43560]
ask patches
   [set property-value precision property-value 2]
end

;determine appoximate BMP footprint (square feet)
to estimate-BMP-footprint
  ask patches[
    if BMP-number = 0 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 1]
    if BMP-number = 1 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0]
    if BMP-number = 2 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0.2]
    if BMP-number = 3 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0.05]
    if BMP-number = 4 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0.05]
    if BMP-number = 5 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0]
    if BMP-number = 6 [set BMP-footprint impervious-cover / 100 * parcel-size * 43560 * 0.05]
    set BMP-footprint precision BMP-footprint 2
  ]
  end

;determine opportunity costs by BMP type
;to determine-opportunity-cost-of-BMP
;  ask patches[
;    if BMP-number = 0 [set opportunity-cost (BMP-footprint / 435600) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 1 [set opportunity-cost (BMP-footprint / 43560) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 2 [set opportunity-cost (BMP-footprint / 43650) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 3 [set opportunity-cost (BMP-footprint / 43560) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 4 [set opportunity-cost (BMP-footprint / 43560) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 5 [set opportunity-cost (BMP-footprint / 43560) / (parcel-size + 0.001) * property-value]
;    if BMP-number = 6 [set opportunity-cost (BMP-footprint / 43560) / (parcel-size + 0.001) * property-value]
;    set opportunity-cost precision opportunity-cost 2
;  ]
;  end


;determine opportunity costs by BMP type
to determine-opportunity-cost-of-BMP
  ask patches[
    if BMP-number = 0 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 1 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 2 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 3 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 4 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 5 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    if BMP-number = 6 [set opportunity-cost BMP-footprint * 0.00000117 * property-value]
    set opportunity-cost precision opportunity-cost 2
  ]
  end


;determine O&M, transaction and total costs (NEED TO INCLUDE RISK AND OPPORTUNITY COST SOMEHOW)
to determine-other-BMP-costs
  ask patches
  [  if pcolor != 125
    [set OM-BMP-cost BMP-cap-cost * (random (0.05) + 0.05)]
  ]
  ask patches
  [
    if pcolor != 125
  [set total-BMP-cost
    BMP-cap-cost +
    transaction-cost
    + (opportunity-cost * opportunity-cost-level)
;    + OM-BMP-cost
  ]
  ]
  ask patches
  [if pcolor != 125
  [set impervious-cost total-BMP-cost / ( impervious-cover / 100 * (parcel-size + 0.001 ))]]
  ask patches

  [if pcolor != 125
  [set impervious-cost precision impervious-cost 2]]
  ask patches
  [if pcolor != 125
  [set OM-BMP-cost precision OM-BMP-cost 2]]
  ask patches
  [if pcolor != 125
  [set transaction-cost precision transaction-cost 2]]
  ask patches
  [if pcolor != 125
  [set total-BMP-cost precision total-BMP-cost 2]]
  end

to credit-revenue-potential
  repeat 5
  [
  ask patches [
     set credit-revenue gallons-runoff-generated
;     * credit-price
     * indexed-credit-price
     ]
  ]
end

;determine perceived behavior control index from credit-revenue, wealth-index and constraints-index; determine payback
to determine-payback
  ask patches
  [
  set payback (total-BMP-cost / (credit-revenue + annual-max-discount + 0.000000001))
  set payback precision payback 2
  ]
end

 to determine-pbc
  ask patches
  [set constraints-index random-normal 0.5 0.17]
  ask patches
  [let max-income max [annual-income] of patches
;  ask patches
;  [set wealth-index (annual-income / 300000)]
   set wealth-index (annual-income / max-income)]
  ask patches
;  [set pbc ((1 + wealth-index) / 2) - constraints-index]
  [set pbc (wealth-index - constraints-index)]
  ask patches
  [set constraints-index precision constraints-index 2]
  ask patches
  with [parcel-size != 0][set wealth-index precision wealth-index 2]
  ask patches
  with [parcel-size != 0][set pbc precision pbc 2]
  end

to assign-landuse-colors
ask patches with [landuse = "LDR"]
  [set pcolor 108]
ask patches with [landuse = "LMDR"]
  [set pcolor 107]
ask patches with [landuse = "MDR"]
  [set pcolor 106]
ask patches with [landuse = "HDR"]
  [set pcolor 105]
ask patches with [landuse = "MU"]
  [set pcolor 104]
ask patches with [landuse = "S"]
  [set pcolor 103]
ask patches with [landuse = "I"]
  [set pcolor 102]
ask patches with [landuse = "O"]
  [set pcolor 101]
ask patches with [landuse = "C"]
  [set pcolor 100]
ask patches with [ sector = 0]
  [set pcolor 125]
end

to set-innovation-by-sector
  ask patches[
;    if sector = 1 [set innovation-index random-normal 2.49 0.85]
;    if sector = 2 [set innovation-index random-normal 0.81 0.28]
;    if sector = 3 [set innovation-index random-normal 1.45 0.49]
;    if sector = 4 [set innovation-index random-normal 0.64 0.22]
;    if sector = 5 [set innovation-index random-normal 2.07 0.71]
    if sector = 1 [set innovation-index random-normal 1.42 0.48]
    if sector = 2 [set innovation-index random-normal 0.78 0.27]
    if sector = 3 [set innovation-index random-normal 1.17 0.40]
    if sector = 4 [set innovation-index random-normal 0.74 0.25]
    if sector = 5 [set innovation-index random-normal 1.54 0.52]
           ]
    ask patches
  [set innovation-index precision innovation-index 2]
end

to set-income-by-sector
  ask patches[
    if sector = 1 [set annual-income random-normal 197096 67013]
    if sector = 2 [set annual-income random-normal 110971 37730]
    if sector = 3 [set annual-income random-normal 135708 46141]
    if sector = 4 [set annual-income random-normal 54134 18406]
    if sector = 5 [set annual-income random-normal 152684 51913]
  ]
    ask patches
  [set annual-income precision annual-income 2]
end

to sprout-early-adopters ; based upon DOEE RiverSmart early program dynamics where early adopters were
  ; identified as being middle-class, single-familiy homeowners with 1-2 children and who give to charity
  repeat 7 [

  ask n-of number-of-innovators patches [
      if annual-income >= income-lower-threshold and annual-income < income-upper-threshold
    and (landuse = "LDR" or landuse = "LMDR")
    [ sprout 1 ]
  ]
    ask turtles [set shape "tree" set color 45]
    ]
  end


to identify-early-adopters

ask max-n-of (number-of-innovators * 0.75) patches with [(landuse = "LDR" or landuse = "LMDR") and annual-income >= income-lower-threshold and annual-income < income-upper-threshold] [innovation-index] [set pcolor 55]
  ask max-n-of (number-of-innovators * 0.25) patches with [landuse-type = "non-residential"] [innovation-index] [set pcolor 55]
    ask patches with [pcolor = 55] [set plabel "Innovator"]


;  ask n-of (number-of-innovators * 0.75) patches with [(landuse = "LDR" or landuse = "LMDR") and annual-income >= income-lower-threshold and annual-income < income-upper-threshold] [set pcolor 55]
;    ask n-of (number-of-innovators * 0.25) patches with [landuse-type = "non-residential"and innovation-index > 2.2 ] [set pcolor 55]

end

to identify-early-adopters-old ; based upon DOEE RiverSmart early program dynamics where early adopters were
  ; identified as being middle-class, single-familiy homeowners with 1-2 children and who give to charity
;loop
;[
  repeat 10
   [
  ask patches
  [
if count patches with [pcolor = 55] >= number-of-innovators [stop]

     if annual-income >= income-lower-threshold
     and
     annual-income < income-upper-threshold
     and
    (landuse = "LDR" or landuse = "LMDR")
    or
    landuse-type = "non-residential" and innovation-index >= 2.2
;if pcolor != 125

 [set pcolor 55]
  ]
; ask n-of number-of-innovators patches [

;   [set pcolor 55]
    ]
;  ]
  end

;;;;;;;;;;;;;;;;;;;;;;;;;;;OPINION/UNCERTAINTY;;;;;;;;;;;;;;;;;;;;;;;

to establish-initial-sia-and-uncertainty
  ask patches
  [set sia-updated 0]
  ask patches
  [set U-updated 0]
  ask patches
  [set sia-initial-baseline random-float 0.15]
  ask patches
  [
   if annual-income >= income-lower-threshold and annual-income < income-upper-threshold
    and (landuse = "LDR" or landuse = "LMDR")
    [set sia-initial-income random-float (0.15) + 0.05]
  ]
  ask patches
  [
    if (landuse-type = "non-residential" and innovation-index >= 1.49)
    [set sia-initial-income random-float (0.15) + 0.05]
  ]
;  ask patches
;  [if any? neighbors with [ pcolor = 55 ]
;      [set sia-neighboring random-float 0.20]
;  ]

;  ask patches
;  [if innovation-index <= innovation-threshold
;      [set sia-innovation random-float 0.15]
;  ]
;   ask patches with [sector = 5]
;   [set sia-initial-sector random-normal 0.2070 0.0706]
;   ask patches with [sector = 1]
;   [set sia-initial-sector random-normal 0.2495 0.0851]
;   ask patches with [sector = 2]
;   [set sia-initial-sector random-normal 0.0812 0.0277]
;   ask patches with [sector = 3]
;   [set sia-initial-sector random-normal 0.1446 0.0493]
;   ask patches with [sector = 4]
;   [set sia-initial-sector random-normal 0.0636 0.0217]

;   ask patches with [sector = 5]
;   [set sia-initial-sector random-normal 0.2500 0.0850]
;   ask patches with [sector = 1]
;   [set sia-initial-sector random-normal 0.2440 0.0830]
;   ask patches with [sector = 2]
;   [set sia-initial-sector random-normal 0.0620 0.0210]
;   ask patches with [sector = 3]
;   [set sia-initial-sector random-normal 0.1450 0.0500]
;   ask patches with [sector = 4]
;   [set sia-initial-sector random-normal 0.1430 0.0490]

   ask patches with [sector = 5]
   [set sia-initial-sector random-normal 0.154 0.0524]
   ask patches with [sector = 1]
   [set sia-initial-sector random-normal 0.139 0.0473]
   ask patches with [sector = 2]
   [set sia-initial-sector random-normal 0.078 0.0265]
   ask patches with [sector = 3]
   [set sia-initial-sector random-normal 0.117 0.0398]
   ask patches with [sector = 4]
   [set sia-initial-sector random-normal 0.074 0.0265]
;  ask patches [
;    if BMP-rebate != 0 [let sia-initial-BMP-rebate random-float (0.1) + 0.1]
;  ]
  ask patches
  [set sia-initial sia-initial-baseline + 0.1 + sia-initial-income + sia-initial-sector
;    + sia-neighboring
;    + sia-innovation
;   + sia-initial-rebate
    ]
  ask patches with [sia-initial != 0]
  [set U-initial 1 / sia-initial]
  ask patches
  [set sia-updated sia-initial]
  ask patches
  [set U-updated U-initial]
    ask patches
  [set sia-initial precision sia-initial 2]
    ask patches
  [set sia-initial-sector precision sia-initial-sector 2]
      ask patches
  [set U-initial precision U-initial 2]
      ask patches
  [set sia-initial-baseline precision sia-initial-baseline 2]
      ask patches
  [set sia-initial-income precision sia-initial-income 2]
      ask patches
  [set sia-neighboring precision sia-neighboring 2]
  ask patches
  [set sia-plus-east-value 0.00001]
    ask patches
  [set sia-plus-west-value 0.00001]
    ask patches
  [set sia-plus-north-value 0.00001]
    ask patches
  [set sia-plus-south-value 0.00001]
    ask patches
  [set sia-plus-northeast-value 0.00001]
    ask patches
  [set sia-plus-southeast-value 0.00001]
    ask patches
  [set sia-plus-northwest-value 0.00001]
    ask patches
  [set sia-plus-southwest-value 0.00001]
end

;;;;;;;;;;;;;;;;;;RANDOM RELATIVE AGREEMENT ALGORITHM;;;;;;;;;;
;  CREATE A PROCEDURE THAT PAIIRS UP A PATCH WITH RANDOM PATCH OUTSIIDE OF ITS NEIGHBORHOOD AND SECTOR PER SOCIAL DYNAMISM
to relative-algorithm-random
      ask n-of 5
      patches [
      if innovation-index > (innovation-threshold
        - 0.2
        )
      [
      let opinion-self [sia-updated] of patch-at 0 0
      let uncertainty-self [U-updated] of patch-at 0 0
      let sector-self [sector] of patch-at 0 0
;      let other-patches patch-set other neighbors
      let other-patches patch-set other patches

      ask one-of other-patches
      [
      if sector != sector-self
      [
      let opinion-other [sia-updated] of patch-at 0 0
      let uncertainty-other [U-updated] of patch-at 0 0

      let opinion-uncertainty-right-self opinion-self + uncertainty-self
      let opinion-uncertainty-left-self opinion-self - uncertainty-self

      let opinion-uncertainty-right-other opinion-other + uncertainty-other
      let opinion-uncertainty-left-other opinion-other - uncertainty-other

;other - NEED TO CORRECT THIS
      let h-self-other min (list opinion-uncertainty-right-self opinion-uncertainty-right-other) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-other)
      if h-self-other > uncertainty-other and parcel-size != 0
      [ask patch-at 0 0 [set sia-updated (opinion-other + mu * ((h-self-other / uncertainty-self) - 1) * (opinion-self - opinion-other))]]
      if h-self-other > uncertainty-other and parcel-size != 0
      [ask patch-at 0 0 [set U-updated (uncertainty-other + mu * ((h-self-other / uncertainty-self) - 1) * (uncertainty-self - uncertainty-other))]]
;      if h-self-other > uncertainty-other and parcel-size != 0
;      [ask patch-at 0 0 [set pcolor 45]]
      ]
      ]
      ]
      ]

      end

;;;;;;;;;;;;;;;;;RELATIVE AGREEMENT ALGORITHM NEW;;;;;;;;;;;;

to relative-algorithm-initial ;; opinion influence through word of mouth
;NEED TO FIGURE OUT HOW TO INCLUDE SMALL-WORLD DYNAMICS HERE - ASSUME A DISTRIBUTION OF OUTSIDE-NEIGHBORHOOD
;INTERACTIONS BETWEEN 1-10% BASED UPON INNOVATION INDEX/PROFILE - SHOULD FORCE CONTACTS TO BE MADE OUTSIDE OF
;HOME WARD
;ONE WAY OF DOING THIS IS TO HAVE OUTSIDE-NETWORK INTERACTIONS ROUTINE DEVELOPED FIRST, THEN ALLOW FOR
;IN-NEIGHBORHOOD CONTACTS VIA THE CODE ALREADY DEVELOPED IN THIS SECTION
;    ask n-of 10 patches [
;      if parcel-size != 0
;      [
      ask
      n-of 45
      patches [
      let opinion-self [sia-updated] of patch-at 0 0
      let opinion-east [sia-updated] of patch-at 1 0
      let opinion-west [sia-updated] of patch-at -1 0
      let opinion-north [sia-updated] of patch-at 0 1
      let opinion-south [sia-updated] of patch-at 0 -1
      let opinion-southeast [sia-updated] of patch-at 1 -1
      let opinion-northeast [sia-updated] of patch-at 1 1
      let opinion-southwest [sia-updated] of patch-at -1 -1
      let opinion-northwest [sia-updated] of patch-at -1 1
      let uncertainty-self [U-updated] of patch-at 0 0
      let uncertainty-east [U-updated] of patch-at 1 0
      let uncertainty-west [U-updated] of patch-at -1 0
      let uncertainty-north [U-updated] of patch-at 0 1
      let uncertainty-south [U-updated] of patch-at 0 -1
      let uncertainty-southeast [U-updated] of patch-at 1 -1
      let uncertainty-northeast [U-updated] of patch-at 1 1
      let uncertainty-southwest [U-updated] of patch-at -1 -1
      let uncertainty-northwest [U-updated] of patch-at -1 1


      let opinion-uncertainty-right-self opinion-self + uncertainty-self
      let opinion-uncertainty-left-self opinion-self - uncertainty-self

      let opinion-uncertainty-right-east opinion-east + uncertainty-east
      let opinion-uncertainty-left-east opinion-east - uncertainty-east

      let opinion-uncertainty-right-west opinion-east + uncertainty-west
      let opinion-uncertainty-left-west opinion-east - uncertainty-west

      let opinion-uncertainty-right-north opinion-north + uncertainty-north
      let opinion-uncertainty-left-north opinion-north - uncertainty-north

      let opinion-uncertainty-right-south opinion-south + uncertainty-south
      let opinion-uncertainty-left-south opinion-south - uncertainty-south

      let opinion-uncertainty-right-southeast opinion-southeast + uncertainty-southeast
      let opinion-uncertainty-left-southeast opinion-southeast - uncertainty-southeast

      let opinion-uncertainty-right-northeast opinion-northeast + uncertainty-northeast
      let opinion-uncertainty-left-northeast opinion-northeast - uncertainty-northeast

      let opinion-uncertainty-right-southwest opinion-southwest + uncertainty-southwest
      let opinion-uncertainty-left-southwest opinion-southwest - uncertainty-southwest

      let opinion-uncertainty-right-northwest opinion-northwest + uncertainty-northwest
      let opinion-uncertainty-left-northwest opinion-northwest - uncertainty-northwest

;east
      let h-self-east min (list opinion-uncertainty-right-self opinion-uncertainty-right-east) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-east)
      if h-self-east > uncertainty-east and parcel-size != 0
      [ask patch-at 1 0 [set sia-updated (opinion-east + mu * ((h-self-east / uncertainty-self) - 1) * (opinion-self - opinion-east))]]
      if h-self-east > uncertainty-east and parcel-size != 0
      [ask patch-at 1 0 [set U-updated (uncertainty-east + mu * ((h-self-east / uncertainty-self) - 1) * (uncertainty-self - uncertainty-east))]]
;west
      let h-self-west min (list opinion-uncertainty-right-self opinion-uncertainty-right-west) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-west)
      if h-self-west > uncertainty-west and parcel-size != 0
      [ask patch-at -1 0 [set sia-updated (opinion-west + mu * ((h-self-west / uncertainty-self) - 1) * (opinion-self - opinion-west))]]
      if h-self-west > uncertainty-west and parcel-size != 0
      [ask patch-at -1 0 [set U-updated (uncertainty-west + mu * ((h-self-west / uncertainty-self) - 1) * (uncertainty-self - uncertainty-west))]]
;north
      let h-self-north min (list opinion-uncertainty-right-self opinion-uncertainty-right-north) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-north)
      if h-self-north > uncertainty-north and parcel-size != 0
      [ask patch-at 0 1 [set sia-updated (opinion-north + mu * ((h-self-north / uncertainty-self) - 1) * (opinion-self - opinion-north))]]
      if h-self-north > uncertainty-north and parcel-size != 0
      [ask patch-at 0 1 [set U-updated (uncertainty-north + mu * ((h-self-north / uncertainty-self) - 1) * (uncertainty-self - uncertainty-north))]]
;south
      let h-self-south min (list opinion-uncertainty-right-self opinion-uncertainty-right-south) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-south)
      if h-self-south > uncertainty-south and parcel-size != 0
      [ask patch-at 0 -1 [set sia-updated (opinion-south + mu * ((h-self-south / uncertainty-self) - 1) * (opinion-self - opinion-south))]]
      if h-self-south > uncertainty-south and parcel-size != 0
      [ask patch-at 0 -1 [set U-updated (uncertainty-south + mu * ((h-self-south / uncertainty-self) - 1) * (uncertainty-self - uncertainty-south))]]
;southeast
      let h-self-southeast min (list opinion-uncertainty-right-self opinion-uncertainty-right-southeast) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-southeast)
      if h-self-southeast > uncertainty-southeast and parcel-size != 0
      [ask patch-at 1 -1 [set sia-updated (opinion-southeast + mu * ((h-self-southeast / uncertainty-self) - 1) * (opinion-self - opinion-southeast))]]
      if h-self-southeast > uncertainty-southeast and parcel-size != 0
      [ask patch-at 1 -1 [set U-updated (uncertainty-southeast + mu * ((h-self-southeast / uncertainty-self) - 1) * (uncertainty-self - uncertainty-southeast))]]
;northeast
      let h-self-northeast min (list opinion-uncertainty-right-self opinion-uncertainty-right-northeast) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-northeast)
      if h-self-northeast > uncertainty-northeast and parcel-size != 0
      [ask patch-at 1 1 [set sia-updated (opinion-northeast + mu * ((h-self-northeast / uncertainty-self) - 1) * (opinion-self - opinion-northeast))]]
      if h-self-northeast > uncertainty-northeast and parcel-size != 0
      [ask patch-at 1 1 [set U-updated (uncertainty-northeast + mu * ((h-self-northeast / uncertainty-self) - 1) * (uncertainty-self - uncertainty-northeast))]]
;southwest
      let h-self-southwest min (list opinion-uncertainty-right-self opinion-uncertainty-right-southwest) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-southwest)
      if h-self-southwest > uncertainty-southwest and parcel-size != 0
      [ask patch-at -1 -1 [set sia-updated (opinion-southwest + mu * ((h-self-southwest / uncertainty-self) - 1) * (opinion-self - opinion-southwest))]]
      if h-self-southwest > uncertainty-southwest and parcel-size != 0
      [ask patch-at -1 -1 [set U-updated (uncertainty-southwest + mu * ((h-self-southwest / uncertainty-self) - 1) * (uncertainty-self - uncertainty-southwest))]]
;northwest
      let h-self-northwest min (list opinion-uncertainty-right-self opinion-uncertainty-right-northwest) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-northwest)
      if h-self-northwest > uncertainty-northwest and parcel-size != 0
      [ask patch-at -1 1 [set sia-updated (opinion-northwest + mu * ((h-self-northwest / uncertainty-self) - 1) * (opinion-self - opinion-northwest))]]
      if h-self-northwest > uncertainty-northwest and parcel-size != 0
      [ask patch-at -1 1 [set U-updated (uncertainty-northwest + mu * ((h-self-northwest / uncertainty-self) - 1) * (uncertainty-self - uncertainty-northwest))]]

;     ]
;     ]
    ]

   ask patches
  [set sia-updated precision sia-updated 2]
    ask patches
  [set U-updated precision U-updated 2]

end

;;;;;;;;;;;;;;;;;;;;;;sia-plus-old;;;;;;;;;;;;;;;

to sia-neighboring-plus-old
  ask patches [
  if count neighbors with [ pcolor = 55 ] = 1
  [set sia-updated sia-updated + 0.01]
  if count neighbors with [ pcolor = 55 ] = 2
  [set sia-updated sia-updated + 0.01]
  if count neighbors with [ pcolor = 55 ] = 3
  [set sia-updated sia-updated + 0.01]
  if count neighbors with [ pcolor = 55 ] = 4
  [set sia-updated sia-updated + 0.01]
  if count neighbors with [ pcolor = 55 ] = 5
  [set sia-updated sia-updated + 0.01]
  if count neighbors with [ pcolor = 55 ] = 6
  [set sia-updated sia-updated + 0.02]
  if count neighbors with [ pcolor = 55 ] = 7
  [set sia-updated sia-updated + 0.04]
  if count neighbors with [ pcolor = 55 ] = 8
  [set sia-updated sia-updated + 0.04]
  let sia-initial-max sia-initial + 0.15
  if sia-updated >= sia-initial-max
  [set sia-updated sia-initial-max]
;  if sia-updated > 1
; [set sia-updated 1]
  ]
end

;;;;;;;;;;;;;;;;;;;;;;sia-plus;;;;;;;;;;;;;;;
; THIS MODULE ACCOUNTS FOR NEIGHBORING/SPATIAL INFLUENCES THAT GO BEYOND WORD-OF-MOUTH
; THIS ROUTINE ASKS ALL PATCHES TO REVIEW ALL NEIGHBORS TO SEE IF THEY ARE ALREADY GREENED AND HAVEN'T HAD AN INFLUENCED OPINION AS OF YET
; IF BOTH CONDITIONS ARE MET, 0.04375 IS ADDED TO THEIR SIA-UPDATED VALUE - THE SIGNIFICANCE OF 0.04375 IS THAT THERE ARE 8 NEIGHBORS AND THE
; TOTAL INFLUENCE OF NEIGHBORING WAS DECIDED TO BE 0.35, SO 0.04375 * 8 = 0.35
to sia-neighboring-plus-setup
  ask
;  n-of 10
  patches
  [
  if [pcolor] of patch-at 1 0 = 55 and sia-plus-east-value = 0.00001
  [set sia-plus-east-value 0.04375]


  if [pcolor] of patch-at -1 0 = 55 and sia-plus-west-value = 0.00001
  [set sia-plus-west-value 0.04375]


  if [pcolor] of patch-at 0 1 = 55 and sia-plus-north-value = 0.00001
  [set sia-plus-north-value 0.04375]

  if [pcolor] of patch-at 0 -1 = 55 and sia-plus-south-value = 0.00001
  [set sia-plus-south-value 0.04375]


  if [pcolor] of patch-at 1 -1 = 55 and sia-plus-southeast-value = 0.00001
  [set sia-plus-southeast-value 0.04375]


  if [pcolor] of patch-at 1 1 = 55 and sia-plus-northeast-value = 0.00001
  [set sia-plus-northeast-value 0.04375]


  if [pcolor] of patch-at -1 1 = 55 and sia-plus-northwest-value = 0.00001
  [set sia-plus-northwest-value 0.04375]


  if [pcolor] of patch-at -1 -1 = 55 and sia-plus-southwest-value = 0.00001
  [set sia-plus-southwest-value 0.04375]


  ]
end

;THIS ROUTINE ADDS THE NEIGHBOR-INFLUENCED VALUE (SIA-PLUS) TO THE SIA-UPDATED VALUE
to sia-neighboring-plus-add
ask patches
[
    set sia-updated
  sia-updated +
    sia-plus-east-value
    + sia-plus-west-value
    + sia-plus-south-value
    + sia-plus-north-value
    + sia-plus-southeast-value
    + sia-plus-northeast-value
    + sia-plus-southwest-value
    + sia-plus-northwest-value
]
end

; THIS ROUTINE ENSURES THAT THE NEIBORING EFFECT DOESN'T BECOME A 'RUNAWAY LOOP' BY ADDING 0.04375 OVER AND OVER AGAIN
; THE ROUTINE SCREENS OUT PATCHES THAT HAVE NEIGHBORS WITH 0.04375 IN THEIR SIA-PLUS VALUES
to sia-neighboring-plus-adjust
ask patches [
    if [pcolor] of patch-at 1 0 = 55 and sia-plus-east-value = 0.04375
 [set sia-plus-east-value 0]
   if [pcolor] of patch-at -1 0 = 55 and sia-plus-west-value = 0.04375
 [set sia-plus-west-value 0]
   if [pcolor] of patch-at 0 1 = 55 and sia-plus-north-value = 0.04375
  [set sia-plus-north-value 0]
    if [pcolor] of patch-at 0 -1 = 55 and sia-plus-south-value = 0.04375
  [set sia-plus-south-value 0]
    if [pcolor] of patch-at 1 -1 = 55 and sia-plus-southeast-value = 0.04375
  [set sia-plus-southeast-value 0]
    if [pcolor] of patch-at 1 1 = 55 and sia-plus-northeast-value = 0.04375
  [set sia-plus-northeast-value 0]
    if [pcolor] of patch-at -1 1 = 55 and sia-plus-northwest-value = 0.04375
  [set sia-plus-northwest-value 0]
    if [pcolor] of patch-at -1 -1 = 55 and sia-plus-southwest-value = 0.04375
  [set sia-plus-southwest-value 0]
]

;  [set sia-updated sia-updated + 0.04]
;  let sia-initial-max sia-initial + 0.15
;  if sia-updated >= sia-initial-max
;  [set sia-updated sia-initial-max]

end


;;;;;;;;;;;;;;;;;RELATIVE AGREEMENT ALGORITHM OLD;;;;;;;;;;;;

to relative-algorithm-initial-old ;; opinion influence through word of mouth
;NEED TO FIGURE OUT HOW TO INCLUDE SMALL-WORLD DYNAMICS HERE - ASSUME A DISTRIBUTION OF OUTSIDE-NEIGHBORHOOD
;INTERACTIONS BETWEEN 1-10% BASED UPON INNOVATION INDEX/PROFILE - SHOULD FORCE CONTACTS TO BE MADE OUTSIDE OF
;HOME WARD
;ONE WAY OF DOING THIS IS TO HAVE OUTSIDE-NETWORK INTERACTIONS ROUTINE DEVELOPED FIRST, THEN ALLOW FOR
;IN-NEIGHBORHOOD CONTACTS VIA THE CODE ALREADY DEVELOPED IN THIS SECTION
;    ask n-of 10 patches [
;     if parcel-size != 0
;      [
      ask
;      n-of 10
      patches [
      let opinion-self [sia-initial] of patch-at 0 0
      let opinion-east [sia-initial] of patch-at 1 0
      let opinion-west [sia-initial] of patch-at -1 0
      let opinion-north [sia-initial] of patch-at 0 1
      let opinion-south [sia-initial] of patch-at 0 -1
      let opinion-southeast [sia-initial] of patch-at 1 -1
      let opinion-northeast [sia-initial] of patch-at 1 1
      let opinion-southwest [sia-initial] of patch-at -1 -1
      let opinion-northwest [sia-initial] of patch-at -1 1
      let uncertainty-self [U-initial] of patch-at 0 0
      let uncertainty-east [U-initial] of patch-at 1 0
      let uncertainty-west [U-initial] of patch-at -1 0
      let uncertainty-north [U-initial] of patch-at 0 1
      let uncertainty-south [U-initial] of patch-at 0 -1
      let uncertainty-southeast [U-initial] of patch-at 1 -1
      let uncertainty-northeast [U-initial] of patch-at 1 1
      let uncertainty-southwest [U-initial] of patch-at -1 -1
      let uncertainty-northwest [U-initial] of patch-at -1 1
      let updated-opinion-east [sia-updated] of patch-at 1 0
      let updated-opinion-west [sia-updated] of patch-at -1 0
      let updated-opinion-north [sia-updated] of patch-at 0 1
      let updated-opinion-south [sia-updated] of patch-at 0 -1
      let updated-opinion-southeast [sia-updated] of patch-at 1 -1
      let updated-opinion-northeast [sia-updated] of patch-at 1 1
      let updated-opinion-southwest [sia-updated] of patch-at -1 -1
      let updated-opinion-northwest [sia-updated] of patch-at -1 1
      let updated-uncertainty-east [U-updated] of patch-at 1 0
      let updated-uncertainty-west [U-updated] of patch-at -1 0
      let updated-uncertainty-north [U-updated] of patch-at 0 1
      let updated-uncertainty-south [U-updated] of patch-at 0 -1
      let updated-uncertainty-southeast [U-updated] of patch-at 1 -1
      let updated-uncertainty-northeast [U-updated] of patch-at 1 1
      let updated-uncertainty-southwest [U-updated] of patch-at -1 -1
      let updated-uncertainty-northwest [U-updated] of patch-at -1 1

      let opinion-uncertainty-right-self opinion-self + uncertainty-self
      let opinion-uncertainty-left-self opinion-self - uncertainty-self

      let opinion-uncertainty-right-east opinion-east + uncertainty-east
      let opinion-uncertainty-left-east opinion-east - uncertainty-east

      let opinion-uncertainty-right-west opinion-east + uncertainty-west
      let opinion-uncertainty-left-west opinion-east - uncertainty-west

      let opinion-uncertainty-right-north opinion-north + uncertainty-north
      let opinion-uncertainty-left-north opinion-north - uncertainty-north

      let opinion-uncertainty-right-south opinion-south + uncertainty-south
      let opinion-uncertainty-left-south opinion-south - uncertainty-south

      let opinion-uncertainty-right-southeast opinion-southeast + uncertainty-southeast
      let opinion-uncertainty-left-southeast opinion-southeast - uncertainty-southeast

      let opinion-uncertainty-right-northeast opinion-northeast + uncertainty-northeast
      let opinion-uncertainty-left-northeast opinion-northeast - uncertainty-northeast

      let opinion-uncertainty-right-southwest opinion-southwest + uncertainty-southwest
      let opinion-uncertainty-left-southwest opinion-southwest - uncertainty-southwest

      let opinion-uncertainty-right-northwest opinion-northwest + uncertainty-northwest
      let opinion-uncertainty-left-northwest opinion-northwest - uncertainty-northwest

;east
      let h-self-east min (list opinion-uncertainty-right-self opinion-uncertainty-right-east) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-east)
      if h-self-east > uncertainty-east and parcel-size != 0
      [ask patch-at 1 0 [set sia-updated (opinion-east + mu * ((h-self-east / uncertainty-self) - 1) * (opinion-self - opinion-east))]]
      if h-self-east > uncertainty-east and parcel-size != 0
      [ask patch-at 1 0 [set U-updated (uncertainty-east + mu * ((h-self-east / uncertainty-self) - 1) * (uncertainty-self - uncertainty-east))]]
;west
      let h-self-west min (list opinion-uncertainty-right-self opinion-uncertainty-right-west) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-west)
      if h-self-west > uncertainty-west and parcel-size != 0
      [ask patch-at -1 0 [set sia-updated (opinion-west + mu * ((h-self-west / uncertainty-self) - 1) * (opinion-self - opinion-west))]]
      if h-self-west > uncertainty-west and parcel-size != 0
      [ask patch-at -1 0 [set U-updated (uncertainty-west + mu * ((h-self-west / uncertainty-self) - 1) * (uncertainty-self - uncertainty-west))]]
;north
      let h-self-north min (list opinion-uncertainty-right-self opinion-uncertainty-right-north) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-north)
      if h-self-north > uncertainty-north and parcel-size != 0
      [ask patch-at 0 1 [set sia-updated (opinion-north + mu * ((h-self-north / uncertainty-self) - 1) * (opinion-self - opinion-north))]]
      if h-self-north > uncertainty-north and parcel-size != 0
      [ask patch-at 0 1 [set U-updated (uncertainty-north + mu * ((h-self-north / uncertainty-self) - 1) * (uncertainty-self - uncertainty-north))]]
;south
      let h-self-south min (list opinion-uncertainty-right-self opinion-uncertainty-right-south) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-south)
      if h-self-south > uncertainty-south and parcel-size != 0
      [ask patch-at 0 -1 [set sia-updated (opinion-south + mu * ((h-self-south / uncertainty-self) - 1) * (opinion-self - opinion-south))]]
      if h-self-south > uncertainty-south and parcel-size != 0
      [ask patch-at 0 -1 [set U-updated (uncertainty-south + mu * ((h-self-south / uncertainty-self) - 1) * (uncertainty-self - uncertainty-south))]]
;southeast
      let h-self-southeast min (list opinion-uncertainty-right-self opinion-uncertainty-right-southeast) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-southeast)
      if h-self-southeast > uncertainty-southeast and parcel-size != 0
      [ask patch-at 1 -1 [set sia-updated (opinion-southeast + mu * ((h-self-southeast / uncertainty-self) - 1) * (opinion-self - opinion-southeast))]]
      if h-self-southeast > uncertainty-southeast and parcel-size != 0
      [ask patch-at 1 -1 [set U-updated (uncertainty-southeast + mu * ((h-self-southeast / uncertainty-self) - 1) * (uncertainty-self - uncertainty-southeast))]]
;northeast
      let h-self-northeast min (list opinion-uncertainty-right-self opinion-uncertainty-right-northeast) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-northeast)
      if h-self-northeast > uncertainty-northeast and parcel-size != 0
      [ask patch-at 1 1 [set sia-updated (opinion-northeast + mu * ((h-self-northeast / uncertainty-self) - 1) * (opinion-self - opinion-northeast))]]
      if h-self-northeast > uncertainty-northeast and parcel-size != 0
      [ask patch-at 1 1 [set U-updated (uncertainty-northeast + mu * ((h-self-northeast / uncertainty-self) - 1) * (uncertainty-self - uncertainty-northeast))]]
;southwest
      let h-self-southwest min (list opinion-uncertainty-right-self opinion-uncertainty-right-southwest) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-southwest)
      if h-self-southwest > uncertainty-southwest and parcel-size != 0
      [ask patch-at -1 -1 [set sia-updated (opinion-southwest + mu * ((h-self-southwest / uncertainty-self) - 1) * (opinion-self - opinion-southwest))]]
      if h-self-southwest > uncertainty-southwest and parcel-size != 0
      [ask patch-at -1 -1 [set U-updated (uncertainty-southwest + mu * ((h-self-southwest / uncertainty-self) - 1) * (uncertainty-self - uncertainty-southwest))]]
;northwest
      let h-self-northwest min (list opinion-uncertainty-right-self opinion-uncertainty-right-northwest) - max (list opinion-uncertainty-left-self opinion-uncertainty-left-northwest)
      if h-self-northwest > uncertainty-northwest and parcel-size != 0
      [ask patch-at -1 1 [set sia-updated (opinion-northwest + mu * ((h-self-northwest / uncertainty-self) - 1) * (opinion-self - opinion-northwest))]]
      if h-self-northwest > uncertainty-northwest and parcel-size != 0
      [ask patch-at -1 1 [set U-updated (uncertainty-northwest + mu * ((h-self-northwest / uncertainty-self) - 1) * (uncertainty-self - uncertainty-northwest))]]

      ]
;      ]
;    ]

end



;;;;;;;;;;;;;;;PUBLIC OUTREACH AGENTS;;;;;;;;;;;;;;;;;;;;;;;;;;

to create-outreach-agents
;  repeat 10
;  [
  ask n-of number-of-pub-outreach patches [
    if public-outreach-agent-contact = "false"
    [sprout-public-outreach-specialists 1 [set color red set shape "triangle" set size 1]]
;    if any? public-outreach-specialists-here [die]
  ]
;  ]
end


to public-outreach-specialists-move
  ask public-outreach-specialists
 [
;    ifelse any? neighbors with [parcel-size = 0]
;    [
      setxy random-pxcor random-pycor
;      ] [
      set heading random 360 fd 1
;      ]
    ask patch-here [set public-outreach-agent-contact "true"]
   ]
end

to identify-isolated-adopters
; ask patches with [pcolor = 55] [if count neighbors with [plabel = "Innovator"] >= 1 [set isolated-adopter "true"]]
ask patches with [pcolor = 55 and plabel != "Innovator"] [if count neighbors with [plabel = "Innovator"] >= 1 [set isolated-adopter "false"]]
ask patches with [pcolor = 55 and plabel != "Innovator"] [if count neighbors with [plabel = "Innovator"] = 0 [set isolated-adopter "true"]]
end


;;;;;;;;;;;;;;;;;;;;;;;;;TESTING;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;clustering;;;;;;;;;;;;;;;

to determine-clusters-old
  ask patches with [pcolor = 55]
   [
  if count patches in-radius 1 with [ pcolor = 55 ] = 0
  [set cluster-number 0.111]
  if count patches in-radius 1 with [ pcolor = 55 ] = 1
  [set cluster-number 0.222
  if count patches in-radius 1 with [ pcolor = 55 ] = 2
  [set cluster-number 0.333]
  if count patches in-radius 1 with [ pcolor = 55 ] = 3
  [set cluster-number 0.444]
  if count patches in-radius 1 with [ pcolor = 55 ] = 4
  [set cluster-number 0.555]
  if count patches in-radius 1 with [ pcolor = 55 ] = 5
  [set cluster-number 0.666]
  if count patches in-radius 1 with [ pcolor = 55 ] = 6
  [set cluster-number 0.777]
  if count patches in-radius 1 with [ pcolor = 55 ] = 7
  [set cluster-number 0.888]
  if count patches in-radius 1 with [ pcolor = 55 ] = 8
  [set cluster-number 1]
  ]
   ]
end

;;;;;;;;;;;;;;;;;;;;;;clustering;;;;;;;;;;;;;;;



to see-good-paybacks-self
ask patches
[if payback < payback-threshold-self [set pcolor 25]
 ]
end


to see-good-payback-threshold-other
  ask patches
[if payback < payback-threshold-other [set pcolor 25]
 ]
end


to see-parcel-acreage-threshold
  ask patches
[if parcel-size >= parcel-acreage-threshold [set pcolor 25]
 ]
end

to see-good-sia-threshold
  ask patches
[if sia-updated > sia-threshold [set pcolor 25]
 ]
end

to see-good-innovation-threshold
  ask patches
[if innovation-index > innovation-threshold
  and landuse-type = "non-residential"
  [set pcolor 25]
 ]
end

to see-imp-cover-0
ask patches
[if impervious-cover <= 0 [set pcolor 25]
 ]
end


to see-implementation-decision-score
ask patches
[if implementation-decision-score = test-implementation-decision-score [set pcolor 25]
 ]
end

;;;;;;;;;;;;;;;;;;;;;;;;PROCEDURES;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;SUPPLY AND DEMAND;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to determine-muni-demand
if remainder ticks 12 = 0
[set muni-demand muni-demand + ongoing-muni-demand
;  + 50000
;  + 0
  ]
end

to determine-development-demand
  if remainder ticks 12 = 0
  [ask n-of (redevelopment_rate / 100 * 654) patches with [sector != 0]
;    [set pcolor red]
    [
      let new-development-demand gallons-runoff-generated
    set development-demand (development-demand + new-development-demand)
      set development-demand precision development-demand 2
  ]
  ]
end

to determine-supply-demand-ratio
 let total-supply sum [gallons-runoff-generated] of patches
with [pcolor = 55 and plabel != "Innovator"]
  set demand-supply-ratio (muni-demand + development-demand) / (total-supply + 0.0000001)
  set demand-supply-ratio precision demand-supply-ratio 2

end

to determine-indexed-credit-price
  set indexed-credit-price credit-price * demand-supply-ratio
;  / 10
  / 1
  if indexed-credit-price > 3.5 [set indexed-credit-price 3.5]
  if indexed-credit-price < 1 [set indexed-credit-price 1]
  set indexed-credit-price precision indexed-credit-price 2
  end

;;;;;;;;;;;;;;;;;;;DECISION-MAKING;;;;;;;;;;;;;;;;;;;;;;;;;

to decision-making
set-property-owner-attributes
end

to set-property-owner-attributes
  ask patches
  [
    ifelse pcolor = 55 [set green-infrastructure-decision "accepted"] [set green-infrastructure-decision "not_accepted"]
    ifelse pcolor = 55 [set acceptance-decision-score 2] [set acceptance-decision-score 0]
    ifelse pcolor = 55 [set green-infrastructure-practiced true] [set green-infrastructure-practiced false]
    ifelse pcolor = 55 [set implementation-decision-score 3] [set implementation-decision-score 0]
    set public-outreach-agent-contact "false"
  ]
end


;THIS IS PATCH-BASED DECISION MAKING STUFF

to property-owner-decision-start-point
  ask patches [
  if green-infrastructure-practiced = true
  and
  landuse-type = "residential"
  [SRC-implementation-continued-res]
  if green-infrastructure-practiced = false
    and
  landuse-type = "residential"
  [run-decide-between-accept-and-implement-res]
    if green-infrastructure-practiced = true
  and
  landuse-type = "non-residential"
  [SRC-implementation-continued-non-res]
  if green-infrastructure-practiced = false
    and
  landuse-type = "non-residential"
  [run-decide-between-accept-and-implement-non-res]
;  if acceptance-decision-score = 1 [SRC-form-opinion]
  ]
end

;;;;;;;;;;;;;;;;;RESIDENTIAL DECISION MAKING;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to run-decide-between-accept-and-implement-res
  if green-infrastructure-decision = "not_accepted" [ run-acceptance-decision-res ]
  if green-infrastructure-decision = "accepted_not_implemented" [ run-implementation-decision-res ]
  if green-infrastructure-decision = "implemented" [ SRC-implementation-continued-res ]
end

to run-acceptance-decision-res
 if acceptance-decision-score = 0 [ SRC-aware-res ]
 if acceptance-decision-score = 1 [ SRC-form-opinion-res ]
 if acceptance-decision-score = 2 [ run-implementation-decision-res ]
end

to SRC-aware-res
  ifelse ((innovation-index > innovation-threshold) or (public-outreach-agent-contact = "true")) or
 ; (
 ;   (innovation-index > innovation-threshold) and
  (count neighbors with [ green-infrastructure-practiced = true ] >= neighbors-threshold)
 ; )
[set acceptance-decision-score 1] [set acceptance-decision-score 0]

end

;---------------------------------------------------------------------------------------------------------

to SRC-form-opinion-res
;  ask patches [
    ifelse sia-updated > sia-threshold [ run-implementation-decision-res ] [ SRC-aware-res ]
;  ]
end

to run-implementation-decision-res
  set green-infrastructure-decision "accepted_not_implemented"
 if implementation-decision-score = 0 [ SRC-self-investment-decision-res ]
 if implementation-decision-score = 1 [ SRC-other-investment-decision-res ]
 if implementation-decision-score = 2 [ SRC-implementation-positive-res ]
 if implementation-decision-score = 3 [ SRC-implementation-continued-res ]
end

to SRC-self-investment-decision-res
  ; NEED TO INCORPORATE OTHER FACTORS HERE POSSIBLY, SUCH AS RISK, ETC.
     ifelse (pbc > 0.5) and (payback <= payback-threshold-self)
;     and (total-BMP-cost < 0.005 * annual-income)
[set implementation-decision-score 2] [set implementation-decision-score 1]
end

to SRC-other-investment-decision-res
  ; NEED TO CONSIDER MANY MORE/DIFFERENT FACTORS HERE
    ifelse
;    (sia-updated > sia-threshold)
;      or
      (payback <= payback-threshold-other)
     and (constraints-index <= constraints-threshold)
[set implementation-decision-score 2] [set implementation-decision-score 1]
    ifelse
     (payback <= payback-threshold-other)
     and (count neighbors with [ green-infrastructure-practiced = true ] >= (neighbors-threshold - additional-neighbors-threshold))
     [set implementation-decision-score 2] [set implementation-decision-score 1]
end

to SRC-implementation-positive-res
;NEED TO INCORPORATE A TIME DELAY TO SIMULATE THE TIME REQUIRED TO IMPLEMENT - SHOULD VARY NORMALLY AND SHOULD BE COMPRISED OF A CERTAIN NUMBER OF TICKS
;    wait 1
    set pcolor 55
    set implementation-decision-score 3
    set green-infrastructure-decision "implemented"
    set green-infrastructure-practiced true
    set credit-revenue-generated indexed-credit-price * gallons-runoff-generated
end

to SRC-implementation-continued-res
ifelse (OM-BMP-Cost < credit-revenue) [set pcolor 55] [reassign-landuse-colors-and-properties]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;DECISION MAKING ROUTINES FOR NON-RESIDENTIAL;;;;;;;;;;;;;;;;;;;;;;;;;;


;  Assumption here is that non-residential property owners will make decisions in a manner that is
; unique compared with residential property owners.  Specifically, non-residential

to run-decide-between-accept-and-implement-non-res
  if green-infrastructure-decision = "not_accepted" [ run-acceptance-decision-non-res ]
  if green-infrastructure-decision = "accepted_not_implemented" [ run-implementation-decision-non-res ]
  if green-infrastructure-decision = "implemented" [ SRC-implementation-continued-non-res ]
end

to run-acceptance-decision-non-res
 if acceptance-decision-score = 0 [ SRC-aware-non-res ]
 if acceptance-decision-score = 1 [ SRC-form-opinion-non-res ]
 if acceptance-decision-score = 2 [ run-implementation-decision-non-res ]
end

to SRC-aware-non-res
  ifelse ((innovation-index > innovation-threshold)
  or (public-outreach-agent-contact = "true"))
;  or (count neighbors with [green-infrastructure-practiced = true] >= neighbors-threshold)
[set acceptance-decision-score 1] [set acceptance-decision-score 0]

end

to SRC-form-opinion-non-res
;  ask patches [
    ifelse (sia-updated > sia-threshold - 0.1) [ run-implementation-decision-non-res ] [ SRC-aware-non-res ]
;  ]
end

to run-implementation-decision-non-res
  set green-infrastructure-decision "accepted_not_implemented"
 if implementation-decision-score = 0 [ SRC-self-investment-decision-non-res ]
 if implementation-decision-score = 1 [ SRC-other-investment-decision-non-res ]
 if implementation-decision-score = 2 [ SRC-implementation-positive-non-res ]
 if implementation-decision-score = 3 [ SRC-implementation-continued-non-res ]
end

to SRC-self-investment-decision-non-res
  ; NEED TO INCORPORATE OTHER FACTORS HERE POSSIBLY, SUCH AS RISK, ETC.
     ifelse (pbc > 0.5) and (payback <= payback-threshold-self)
;     and (total-BMP-cost < 0.005 * annual-income)
[set implementation-decision-score 2] [set implementation-decision-score 1]
end

to SRC-other-investment-decision-non-res
  ; NEED TO CONSIDER MANY MORE/DIFFERENT FACTORS HERE
    ifelse
;    (sia-updated > sia-threshold)
;      or
      (payback <= payback-threshold-other)
    and (constraints-index <= constraints-threshold)
[set implementation-decision-score 2] [set implementation-decision-score 1]
    ifelse
     (payback <= payback-threshold-other)
    and (count neighbors with [ green-infrastructure-practiced = true ] >= (neighbors-threshold - additional-neighbors-threshold))
     [set implementation-decision-score 2] [set implementation-decision-score 1]
end

to SRC-implementation-positive-non-res
;NEED TO INCORPORATE A TIME DELAY TO SIMULATE THE TIME REQUIRED TO IMPLEMENT - SHOULD VARY NORMALLY AND SHOULD BE COMPRISED OF A CERTAIN NUMBER OF TICKS
;    wait 1
    set pcolor 55
    set implementation-decision-score 3
    set green-infrastructure-decision "implemented"
    set green-infrastructure-practiced true
    set credit-revenue-generated indexed-credit-price * gallons-runoff-generated
end

to SRC-implementation-continued-non-res
ifelse (OM-BMP-Cost < credit-revenue) [set pcolor 55] [reassign-landuse-colors-and-properties]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to reassign-landuse-colors
if landuse = "LDR" [set pcolor 108]
if landuse = "LMDR" [set pcolor 107]
if landuse = "MDR" [set pcolor 106]
if landuse = "HDR" [set pcolor 105]
if landuse = "MU"  [set pcolor 104]
if landuse = "S"   [set pcolor 103]
if landuse = "I"   [set pcolor 102]
if landuse = "O"   [set pcolor 101]
if landuse = "C"   [set pcolor 100]
end

to reassign-landuse-colors-and-properties
if landuse = "LDR" [set pcolor 108]
if landuse = "LMDR" [set pcolor 107]
if landuse = "MDR" [set pcolor 106]
if landuse = "HDR" [set pcolor 105]
if landuse = "MU"  [set pcolor 104]
if landuse = "S"   [set pcolor 103]
if landuse = "I"   [set pcolor 102]
if landuse = "O"   [set pcolor 101]
if landuse = "C"   [set pcolor 100]
set green-infrastructure-decision "not_accepted"
set acceptance-decision-score 0
set green-infrastructure-practiced false
set implementation-decision-score 0
end


to assign-landuse-type
ask patches[
if landuse = "LDR" [set landuse-type "residential"]
if landuse = "LMDR" [set landuse-type "residential"]
if landuse = "MDR" [set landuse-type "residential"]
if landuse = "HDR" [set landuse-type "residential"]
if landuse = "MU"  [set landuse-type "residential"]
if landuse = "S"   [set landuse-type "non-residential"]
if landuse = "I"   [set landuse-type "non-residential"]
if landuse = "O"   [set landuse-type "non-residential"]
if landuse = "C"   [set landuse-type "non-residential"]
]
end


to see-implementation-decision-equal-greater-than-1
ask patches
[if implementation-decision-score >= 1 [set pcolor 55]

]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;VIEW OPINION DISSIMENATION;;;;;;;;;;;;;;;;;;;;;;;;


to see-RA-work
  ask patches with [sia-updated <= 0.15]
  [set pcolor 14 ]
    ask patches with [sia-updated > 0.15 and sia-updated <= 0.3]
  [set pcolor 15 ]
ask patches with [sia-updated > 0.3 and sia-updated <= 0.45]
  [set pcolor 16 ]
  ask patches with [sia-updated > 0.45 and sia-updated <= 0.6]
  [set pcolor 17 ]
  ask patches with [sia-updated > 0.6 and sia-updated <= 0.75]
  [set pcolor 18 ]
  ask patches with [sia-updated > 0.75]
  [set pcolor 19 ]
end


to see-RA-work-turtles-patches
  ask patches with [sia-updated <= 0.15]
  [sprout-lowest-opinions 1 [set color 14 set shape "tree"]]
      ask patches with [sia-updated > 0.15 and sia-updated <= 0.3]
  [sprout-lower-opinions 1 [set color 15 set shape "tree"]]
ask patches with [sia-updated > 0.3 and sia-updated <= 0.45]
  [sprout-low-opinions 1 [set color 16 set shape "tree"]]
  ask patches with [sia-updated > 0.45 and sia-updated <= 0.6]
  [sprout-moderate-opinions 1 [set color 17 set shape "tree"]]
  ask patches with [sia-updated > 0.6 and sia-updated <= 0.75]
  [sprout-higher-opinions 1 [set color 18 set shape "tree"]]
  ask patches with [sia-updated > 0.75]
  [sprout-highest-opinions 1 [set color 19 set shape "tree"]]
end


to see-RA-work-turtles
  ask turtles with [sia-updated <= 0.15]
  [hatch-lowest-opinions 1 [set color 14 set shape "tree"]]
      ask turtles with [sia-updated > 0.15 and sia-updated <= 0.3]
  [hatch-lower-opinions 1 [set color 15 set shape "tree"]]
ask turtles with [sia-updated > 0.3 and sia-updated <= 0.45]
  [hatch-low-opinions 1 [set color 16 set shape "tree"]]
  ask turtles with [sia-updated > 0.45 and sia-updated <= 0.6]
  [hatch-moderate-opinions 1 [set color 17 set shape "tree"]]
  ask turtles with [sia-updated > 0.6 and sia-updated <= 0.75]
  [hatch-higher-opinions 1 [set color 18 set shape "tree"]]
  ask turtles with [sia-updated > 0.75]
  [hatch-highest-opinions 1 [set color 19 set shape "tree"]]
end

to see-clusters
  ask patches with [cluster-number != 0]
  [set pcolor 14 ]
end

;;;;;;;;;;;;;;;;;

to assign-landuse-colors-invested-parcels
ask patches with [landuse = "LDR"]
  [set pcolor 108]
ask patches with [landuse = "LMDR"]
  [set pcolor 107]
ask patches with [landuse = "MDR"]
  [set pcolor 106]
ask patches with [landuse = "HDR"]
  [set pcolor 105]
ask patches with [landuse = "MU"]
  [set pcolor 104]
ask patches with [landuse = "S"]
  [set pcolor 103]
ask patches with [landuse = "I"]
  [set pcolor 102]
ask patches with [landuse = "O"]
  [set pcolor 101]
ask patches with [landuse = "C"]
  [set pcolor 100]
ask patches with [ sector = 0]
  [set pcolor 125]
  ask patches with [ green-infrastructure-practiced = true]
  [set pcolor 55]
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;to neighbors-test ;; determining if neighbors are good for investment
;;  repeat 10
;;  [
;    ask n-of 2 patches [
;      let added-self [pbc] of patch-at 0 0
;      let added-east [pbc] of patch-at 1 0
;      let added-west [pbc] of patch-at -1 0
;      let added-north [pbc] of patch-at 0 1
;      let added-south [pbc] of patch-at 0 -1
;      let added-southeast [pbc] of patch-at 1 -1
;      let added-northeast [pbc] of patch-at 1 1
;      let added-southwest [pbc] of patch-at -1 -1
;      let added-northwest [pbc] of patch-at -1 1
;
;      if added-self + added-east >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold [ask patch-at 1 0 [set pcolor 55 ] ]
;
;      if added-self + added-west >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold  [ask patch-at -1 0 [set pcolor 55 ] ]
;
;      if added-self + added-north >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold  [ask patch-at 0 1 [set pcolor 55 ] ]
;
;      if added-self + added-south >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold  [ask patch-at 0 -1 [set pcolor 55 ] ]
;
;      if added-self + added-southeast >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold [ask patch-at 1 -1 [set pcolor 55 ] ]
;
;      if added-self + added-northeast >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold [ask patch-at 1 1 [set pcolor 55 ] ]
;
;      if added-self + added-southwest >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold [ask patch-at -1 -1 [set pcolor 55 ] ]
;
;      if added-self + added-northwest >= favorability-need
;      and
;      (any? turtles-here)
;      and
;      added-self >= favorability-threshold [ask patch-at -1 1 [set pcolor 55 ] ]
;
;      if any? neighbors with [ pcolor = 55 ]
;      and
;      (any? turtles-here)
;      and
;      pbc >= favorability-threshold
;      [set pcolor 55]
;    ]
;;  ]
;  ask turtles [
;;    if one-of neighbors with [ pcolor = 55 ]
;    if any? neighbors with [ pcolor = 55 ]
;    and
;    (any? turtles-here)
;    and
;    pbc >= favorability-threshold
;    [hatch-investors 1 [set color 105 set shape "tree"]]
;    if any? investors-here [die]
;  ]
;end




;
; sweep-test
;
; this is an automated parameter sweeping test
; it runs num-tests interations of the various configurations
; and prints results to the console
;
;Least Favorable
;  set growth-capacity 8
;  set investment-limit-radius 1
;  set num-turtles 25
;  set favorability-threshold 2
;  set favorability-need 4
;  set level-of-competition 1

;Reasonable Scenario
;  set growth-capacity 2
;  set investment-limit-radius 1
;  set num-turtles 25
;  set favorability-threshold 1
;  set favorability-need 2
;  set level-of-competition 2

;Most Favorable
;  set growth-capacity 0
;  set investment-limit-radius 5
;  set num-turtles 700
;  set favorability-threshold 0
;  set favorability-need 0
;  set level-of-competition 9

;to sweep-test
  ;
  ; setup the configuration
  ;
;;  set growth-capacity 1
;;  set investment-limit-radius 5
;;  set num-turtles 700
;;  set favorability-threshold 0
;;  set favorability-need 0
;;  set level-of-competition 9


;  let num-tests 10
;  let i 0
;
;  set i 0
;  while [i <= 10]
;    [
;      setup
;      print (Invested-parcels)
;      set i (i + 1)
;    ]
;end
@#$#@#$#@
GRAPHICS-WINDOW
236
13
747
454
16
13
15.2
1
10
1
1
1
0
1
1
1
-16
16
-13
13
1
1
1
Months
15.0

BUTTON
3
10
66
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
756
198
1046
372
Time vs. Invested Parcels
Time (clicks)
Invested Parcels
0.0
360.0
0.0
654.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plotxy ticks count patches with [green-infrastructure-practiced = true]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     