globals 
[
  all-tags main-tags lesser-tags randomized-list1 plot-pens
  sequence-list init-amt-list stage1-amt-list stage2-amt-list   
  actual-amt-list detection-list true-signal-list false-signal-list
]
patches-own [psequence pcomplimentary place-check]
turtles-own [sequence complimentary bound]
breed [polymerase a-polymerase]
breed [mRNA a-mRNA]
breed [cDNA a-cDNA]

;;;;;;;;;;;;;;;;;;;;; General Setup ;;;;;;;;;;;;;;;;;;;;;
to setup
  set-lists
  setup-all-tags-list
  turtle-setup
  world-setup
end
to set-lists
  set sequence-list []
  set init-amt-list []
  set stage1-amt-list []
  set stage2-amt-list []
  set actual-amt-list []
  set detection-list []
  set true-signal-list []
  set false-signal-list []             
end
;;;;;;;;;;;;;;;;;;;;; Turtle Setup ;;;;;;;;;;;;;;;;;;;;;
;this subroutine is long because it includes the methods to make each of the three distributions
to turtle-setup
    clear-turtles
    reset-ticks
    set-current-plot "Component-Amounts"
    clear-plot
    set plot-pens []
    make-plot-pens
  
    if Distribution = "Power-Law"
    [
       ;set randomized-list1 [8 4 9 15 5 7 0 1 14 10 11 6 2 13 3 12]
       ; I abandoned the randomized list after trying to format output by hand.
       ; It is much easier if all turtles with a given initial amount are located next to each other in a list.
       
       set randomized-list1 [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]
       
       ; this loop is used to calculate the norm-factor
       ;the norm-factor is used to normalize the distribution so that the given 'initial-amount' of turtles is created
       let make-number 0
       let i 0   ; i is used at as an index counter
       let j 0   ; j is used to sum the total amount of turtles that would be created without the norm-factor
       let norm-factor 1
       repeat num-comp-used
       [
           set make-number ( ( i + 1 ) ^ ( - alpha ) )     
           set j ( j + make-number)     
           set i ( i + 1 )
       ]
       set norm-factor ( initial-amount / j)
       
       ; this creates the actual distribution
       set i 0   
       set make-number 0
       ; this dummy list was added after I had a hard time initializeing the list sucessfully
       ; it contains the amounts of each sequence of turtle that should be created
       let dummy [] 
    
       foreach randomized-list1
       [
             set make-number ceiling ( norm-factor * ( (i + 1) ^ ( - alpha )) )
             ;show (word "make-number:" make-number " norm-factor:" norm-factor " num-comp-used:" num-comp-used " alpha:" alpha)
             if i = 0 
             [
               set dummy fput make-number dummy
               ;set sequence-list [ ["A" "C" ] ]  ; this is left here in case I ever switch back to the randomized list
               set sequence-list [ ["C" "C"] ]
               set init-amt-list dummy ;item 0 init-amt-list
             ]  
             
             if i < num-comp-used and i > 0
             [
               set dummy fput make-number dummy
               set init-amt-list dummy
               set sequence-list fput (item ? all-tags) sequence-list    
             ]
             
             if i >= num-comp-used [set make-number 0]                
             ;show (word "i:" i " ?:" ? " make-number:" make-number)
             
             create-cDNA make-number
             [
                  setxy random-xcor random-ycor
                  set sequence item ? all-tags
                  find-complimentary
                  set color white
                  set bound 0 ; bound=0 is unbound, bound=1 is specific binding, bound=2 is non-specific, bound=3 is dimer
             ]
             set i ( i + 1 )
          ]
          set sequence-list reverse sequence-list
          set init-amt-list reverse init-amt-list 
          show (word "Sequences Used:" sequence-list)
          show (word "Initial Amounts:" init-amt-list)     
    ]
    
    ; a lot of this code is similar to the Power-Law distribution so most of the comments are there 
    if Distribution = "Bimodal"
    [
          ;set randomized-list1 [8 4 9 15 5 7 0 1 14 10 11 6 2 13 3 12]
          set randomized-list1 [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]
          
          ; this calculates the number of components used in each mode
          let num-comp-mode1 floor ( num-comp-used / 2)
          let num-comp-mode2 ceiling ( num-comp-used / 2)
          
          ; this calculates the amount of turtles that should be created for sequences in the smaller mode.
          let conc-mode2 ceiling ( initial-amount / ( alpha * num-comp-mode1 + num-comp-mode2 ) )
          ;show (word "num-comp-mode1:" num-comp-mode1 " num-comp-mode2:" num-comp-mode2 " conc-mode2:" conc-mode2)
          
          let make-number 0
          let i 0
          let dummy []
          
          ; for each sequence calculate how many turtles to create
          foreach randomized-list1
          [
                ;calculate how many turtles to create for this particular sequence
                if i <   num-comp-mode1 [ set make-number (alpha * conc-mode2) ] ; this sets the concentration of turtles
                if i >=   num-comp-mode1 and i <= num-comp-used [ set make-number conc-mode2 ]
                if i >=  num-comp-used [set make-number 0]
                
                if i = 0 
                [
                  set dummy fput make-number dummy
                  ;set sequence-list [ ["A" "C" ] ]
                  set sequence-list [ ["C" "C" ] ]
                  set init-amt-list dummy ;item 0 init-amt-list
                ]  
                ; this makes all the turtles for mode 1
                if i < num-comp-used and i > 0
                [
                  set dummy fput make-number dummy
                  set init-amt-list dummy ;fput make-number init-amt-list
                  set sequence-list fput (item ? all-tags) sequence-list    
                ]    
                      
                ;show (word "i:" i " ?:" ? " make-number:" make-number)
                create-cDNA make-number
                [
                     setxy random-xcor random-ycor
                     set sequence item ? all-tags
                     find-complimentary
                     set color white
                     set bound 0 ; bound=0 is unbound, bound=1 is specific binding, bound=2 is non-specific, bound=3 is dimer
                ]
                set i ( i + 1 )
          ]
          set sequence-list reverse sequence-list
          set init-amt-list reverse init-amt-list 
          show (word "Sequences Used:" sequence-list)
          show (word "Initial Amounts:" init-amt-list)   
    ]
    
    ; a lot of this code is similar to the Power-Law distribution so most of the comments are there
    if Distribution = "Uniform"
    [
          ;set randomized-list1 [8 4 9 15 5 7 0 1 14 10 11 6 2 13 3 12]
          set randomized-list1 [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]
          let i 0
          let dummy []
          foreach randomized-list1
          [
                
                let make-number floor (initial-amount / num-comp-used)
                
                if i = 0 
                [
                  set dummy fput make-number dummy
                  ;set sequence-list [ ["A" "C" ] ]
                  set sequence-list [ ["C" "C" ] ]
                  set init-amt-list dummy ;item 0 init-amt-list
                ]         
                
                if i < num-comp-used and i > 0 [
                  set init-amt-list fput make-number init-amt-list
                  set sequence-list fput (item ? all-tags) sequence-list
                ]     
                if i >= num-comp-used [set make-number 0]   
                create-cDNA make-number
                [
                  setxy random-xcor random-ycor
                  set sequence item ? all-tags
                  find-complimentary
                  set color white
                  set bound 0 ; bound=0 is unbound, bound=1 is specific binding, bound=2 is non-specific, bound=3 is dimer
                ]
                set i (i + 1)
          ]
          set sequence-list reverse sequence-list
          set init-amt-list reverse init-amt-list 
          show (word "Sequences Used:" sequence-list)
          show (word "Initial Amounts:" init-amt-list)
    ]
    make-polymerase    
end
; polymerase don't need a special distribution or sequence
; they just need to be present during the amplification stage
to make-polymerase
    create-polymerase amount-of-polymerase
    [
      setxy random-xcor random-ycor
      set sequence ["-" "-"]
      set color red
      set bound 0
    ]
end

;;;;;;;;;;;;;;;;;;;;;   Sequences Setup  ;;;;;;;;;;;;;;;;;;;;;

;; Creates a list of all possible sequences (of length 2 with 4 nucleotides)
to setup-all-tags-list
  set all-tags []
  let tag-elements ["C" "G" "A" "T"] ; these are the four nucleotides used in DNA
  foreach tag-elements
  [
    let i ?
    foreach tag-elements [
      let j ?
      set all-tags fput (list i ?) all-tags
     ]
  ]
  ;; as a result of using FPUT the result is in backwards order
  set all-tags reverse all-tags
  ;show all-tags
end
; this 
to find-complimentary
  set complimentary []
  foreach sequence
  [
      if ? = "C" [set complimentary fput "G" complimentary]
      if ? = "G" [set complimentary fput "C" complimentary]
      if ? = "A" [set complimentary fput "T" complimentary]
      if ? = "T" [set complimentary fput "A" complimentary]
  ]
  set complimentary reverse complimentary
end
;;;;;;;;;;;;;;;;;;;;;   Patches Setup  ;;;;;;;;;;;;;;;;;;;;;
; makes all the patches in the world blank
to world-setup
   clear-patches
   ask patches [set psequence ["-" "-"]]
end
; only 16 patches will be used as microarray patches
; this is used to determine their location and their sequence
to array-setup
  ; these variables are used to determine the position of each microarray patch
  let upper-x (4 * (gap + 1))
  let upper-y (4 * (gap + 1))
  let sequence-length 2
  let placeholder 0 
  let start-x (- sequence-length - gap)
  let start-y (- sequence-length - gap)
  
  if arangement = "Left-to-Right"
  [
      LET X start-x
      WHILE [ X < (upper-x + start-x)]
      [
       LET Y start-y
       WHILE [ Y < (upper-y + start-y)]
       [
          ; (x - start-x) this shows how far right of the starting square we are. all patches counted.
          ; (x - start-x) / (gap + 1) this shows how many array patches we are to the right of the starting square.
          ; (Y - start-y) this shows how far above the starting square we are. all patches counted.
          ; (upper-x / (gap + 1) ) this shows how many array tiles we have in one row\\
          
          ; placeholder is used to determine which sequence is pulled out of the list 'all-tags'
          set placeholder ( (x - start-x) / (gap + 1) + ((upper-x / (gap + 1) ) * (Y - start-y) ) / (gap + 1))
          
          ASK PATCH X Y 
          [ 
             set pcolor yellow 
             set place-check placeholder
             set psequence item (place-check) all-tags
             find-pcomplimentary
          ]
          SET Y (Y + gap + 1)
       ]
       SET X (X + gap + 1)
      ]
  ]
  
  if arangement = "Random-Order"
  [
      let dummy-list all-tags
      let randomvar 0
      
      
      LET X start-x
      WHILE [ X < (upper-x + start-x)]
      [
       LET Y start-y
       WHILE [ Y < (upper-y + start-y)]
       [
          ; (x - start-x) this shows how far right of the starting square we are. all patches counted.
          ; (x - start-x) / (gap + 1) this shows how many array patches we are to the right of the starting square.
          ; (Y - start-y) this shows how far above the starting square we are. all patches counted.
          ; (upper-x / (gap + 1) ) this shows how many array tiles we have in one row\\
          
          ; placeholder is used to determine which sequence is pulled out of the list 'all-tags'
          set placeholder ( (x - start-x) / (gap + 1) + ((upper-x / (gap + 1) ) * (Y - start-y) ) / (gap + 1))
          
          ASK PATCH X Y 
          [ 
             set pcolor yellow 
             set randomvar random (length dummy-list)
             set place-check randomvar
             set psequence item (place-check) dummy-list
             find-pcomplimentary
             set dummy-list remove-item randomvar dummy-list    
          ]
          SET Y (Y + gap + 1)
       ]
       SET X (X + gap + 1)
      ]
  ]
end
; this is just like the find-complimentary for turtles, but the letter p is in front of each varible (for patch)
to find-pcomplimentary
  set pcomplimentary []
  foreach psequence
  [
      if ? = "C" [set pcomplimentary fput "G" pcomplimentary]
      if ? = "G" [set pcomplimentary fput "C" pcomplimentary]
      if ? = "A" [set pcomplimentary fput "T" pcomplimentary]
      if ? = "T" [set pcomplimentary fput "A" pcomplimentary]
  ]
  set pcomplimentary reverse pcomplimentary
end

;;;;;;;;;;;;;;;;;; Main Program ;;;;;;;;;;;;;;;;;;;;;;;;;;
to go
  plot-components
  if ticks = 0 [initial-analysis]
  ifelse ticks <= time-limit-stage1
  [ 
    move-turtles1  
    amplify  
    tick
  ]
  [
    ifelse ticks < (time-limit-stage1 + time-limit-stage2)
    [
      move-turtles2
      tick
    ]
    [
      ask turtles with [bound = 0] [die]
      ask turtles with [bound = 3] [die]
      stage2-analysis
      plot-components 
      if Save-Output? = true [print-everything]
      stop
    ]
  ]
  if ticks = time-limit-stage1 [end-stage1]
end
to end-stage1
    ask polymerase [die]
    stage1-analysis
    if Stage1-Alert? = true 
    [
      display
      user-message ( "Amplification stage complete" )
    ]
    array-setup
end
; this moves all turtles not including binding rules
to move-turtles1
  ask turtles 
  [
    left random 720
    jump random 5
  ]
end
; this moves all turtles including binding rules 
to move-turtles2
  ask turtles with [bound = 0]
  [ 
    left random 720
    jump random 5
    if random 100 < Bind-chance-specific [specific-binding]
    if random 100 < Bind-chance-nonspecific [nonspecific-binding]
    strand-strand-binding
  ]
  ask turtles with [bound = 1]
  [
    unbind-specific
  ]
  ask turtles with [bound = 2]
  [
    unbind-nonspecific
  ]
  ask turtles with [bound = 3]
  [
    left random 720
    jump random 5
    unbind-strand-strand
  ]
end
; this is used to create more turtles with a given sequence
to amplify
  ask polymerase 
  [
    ask cDNA-here 
    [
      ; l
      ifelse Linear-Amplification? = TRUE
      [
         ; with linear-amplification mRNA cannot further amplify themselves
         ; only the initial concentration of cDNA will create more strands
         hatch-mRNA 1 
         [
           set color blue 
         ]
      ]
      [
         hatch-cDNA 1 
         [
            ; with non linear-amplification more cDNA is created so that it can further amplify itself
            ; NOTE: THIS IS NOT BIOLOGICALLY ACURATE (cDNA does not create more cDNA)
            ; this was just the easiest way to write the code.
            set color white
         ]
      ]
    ]
  ]
  
end

; all these specific/nonspecific binding/unbinding subroutines are pretty self explanitory.
to specific-binding  
  ;if complimentary = [psequence] of patch-here [set bound 1 ]
  let i 0
  let match 0
  let sequence-length 2
  let dummy ([psequence] of patch-here)
  
  repeat sequence-length
  ;foreach complimentary dummy
  [   
    if (item i complimentary) = (item i dummy) [set match (match + 1)]
    set i (i + 1)
  ]
  if match = 2 [set bound 1 set color green]
end
to nonspecific-binding
  let i 0
  let match 0
  let sequence-length 2
  let dummy ([psequence] of patch-here)
  
  repeat sequence-length
  ;foreach complimentary dummy
  [   
    if (item i complimentary) = (item i dummy) [set match (match + 1)]
    set i (i + 1)
  ]
  if match = 1 [set bound 2 set color orange]
end
; strand-strand binding was feature that was eventually left out of the final code
to strand-strand-binding
end
to unbind-specific
  if random 100 < Unbind-chance-specific [ set bound 0 set color white]
end
to unbind-nonspecific
   if random 100 < Unbind-chance-nonspecific [ set bound 0 set color white]
end
to unbind-strand-strand
end

;;;;;;;;;;;;;;;;;; Plotting ;;;;;;;;;;;;;;;;;;;;;;;;;;
to make-plot-pens
  set-current-plot "Component-Amounts"
  let i 0
  repeat num-comp-used
  [ 
    create-temporary-plot-pen ( word "component-" i )
    set plot-pens lput ( word "component-" i ) plot-pens
    set i ( i + 1 )
  ]  
end
to plot-components 
  set-current-plot "Component-Amounts"
  let i 0
  let sequence-marker 0
  let this-sequence []
  
  repeat num-comp-used
  [        
         set sequence-marker (item i randomized-list1)
         set this-sequence (item sequence-marker all-tags)
         ;show (word "i:" i " sequence-marker:" sequence-marker " this-sequence:" this-sequence)
         
         set-current-plot-pen (item i plot-pens)
         plot count turtles with [sequence = this-sequence]
         set i ( i + 1)
  ]
  
end
;;;;;;;;;;;;;;;;;; Analysis ;;;;;;;;;;;;;;;;;;
to initial-analysis
    ; this calculates the initial amount of each strand containing each sequence
    let i 0
    let new-amt 0
    let ratio 0
    set init-amt-list []
    foreach all-tags
    [
      set new-amt (count turtles with [sequence = ?])
      set init-amt-list fput new-amt init-amt-list
      set i (i + 1)
    ]
    set init-amt-list reverse init-amt-list
    ; This prints the data generated to the Command Center box if Show-Output? is true (1 of 3 outputs)
    If Show-Output? = True
    [
        print "Results"
        print (word "All Sequences:" all-tags)
        print (word "Initial Amounts" init-amt-list)
    ]
    
end
to stage1-analysis
    ; this calculates the new amounts of strands containing each sequence after amplification 
    let i 0
    let new-amt 0
    let ratio 0
    foreach all-tags
    [
      set new-amt (count turtles with [sequence = ?])
      set stage1-amt-list fput new-amt stage1-amt-list
      set i (i + 1)
    ]
    ; since I was adding things to the front of the list (instead of the back), the list needs to be reversed to be acurate
    set stage1-amt-list reverse stage1-amt-list
    
    ; This prints the data generated to the Command Center box if Show-Output? is true (2 of 3 outputs)
    If Show-Output? = True
    [
        print (word "Amount After Amplification" stage1-amt-list)
    ]
end
to stage2-analysis
    let detection 0
    let true-signal 0
    let false-signal 0
    let actual-amt 0
    
    foreach all-tags
    [
      set true-signal 0
      set false-signal 0
      set actual-amt (count turtles with [sequence = ?])
      
      ask patches with [pcomplimentary = ?] [set detection count turtles-here]
      ask patches with [pcomplimentary = ?] [ask turtles-here with [bound = 1] [ set true-signal (true-signal + 1)]]
      ask patches with [pcomplimentary = ?] [ask turtles-here with [bound = 2] [ set false-signal (false-signal + 1)]]
      
      set actual-amt-list fput actual-amt actual-amt-list
      set detection-list fput detection detection-list
      set true-signal-list fput true-signal true-signal-list
      set false-signal-list fput false-signal false-signal-list
      ;print ( word "seq:" ? " actual:" actual-amt " detection:" detection " true-signal:" true-signal " false-signal:" false-signal)
    ]
    ; since I was adding things to the front of the list (instead of the back), all the lists need to be reversed to be acurate
    set actual-amt-list reverse actual-amt-list
    set detection-list reverse detection-list
    set true-signal-list reverse true-signal-list
    set false-signal-list reverse false-signal-list 
    
    ; This prints the data generated to the Command Center box if Show-Output? is true (3 of 3 outputs)
    if Show-Output? = true
    [
        print (word "Amount Bound:" actual-amt-list)
        print (word "Amount Detected:" detection-list)
        print (word "True Signal:" true-signal-list)
        print (word "False Signal:" false-signal-list)
    ]
end
to print-everything
    ; this writes all the data generated to a file of the user's specification
    file-open user-new-file      
    file-print "Results"
    file-print (word "All Sequences:" all-tags)
    file-print (word "Initial Amounts:" init-amt-list)
    file-print (word "Amount After Amplification:" stage1-amt-list)
    file-print (word "Amount Bound:" actual-amt-list)
    file-print (word "Amount Detected:" detection-list)
    file-print (word "True Signal:" true-signal-list)
    file-print (word "False Signal:" false-signal-list)
    file-flush    
    file-close
end
@#$#@#$#@
GRAPHICS-WINDOW
498
10
844
377
10
10
16.0
1
10
1
1
1
0
1
1
1
-10
10
-10
10
0
0
1
ticks
BUTTON
356
38
480
71
NIL
setup\\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
356
72
480
105
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
SLIDER
12
86
150
119
initial-amount
initial-amount
100
1000
320
10
1
NIL
HORIZONTAL
SLIDER
167
201
339
234
time-limit-stage2
time-limit-stage2
50
1000
300
1
1
NIL
HORIZONTAL
TEXTBOX
14
23
132
41
cDNA\\n
11
0.0
1
TEXTBOX
12
273
162
291
Array\\n
11
0.0
1
SLIDER
7
289
150
322
gap
gap
0
2
1
1
1
NIL
HORIZONTAL
MONITOR
846
232
967
277
Unbound strands
( count (cDNA with [bound = 0]) + count (mRNA with [bound = 0]))
17
1
11
MONITOR
847
279
967
324
Specific-binding
count (turtles with [bound = 1])
17
1
11
MONITOR
848
326
968
371
nonspecific binding
count (turtles with [bound = 2])
17
1
11
CHOOSER
7
325
150
370
Arangement
Arangement
"Random-Order" "Left-to-Right"
1
MONITOR
969
232
1092
277
nonspecific/specific
precision ((count (turtles with [bound = 2] )) / \\n(count (turtles with [bound = 1]))) 3
17
1
11
TEXTBOX
168
185
318
203
Array Binding\\n
11
0.0
1
SLIDER
167
303
339
336
Unbind-chance-specific
Unbind-chance-specific
0
10
3
1
1
NIL
HORIZONTAL
SLIDER
167
337
339
370
Unbind-chance-nonspecific
Unbind-chance-nonspecific
0
20
10
1
1
NIL
HORIZONTAL
SLIDER
167
235
339
268
Bind-chance-specific
Bind-chance-specific
80
100
95
1
1
NIL
HORIZONTAL
SLIDER
167
269
339
302
Bind-chance-nonspecific
Bind-chance-nonspecific
0
60
10
1
1
NIL
HORIZONTAL
TEXTBOX
169
24
330
52
Amplification
11
0.0
1
CHOOSER
12
40
150
85
Distribution
Distribution
"Power-Law" "Bimodal" "Uniform"
2
SLIDER
12
155
150
188
alpha
alpha
1
10
4
0.5
1
NIL
HORIZONTAL
SLIDER
12
120
150
153
num-comp-used
num-comp-used
0
16
16
1
1
NIL
HORIZONTAL
TEXTBOX
12
189
182
247
ALPHA\\n\\n
11
0.0
1
PLOT
846
10
1092
230
Component-Amounts
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true
SLIDER
167
39
339
72
time-limit-stage1
time-limit-stage1
0
1000
300
1
1
NIL
HORIZONTAL
SLIDER
167
73
339
106
amount-of-polymerase
amount-of-polymerase
0
50
20
1
1
NIL
HORIZONTAL
SWITCH
167
107
339
140
Linear-Amplification?
Linear-Amplification?
0
1
-1000
SWITCH
358
302
482
335
Save-Output?
Save-Output?
1
1
-1000
SWITCH
357
268
482
301
Stage1-Alert?
Stage1-Alert?
1
1
-1000
SWITCH
358
337
482
370
Show-Output?
Show-Output?
0
1
-1000
TEXTBOX
14
11
164
29
SETUP
13
0.0
1
TEXTBOX
169
10
319
28
RUN OPTIONS
13
0.0
1
TEXTBOX
357
254
482
272
OUTPUT AND ALERTS\\n
11
0.0
1
TEXTBOX
11
202
161
241
Power-Law: scaling exponent\\nBimodal: mode1/mode2\\nUniform: nothing
10
0.0
1
@#$#@#$#@

WHAT IS IT?
-----------
Microarrays are a powerful tool for detecting the quantities of gene expression in an organism. They are the only mechanism that can simultaneously detect every type of gene being expressed. However, the error in the process is not widely understood, and microarrays have received a reputation for inaccuracy.
This model shows how error enters the microarray process attempts to give the user a more intuitive feel about the limitations and advantages to using microarrays. 
This model is based off of (as yet unpublished) work by Patrick McMullen and Luis Amaral.
HOW IT WORKS
------------
Stage 1: Amplification
The goal of this stage is to amplify the initial signal to the point where it is easily read by the microarray.
During this stage there are three types of turtles: polymerase, cDNA and mRNA. Every time a cDNA and a polymerase are on the same patch a mRNA strand created with the same sequence as the cDNA used to create it. After the first time limit runs out, all the polymerase dies.
The important point of this sequence is that random error enters the model based off of the spatial location of the turtles. If there are less turtles 
Stage 2: Microarray binding
During this stage the microarray patches are created. There are no polymerase molecules, so no more cDNA is being created. If a cDNA strand has a complimentary sequence that is similar to the sequence of the patch, then they can bind. If the sequences match exactly then the binding is specific, if they only partially match, than the binding is non-specific. When this stage is over all unbound strands are destroyed.

HOW TO USE IT
-------------
The Interface is divided into several distinct blocks. The first column allows you to change the setup conditions for cDNA as well as for the microarray itself. The second column allow you to change the Run Options that change the rules of the system. The third column contains the 'Setup' and 'Go' buttons and the options for Outputs and Alerts.
- SETUP
    - cDNA
	Distribution - There are three options to generate a concentration distribution 	of sequences used. With Power-law, one sequence is initially present at a 		significantly higher amount and each following sequence has a smaller amount 		than the previous sequence. With Bimodal distribution, half of the sequences 		will have a high initial amount (mode1) and half the sequences will have a 		low initial amount (mode2). For uniform, all the sequences will have the 		same initial amount.
	initial-amount - This changes the initial number of cDNA strands initially		placed into the system
	num-comp-used - This changes the number of sequences used to create the 		distribution of cDNA. 
	alpha - this is a variable that allows you to tune the type of sequence  		distribution. The role alpha plays depends on the type of distribution chosen 		above. With Power law alpha is the scaling exponent (amount = C * X ^ alpha). 		With bimodal alpha is the ratio of the larger mode to the smaller mode. With 		uniform distribution alpha plays no role.  
    - Microarray
	gap - this allows you to set how many blank patches are placed between patches 		in the array
	Arangement - this allows you to choose if the patches in the microarray are 		placed in a random order or in the order of the sequence list.

- RUN OPTIONS
     - Amplification 
	time-limit-stage1 - this controls how many ticks the amplification stage will 		run.
	amount-of-polymerase - this controls how many polymerase are added to the 
	(poymerase allow cDNA to create mRNA strands)
	Linear-Amplification? - If it is turned on then the sequences created by 		amplification cannot be used to create more sequences (amplification is 		linear). If it is turned on they can (amplification is exponential). 			In this case, exponential amplification isn't biologically acurate, but the 		visualization was nice so I left it in.
     - Microarray Binding
	time-limit-stage2 - this controls how many ticks the strands have to bind the 		microarray before they are destroyed.
	Bind-chance-specific - the chance that a strand on a patch with it's exact 		complementary sequence will bind to that patch. 
	Unbind-chance-specific - the chance that a specifically bound strand will 		spontaniously unbind.
	Bind-chance-non-specific - the chance that a strand on a patch with one amino 		acid in it's sequence matching the complementary sequence will bind to that 		patch. 
	Unbind-chance-non-specific - the chance that a non - specifically bound strand 		will spontaniously unbind.
- OUTPUTS AND ALERTS
	Stage1-Alert? - Will display a message window alerting you when the 			amplification stage is over
	Save-Output? - Will save the data generated to a text file of your 			specification
	Show-Output? - will display the data generated in the command center
THINGS TO NOTICE
----------------
Make sure you have Show-Output? set to 'On'. 
While the only way to increase the acuracy of the True Signal is to have more strands after the amplification stage, the magnitude of the False-signal also increases due to increased non-specific binding. Dispite this trend, the signal to noise ratio is improved with a larger the number of strands.
Things that increase noise in the setup: lowering the inital amount, increasing the number of components used (just because they will lower the initial amounts you 
Things that increase noise in the amplification stage: decreaseing the time limit or decreasing the amount of polymerase (Changing the amplification from linear to nonlinear is just for fun)
Things that increase noise in the microarray binding stage: decreasing the time limit,  bind-chance specific, or unbind-chance-nonspecific; increasing bind-chance-nonspecific or unbind-chance-specific.

THINGS TO TRY
-------------
The quickest way to see different error distributions is with the 'Bimodal' distribution. Change the initial amounts and the ratio between starting amounts (with the 'alpha' slider).
EXTENDING THE MODEL
-------------------
A feature that would really help the user visualize what this model is trying to acomplish is a plot showing the distribution of each sequence amount after each stage.
Another great feature would be a format of output that could be put directly into a spreadsheet and graphed. 
Plenty of embelishments could be added that make the model more acurately reflect the physical processes involved. I don't think these are really necessary. However, if such features are added, then they should reflect aditional errors that could occur such as strand-strand binding or transcription errors in the amplification stage.
NETLOGO FEATURES
----------------
The main technical challenge while programming this model was in managing lists.
The sequences were in lists, the amounts of each sequence at each stage were in lists, virtually every changing variable in this system was managed in a list. 
The create-temporary-plot-pen feature was also used in this model to only plot the amounts of components that were present.

CREDITS AND REFERENCES
----------------------
By Peter Winter
Thanks to Patrick McMullen and Luis Amaral for providing sugestions and direction to this project.



@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="stage1errorAmt640" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>item 0 stage1-amt-list</metric>
    <metric>item 1 stage1-amt-list</metric>
    <metric>item 2 stage1-amt-list</metric>
    <metric>item 3 stage1-amt-list</metric>
    <metric>item 4 stage1-amt-list</metric>
    <metric>item 5 stage1-amt-list</metric>
    <metric>item 6 stage1-amt-list</metric>
    <metric>item 7 stage1-amt-list</metric>
    <metric>item 8 stage1-amt-list</metric>
    <metric>item 9 stage1-amt-list</metric>
    <metric>item 10 stage1-amt-list</metric>
    <metric>item 11 stage1-amt-list</metric>
    <metric>item 12 stage1-amt-list</metric>
    <metric>item 13 stage1-amt-list</metric>
    <metric>item 14 stage1-amt-list</metric>
    <metric>item 15 stage1-amt-list</metric>
    <enumeratedValueSet variable="time-limit-stage2">
      <value value="500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Arangement">
      <value value="&quot;Left-to-Right&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-amount">
      <value value="640"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="amount-of-polymerase">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Distribution">
      <value value="&quot;Uniform&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Linear-Amplification?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="gap">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit-stage1">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Save-Output?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-specific">
      <value value="95"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-comp-used">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="alpha">
      <value value="4"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-specific">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Stage1-Alert?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Stage1ErrorAmt160Timelimit50" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>item 0 stage1-amt-list</metric>
    <metric>item 1 stage1-amt-list</metric>
    <metric>item 2 stage1-amt-list</metric>
    <metric>item 3 stage1-amt-list</metric>
    <metric>item 4 stage1-amt-list</metric>
    <metric>item 5 stage1-amt-list</metric>
    <metric>item 6 stage1-amt-list</metric>
    <metric>item 7 stage1-amt-list</metric>
    <metric>item 8 stage1-amt-list</metric>
    <metric>item 9 stage1-amt-list</metric>
    <metric>item 10 stage1-amt-list</metric>
    <metric>item 11 stage1-amt-list</metric>
    <metric>item 12 stage1-amt-list</metric>
    <metric>item 13 stage1-amt-list</metric>
    <metric>item 14 stage1-amt-list</metric>
    <metric>item 15 stage1-amt-list</metric>
    <enumeratedValueSet variable="Stage1-Alert?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Show-Output?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="amount-of-polymerase">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-amount">
      <value value="160"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Arangement">
      <value value="&quot;Left-to-Right&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Save-Output?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Linear-Amplification?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-comp-used">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="gap">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-specific">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-specific">
      <value value="95"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit-stage1">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit-stage2">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Distribution">
      <value value="&quot;Uniform&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="alpha">
      <value value="4"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Fulldetectionuniform320" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>item 0 detection-list</metric>
    <metric>item 1 detection-list</metric>
    <metric>item 2 detection-list</metric>
    <metric>item 3 detection-list</metric>
    <metric>item 4 detection-list</metric>
    <metric>item 5 detection-list</metric>
    <metric>item 6 detection-list</metric>
    <metric>item 7 detection-list</metric>
    <metric>item 8 detection-list</metric>
    <metric>item 9 detection-list</metric>
    <metric>item 10 detection-list</metric>
    <metric>item 11 detection-list</metric>
    <metric>item 12 detection-list</metric>
    <metric>item 13 detection-list</metric>
    <metric>item 14 detection-list</metric>
    <metric>item 15 detection-list</metric>
    <enumeratedValueSet variable="Stage1-Alert?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Show-Output?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="amount-of-polymerase">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-amount">
      <value value="320"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Arangement">
      <value value="&quot;Left-to-Right&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Save-Output?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Linear-Amplification?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-comp-used">
      <value value="16"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="gap">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Unbind-chance-specific">
      <value value="3"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-nonspecific">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Bind-chance-specific">
      <value value="95"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit-stage1">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit-stage2">
      <value value="300"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Distribution">
      <value value="&quot;Uniform&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="alpha">
      <value value="4"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
