globals [
  temp-c-price
  temp-c-seller-rating
  temp-c-shipping
  total-sellers
  count-A
  count-B
  count-C
  count-D
  count-E
  count-F
  count-G
  count-H
  count-I
  count-J
]

breed [sellers seller]
breed [buyers buyer]

sellers-own [
  inventory
  cost                                              ; product cost
  profit-rate                                       ; profit rate of the product
  price                                             ; price of the product
  sales-volume                                      ; cout of sold products
  revenue                                           ; revenue
  age                                               ; how many days the seller has been active in the market
  profit                                            ; profit
  rating                                            ; feedback ratings from buyers, +1 = positive, -1 = negative, 0 = neutral
  utility
  star-level                                        ; proportional to the feedback rating
  alive?
]

buyers-own [
  rating                                            ; feedback rating from sellers, +1 = positive, -1 = negative, 0 = neutral
  c-price                                           ; price coefficient in utility function
  c-seller-rating                                   ; seller-rating coefficient utility function
  c-shipping                                        ; shipping coefficient utility function
]

;********************INITIALIZE********************

to setup
  clear-all
  
  ;; create existing sellers
  set-default-shape sellers "computer server"
  create-sellers existing-sellers
  [
    setxy random-xcor random-ycor
    set color blue
    set age random 10000
    set rating random 10000
    ;set size 1 + rating * 0.01
    ;; initialize
    set sales-volume 0
    set revenue 0
    set profit 0
    set inventory random 1000
    set cost 20
    set profit-rate random 20
    set alive? true
  ]
  
  ;; create existing buyers
  set-default-shape buyers "computer workstation"
  create-buyers number-of-buyers
  [
    setxy random-xcor random-ycor
    set c-price random 100 / (100 * 20)
    set c-seller-rating random 100 / (100 * 1000)
    set c-shipping random 100 / (100 * 25)    
  ]
;  update-variables
  ;do-plots
end

;;********************RUN********************
to go
  
  ;; sellers not doing well leave the market
  
  ;; new sellers enter the market
  create-sellers new-sellers
  [
    set size 1
    setxy random-xcor random-ycor
    set color red
    set age 0
    set rating 0
    set sales-volume 0
    set revenue 0
    set profit 0
    set inventory random 1000
    set cost 20
    set profit-rate random 20
    set alive? true
  ]
  
  ;; sellers adjust their price
  ask sellers
  [
    adjust-price
  ]
  
  ask n-of demand buyers
  [
    ask sellers
    [
      set utility -10000
    ]
    surf-online
    make-a-choice
;    give-feedback
  ]
  
  update-variables
  ;do-plots
end

to adjust-price
  set price cost * (profit-rate / 100 + 1)
end

;; buyers surf online and randomly pick 4 sellers
to surf-online
  set temp-c-price c-price
  set temp-c-seller-rating c-seller-rating
  set temp-c-shipping c-shipping
  ; show count sellers
  ask n-of choice-set-size sellers with [alive?]
  [
    set utility ( temp-c-price * price + temp-c-seller-rating * rating + temp-c-shipping * (distance myself) + (random 100 / 100))
  ]
end

to make-a-choice
  ask one-of sellers with-max [utility]
  [
    set sales-volume (sales-volume + 1)
    set revenue (revenue + price)
    set profit (profit + cost * profit-rate)
    ;show sales-volume
    set inventory (inventory - 1)
    set size size + 0.01
    ;show inventory
    
    ;; give seller feedback rating
    ifelse random 100 < 98
    [
      set rating (rating + 1)                                  ; buyer satisfied with seller
    ]
    [ 
      if random 50 < 100
      [
        set rating (rating - 1)                               ; buyer not stisfied with seller
      ]
    ]
  ] 
  
end

to update-variables
  ask sellers
  [
    ifelse rating <= 250
    [
      set star-level "A"
    ]
    [
      ifelse rating <= 500
      [
        set star-level "B"
      ]
      [
        ifelse rating <= 1000
        [
          set star-level "C"
        ]
        [
          ifelse rating <= 2000
          [
            set star-level "D"
          ]
          [
            ifelse rating <= 5000
            [
              set star-level "E"
            ]
            [
              ifelse rating <= 5000
              [
                set star-level "F"
              ]
              [
                ifelse rating <= 5000
                [
                  set star-level "G"
                ]
                [
                  ifelse rating < 10000
                  [
                    set star-level "H"
                  ]
                  [
                    ifelse rating < 20000
                    [
                      set star-level "I"
                    ]
                    [
                      set star-level "J"
                    ]
                  ]
                ]                
              ]              
            ]
          ]
        ]
      ]
    ]
  ]
  ask sellers with [age > 100]
  [
    if revenue < 100
    [
      set alive? false
      set color yellow
    ]
  ]
  set total-sellers count sellers with [alive?]
  ;show total-sellers
  set count-A count sellers with [star-level = "A" and alive?]
  set count-B count sellers with [star-level = "B" and alive?]
  set count-C count sellers with [star-level = "C" and alive?]
  set count-D count sellers with [star-level = "D" and alive?]
  set count-E count sellers with [star-level = "E" and alive?]
  set count-F count sellers with [star-level = "F" and alive?]
  set count-G count sellers with [star-level = "G" and alive?]
  set count-H count sellers with [star-level = "H" and alive?]
  set count-I count sellers with [star-level = "I" and alive?]
  set count-J count sellers with [star-level = "J" and alive?]
end

;to do-plots
;  set-current-plot "sellers rating"
;  set-current-plot-pen "1"
;  plot count-A
;  ;show A-sales-volume
;  set-current-plot-pen "2"
;  plot count-B
;  ;show B-sales-volume
;  set-current-plot-pen "3"
;  plot count-C    
;  set-current-plot-pen "4"
;  plot count-D
;  set-current-plot-pen "5"
;  plot count-E    
;  set-current-plot-pen "6"
;  plot count-F    
;  set-current-plot-pen "7"
;  plot count-G    
;  set-current-plot-pen "8"
;  plot count-H
;  set-current-plot-pen "9"
;  plot count-I 
;  set-current-plot-pen "10"
;  plot count-J
;end
@#$#@#$#@
GRAPHICS-WINDOW
205
10
878
704
25
25
13.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
ticks

BUTTON
15
10
78
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
90
10
153
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
15
45
187
78
existing-sellers
existing-sellers
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
15
80
187
113
number-of-buyers
number-of-buyers
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
15
115
187
148
new-sellers
new-sellers
0
10
1
1
1
NIL
HORIZONTAL

SLIDER
15
150
187
183
demand
demand
0
50
50
1
1
NIL
HORIZONTAL

SLIDER
15
185
187
218
choice-set-size
choice-set-size
4
10
4
1
1
NIL
HORIZONTAL

MONITOR
950
10
1027
55
NIL
total-sellers\\n
0
1
11

MONITOR
885
10
942
55
NIL
count-A
0
1
11

MONITOR
885
60
942
105
NIL
count-B
0
1
11

MONITOR
885
110
942
155
NIL
count-C\\n
0
1
11

MONITOR
885
160
942
205
NIL
count-D
0
1
11

MONITOR
885
210
942
255
NIL
count-E
0
1
11

MONITOR
885
260
942
305
NIL
count-F
0
1
11

MONITOR
885
310
942
355
NIL
count-G
0
1
11

MONITOR
885
360
942
405
NIL
count-H
0
1
11

MONITOR
885
410
942
455
NIL
count-I\\n
0
1
11

MONITOR
885
460
942
505
NIL
count-J\\n
170
1
11

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

computer server
false
0
Rectangle -7500403 true true 75 30 225 270
Line -16777216 false 210 30 210 195
Line -16777216 false 90 30 90 195
Line -16777216 false 90 195 210 195
Rectangle -10899396 true false 184 34 200 40
Rectangle -10899396 true false 184 47 200 53
Rectangle -10899396 true false 184 63 200 69
Line -16777216 false 90 210 90 255
Line -16777216 false 105 210 105 255
Line -16777216 false 120 210 120 255
Line -16777216 false 135 210 135 255
Line -16777216 false 165 210 165 255
Line -16777216 false 180 210 180 255
Line -16777216 false 195 210 195 255
Line -16777216 false 210 210 210 255
Rectangle -7500403 true true 84 232 219 236
Rectangle -16777216 false false 101 172 112 184

computer workstation
false
0
Rectangle -7500403 true true 60 45 240 180
Polygon -7500403 true true 90 180 105 195 135 195 135 210 165 210 165 195 195 195 210 180
Rectangle -16777216 true false 75 60 225 165
Rectangle -7500403 true true 45 210 255 255
Rectangle -10899396 true false 249 223 237 217
Line -16777216 false 60 225 120 225

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
