globals
[
  ; variables used to keep track of metabolism in cell
  fooda
  foodb
  foodc
  newprot
  
  ; variables used to keep 
  protein-pens ; a list of all the temporary plot pens
  tries        ; how many attempts the model has made to reach a stable setup.
  
  ; variables used for network analysis
  av-clustering-coef
  component-size          ;; number of turtles explored so far in the current component
  ;giant-component-size    ;; number of turtles in the giant component
  ;giant-start-node        ;; node from where we started exploring the giant component
  
  
  ; for feed forward analysis
  number-of-ff-loops
  number-of-fb-loops
  types-of-ff-loops
  who-in-ff-loops
  who-in-fb-loops
  two-node-ps-feedback
  two-node-ng-feedback
  two-node-dn-feedback
  
  ; to test for robustness
  repeats
  repeats-survived
  try-repeats
]
turtles-own
[
  ;; this is used to mark turtles we have already visited
  ;explored?
  transcription-number
  metabolism
  life-critical
  protein-amt
  check
  clustering-coef
]
 directed-link-breed [positive-edges  positive-edge] ; sjfs
 directed-link-breed [negative-edges  negative-edge] ; dfs
;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup Procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;
to setup
  ca
  set tries 1
  set repeats 1
  set repeats-survived 0
  set try-repeats false
  another-try
end
to another-try
  make-metabolites
  make-turtles
  specialize-turtles
  ;repeat num-edges [make-edges]
  make-edges3
  set protein-pens []
  make-protein-pens
  plot-protein-amount 
end

to make-metabolites
  set fooda 20
  set foodb 30
  set foodc 40
  set newprot 0
  plot-metabolites
end
to make-turtles
  set-default-shape turtles "circle"
  ;set-default-shape links "myarrow"
  crt num-nodes
  [
    set color white
    set protein-amt initial-protein-amt
    set metabolism 0
    set life-critical 0
    set check 0
  ]
  layout-circle turtles max-pxcor - 1
end
to specialize-turtles
  ask turtle 1 [set metabolism 1 set color orange]
  ask turtle 2 [set metabolism 2 set color orange]
  ask turtle 3 [set metabolism 3 set color orange]
  ask turtle 4 [set life-critical 1 set color yellow]
  ask turtle 5 [set life-critical 1 set color yellow]
  ask turtle 6 [set life-critical 1 set color yellow]
end
to rerun-this-setup
    reset-ticks
    ;set tries 1
    set-current-plot "Metabolites"
    clear-plot    
    set-current-plot "Protein-Amounts"
    clear-plot
    set-current-plot "Metabolite-Conversion-Chance"
    clear-plot
    ask turtles [set protein-amt initial-protein-amt]
    set protein-pens []
    make-metabolites
    make-protein-pens
    
end
;;;;;;;;;;;;;;;;;;;;;;
;;; Main Procedure ;;;
;;;;;;;;;;;;;;;;;;;;;;
to go
  ; stop if you've repeated enough
  if tries > 1000
  [
      display
      user-message ( word  "No networks meet your requirements for robustness")
      stop
  ]    
  
  if repeats > 10
  [
        if Show-Notifications? = True
        [
          display
          user-message ( word  "Network survived " repeats-survived " of 10 repeated trials.")
        ]
        
        ; If the network survived a sufficient number of repeats, then stop. If not make new network and try again.
        ifelse repeats-survived >= Repeats-Threshold
        [ stop ]
        [
          reset-ticks
          set-current-plot "Metabolites"
          clear-plot    
          set-current-plot "Protein-Amounts"
          clear-plot
          set-current-plot "Metabolite-Conversion-Chance"
          clear-plot
          clear-links 
          clear-turtles  
          set tries ( tries + 1)
          set repeats 1
          set repeats-survived 0
          set try-repeats false
          another-try
        ]
  ]  
  
  ; time limit check
  if ticks > time-limit
  [
    ; if this is the first time this network survived the time limit, prepare for repeated trials
    ifelse try-repeats = false
    [
      set try-repeats true
      ; since we do 10 trials, there are 9 repeats after the initial sucess.
      ; so I start my repeats counter at 2 and go until it reaches 10
      set repeats 2
      set repeats-survived 1
      ; if the user wants notifications tell him a network survived the time limit.
      if Show-Notifications? = True
      [
        display
        user-message ( word  tries " tries untill network survived. Now checking robustness.")
      ]
      rerun-this-setup
    ]
    ; if this is one of the repeated trials, record sucess, carry on.
    [    
      set repeats (repeats + 1)
      set repeats-survived (repeats-survived + 1)
    ]
  ]
 ; kills the cell if there aren't any life-critical proteins
 if ([protein-amt] of turtle 4) <= 0 or ([protein-amt] of turtle 5) <= 0 or ([protein-amt] of turtle 6) <= 0
 [
    reset-ticks
    set-current-plot "Metabolites"
    clear-plot    
    set-current-plot "Protein-Amounts"
    clear-plot
    set-current-plot "Metabolite-Conversion-Chance"
    clear-plot
    
    ; if this wasn't a repeated trial, try a new network
    if try-repeats = false 
    [
      clear-links 
      clear-turtles  
      set tries ( tries + 1)
      another-try
    ]
    ; if this was a repeated trial, don't record sucess, carry on.
    if try-repeats = true 
    [
      set repeats ( repeats + 1 ) 
      rerun-this-setup
    ]
  ]
    
  ;fooda ( or Metabolite 'A' ) is added
  set fooda (fooda + feed-rate)
  run-metabolism ; this is where all the conversions between metabolites takes place
  plot-metabolites
  plot-protein-amount
  degrade-protein
  ; turtles raise or lower each others transcription chance, degrade some proteins, missing: plot their protein concentrations, 
  ; turtles adjust their size in relation to transcription chance
  ; transcribe-protein. all in this subroutine:
  node-specific-operation
  tick
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Subroutines for Main Procedure ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; every protein from every node rolls a dice to see if it dies.
to degrade-protein
  ask turtles
  [
     let i 0
     ; every protein has the same chance to degrade, so repeat this for every protein
     repeat protein-amt 
     [ 
         if random 100 < degrade-chance 
         [ 
             set i (i + 1) 
             set protein-amt (protein-amt - i)
         ]
     ]
     if protein-amt < 0 [set protein-amt 0]
  ]
  
end

; turtles raise or lower each others transcription chance, degrade some proteins, missing: plot their protein concentrations, 
; turtles adjust their size in relation to transcription chance
; transcribe-protein. all in this subroutine:
to node-specific-operation
  
  ; normalize-to is the sum of all the transcription numbers from every node
  let normalize-to 0
  ; this adjusts chance of transcription
  ask turtles 
  [ 
      let baseline Transcription-Basis
      let j baseline
   
      ask in-positive-edge-neighbors [ set j ( j + (protein-amt  * Regulation-Factor)) ] 
      ask in-negative-edge-neighbors [ set j (j - (protein-amt * Regulation-Factor)) ] 
      if j < 1 [set j 1]
      
      set transcription-number j; not normalized transcription chance not 1 in 100
      set normalize-to (normalize-to + j)
  ]
  
  let l 0
  ; newprot is the number of new proteins that will be created this turn.
  ; for each new protein one node is chosen (based off of transcription chance)
  repeat newprot
  [
    let i 0
    ; choose a random number between 0 and normalize-to. 
    ; then see which node won a  brand new protein 
    let k (random normalize-to)
    while [k > 0]
    [
      set k ( k - ([transcription-number] of turtle i) )
      if k <= 0 [ask turtle i [set protein-amt ( protein-amt + 1 )] ]
      set i (i + 1)
      
    ]
  ]
  set newprot 0
  
  ; this adjusts the size of each node to be proportional to it's chance of transcription
  ask turtles 
  [
     set size 0.1 + num-nodes * 5 * (transcription-number / normalize-to)
  ]
end
to run-metabolism
  let K ( Max-Conv-Chance / 100 ) ;this is production rate at saturation it is set to 90%
  let kp ( 1 / Conv-Sensitivity ) ; this is (1/amt of food) required to have 50% of max conversion. right now it's set to 10
  
  if (fooda < 0 or foodb < 0 or foodc < 0)
  [
    display
    user-message (word "fooda:" fooda " ca:"([protein-amt] of turtle 1) " atob:" floor (K * kp * fooda * 100 / ( 1 + (kp * fooda) )) 
                       " foodb:" foodb " btoc:" floor (K * kp * foodb * 100 / ( 1 + (kp * foodb) ))
                       " foodc:" foodc " ctop:" floor (K * kp * foodc * 100 / ( 1 + (kp * foodc) )))
    stop
  ] 
;  if [protein-amt] of turtle 1 > 0
;  [
      repeat ([protein-amt] of turtle 1)
      [
        if random 100 < floor (K * kp * fooda * 100 / ( 1 + (kp * fooda) ))
        [
           set fooda (fooda - 1)
           set foodb (foodb + 1)    
        ]  
      ]
  ;]
  repeat ([protein-amt] of turtle 2)
  [
    if random 100 < floor (K * kp * foodb * 100 / ( 1 + (kp * foodb) ))
    [
       set foodb (foodb - 1)
       set foodc (foodc + 1)  
    ]  
  ]
  
  repeat ([protein-amt] of turtle 3)
  [
    if random 100 < floor (K * kp * foodc * 100 / ( 1 + (kp * foodc) ))
    [
       set foodc (foodc - 1)
       set newprot (newprot + 1)  
    ]  
  ]
  
  set-current-plot "Metabolite-Conversion-Chance"
  set-current-plot-pen "A to B"
  plot floor (K * kp * fooda * 100 / ( 1 + (kp * fooda) )) 
  set-current-plot-pen "B to C"
  plot floor (K * kp * foodb * 100 / ( 1 + (kp * foodb) )) 
  set-current-plot-pen "C to D"
  plot floor (K * kp * foodc * 100 / ( 1 + (kp * foodc) )) 
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Plotting and Visuals ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; THIS IS TAKEN FROM DIFFUSION ON A DIRECTED NETWORK. MAYBE ADD SOMETHING LIKE THIS TO LOOK COOL.
;to update-link-appearance ; link procedure
;  ; scale color to be brighter when more value is flowing through it
;  set color scale-color gray (current-flow / (2 * mean-flow + 0.00001)) -0.4 1
;end
to make-protein-pens
  set-current-plot "Protein-Amounts"
  let i 0
  ask turtles 
  [ 
    
    create-temporary-plot-pen ( word "protein-" i )
    set protein-pens lput ( word "protein-" i ) protein-pens
    set i ( i + 1 )
    if i >= 2 and i <= 4 [set-plot-pen-color orange]
    if i >= 5 and i <= 7 [set-plot-pen-color yellow]
  ]
  
end
to plot-protein-amount
  let amt-index []
  let i 0
  repeat num-nodes
  [ 
      ask turtle i
     [
         set amt-index lput ( protein-amt ) amt-index
     ]
     set i ( i + 1)
  ]  
  ;show amt-index ;to check if working properly
  
  set i 0
  repeat num-nodes
  [        
         set-current-plot "Protein-Amounts"
         set-current-plot-pen (item i protein-pens)
         plot (item i amt-index)
         ;plot-pen-reset
         set i ( i + 1)
  ]
end
to plot-metabolites
  set-current-plot "Metabolites"
  set-current-plot-pen "A"
  plot fooda
  set-current-plot-pen "B"
  plot foodb
  set-current-plot-pen "C"
  plot foodc
  set-current-plot-pen "P"
  plot newprot
  
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Edge Operations ;;;
;;;;;;;;;;;;;;;;;;;;;;;
;; pick a random missing edge and create it
;to make-edges
;    let node1 one-of turtles
;    let node2 one-of turtles
;    ifelse node1 = node2  ;or out-link-neighbor? node2
;     [ make-edges ]
;     [
;        ifelse random 100 < %positive-regulation
;        [
;          ask node1 
;          [ 
;            ifelse out-link-neighbor? node2 [make-edges]
;            [create-positive-edge-to node2 [set color green]]
;          ]
;        ]
;          [
;          ask node1
;          [ 
;            ifelse out-link-neighbor? node2 [make-edges]
;            [create-negative-edge-to node2 [set color red]]
;          ]
;        ]
;     ]  
;    find-clustering
;end
;to make-edges2
;  let i 0
;  let j 0
;  let node2 one-of turtles
;  repeat (num-nodes - 1) ; last node doesn't need to look for nodes to link to. 
;  [
;     set j 0
;     repeat (num-nodes - i - 1) ; since the node index starts at 0, num-nodes is one larger than the highest index. ie. turtle9 is last turtle for num-nodes = 10.
;     [
;        ask turtle i 
;        [
;            set node2 turtle (num-nodes - j - 1)
;            ;show (word node2 )
;            if random 100 < chance-of-edge
;            [ 
;              ifelse random 100 < %positive-regulation 
;              [create-positive-edge-to node2 [set color blue]]
;              [create-negative-edge-to node2 [set color red ]]
;            ]
;        ]
;        set j (j + 1)
;     ]
;     set i (i + 1)
;     find-clustering
;  ]
;  
;end
to make-edges3
  let i 0
  let j 0
  let node2 one-of turtles
  set-default-shape links "Myarrow"
  repeat (num-nodes - 1 ) ; last node doesn't need to look for nodes to link to. 
  [
     set j 0
     repeat (num-nodes - 1) ; since the node index starts at 0, num-nodes is one larger than the highest index. ie. turtle9 is last turtle for num-nodes = 10.
     [
        if i != j 
        [
            ask turtle i 
            [
                set node2 turtle j
                ;show (word node2 )
                if random 100 < chance-of-edge
                [ 
                  ifelse random 100 < chance-edge-positive 
                  [create-positive-edge-to node2 [set color blue set thickness .1]]
                  [create-negative-edge-to node2 [set color red set thickness .1]]
                ]
            ]
        ]
        set j (j + 1)
     ]
     set i (i + 1)
  ]
  find-clustering
  motif-check
end
;;;;;;;;;;;;;;;;;;;;;;;;
;;; Network Analysis ;;;
;;;;;;;;;;;;;;;;;;;;;;;;
to find-clustering
  let i 0
  let clustering 0
  repeat num-nodes
  [  
     ask turtle i
     [
        ;ask out-link-neighbors [set check 1]  
        ask out-link-neighbors [set clustering count my-out-links]        
        set clustering-coef (clustering / ( num-nodes * ( num-nodes - 1 ) ) )
     ] 
     set i (i + 1)
  ]
end

to motif-check
  check-two-node-regulation
  ; the following two are for three node motifs
  check-for-ff-loops 
  check-for-fb-loops
end
to check-two-node-regulation
   ;all three types of two node feedback
   let i 0
   set two-node-ps-feedback 0
   set two-node-ng-feedback 0
   set two-node-dn-feedback 0
   repeat num-nodes
   [
      ask turtle i 
      [
        set check 1
        ask out-positive-edge-neighbors 
        [ 
          ask out-positive-edge-neighbors with [check = 1] [set two-node-ps-feedback (two-node-ps-feedback + 1)]; show "two-node-ps-feedback"]
          ask out-negative-edge-neighbors with [check = 1] [set two-node-ng-feedback (two-node-ng-feedback + 1)]; show "two-node-ng-feedback"]
        ]
        ask out-negative-edge-neighbors
        [ 
          ask out-positive-edge-neighbors with [check = 1] [set two-node-ng-feedback (two-node-ng-feedback + 1)]; show "two-node-ng-feedback"]
          ask out-negative-edge-neighbors with [check = 1] [set two-node-dn-feedback (two-node-dn-feedback + 1)]; show "two-node-dn-feedback"]
        ]
      ]
      set i ( i + 1 )
      ask turtles [set check 0]
   ]
   set two-node-ps-feedback (two-node-ps-feedback / 2)
   set two-node-ng-feedback (two-node-ng-feedback / 2)
   set two-node-dn-feedback (two-node-dn-feedback / 2)   
end
to check-for-ff-loops ;three node
   ;Feed Forward
   let i 0
   let x 0
   let y 0
   set number-of-ff-loops 0
   set types-of-ff-loops []
   set who-in-ff-loops []
   repeat num-nodes
   [
      let j 0
      ask turtle i 
      [
        ask out-positive-edge-neighbors [set check 1 ]
        ask out-negative-edge-neighbors [set check 2 ]
        set x [who] of self
        ask out-positive-edge-neighbors 
        [ 
            set y [who] of self
            ask out-positive-edge-neighbors with [check = 1] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 1 types-of-ff-loops
                ]
            ask out-negative-edge-neighbors with [check = 1] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 2 types-of-ff-loops
                ]
            ask out-positive-edge-neighbors with [check = 2] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 3 types-of-ff-loops
                ]
            ask out-negative-edge-neighbors with [check = 2] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 4 types-of-ff-loops
                ]
        ]
        ask out-negative-edge-neighbors
        [
            set y [who] of self
            ask out-positive-edge-neighbors with [check = 1] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 5 types-of-ff-loops
                ]
            ask out-negative-edge-neighbors with [check = 1] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 6 types-of-ff-loops
                ]
            ask out-positive-edge-neighbors with [check = 2] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 7 types-of-ff-loops
                ]
            ask out-negative-edge-neighbors with [check = 2] 
                [
                  set j (j + 1) 
                  set who-in-ff-loops fput (word x "-" y "-" [who] of self) who-in-ff-loops
                  set types-of-ff-loops fput 8 types-of-ff-loops
                ]
        ]
        ;show j 
        set number-of-ff-loops (number-of-ff-loops + j)
      ]
      ;ask turtle i [if (check != 0) [set color blue]]
      set i ( i + 1 )
      ask turtles [set check 0]
   ]
end
to check-for-fb-loops ;three node
   ;Feedback
   let i 0
   let x 0
   let y 0
   set number-of-fb-loops 0
   ;set types-of-fb-loops [b
   set who-in-fb-loops []
   repeat num-nodes
   [
      let j 0
      ask turtle i 
      [
        ask in-positive-edge-neighbors [set check 1]
        ask in-negative-edge-neighbors [set check 2]
        set x [who] of self
        ask out-positive-edge-neighbors 
        [ 
            set y [who] of self
            ask out-positive-edge-neighbors with [check = 1] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-negative-edge-neighbors with [check = 1] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-positive-edge-neighbors with [check = 2] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-negative-edge-neighbors with [check = 2] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
        ]
        ask out-negative-edge-neighbors
        [
            set y [who] of self
            ask out-positive-edge-neighbors with [check = 1] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-negative-edge-neighbors with [check = 1] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-positive-edge-neighbors with [check = 2] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
            ask out-negative-edge-neighbors with [check = 2] [set j (j + 1) set who-in-fb-loops fput (word x "-" y "-" [who] of self) who-in-fb-loops]
        ]
        ;show j 
        set number-of-fb-loops (number-of-fb-loops + j)
      ]
      set i ( i + 1 )
      ask turtles [set check 0]
   ]
   set number-of-fb-loops (number-of-fb-loops / 3) ; I think they always get counted three times
   ;print who-in-fb-loops 
end
to print-analysis
   print ( word "two-node-ps-feedback:" two-node-ps-feedback )
   print ( word "two-node-ng-feedback:" two-node-ng-feedback )
   print ( word "two-node-dn-feedback:" two-node-dn-feedback )
   
   print ( word "number-of-fb-loops:" number-of-fb-loops )
   print ( word "number-of-ff-loops:" number-of-ff-loops )
   print types-of-ff-loops
   print who-in-ff-loops
end
;two-node-ps-feedback
;two-node-ng-feedback
;two-node-dn-feedback
;number-of-fb-loops
;number-of-ff-loops
@#$#@#$#@
GRAPHICS-WINDOW
539
14
1004
500
45
45
5.0
1
10
1
1
1
0
0
0
1
-45
45
-45
45
1
1
1
ticks
BUTTON
31
15
106
48
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
107
15
183
48
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
SLIDER
17
187
189
220
num-nodes
num-nodes
8
20
10
1
1
NIL
HORIZONTAL
MONITOR
379
45
429
90
Total
count links
3
1
11
SLIDER
17
257
189
290
chance-edge-positive
chance-edge-positive
0
100
20
1
1
%
HORIZONTAL
MONITOR
431
45
481
90
Positive
count positive-edges
17
1
11
MONITOR
483
45
533
90
negative
count negative-edges
17
1
11
MONITOR
379
92
436
137
%positive
100 * (count positive-edges) / ((count negative-edges) + (count positive-edges))
2
1
11
PLOT
1007
47
1294
197
Protein-Amounts
Ticks
Amt.
0.0
10.0
0.0
10.0
true
true
PENS
"protein-0" 1.0 0 -16777216 true
PLOT
1008
199
1294
349
Metabolites
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"A" 1.0 0 -13345367 true
"B" 1.0 0 -1184463 true
"C" 1.0 0 -2674135 true
"P" 1.0 0 -16777216 true
SLIDER
198
46
370
79
time-limit
time-limit
0
1000
700
1
1
NIL
HORIZONTAL
SLIDER
197
160
369
193
initial-protein-amt
initial-protein-amt
0
100
20
1
1
NIL
HORIZONTAL
SLIDER
195
241
367
274
feed-rate
feed-rate
0
100
20
1
1
NIL
HORIZONTAL
SLIDER
197
195
369
228
degrade-chance
degrade-chance
0
10
5
1
1
%
HORIZONTAL
MONITOR
31
50
184
95
tries to survive
tries
17
1
11
TEXTBOX
1006
13
1253
42
Orange = Metabolism Protein\\nYellow = Life Critical Protein
11
0.0
1
SLIDER
17
222
189
255
chance-of-edge
chance-of-edge
0
100
25
1
1
%
HORIZONTAL
MONITOR
437
92
533
137
avg edges/node
(count links) / num-nodes
17
1
11
PLOT
1008
350
1294
500
Metabolite-Conversion-Chance
NIL
NIL
0.0
10.0
0.0
90.0
true
true
PENS
"A to B" 1.0 0 -13345367 true
"B to C" 1.0 0 -1184463 true
"C to D" 1.0 0 -2674135 true
SLIDER
194
276
368
309
Max-Conv-Chance
Max-Conv-Chance
0
95
80
1
1
%
HORIZONTAL
SLIDER
194
311
368
344
Conv-Sensitivity
Conv-Sensitivity
0
20
10
1
1
NIL
HORIZONTAL
TEXTBOX
198
20
348
38
RUN OPTIONS\\n
13
0.0
1
TEXTBOX
19
175
169
193
Network Generation\\n
11
0.0
1
MONITOR
379
219
456
264
FF
number-of-ff-loops
17
1
11
MONITOR
457
219
532
264
FB
number-of-fb-loops
17
1
11
TEXTBOX
385
207
535
225
3-node motifs\\n
11
0.0
1
TEXTBOX
381
147
531
165
2-node feedback motifs
11
0.0
1
MONITOR
380
161
430
206
P - P
  two-node-ps-feedback\\n
17
1
11
MONITOR
432
161
482
206
N - P
two-node-ng-feedback\\n
17
1
11
MONITOR
484
161
534
206
N - N
two-node-dn-feedback
17
1
11
TEXTBOX
18
162
168
180
SETUP
13
0.0
1
TEXTBOX
196
228
346
246
Metabolism
11
0.0
1
TEXTBOX
198
33
348
51
General
11
0.0
1
TEXTBOX
194
344
344
362
Transcription
11
0.0
1
SLIDER
195
357
367
390
Regulation-Factor
Regulation-Factor
0
2
2
0.5
1
NIL
HORIZONTAL
SLIDER
195
393
367
426
Transcription-Basis
Transcription-Basis
80
200
80
20
1
NIL
HORIZONTAL
TEXTBOX
380
19
530
37
NETWORK ANALYSIS
13
0.0
1
TEXTBOX
380
32
530
50
Edges
11
0.0
1
MONITOR
8
96
195
141
Times Survived Out of 10 Repeats
repeats-survived
17
1
11
SWITCH
198
114
371
147
Show-Notifications?
Show-Notifications?
1
1
-1000
SLIDER
198
80
371
113
Repeats-Threshold
Repeats-Threshold
1
10
5
1
1
NIL
HORIZONTAL
TEXTBOX
381
136
531
154
Network Motifs\\n
11
0.0
1
TEXTBOX
198
147
348
165
Protein Options
11
0.0
1
@#$#@#$#@
WHAT IS IT?
-----------
**What is this model doing?**
This model is loosely based off of transcription networks and the affect that transcription networks have on the life process of a cell. The model creates a random transcription network, applies rules mimicking cell life, and tests if the network can keep the cell alive past a time limit. If the network does not survive past the time limit, a new random network is generated and the process starts over. Once a network survives the time limit once, the robustness of the network is measured by recording how many times the cell survives ten repeated tests.
By looking at what kinds of networks survive and contrasting them against the other random networks generated we can hope to see trends in which networks are selected for and which networks are selected against. 
**What are the nodes in the network?**
Each node represents both a protein and the gene that encodes that protein. So the two main properties of each node are the amount of protein present and the chance that more of that protein will be created. The amounts of each protein are shown on a graph, and the chance of transcription is represented by the size of each node. 
**What are the edges in the network?**
(In this model, but not in biology) every protein is a potential transcription factor, which means that it influences the chance another protein is transcribed. Blue (or positive) edges are used to show which proteins increase the chance that another protein is transcribed. Red (or negative) edges show which proteins reduce that chance.
**What are the rules that mimic cell life?**
In this simplified cell, there are three types of proteins: life-critical, metabolism, and blank. The survival of the cell depends on how well it uses its metabolism to create new proteins and how well it balances the transcription chances for each kind of protein.
Every turn, each protein has an equal chance of being degraded. The cell dies if the amount of any life-critical protein drops to zero. The only way to create new proteins is by converting metabolites from one into the other. 'A' is converted into 'B' then into 'C' and then into a new protein. This conversion process is dependent on the amounts of each metabolism protein.

HOW IT WORKS
------------
**Random Network Creation**
There is a fixed chance (chance-of-edge) that an edge will be created from any one node to another node. Whether the edge is either positive or negative is randomly selected based off of a fixed probability (chance-edge-positive).

**Creating new proteins (Cell Metabolism)**
There are three kinds of metabolites 'A', 'B' and 'C' and three metabolism proteins. One protein converts 'A' to 'B', another converts 'B' to 'C', and the last creates new proteins out of 'C'. Each step in this system is calculated in an identical manner.
The quantity of 'A' converted to 'B' in any tick depends on both the amount of metabolism protein and amount of 'A' present. The amount of protein determines how many tries the cell has to convert one 'A' to one 'B'. The amount of 'A' influences the chance that a conversion attempt will succeed. 
The chance of conversion is determined by two variables Max-Conv-Chance and Conv-sensitivity.
The type of new protein created is determined by the chance of transcription.
**Calculating the Chance of Transcription**
Every node has a number, called the transcription-number, that is used to calculate the chance of transcription. Every time a protein is transcribed the amount of that protein is increased by one.
X = L + (A + B) * M
Where:
X = Transcription-number
L = transcription-basis
M = regulation-factor
A = The protein amount of all positive transcription factors (from positive inward edges)
B = The protein amount of all negative transcription factors (from negative inward edges)
L and M, the transcription-basis and regulation-factor can be changed from the interface. 
Finally when a new protein is created, the chance of any given node transcribing the new protein is:
Y  = ( X1 / Xt ) * 100%
Where: 
Y  = % Chance of transcription for node 1
X1 = Transcription-number for node 1
Xt = Sum of transcription-numbers from all nodes
HOW TO USE IT
-------------
Network Generation
- num-nodes - this changes the number of nodes in your network
- chance-of-edge - this changes the chance that a an edge will be going from any one 		node to another node
- chance-edge-positive - if a new edge is created, this determines the chance that the 		new edge will be positive 
Run Options
General
- time-limit - this is how many ticks the cell needs to survive
- Repeats-Threshold - If the same network is tested 10 times, how many times must a network survive. If the Repeats-Threshold is not met, a new random network will be generated.
- Show-Notifications? - this displays user messages every time it finds a network that has survived.
Protein Options
- initial-protein-amt - this is the starting amount of each type of protein
- degrade-chance - this is the chance that any particular protein will degrade this 	tick
Metabolism
- feed-rate - how much metabolite 'A' is added every tick 
For more information on max-conv-chance and conv-sensitivity, look in the How It Works section
- max-conv-chance - this is the maximum metabolism conversion chance. When there is an excess of 'A' present, each of the proteins that convert 'A' to 'B' will have this chance of converting one 'A' this tick. 
- conv-sensitivity - This variable determines how sensitive the conversion chance is to the amount of metabolite. Specifically, this number is the amount of metabolite that will have a conversion chance that is half the size of the maximum conversion chance.
Example: 
max-conv-chance = 80%
conv-sensitivity = 10
If there is 100 'A' present, the conversion chance will be close to 80%
If there is 10 'A' present, the conversion chance will be 40%
If there is 1 'A' present, the conversion chance will be close to 2%
Transcription
For more information on regulation-factor and transcription-basis, look in the How It Works section. Both of these variables play a role in how much affect the transcription factors have on the chance of transcription.
- regulation-factor - This controls how strong the regulation from positive and negative edges will be. 

- transcription-basis - This controls how easily a node is influenced by regulation from positive and negative edges.
THINGS TO NOTICE
----------------
Every aspect of this model depends on random chance to the point where it is often difficult to show any striking trends without running lots of repetitions, recording the results, and analyzing them.
Robust networks typically have repeated fluctuations in the Protein-Amounts Graph. 
By looking at the levels of different metabolites, you can tell which metabolism protein was limiting the production of at which part of the simulation. Example: If the levels of 'B' increased, but 'C' stayed consistently low. Than the protein that converted 'B' to 'C' was limiting step in the metabolism.

THINGS TO TRY
-------------
By looking at how many tries the model takes to create a stable network,
Change number of nodes. Can you notice a difference in the number of tries the model needs to generate a stable network? How about if you change the regulation factor?
Increasing the number of nodes decreases the chance that a new protein will be a life-critical or a metabolism protein.  
By increasing the strength of the regulation factor it should take more tries to create a stable network. This is because most randomly generated networks have a negative effect on survival. By increasing the strength of the edges, you are increasing the negative effects.

EXTENDING THE MODEL
-------------------
Most of the features I wish I could add have to do with analysis. I would have liked to look at more network properties. 
Another great feature would be to create more graph friendly output. 

NETLOGO FEATURES
----------------
create-temporary-plot-pens
CREDITS AND REFERENCES
----------------------
By Peter Winter
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>count positive-edges</metric>
    <metric>count negative-edges</metric>
    <metric>tries</metric>
    <metric>repeats-survived</metric>
    <metric>two-node-ps-feedback</metric>
    <metric>two-node-ng-feedback</metric>
    <metric>two-node-dn-feedback</metric>
    <metric>number-of-fb-loops</metric>
    <metric>number-of-ff-loops</metric>
    <enumeratedValueSet variable="Repeats-Threshold">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="feed-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Regulation-Factor">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-edge">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Max-Met-Conv">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Show-Notifications?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Transcription-Basis">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%positive-regulation">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Met-Conv-Sensitivity">
      <value value="8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-protein-amt">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degrade-chance">
      <value value="5"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Threshold1CountTries" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>tries</metric>
    <enumeratedValueSet variable="time-limit">
      <value value="700"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Show-Notifications?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degrade-chance">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-protein-amt">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%positive-regulation">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Repeats-Threshold">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Met-Conv-Sensitivity">
      <value value="8"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Transcription-Basis">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-edge">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Regulation-Factor">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Max-Met-Conv">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="feed-rate">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="% positive20" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <metric>tries</metric>
    <enumeratedValueSet variable="Regulation-Factor">
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-edge-positive">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Repeats-Threshold">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="num-nodes">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Transcription-Basis">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-protein-amt">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Conv-Sensitivity">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Max-Conv-Chance">
      <value value="80"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="feed-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Show-Notifications?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="degrade-chance">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-edge">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="time-limit">
      <value value="700"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
myarrow
0.2
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
Polygon -7500403 true true 90 90 150 60 240 195 150 150 60 195 150 60
@#$#@#$#@
0
@#$#@#$#@
