Globals [price producer-surplus consumer-surplus Total-Surplus]
Breed [Buyers Buyer]
Breed [Sellers Seller]
Buyers-own [willingtopay consumersurplus]
Sellers-own [willingtosellfor producersurplus]
turtles-own [partner]
 



to setup
  
  clear-all                                                     ;clear the world
  create-Buyers 50                                              ;create buyers, put them in random places
  [
  setxy random-xcor random-ycor
  ]
  create-Sellers 50                                                ;create Sellers, put them in random places
  [
   setxy random-xcor random-ycor
  ]
  ask buyers [set shape "buyersleeping" set size 1.6]                        ;give buyers default neutral shapes
  ask Sellers [set shape "sellersleeping" set size 1.6]                            ;give Sellers default neutral shapes        
  ask Buyers [set willingtopay (who + 50 + Change-in-Demand)]    ;set price buyers are willing to pay
  ask Sellers [set willingtosellfor (who + 1 - Change-in-Supply)] ;set price Sellers are willing to sell for
  set price Initial-Price                               ;converts price set by slider into variable that can change
  set consumer-surplus 0                                        ; set surplusses to 0
  set producer-surplus 0
  set total-surplus 0
  ask turtles [set partner nobody] 
end

to go
  ;these commands repeat most of the startup procedures for when "go" is called after a price change
  update-plot
  ask buyers [set shape "buyersleeping" set size 1.6]
  ask sellers [set shape "sellersleeping" set size 1.6]
  ask turtles [set partner nobody] 
  ask buyers [set consumersurplus (willingtopay - price)]
  ask sellers [set producersurplus (price - willingtosellfor)]
  set consumer-surplus 0
  set producer-surplus 0
  set total-surplus 0
  
  ;if you're a buyer willing to buy and haven't bought, show that you're looking
  ask buyers [if willingtopay >= price and partner = nobody and not any? buyers with [shape = "buyermad"][set shape "buyerlooking"]]
  
  ;if you're a seller willing to sell haven't sold, and there are buyers, show that you're selling.
  ask sellers [if willingtosellfor <= price and partner = nobody and not any? sellers with [shape = "sellermad"][set shape "sellerlooking"]]
  
  ;if you're a buyer willing to buy and haven't bought, find a car to buy
  ask buyers [if shape = "buyerlooking" [findseller]]
  
  ;if you're a seller who wants to sell and there are no buyers left, look angry
  ask sellers [if willingtosellfor <= price and partner = nobody and not any? buyers with [shape = "buyerlooking"] [set shape "sellermad"]]
  ;if nobody is looking to buy or sell, stop and announce the equilibrium price ahs been reached
  if not any? sellers with [shape = "sellerlooking"] 
     and not any? sellers with [shape = "sellermad"]
        and not any? buyers with [shape = "buyerlooking"] 
           and not any? buyers with [shape = "buyermad"]
              [output-print " " output-type "Equilibrium price reached! " output-type count sellers with [partner != nobody] output-type " Cars sold for $" output-type price output-type " each."  update-plot stop]
  
  ;if buyers and sellers are angry, and they are willing to adjust prices, make them adjust their prices
  if any? buyers with [shape = "buyermad"] and price-adjusting [raiseprice]
  if any? sellers with [shape = "sellermad"] and price-adjusting [lowerprice]
  
  ;if buyers and sellers are angry, but they are not willing to adjust prices, stop and announced they are angry
  if any? buyers with [shape = "buyermad"] and not price-adjusting [output-print "Buyers are angry!" stop]
  if any? sellers with [shape = "sellermad"] and not price-adjusting [output-print "Sellers are angry!" stop]
end

to findseller
  ;if there are buyers who want to buy, but can't, make them mad
  ask buyers [if willingtopay >= price and partner = nobody and not any? sellers with [shape = "sellerlooking"] [set shape "buyermad"]]
  
  ;if there are sellers who want to sell, but can't, make them mad
  ask sellers [if willingtosellfor <= price and partner = nobody and not any? buyers with [shape = "buyerlooking"] [set shape "sellermad"]]
  
  ;if there are sellers left who want to sell, wander around and look for them
  if any? sellers with [shape = "sellerlooking"] and partner = nobody [lt random 40 rt random 40 fd 1 checkseller]
end

to checkseller
  ;if there is a Seller who hasn't sold who wants to sell on this spot, buy it and make both of you happy.
  if any? other turtles-here with [(partner = nobody) and (shape = "sellerlooking")]
       [set partner one-of other turtles-here with [partner = nobody and shape = "sellerlooking"] 
       set shape "buyerhappy"
       set consumer-surplus consumer-surplus + (consumersurplus)
       ask partner [set partner myself set shape "sellerhappy" set producer-surplus producer-surplus + (producersurplus)]]
  set total-surplus consumer-surplus + producer-surplus
  
  ;if there's not a seller here, look somewhere else
  if not any? other turtles-here with [shape = "sellerlooking"][findseller]
end

to raiseprice
  ;announce your are raising the price, then raise the price
  Output-print "Buyers are angry there are no cars to buy." output-print "Sellers realize they can raise prices without losing sales." output-type "Sellers raise price to $" output-type price + 1 output-print "." 
         output-print " "
  set price (price + 1)
  wait 2
  go
end

to lowerprice
  ;announce you are lowering the price, then lower the price
  Output-print "Sellers are angry nobody will buy their car." output-type "Sellers drop price to $" output-type price - 1
       output-print "." output-print " "
  set price (price - 1)
  wait 2
  go
end

to update-plot
set-current-plot "Price & Quantity"
set-current-plot-pen "Price"
plot price
set-current-plot-pen "Quantity"
plot count sellers with [shape = "sellerhappy"]
set-current-plot "Change in Surplus"
set-current-plot-pen "Total Surplus"
plot Total-Surplus
set-current-plot "Change in Surplus"
set-current-plot-pen "Producer Surplus"
plot Producer-Surplus
set-current-plot "Change in Surplus"
set-current-plot-pen "Consumer Surplus"
plot Consumer-Surplus
end
  
@#$#@#$#@
GRAPHICS-WINDOW
501
10
945
475
16
16
13.152
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks

BUTTON
7
10
71
55
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
5
72
143
105
Initial-Price
Initial-Price
50
101
75
1
1
$
HORIZONTAL

BUTTON
80
10
146
55
go
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
6
305
219
474
Price & Quantity
NIL
NIL
0.0
10.0
0.0
100.0
true
true
PENS
"Quantity" 1.0 0 -13345367 true
"Price" 1.0 0 -2674135 true

MONITOR
176
11
241
56
Price
Price
17
1
11

MONITOR
252
11
336
56
Quantity Sold
count sellers with [partner != nobody]
17
1
11

SLIDER
176
119
338
152
Change-in-Supply
Change-in-Supply
-24
24
0
2
1
NIL
HORIZONTAL

SLIDER
174
68
338
101
Change-in-Demand
Change-in-Demand
-24
24
0
2
1
NIL
HORIZONTAL

SWITCH
5
119
142
152
Price-Adjusting
Price-Adjusting
1
1
-1000

OUTPUT
3
161
490
299
12

MONITOR
363
10
490
55
Total Surplus
Total-Surplus
17
1
11

MONITOR
363
112
490
157
NIL
Consumer-Surplus
17
1
11

MONITOR
363
60
489
105
NIL
Producer-Surplus
17
1
11

PLOT
218
305
492
474
Change in Surplus
NIL
NIL
0.0
10.0
0.0
100.0
true
true
PENS
"Total Surplus" 1.0 0 -10899396 true
"Consumer Surplus" 1.0 0 -13345367 true
"Producer Surplus" 1.0 0 -955883 true

@#$#@#$#@
WHAT IS IT?
-----------
This model simulates how the equillibrium price and quantity sold in a market emerge from individual decisions to buy or sell. In doing so the model provides and agent-based explanation for the laws of supply and demand.  By watching the actions of individual agents one can see why an increase in demand leads to increases in price and quantity (and vice versa), and why an increase in supply leads to a decrease in price and increase in quantity sold (and vice versa).

HOW IT WORKS
------------
The model consists of 50 "buyers" (people shape) and 50 "sellers" (car shapes). Each buyer has a specific price they are willing to pay for a car. Each seller has a specific price for which they are willing to sell their car. When the model is run each buyer willing to pay more than the market price will attempt to buy a car. Each seller willing to sell for less than the market price will attempt to sell their car. The buyer and sellers interested in making a deal will turn yellow. 

At each tick the buyers interested in buying randomly move around. When they find a seller willing to sell, a deal is made and both the buyer and seller turn green to show their satisfaction. If interested buyers remain after there are no longer interested sellers, the model stops and these buyers turn red to show their dissatisfaction. Similarly, if interested sellers remain after there are no longer interested buyers, the model stops and these sellers turn red to show their dissastisfaction.

When the PRICE-ADJUSTING button is "on" the model does not stop when there are angry buyers or sellers. Instead, at the next tick the price moves up or down by one dollar. If there are angry buyers the price will move up. This simulates sellers raising the price because they realize doing so will not lead to a decrease in sales. Similarly, when there are angry sellers, at the next tick the price decreases by one dollar. This simulates angry sellers willing to sell for less than the market price who now decide to offer a lower price in order to ensure they make a sale. When the PRICE-ADJUSTING button is "on" the model will always move to the equillibrium price and quantity.

The CHANGE-IN-DEMAND and CHANGE-IN-SUPPLY silders simulate increases in supply and demand. The buttons work by changing the amount of money buyers and sellers are willing to pay or receive. For example, increasing demand by 4 will increase the price every buyer is willing to pay by $4. This simulates an increase in demand because it effectively means that an any price, there are now four additional buyers willing to buy. Similarly, increasing supply by 4 will lower the price every seller is willing to sell for by 4$. This similates an increase in supply because it effectively means that an any price, there are now four more sellers willing to sell. 


HOW TO USE IT
-------------
The SETUP button sets up the market of 50 buyers and 50 sellers. Initially they are all white to show that nobody is interesting in any action.

The INITIAL-PRICE slider sets the initial price in the market. If the PRICE-ADJUSTING button is on the price will change at each tick.

The PRICE-ADJUSTING button determines whether angry buyers and sellers will adjust the prices they offer, and consequently the market price, in order to become happy. 

The CHANGE-IN-DEMAND slider controls the change in demand.

The CHANGE-IN-SUPPLY slider controls the change in supply.

If the goal is simply to see what will happen at a certain price, begin with an INTITIAL-PRICE and run the model. Adjust the CHANGE-IN-DEMAND and CHANGE-IN-SUPPLY sliders to find out what happens and different levels of supply and demand. To make the model converge on the equillibrium price and and quantity, simply turn on the PRICE-ADJUSTING button."

THINGS TO NOTICE
----------------
At low prices, almost all buyers are angry, while at high prices, almost all sellers are angry. When buyers become angry, they are always willing to pay more than the market price. Similarly, when sellers become angry, they are always willing to sell for less than the market price. This is the reasoning behind why the model changes the market price.

THINGS TO TRY
-------------
Run the model with varying increase or decreases in supply and demand. Do increases in demand always lead to increases in price and quantity? Do increases in supply always lead to decreases in price? 

EXTENDING THE MODEL
-------------------
This model contains a very limited number of homogenous buyers and sellers who all react uniformly to changes in supply and demand. An extension to the model could allow the user to adjust the number of buyer and sellers, or create different breeds of buyers and sellers who react differently to various market outcomes (e.g. becoming angry, change in demand, etc.). 


@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

buyerhappy
false
0
Circle -13840069 true false 105 0 90
Polygon -13840069 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -13840069 true false 127 79 172 94
Polygon -13840069 true false 195 90 240 150 225 180 165 105
Polygon -13840069 true false 105 90 60 150 75 180 135 105

buyerlooking
false
0
Circle -1184463 true false 110 5 80
Polygon -1184463 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -1184463 true false 127 79 172 94
Polygon -1184463 true false 195 90 240 150 225 180 165 105
Polygon -1184463 true false 105 90 60 150 75 180 135 105

buyermad
false
0
Circle -2674135 true false 110 5 80
Polygon -2674135 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -2674135 true false 127 79 172 94
Polygon -2674135 true false 195 90 240 150 225 180 165 105
Polygon -2674135 true false 105 90 60 150 75 180 135 105

buyersleeping
false
0
Circle -1 true false 110 5 80
Polygon -1 true false 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -1 true false 127 79 172 94
Polygon -1 true false 195 90 240 150 225 180 165 105
Polygon -1 true false 105 90 60 150 75 180 135 105

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sellerhappy
false
0
Polygon -13840069 true false 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -13840069 true false 47 195 58
Circle -13840069 true false 195 195 58

sellerlooking
false
0
Polygon -1184463 true false 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -1184463 true false 47 195 58
Circle -1184463 true false 195 195 58

sellermad
false
0
Polygon -2674135 true false 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -2674135 true false 47 195 58
Circle -2674135 true false 195 195 58

sellersleeping
false
0
Polygon -1 true false 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -1 true false 47 195 58
Circle -1 true false 195 195 58

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
