
breed [ workers worker ]
breed [ bosses boss ]

turtles-own [ 
  expertise ; the level of technical expertise that the agent has with the technology
  attitude   ; feelings about new technology
  group-membership ; which workgroup the workers and bosses are part of
  group-liking ; how the worker feels about his workgroup
  boss-liking ; how the worker feels about his boss
  adopt ; records when a person makes decision to adopt the technology
  reject ; records true when a person makes a decision to reject technology
  ]

links-own [
  group ; a way to access the links in each group 
]
globals [
  change-amt ; used to keep track of the amt turtles change their opinions each round
  change-counts ; keeps track of how many adopt/ reject decisions have been made
  change-time ; keeps track of the time since the last adopt/reject decisions were made
  had-training ; only allows training to happen once
  reduction-factor ; keeps track of how much less others are able to influence over time
]

to setup
  clear-all
  set reduction-factor 1
  set had-training false
  set change-counts 0
       if (Group-liking?) [
      ifelse (number-workgroups > 1) [ 
        create-bosses number-workgroups [ set color white ]
       layout-circle bosses 10
       ask bosses [ create-links-with other bosses ] 
   ; assume that all bosses interact, can change this assumption later
      
    let counts 0
   let num-links ( ( average-node-degree - 1 ) * workgroup-size ) / 2
  while [ counts < number-workgroups ]
    [ create-workers workgroup-size [ set group-membership counts 
        set color blue ]
 
    
       layout-circle workers with [group-membership = counts ] 5 - 0.5 * max( list (number-workgroups - 5) (0) )  
          ask workers with [group-membership = counts ] [
           setxy xcor + [xcor] of boss counts ycor + [ycor] of boss counts 
           create-link-with boss counts
       ]
 
       let linkcounts 0
       while [linkcounts < num-links ] [
           ask one-of workers with [group-membership = counts] [
               let choice (one-of other workers with [not link-neighbor? myself and group-membership = counts])
                     if choice != nobody [ create-link-with choice [ set group counts ]
                       set linkcounts linkcounts + 1 ] 
           ]
       ]
  
    set counts counts + 1
    ]
  ]
   [create-bosses 1 [ setxy 0 0 set color white ] 
     create-workers workgroup-size [  
        set color blue 
        set group-liking min-init-group-liking + random ( max-init-group-liking - min-init-group-liking )]
    
       layout-circle workers  14.5    
             ask workers [
           setxy xcor + [xcor] of boss 0 ycor + [ycor] of boss 0 
           create-link-with boss 0
       ]
          let num-links ( ( average-node-degree - 1 ) * workgroup-size ) / 2
       let linkcounts 0
       while [linkcounts < num-links ] [
           ask one-of workers [
               let choice (one-of other workers with [not link-neighbor? myself ])
                     if choice != nobody [ create-link-with choice
                       set linkcounts linkcounts + 1 ] 
           ]
       ]
      ]
   ask workers [ set group-liking min-init-group-liking + random ( max-init-group-liking - min-init-group-liking )]
    ]
  
  if  ( not Group-liking? )
   [create-bosses 1 [ setxy 0 0 set color white ] 
     create-workers number-workers [  
        set color blue ]
         
       layout-circle workers  14.5    
             ask workers [
           setxy xcor + [xcor] of boss 0 ycor + [ycor] of boss 0 
           create-link-with boss 0
       ]
          let num-links  round ( ( density / 100 ) * ( ( number-workers ) * (number-workers - 1 ) / 2 ) )
       let linkcounts 0
       while [linkcounts < num-links ] [
           ask one-of workers [
               let choice (one-of other workers with [not link-neighbor? myself ])
                     if choice != nobody [ create-link-with choice
                       set linkcounts linkcounts + 1 ] 
           ]
       ]
      ]
   
      if  ( not Boss-influence? ) [ ask bosses [ die ] ]
     
      ask bosses [ set shape "person business"
         set attitude min-init-att + random ( max-init-att - min-init-att ) ]
      ask workers [ set shape "person"
                  set attitude min-init-attitude + random ( max-init-attitude - min-init-attitude )
           if Boss-influence? [ set boss-liking min-init-boss-liking + random ( max-init-boss-liking - min-init-boss-liking ) 
           set expertise min-init-expertise + random ( max-init-expertise - min-init-expertise )
 ]
        ]
      
         ; the dissenter is a technological expert who is completely against the technology
    ask turtles [
            
        set size 3
        set adopt false
        set reject false 
           ; doesn't allow any agents to make a decision about adopting or rejecting the
           ; technology before the simulation starts
        set label attitude 
    ]   
end

to go
  set change-amt 0
  ask workers [
    set change-amt 0
    ; turtles only update opinions until they have made a decision
    if adopt = false and reject = false [
    if Group-liking? [ talk-to-group ]
    if Boss-influence? [ talk-to-boss ]
    if Critical-mass? [ crit-mass-effect ]
    if Reduce-influence? [ reduce-influence ]
     ; the worker updates their attitude from the effects of the hypotheses
     set attitude attitude + change-amt

   ; the turtles check again to see if they are ready to make a decision
       if attitude > 99 [ set adopt true 
           set color green
           set attitude 100 ]
        if attitude < 1 [ set reject true
            set color red 
            set attitude 0]
         set label round attitude
    ]
  ]
  
  ; if the training switch is on, keep track of decisions to have training when
  ; there have been no new decisions made for a while
  if Boss-influence? and training? and had-training = false [
    ifelse training-time? [ 
      ifelse change-time = training-time [ 
         ask workers with [ adopt = false and reject = false ]
          [ set attitude attitude + training-effect ]
           ; make sure training doesn't happen again
           set had-training true
           ; if nobody has made a decision, add a tick
       ] 
      [ set change-time change-time + 1 ] ]
  [  ifelse count workers with [ adopt = true or reject = true ] = change-counts 
       ; if nobody has made a new decision within 50 ticks, have a training session
       [ ifelse change-time > 49 [
           ; having more information will increase people's attitudes 
          ask workers with [ adopt = false and reject = false ]
          [ set attitude attitude + training-effect ]
           ; make sure training doesn't happen again
           set had-training true
           ; if nobody has made a decision, add a tick
       ] [ set change-time change-time + 1 ] ]
       ; if the count is different, someone has made a decision and the clock resets
       [ set change-time 0
         set change-counts count workers with [ adopt = true or reject = true ] ]
   ]
  ]
  
  ; if the influence-reduction hypothesis is in effect, each period the amount
  ; of the reduction is calculated and applied to the changes in the next period
   
   if Reduce-influence?
   [ set reduction-factor reduction-factor * ( 1 -  ( amt-reduction / 100 ) ) ]
  
  
  ; model ends when all the workers have made a decision (so sometimes
  ; the model never ends
 if count workers with [ adopt = true or reject = true ] = count workers
 [ stop ]
 
 tick 
  end

to talk-to-group ; worker procedure
  let track 0
       ; if a worker has one link, then they only have a link with their boss, and 
       ; can't update their opinion due to group opinions
   while [ track <  hyp1-degree / 100 * ( count my-links - 1 ) ]
     [ 
       ; the amount of change is weighted by the degree of the hypothesis, the group-liking,
       ; and the difference in attitudes between the worker and one of their link neighbors
       set change-amt change-amt + ( hyp1-degree / 100 ) * ( group-liking / 100 ) * 
           ( [ attitude ] of one-of link-neighbors - attitude )
       set track track + 1
     ]
end

to talk-to-boss ; worker procedure
  ; the degree of the hypothesis is used to limit how often the worker talks to his boss,
  ; since workers will most likely talk to their coworkers more often than they do with their boss
  if random 100 <= hyp2-degree [
  ; the worker updates his change-amt by his amount of expertise, liking of his boss, 
  ; degree of the hypothesis, and the difference in attitude of his boss 
  set change-amt change-amt + ( 100 - expertise ) / 100 * ( boss-liking / 100 ) * 
         ( hyp2-degree / 100 ) * ( [ attitude ] of boss group-membership - attitude )
  ]
end

to crit-mass-effect ; worker procedure
  ; to implement this, we assume that even if a worker doesn't have a link with 
  ; all the members of his group, the effect of the technology increases anyway
  if count workers with [ group-membership = [ group-membership ] of myself and adopt = true ] > 
     threshold / 100 * (count workers with [ group-membership = [ group-membership ] of myself ] ) 
     [ set change-amt change-amt + value-of-threshold ]
end

to reduce-influence
  ; the reduction factor decreases the size of the change amount over time
  set change-amt change-amt * reduction-factor
end
@#$#@#$#@
GRAPHICS-WINDOW
965
17
1321
394
16
16
10.5
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks

SLIDER
14
261
186
294
workgroup-size
workgroup-size
1
50
10
1
1
NIL
HORIZONTAL

SLIDER
14
293
186
326
number-workgroups
number-workgroups
1
10
4
1
1
NIL
HORIZONTAL

BUTTON
815
10
878
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
855
50
918
83
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
14
228
186
261
average-node-degree
average-node-degree
1
workgroup-size - 1
5
1
1
NIL
HORIZONTAL

SWITCH
36
186
162
219
Group-liking?
Group-liking?
0
1
-1000

TEXTBOX
12
137
162
179
Hypothesis 1: Fulk 1993- Workgroup attitudes predict individual attitudes\\n
11
0.0
1

SWITCH
270
70
411
103
Boss-influence?
Boss-influence?
0
1
-1000

TEXTBOX
253
11
403
67
Hypothesis 2: Leonard-Barton & Deschamps - managers influence those more who are less skilled
11
0.0
1

TEXTBOX
492
13
642
69
Hypothesis 3: Kraut et al - technology is more valuable once it has reached a critical mass
11
0.0
1

SWITCH
512
78
643
111
Critical-mass?
Critical-mass?
0
1
-1000

SWITCH
233
155
336
188
training?
training?
0
1
-1000

TEXTBOX
502
215
652
257
Hypothesis 4: Karahanna - interactions with others less influential over time
11
0.0
1

SWITCH
505
272
662
305
Reduce-influence?
Reduce-influence?
1
1
-1000

TEXTBOX
14
10
164
38
Global variables when Hypothesis 1 is not in effect
11
0.0
1

SLIDER
9
43
181
76
number-workers
number-workers
0
100
13
1
1
NIL
HORIZONTAL

SLIDER
9
75
181
108
density
density
0
100
38
1
1
NIL
HORIZONTAL

SLIDER
770
135
942
168
max-init-attitude
max-init-attitude
0
100
9
1
1
NIL
HORIZONTAL

SLIDER
770
168
942
201
min-init-attitude
min-init-attitude
0
max-init-attitude
0
1
1
NIL
HORIZONTAL

SLIDER
14
326
186
359
hyp1-degree
hyp1-degree
0
100
20
1
1
NIL
HORIZONTAL

SLIDER
255
112
427
145
hyp2-degree
hyp2-degree
0
100
26
1
1
NIL
HORIZONTAL

SLIDER
495
119
667
152
threshold
threshold
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
498
315
670
348
amt-reduction
amt-reduction
0
5
2
1
1
NIL
HORIZONTAL

SLIDER
495
152
667
185
value-of-threshold
value-of-threshold
0
100
20
1
1
NIL
HORIZONTAL

BUTTON
765
50
842
83
go-once
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
771
112
921
130
Initial Attitudes of Workers
11
0.0
1

TEXTBOX
769
229
919
247
Initial Attitudes of Bosses
11
0.0
1

SLIDER
769
254
941
287
max-init-att
max-init-att
0
100
51
1
1
NIL
HORIZONTAL

SLIDER
769
287
941
320
min-init-att
min-init-att
0
max-init-att
0
1
1
NIL
HORIZONTAL

MONITOR
1031
413
1112
458
NIL
change-time
1
1
11

MONITOR
1118
413
1221
458
NIL
reduction-factor
17
1
11

SWITCH
345
155
476
188
training-time?
training-time?
1
1
-1000

SLIDER
254
236
426
269
training-time
training-time
0
500
250
1
1
NIL
HORIZONTAL

TEXTBOX
233
345
383
363
Expertise of Workers
11
0.0
1

SLIDER
253
366
425
399
max-init-expertise
max-init-expertise
0
100
52
1
1
NIL
HORIZONTAL

SLIDER
253
399
425
432
min-init-expertise
min-init-expertise
0
max-init-expertise
0
1
1
NIL
HORIZONTAL

SLIDER
14
392
186
425
min-init-group-liking
min-init-group-liking
0
max-init-group-liking
0
1
1
NIL
HORIZONTAL

SLIDER
14
359
186
392
max-init-group-liking
max-init-group-liking
1
100
46
1
1
NIL
HORIZONTAL

SLIDER
254
270
426
303
max-init-boss-liking
max-init-boss-liking
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
254
304
426
337
min-init-boss-liking
min-init-boss-liking
0
max-init-boss-liking
0
1
1
NIL
HORIZONTAL

SLIDER
254
203
426
236
training-effect
training-effect
0
100
50
1
1
NIL
HORIZONTAL

@#$#@#$#@
WHAT IS IT?
-----------
This model attempts to use theories of social influence to determine whether people will decide to adopt a technology or reject it, based on a variety of social factors.  There are four main hypotheses that this model tests:
1. People are influenced by the opinions of others in their workgroups
2. People are influenced by the opinions of their bosses (and information passed down to them as a function of training)
3. Technology is more valuable to people once it reaches a critical mass
4. The influence of the opinions of others are reduced over time

HOW IT WORKS
------------
Each hypothesis has a switch that can be turned on or off to indicate that the hypothesis is in effect.  A few of the hypotheses also have sub-hypotheses that affect the overall amount that each agent changes their attitude towards the technology. 

At each tick, every worker updates his attitude by a change-amount.  This change amount is the result of the affects from each hypothesis in the following ways:
1. Workgroup influence: the worker talks to some or all of the workers he is linked to, and updates the change amount by the differences between his and everyone else's attitudes, weighted by how much the worker likes his group and the degree to which the overall workgroup influences each worker.
2. Boss influence: the worker talks to their boss either every tick or every few ticks, and updates his change amount by the difference between his opinion and his boss's opinion, weighted by the worker's expertise, liking of his boss, and degree that he is influenced by his boss.  There is also an option to have training, scheduled at a specifice time period, or scheduled when noone has made a new adopt or reject decision for 50 time units.  When either of these training hypotheses are in effect, a training is held once, and all workers who haven't made an adopt/reject decision update their attitudes by the value of the training.
3. When the critical mass hypothesis is in effect, once the number of coworkers in an employee's workgroup is above a certain threshold, the value of the technology drastically increases by a specified amount each time period.
4. When the reduction of influence hypothesis is in effect, the overall change amount that each worker has kept track of is reduced by a reduction amount that decreases each time period.

At the end of each tick each worker again checks his/her attitude and if it is 100 or greater, decides to adopt the technology, and if it is 0 or below, decides to reject the technology.

THINGS TO TRY
-------------
Since the workgroup hypothesis is a relatively fundamental theory regarding technology adoption, it is useful to keep it on during all of the experiments, but it is interesting to see where the initial conditions determine that the technology will not be adopted, for example low worker attitudes and high expertise, and no training or bosses who are not in favor of the technology.

EXTENDING THE MODEL
-------------------
Another important aspect of technology implementation is the ability of technologies to be interpreted in different ways, no matter how rigid the uses the original software developers intended.  An interesting extension would be to not only influence attitudes but perform the same influence processes on the particular way an employee uses the technology.

One other possible extension concerns the difference between the actual attitudes of a worker's group and his perception of their attitudes.  Frequently, these values are different, especially in situations where a worker does not interact with a particular employee very much.  This feature would be an interesting extension to the model as well.

NETLOGO FEATURES
----------------
One of the useful features of NetLogo is the ability to define sliders based on the values of other sliders.  In particular, when sliders define a maximum and minimum value of a range, there is no built-in ability to throw an error when the maximum value is less than the minimum value. Being able to define the slider so that the maximum value of the minumum slider is the value chosen on the maximum value slider replaces the need for this in a much simpler way.

When looking for random agents, NetLogo is also useful, because the process of selecting turtles to "move" is random, so this reduces the need for many random number generators, which could be very cumbersome in a model that requires many random behaviors, specifically in any models involving human agents.

RELATED MODELS
--------------
Some other related models are those in the Models Library are Virus on a Network, which also models how a value spreads across a network, and Diffusion on a Directed Network.


CREDITS AND REFERENCES
----------------------
I would like to thank Professor Paul Leonardi for his guidance in narrowing down the definition of my model and suggesting hypothesis combinations that would be useful to test.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person business
false
0
Rectangle -1 true false 120 90 180 180
Polygon -13345367 true false 135 90 150 105 135 180 150 195 165 180 150 105 165 90
Polygon -7500403 true true 120 90 105 90 60 195 90 210 116 154 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 183 153 210 210 240 195 195 90 180 90 150 165
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 76 172 91
Line -16777216 false 172 90 161 94
Line -16777216 false 128 90 139 94
Polygon -13345367 true false 195 225 195 300 270 270 270 195
Rectangle -13791810 true false 180 225 195 300
Polygon -14835848 true false 180 226 195 226 270 196 255 196
Polygon -13345367 true false 209 202 209 216 244 202 243 188
Line -16777216 false 180 90 150 165
Line -16777216 false 120 90 150 165

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Situation 1" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>count workers with [ adopt = true or reject = true ] = count workers</exitCondition>
    <metric>count workers with [ adopt = true]</metric>
    <metric>count workers with [ reject = true ]</metric>
    <metric>count workers with [ adopt = false and reject = false ]</metric>
    <steppedValueSet variable="min-init-attitude" first="0" step="1" last="50"/>
  </experiment>
  <experiment name="Situation 2" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="2000"/>
    <exitCondition>count workers with [ adopt = true or reject = true ] = count workers</exitCondition>
    <metric>count workers with [ adopt = true ]</metric>
    <metric>count workers with [ reject = true ]</metric>
    <metric>count workers with [ adopt = false and reject = false ]</metric>
    <steppedValueSet variable="min-init-group-liking" first="0" step="1" last="50"/>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
