globals [
  king
  smith-leader
  john-leader
  ]

directed-link-breed [friendships friendship]

breed [smiths smith]

breed [johns john]

breed [does doe]

breed [janes jane]

turtles-own [
  in-friends
  out-friends
  total-friend-set
  total-friends
  my-leader
  extended-network
  wealth
  age
  racist
]

to setup
  clear-all
  ask patches [set pcolor green]
  create-smiths 25
  create-johns 25
  create-janes 25
  create-does 25
  ask turtles [
     move-to one-of patches
     set wealth 1000
     set my-leader self
     set racist ifelse-value(random 100 >= initial-racism) [0] [1] 
   ]
  do-breeds

   
end   
    
      
to go
   ask turtles[
  wiggle
  set out-friends count out-friendship-neighbors
  set in-friends count in-friendship-neighbors
  set total-friend-set (turtle-set in-friendship-neighbors out-friendship-neighbors self)
  set total-friends count total-friend-set
  maintain-max
  make-friends
  graves
  if count turtles < 101
  [
    immigrate
    babies
  ]
  ]
  update-turtles
  if ethnic-rivarly?
  [kill-ethnic-rival]
  if there-can-only-be-one?
  [kill-all-rivals]
  
  gravesmore
  update-globals
  do-plots
  do-breeds
  tick
  
end 

to do-breeds
  ask turtles [
    set shape "person"
    if breed = smiths
    [set color red]
    if breed = johns
    [set color blue]
    if breed = janes
    [set color orange]
    if breed = does
    [set color yellow]
  ]
end
to wiggle 
  rt random-float 360 fd 1
end

to make-friends
 let prospect one-of other turtles
  if prospect != nobody
  [
    if out-friends < 1
    [ifelse hard-racism? 
      [ifelse [racist] of self = 0
        [create-friendship-to prospect]
        [if [breed] of prospect = [breed] of self
          [create-friendship-to prospect]
        ]
        ]
      [create-friendship-to prospect]
    ]
  if out-friends = 1
  [let worst-friend min-one-of out-friendship-neighbors [total-friends]
    if worst-friend != nobody
    [ifelse [racist] of self = 1
      [if [breed] of self != [breed] of my-leader and [breed] of self = [breed] of prospect
        [ask out-friendship-to worst-friend [die] 
         create-friendship-to prospect]
       if ([breed] of self = [breed] of my-leader and [breed] of self = [breed] of prospect) or ([breed] of self != [breed] of my-leader and [breed] of self != [breed] of prospect)
       [if [total-friends] of prospect > [total-friends] of worst-friend
         [ask out-friendship-to worst-friend [die] 
           create-friendship-to prospect
         ]]
      ]
      [if [total-friends] of prospect > [total-friends] of worst-friend
         [ask out-friendship-to worst-friend [die] 
           create-friendship-to prospect
         ]]
    ]
  ]
  ]

end


to maintain-max
  let worst-out-friend min-one-of out-friendship-neighbors [total-friends]
  let worst-in-friend  min-one-of in-friendship-neighbors [total-friends]
  if worst-out-friend != nobody
  [
    if out-friends > 1
  [ask out-friendship-to worst-out-friend [die] ]
  ]
  if worst-in-friend != nobody  
    [if in-friends > 100
    [ask in-friendship-from worst-in-friend [die] ]
    ]
  
end
   
to update-globals
  set king one-of turtles with [total-friends = count turtles - 1]
  if count smiths > 0
  [
  ifelse king = nobody and [in-friends] of one-of smiths > 0 
  [set smith-leader max-one-of smiths [total-friends]]
  [set smith-leader nobody]
  ]
  if count johns > 0
  [  
  ifelse king = nobody and [in-friends] of one-of johns > 0 and count johns > 0
  [set john-leader max-one-of johns [total-friends]]
  [set john-leader nobody] 
  ] 
end  

to update-turtles
  ask turtles
  [set my-leader max-one-of (turtle-set out-friendship-neighbors self) [total-friends]
   set wealth ifelse-value (accumulate-wealth?) [wealth] [0] + ([total-friends] of my-leader) * ((100 - relative-wealth-from-power)+ ifelse-value (my-leader = self) 
     [ifelse-value ([total-friends] of self > 2) [relative-wealth-from-power] [0]] [0] +
      ifelse-value ([breed] of my-leader = [breed] of self) [ifelse-value ([total-friends] of my-leader > 2)[ethnic-benefit] [0]][0]) 
      
 
  set age age + 1
;  ifelse [breed] of my-leader != [breed] of self
;  [if reactionary-tendency > random 100
;    [set racist 1]] 
;  [if reactionary-tendency > random 100
;    [set racist 0]] 
]
  
end

to create-turtle  ;; patch procedure
  sprout 1 [
    set breed one-of (list smiths johns janes does) 
    set shape "person"
     set wealth 1000
     set my-leader self 
    set racist ifelse-value (50 > random 100)
    [1]
    [0]
    make-friends
    ]  
end



to immigrate
  if chance-of-immigrant > random 100
  [ask one-of patches [create-turtle]]
end
   
to babies
 if member? self max-n-of ((10 / 100) * count turtles) turtles [wealth]  
 [if 100 > random 100 
  [ hatch 1
    [ set wealth 1000
      wiggle
     if mutation-rate > random 100
     [set racist abs(racist - 1)
      set breed one-of (list smiths johns janes does) ]
     make-friends 
    ]
     ]]
end  

to graves
  if member? self min-n-of ((1 / 100) * count turtles) turtles [wealth] 
  [die]
  if 1 > random 5
  [if member? self min-n-of ((10 / 100) * count turtles) turtles [wealth] 
    [die]
  ]
end
to gravesmore
  if 200 > random 100
  [ask one-of turtles [die]]
end
to kill-ethnic-rival
  if ticks > 10 ;; without this delay, the model won't be able to run because none of the leaders will be defined
  [let smith-leaders (turtle-set smith-leader)
  let john-leaders (turtle-set john-leader)
  if smith-leader != nobody
  [ask smith-leader
  [ let rival one-of john-leaders with [xcor = [xcor] of self] with [ycor = [ycor] of self]
    if rival != nobody
    [if [total-friends] of self > [total-friends] of rival
      [ask rival
        [die]
      ]
    ]
  ]]
  if john-leader != nobody
  [ask john-leader
  [ let rival one-of smith-leaders with [xcor = [xcor] of self] with [ycor = [ycor] of self]
    if rival != nobody
    [if [total-friends] of self > [total-friends] of rival
      [ask rival
        [die]
      ]
    ]
  ]]
  ]
end

to kill-all-rivals
  ask turtles
  [if my-leader = self and in-friends > 0 ;; letting rivals have no followers basically makes everyone kill everyone else 
    [let rival one-of other turtles-here with [my-leader = self and in-friends
        > 0] ;; see above comment
      if rival != nobody
    [if [total-friends] of self > [total-friends] of rival
      [ask rival
        [die]
      ]
    ]
    ]
  ]
end

to do-plots
  set-current-plot "Racism"
  set-current-plot-pen "Reds"
  plot count smiths with [racist = 1]
  set-current-plot-pen "Blues"
  plot count johns with [racist = 1]
  set-current-plot-pen "Total"
  plot count turtles with [racist = 1]
  set-current-plot-pen "Oranges"
  plot count janes with [racist = 1]
  set-current-plot-pen "Yellows"
  plot count does with [racist = 1]
  set-current-plot "Population"
  set-current-plot-pen "Reds"
  plot count smiths
  set-current-plot-pen "Blues"
  plot count johns
  set-current-plot-pen "Total"
  plot count turtles
  set-current-plot-pen "Oranges"
  plot count janes
  set-current-plot-pen "Yellows"
  plot count does
end

to extra
if self = one-of min-n-of (25 / 100 * count turtles) turtles [wealth] and 20 > random 100
  [die]
if self = one-of max-n-of (25 / 100 * count turtles) turtles [wealth] and 20 > random 100
  [set wealth wealth / 2
    hatch 1
    [wiggle
     create-friendship-to my-leader
     set age 0]
  ]
;   ifelse my-leader = self
;  [set wealth wealth + (wealth-from-network * wealth-from-power * (count [total-friend-set] of my-leader with [breed != [breed] of self]
;    + ethnic-benefit * (count [total-friend-set] of my-leader with [breed = [breed] of self])))]
;  [set wealth wealth + (wealth-from-network * (count [total-friend-set] of my-leader with [breed != [breed] of self]
;    + ethnic-benefit * (count [total-friend-set] of my-leader with [breed = [breed] of self])))]
  if random 100 < mutation-rate
     [ifelse racist = true
       [set racist 0]
       [set racist true]]
end
  


   





  
      
     
@#$#@#$#@
GRAPHICS-WINDOW
580
10
1019
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks

BUTTON
57
88
123
121
NIL
setup\n\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
58
138
121
171
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
-4
195
214
228
there-can-only-be-one?
there-can-only-be-one?
1
1
-1000

SWITCH
6
240
153
273
ethnic-rivarly?
ethnic-rivarly?
1
1
-1000

PLOT
290
280
490
430
Racism
Time
Racists
0.0
10.0
0.0
100.0
true
true
PENS
"Reds" 1.0 0 -2674135 true
"Blues" 1.0 0 -13345367 true
"Total" 1.0 0 -16777216 true
"Oranges" 1.0 0 -955883 true
"Yellows" 1.0 0 -1184463 true

PLOT
5
380
205
530
Population
Time
Population
0.0
10.0
0.0
10.0
true
true
PENS
"Reds" 1.0 0 -2674135 true
"Blues" 1.0 0 -13345367 true
"Total" 1.0 0 -16777216 true
"Oranges" 1.0 0 -955883 true
"Yellows" 1.0 0 -1184463 true

SLIDER
330
140
527
173
ethnic-benefit
ethnic-benefit
0
100
0
1
1
NIL
HORIZONTAL

SLIDER
145
135
317
168
mutation-rate
mutation-rate
0
100
100
1
1
NIL
HORIZONTAL

SWITCH
145
20
282
53
hard-racism?
hard-racism?
1
1
-1000

SLIDER
40
305
212
338
initial-racism
initial-racism
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
35
345
222
378
chance-of-immigrant
chance-of-immigrant
0
100
20
1
1
NIL
HORIZONTAL

MONITOR
330
210
427
255
Ethnocentrics
count turtles with [racist = 1]
1
1
11

SLIDER
325
60
547
93
relative-wealth-from-power
relative-wealth-from-power
0
100
99
1
1
NIL
HORIZONTAL

SWITCH
135
75
312
108
accumulate-wealth?
accumulate-wealth?
0
1
-1000

@#$#@#$#@
WHAT IS IT?
-----------
Ethnic conflict is an ongoing horror subplot in the story of the human race. From Holocaust remembrance month to the ongoing genocide in Darfur, it is something that is often on our minds and that continuously has to be dealt with. However, it appears to be possible that such tendencies may have actually initially evolved to counteract other evolutionary effects that gave human beings incentives to split into non-cooperative groups and not work as effectively together. 

This is a model of an ancient land of knights, split into reds and blues. At first, they are all without lords, but being good knights, they seek out a someone to pledge their loyalty to. However, being good humans, they look out for their own interests, and if they see an opportunity to serve a lord with a greater following, they seize it. They are also capable of prejudice for their own kind, and violence, though these things are decided upon by the observer.


HOW IT WORKS
------------
Each knight walks around aimlessly, looking for a lord to pledge his allegiance to. If he's not committed and runs into another knight, he pledges his allegiance to that knight. If he IS committed and runs into another knight, he compares that knight's following to his current lord's: if it's greater, he switches. This goes on until a king is crowned. However, knights can be prejudiced for following those of their own kind, and only pledge allegiance to them, and lords are capable of violence against other lords they view as potential threats. 


HOW TO USE IT
-------------
The "percent-red" slider determines the percentage of knights that will be red, and the percentage that will be blue. The "there-can-be-only-one?" switch makes lords (knights with at least one follower) kill other lords they run into with less followers, and the "ethnic-rivalry?" switch makes the "leaders" of each race, or the member of that race with the most followers, kill the leader of the other if they happen to meet and the killer has more followers than the killee. The prejudice sliders set the level of prejudice for following one's own kind, with the number being the probability that each knight will only consider following a member of its own race at any given time.


THINGS TO NOTICE
----------------
If the switches are all off and the prejudice sliders are set to 0, notice how a king emerges every time, with every knight as a follower. If the prejudice is high for one race but not the other, that race will tend to produce the king, even if they're a minority. If the prejudice is high for both, they'll tend to split into ethnic groups each with its own leader, but eventually merge unless both prejudices are at 100 percent or only the prejudice for the minority is 100 percent. If prejudice is high for a minority, and the kill rival switches are turned on, far more members of that minority will die than if they are not prejudiced.


THINGS TO TRY
-------------
First, run the model with the switches off and prejudice sliders set to zero and see an undisputed ruler peacefully emerge. Next, set the percent-red slider to 40 and the red prejudice 100, and see a red king peacefully emerge. Next, set the percent red slider to 5 and the red prejudice to 100, and see a tiny red group and huge blue group, each with their own leader (except in very rare cases where red get lucky and manage to make a king). Next, set percent red 50 and prejudice for both groups 100, and see two equal, unconnected groups with their own leaders emerge. Next, set the percent red slider to 20, turn on the rival switches, and watch a fairly violent transition to a usually blue single leader occur. Next, keep the settings the same but turn red prejudice up to 100, and watch red either brutally take over Saddam Hussein style or get completely wiped out.


EXTENDING THE MODEL
-------------------
Try making prejudice levels normally distributed across each knight, and making knights reproduce and die, seeing how prejudice levels evolve over time. 


NETLOGO FEATURES
----------------
The "make-friends" procedure comes from a model of preferential attachment that is based on turtles having to "economize" on the number and kind of links they have, and that uses the concept of a "marginal friend" (called worst-friend in the procedures) to determine who to cut out of a network if a better opportunity arises.


RELATED MODELS
--------------
This is related to the RismanPreferentialAttachment model on Modeling Commons.


CREDITS AND REFERENCES
----------------------
All of the code written by and ideas produced by Alex Risman, as far as he knows.

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Critical-King-Point" repetitions="1" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="20000"/>
    <exitCondition>king != nobody</exitCondition>
    <metric>[breed] of king</metric>
    <enumeratedValueSet variable="blue-prejudice">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-prejudice">
      <value value="100"/>
    </enumeratedValueSet>
    <steppedValueSet variable="percent-red" first="0" step="1" last="100"/>
  </experiment>
  <experiment name="Proportion-King" repetitions="100" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <exitCondition>king != nobody</exitCondition>
    <metric>[breed] of max-one-of turtles [total-friends]</metric>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-prejudice">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="percent-red">
      <value value="70"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-prejudice">
      <value value="0"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="disparate-power-1" repetitions="100" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="5000"/>
    <metric>count turtles with [racist = 1]</metric>
    <metric>mean [racist] of turtles</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wealth-from-network">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="wealth-from-power">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-power-wealth" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="3500"/>
    <metric>count turtles with [racist = 1]</metric>
    <metric>mean [racist] of turtles</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-immigrant-power-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="10"/>
      <value value="40"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-mutation-power-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="0"/>
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-hard-power-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-accum-power-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="high-mutation-power-wealth" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="relative-wealth-from-power" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-immigrant" repetitions="2" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <steppedValueSet variable="chance-of-immigrant" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="relative-wealth-from-power">
      <value value="99"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="varied-mutation" repetitions="2" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1500"/>
    <metric>mean [racist] of turtles * 100</metric>
    <enumeratedValueSet variable="initial-racism">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="chance-of-immigrant">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="relative-wealth-from-power">
      <value value="99"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-benefit">
      <value value="0"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="accumulate-wealth?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="hard-racism?">
      <value value="false"/>
    </enumeratedValueSet>
    <steppedValueSet variable="mutation-rate" first="0" step="1" last="100"/>
    <enumeratedValueSet variable="there-can-only-be-one?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="ethnic-rivarly?">
      <value value="false"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
