globals [
  current-population
]

turtles-own [
  personal-interest
  interest-level
  attention-span
  thought-size
  knowledge-counter
  conversing-with
  current-action
  space-out-duration
]

to setup
    ca
    reset-ticks
    set current-population population
    crt population [
      setxy random-xcor random-ycor
      set shape "person"
      set size 2
      if (interest-variation = "none") [ set color 75 ]
      if (interest-variation = "small") [ set color 75 + (random 5 * -1 ^ random 2) ]
      if (interest-variation = "medium") [ set color 75 + (random 3 * 10 * -1 ^ random 2) + (random 5 * -1 ^ random 2) ]
      if (interest-variation = "large") [ set color 75 + (random 5 * 10 * -1 ^ random 2) + (random 5 * -1 ^ random 2) ]
      set knowledge-counter 0
      set interest-level 0
      set label knowledge-counter
      set current-action "walking"
      set attention-span 0
      set personal-interest color
    ]
end

to go
  ask turtles [
    ifelse (current-action = "walking") [
      move
      check-location
    ] [
      ifelse (current-action = "talking")
      [ talk ] [listen]
    ]
  ]
  tick
end

; turtle methods

to move
  rt random-float 90 * -1 ^ random 2
  fd 1
end

to check-location
  if (count other turtles-here with [current-action = "walking"] > 0) [
    create-link-with one-of other turtles-here with [current-action = "walking"]
    set current-action "talking"
    face one-of link-neighbors
    set conversing-with [who] of one-of link-neighbors
    set-interest-level
    set-thought-size
    ask link-neighbors [
      set current-action "listening"
      set conversing-with [who] of myself
      face myself
      set-interest-level
      set-attention-span
    ]
  ]
end

to talk
  set thought-size (thought-size - 1)
  if (thought-size <= 0) [
    set current-action "listening"
    set-attention-span
  ]
end

to listen
  ifelse (attention-span > 0) [
    set attention-span (attention-span - 1)
    if ([current-action] of one-of link-neighbors = "talking") [ 
      set knowledge-counter (knowledge-counter + (1 - interest-level))
      set label precision knowledge-counter 2
    ]
    if (attention-span <= 0) [ set-space-out-duration ]
  ] [
    set space-out-duration (space-out-duration - 1)
    if (space-out-duration <= 0) [ set-attention-span ]
  ]
  if ([current-action] of one-of link-neighbors = "listening") [
    ifelse (attention-span = 0) [
      set current-action "walking"
      rt 180
      fd 2
      ask one-of link-neighbors [
        set current-action "walking"
        rt 180
        fd 2
        ]
      ask my-links [ die ]
    ] [
      set-thought-size
      if (thought-size > 10) [ set current-action "talking" ]
    ]
  ]
end

; set methods

to set-thought-size
  set thought-size random 300 * interest-level
end

to set-interest-level
  let difference abs (personal-interest - ([personal-interest] of one-of link-neighbors))
  ifelse (difference = 0)
  [ set interest-level .9 ] [
    ifelse (difference = 1)
    [ set interest-level .7 ]
    [ set interest-level 1 / difference ]
  ]
end
 
to set-attention-span
  set attention-span (average-attention-span + random 6 * -1 ^ random 2) + (average-attention-span * interest-level)
end

to set-space-out-duration
  set space-out-duration (average-space-out-duration + random 6 * -1 ^ random 2) + (average-space-out-duration * interest-level)
end  
@#$#@#$#@
GRAPHICS-WINDOW
308
8
997
446
17
10
19.4
1
10
1
1
1
0
1
1
1
-17
17
-10
10
0
0
1
ticks
30.0

SLIDER
17
9
290
42
population
population
0
100
50
1
1
people
HORIZONTAL

SLIDER
19
53
289
86
average-attention-span
average-attention-span
0
300
60
1
1
seconds
HORIZONTAL

SLIDER
17
96
291
129
average-space-out-duration
average-space-out-duration
0
60
10
1
1
seconds
HORIZONTAL

CHOOSER
17
141
132
186
interest-variation
interest-variation
"none" "small" "medium" "large"
3

BUTTON
144
147
211
181
setup
setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

BUTTON
225
147
289
181
go
go
T
1
T
OBSERVER
NIL
G
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model demonstrates my theory for the accumulation of knowledge through conversation. The idea is that people gain knowledge when they listen, and don't when they don't listen, as in they are either talking or walking around. If they are talking to someone they are similar to, they will be more interested in talking, but will learn less from the conversation. If they are talking to someone they are not very similar to, they will be less interested in talking, but will learn more from the conversation. Accordently, they will have a longer attention span and space out for a shorter period of time with someone more similar, and vice versa for someone less similar. After a certain period when no one has spoken, they will part ways and find someone new to talk to.

## HOW IT WORKS

Turtles move randomly. When they encounter another walking turtle, they start a conversation. Only one turtle can be talking at a time, but both can be listening. While one turtle talks, the other turtle "gains" knowledge, but "loses" attention, until they space out for a short duration. During this time, they don't "gain" any knowledge. After the period is over, they begin learning again, and their focus is reset. If no one is talking for long enough that one of the turtles loses focus, they both go back to walking.

## PROPOSAL FOR A REAL WORLD EXPERIMENT

My dream team would be Drs. Sid Horton, Galen Bodenhausen, and Jennifer Lackey. Dr. Horton has done research in memory process of language production and how character intimacy influences the processing of metaphoric utterances. This would benefit the project because it would be a good way of indicating interest similarity and conversation flow. Two people with similar interests will be more capable of holding an interlocuter-rich conversation. Dr. Bodenhausen has studied how stereotypes affects attention and memory. This would be a good angle because it would analyze how interest similarity affects attention span, knowledge acquisition, and memory retrieval. Dr. Lackey is interested in knowledge acquisition through language, and has written an article about testimony as a source of knowledge. Her expertise would shed light on how much people actually learn from conversation, especially if they have little pre-existing knowledge in the other person's interests.
This model doesn't have a specific experimental structure. One possible experiment would be similar to the "interest-variation" chooser. In other words, gather four test groups, one with people from a very specific field, such as neuroscience, one with a slightly larger range, such as neuroscience, linguistics, and biology, one with an even larger field, such as all of cognitive science, and one with a very large field, such as Weinberg. Subjects can have a conversation with only one person at a time, and it has to be about their own field and the field of the other person. When neither person has anything more to say for a period of time, they end the conversation and move on to someone else. The experimenters observe the conversations and make note of how interested the subjects seem, how long each person is talking, how long the pauses between dialogue are, and if a person appears to lose focus briefly. At the end, subjects can evaluate how much they learned in each conversation and how interested they were in the other person's field of interest. The experimenters would compare their observations with the reports given by the subjects to get an idea of how interest and knowledge acquisition are related.
This is by no means a perfect study, there are many flaws and sources of error, but I think it would be an interesting experiment if someone with experience in research methodology and design were to write out a proposal and experiment design.

## HOW TO USE IT

Use the sliders to adjust the population, average attention span, and average space out duration, and the drop down menu to change the variance in interests of the turtles. Average attention span and space out duration can be changed while the program is running.

## THINGS TO NOTICE

Notice the length of a conversation based on how similar the turtles are and how long they pay attention for. Notice how sometimes the knowledge counters go up together, and sometimes one goes up much more than the other.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
