
globals [
book_bid
book_ask
temp_book
revenue
counting
Sum_auction
k
Trasportion-cost
harvest-cost
B1
B2
hearing-n
life-cycle
db_transactions
aver_plot11
aver_plot12 
aver_plot13 
aver_plot21 
aver_plot22
aver_plot23
aver_react
mean_prof_t1
mean_prof_t2
mean_prof_t3
sales_info_h
sales_info_s
ag_h
bg_h
ag_s
bg_s
pos1
pos2
pos3
pm
]

breed [bidders bidder]
breed [actions action]

actions-own [
  Creation_day
  Hearing_Date
  Reserve_Price
  State
  Volume
  Species
  Location
  re-auctions
  harvesting-date
]

bidders-own [
  type_bidder
  type_risk_value
  type_risk_need
  point_value
  point_need
  score_risk
  profit_in
  actions_in
  vol_in
  day_in
  capacity
  need
  need_actual
  market_price
  process-cost
  Max_price
  Min_price
  Expected-sale
  asking_since
  Profit_rent
  slope
  Bidding
  best-bidding
  score
  score_bin
  interest_in
  harv_dates
  temp_vol
]

to setup

  ca
  import-drawing "map1.jpg"
  file-close-all
  file-open "test.txt"
  file-print "new model"
  file-write "Operation"
  file-write "Agent"
  file-write "Period"
  file-write "Vol"
  file-write "Type"
  file-write "Location"
  file-write "HD"
  file-write "RP"
  file-write "MP"
  file-write "mean"
  file-write "Wins"
  file-write "Rem_cap"
  file-write "Action"
  file-write "Type_action"
  file-print ""
  set db_transactions [] ; pos 0 = Species, 1 = location, 2 = unit. reserve price, 3 = unit. winning price, 4 = Number of re-auctions 
  set temp_book []
  set book_bid []
  set aver_react []
  set book_ask []
  set sales_info_h []
  set sales_info_s []
  set mean_prof_t1 []
  set mean_prof_t2 []
  set mean_prof_t3 []
  set Trasportion-cost 1
  set revenue []
  set harvest-cost [4 5 6]       ;1= flat 2= swamp 3= mountain
  Set B1 [2 4] ; species
  Set B2 [5 4 3]                 ;5= flat 4= swamp 3= mountain
  set hearing-n 0
  set life-cycle []
  set pm[]
  
  repeat number_of_bidders [set book_ask lput 0 book_ask]
  
  ask patches [set pcolor green + 3]
  
  create-bidders number_of_bidders 
  ask bidders [create_parametres
    setxy random-xcor random-ycor]
  
  set-default-shape bidders "house" 
  set counting 0
  set Sum_auction 0
  set k 0
end


to go
  
  let mean_n_auction (Mean_Auction_per_year * Periodicity / 365) ; 
  let n_auction floor mean_n_auction + random 2
  if k / periodicity = int(k / periodicity)
   [
     create-actions n_auction 
     [ 
       setxy random-xcor random-ycor
       set size 2
       set color green
       set Creation_day ticks
       set Hearing_Date ticks + periodicity
       set State 1;available
       Set Volume 10 + random 20
       let kkk random 100
       ifelse kkk > %_Softwood 
       [Set Species "Hardwood"]
       [Set Species "Softwood"]
       Set Location random 3 
       let bb1 0
       let bb2 0
       ifelse species = "Hardwood"
       [set bb1 item 1 B1]
       [set bb1 item 0 B1]
       set bb2 item location B2
       set Reserve_Price (volume * (bb1 + bb2)) * 0.7
       ;set market_price int(Reserve_Price * (5 + random-normal 0 1))
       set harvesting-date ((random 3) + 1) * 180
       file-write "CR"
       file-write [who] of self 
       file-write ticks
       file-write volume
       file-write Species
       file-write location
       file-write Hearing_date
       file-write Reserve_Price
       file-print ""
      ]
     set Sum_auction Sum_auction + n_auction
   ]
   set k k + 1
   if k / 365 = int(k / 365)     
   [user-message (word " Year " (k / 365) " is finished ")]
   
   set-default-shape actions "tree"
hearing-date 
update_capacity
harvesting
transform
update_trend
plotting
    tick
    if hearing-n != 0 
    [ask bidders 
      [set asking_since asking_since + 1]
    ]
end

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;; hearing-date ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; hearing-date ;;;;;;;;;;;;;;;;;;;;;;
 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
to hearing-date 
 
let temp1 [hearing_date] of actions          ;here we define the set of hearings dates 
let q_h length(filter [? = ticks] temp1)     ;how many actions do we have for auctioning today?
set book_bid []
  if q_h > 0
  [ 
   set book_bid [who] of actions with [hearing_date = ticks]   ;all the actions with hearing today, will be audicted at the same time
   let i 0
   ask bidders [
     set Max_price []
     set Min_price []
     set score []
     set score_bin []
     set Bidding []
     set temp_vol 0
  
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; SCORING ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
     
     set i 0
     while [i < length(book_bid)]
     [
       let posi length(Max_price)
       let act item i book_bid
       let vvol [volume] of action act
       let distt distancexy [xcor] of action act [ycor] of action act
       let hharv item ([location] of action act) harvest-cost
       let mk_p 0
       set Max_price lput (vvol * (market_price -(process-cost + hharv + distt * Trasportion-cost))) Max_price
       set Min_price lput (1.05 * ([Reserve_price] of action act)) Min_price
       ;if item posi Min_price > [Reserve_price] of action act
       ;  [set Min_price replace-item posi Min_price ((1 - need / capacity) * (last(Min_price) - [Reserve_price] of action act) + [Reserve_price] of action act)]
       if last(Max_price) < 0 [
         set Max_price replace-item posi Max_price 0 
         set Min_price replace-item posi Min_price 0
       ]
       ;if last(Min_price) < 0 [
       ;  set Min_price replace-item posi Min_price 0 
       ;]
       
       ifelse distt < Radius                                           ;Maximum Radius that bidders are interested to participate
       [
         let v0 last(min_price)
         let v4 last(max_price)
         let diff v4 - v0
         let v2 (v0 + diff / 2)
         let v1 (v0 + diff / 4)
         let v3 (v0 + 3 * diff / 4)
         let desvi diff / 12
         
         if type_risk_need = 1
           [set bidding lput(random-normal v1 desvi) bidding
             set need_actual need
             set need 2 * need + need * (point_need * change_rate_need)]
         if type_risk_need = 2
           [set bidding lput(random-normal v3 desvi) bidding
             set need_actual need
             set need 1.2 * need + need * (point_need * change_rate_need)]
         if type_risk_need = 3
           [let v ([volume] of action act) 
             let d distancexy [xcor] of action act [ycor] of action act
             set need_actual need
             set need 1.2 * need + need * (point_need * change_rate_need)
             let bid3 0
             ifelse [Species] of action act = "Hardwood"
             [set bid3 (ag_h * d + bg_h) * v]
             [set bid3 (ag_s * d + bg_s) * v]
             set bidding lput(bid3) bidding
             ;set bidding lput(random-normal v2 desvi) bidding
           ]   
         
         if type_risk_value = 1
         [set bidding lput(point_value * (diff / 1) + v0) bidding]
         if type_risk_value = 2
         [set bidding lput(point_value * (diff / 1) + v0) bidding]
         if type_risk_value = 3
         [set bidding lput(point_value * (diff / 1) + v0) bidding]
         
         
         if last(Bidding) >= last(max_price)
         [set bidding replace-item posi bidding last(max_price)]
         
         ifelse last(Bidding) >= [Reserve_Price] of action act and need >= [volume] of action act
         [if Type_bidder = "lumber"
           [ifelse [Species] of action act = "Softwood"
             [set score lput 0 score]
             [set score lput [volume] of action act score]]
         if Type_bidder = "paper"
           [ifelse [Species] of action act = "Hardwood"
             [set score lput 0 score]
             [set score lput [volume] of action act score]]
         if Type_bidder = "logger"
           [set score lput [volume] of action act score]
         ]
         [set score lput 0 score
         ]  
         
       ]
       [set bidding lput 0 bidding
         set score lput 0 score
       ]
       
       set i i + 1   
     ]
     
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; COMBINATORIAL BIDDING in each Item Individually;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
     
     let act_inter_in []               ;Here we exclude the interest auctions (non zero items in Score)
     
     set i 0
     while [i < length(score)]
     [if item i score != 0
       [set act_inter_in lput (item i book_bid) act_inter_in
       ]
     set i i + 1]
     
     let score_bin_temp []             ; Defining Binary
     let score_of_comb []              ; Defining Possible solution using Binary
     
     if length(act_inter_in) > 0
     [
       ifelse length(act_inter_in) = 1
       [set score_bin_temp lput [] score_bin_temp
         let sccc [volume] of action (item 0 act_inter_in) / (distancexy [xcor] of action (item 0 act_inter_in) [ycor] of action (item 0 act_inter_in))
         set score_of_comb lput sccc score_of_comb
       ]
       [set i 0
         while [i < 2 ^ length(act_inter_in)]
         [set score_bin_temp lput [] score_bin_temp
           set score_of_comb lput 0 score_of_comb
           set i i + 1]
         set score_of_comb remove-item last(score_of_comb) score_of_comb   ;????????
       ]
       
       ifelse length(act_inter_in) = 1    
       [ set score_bin_temp [[1]]
         set score_bin act_inter_in
         create-link-to action (item 0 act_inter_in)]
       
       [let j 0
         let change 1
         while [j < length(act_inter_in)]
         [set i 0
           let val 0
           while [i < 2 ^ length(act_inter_in)]
           [if i / change = int(i / change)
             [ifelse val = 0
               [set val 1]
               [set val 0]]
           set score_bin_temp replace-item i score_bin_temp fput val item i score_bin_temp
           set i i + 1
           ] 
           set change change * 2
           set j j + 1
         ]
         
         set i 0
         while [i < 2 ^ length(act_inter_in)]
         [
           let temp_array []
           set j 0
           while [j < length(item i score_bin_temp)]
           [if item j (item i score_bin_temp) != 0
             [set temp_array lput (item j act_inter_in) temp_array]
           set j j + 1]
           if length(temp_array) > 0
           [set score_bin lput temp_array score_bin]
           set i i + 1  
         ]
         
         ;here we use an index to score the possible solutions
         set i 0
         while [i < length(score_bin)]
         [
           let vol_temp 0
           let dist_temp 0
           let index 0
           let pr [who] of self
           set j 0
           while [j < length(item i score_bin)]
           [let act item j (item i score_bin)
             set vol_temp vol_temp + [volume] of action act
             ifelse pr = [who] of self
             [set dist_temp (distancexy [xcor] of action act [ycor] of action act)
               create-link-to action act
             ]
             [ifelse pr = last(item i score_bin)
               [set dist_temp (distancexy [xcor] of action act [ycor] of action act) + dist_temp
                 create-link-to action pr]
               [ask action pr 
                 [set dist_temp (distancexy [xcor] of action act [ycor] of action act) + dist_temp
                   create-link-to action act]
               ]
             ]
             ;user-message(word "we've analysed the distance between " pr " to action " act)
             set pr act
             set j j + 1]
           
           ifelse vol_temp > need
           [set index 999999]
           [set index (dist_temp / vol_temp)]
           set score_of_comb replace-item i score_of_comb index
           set i i + 1  
         ]
         
       ]
       
     ]
     
     if length(score_of_comb) != 0
     [let win_sco min(score_of_comb)
       let win_pos position min(score_of_comb) score_of_comb
       let win_sol item win_pos score_bin
       if is-list? win_sol
       [set i 0
         while [i < length(book_bid)]
         [let j 0
           let act item i book_bid
           let flag 0
           while [j < length(win_sol)]
           [
             if act = item j win_sol
             [set flag 1]
             set j j + 1]
           if flag = 0
           [set score replace-item i score 0]
           set i i + 1
         ]]
       if type_risk_need = 3
       [
         ;user-message( word "the book_bid is " book_bid "the agent " [who] of self " is considering the actions " act_inter_in ", so the universe of possible combinations have " length(score_bin) " options and the book is " score_bin " and the score of these options are " score_of_comb ", so the winner is the lower score " win_sco " which belonges to the solution " win_sol ", and the new score is " score)
       ]
     ]
     
   ]
   
   set i 0
   let rev_temp 0
   
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; WINING PROCESS ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
   set hearing-n hearing-n + 1
   while [i < length(book_bid)]
     [set book_ask []
       let act item i book_bid
       set book_ask filter[? > 0] [item i Bidding] of bidders with [item i score > 0]
       ;user-message(word "the book_bid is " book_bid ", and the book_ask is " book_ask)
       ifelse length(book_ask) > 0
       [let max_mon max(book_ask)
         let mean_mon mean(book_ask)
         let max_bidder one-of([who] of bidders with [length(filter[? = max_mon] bidding) > 0])
         let disttt 0
         let volll 0
         ;user-message(word "and the winner is " max_bidder " with a bid of " max_mon)
         ask bidder max_bidder [
           set actions_in lput act actions_in 
           set vol_in lput [Volume] of action act vol_in
           set day_in lput ticks day_in
           let winn position max(score) score
           set need need - [volume] of action act
           set pm lput [point_value] of self pm
           set asking_since 0
           set harv_dates lput (([harvesting-date] of action act) + ticks) harv_dates
           set disttt distancexy [xcor] of action act [ycor] of action act
           set volll [volume] of action act
           set temp_vol temp_vol + volll
           file-write "WIN"
           file-write [who] of self
           file-write ticks
           file-write ""
           file-write type_bidder
           file-write ""
           file-write ""
           file-write [reserve_price] of action act
           file-write max_mon
           file-write mean_mon
           file-write length(actions_in)
           file-write need
           file-write [who] of action act
           file-write [Species] of action act
           file-print ""
           let db_temp [0 0 0 0 0]
           set db_temp replace-item 0 db_temp [Species] of action act
           set db_temp replace-item 1 db_temp [location] of action act
           set db_temp replace-item 2 db_temp (([Reserve_Price] of action act) / ([volume] of action act))
           set db_temp replace-item 3 db_temp (max_mon / [volume] of action act)
           set db_temp replace-item 4 db_temp [re-auctions] of action act
           set db_transactions lput(db_temp) db_transactions
         ]
         
         let sale []
         set sale lput disttt sale
         set sale lput (max_mon / volll) sale
         ifelse [species] of action act = "Hardwood"
         [set sales_info_h lput sale sales_info_h]
         [set sales_info_s lput sale sales_info_s]
         
         
         ask bidders with [item i bidding > 0 and item i score > 0] 
         [ 
           let maxiprice item i max_price
           let bbidding item i bidding
           ;set pn [point_value] of self
           if [who] of self = max_bidder
           [set profit_in lput ((maxiprice - bbidding) / bbidding) profit_in
            ; user-message (word "" [who] of self)
            ; ;set point_need 
             ;ifelse point_value - Change_rate_value < 0 and pn
             ;[set point_value 0]
             ;[set point_value point_value - Change_rate_value]  
           ]
           
           if [who] of self != max_bidder
           [set profit_in lput (((bbidding - max_mon) / bbidding) * 0)profit_in
             
             ;let sign random-float 1
             ;ifelse sign < 0.5 
             ;[set sign -1]
             ;[set sign 1]
             
             ;ifelse point_value + Change_rate_value > 1
             ;[set point_value 1]
             ;[set point_value point_value + Change_rate_value]
           ]  
           ;user-message(word "we just scored the agent " [who] of self)
         ]
         set rev_temp rev_temp + max_mon
         set life-cycle lput ((ticks - [Creation_day] of action act) / Periodicity - 1) life-cycle
         set aver_react lput ((sum(life-cycle) / length(life-cycle)) * 100) aver_react
         set-current-plot "% Re-auction"
         plot mean(aver_react)
         ask action act [die]
         output-show (word "Period : " ticks ", Action : " act ", Winner : " max_bidder ", Revenue : " max_mon)
         set temp_book []
       ]
       [ask action act [set hearing_date hearing_date + periodicity
         set re-auctions re-auctions + 1
       ]
       file-write "RE-ACT" 
       file-write act
       file-write ticks
       file-write ""
       file-write ""
       file-write ""
       file-write ""
       file-write ""
       file-write [re-auctions] of action act
       file-print ""
       ]
       score_strategies
       set i i + 1
     ]
   
   set revenue lput rev_temp revenue
   
  ]
  
  ask links [die]
  
  update_trend  
  
end


to transform

 if hearing-n = 12 and ticks = hearing-n * periodicity
    [
      ask bidders with [type_risk_need = 1] [
        let i random-float 1
        if i < 1 / 3
        [set type_risk_need 3]   
      ]
      ask bidders with [type_risk_need = 2] [
        let i random-float 1
        if i < 1 / 3
        [set type_risk_need 3]   
      ]
      if count(bidders with [type_risk_need = 3]) > 0
      [
        user-message(word "Now we have enter! We have " count(bidders with [type_risk_need = 3]) " agents of type 3")
      ]
    ]
  
  
end

to count_agents_type
ask bidders [
 if point_value <= (3 / 3)
  [set type_risk_value 3]
  if point_value <= (2 / 3)
  [set type_risk_value 2]
  if point_value <= (1 / 3)
[set type_risk_value 1]    
]
end

to score_strategies
  
  if count(bidders with[length(profit_in) > 0 and (type_risk_need = 1 or type_risk_value = 1)]) > 0
  [let temp_arr ([profit_in] of bidders with [length(profit_in) > 0 and (type_risk_need = 1 or type_risk_value = 1)])
    let i 0
    while [i < length(temp_arr)]
    [set mean_prof_t1 lput(mean(item i temp_arr)) mean_prof_t1
      set i i + 1]]
  if count(bidders with[length(profit_in) > 0 and (type_risk_need = 2 or type_risk_value = 2)]) > 0
  [let temp_arr ([profit_in] of bidders with [length(profit_in) > 0 and (type_risk_need = 2 or type_risk_value = 2)])
    let i 0
    while [i < length(temp_arr)]
    [set mean_prof_t2 lput(mean(item i temp_arr)) mean_prof_t2
      set i i + 1]]
  if count(bidders with[length(profit_in) > 0 and (type_risk_need = 3 or type_risk_value = 3)]) > 0
  [let temp_arr ([profit_in] of bidders with [length(profit_in) > 0 and (type_risk_need = 3 or type_risk_value = 3)])
    let i 0
    while [i < length(temp_arr)]
    [set mean_prof_t3 lput(mean(item i temp_arr)) mean_prof_t3
      set i i + 1]]
  
  
  set-current-plot "Mean Profit"
  set-current-plot-pen "Type 1"
  ifelse length(mean_prof_t1) > 0
  [plot mean(mean_prof_t1)]
  [plot 0]
  set-current-plot-pen "Type 2"
  ifelse length(mean_prof_t2) > 0
  [plot mean(mean_prof_t2)]
  [plot 0]
  set-current-plot-pen "Type 3"
  ifelse length(mean_prof_t3) > 0
  [plot mean(mean_prof_t3)]
  [plot 0]
  
  let temp_p1 0
  let temp_p2 0
  let temp_p3 0
  
  let sco_res_temp []
  ifelse mean_prof_t1 != [] 
  [set sco_res_temp lput mean(mean_prof_t1) sco_res_temp
    set temp_p1 mean(mean_prof_t1)]
  [set sco_res_temp lput 0 sco_res_temp
    set temp_p1 0]
  ifelse mean_prof_t2 != [] 
  [set sco_res_temp lput mean(mean_prof_t2) sco_res_temp
    set temp_p2 mean(mean_prof_t2)]
  [set sco_res_temp lput 0 sco_res_temp
    set temp_p2 0]
  ifelse mean_prof_t3 != [] 
  [set sco_res_temp lput mean(mean_prof_t3) sco_res_temp
    set temp_p3 mean(mean_prof_t3)]
  [set sco_res_temp lput 0 sco_res_temp
    set temp_p3 0]
  
  set sco_res_temp sort(sco_res_temp)
  set pos1 position temp_p1 sco_res_temp + 1
  set pos2 position temp_p2 sco_res_temp + 1
  set pos3 position temp_p3 sco_res_temp + 1
  
;user-message(word "now the learning process start, the sco_res_temp is " sco_res_temp ", and the positions 1, 2 and 3 are " pos1 " " pos2 " and " pos3)

  if length(pm) > 0
  [ask bidders [
  
    
    ifelse point_value < mean(pm)
    [if point_value + Change_rate_value < 1
      [set point_value point_value + 0.01 * Change_rate_value]]
    [if point_value - Change_rate_value > 0
      [set point_value point_value - 0.01 * Change_rate_value]]
    

    if type_risk_need = 1 or type_risk_need = 2 or type_risk_need = 3 
      [set point_need (need_actual - temp_vol) / need]
  ]]
  
  
  set-current-plot "Points of value"
  set-current-plot-pen "Winners"
  ifelse length(pm) > 0
  [plot mean(pm)]
  [plot 0]
  set-current-plot-pen "Type 1"
  ifelse count(bidders with [type_risk_value = 1]) > 0
  [plot mean([point_value] of bidders with [type_risk_value = 1])]
  [plot 0]
  set-current-plot-pen "Type 2"
  ifelse count(bidders with [type_risk_value = 2]) > 0
  [plot mean([point_value] of bidders with [type_risk_value = 2])]
  [plot 0]
  set-current-plot-pen "Type 3"
  ifelse count(bidders with [type_risk_value = 3]) > 0
  [plot mean([point_value] of bidders with [type_risk_value = 3])]
  [plot 0]
  
  set-current-plot "Profit Type of Strategy"
  set-current-plot-pen "Type 1"
  ifelse length(mean_prof_t1) > 0
  [plot last(mean_prof_t1)]
  [plot 0]
  set-current-plot-pen "Type 2"
  ifelse length(mean_prof_t2) > 0
  [plot last(mean_prof_t2)]
  [plot 0]
  set-current-plot-pen "Type 3"
   ifelse length(mean_prof_t3) > 0
   [plot last(mean_prof_t3)]
   [plot 0]
  
  ask bidders[
    set profit_in []
  ]
  
end

to update_capacity
  ask bidders [
    if need != capacity [
      let ratio capacity / 365
      ifelse need + ratio > capacity
      [set need capacity]
      [set need need + ratio]
    ]
   ]
end

to harvesting
ask bidders [
 if length(harv_dates) > 0
 [if ticks = min(harv_dates)
   [let pos position min(harv_dates) harv_dates
     set day_in remove-item pos day_in
     set vol_in remove-item pos vol_in 
     set harv_dates remove-item pos harv_dates
   ]
 ]  
]  

;ask actions [
; if ticks > harvesting-date + creation_day
; [   
;   die] 
;]
  
end

to plotting
  if length(revenue) > 0
  [set-current-plot "Revenue"
    ;plot mean(revenue)
    set-current-plot-pen "Revenue" 
    plot last(revenue)
    set-current-plot-pen "Mean_Rev"
    plot mean(revenue)
    ifelse int(min(revenue)) = int(max(revenue))
    [set-plot-y-range int(min(revenue) - 1) int(max(revenue) + 1)]
    [set-plot-y-range int(min(revenue)) int(max(revenue))]
 ]
  
  ;set-current-plot "how many trees are here?"
 ; plot count(actions)
  
  temp
  
  set-current-plot "Average Market-P/R-P"
    set-current-plot-pen "Softwood" 
    plot (aver_plot11 + aver_plot12  + aver_plot13) / 3
     set-current-plot-pen "Hardwood" 
    plot (aver_plot21  + aver_plot22  + aver_plot23) / 3
    ;set-current-plot-pen "Loc 2" 
    ;plot aver_plot12
    ;set-current-plot-pen "Loc 0" 
    ;plot aver_plot13
    
    
   ; set-current-plot "Hardwood Mean Market/R-P"
    ;set-current-plot-pen "Loc 1" 
    ;plot aver_plot21
    ;set-current-plot-pen "Loc 2" 
    ;plot aver_plot22
    ;set-current-plot-pen "Loc 0" 
    ;plot aver_plot23
  
 ; set-current-plot "Type of strategy of bidders"
;  set-current-plot-pen "Type 1"
 ; plot count(bidders with [type_risk = 1])
 ; set-current-plot-pen "Type 2"
 ; plot count(bidders with [type_risk = 2])
;  set-current-plot-pen "Type 3"
 ; plot count(bidders with [type_risk = 3])
  
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;; Measurig Mean Profit ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 


to temp
  
    set aver_plot11 0
    set aver_plot12 0  
    set aver_plot13 0  
    set aver_plot21 0  
    set aver_plot22 0
    set aver_plot23 0
    
    let temp_list11 []
    let temp_list12 []
    let temp_list13 []
    let temp_list21 []
    let temp_list22 []
    let temp_list23 []
    let i 0
        
  ;Softwood 1
  set temp_list11 filter [first ? = "Softwood"] db_transactions
    let result111 []
    foreach temp_list11
    [if item 1 ? = 1
      [set result111 lput item 2 ? result111
        ]
    ]
    let result112 []
    foreach temp_list11
    [if item 1 ? = 1
      [set result112 lput item 3 ? result112
        ]
    ]
    let result113 []
    set i 0
    while [i < length(result111)]
    [set result113 lput (item i result112 / item i result111) result113
      set i i + 1]
    ifelse length(result111) < 2
    [set aver_plot11 0]
    [set aver_plot11 mean(result113)]
  
  ;Softwood 2
  set temp_list12 filter [first ? = "Softwood"] db_transactions
    let result121 []
    foreach temp_list12
    [if item 1 ? = 2
      [set result121 lput item 2 ? result121
        ]
    ]
    let result122 []
    foreach temp_list12
    [if item 1 ? = 2
      [set result122 lput item 3 ? result122
        ]
    ]
    let result123 []
    set i 0
    while [i < length(result121)]
    [set result123 lput (item i result122 / item i result121) result123
      set i i + 1]
    ifelse length(result121) < 2
    [set aver_plot12 0]
    [set aver_plot12 mean(result123)]
  
  ;Softwood 3   ;;actually is not 3, is 0;;
  set temp_list13 filter [first ? = "Softwood"] db_transactions
    let result131 []
    foreach temp_list13
    [if item 1 ? = 0
      [set result131 lput item 2 ? result131
        ]
    ]
    let result132 []
    foreach temp_list13
    [if item 1 ? = 0
      [set result132 lput item 3 ? result132
        ]
    ]
    let result133 []
    set i 0
    while [i < length(result131)]
    [set result133 lput (item i result132 / item i result131) result133
      set i i + 1]
    ifelse length(result131) < 2
    [set aver_plot13 0]
    [set aver_plot13 mean(result133)]
  
  ;Hardwood 1
  set temp_list21 filter [first ? = "Hardwood"] db_transactions
    let result211 []
    foreach temp_list21
    [if item 1 ? = 1
      [set result211 lput item 2 ? result211
        ]
    ]
    let result212 []
    foreach temp_list21
    [if item 1 ? = 1
      [set result212 lput item 3 ? result212
        ]
    ]
    let result213 []
    set i 0
    while [i < length(result211)]
    [set result213 lput (item i result212 / item i result211) result213
      set i i + 1]
    ifelse length(result211) < 2
    [set aver_plot21 0]
    [set aver_plot21 mean(result213)]
  
  ;Hardwood 2
  set temp_list22 filter [first ? = "Hardwood"] db_transactions
    let result221 []
    foreach temp_list22
    [if item 1 ? = 2
      [set result221 lput item 2 ? result221
        ]
    ]
    let result222 []
    foreach temp_list22
    [if item 1 ? = 2
      [set result222 lput item 3 ? result222
        ]
    ]
    let result223 []
    set i 0
    while [i < length(result221)]
    [set result223 lput (item i result222 / item i result221) result223
      set i i + 1]
    ifelse length(result221) < 2
    [set aver_plot22 0]
    [set aver_plot22 mean(result223)]
  
  ;Hardwood 3 ;;actually is no 3, is 0
  set temp_list23 filter [first ? = "Hardwood"] db_transactions
    let result231 []
    foreach temp_list23
    [if item 1 ? = 0
      [set result231 lput item 2 ? result231
        ]
    ]
    let result232 []
    foreach temp_list23
    [if item 1 ? = 0
      [set result232 lput item 3 ? result232
        ]
    ]
    let result233 []
    set i 0
    while [i < length(result231)]
    [set result233 lput (item i result232 / item i result231) result233
      set i i + 1]
    ifelse length(result231) < 2
    [set aver_plot23 0]
    [set aver_plot23 mean(result233)]

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;; After Warm Up Period: Finding Regression ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

to update_trend
  
  if length(sales_info_h) > 1
  [set ag_h slope_m (sales_info_h)
    set bg_h intercept_b (sales_info_h)]
  if length(sales_info_s) > 1
  [set ag_s slope_m (sales_info_s)
    set bg_s intercept_b (sales_info_s)]
  
end     

to-report slope_m [data]
  
  let averagex averx (data)
  let averagey avery (data)
  let i 0
  let val1 0
  let val3 0
  while [i < length(data)]
  [set val1 val1 + (item 0 (item i data) - averagex) * (item 1 (item i data) - averagey)
    set val3 val3 + ((item 0 (item i data) - averagex) ^ 2)
    set i i + 1]
  let val4 (val1 / val3)
  report val4
  
end

to-report intercept_b [data]
  let averagex averx (data)
  let averagey avery (data)
  report averagey - slope_m (data) * averagex
end

to-report averx [data]
  
  let i 0
  let x []
  while [i < length(data)]
  [set x lput item 0 (item i data) x
    set i i + 1]
  let av_x mean(x)
  report av_x 
  
end

to-report avery [data]
  
  let i 0
  let y []
  while [i < length(data)]
  [set y lput item 0 (item i data) y
    set i i + 1]
  let av_y mean(y)
  report av_y
  
end

to new-bidders
 
  ;every 100 [
     if mouse-down? [
    create-bidders 1[
      set xcor mouse-xcor
      set ycor mouse-ycor
      set color black
      set shape "House"  
      create_parametres
    ]
  ]
 ; ]
end


to create_parametres
  set process-cost 5 + random-float 2
   ifelse (%_papermill + %_lumbermill + %_logger) != 100
   [user-message (word "Please Adjust Bidders_Distribution")]
   [let typ random 100
     
     if typ <= %_lumbermill
     [set type_bidder "lumber"
       set color blue
       set Capacity 50 + random 5
       set profit_rent 5 + random 5
       set need random capacity
       set market_price 1.1 * (process-cost + Trasportion-cost * 7 + 5 + 4)]   ; harvest cost + price of hardwood
     
     if typ >  %_lumbermill and typ <= (%_papermill + %_lumbermill)
     [set type_bidder "paper"
       set color yellow
       set Capacity 130 + random 20
       set profit_rent 5 + random 5 
       set need random capacity
       set market_price 1.1 * (process-cost + Trasportion-cost * 7 + 5 + 2)]  ; harvest cost + price of hardwood
     
     if typ > (%_papermill + %_lumbermill)
     [set type_bidder "logger"
       set color red
       set profit_rent 3 + random 2
       set capacity 400
       set need random capacity
       set market_price 1.05 * (process-cost + Trasportion-cost * 7 + 5 + 3)] ]  ; harvest cost + price of hardwood
   
   set asking_since 0
   
   ifelse Learning_Type = "Value change"
   [set type_risk_value (random 3) + 1
     if type_risk_value = 1
     [;set score_risk [1.5 1.2 1.2]
       set point_value 0 + random-float (1 / 3)]
     if type_risk_value = 2
     [;set score_risk [1.2 1.5 1.2]
       set point_value (1 / 3 ) + random-float (1 / 3)]
     if type_risk_value = 3
     [;set score_risk [1.2 1.2 1.5]
       set point_value (2 / 3) + random-float (1 / 3)]]
   
   [set type_risk_need (random 2) + 1
     set point_need 0]
   
   set vol_in []
   set day_in []
   set profit_in[]
   set harv_dates []
   set slope 0
   set size 1.5
   set actions_in []
  
end
@#$#@#$#@
GRAPHICS-WINDOW
224
11
676
484
16
16
13.4
1
10
1
1
1
0
0
0
1
-16
16
-16
16
0
0
1
ticks

BUTTON
82
39
145
72
Go
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
8
39
74
72
Setup
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
9
78
217
111
Number_of_Bidders
Number_of_Bidders
2
100
58
1
1
NIL
HORIZONTAL

PLOT
680
40
1038
186
Revenue
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"Revenue" 1.0 0 -7500403 true
"Mean_Rev" 1.0 0 -2674135 true

BUTTON
153
40
216
73
Step
Go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

OUTPUT
865
313
1248
482
10

MONITOR
945
104
1038
149
Total Revenue
sum(revenue)
2
1
11

PLOT
1043
40
1248
185
Average Market-P/R-P
NIL
NIL
0.0
10.0
0.0
2.0
true
true
PENS
"Softwood" 1.0 0 -2674135 true
"Hardwood" 1.0 0 -10899396 true

PLOT
681
361
859
481
% Re-auction
NIL
NIL
0.0
10.0
0.0
0.1
true
false
PENS
"default" 1.0 0 -16777216 true

TEXTBOX
12
14
162
34
Parameters
16
125.0
1

SLIDER
9
208
218
241
%_Softwood
%_Softwood
0
100
80
1
1
NIL
HORIZONTAL

INPUTBOX
159
140
219
200
%_logger
34
1
0
Number

INPUTBOX
8
140
80
200
%_Papermill
33
1
0
Number

INPUTBOX
80
140
160
200
%_Lumbermill
33
1
0
Number

TEXTBOX
48
120
198
148
Bidders_Distribution
13
125.0
1

INPUTBOX
10
247
76
307
Periodicity
15
1
0
Number

INPUTBOX
85
248
219
308
Mean_Auction_Per_Year
500
1
0
Number

MONITOR
680
312
765
357
NIL
Sum_auction
17
1
11

SLIDER
10
363
219
396
Change_Rate_value
Change_Rate_value
0.01
0.1
0.06
0.01
1
NIL
HORIZONTAL

MONITOR
771
312
859
357
hearing-n
hearing-n
17
1
11

PLOT
865
188
1038
308
Mean Profit
NIL
NIL
0.0
10.0
0.0
0.1
true
true
PENS
"Type 1" 1.0 0 -1184463 true
"Type 2" 1.0 0 -13345367 true
"Type 3" 1.0 0 -2064490 true

PLOT
680
188
860
308
Profit Type of Strategy
NIL
NIL
0.0
10.0
0.0
0.2
true
true
PENS
"Type 1" 1.0 0 -1184463 true
"Type 2" 1.0 0 -13345367 true
"Type 3" 1.0 0 -2064490 true

SLIDER
10
401
220
434
Change_Rate_need
Change_Rate_need
0.01
0.1
0.06
0.01
1
NIL
HORIZONTAL

SLIDER
11
438
106
471
Radius
Radius
2
10
8
1
1
NIL
HORIZONTAL

CHOOSER
11
312
219
357
Learning_Type
Learning_Type
"Value change" "Need change"
0

BUTTON
111
439
221
472
new-bidders
new-bidders
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

TEXTBOX
687
15
1087
55
Auction based simulation
16
125.0
1

PLOT
1044
188
1248
308
Points of value
NIL
0
0.0
10.0
0.0
1.0
true
true
PENS
"Winners" 1.0 0 -10899396 true
"Type 1" 1.0 0 -1184463 true
"Type 2" 1.0 0 -13345367 true
"Type 3" 1.0 0 -2064490 true

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="Exp_bidders" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="365"/>
    <metric>last(revenue)</metric>
    <metric>mean(revenue)</metric>
    <steppedValueSet variable="Number_of_Bidders" first="50" step="10" last="150"/>
    <enumeratedValueSet variable="Per_Quantity_Mean">
      <value value="40"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Method">
      <value value="&quot;Sequentially&quot;"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="365"/>
    <metric>count turtles</metric>
    <metric>mean(Revenue)</metric>
    <enumeratedValueSet variable="Method">
      <value value="&quot;Periodically&quot;"/>
      <value value="&quot;Sequentially&quot;"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Per_Quantity_Mean">
      <value value="40"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%_Papermill">
      <value value="33"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%_Lumbermill">
      <value value="33"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%_logger">
      <value value="34"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="Number_of_Bidders">
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="%_Softwood">
      <value value="80"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
