globals [ dA dB dC Kd KB rbound-A rbound-B time A-exp B-exp C-exp]
turtles-own [age bound partner]
breed [ rna ]
breed [ a-protein ]
breed [ b-protein ]
breed [ c-protein ]


to setup
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
; setup variables
reset-counters
set rbound-A false ; set the bound state of the operon to false
set rbound-B false ; set the bound state of the operon to false
set dA 10 ; rate of protein A
set dB 10 ; rate of protein B
set dC 10 ; rate of protein C
set Kd 4 ; dissociation coefficient
set KB 100 ; binding coefficient


      ; create binding sites  
      ; red - A
      ask patches with [(pxcor = -13) and (pycor = 0)] [ set pcolor red set plabel "A" ]
      ; create "gene"
      ask patches with [(pxcor > -13) and (pxcor <= -5) and (pycor = 0)] [ set pcolor white ]

      ; blue - B
      ask patches with [(pxcor = -6) and (pycor = 0)] [ set pcolor blue set plabel "B" ]
      ; create "gene"
      ask patches with [(pxcor > -6) and (pxcor <= 0) and (pycor = 0)] [ set pcolor white ]
      
     ; blue - C
      ask patches with [(pxcor = 1) and (pycor = 0)] [ set pcolor gray set plabel "P" ]
      ask patches with [(pxcor = 2) and (pycor = 0)] [ set pcolor gray set plabel "P" ]
      ask patches with [(pxcor = 3) and (pycor = 0)] [ set pcolor green set plabel "C" ]
      ; create "gene"
      ask patches with [(pxcor > 3) and (pxcor <= 10) and (pycor = 0)] [ set pcolor white ]

      
      ; create ribosomes
      ask patches with [ ((pxcor < -12) or (pxcor > 13)) or ((pycor < -3) or (pycor > 5))] [ if random 10 = 1 [set pcolor cyan] ]
  plot-history
  plot-levels               
end

to go 
  set time time + 1
; do gene transcription
ask patches [

  if (plabel = "A") [
    if (gene-A = true and random 100 < dA ) [
      sprout 1 [
        set A-exp A-exp + 1
        set breed rna
        set partner nobody
        set shape "rna"
        set color red
        set bound false
        set age random 30
        set heading random 360
        fd 2
      ]
    ]
  ]
  
  if (plabel = "B") [
    if (gene-B = true and random 100 < dB) [
      sprout 1 [
        set B-exp B-exp + 1
        set breed rna
        set partner nobody
        set shape "rna"
        set color blue
        set bound false
        set age random 30
        set heading random 360
        fd 2
      ]
    ]
  ]

;; this determines which gate the system emulates
if (plabel = "C" ) [
  if (condition = "3" ) [if (not (rbound-A = true and rbound-B = true) ) [ express-c] ]
  if (condition = "4" ) [if (rbound-A = false and rbound-B = false) [ express-c]]
  if (condition = "1" ) [if (rbound-A = true and rbound-B = true) [ express-c]]
  if (condition = "2" ) [if (rbound-A = true or rbound-B = true) [ express-c]]
  if (condition = "5" ) [if ((rbound-A = true or rbound-B = true) and not (rbound-A = true and rbound-B = true)) [ express-c]]
]
]

; this was a bit tricky to get the order of events right
ask a-protein [
    without-interruption [bind-site-a]]
    ask b-protein [
    without-interruption [bind-site-b]]
ask turtles 
    [wander ;; both rnas and proteins check to see if they bind and otherwise move around
     grow-old] ;; both also are recycled by the cell machinery after a while.
plot-history
plot-levels
end

to express-c

  if ( random 100 < dC ) [
     sprout 1 [
       set C-exp C-exp + 1
       set breed rna
       set partner nobody
       set shape "rna"
       set color green
       set bound false
       set age random 30
       set heading random 360
       fd 2
     ]
   ]
 
end
 
; bind repressor to lacZ operon
to bind-site-a
  if (rbound-A = false and partner = nobody)
  [if (random 100 < Kb and breed = a-protein) [
    set bound true 
    set rbound-A true 
    setxy 1 0  
    set heading 180]]
end

to bind-site-b
  if (rbound-B = false and partner = nobody)
  [if (random 100 < Kb and breed = b-protein) [
    set bound true 
    set rbound-B true 
    setxy 2 0  
    set heading 180]]
end

; unbind repressor from lacZ operon
to unbind-site
  if ((random 100 < Kd) or (partner != nobody)) [
    ifelse (color = red) [set rbound-A false] [set rbound-B false] 
    set bound false  
    setxy random world-width random world-height
]
end

; have RNAs, proteins, and inducers move around the environment
to wander
  if (pcolor = cyan and shape = "rna") [  
    ;; this is the ribosome translating
    hatch 1 [
ifelse (color = blue) [set breed b-protein ] [ifelse (color = green) [set breed c-protein ] [set breed a-protein ]]         
    set shape "repressor"
    set bound false
    set age 0
    set heading random 360
    ]
  ] 
  ifelse (bound = true) [without-interruption [unbind-site]] [rt random 90 - random 90 fd 1 ]
end

to grow-old ;; cells break down rnas and proteins after a while.  
   set age age + 1
   if (age > (40 + random 100))  [if (bound != true) [die] ]
end


to plot-levels ;; this creates creates the bar graph 
    set-current-plot "Protein Concentrations"
    clear-plot
    set-current-plot-pen "A"
    plot-pen-down
    plotxy 1 count turtles with [breed = a-protein] 
    set-current-plot-pen "B"
    plot-pen-down
    plotxy 2 count turtles with [breed = b-protein] 
    set-current-plot-pen "C"
    plot-pen-down
    plotxy 3 count turtles with [breed = c-protein] 
end

to plot-history ;; this creates the line graph
  set-current-plot "Concentration History"
    set-current-plot-pen "A"
  plot ( count turtles with [breed = a-protein]  )
    set-current-plot-pen "B"
  plot ( count turtles with [breed = b-protein]  )
    set-current-plot-pen "C"
  plot ( count turtles with [breed = c-protein]  )
end

to reset-counters
set A-exp 0
set B-exp 0
set C-exp 0
set time 0
end

; This model was created as part of the 2004 BioQUEST Curriculum Consortium
; Summer Workshop.  
;
; Copyright 2004 by Steven Brewer.  All rights reserved.
; This model was inspired by many of the sample Netlogo models and parts 
; were based on functions from the Enzyme Kinetics model.  (Wilensky, U. (2001).  
; NetLogo Enzyme Kinetics model. http://ccl.northwestern.edu/netlogo/models/EnzymeKinetics. 
; Center for Connected Learning and Computer-Based Modeling, Northwestern University, 
; Evanston, IL.) 
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from the authors.
; Contact the authors for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Brewer, S.D. (2004).  Logical Promoter: Simulating Logical Gates Using
; a Model of Gene Expression.  http://bcrc.bio.umass.edu/netlogo/models/LogicalPromoter
; Biology Computer Resource Center
;
; In other publications, please use:
; Copyright 2004 by Steven Brewer.  All rights reserved.  See
; http://bcrc.bio.umass.edu/netlogo/models/LogicalPromoter
; for terms of use.
@#$#@#$#@
GRAPHICS-WINDOW
321
10
776
245
18
8
12.03
1
10
1
1
1
0
1
1
1
-18
18
-8
8
0
0
1
ticks
30.0

BUTTON
4
10
70
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
74
10
137
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
5
184
310
338
Protein Concentrations
NIL
NIL
0.0
6.0
0.0
30.0
false
true
"" ""
PENS
"A" 1.0 1 -65536 true "" ""
"B" 1.0 1 -16776961 true "" ""
"C" 1.0 1 -11352576 true "" ""

BUTTON
6
146
131
179
NIL
reset-counters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
4
58
107
91
gene-A
gene-A
1
1
-1000

SWITCH
109
58
212
91
gene-B
gene-B
1
1
-1000

CHOOSER
164
10
302
55
condition
condition
"1" "2" "3" "4" "5"
0

MONITOR
64
94
121
139
NIL
A-exp
3
1
11

MONITOR
123
94
180
139
NIL
B-exp
3
1
11

MONITOR
182
94
239
139
NIL
C-exp
3
1
11

MONITOR
5
94
62
139
NIL
time
3
1
11

PLOT
4
339
311
563
Concentration History
NIL
NIL
0.0
100.0
0.0
30.0
true
false
"" ""
PENS
"A" 1.0 0 -65536 true "" ""
"B" 1.0 0 -16776961 true "" ""
"C" 1.0 0 -11352576 true "" ""

BUTTON
190
149
310
182
NIL
clear-all-plots
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This is a model that demonstrates possible ways that two genes could bind and influence expression of a third, either turning it off or on. The conditions modeled here are not an exhaustive range of the possibilities available in biological systems, but each condition represents an important class of control mechanisms.

## HOW IT WORKS

In this system, there are three genes: A, B and C. Genes A and B produce transcription factors. Gene C has two enhancer or silencer regions that the transcription factors can bind to.  Depending on the settings of the system, these are either enhancers (turning on transcription of C) or silencers (turning off transcription of C).

## HOW TO USE IT

1) Click "setup" to create the genes (A, B, & C) (the big long white rectangle is the chromosome sequence) and ribosomes (these are the blue square blocks). P is the promoter.  
2) Check the switches that turn genes A and B on and off. There are 4 combinations that you will need to use.   
3) There are 5 different conditions you will need to run. These can be changed by clicking on the box that says "condition".   
4) Therefore you need to run this model a total of 20 times to fully complete your worksheet.  
5) Click "go" to start the model.  
6) A plot shows levels of A, B, and C. 

Notes:  
~Do NOT scroll down on the screen during the simulation, for some reason your graph will disappear in cyberspace. Try to set up the screen so that everything you need to see is visible from the beginning.  
~To change the rate at which things move, there is a speed control bar at the top of the simulation picture.   
ed bars are lac I RNA, blue bars are lac Z RNA  
ed crowns are repressors, blue crowns are b-gal  
~Green triangles are inducers (sugar)  
~Inducers adhered to repressors are repressor-inducer complexes  
~Inducers adhered to b-gal are b-gal-inducer complexes

## THINGS TO NOTICE

Even when C is turned off (note, you do not do this manually), you may notice it occasionally being transcribed. Why might this be? Are some gates "leakier" than others? Why? You can use the counters to put the system in equilibrium and then reset the counters and experiment with which configurations are most effective.

## THINGS TO DO

For each gate, determine what role the promoter is playing in the system (enhancer or silencer).

Consider constructing a "truth table" that lists possible states of "A", "B", and "C" under each condition to help distinguish among conditions that otherwise may appear to be identical.

## EXTENDING THE MODEL

To simplify this model, a number of factors have been de-paramaterized, including the rates of each gene (dA, dB, dC) and the coefficients of binding and dissociation (KB and Kd).  By adding sliders, you could extend this model and explore the behavior of the system with different values.  By changing these values you can try to decrease the leakiness of the system and increase the speed of the system turning on or off.

## CREDITS AND REFERENCES

This model was created as part of the 2004 BioQUEST Curriculum Consortium  
Summer Workshop.  

Copyright 2004 by Steven Brewer.  All rights reserved.

This model was inspired by many of the sample Netlogo models and parts were based on functions from the Enzyme Kinetics model.  (Wilensky, U. (2001).  NetLogo Enzyme Kinetics model. http://ccl.northwestern.edu/netlogo/models/EnzymeKinetics. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.)    
Permission to use, modify or redistribute this model is hereby granted,  
provided that both of the following requirements are followed:  
a) this copyright notice is included.  
b) this model will not be redistributed for profit without permission
   from the authors.  
Contact the authors for appropriate licenses for redistribution for  
profit.

To refer to this model in academic publications, please use:  
Brewer, S.D. (2004).  Logical Promoter: Simulating Logical Gates Using  
a Model of Gene Expression.  http://bcrc.bio.umass.edu/netlogo/models/LogicalPromoter  
Biology Computer Resource Center

In other publications, please use:  
Copyright 2004 by Steven Brewer.  All rights reserved.  See  
http://bcrc.bio.umass.edu/netlogo/models/LogicalPromoter  
for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

b-complex
true
0
Polygon -10899396 true false 79 46 198 148 78 254
Polygon -13345367 true false 77 48 197 149 77 255 257 254 256 49

box
true
0
Polygon -7500403 true true 45 255 255 255 255 45 45 45

circle
false
0
Circle -7500403 true true 35 35 230

inducer
true
0
Polygon -10899396 true false 76 47 197 151 75 256

r-complex
true
0
Polygon -2674135 true false 76 47 197 150 76 254 257 255 257 47
Polygon -10899396 true false 79 46 198 148 78 254

repressor
true
0
Polygon -7500403 true true 76 47 197 150 76 254 257 255 257 47

rna
true
0
Rectangle -7500403 true true 7 126 294 170

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
