Globals[
  F           ;Global variable: Electrical Force
  A           ;Global variable: Acceleration
  V           ;Global variable: Velocity
  X           ;Global variable: Displacement
  T           ;Global variable: Time
  R           ;Global variable: Distance
  k           ;Global variable: Coloumb's Constant
  color1      ;Global variable: Color of Turtle 0
  color2]     ;Gloval variable: Color of Turtle 1

to setup
  ca
  reset-ticks                               
  ask patches[set pcolor white]             ;Sets the world to the color white
  ifelse charge1 >= 0                       ;If the charge is greater than or equal to zero, check if...
    [if charge1 = 0 [set color1 gray]       ;the charge of turtle 0 is 0 the color with be grey
     if charge1 > 0 [set color1 red] ]      ;the charge is greater than 0 the color will be red
    [set color1 black]                      ;If the charge is less than zero, color will be black
  ifelse charge2 >= 0                       ;If the charge is greater than or equal to zero, check if...              
    [if charge2 = 0 [set color2 gray]       ;the charge of turtle 1 is 0 the color with be grey               
     if charge2 > 0 [set color2 red] ]      ;the charge is greater than 0 the color will be red                
    [set color2 black]                      ;If the charge is less than zero, color will be black              
  ask patch 0 0 [sprout 1                   ;Sprout a turtle at patch coordinate: (0,0)          
    [set size 1                             ;Set turtle size to 1           
      set color color1                      ;Set color to whatever color 1 is                 
      set shape "circle"                    ;Set shape of turtle to "circle"                 
    ]]
  ask patch (0 + D) 0 [sprout 1             ;Sprout a turtle at patch coordinant: (0 + Displacement,0)                 
    [set size 1                             ;Set turtle size to 1           
      set color color2                      ;Set color to whatever color 2 is                  
      set shape "circle"                    ;Set shape of turtle to "circle"                   
    ]]
  set x D                                   ;Set the x value as the slider's for distance               
  set k (9 * (10 ^ 9))                      ;Defines Coloumb's Constant in a numberic value                  
  end

to go
  tick                                          
  wait 0.001                                            ;Wait 0.001 of a second between ticks                        
  every .01 [set T T + .01]                             ;Every 0.01 seconds, set the time up by 0.01                           
  set R x                                               ;Set the distance between the two particles x                    
  set F ((- (k) * (charge1) * (Charge2)) / (R ^ 2))     ;Defines the equation for the Electrical force                            
  set A (F / mass)                                      ;Defines the equation for Acceleration         
  set v (initial_velocity + (A * T) )                   ;Defines the equation for Velocity                         
  set x (x - v)                                         ;Defines the equation for Displacement                  
  ask turtle 1 [setxy x 0]                              ;Positions the turtle at the given x value                 
  if x <= 1 [ask turtle 1 [set xcor 0]                  ;If the displacement is equal to or less then 1, the turtle will stop                         
    stop]
  if x >= 55 [stop]                                     ;If the displacement is equal to or greater than 55, the turtle will stop      
end 
@#$#@#$#@
GRAPHICS-WINDOW
187
12
1049
185
-1
5
12.91
1
10
1
1
1
0
0
1
1
-5
60
-5
5
1
1
1
ticks
30.0

SLIDER
6
52
178
85
Charge1
Charge1
-0.0001
0.0001
1.0E-4
0.00001
1
C
HORIZONTAL

SLIDER
7
89
179
122
Charge2
Charge2
-0.0001
0.0001
1.0E-4
.00001
1
C
HORIZONTAL

SLIDER
7
127
179
160
D
D
1
50
25
0.5
1
m
HORIZONTAL

SLIDER
6
164
178
197
Mass
Mass
.1
5
1
.1
1
kg
HORIZONTAL

SLIDER
6
203
178
236
Initial_Velocity
Initial_Velocity
-10
10
1
1
1
m/s
HORIZONTAL

BUTTON
8
12
84
48
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
93
12
173
48
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
188
194
366
239
Distance Between Particles (m)
r
2
1
11

PLOT
375
194
535
344
F v. T
Time (s)
Force (N)
0.0
0.1
0.0
0.05
true
false
"" ""
PENS
"Electric Force" 1.0 0 -2674135 true "" "if t > 0 [plotxy t f]"

PLOT
874
195
1034
345
Position vs. Time
Time (s)
Position (m)
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"Position" 1.0 0 -13840069 true "" "if t > 0 [plotxy t x]"

TEXTBOX
875
348
1000
390
Position of the rightmost particle relative to the leftmost particle (origin).
11
0.0
1

MONITOR
189
247
246
292
Time (s)
T
2
1
11

PLOT
706
194
866
344
V vs. T
Time (s)
Velocity (m/s)
0.0
1.0
0.0
0.05
true
false
"" ""
PENS
"default" 1.0 0 -13345367 true "" "if t > 0 [plotxy t v]"

PLOT
540
195
700
345
A vs. T
Time (s)
Acceleration (m/s2)
0.0
1.0
0.0
0.05
true
false
"" ""
PENS
"default" 1.0 0 -8630108 true "" "if t > 0 [plotxy t a]"

@#$#@#$#@
## WHAT IS IT?

This model is used to quantitatively simulate the intereactions between two particles 
with the electric force (F). The simulation uses initial conditions and Coloumb's Equation for the elctric force in order to model particle-particle interaction.

## HOW IT WORKS

This model utilizes multiple equations in order to function. The basis of these equations are dictated by the globals defined within the code and in the User Interface (UI): 

* [charge1] are [charge2] are globals defined in the UI and correspond to the given charge (in Coloumbs). Charge1 defines the left particle's charge and Charge2 defines the right paricle's charge. The color (via the globals [color1] and [color2]) of each particle also corresponds to its charge, with neutral displaying gray, negative displaying black, and positive displaying red. 

* [D] is a UI-defined global that represents distance.

* [Mass] is defined in the UI and is uniform between the two particles.

* [Initial_Velocity] is the beginning velocity of the rightmost particle. 

* [F] is defined as the electric force and is defined by Coloumb's Equation embedded into the code:
F = k(charge1)(charge2)/(D ^ 2)

* [A] is defined as the acceleration of the rightmost particle, defined by Newton's Second Law, embedded in the code:
F = mA
A = F / m

* [V] is the given velocity of the rightmost particle, defined as a function of time and acceleration:
V = (initial_velocity) + (A * T))

* [X] is the position of the rightmost particle's position. It changes depending on the velocity defined above.

* [T] represents time, as a replacement of ticks. Within the code, the value for T increases by 0.01 every 0.01 seconds. As such, T represents time in the real-world. 

* [R] is the distance between two particles, which is identical to X. 

* [k] is Coloumb's constant, defined as 9 * (10 ^ 9) at the setup phase of the code. 

## HOW TO USE IT

(1) Select values for the particle's charges and the distance between them. Choose values for their mass and the rightmost particle's initial velocity.
(2) Hit the setup button.
(3) Hit the go button to begin the simulation.

At any point during the model, the "go" button can be deslected to stop the model manually.

## THINGS TO NOTICE

As the simulation is running, notice the velocity of the right particle. Is it constant or does it change? How does the movement of the particle relate to its distance from the left particle?

## THINGS TO TRY

1) Make one or both charges neutral. What happens?

2) If both charges are positive, do the particles repel or attract?

3) How does the mass affect velocity? Try increasing the mass and using the graph provided to examine this relationship.


## EXTENDING THE MODEL

This is a simplistic model of the electric force, with only one particle moving at a time. To extend this model, both particles can be allowed movement. In addition, more than two particles can be included in the model to demonstrate the addition of force vectors.

## NETLOGO FEATURES

Note the use of [globals] at the top of the code to define variables not present in the user interface. 

The most important part of this model are the relationships defined by the equations embedded in the simulation. View the "How it Works" section to see more.  

## RELATED MODELS

This model is most like the "Traffic Basic" model in the NetLogo Model Library. It utilizes a similar interaction between acceleration, velocity, and position for the right particle. 

## CREDITS AND REFERENCES

Programmed by: Joshua Abraham, Joe Garcia, Ryan Wang, and Jace Marcos
Teacher: Mr. Reese
Tracy High School IB Physics Period 1

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
