turtles-own [energy]

to-report Time-period
  report ticks / 40

end

to setup
  clear-all
  setup-turtles
  setup-patches
  reset-ticks
end

to setup-turtles
  create-turtles Starting-population-size
  ask turtles [
    set color 37.7 - random-float (Mutation-rate / 2)
    set shape "mouse side"
    set size 1.25
    setxy random-xcor random-ycor
    set energy 20]
end

to setup-patches
  ask patches [set pcolor Environment-color]
end


to go

  if years = 0 [user-message "Number of years is needed" stop]
  if ticks > years * 40 [stop]


  if color-heritable? = false [ask turtles [set color 31 + random-float 7.5]]
  diff-survival
  move
  forage
  dead
  reproduce
  regrow
  if count turtles = 0 [user-message "All mice have died."  Stop]
  tick
end

to move
  ask turtles [rt (random 180)
               fd 1
               set energy energy - 1]
end

to dead
  ask turtles [if energy <= 0 [die]]
end

to forage
  ask turtles [if pcolor = Environment-color [set energy (energy + 1.5) set pcolor pcolor - 1]]
end


to reproduce
  ask turtles [
    if energy >= 40
    [hatch 1
      [set energy 20
       if random 100 < Mutation-rate [
          ;set color (color - 1) + random-float 2
          set color 31 + random-float 7.5
        ]
        if color < 31 [set color 31]
        if color > 38.5 [set color 38.5]]
      set energy energy - 20
      ] ]
end

to regrow
  ask patches with [pcolor != Environment-color] [set pcolor Environment-color]
end

to diff-survival
    ask turtles [
      if random 2500 < (abs (color - Environment-color) * Number-of-visual-predators * 0.5) [die]
    ]
end
@#$#@#$#@
GRAPHICS-WINDOW
7
10
415
419
-1
-1
16.0
1
10
1
1
1
0
1
1
1
-12
12
-12
12
0
0
1
ticks
5.0

BUTTON
422
10
530
47
Set up/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
541
10
648
47
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
423
334
532
379
Population Size
count turtles
17
1
11

SLIDER
610
212
755
245
Mutation-rate
Mutation-rate
0
15
6.0
1
1
NIL
HORIZONTAL

PLOT
423
384
816
584
Distribution of Colors
Color
Frequency
30.0
39.0
0.0
10.0
true
false
"" ""
PENS
"default" 0.1 1 -3844592 true "" "histogram [color] of turtles"

SLIDER
650
273
818
306
Environment-color
Environment-color
31
38
38.0
1
1
NIL
HORIZONTAL

SLIDER
422
273
640
306
Number-of-visual-predators
Number-of-visual-predators
0
30
15.0
5
1
NIL
HORIZONTAL

MONITOR
535
334
641
379
Average color
mean [color] of turtles
2
1
11

SWITCH
423
214
568
247
color-heritable?
color-heritable?
0
1
-1000

BUTTON
569
94
751
129
Clean/Recover background
ask patches [ifelse pcolor = environment-color \n[set pcolor 0]\n[set pcolor environment-color]]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
569
54
751
89
Retrieve Default settings
set color-heritable? true\nset mutation-rate 6\nset number-of-visual-predators 15\nset environment-color 38\nset years 50\nsetup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
425
567
499
585
Darker color
12
0.0
0

TEXTBOX
729
569
808
587
Lighter color
12
0.0
0

TEXTBOX
421
133
688
151
Factors-----------------------
12
13.0
1

TEXTBOX
423
313
681
331
Results------------------------
12
13.0
1

TEXTBOX
422
199
572
217
Heritability
11
105.0
1

TEXTBOX
609
196
670
214
Variation
11
105.0
1

TEXTBOX
421
258
571
276
Differential Survival
11
105.0
1

TEXTBOX
650
258
800
276
Environment
11
105.0
1

BUTTON
656
10
752
47
Run a year
repeat 40 [go]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

INPUTBOX
422
59
561
126
Years
50.0
1
0
Number

MONITOR
733
334
816
379
Years
(ticks - 1)/ 40
0
1
11

PLOT
7
424
212
583
Population Size
Years
# of Mice
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -8630108 true "" "plotxy time-period count turtles"

PLOT
214
424
414
583
Average Color
Years
Average Color
0.0
10.0
30.0
39.0
true
false
"" ""
PENS
"default" 1.0 0 -13791810 true "" "plotxy time-period mean [color] of turtles"

MONITOR
644
334
730
379
SD of color
standard-deviation [color] of turtles
2
1
11

SLIDER
421
154
627
187
Starting-population-size
Starting-population-size
1
50
30.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## MODEL IDEAS

This module provides students with opportunities to identify and test different components of natural selection model.

## CREDITS AND REFERENCES

This module is made by Dr. Lin Xiang at Weber State University. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2017). Pocket Mouse Module. Zoology Department, Weber State University, Ogden, UT.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

beetle
true
0
Circle -7500403 true true 140 69 20
Circle -7500403 true true 137 74 10
Circle -7500403 true true 153 74 10
Polygon -7500403 true true 150 84 150 252 129 245 115 235 109 223 101 209 99 182 96 154 94 127 90 119 88 112 95 106 111 102 127 99 135 91 138 81
Polygon -7500403 true true 141 81 140 65 135 47 125 33 112 24 98 16 91 17 97 22 106 25 118 34 125 39 134 54 136 66 138 77 141 84
Polygon -7500403 true true 132 105 108 84 76 98 61 90 44 92 62 95 75 104 108 90 122 109
Polygon -7500403 true true 150 84 150 252 171 245 185 235 191 223 199 209 201 182 204 154 206 127 210 119 212 112 205 106 189 102 173 99 165 91 162 81
Polygon -7500403 true true 97 139 81 136 51 169 36 172 29 187 41 176 53 175 80 142 99 151
Polygon -7500403 true true 102 182 86 179 61 232 47 238 40 254 52 241 66 235 87 186 105 199
Polygon -7500403 true true 159 81 160 65 165 47 175 33 188 24 202 16 209 17 203 22 194 25 182 34 175 39 166 54 164 66 162 77 159 84
Polygon -7500403 true true 168 105 192 84 224 98 239 90 256 92 238 95 225 104 192 90 178 109
Polygon -7500403 true true 203 139 219 136 249 169 264 172 271 187 259 176 247 175 220 142 201 151
Polygon -7500403 true true 198 182 214 179 239 232 253 238 260 254 248 241 234 235 213 186 195 199

beetle 1
true
0
Rectangle -16777216 true false 132 86 166 230
Polygon -7500403 true true 181 90 191 96 199 109 204 122 209 140 211 168 209 201 201 227 190 240 178 246 168 248 153 249 151 240 151 225 151 210 151 195 151 180 151 165 151 150 151 120 151 105 166 90 151 90 151 60 181 75
Polygon -7500403 true true 120 90 110 96 102 109 97 122 92 140 90 168 92 201 100 227 111 240 123 246 133 248 148 249 150 240 150 225 150 210 150 195 150 180 150 165 150 150 150 120 150 105 135 90 150 90 150 60 120 75
Circle -7500403 true true 135 45 30
Circle -7500403 true true 151 54 24
Circle -7500403 true true 127 54 24
Circle -7500403 true true 133 63 34
Circle -7500403 true true 158 70 26
Circle -7500403 true true 131 222 40
Polygon -7500403 true true 135 55 123 55 114 57 108 64 108 61 109 43 113 39 113 46 113 53 114 54 128 52 137 53
Polygon -7500403 true true 165 55 177 55 186 57 192 64 192 61 191 43 187 39 187 46 187 53 186 54 172 52 163 53
Polygon -7500403 true true 125 102 95 87 95 63 91 38 96 23 102 17 98 27 93 40 99 47 103 56 100 84 132 97
Polygon -7500403 true true 175 102 205 87 205 63 209 38 204 23 198 17 202 27 207 40 201 47 197 56 200 84 168 97
Polygon -7500403 true true 104 115 90 121 62 122 59 117 30 98 26 90 29 81 33 81 29 89 33 97 61 115 64 113 89 117 106 110
Polygon -7500403 true true 196 115 210 121 238 122 241 117 270 98 274 90 271 81 267 81 271 89 267 97 239 115 236 113 211 117 194 110
Polygon -7500403 true true 91 163 78 169 66 229 57 244 57 255 59 262 63 263 59 254 61 244 71 231 80 242 76 230 81 176 93 168
Polygon -7500403 true true 209 163 222 169 234 229 243 244 243 255 241 262 237 263 241 254 239 244 229 231 220 242 224 230 219 176 207 168
Circle -7500403 true true 116 70 26

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

grasshopper
false
0
Polygon -7500403 true true 226 157 241 152 247 159 243 185 238 185 234 181 230 175 217 184 200 191 181 194 164 198 141 200 121 198 101 192 84 184 79 179 104 165 137 155 157 154 183 154 203 156 221 158 227 158
Polygon -7500403 true true 238 154 250 122 262 91 267 63 269 39 270 11 271 33 269 59 265 85 250 128 240 156
Polygon -7500403 true true 239 155 259 121 269 104 281 76 288 50 295 20 288 56 283 74 271 104 258 127 240 155
Polygon -7500403 true true 207 179 237 190 246 208 256 212 242 209 235 194 203 185
Polygon -7500403 true true 169 187 162 196 161 215 154 218 164 215 166 198 180 187
Polygon -7500403 true true 230 166 255 172 256 191 263 194 253 191 251 174 217 170
Polygon -7500403 true true 147 178 166 185 173 203 183 201 171 207 163 187 134 182
Polygon -7500403 true true 121 170 73 101 67 100 24 203 18 201 12 199 7 195 15 198 23 200 64 98 67 93 72 95 75 99 92 122 137 157
Polygon -7500403 true true 133 166 85 97 79 96 51 209 44 204 39 202 36 199 43 201 50 203 76 94 79 89 84 91 87 95 104 118 155 157

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

moth
true
0
Polygon -16777216 true false 150 54 138 61 132 65 116 102 76 178 57 232 62 260 72 281 92 277 129 258 143 250 146 266 151 276 156 266 160 250 170 258 183 263 212 278 229 281 240 262 242 232 226 180 186 101 169 63 163 60
Polygon -7500403 true true 151 52 139 59 133 63 117 100 77 176 58 230 63 258 73 279 93 275 130 256 144 248 147 264 152 274 157 264 161 248 171 256 184 261 213 276 230 279 241 260 243 230 227 178 187 99 170 61 164 58
Circle -7500403 true true 141 35 18
Circle -7500403 true true 135 39 30
Polygon -7500403 true true 146 41 130 34 114 28 94 26 90 27 101 32 118 33 138 40
Polygon -7500403 true true 130 68 122 54 117 37 113 25 99 9 116 24 121 38 128 53 137 67
Polygon -7500403 true true 130 81 114 71 98 83 76 107 49 117 35 126 28 128 34 129 31 137 42 123 76 110 71 121 85 100 93 94 102 113 97 90 112 79 123 96
Polygon -7500403 true true 154 41 170 34 186 28 206 26 210 27 199 32 182 33 162 40
Polygon -7500403 true true 168 71 176 57 181 40 185 28 199 12 182 27 177 41 170 56 161 70
Polygon -7500403 true true 170 81 186 71 202 83 224 107 251 117 265 126 272 128 266 129 269 137 258 123 224 110 229 121 215 100 207 94 198 113 203 90 188 79 177 96

mouse side
false
0
Polygon -7500403 true true 289 142 271 165 237 164 217 185 235 192 254 192 259 199 245 200 248 203 226 199 200 194 155 195 122 185 84 187 91 195 82 192 83 201 72 190 67 199 62 185 46 183 36 165 40 134 57 115 74 106 60 109 90 97 112 94 92 93 130 86 154 88 134 81 183 90 197 94 183 86 212 95 211 88 224 83 235 88 248 97 246 90 257 107 255 97 270 120
Polygon -7500403 true true 38 162 24 165 19 174 22 192 47 213 90 225 135 230 161 240 178 262 150 246 117 238 73 232 36 220 11 196 7 171 15 153 37 146 46 145
Polygon -16777216 true false 234 100 220 96 210 100 214 111 228 116 239 115
Circle -16777216 true false 246 117 20
Line -7500403 true 270 153 282 174
Line -7500403 true 272 153 255 173
Line -7500403 true 269 156 268 177

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
