globals[cost budget]                                                                                     ;shows the global variables
to setup                                                                                                 ;starts the setup feature
  ca                                                                                                     ;clears all preset rules
  reset-ticks                                                                                            ;resets the months shown on the plots
  ask patches [set pcolor scale-color 103.5 (pycor) 36 -5]                                               ;creates background with a gradiant fill
  crt 1 [set shape "Podium" set size 20 set ycor 2.5 set xcor 8 set heading 90]                          ;places and creates podium
  crt 1 [set shape "Podium opposite" set size 20 set ycor 2.5 set xcor 24 set heading 270]               ;places and creates podium
  crt 1 [set shape "Politician" set size 10 set ycor 4.5 set xcor 3 set heading 0]                       ;places and creates politition
  crt 1 [set shape "person" set size 10 set ycor 4.5 set xcor 29 set heading 0 set budget 0 set cost 0]  ;creates and places scienctist and resets the cost and budget to 0
  crt 1 [set shape "Speech bubble" set size 20 set ycor 12 set xcor 21 set heading 0]                    ;creates speech bubble
  crt 1 [set shape "dot" set size 0 set ycor 12 set xcor 26]                                             ;creates speech bubble
  ask turtles with [shape = "dot"] [set label "I would like to make a proposal"]                         ;creates a turtle which is hidden in the speech bubble and says a sentence
  ask turtles [set label-color black]                                                                    ;sets label color black

  crt 1 [set shape "Speech bubble 1" set size 18 set ycor 15 set xcor 6 set heading 0]                   ;creates speech bubble
  crt 1 [set shape "square" set size 0 set ycor 14 set xcor 10]                                          ;creates a square turtle
  ask turtles with [shape = "square"] [set label "How much will it cost?"]                               ;creates a turtle which is hidden in the speech bubble and says a sentence
  ask turtles [set label-color black]                                                                    ;set labels color to black
end                                                                                                      ;ends the setup feature

to go                                                                                                    ;starts the go feature
if ticks < 1 [set budget budget_start]                                                                   ;sets the graph to start with the budget that was put in by you
ask turtles with[shape = "person"][set cost cost + (1200 * Boats)]                                       ;sets the global variable, cost, with how many boats on the slider
ask turtles with[shape = "person"][set cost cost + (2000 * Farmland)]                                    ;sets the global variable, cost, with how many acres of farmland on the slider
ask turtles with[shape = "person"][set cost cost + (6827.5 * Scienctists)]                               ;sets the global variable, cost, with how many scientists on the slider
ask turtles with[shape = "person"][set cost cost + (5166 * Water-Pumps)]                                 ;sets the global variable, cost, with how many water pumps on the slider
ask turtles with[shape = "person"][set cost cost + (1000 * Equipment)]                                   ;sets the global variable, cost, with how much equipment on the slider
ask turtles with[shape = "person"][set budget budget - (1200 * Boats)]                                   ;sets the global variable, budget, with how many boats on the slider
ask turtles with[shape = "person"][set budget budget - (2000 * Farmland)]                                ;sets the global variable, budget, with how many acres of farmland on the slider
ask turtles with[shape = "person"][set budget budget - (6827.5 * Scienctists)]                           ;sets the global variable, budget, with how many scientists on the slider
ask turtles with[shape = "person"][set budget budget - (5166 * Water-Pumps)]                             ;sets the global variable, budget, with how many water pumps on the slider
ask turtles with[shape = "person"][set budget budget - (1000 * Equipment)]                               ;sets the global variable, budget, with how much equipment on the slider
tick                                                                                                     ;adds 1 tick to update both plots
end                                                                                                      ;ends the go feature
@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
0
32
0
32
0
0
1
ticks
30.0

BUTTON
34
10
98
43
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
2
47
174
80
Boats
Boats
0
40
34.0
1
1
NIL
HORIZONTAL

MONITOR
647
10
983
55
Cost
cost
17
1
11

BUTTON
114
10
177
43
Start
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
3
79
175
112
Farmland
Farmland
0
100
62.0
1
1
NIL
HORIZONTAL

SLIDER
4
113
176
146
Scienctists
Scienctists
0
80
70.0
1
1
NIL
HORIZONTAL

SLIDER
4
146
176
179
Water-Pumps
Water-Pumps
0
20
18.0
1
1
NIL
HORIZONTAL

MONITOR
982
10
1333
55
Budget
budget
17
1
11

PLOT
647
55
983
456
Cost per Month
Months
Cost
0.0
12.0
0.0
1000000.0
true
false
"" ""
PENS
"Cost" 1.0 0 -16448764 true "" "plot cost "

PLOT
983
54
1333
456
Budget per Month
Months
Money
0.0
12.0
0.0
1000000.0
true
false
"" ""
PENS
"Budget" 1.0 0 -16777216 true "" "ifelse ticks < 1 [plot budget_start] [plot budget]"

INPUTBOX
4
210
114
270
budget_start
100000.0
1
0
Number

TEXTBOX
8
278
130
296
Type budget above
13
0.0
1

SLIDER
4
178
176
211
Equipment
Equipment
0
40
30.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model accuratly estimates the cost of running certain preservation efforts to save the depleading delta smelt. This interactive model can accuratly show the costs to these efforts.

## HOW IT WORKS

Clicking "setup" gets the model ready while adjusting the sliders activates global variables, which are shown on the plots via mathematical equations.

## HOW TO USE IT

SETUP-Starts the model
SLIDERS-Used to adjust amounts of exspenses
START-Starts the model and/or adds one month to the model
IMPUT BOX-Type in the desired budget

## THINGS TO NOTICE

Notice how the speech bubbles are created and what other features you could create using this formula.

## THINGS TO TRY

Somthing to try is to adjust the costs for the certain expenses.

## EXTENDING THE MODEL

Eventually it would be great if there were more sliders representing more expenses. It would also be better to make the default screen more interactive.

## NETLOGO FEATURES

Some great and unique features of NetLogo used in this model are the label feature and the turtle editor.

## CREDITS AND REFERENCES

Staff and facilities of Lawrence Livermore National Laboratory
https://www.water.ca.gov/
https://www.dfg.ca.gov/
Dr. Hartman
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -13345367 true false 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -955883 true false 111 5 80
Polygon -16777216 true false 120 195 120 195 105 285 105 300 135 300 150 225 165 300 210 300 195 285 180 195 180 195
Rectangle -955883 true false 135 60 172 94
Polygon -1 true false 195 90 240 150 225 180 165 105
Polygon -1 true false 105 90 60 150 75 180 135 105
Polygon -16777216 true false 120 210 30 195
Polygon -1 true false 120 210 195 210
Polygon -1 false false 195 270
Rectangle -16777216 true false 195 285 210 300
Rectangle -16777216 true false 90 285 105 300
Polygon -1 true false 120 195 105 90 195 90 180 195 120 195
Circle -16777216 true false 126 26 20
Circle -16777216 true false 160 25 20
Circle -1 true false 128 34 10
Circle -1 true false 164 33 10
Polygon -1 true false 135 90 150 120
Polygon -16777216 false false 45 105
Polygon -16777216 true false 135 90 150 120 165 90 135 90
Circle -16777216 false false 30 30 0
Line -16777216 false 150 105 150 210
Polygon -7500403 true true 125 16
Polygon -16777216 true false 123 13 180 15 154 2 120 10 124 12
Polygon -7500403 true true 135 60
Polygon -16777216 true false 133 56 171 56 163 66 140 66 133 56
Polygon -1 true false 137 60 168 61 171 58 172 55 132 56 136 60

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

podium
true
0
Rectangle -6459832 true false 120 120 195 180
Rectangle -6459832 true false 105 150 120 165
Polygon -6459832 false false 135 165
Rectangle -6459832 false false 135 150 135 150
Polygon -6459832 true false 120 180 120 195 75 120 105 120 120 165
Rectangle -6459832 true false 105 120 135 150

podium opposite
true
0
Rectangle -6459832 true false 105 120 180 180
Rectangle -6459832 true false 180 150 195 165
Polygon -6459832 false false 165 165
Rectangle -6459832 false false 165 150 165 150
Polygon -6459832 true false 180 180 180 195 225 120 195 120 180 165
Rectangle -6459832 true false 165 120 195 150

politician
false
0
Rectangle -955883 true false 135 90 165 120
Polygon -16777216 true false 120 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 180 195
Rectangle -955883 true false 135 75 165 90
Polygon -16777216 true false 195 90 240 150 225 180 165 105
Polygon -16777216 true false 105 90 60 150 75 180 135 105
Circle -955883 true false 110 5 80
Rectangle -16777216 true false 195 285 210 300
Rectangle -16777216 true false 90 285 105 300
Polygon -16777216 true false 195 90 180 195 120 195 105 90 120 90 150 165 180 90 195 90
Polygon -16777216 true false 150 105
Polygon -1 true false 120 90 135 90 150 105 165 90 180 90 150 165 120 90
Rectangle -1184463 false false 150 15 150 15
Polygon -1184463 true false 105 30 120 15 135 0 165 0 195 30 105 30
Circle -16777216 true false 156 37 16
Circle -16777216 true false 123 36 16
Circle -1 true false 129 42 8
Circle -1 true false 162 43 8
Line -16777216 false 150 105 150 210
Polygon -16777216 true false 138 64 145 70 160 69 167 63 139 64
Polygon -1 true false 142 67 163 65 163 63 145 64 145 70
Polygon -2674135 true false 147 101 151 95 157 98 153 107 146 101
Polygon -2674135 true false 147 104 145 140 151 145 155 142 153 102 149 102 153 103

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

speech bubble
true
0
Circle -1 true false 96 96 108
Circle -1 true false 71 106 89
Circle -1 true false 143 104 89
Circle -1 true false 53 114 80
Circle -1 true false 89 160 44
Circle -1 true false 144 143 64
Circle -1 true false 194 154 44
Polygon -1 true false 75 210 135 225
Polygon -1 true false 195 195 225 225 212 182

speech bubble 1
true
0
Circle -1 true false 96 96 108
Circle -1 true false 71 106 89
Circle -1 true false 143 104 89
Circle -1 true false 53 114 80
Circle -1 true false 89 160 44
Circle -1 true false 144 143 64
Circle -1 true false 194 154 44
Polygon -1 true false 75 210 135 225
Polygon -1 true false 69 174 76 215 98 189 91 162

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
