turtles-own [ x_solve y_solve z_solve piece-type]
breed [cubes a-cube]
breed [stickers a-sticker]
globals [i j k ]

to setup
  clear-all
  setxyz 20 -40 16 ; set the observer position
  build-cube
end

to mix
  set i 0
  while [i < 20] [
    set j random 3
    if j = 0 [ rotate-face ]
    if j = 1 [ roll-cube ]
    if j = 2 [ spin-cube ]
    set i (i + 1)]
  paint-neighbors
end

to solve-1
;  ask patch 3 3 -4 [ask turtles-here [set j color]]
;  if j = color-1 [roll-cube roll-cube]
;  repeat 4 [
;    ask patch -1 3 0 [ask turtles-here [set i color]]
;    ifelse i = color-1 [roll-cube] [spin-cube]]

;  ask patch 3 3 4 [ask turtles-here [set j color]]
;  if j = color-1 [show "sucess"]
end





;;  This procedure creates 27 turtles in puts them in a cube
to build-cube
   crt 27
    [  set x_solve (who mod 3)
       set y_solve ((int (who / 3)) mod 3)
       set z_solve ((int (who / 9)) mod 3)
       set breed cubes
       setxyz (x_solve * 3) (y_solve * 3) (z_solve * 3 - 3)
       set color 35
       set heading 0]
  ask turtle 13 [die]
  ask cubes with [y_solve = 2] [hatch 1 [set color 25 set breed stickers]]
  ask cubes [set heading 90]
  ask cubes with [x_solve = 2] [hatch 1 [set color 105 set breed stickers]]
  ask cubes [set heading 180]
  ask cubes with [y_solve = 0] [hatch 1 [set color 15 set breed stickers]]
  ask cubes [set heading 270]
  ask cubes with [x_solve = 0] [hatch 1 [set color 55 set breed stickers]]
  ask cubes [set heading 0 tilt-up 90]
  ask cubes with [z_solve = 2] [hatch 1 [set color 9.9 set breed stickers]]
  ask cubes [set heading 0 tilt-down 180]
  ask cubes with [z_solve = 0] [hatch 1 [set color 45 set breed stickers]]
  ask cubes [die]
  ask stickers [fd 1]
  ask stickers [create-links-with turtles-on neighbors]
  ask turtles [
    if count link-neighbors = 2 [set piece-type "corner"]
    if count link-neighbors = 0 [set piece-type "face"]
    if count link-neighbors = 1 [set piece-type "edge"]]
;  paint-neighbors
end

to find-face



end


to rotate-face
  ask stickers-on patch 7 0 3   [setxyz 7 6 2] 
  ask stickers-on patch 7 0 -3  [setxyz 7 0 3] 
  ask stickers-on patch 7 6 -3  [setxyz 7 0 -3] 
  ask stickers-on patch 7 6 3   [setxyz 7 6 -3] 
  ask stickers-on patch 7 6 2   [setxyz 7 6 3] 
  ask stickers-on patch 7 3 3   [setxyz 7 6 1] 
  ask stickers-on patch 7 0 0   [setxyz 7 3 3] 
  ask stickers-on patch 7 3 -3  [setxyz 7 0 0] 
  ask stickers-on patch 7 6 0   [setxyz 7 3 -3] 
  ask stickers-on patch 7 6 1   [setxyz 7 6 0] 
  ask stickers-on patch 6 0 4    [setxyz 6 7 4] 
  ask stickers-on patch 6 -1 -3  [setxyz 6 0 4] 
  ask stickers-on patch 6 6 -4   [setxyz 6 -1 -3] 
  ask stickers-on patch 6 7 3    [setxyz 6 6 -4] 
  ask stickers-on patch 6 7 4    [setxyz 6 7 3]
  ask stickers-on patch 6 3 4    [setxyz 6 7 4] 
  ask stickers-on patch 6 -1 0   [setxyz 6 3 4] 
  ask stickers-on patch 6 3 -4   [setxyz 6 -1 0] 
  ask stickers-on patch 6 7 0    [setxyz 6 3 -4] 
  ask stickers-on patch 6 7 4    [setxyz 6 7 0]
  ask stickers-on patch 6 -1 3   [setxyz 6 7 4] 
  ask stickers-on patch 6 0 -4   [setxyz 6 -1 3] 
  ask stickers-on patch 6 7 -3   [setxyz 6 0 -4] 
  ask stickers-on patch 6 6 4    [setxyz 6 7 -3] 
  ask stickers-on patch 6 7 4    [setxyz 6 6 4]
  paint-neighbors
end

to spin-cube
  set i -3
  while [i < 4] [
    ask stickers-on patch 0 -1 i [setxyz 7 7 i]
    ask stickers-on patch -1 6 i [setxyz 0 -1 i]
    ask stickers-on patch 6 7 i  [setxyz -1 6 i]
    ask stickers-on patch 7 0 i  [setxyz 6 7 i]
    ask stickers-on patch 7 7 i  [setxyz 7 0 i]

    ask stickers-on patch 3 -1 i [setxyz 7 7 i]
    ask stickers-on patch -1 3 i  [setxyz 3 -1 i]
    ask stickers-on patch 3 7 i  [setxyz -1 3 i]
    ask stickers-on patch 7 3 i  [setxyz 3 7 i]
    ask stickers-on patch 7 7 i  [setxyz 7 3 i]

    ask stickers-on patch -1 0 i [setxyz 7 7 i]
    ask stickers-on patch 0 7 i  [setxyz -1 0 i]
    ask stickers-on patch 7 6 i  [setxyz 0 7 i]
    ask stickers-on patch 6 -1 i [setxyz 7 6 i]
    ask stickers-on patch 7 7 i  [setxyz 6 -1 i]
    set i (i + 3) ]

  set i -4
  while [i < 5] [
    ask stickers-on patch 0 0 i [setxyz 7 7 i]
    ask stickers-on patch 0 6 i [setxyz 0 0 i]
    ask stickers-on patch 6 6 i [setxyz 0 6 i]
    ask stickers-on patch 6 0 i [setxyz 6 6 i]
    ask stickers-on patch 7 7 i [setxyz 6 0 i]

    ask stickers-on patch 0 3 i [setxyz 7 7 i]
    ask stickers-on patch 3 6 i [setxyz 0 3 i]
    ask stickers-on patch 6 3 i [setxyz 3 6 i]
    ask stickers-on patch 3 0 i [setxyz 6 3 i]
    ask stickers-on patch 7 7 i [setxyz 3 0 i]
    set i (i + 8) ]
  paint-neighbors
end


to roll-cube
  set i 0
  while [i < 7] [
    ask stickers-on patch 0 i 4   [setxyz 0 i 5]
    ask stickers-on patch -1 i -3 [setxyz 0 i 4]
    ask stickers-on patch 6 i -4  [setxyz -1 i -3]
    ask stickers-on patch 7 i 3   [setxyz 6 i -4]
    ask stickers-on patch 0 i 5   [setxyz 7 i 3]

    ask stickers-on patch 3 i 4   [setxyz 0 i 5]
    ask stickers-on patch -1 i 0  [setxyz 3 i 4]
    ask stickers-on patch 3 i -4  [setxyz -1 i 0]
    ask stickers-on patch 7 i 0   [setxyz 3 i -4]
    ask stickers-on patch 0 i 5   [setxyz 7 i 0]

    ask stickers-on patch 6 i 4  [setxyz 0 i 5]
    ask stickers-on patch -1 i 3 [setxyz 6 i 4]
    ask stickers-on patch 0 i -4 [setxyz -1 i 3]
    ask stickers-on patch 7 i -3 [setxyz 0 i -4]
    ask stickers-on patch 0 i 5  [setxyz 7 i -3]
    set i (i + 3) ]
  
  set i -1
  while [i < 9] [
    ask stickers-on patch 0 i 0  [setxyz 0 i 5]
    ask stickers-on patch 3 i -3 [setxyz 0 i 0]
    ask stickers-on patch 6 i 0  [setxyz 3 i -3]
    ask stickers-on patch 3 i 3  [setxyz 6 i 0]
    ask stickers-on patch 0 i 5  [setxyz 3 i 3]

    ask stickers-on patch 0 i 3  [setxyz 0 i 5]
    ask stickers-on patch 0 i -3 [setxyz 0 i 3]
    ask stickers-on patch 6 i -3 [setxyz 0 i -3]
    ask stickers-on patch 6 i 3  [setxyz 6 i -3]
    ask stickers-on patch 0 i 5  [setxyz 6 i 3]
    set i (i + 8) ]
  paint-neighbors
end


to paint-neighbors
  clear-patches
  ask stickers
    [ paint-stickers neighbors ]
end

to paint-stickers [agents]
  ask agents [ set pcolor [color] of myself - 2 ]
end

;;Robert Patchin 2017
@#$#@#$#@
GRAPHICS-WINDOW
0
0
325
346
17
17
9.0
1
10
1
1
1
0
1
1
1
-17
17
-17
17
-6
6
1
1
1
ticks
30.0

BUTTON
38
15
165
52
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
265
281
328
314
R
rotate-face
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
38
73
132
106
Spin Cube
spin-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
37
122
127
155
Roll Cube
roll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
186
20
298
53
Mix the Cube
Mix
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
265
331
328
364
Ri
rotate-face\nrotate-face\nrotate-face
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
25
331
88
364
L
spin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
23
272
86
305
Li
spin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
103
224
166
257
B
spin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
184
224
247
257
Bi
spin-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
184
393
247
426
F
spin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
105
393
168
426
Fi
spin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
109
278
172
311
U
roll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
181
283
244
316
Ui
roll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
182
334
245
367
D
roll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
105
334
168
367
Di
roll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
325
18
475
74
Solve a \"cross on the top\"\nEnsure sequence is correct and line up with cube faces by using U and Ui
11
0.0
1

BUTTON
698
15
792
48
Ri-Di-R-D
rotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
516
14
666
112
Move corner pieces using D and Di to below their desired position use this sequence (repeatedly) to move a corner to the top (or bottom and complete the face)\n
11
0.0
1

BUTTON
585
156
746
189
U-R-Ui-Ri-Ui-Fi-U-F
roll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
584
201
742
234
Ui-Li-U-L-U-F-Ui-Fi
roll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
391
162
541
232
Use spin cube, Ui and U to position a side piece on top to move top center piece to the right or left side and build second row
11
0.0
1

BUTTON
581
248
706
281
F-U-R-Ui-Ri-Fi
spin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
585
306
706
339
F-R-U-Ri-Ui-F
spin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
432
264
582
320
Use to form a yellow cross\ntop if no yellow edges or \nbackwards yellow el\nbottom if yellow line across
11
0.0
1

BUTTON
583
364
739
397
R-U-Ri-U-R-U-U-Ri
rotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
422
344
572
428
if no yellow corners - yellow to outer left face\nif 1 yellow corner - yellow to top lower left face\nif 2 yellow corners - yellow front left face
11
0.0
1

BUTTON
550
486
781
519
Ri-F-Ri-B-B-R-Fi-Ri-B-B-R-R-Ui
rotate-face\nrotate-face\nrotate-face\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nrotate-face\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nrotate-face\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
549
539
753
572
F-F-U-L-Ri-F-F-Li-R-U-F-F
spin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nrotate-face\nroll-cube\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
545
585
756
618
F-F-Ui-L-Ri-F-F-Li-R-Ui-F-F
spin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nrotate-face\nrotate-face\nspin-cube\nspin-cube\nrotate-face\nroll-cube\nrotate-face\nrotate-face\nrotate-face\nroll-cube\nroll-cube\nroll-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\nspin-cube\nrotate-face\nspin-cube\nspin-cube\nspin-cube\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
459
113
609
141
Invert the cube using roll-cube twice
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

This is a 3D version of a rubix cube I made to play around with

## THINGS TO DO

Use "Spin" to spin the cube arround the z-axis
Use "Roll" to roll cube around y-axis
Use "R" to spin the right face clockwise 

All other moves are composed of these three elementry moves

## SOLVING

The notation and pre-built algorithms support solving the cube using this guide:

https://www.rubiks.com/uploads/general_content/Rubiks_cube_3x3_solution-en.pdf

## Copyright

Rob Patchin, 2017

Please use and improve!
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 30 30 240

circle 2
false
0
Circle -7500403 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7500403 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 3D 5.2.0
@#$#@#$#@
setup
paint-neighbors
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
