globals [comfortable-acceleration max-deceleration Tdeta Tdc Tde Vp Pp Vf Pf Lp
         A1obj_lower A1obj_upper A2obj_lower A2obj_upper A3obj_lower A3obj_upper Aobj_lower Aobj_upper
         cor-unit tick-unit W-volume S-volume vehicle-size-in-Netlogo d L Source-Queue-W Source-Queue-S W-weight S-weight W-phase S-phase min-Green Wmu Wx-in Wx-out Smu Sx-in Sx-out
         Wspillbacks Sspillbacks Wsubjectcar Ssubjectcar W-almost-spillback S-almost-spillback W-flow S-flow WCars-out-approach SCars-out-approach
         W1-in W1-out S1-in S1-out W2-in W2-out max-xcor max-ycor W1-light-xcor W2-light-xcor S1-light-ycor Mid-light-xcor PhaseList]

;;cars in different approaches
breed [Wcars Wcar]
breed [Scars Scar]
breed [Wlight1s Wlight1]
breed [Wlight2s Wlight2]
breed [Slight1s Slight1]
breed [Midlights Midlight]

turtles-own [acceleration pre-speed speed next-speed next-dis next-dis-in-netlogo min-speed max-speed pre-position PV distance-of-PV PL spillback-same-direction spillback-other-direction block]

;; PWBP how to correctly evaluate the real discharging rate based on downstream density? Current algorithm tend to switch very frequently.
to setup
  clear-all
  set max-xcor 350
  set max-ycor 140
  ask patches [setup-road]
  set Tdeta 0.1 ;;communication interval
  set Tdc 0.1 ;;communication delay = 0.1 s
  set Tde 0.1  ;;execution delay = 0.1 s
  set vehicle-size-in-Netlogo 5 ;; a vehicle occupies 5 patches in Netlogo is
  set cor-unit 5 ;;suppose 1 cor = 5 m
  set L vehicle-size-in-Netlogo * cor-unit ;;vehicle length in real world
  set d 3 ;; the safety stop distance
  set Lp L + d ;; vehicle space headway when stop
  set tick-unit 0.1 ;;suppose 1 tick = 0.1 s
  ;;hence 1 cor/tick = 5 m/ 0.1 s = 50 m/s, 0.1 cor/tick = 5 m/s, and 0.01 cor/tick2 = 5 m/s2
  set comfortable-acceleration 2 ;;comfortable acceleration is 2 m/s2
  set max-deceleration -6 ;;max-deceleration is -6 m/s2
  set W-volume 3600 ;;volume of west approach
  set S-volume 600 ;;volume of south approach
  set min-Green 10 ;;minimum green is 10 s
  set Source-Queue-W 0 ;;initialize the source queue at west approach
  set Source-Queue-S 0 ;;initialize the source queue at south approach
  set W-weight 0  ;;initialize the weight of west approach
  set S-weight 0  ;;initialize the weight of south approach
  set W-phase 0  ;;initialize the state of west phase
  set S-phase 0  ;;initialize the state of south phase
  set-default-shape turtles "new-car"
  set PhaseList []
  setup-lights
  reset-ticks
end

to setup-road ;; patch procedure
  set W1-in 190
  set W1-out 195
  set S1-in 70
  set S1-out 75
  set W2-in 270
  set W2-out 275
  if (pycor > S1-out) or (pycor < S1-in) [set pcolor gray]
  if (pycor <= S1-out) and (pycor >= S1-in) [set pcolor white]
  if (pxcor <= W1-out) and (pxcor >= W1-in) [set pcolor white]
  if (pxcor <= W2-out) and (pxcor >= W2-in) [set pcolor white]

end

to setup-lights
  create-Wlight1s 1[
    set shape "cylinder"
    set color red
    set W1-light-xcor (W1-in - 3)
    set xcor W1-light-xcor
    set ycor (S1-in + S1-out) / 2
    set heading 90
    set size 5]
  create-Wlight2s 1[
    set shape "cylinder"
    set color red
    set W2-light-xcor (W2-in - 3)
    set xcor W2-light-xcor
    set ycor (S1-in + S1-out) / 2
    set heading 90
    set size 5]
  create-Slight1s 1[
    set shape "cylinder"
    set color green
    set xcor (W1-in + W1-out) / 2
    set S1-light-ycor (S1-in - 3)
    set ycor S1-light-ycor
    set heading 0
    set size 5]
end

to go-PWBP
  operate-lights-PWBP
  generate-vehicles
  car-run-CFFM
  tick
end

to go-BP
  operate-lights-BP
  generate-vehicles
  car-run-CFFM
  tick
end

to go-CABP
  operate-lights-CABP
  generate-vehicles
  car-run-CFFM
  tick
end

to generate-vehicles
  ;; sprout new cars in western approach
  if  ticks mod int((3600 / W-volume) / tick-unit) = 0   ;;volume is the traffic demand for each lane
  [set Source-Queue-W (Source-Queue-W + 1)]
  let near-origin-Wcars turtles with [xcor < 8]
  if Source-Queue-W > 0 and (count near-origin-Wcars) = 0
  [set Source-Queue-W (Source-Queue-W - 1)
   ask patch 0 round((S1-in + S1-out) / 2) [sprout-Wcars 1 [
      set color blue
      set size vehicle-size-in-Netlogo
      set ycor (S1-in + S1-out) / 2
      set heading 90
      set speed 5
      set pre-speed speed
      set pre-position xcor * cor-unit
      set max-speed 20
      set min-speed 0]]]

   ;; sprout new cars in southern approach
  if  ticks mod int((3600 / S-volume) / tick-unit) = 0
  [set Source-Queue-S (Source-Queue-S + 1)]
  let near-origin-Scars turtles with [ycor < 8]
  if Source-Queue-S > 0 and (count near-origin-Scars) = 0
  [set Source-Queue-S (Source-Queue-S - 1)
   ask patch round((W1-in + W1-out) / 2) 0 [sprout-Scars 1 [
      set color blue
      set size vehicle-size-in-Netlogo
      set xcor (W1-in + W1-out) / 2
      set heading 0
      set speed 5
      set pre-speed speed
      set pre-position ycor * cor-unit
      set max-speed 20
      set min-speed 0]]]
end

to car-run-CFFM
  ask Wcars [
    ifelse xcor >= world-width - 1
    [die]
    [ifelse any-PV?
     [follow-PV-CFFM]
     [speed-up-CFFM]]]
  ask Wcars [
    set pre-speed speed
    set pre-position xcor * cor-unit
    fd next-dis-in-netlogo
    set speed next-speed]

  ask Scars [
    ifelse ycor >= world-height - 1
    [die]
    [ifelse any-PV?
     [follow-PV-CFFM]
     [speed-up-CFFM]]]
  ask Scars [
    set pre-speed speed
    set pre-position ycor * cor-unit
    fd next-dis-in-netlogo
    set speed next-speed]
end

to-report any-PV?
  let myhd heading
  let front-cars turtles with [(((distance myself) > 0 and color = blue) or ((distance myself) > 5 and color = red) or ((distance myself) > 5 and color = green and (spillback-same-direction = 1 or spillback-other-direction = 1))) and (towards myself) != myhd and heading = myhd]
  let front-lights turtles with [(((distance myself) > 5 and color = red) or((distance myself) > 5 and color = green and (spillback-same-direction = 1 or spillback-other-direction = 1))) and (distance myself) <= 15 and (towards myself) != myhd and heading = myhd]
  set PV (min-one-of front-cars [distance myself])
  set PL (min-one-of front-lights [distance myself])
  ifelse PV != nobody
  [set distance-of-PV  distance PV
    ifelse distance-of-PV <= 15
    [if PL != nobody
      [if PL != PV
        [set PV PL ]]
      report true]
    [report false]]
  [report false]
end

to follow-PV-CFFM
  set Vp [pre-speed] of PV
  set Pp [pre-position] of PV

  ;;calculate the distance travelled in this cycle
  ifelse speed + acceleration * Tdeta < min-speed
  [let t-deceleration (min-speed - speed) / acceleration
   set next-dis speed * t-deceleration + 0.5 * acceleration * t-deceleration * t-deceleration + min-speed * (Tdeta - t-deceleration)]
  [ifelse speed + acceleration * Tdeta > max-speed
    [let t-acceleration (max-speed - speed) / acceleration
     set next-dis speed * t-acceleration + 0.5 * acceleration * t-acceleration * t-acceleration + max-speed * (Tdeta - t-acceleration)]
    [set next-dis speed * Tdeta + 0.5 * acceleration * Tdeta * Tdeta]]
  set next-dis-in-netlogo next-dis / cor-unit

  ;;update the speed at the beginning of next cycle
  ifelse speed + acceleration * Tdeta < min-speed          ;; to avoid speed < min-speed
  [set next-speed min-speed]
  [ifelse speed + acceleration * Tdeta > max-speed       ;; to avoid speed > max-speed
    [set next-speed max-speed]
    [set next-speed speed + acceleration * Tdeta]]

  set Vf next-speed
  ifelse heading = 90
  [set Pf xcor * cor-unit + next-dis]
  [set Pf ycor * cor-unit + next-dis]

  ;;calculate the acceleration during next cycle
  let Vfmax max-speed
  let apmax- max-deceleration
  let afmax- max-deceleration
  let afmax+ comfortable-acceleration

  let A1 Vf * Vf / -2
  let B1 Pp + Vp * Vp / (2 * apmax-) - Pf - Lp
  let A2 Tdeta * Tdeta / (-2 * afmax-)
  let B2 Tdeta * Tdeta / 2 - Vf * Tdeta / afmax-
  let C2 Pf + Lp + Vf * Tdeta - Pp + Vp * Vp / (2 * apmax-) - Vf * Vf / (2 * afmax-)
  let A3 (Vfmax - Vf) * (Vfmax - Vf) / -2
  let B3 Vfmax * Vfmax / (2 * afmax-) - Vp * Vp / (2 * apmax-) - Vfmax * Tdeta + Pp - Pf - Lp

  ifelse -1 * (Vf / Tdeta) > afmax-      ;;calculate the solution of segment 1
  [ifelse B1 > 0
    [ifelse A1 / B1 >= -1 * (Vf / Tdeta)
      [set A1obj_lower afmax- set A1obj_upper -1 * (Vf / Tdeta)]
      [ifelse A1 / B1 >= afmax-
        [set A1obj_lower afmax- set A1obj_upper A1 / B1]
        [set A1obj_lower 10 set A1obj_upper -10]]]
    [ifelse B1 < 0
      [set A1obj_lower 10 set A1obj_upper -10]
      [ifelse Vf = 0
        [set A1obj_lower afmax- set A1obj_upper -1 * (Vf / Tdeta)]
        [set A1obj_lower 10 set A1obj_upper -10]]]]
  [set A1obj_lower 10 set A1obj_upper -10]

  ifelse B2 * B2 - 4 * A2 * C2 >= 0       ;;calculate the solution of segment 2
  [ifelse (B2 + sqrt (B2 * B2 - 4 * A2 * C2)) / (-2 * A2) >= (Vfmax - Vf) / Tdeta or (sqrt (B2 * B2 - 4 * A2 * C2) - B2) / (2 * A2) < (-1 * Vf) / Tdeta
    [set A2obj_lower 10 set A2obj_upper -10]
    [ifelse max (list ((B2 + sqrt (B2 * B2 - 4 * A2 * C2)) / (-2 * A2)) ((-1 * Vf) / Tdeta) (afmax-)) <= min (list ((sqrt (B2 * B2 - 4 * A2 * C2) - B2) / (2 * A2)) ((Vfmax - Vf) / Tdeta) (afmax+))
      [set A2obj_lower max (list ((B2 + sqrt (B2 * B2 - 4 * A2 * C2)) / (-2 * A2)) ((-1 * Vf) / Tdeta) (afmax-)) set A2obj_upper min (list ((sqrt (B2 * B2 - 4 * A2 * C2) - B2) / (2 * A2)) ((Vfmax - Vf) / Tdeta) (afmax+))]
      [set A2obj_lower 10 set A2obj_upper -10]]]
  [set A2obj_lower 10 set A2obj_upper -10]

  ifelse (Vfmax - Vf) / Tdeta < afmax+      ;;calculate the solution of segment 3
  [ifelse B3 < 0
    [ifelse A3 / B3 > (Vfmax - Vf) / Tdeta
      [set A3obj_lower (Vfmax - Vf) / Tdeta set A3obj_upper min (list (A3 / B3) (afmax+))]
      [set A3obj_lower 10 set A3obj_upper -10]]
    [set A3obj_lower (Vfmax - Vf) / Tdeta set A3obj_upper afmax+]]
  [set A3obj_lower 10 set A3obj_upper -10]

  ifelse A3obj_lower <= A3obj_upper      ;; obtain Aobj
  [set Aobj_upper A3obj_upper
    ifelse A2obj_lower <= A2obj_upper
    [ifelse A1obj_lower <= A1obj_upper
      [set Aobj_lower A1obj_lower]
      [set Aobj_lower A2obj_lower]]
    [set Aobj_lower A3obj_lower]]
  [ifelse A2obj_lower <= A2obj_upper
    [set Aobj_upper A2obj_upper
      ifelse A1obj_lower <= A1obj_upper
      [set Aobj_lower A1obj_lower]
      [set Aobj_lower A2obj_lower]]
    [ifelse A1obj_lower <= A1obj_upper
      [set Aobj_lower A1obj_lower set Aobj_upper A1obj_upper]
      [set Aobj_lower 10 set Aobj_upper -10]]]

  ifelse Aobj_lower <= Aobj_upper
  [set acceleration min (list (afmax+) (Aobj_upper))]
  [set acceleration afmax-]

end

to speed-up-CFFM
  ifelse speed + acceleration * Tdeta < min-speed
  [let t-deceleration (min-speed - speed) / acceleration
   set next-dis speed * t-deceleration + 0.5 * acceleration * t-deceleration * t-deceleration + min-speed * (Tdeta - t-deceleration)]
  [ifelse speed + acceleration * Tdeta > max-speed
    [let t-acceleration (max-speed - speed) / acceleration
     set next-dis speed * t-acceleration + 0.5 * acceleration * t-acceleration * t-acceleration + max-speed * (Tdeta - t-acceleration)]
    [set next-dis speed * Tdeta + 0.5 * acceleration * Tdeta * Tdeta]]
  set next-dis-in-netlogo next-dis / 5

  ;;update the speed at the beginning of next cycle
  ifelse speed + acceleration * Tdeta < min-speed          ;; to avoid speed < min-speed
  [set next-speed min-speed]
  [ifelse speed + acceleration * Tdeta > max-speed       ;; to avoid speed > max-speed
    [set next-speed max-speed]
    [set next-speed speed + acceleration * Tdeta]]

  set acceleration comfortable-acceleration
end

to operate-lights-PWBP
  operate-other-lights
  capture-spillback-other-direction
  capture-spillback-same-direction
  if ticks mod (min-Green / tick-unit) = 0
  [calculate-weight-PWBP
   operate-main-lights]
end

to operate-lights-BP
  operate-other-lights
  capture-spillback-other-direction
  capture-spillback-same-direction
  if ticks mod (min-Green / tick-unit) = 0
  [calculate-weight-BP
   operate-main-lights]
end

to operate-lights-CABP
  operate-other-lights
  capture-spillback-other-direction
  capture-spillback-same-direction
  if ticks mod (min-Green / tick-unit) = 0
  [calculate-weight-CABP
   operate-main-lights]

end

to operate-other-lights
  ifelse ticks mod (90 / tick-unit) <= (30 / tick-unit) ;; the cycle for this light is 90, with 30 green
  [ask Wlight2s[set color green]]
  [ask Wlight2s[set color red]]
end

to operate-main-lights
  ifelse W-phase = 1
  [ask Wlight1s[set color green]]
  [ask Wlight1s[set color red]]

  ifelse S-phase = 1
  [ask Slight1s[set color green]]
  [ask Slight1s[set color red]]

  ifelse W-phase = 1
  [set PhaseList lput 1 PhaseList]
  [set PhaseList lput 0 PhaseList]
end

to capture-spillback-other-direction
  set Wspillbacks Wcars with [xcor >= W1-light-xcor and xcor <= (W1-out + 2)]
  ifelse any? Wspillbacks
  [ask Slight1s[set spillback-other-direction 1]]
  [ask Slight1s[set spillback-other-direction 0]]

  set Sspillbacks Scars with [ycor >= S1-light-ycor and ycor <= (S1-out + 2)]
  ifelse any? Sspillbacks
  [ask Wlight1s[set spillback-other-direction 1]]
  [ask Wlight1s[set spillback-other-direction 0]]
end

to capture-spillback-same-direction
  set Wsubjectcar min-one-of (Wcars with [xcor >= (W1-light-xcor - 15) and xcor <= W1-light-xcor]) [xcor]
  if Wsubjectcar != nobody
  [let xtemp [xcor] of Wsubjectcar
   set W-almost-spillback Wcars with [xcor > xtemp and xcor < W2-light-xcor]
   ifelse count W-almost-spillback >= (round((W2-light-xcor - W1-out) / 5.6) - 1) ;;(W2-light-xcor - W1-out) / 5.6 calculates the jam vehicle number on the approach, floor is for conservation
   [ask Wlight1s[set spillback-same-direction 1]]
   [ask Wlight1s[set spillback-same-direction 0]]]

  set Ssubjectcar min-one-of (Scars with [ycor >= (S1-light-ycor - 15) and ycor <= S1-light-ycor]) [ycor]
  if Ssubjectcar != nobody
  [let ytemp [ycor] of Ssubjectcar
   set S-almost-spillback Scars with [ycor > ytemp and ycor < max-ycor]
   ifelse count S-almost-spillback >= (round((max-ycor - S1-out) / 5.6) - 1)
   [ask Slight1s[set spillback-same-direction 1]]
   [ask Slight1s[set spillback-same-direction 0]]]
end

to calculate-weight-PWBP
  let W-weight-in (sum [xcor] of Wcars with [xcor >= 0 and xcor <= W1-in]) / (W1-in - 0)
  let W-weight-out (W2-in * (count Wcars with [xcor >= W1-out and xcor <= W2-in]) - (sum [xcor] of Wcars with [xcor >= W1-out and xcor <= W2-in])) / (W2-in - W1-out)
  set W-weight (W-weight-in - W-weight-out)

  let S-weight-in (sum [ycor] of Scars with [ycor >= 0 and ycor <= S1-in]) / (S1-in - 0)
  let S-weight-out (max-ycor * (count Scars with [ycor >= S1-out and ycor <= max-ycor]) - (sum [ycor] of Scars with [ycor >= S1-out and ycor <= max-ycor])) / (max-ycor - S1-out)
  set S-weight (S-weight-in - S-weight-out)

  ifelse W-phase = 1
  [set Wmu floor(min-Green / 1.7)]  ;;according to observation, the start-up lost time is 4.5s, and the saturated headway is 1.7s.
  [set Wmu 1 + floor((min-Green - 4.5) / 1.7)]
  set Wx-in count Wcars with [xcor <= W1-in and xcor >= (W1-in - Wmu * 6.6 - 10)] ;;6.6 = 5.6 + 1, a vehicle takes up 5.6 cor when saturated, 1 cor is considered as a buffer in case some vehicles could catch up, 10 is the distance from the first vehicle to the stop line
  set WCars-out-approach (Wcars with [xcor >= W1-out and xcor <= (W1-out + 5.6 * (min list Wmu Wx-in))])
  ifelse any? WCars-out-approach
  [let Wmean-speed mean [speed] of WCars-out-approach
   let Wmean-density (count WCars-out-approach) / (5.6 * (min list Wmu Wx-in) * cor-unit)
   set Wx-out Wmean-speed * Wmean-density * min-Green]
  [set Wx-out min list Wmu Wx-in]
  set W-flow min (list Wmu Wx-in Wx-out)

  ifelse S-phase = 1
  [set Smu floor(min-Green / 1.7)]
  [set Smu 1 + floor((min-Green - 4.5) / 1.7)]
  set Sx-in count Scars with [ycor <= S1-in and ycor >= (S1-in - Smu * 6.6 - 10)]
  set SCars-out-approach (Scars with [ycor >= S1-out and ycor <= (S1-out + 5.6 * (min list Smu Sx-in))])
  ifelse any? SCars-out-approach
  [let Smean-speed mean [speed] of SCars-out-approach
   let Smean-density (count SCars-out-approach) / (5.6 * (min list Smu Sx-in) * cor-unit)
   set Sx-out Smean-speed * Smean-density * min-Green]
  [set Sx-out min list Smu Sx-in]
  set S-flow min (list Smu Sx-in Sx-out)

  ifelse W-weight * W-flow > S-weight * S-flow
  [set W-phase 1 set S-phase 0]
  [ifelse W-weight * W-flow < S-weight * S-flow
    [set W-phase 0 set S-phase 1]
    [let x random 2
     ifelse x = 0  ;;breaking ties arbitrarily
      [set W-phase 1 set S-phase 0]
      [set W-phase 0 set S-phase 1]]]
end

to calculate-weight-BP
  let W-weight-in (count Wcars with [xcor >= 0 and xcor <= W1-in])
  let W-weight-out (count Wcars with [xcor >= W1-out and xcor <= W2-in])
  set W-weight max list (W-weight-in - W-weight-out) 0

  let S-weight-in (count Scars with [ycor >= 0 and ycor <= S1-in])
  let S-weight-out (count Scars with [ycor >= S1-out and ycor <= max-ycor])
  set S-weight max list (S-weight-in - S-weight-out) 0

  ifelse W-weight > S-weight
  [set W-phase 1 set S-phase 0]
  [ifelse W-weight < S-weight
    [set W-phase 0 set S-phase 1]
    [let x random 2
     ifelse x = 0  ;;breaking ties arbitrarily
      [set W-phase 1 set S-phase 0]
      [set W-phase 0 set S-phase 1]]]
end

to calculate-weight-CABP
  let WCa round((W1-light-xcor - 0) / 5.6) ;; the maximum vehicles when in jam density
  let WCb round((W2-light-xcor - W1-out) / 5.6)
  let Cinf 500
  let m 4
  let WQa (count Wcars with [xcor <= W1-in])
  let W-weight-in min list 1 (WQa / Cinf + (2 - WCa / Cinf) * (WQa / WCa) ^ m) / (1 + (WQa / WCa) ^ (m - 1))
  let WQb (count Wcars with [xcor >= W1-out and xcor <= W2-in])
  let W-weight-out min list 1 (WQb / Cinf + (2 - WCb / Cinf) * (WQb / WCb) ^ m) / (1 + (WQb / WCb) ^ (m - 1))
  set W-weight max list (W-weight-in - W-weight-out) 0

  let SCa round((S1-light-ycor - 0) / 5.6)
  let SCb round((max-ycor - S1-out) / 5.6)
  let SQa (count Scars with [ycor >= 0 and ycor <= S1-in])
  let S-weight-in min list 1 (SQa / Cinf + (2 - SCa / Cinf) * (SQa / SCa) ^ m) / (1 + (SQa / SCa) ^ (m - 1))
  let SQb (count Scars with [ycor >= S1-out and ycor <= max-ycor])
  let S-weight-out min list 1 (SQb / Cinf + (2 - SCb / Cinf) * (SQb / SCb) ^ m) / (1 + (SQb / SCb) ^ (m - 1))
  set S-weight max list (S-weight-in - S-weight-out) 0

  ifelse W-weight > S-weight
  [set W-phase 1 set S-phase 0]
  [ifelse W-weight < S-weight
    [set W-phase 0 set S-phase 1]
    [let x random 2
     ifelse x = 0  ;;breaking ties arbitrarily
      [set W-phase 1 set S-phase 0]
      [set W-phase 0 set S-phase 1]]]
end
@#$#@#$#@
GRAPHICS-WINDOW
0
85
832
425
-1
-1
2.35
1
10
1
1
1
0
0
0
1
0
350
0
140
1
1
1
ticks
30.0

BUTTON
545
35
625
68
PWBP
go-PWBP
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
190
35
270
68
Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
365
35
445
68
BP
go-BP
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
455
35
535
68
CABP
go-CABP
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model shows you how the Position-weighted Backpressure (PWBP) differs from the original Backpressue (BP), and the Capacity-Aware Backpressure (CABP) in terms of work conservation.

It has two intersections: the left intersection with two signal lights is the one that uses the BP-series controllers; the right intersection with only one signal light uses fixed timing controller.

The car-following model used in this model is a collision free car-following model for connected and automated vehicles from the literature.


## HOW TO USE IT

Click on the Reset button to set up the network and vehicles.

Click on BP, CABP, or PWBP to start the simulation under different controllers. Note that when you switch between different controllers, you need to first click the previous controller to pause the simulation, and then click the new controller to continue the simulation.

You can move the model speed bar to adjust the simulation speed.


## THINGS TO NOTICE

We can find that eventually the BP controller always gives green to the east-bound approach, even when the east approach is fully occupied and hence no vehicles can actually pass the intersection during green. However, if the green is given to the north-bound traffic, vehicles will be able to pass the intersection. We call this phenomenon "loss of work conservation". The reason behind this is that BP only considers the vehicle number difference between incoming and outgoing approaches, and assumes that saturation flow is always guaranteed, which is reasonable in communication network, but obviously not the case in traffic network.

CABP somehow solves this spillback problem by adjusting the movement weight calculation method, but it keeps the assumption about saturation flow rate. Therefore CABP is useful in limited certain cases, and cannot handle incident/accident scenarios, which is shown in other simulation models.

PWBP manages to resolve the basic issue: the way to calculate movement flow, along with movement weight. Hence work conservation is always guranteed in PWBP, no matter there is incident/accident or not.



## HOW TO CITE

If you mention this model or the NetLogo software in a publication, we ask that you include the citations below.

For the PWBP model:

* Li, Li, and Saif Eddin Jabari. "Position weighted backpressure intersection control for urban networks." Transportation Research Part B: Methodological 128 (2019): 435-461.

For the BP model:

* Wongpiromsarn, Tichakorn, et al. "Distributed traffic signal control for maximum network throughput." 15th international IEEE conference on intelligent transportation systems. IEEE, 2012.

For the CABP model:

* Gregoire, Jean, et al. "Capacity-aware backpressure traffic signal control." IEEE Transactions on Control of Network Systems 2.2 (2014): 164-173.

For the car following model:

* Li, Li, and Wanjing Ma. "A collision-free car-following model for connected automated vehicles." Proc. 96th Transportation Research Board Annual Meeting. 2017.

Please cite the NetLogo software as:

* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.


This work was funded in part by the C2SMART Center, a Tier 1 USDOT University Transportation Center, and in part by the New York University Abu Dhabi Research Enhancement Fund.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

new-car
true
0
Polygon -7500403 true true 165 0 149 21 129 39 120 60 117 74 90 90 75 105 60 135 60 180 75 225 150 300 210 300 210 0 165 0
Circle -16777216 true false 150 180 90
Circle -16777216 true false 150 30 90
Circle -7500403 true true 165 195 60
Polygon -16777216 true false 80 138 78 168 135 166 135 91 105 106 96 111 89 120
Circle -7500403 true true 165 45 60

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
setup
repeat 180 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
