breed [healthies healthy] ;;Different breeds of turtles to show heatlh state.
breed [infecteds infected]
breed [sicks sick]
breed [immunes immune]
breed [deads dead]

globals [ ;; Global variables.
  total-healthy
  total-sick
  total-infected
  total-immune
  total-dead
]

turtles-own [  ;; Turtle variables.
  turn-check
  wall-turn-check
  incubate
  sickness
  terminal-check
  immune-check
]

to building-draw ;; Use the mouse to draw buildings.
  if mouse-down?
    [
      ask patch mouse-xcor mouse-ycor
        [ set pcolor brown ]]
end

to setup  ;; Initialize the model.
  clear-turtles
  reset-ticks
  pop-check
  ask patches [set pcolor grey]
  setup-agents
  update-globals
  do-plots

end

to go  ;; Run the model.
   disease-check
  tick
  repeat 5 [ ask healthies [ fd 0.2 ] display ]
   repeat 5 [ ask infecteds [ fd 0.2 ] display ]
   repeat 5 [ ask sicks [ fd 0.2 ] display ]
   repeat 5 [ ask immunes [ fd 0.2 ] display ]
   update-globals
   do-plots

end


to setup-agents  ;;  Setup the begining number of agents and their initial states.
  set-default-shape healthies "person"
  set-default-shape infecteds "person"
  set-default-shape sicks "person"
  set-default-shape immunes "person"
  set-default-shape deads "person"

  ask n-of initial-healthy patches with [pcolor  = grey]
     [ sprout-healthies 1
      [ set color blue ] ]

  ask n-of initial-sick patches with [pcolor = grey]
    [ sprout-sicks 1
      [ set color yellow
        set sickness disease-period ] ]

end

to disease-check ;;  Check to see if an infected or sick turtle occupies the same patch.
  ask healthies [
    if any? other turtles-here with [color = yellow]
    [infect]
    if any? other turtles-here with [color = pink]
    [infect]
    wander
  ]

  ask sicks [
    if any? other turtles-here with [color = blue]
    [infect]
    wander
    set sickness sickness - 1
    if sickness < 1
    [live-or-die]
  ]

  ask infecteds [
    if any? other turtles-here with [color = blue]
    [infect]
    wander
    set incubate incubate - 1
    if incubate = 0
    [get-sick]
  ]

  ask immunes [wander]

end

to infect ;;  Infect a healthy turtle, test if it is immune and set the incubation timer if it isn't.
  set immune-check random 100
  ifelse immune-check < immune-chance-beforehand
  [recover]
  [ask healthies-on patch-here[
    set breed infecteds
    set incubate incubation-period]
  ask infecteds-on patch-here [set color pink]]

end

to get-sick ;;  Change an infected turtle into an sick turtle and set the disease progression timer.
   set breed sicks
   set color yellow
   set sickness disease-period
end

to terminate ;;  Kill a sick turtle who reaches the end of the disease progression and fails the terminal check.
  set breed deads
  set color black
end

to live-or-die ;; Test if the turtle dies from the disease.
  set terminal-check random 100
  ifelse terminal-check < terminal-chance
  [terminate]
  [recover]
end

to recover  ;;  Change turtle breed to immune.
  set immune-check random 100
  if immune-chance-after > immune-check
  [set breed immunes
  set color sky]
  if immune-chance-after < immune-check
  [set breed healthies set color blue]
end


to wander ;; Random movement for agents.
    set turn-check random 20
    if turn-check > 15
    [right-turn]
    if turn-check < 5
    [left-turn]
     if [pcolor] of patch-ahead 1 != grey
     [wall]

end

to wall ;;  Turn agent away from wall
    set wall-turn-check random 10
    if wall-turn-check >= 6
    [wall-right-turn]
    if wall-turn-check <= 5
    [wall-left-turn]
end

to wall-right-turn ;;Generate a random degree of turn for the wall sub-routine.
  rt 170
end

to wall-left-turn ;;Generate a random degree of turn for the wall sub-routine.
  lt 170
end

to right-turn ;;Generate a random degree of turn for the wander sub-routine.
  rt random-float 10
end

to left-turn   ;;Generate a random degree of turn for the wander sub-routine.
  lt random-float 10
end

to update-globals ;;Set globals to current values for reporters.
  set total-healthy (count healthies)
  set total-infected (count infecteds)
  set total-sick (count sicks)
  set total-immune (count immunes)
  set total-dead (count deads)
end

to do-plots ;; Update graph.
  set-current-plot "Population Totals"
  set-current-plot-pen "Healthy"
  plot total-healthy
  set-current-plot-pen "Infected"
  plot total-infected
  set-current-plot-pen "Sick"
  plot total-sick
  set-current-plot-pen "Immune"
  plot total-immune
  set-current-plot-pen "Dead"
  plot total-dead
end

to pop-check  ;; Make sure total population does not exceed total number of patches.
  if initial-healthy + initial-sick > count patches
    [ user-message (word "This simulation only has room for " count patches " agents.")
      stop ]
end

; *** NetLogo 4.1 Model Copyright Notice ***
;
; Copyright 2010 by Michael D. Ball.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Michael D. Ball.
; Contact Michael D. Ball for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Ball, M. (2010).  Infectious Disease Model ver. 1.
; http://www.personal.kent.edu/~mdball/netlogo_models.htm.
; The Center for Complexity in Health,
; Kent State University at Ashtabula, Ashtabula, OH.
;
; In other publications, please use:
; Copyright 2010 Michael D. Ball.  All rights reserved.
; See http://www.personal.kent.edu/~mdball/netlogo_models.htm
; for terms of use.
;
; *** End of NetLogo 4.1 Model Copyright Notice ***

@#$#@#$#@
GRAPHICS-WINDOW
136
10
1875
553
-1
-1
21.38
1
10
1
1
1
0
1
1
1
-40
40
-12
12
0
0
1
ticks
1000.0

SLIDER
1
558
219
591
INITIAL-HEALTHY
INITIAL-HEALTHY
0
500
500.0
1
1
NIL
HORIZONTAL

SLIDER
1
592
220
625
INITIAL-SICK
INITIAL-SICK
0
10
3.0
1
1
NIL
HORIZONTAL

SLIDER
0
660
219
693
DISEASE-PERIOD
DISEASE-PERIOD
0
20
7.0
1
1
Days
HORIZONTAL

SLIDER
0
693
218
726
IMMUNE-CHANCE-beforehand
IMMUNE-CHANCE-beforehand
0
100
0.0
1
1
%
HORIZONTAL

SLIDER
1
626
220
659
INCUBATION-PERIOD
INCUBATION-PERIOD
0
20
14.0
1
1
Days
HORIZONTAL

SLIDER
0
727
219
760
TERMINAL-CHANCE
TERMINAL-CHANCE
0
100
1.0
1
1
%
HORIZONTAL

BUTTON
2
10
100
76
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
0
142
100
207
NIL
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
217
556
1799
813
POPULATION TOTALS
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Healthy" 1.0 0 -13345367 true "" "plot count HEALTHIES"
"Infected" 1.0 0 -1664597 true "" "plot count infecteds"
"Sick" 1.0 0 -1184463 true "" "plot count sicks"
"Immune" 1.0 0 -13791810 true "" "plot count immuneS"
"Dead" 1.0 0 -16777216 true "" "plot count deads"

BUTTON
0
254
99
345
Draw Walls
building-draw
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
1797
556
1875
601
Total Healthy
total-healthy
17
1
11

MONITOR
1797
600
1876
645
Total Infected
total-infected
17
1
11

MONITOR
1798
644
1877
689
Total Sick
total-sick
17
1
11

MONITOR
1798
732
1876
777
Total Dead
total-dead
17
1
11

MONITOR
1798
688
1876
733
Total Immune
total-immune
17
1
11

BUTTON
0
440
99
510
Clear All
clear-all
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
0
761
218
794
immune-chance-after
immune-chance-after
0
100
66.0
1
1
%
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates the spread of an infectious disease traveling via contact through a randomly moving population. The user can draw walls, buildings, or obstacles in the environment to simulate different environments.

## HOW IT WORKS

The agents wander randomly throughout the simulation grid. If a healthy agent occupies a patch with a sick or infected agent, the healthy agent has a chance to become infected. This is controled by the immune-chance slider. A healthy agent that does not become infected, becomes immune. An agent remains infected for a period determined by the incubation-period slider. During this time, the agent is contagious. Once the incubation period ends, the agent becomes sick. Sick agents remain contagious through the length of the disease period (controlled by the disease-period slider). At the end of the disease period, the agent either dies or recovers and becomes immune. This is determined by the terminal-chance slider.

## HOW TO USE IT

1. Use the Draw Walls button to create different landscapes for the agents to move around.
2. Set the initial healthy and sick populations.
3. Set the incubation and disease period to desired levels.
4. Set the chance for immunity and terminal illness.
5. Click Setup to populate the simulation grid.
6. Click Go to set the agents in motion.


## EXTENDING THE MODEL

Hit me with suggestions, or get into modeling yourself ;)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

All disease models

## CREDITS AND REFERENCES

Credit goes to:
Copyright 2010 Michael D. Ball.  All rights reserved.
; See http://www.personal.kent.edu/~mdball/netlogo_models.htm
who created the code, Stefan Baumgartner simply updated it to version 6.1.1. and tweaked it a bit.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
