globals[extinction-event-date global-organisms-list]

breed[organisms organism]

organisms-own[evolvability]

patches-own[saturated? blocked? survivor? painted? organisms-list mean-evolvability-here]

to setup
  ca
  set global-organisms-list []
  ask patches [set saturated? false set blocked? false set survivor? false set painted? false set organisms-list [] set mean-evolvability-here 0]
  put-organisms
  update-heat-map
  if programmed-extinction-events = "random uniform between X and Y" [set extinction-event-date ( X + random ( Y - X ))]
  reset-ticks
end

to put-organisms
  create-organisms init-n-of-organisms [ht set evolvability init-evolvability]
end

to go
  ask organisms [shift-niche]
  ask organisms [mutate]
  ask organisms [new-generation]
  if ticks mod ticks-to-update-heat-map = 0 [update-heat-map]
  optimize
  tick
  if programmed-extinction-events = "regular intervals X generations" [if ticks mod X = 0 [extinction-event]]
  if programmed-extinction-events = "random uniform between X and Y" [if ticks = extinction-event-date [extinction-event set extinction-event-date ( ticks + X + random ( Y - X )) ]]
  if ticks = n-generations-to-stop [stop]
end

to optimize
  ; to save computational resources blocked  organisms (surrounded by saturated niches) are killed and their
  ; evolvabilities saved in a list (per patch) so they can be recovered after an extinction event
  ask organisms with [not blocked? and (count neighbors with [saturated?]) = 8] [
    set blocked? true
    set organisms-list fput evolvability organisms-list
    set global-organisms-list (sentence global-organisms-list organisms-list)
    die
  ]
end

to extinction-event
  set global-organisms-list []
  ask organisms [
    set organisms-list fput evolvability organisms-list
    die
  ]
  ask n-of n-surviving-niches (patches with [pcolor != black]) [
    set survivor? true
    foreach organisms-list [ ?1 -> sprout-organisms 1 [ht set evolvability ?1] ]
  ]
  ask patches with [not survivor?] [set pcolor black]
  ask patches [set organisms-list [] set saturated? false set survivor? false set blocked? false set painted? false set mean-evolvability-here 0]
  ask organisms [
    set global-organisms-list (sentence global-organisms-list organisms-list)
  ]
end

to update-heat-map
  ask patches with [any? organisms-here][set mean-evolvability-here (mean [evolvability] of organisms-here * 100)]
  ask patches with [not empty? organisms-list and not painted?][set mean-evolvability-here (mean organisms-list * 100) set painted? true]
  ask patches with [mean-evolvability-here > 0 ][set pcolor scale-color black mean-evolvability-here 0 9.9]
end

to shift-niche
  let candidates neighbors with [not saturated?]
  if random-float 1 < evolvability and any? candidates [
    set saturated? false
    move-to one-of candidates
  ]
end

to mutate
  if random-float 1 < prob-of-evolvability-mutation [set evolvability (evolvability + ((2 * random-float magnitude-of-evolvability-mutation) - magnitude-of-evolvability-mutation))]
end

to new-generation
  repeat n-of-offspring [ifelse (count organisms-here) <= max-n-organisms-per-niche
    [hatch 1]
    [set saturated? true die]]
end
@#$#@#$#@
GRAPHICS-WINDOW
298
10
707
420
-1
-1
1.0
1
10
1
1
1
0
1
1
1
-200
200
-200
200
0
0
1
ticks
30.0

BUTTON
15
22
93
55
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
98
22
161
55
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
13
177
291
210
prob-of-evolvability-mutation
prob-of-evolvability-mutation
0
0.1
0.005
0.005
1
NIL
HORIZONTAL

SLIDER
12
139
291
172
init-evolvability
init-evolvability
0
0.1
0.025
0.005
1
NIL
HORIZONTAL

SLIDER
13
215
291
248
magnitude-of-evolvability-mutation
magnitude-of-evolvability-mutation
0
0.01
0.0025
0.0005
1
NIL
HORIZONTAL

BUTTON
14
304
140
337
NIL
extinction-event
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
147
303
293
336
n-surviving-niches
n-surviving-niches
0
10
5.0
1
1
NIL
HORIZONTAL

PLOT
41
485
342
652
Average evolvability of organisms
ticks
Average evolvability
0.0
10.0
0.0
0.1
true
false
"" ""
PENS
"over organisms" 1.0 0 -16777216 true "" "if not empty? global-organisms-list [plot mean global-organisms-list]"

MONITOR
392
461
563
506
Average evolvability
mean [evolvability] of organisms
3
1
11

CHOOSER
13
254
292
299
programmed-extinction-events
programmed-extinction-events
"control (no extinction events)" "regular intervals X generations" "random uniform between X and Y"
1

INPUTBOX
15
344
78
404
X
1000.0
1
0
Number

INPUTBOX
92
344
153
404
Y
4000.0
1
0
Number

INPUTBOX
13
74
174
134
max-n-organisms-per-niche
5.0
1
0
Number

INPUTBOX
179
10
293
70
init-n-of-organisms
1.0
1
0
Number

SLIDER
15
407
230
440
n-generations-to-stop
n-generations-to-stop
0
15000
15000.0
1000
1
NIL
HORIZONTAL

SLIDER
15
444
255
477
ticks-to-update-heat-map
ticks-to-update-heat-map
1
100
100.0
1
1
NIL
HORIZONTAL

PLOT
381
512
669
646
number of organisms
ticks
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot length global-organisms-list"

INPUTBOX
179
74
293
134
n-of-offspring
2.0
1
0
Number

@#$#@#$#@
## THEORY

Evolutionary adaptability, also called evolvability is the potential of a lineage to evolve, this is, to generate heritable, selectable phenotypic variation. What are the causes for the appearance of increasing evolvability? Is evolvability evolvable? The most common explanations for evolvability rely on selection pressure. (e.g. Dawkins, R., 2003; Kirschner, M., & Gerhart, J., 1998). However, it has been shown that adaptive explanations may be unnecessary. If evolvability is heritable, increasing evolvability is demonstrated without any pressure to adapt, resulting from a more fundamental passive process of drifting over genotypes. The more genotypically diverse and evolvable organisms become, more likely they become phenotypically diverse and spread through ecological niches, such that, a biased distribution of phenotypes towards increasing evolvability can result from a passive drift over genotypes. (Lehman, J., & Stanley, K. O., 2013)

Considering this and observing that extinction events exert a powerful influence on the evolution of life (Raup, D. M., 1986; Raup, D. M., 1992), Lehman and Miikkulein (2015) explore the potential link between extinction events and the biological property of evolvability, and reinforce the interpretation that repeated and indiscriminate extinction events although being destructive and unpredictable can accelerate the evolution of life. While extinction events perturb ecological systems by eliminating those organisms that happen to be susceptible to geological rare stresses that happen by chance, it may yet benefit evolution as whole. In this view, the evolution's long-term potential of a particular lineage is not fully determined by its adaptivity. This potential is accentuated by extinction events, in detriment of more susceptible lineages. As a consequence, repeated indiscriminate extinction events accelerate evolution.

## WHAT IS IT?

Extinction events can accelerate evolution. This model was designed to study the importance of mass extinction events for the evolution of biological diversity.

## HOW IT WORKS

This model replicates the experiments of Lehman and Miikkulein (2015) on the effect of repeated extinction events on evolution. The model is based on the abstract limited-capacity niche model of Lehman, J. and & Stanley, K. O. (2013) inspired by the concept of adaptive radiation through ecological niches. Each organism has only one gene: evolvability - its capacity to generate novel phenotypes, expressed by a probability of shifting to a new niche (a patch in a discrete toroidal world), where new phenotypes are required for different ways of living. In this sense the world can also be seen as the phenotypic space explored by different lineages or organisms in genotypic drift. In each generation, each organism is substituted by his offspring which inherit their parents evolvability but can also become more or less evolvable according to a fixed probability of mutation of evolvability and a magnitude of mutation picked from a uniform distribution. In the beginning of each generation, an organism can shift to a new niche according to its evolvability. To model limited resources, niches support only a limited number of organisms. The simulations start with one organism at the center of the world.

Because niches have limited capacity due to limited resources and population growth is geometrical there's an indirect pressure to expand through niches which results in increasing evolvability. More evolvable lineages of organisms will spread more rapidly and occupy a larger amount of niches, however, because the world is finite, it saturates and the evolution of evolvability stagnates. Extinction thus facilitate the continuation of the evolution of evolvability. To test this hypothesis, regular extinction events can be programmed (at an every fixed number of generations). Repeated extinction events at random intervals can also be tested, as well as no extinction events at all (control) or at arbitrary chosen generations.

Due to performance issues, this model presents a simplified version of the model described above. Here, niches that become completely surronded will not change their evolvability.

## HOW TO USE IT

Use the input boxes init-n-of-organisms, max-n-organisms-per-niche and n-of-offspring to specify the initial conditions: initial number of organisms, maximum number of organisms per niche and the number of offspring by each organism at each generation.

Use the sliders to specify the value of evolvability to start with (init-evolvability), the probability with which this value is changed/mutated in each new organism at each generation (prob-of-evolvability-mutation), and the maximum magnitude with which evolvability can be mutated (magnitude-of-evolvability-mutation). Note, given the default value 0.0025 of the magnitude-of-evolvability-mutation, evolvability can be changed by any magnitude (with the same probability) in the interval [-0.0025,0.0025].

Extinction events can be programmed using the box programmed-extinction-events. "Regular intervals X generations" is chosen by default. "Random uniform between X and Y" and control conditions can also be chosen. X and Y are specified in the respective input boxes (with no effect in the case no extinction events are programmed). Choose the number of surviving niches after extinction with the slider n-surviving-niches.

You can also manually provoke extinction events by clicking the button "extinction event".

To control when to stop the simulation use the slider n-generations-to-stop. One tick/time unit corresponds to one generation.

Each patch in the toroidal world corresponds to a niche. It as the size of one pixel and its color intensity corresponds to the average evolvability value at that niche. Higher intensity pixels indicate higher evolvability values at the corresponding niche. You can use the slider ticks-to-update-heat-map to choose when to update this visual information. The default is 100 for optimization but you can start with 1 and change it later as it gets slower.

Plots are given for the evolution of the average evolvability over all organisms in the world (in this case also a counter), and the total number of organisms in the world. 

Setup and go! (go is also stop)

15000 generations can take some time but evolution takes time :)

## THINGS TO TRY

1) Setup and go with default settings but with no programmed extinctions events (set control condition) and wait to see how evolvability evolves until it stagnates. Observe that the more phenotipicaly diverse lineages (with higher evolvability) are more far from the center of the world, and the less are closer. More evolvable lineages, explored and conquered more of the phenotypic space.

1.1) Provoke an isolated extinction event.

2) Setup and go with default settings but try different conditions of extinction, observe the evolution of evolvability and compare.

3) Change settings, setup and go. (note you can also change settings during the simulation and manually provoke extinction events.

## CREDITS

The present model was coded by David N. Sousa. Feel free to contact.

## REFERENCES

Dawkins, R. (2003). The evolution of evolvability. On growth, form and computers, 239-255.

Kirschner, M., & Gerhart, J. (1998). Evolvability. Proceedings of the National Academy of Sciences, 95(15), 8420-8427

Lehman, J., & Stanley, K. O. (2013). Evolvability is inevitable: Increasing evolvability without the pressure to adapt. PloS one, 8(4), e62186.

Lehman, J., & Miikkulainen, R. (2015). Extinction events can accelerate evolution. PloS one, 10(8), e0132886.

Raup, D. M. (1986). Biological extinction in earth history. Science, 231(4745), 1528-1533.

Raup, D. M. (1992). Extinction: bad genes or bad luck?. WW Norton & Company.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
