breed [cryptographers cryptographer]
breed [nsas nsa]
breed [coins coin]

globals [
  final_result
  correct_predictions ;; times cryptographers correctly predict who paid dinner (if them or NSA agent)
  incorrect_predictions ;; times cryptographers inccorectly predicted who paid dinner (if them or NSA agent)
  ratio
]

cryptographers-own [
  state                   ;; my current state: "PAID", "NOT PAID", "EATING"
  dishonesty                 ;; honesty level of the cryptographer
  left-coin right-coin    ;; the coin to their left, the coin to their right
  result                  ;; result
]

coins-own [
  home-xpos home-ypos home-heading     ;; where I belong when I'm on the table
  owners                                ;; the cryptographers that currently owns me
  tossed?                               ;; whether I'm currently tossed
  flip                                ;; 0 or 1
]

nsas-own [
  state
]

to setup
  clear-all
  make-turtles
  reset-ticks
end

to make-turtles
  set-default-shape cryptographers "person"
  set-default-shape coins "circle"
  set-default-shape nsas "person"
  set correct_predictions 0
  set incorrect_predictions 0
  ;; create-ordered-<breed> equally spaces the headings of the turtles,
  ;; in who number order
  create-ordered-cryptographers num-cryptographers [
    set size 0.1
    jump 0.35
    set state "EATING"
    set color yellow
    set result "-"
    set dishonesty lying-probability / num-cryptographers
  ]
  create-ordered-coins num-cryptographers [
    rt 180 / num-cryptographers
    jump 0.25
    rt 180
    set size 0.1
    set color white
    set tossed? false
    set owners nobody
    set home-xpos xcor
    set home-ypos ycor
    set home-heading heading
    set flip 3
  ]
  ask cryptographers [
    set left-coin coin (who + num-cryptographers)
    ifelse who = 0
      [ set right-coin coin (2 * num-cryptographers - 1) ]
      [ set right-coin coin (who + num-cryptographers - 1) ]
  ]

  create-nsas 1 [
    ;jump 0.3
    set state "WATCHING"
    set size 0.1
    set ycor max-pycor
    set color blue
  ]
end

to go
  restart
  wait 0.3
  ask one-of cryptographers [ update ]
  wait 0.3
  ask coins [ tossing ]
  ask cryptographers [ decision ]
  final-result
  reporting
  ;if incorrect_predictions = 1 [stop]
  if correct_predictions > 0 [
    set ratio (correct_predictions / (incorrect_predictions + correct_predictions))
  ]
  tick
end

;; everybody gets a new color.
to restart
  ask cryptographers [
    ;; look up the color in the colors list indexed by our current state
    if state = "PAID" [
      set color yellow
      set state "EATING"
    ]
  ]
  ask nsas [
    if state = "PAID" [
      set color blue
      set state "WATCHING"
    ]
  ]
  ask coins [
    set shape "circle"
    set flip 3
    set color white
  ]
end

;; cryptographers and NSA agent are updated to which one paid
to update
  let var random 100
  if var <= nsa-vs-cryp-prob-to-pay [
    ask one-of cryptographers [
      set state "PAID"
      set color red
    ]
  ]
  ;; Changes color of the NSA agent to red if he paid the dinner
  if var > nsa-vs-cryp-prob-to-pay [
    ask NSA 6 [
      set state "PAID"
      set color red
    ]
  ]
end



;; 2 cryptographers select a coin that only they can see it's result
to acquire-coins-naive  ;; cryptographer procedure
  if [owners] of left-coin = nobody
    [ acquire-left ]
  if [owners] of right-coin = nobody
    [ acquire-right ]
end

;; this is one of the coin only him and a partner can see
to acquire-left  ;; cryptographers coin ownership
  ask left-coin [
    set owners myself
  ]
end

;; this is one of the coin only him and a partner can see
to acquire-right  ;; cryptographers coin ownership
  ask right-coin [
    set owners myself
  ]
end


to tossing
  if any? coins with [shape = "circle"] [
    ask coins [
      ;let a random-float 1
      ifelse (flip = 3) and (random-float 1 > 0.5) [
        ;print "hi"
        set shape "coin tails"
        set color lime
        set flip 1
        ]
      [
        set shape "coin heads"
        set flip 0
        set color pink
        set tossed? true

      ]
      wait 0.2
    ]
  ]
end

to decision
  let a 3
  let b 3
  ask left-coin [
    if flip = 0 [
      set  a 0
    ]
    if flip = 1 [
      set a 1
    ]
  ]
  ask right-coin [
    if flip = 0 [
      set  b 0
    ]
    if flip = 1 [
      set b 1
    ]
  ]

  ;; XOR Operation
  if color = yellow [
    if (a = 0) and (b = 0) [
      set result 0
    ]
    if (a = 0) and (b = 1) [
      set result 1
    ]
    if (a = 1) and (b = 0) [
      set result 1
    ]
    if (a = 1) and (b = 1) [
      set result 0
    ]
  ]
  if color = red [
    ;; XOR Operation
    if (a = 0) and (b = 0) [
      set result 1
    ]
    if (a = 0) and (b = 1) [
      set result 0
    ]
    if (a = 1) and (b = 0) [
      set result 0
    ]
    if (a = 1) and (b = 1) [
      set result 1
    ]
  ]
  ;; If the cryptographers is dishonest, he might lie = collusion
  if random-float 1 < dishonesty [
    ifelse (result = 1) [
      set result 0
    ]
    [
      set result 1
    ]
  ]
end


to final-result
  let var1 1
  let var2 1
  let var3 1
  ;let final_result 1
  ask cryptographer 0 [
    if (result = 0)[
      set var1 0
    ]
    if (result = 1)[
      set var1 1
    ]
  ]
  ask cryptographer 1 [
    if (result = 0)[
      set var2 0
    ]
    if (result = 1)[
      set var2 1
    ]
  ]
    ask cryptographer 2 [
    if (result = 0)[
      set var3 0
    ]
    if (result = 1)[
      set var3 1
    ]
  ]
  if (var1 = 0) and (var2 = 0) and (var3 = 0)[
      set final_result 0
  ]
  if (var1 = 0) and (var2 = 0) and (var3 = 1)[
      set final_result 1
  ]
  if (var1 = 0) and (var2 = 1) and (var3 = 0)[
      set final_result 1
  ]
  if (var1 = 0) and (var2 = 1) and (var3 = 1)[
      set final_result 0
  ]
  if (var1 = 1) and (var2 = 0) and (var3 = 0)[
      set final_result 1
  ]
  if (var1 = 1) and (var2 = 0) and (var3 = 1)[
      set final_result 0
  ]
  if (var1 = 1) and (var2 = 1) and (var3 = 0)[
      set final_result 0
  ]
  if (var1 = 1) and (var2 = 1) and (var3 = 1)[
      set final_result 1
  ]
  print final_result
end

to reporting
  ask nsa 6 [
    if (final_result = 0) and (color = red)[
      print "Correctly predicted NSA paid"
      set correct_predictions ( correct_predictions + 1 )
    ]
    if (final_result = 0) and (color = blue)[
      print "Incorrectly predicted NSA paid - there was collusion"
      set incorrect_predictions ( incorrect_predictions + 1 )
    ]
    if (final_result = 1) and (color = red)[
      print "Incorrectly predicted an anonymous Cryptographer paid - there was collusion"
      set incorrect_predictions ( incorrect_predictions + 1 )
    ]
    if (final_result = 1) and (color = blue)[
      print "Correctly predicted an anonymous Cryptographer paid"
      set correct_predictions ( correct_predictions + 1 )
    ]
]
end


@#$#@#$#@
GRAPHICS-WINDOW
226
10
634
419
-1
-1
400.0
1
5
1
1
1
0
0
0
1
0
0
0
0
0
0
1
ticks
30.0

SLIDER
12
31
198
64
num-cryptographers
num-cryptographers
3
3
3.0
1
1
NIL
HORIZONTAL

BUTTON
14
80
81
113
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
84
80
147
113
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
14
123
200
156
nsa-vs-cryp-prob-to-pay
nsa-vs-cryp-prob-to-pay
0
100
50.0
1
1
NIL
HORIZONTAL

MONITOR
16
167
201
212
Number of Good Predictions
correct_predictions
17
1
11

MONITOR
16
224
204
269
Number of Incorrect Predictions
incorrect_predictions
17
1
11

BUTTON
149
80
212
113
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
20
278
192
311
lying-probability
lying-probability
0
1
0.5
0.1
1
NIL
HORIZONTAL

PLOT
15
325
198
475
plot 1
NIL
NIL
0.0
1.0
0.0
1.0
true
false
"" ""
PENS
"Prediction Ratio" 1.0 0 -2674135 true "" "plot ratio"

@#$#@#$#@
## WHAT IS IT?

This model tries to replicate the dinning cryptographers problem made by David Chaum in the early 1980s. 

"Three cryptographers gather around a table for dinner. The waiter informs them that the meal has been paid for by someone, who could be one of the cryptographers or the National Security Agency (NSA). The cryptographers respect each other's right to make an anonymous payment, but want to find out whether the NSA paid. So they decide to execute a two-stage protocol."   
   

Despite the similar name, the dining cryptographers problem is unrelated to the dining philosophers problem.

## HOW IT WORKS


Three cryptographers are initiated and one NSA agent is on the middle. One of all 4 is randomly selected to be the person paying dinner.  
Next the cryptographers form couples with all others (in this case 3 couples are formed) and toss a coin which result only them can see.  

Heads is = 0
Tails is = 1

Once this is done, they inform the result computing both the coins each one can see based on the XOR function. If one of the cryptographers actually paid, he will announce the inverse of the XOR function.

Once all members have announced the result, again a XOR function is computed over the 3 results.  

If the final results is 1 => it means one of them paid the Dinner (but only the one that pays knows whom).   
If the final results is 0 => it means the NSA agent paid the Dinner.  

This way they can communicate annonimously.  

But, if one of them lies, then there's a collision and the result is null.   

## HOW TO USE IT

Go slow will allow to view how the mechanism works.  
We can select the number of cryptographers, but due to the coding right now it can't be selected (would have to update a lot of the code)
We can select the probability of them lying, which will increase the chances of the prediction colluding. The probability of them lying is divided in equal parts to each them.  
  

## THINGS TO NOTICE

Check how with 0% lying chance, they can communicate who the paying person is with 100% accuarecy, without ever divulging who actually paid the dinner!

## THINGS TO TRY

Play with lying probability too se how it affects the success ratio

## EXTENDING THE MODEL

1) Number of cryptographers should be extended
2) Add chances of one cryptographer being 100% malicious
3) Add chances of attack in the middle

Much is without finish (due to personal problems I had 1 day only to do this, despite wanting to spend more time on it and it being the most fun I had in some weeks). For that I excuse for myself for missing things that would be easily fixed and added. I'll try to complete it regardless of the end-line being over. 

## NETLOGO FEATURES

XOR function, ownership, no patches. 

## RELATED MODELS

Although I had decided to use this idea previously (for my interest on cypherpunks mailing lists), I later found the dinning philosophers model in netLogo. Despite it being different, the architecture helped me figure out how to set the ownership of coins.

## CREDITS AND REFERENCES

Professor Georgiy Bobashev
Dinning philosophers model author Uri Wilensky
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

coin heads
false
0
Circle -7500403 true true 15 15 270
Circle -16777216 false false 22 21 256
Line -16777216 false 165 180 192 196
Line -16777216 false 42 140 83 140
Line -16777216 false 37 151 91 151
Line -16777216 false 218 167 265 167
Polygon -16777216 false false 148 265 75 229 86 207 113 191 120 175 109 162 109 136 86 124 137 96 176 93 210 108 222 125 203 157 204 174 190 191 232 230
Polygon -16777216 false false 212 142 182 128 154 132 140 152 149 162 144 182 167 204 187 206 193 193 190 189 202 174 193 158 202 175 204 158
Line -16777216 false 164 154 182 152
Line -16777216 false 193 152 202 153
Polygon -16777216 false false 60 75 75 90 90 75 105 75 90 45 105 45 120 60 135 60 135 45 120 45 105 45 135 30 165 30 195 45 210 60 225 75 240 75 225 75 210 90 225 75 225 60 210 60 195 75 210 60 195 45 180 45 180 60 180 45 165 60 150 60 150 45 165 45 150 45 150 30 135 30 120 60 105 75

coin tails
false
0
Circle -7500403 true true 15 15 270
Circle -16777216 false false 20 17 260
Line -16777216 false 130 92 171 92
Line -16777216 false 123 79 177 79
Rectangle -7500403 true true 57 101 242 133
Rectangle -16777216 false false 45 180 255 195
Rectangle -16777216 false false 75 120 225 135
Polygon -16777216 false false 81 226 70 241 86 248 93 235 89 232 108 243 97 256 118 247 118 265 123 248 142 247 129 253 130 271 145 269 131 259 162 245 153 262 168 268 197 259 177 255 187 245 174 243 193 235 209 251 193 234 225 244 208 227 240 240 222 218
Rectangle -7500403 true true 91 210 222 226
Polygon -16777216 false false 65 70 91 50 136 35 181 35 226 65 246 86 241 65 196 50 166 35 121 50 91 50 61 95 54 80 61 65
Polygon -16777216 false false 90 135 60 135 60 180 90 180 90 135 120 135 120 180 150 180 150 135 180 135 180 180 210 180 210 135 240 135 240 180 210 180 210 135

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person student
false
0
Polygon -13791810 true false 135 90 150 105 135 165 150 180 165 165 150 105 165 90
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -1 true false 100 210 130 225 145 165 85 135 63 189
Polygon -13791810 true false 90 210 120 225 135 165 67 130 53 189
Polygon -1 true false 120 224 131 225 124 210
Line -16777216 false 139 168 126 225
Line -16777216 false 140 167 76 136
Polygon -7500403 true true 105 90 60 195 90 210 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
