globals [ N Mean-Economic-Output_t-1 Mean-Economic-Output_t ]

turtles-own 
[
  core-business-ID 
  
  ; Quantum business dynamics variables:
  x_t-1
  x_t
  F
  number-state
  Qe
  
  
  ; Quantities supplied:
  Q_t-1
  Q_t
  
  ; Market share:
  
  M_t-1
  M_t
  
  
  ]




to setup-types
  ca
  no-display
  ask patches [ set pcolor white ]
  set-types
  create-hypercubic-lattice
  ask turtles [ set x_t 1 - 2 * random-float 1.000 ]
  display 
end



to go
  tick
  update-core-business-fitness
  quantum-game
  determine-economic-output
  do-plot
end



to update-core-business-fitness
  
  ask turtles 
  
  [ set x_t-1 x_t
    set M_t-1 M_t ]
  
  ask turtles [ set F (1 - delta) * (1 - b * x_t-1 ^ 2) + delta * M_t-1 ]
  
  ask turtles [ set x_t (1 - epsilon_1 - epsilon_2) * F + epsilon_1 * mean [F] of link-neighbors + epsilon_2 * mean [F] of turtles ]
  
  ask turtles [ set Qe Q-bar + niu * x_t ]
  
end

to quantum-game
  ask turtles [ set number-state random-poisson (Qe - theta) ]
  ask turtles [ set Q_t number-state + theta ]
  ask turtles [ set M_t Q_t / (sum [Q_t] of turtles) ]
  ask turtles [ set size max-height * M_t ]
end


to determine-economic-output
  set Mean-Economic-Output_t-1 Mean-Economic-Output_t
  set Mean-Economic-Output_t mean [Q_t] of turtles
   
end


to do-plot
  set-current-plot "Delay-Plot Mean Economic Output"
  set-plot-x-range min-plot-x max-plot-x
  set-plot-y-range min-plot-y max-plot-y
  if (ticks mod plotting-sampling = 0) [ plotxy Mean-Economic-Output_t-1 Mean-Economic-Output_t ]
  
  set-current-plot "Mean Economic Output"
  set-plot-y-range min-plot-y max-plot-y
  plot Mean-Economic-Output_t
  
  set-current-plot "Mean x"
  plot mean [x_t] of turtles
end










;;;;;;;;;;;;;;;;;;;;;;
;; SETUP PROCEDURES ;;
;;;;;;;;;;;;;;;;;;;;;;



to set-types

  set N 2 ^ k
  cro N [ fd 10 rt 180 ]
  ask turtles [ set core-business-ID who ]

end


to create-hypercubic-lattice
  
  let prev-max-who -1
  if (any? turtles)
    [ set prev-max-who  (max [core-business-ID] of turtles) ]
    
 ask turtles 
 
 
  [
    
    let i 0
    repeat N
    [
      if ((floor ((core-business-ID - prev-max-who - 1) / (2 ^ i))) mod 2 = 0)
        [ create-link-with turtle (core-business-ID + (2 ^ i)) ]
      set i (i + 1)
    ]
  ]
  
  ask links [ set color black ]
  
  set-default-shape turtles "line"
end

@#$#@#$#@
GRAPHICS-WINDOW
423
10
908
516
20
20
11.6
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks

SLIDER
28
22
120
55
k
k
0
10
5
1
1
NIL
HORIZONTAL

BUTTON
272
31
370
64
NIL
setup-types
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
275
74
338
107
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
23
66
115
99
theta
theta
0
100
14
1
1
NIL
HORIZONTAL

SLIDER
21
113
119
146
Q-bar
Q-bar
0
100
30
10
1
NIL
HORIZONTAL

SLIDER
23
161
115
194
niu
niu
0
100
30
10
1
NIL
HORIZONTAL

SLIDER
151
21
243
54
b
b
0
2
2
0.01
1
NIL
HORIZONTAL

SLIDER
147
69
245
102
epsilon_1
epsilon_1
0
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
147
117
252
150
epsilon_2
epsilon_2
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
148
164
240
197
delta
delta
0
1
0.05
0.01
1
NIL
HORIZONTAL

SLIDER
184
284
311
317
max-height
max-height
0
100
50
10
1
NIL
HORIZONTAL

SLIDER
21
285
161
318
plotting-sampling
plotting-sampling
1
100
1
1
1
NIL
HORIZONTAL

PLOT
928
10
1162
226
Delay-Plot Mean Economic Output
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 2 -16777216 true

SLIDER
28
349
145
382
min-plot-x
min-plot-x
0
100
20
5
1
NIL
HORIZONTAL

SLIDER
185
350
303
383
max-plot-x
max-plot-x
0
100
50
5
1
NIL
HORIZONTAL

SLIDER
30
406
144
439
min-plot-y
min-plot-y
0
100
20
5
1
NIL
HORIZONTAL

SLIDER
182
411
316
444
max-plot-y
max-plot-y
0
100
50
5
1
NIL
HORIZONTAL

PLOT
927
245
1260
395
Mean Economic Output
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 2 -16777216 true

PLOT
927
403
1265
553
Mean x
NIL
NIL
0.0
10.0
-0.01
0.01
true
false
PENS
"default" 1.0 2 -16777216 true

MONITOR
276
141
374
186
Dispersion
standard-deviation [x_t] of turtles
5
1
11

@#$#@#$#@
WHAT IS IT?
-----------
This is a model of a quantum artificial economy, proposed in the article: "Chaos and Nonlinear Dynamics in a Quantum Artificial Economy" arXiv:1202.6647v1 [nlin.CD] http://arxiv.org/abs/1202.6647

The model belongs to a joint Econophysics, Quantum Complex Systems Science and Risk Science research line, falling under the MSC classification:

"91B80 - Applications of statistical and quantum mechanics to economics (econophysics)"

In most businesses one deals with discrete business volumes (or in the case of companies that supply goods: discrete quantities), thus, to address economic chaotic dynamics one may, effectively, assume some quantization scheme of fundamental economic variables and economic equilibrium conditions, working with a business game process, in which the quantum averages from transaction round to transaction round follow the continuous state classical chaotic dynamics of some (coupled) nonlinear map.

The current model builds up on such a proposal, introducing a quantum artificial economy with (quantum) chaotic dynamics, by combining quantum game theory, quantum chaos theory and coherent state lattice field solutions.

The model, therefore, is an evolutionary quantum game theory-based proposal that applies the mathematical formalism of quantum chaos and quantum complex systems' science to evolutionary economics, through a quantum business game where the traded quantities are discrete, allowing for economic dynamics to be addressed for discrete economic equilibrium conditions.


HOW IT WORKS
------------

At each transaction round, each company is characterized by a coherent state solution for the business volume (measured in quantities), which corresponds to a quantum business game equilibrium condition.

The coherent states provide probability amplitudes (interpreted as Arrow-Debreu price amplitudes for business risk exposure, see Refs [1] and [2]), such that each alternative number state corresponds to a company's equilibrium solution, given by the quantum operator:

| Q(i) = N(i) + theta

where N(i) is the i-th company's bosonic number operator and theta corresponds to the lowest quantities that can be sold.

The quantitis eigenspectrum is discrete, which captures the nature of supply for most businesses.

The coherent state, for each round, alpha_t(i) (where t labels the round and i the company) is defined as the squared root of Qe_t(i) - theta, where Qe_t(i) are the (quantum) expected quantities to be sold by company i at the end of the round t.

The dynamical variable Qe_t is equal to Q-bar + niu * x_t(i), where x_t(i) is a company's fitness variable and it is driven by a continuous state coupled quadratic map (see Eqs.(30) to (32) in Ref. [2], page 7).

The nonlinear map introduces an adaptive walk on a hypercubic lattice, implementing a business economics version of Kaneko's self-organizing genetic algorithms. In this way, each company's binary string code corresponds to a core business strategic profile, where each bit of the binary string is a core business dimension (among core business dimensions one can include the mission statement and business concept).

The coupled quadratic map implements four types of evolutionary dynamics:

(A) - Local competition dynamics between companies that are close to each other in their core business strategic dimensions (local hypercubic lattice one-bit mutant neighors coupling as per Kaneko, Refs. [3] and [4]) - controlled by the slider epsilon_1;

(B) - Global competitiveness' industry-wide evolutionary race - controlled by the slider epsilon_2;

(C) - Market share feedback effects upon a business fitness (this leads to a coupling between the quadratic map and the previous transaction round's company's market share, such that the previous round's quantum fluctuations affect the company's fitness dynamics) - controlled by the slider delta.

(D) - Local fitness dynamics given by the quadratic map with nonlinearity parameter b.


HOW TO USE IT
-------------

The upper eight sliders set the economy's profile. The sliders b, theta, epsilon_1, epsilon_2, delta, Q-bar and niu are the parameters' for the model's main equations, reviewed above.

The slider k sets the length of the core business strategic profile and, therefore, the number of companies in the economy is set to N = 2^k.

The lower six sliders correspond to plotting and visualization parameters, these are:

-> plotting-sampling: the user can set the plotting sampling range "p" so that only the rounds satisfying t mod p = 0 are plotted;

-> min-plot-x, max-plot-x, min-plot-y, max-plot-y: the user can set the range for the "Mean Economic Output" as well as the "Delay-Plot Mean Economic Output";

-> max-height: each company (turtle agent) is set as a line segment and the size of the turtle is set to the product of max-height multiplied by the market share, in this way, one can see the quantum fluctuations in the lattice sites such that lines with the greater company height have larger market shares which, for each company, result from the sum of the quantities sold by the company divided by the total of quantities sold.




THINGS TO NOTICE
----------------

In this model one may notice the fluctuations in the company heights and try to find patterns, getting a feel for the quantum business game dynamics.

One may also look at each of the three plots:

- "Mean x" - this is the plot for the companies' fitness mean field;

- "Mean Economic Output" - this is the plot for the mean quantities sold in the economy at each round of the game;

- "Delay-Plot Mean Economic Output" - this is the delay plot for the mean quantities sold in the economy for two consecutive rounds;

One may look at the company fitness variable x and see how its dynamics leaves a signature in the quantum business game dynamics ("Mean x" plot vs "Mean Economic Output").

One may look at patterns in the delay plot that may relate to the chaotic dynamics.



THINGS TO TRY
-------------

The model works as a sort of economic lab, such that different parameters lead to different economic profiles, some of the most relevant are obtained for:

epsilon_1 = delta = 0: in this case, there is no market share coupling in the fitness dynamics and neither is there any local coupling, the global coupling slider epsilon_2 will then set the strength of a perfect competition scenario. The higher the value of epsilon_2 is the more does the economy profile approach the perfect competition regime, with one difference, that due to the quantum fluctuations, each company's economic equilibrium changes from round to round, however, the quantum averages of the several companies synchronize so that one obtains a statistical economic equilibrium notion, just as it takes place in other artificial economies models with discrete local equilibrium trading like, for instance, sugarscape. 

epsilon_1 = 0: in this case, one may address both global competition and local market share coupling, such that on average companies which got a higher market share in one round tend to increase their market share in the following round.

In the more general case, where all the three parameters can be changed (epsilon_1, epsilon_2 and delta) there is business concept differentiation, global competition and market share coupling.

The user may adjust the profile and see how different economic profiles lead to different dynamics.



EXTENDING THE MODEL
-------------------

The model may be changed to include value chain effects, labor market, and other features of actual economies.



RELATED MODELS
--------------


Other related models with the same MSC classification are:

- Herding
http://ccl.northwestern.edu/netlogo/models/community/Herding


- Artificial Financial Market
http://ccl.northwestern.edu/netlogo/models/community/Artificial%20Financial%20Market

- Artificial Financial Market II - Tail Risk

http://ccl.northwestern.edu/netlogo/models/community/Artificial%20Financial%20Market%20II%20-%20Tail%20Risk

- Quantum Financial Market

http://ccl.northwestern.edu/netlogo/models/community/Quantum_Financial_Market


Also related to Quantum Complex Systems Science is the model:

- Quantum Life I

http://ccl.northwestern.edu/netlogo/models/community/Quantum%20Life%20I



CREDITS AND REFERENCES
----------------------

[1] Gon_ves, 2012, "Quantum Financial Economics of Games of Strategy and Financial Decisions", arXiv:1202.2080v1 [q-fin.GN] http://arxiv.org/abs/1202.2080

[2] Gon_ves, 2012, "Chaos and Nonlinear Dynamics in a Quantum Artificial Economy" arXiv:1202.6647v1 [nlin.CD] http://arxiv.org/abs/1202.6647

[3] Kaneko, K., "Chaos as a Source of Compexity and Diversity in Evolution", Arti?cial Life I, 1994, 163-177

[4] Kaneko, K. and I. Tsuda, Complex Systems: Chaos and Beyond, A Constructive Approach with Applications in Life Sciences, Springer, Germany, 2001.


The present work is part of an ongoing research by the author in risk science, risk mathematics, quantum game theory and the application of the mathematical formalisms from quantum theory and chaos theory to mathematical economics.


AUTHOR INFORMATION:
-------------------

Carlos Pedro Gon_ves (PhD)

Instituto Superior de Ci_ias Sociais e Pol_cas - Technical University of Lisbon

E-mail: cgoncalves@iscsp.utl.pt

Website: https://sites.google.com/site/carlospedrogoncalves/

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
