;; Forest harvesting & planting model
;;
;; Author: Desi Suyamto
;;
;; Forest2020 Collaborative Programme, Facultyof Forestry, Bogor Agrciultural University, Indonesia
;;

breed[trees tree]
breed[houses house]
breed[agents agent]
breed[trucks truck]
breed[harvests harvest]

agents-own
[
  agent-farmer-capital-harvest-timber
  agent-farmer-capital-timber
  agent-farmer-consumption
  agent-farmer-to-pool?
  agent-farmer-to-go-home?
  agent-farmer-to-harvest?
  agent-farmer-household-id
  agent-trader-consumption
  agent-trader-capital-financial
  agent-type
]

globals
[
  farmer-tree-recruitment-rate
  x-center
  y-center
]

houses-own
[
  house-id
  house-capital-land
  house-capital-financial
  house-timber-density
]

patches-own
[
  patch-any-trees?
  patch-any-houses?
  patch-distance-to-upperstream
  patch-harvest-pool?
  patch-harvest-wait?
  patch-farmer-household-land-id
  patch-protected-forest?
  patch-road?
]

trees-own
[
  tree-center?
  tree-distance-to-upperstream
  tree-protected-forest?
  tree-natural?
  tree-domesticated?
  tree-farmer-household-id
]

trucks-own
[
  truck-speed
  truck-to-load?
  truck-to-transport?
]

to initialise-patch
  ask patches
  [
    set pcolor 34 + random-float 3
    set patch-any-trees? false
    set patch-any-houses? false
    set patch-road? false
    set patch-harvest-pool? false
    set patch-harvest-wait? false
    set patch-distance-to-upperstream distancexy min-pxcor max-pycor
    set patch-protected-forest? false
    set patch-farmer-household-land-id -9999
  ]

  let m max[patch-distance-to-upperstream]of patches

  ask patches
  [
    set patch-protected-forest? (patch-distance-to-upperstream / m) < .36
  ]

  repeat 9 [diffuse pcolor .1]

  set x-center round (.5 * (max-pxcor - min-pxcor))
  set y-center round (.5 * (max-pycor - min-pycor))

  ask one-of patches with[pxcor = x-center and pycor = y-center]
  [
    set patch-harvest-pool? true
    sprout-agents 1
    [
      set shape "person"
      set color cyan
      set size 7.2
      set agent-farmer-capital-harvest-timber 0
      set agent-farmer-capital-timber 0
      set agent-farmer-consumption 0
      set agent-farmer-to-pool? false
      set agent-farmer-to-go-home? false
      set agent-farmer-to-harvest? false
      set agent-farmer-household-id -9999
      set agent-type "trader"
      set agent-trader-consumption .63
      set agent-trader-capital-financial 0
    ]
  ]

  ask one-of patches with[pxcor = max-pxcor and pycor = y-center]
  [
    set patch-harvest-wait? true
  ]

  ask patches with[pxcor >= x-center and pxcor <= max-pxcor and pycor = y-center]
  [
    set pcolor 1.8
    set patch-road? true
    ask neighbors
    [
      set pcolor 1.8
      set patch-road? true
    ]
  ]

  repeat 18 [diffuse pcolor .01]
end

to initialise-natural-tree
  let n 540
  let dm max [patch-distance-to-upperstream]of patches
  let p n-of n patches with[patch-distance-to-upperstream / dm < .63]

  ask p
  [
    sprout-trees 1
    [
      ht
      set shape one-of["tree1" "tree2" "tree3" "tree4"]
      set tree-center? false
      set tree-natural? true
      set tree-protected-forest? false
      set tree-domesticated? false
      set tree-farmer-household-id -9999
    ]
  ]

  let c min-one-of trees[distancexy min-pxcor max-pycor]
  ask c
  [
    set tree-center? true
    set tree-distance-to-upperstream 0
    set size 12.6
    set color 51
    setxy min-pxcor max-pycor
  ]

  ask trees with[not tree-center?]
  [
    face one-of trees with[tree-center?]
    fd random-float x-center
    set tree-distance-to-upperstream distance c
  ]

  ask trees-on patches with[patch-road?]
  [
    move-to one-of patches with[not patch-road?]
  ]

  ask trees with[not tree-center?]
  [
    set tree-distance-to-upperstream distance c
  ]

  let m max[tree-distance-to-upperstream]of trees

  ask trees with[not tree-center?]
  [
    set color 51 + 3.6 * (tree-distance-to-upperstream / m)
    set size 12.6 - 3.6 * (tree-distance-to-upperstream / m)
  ]

  ask trees
  [
    st
    ask patch-here
    [
      set patch-any-trees? true
    ]
  ]

  ask patches with[patch-protected-forest?]
  [
    ask trees-here
    [
      set tree-protected-forest? true
      set color max list 50 (color - random-float 3.6)
    ]
  ]
end

to initialise-house
  set-default-shape houses "house1"

  let p patches with[(pxcor > 9 + min-pxcor and pxcor < max-pxcor - 9) and (pycor > 9 + min-pycor and pycor < max-pycor - 9)]

  let m max[patch-distance-to-upperstream]of patches

  let i 0

  ask n-of 2 p with[(patch-distance-to-upperstream / m >= .54 and patch-distance-to-upperstream / m  < .63) and not patch-any-trees? and not patch-road? and not patch-any-houses?]
  [
    sprout-houses 1
    [
      ht
      set house-capital-financial 0
      set house-id i
      set size 9
      set color 23
      ask patch-here
      [
        set patch-any-houses? true
      ]
      set house-capital-land max list 9 round ((54 + random 180) * timber-production-policy)
    ]
    set i i + 1
  ]

  ask n-of 3 p with[patch-distance-to-upperstream / m  > .63 and not patch-any-trees? and not patch-road? and not patch-any-houses?]
  [
    sprout-houses 1
    [
      ht
      set house-capital-financial 0
      set house-id i
      set size 9
      set color 23
      ask patch-here
      [
        set patch-any-houses? true
      ]
      set house-capital-land round ((54 + random 180) * timber-production-policy)
    ]
    set i i + 1
  ]

  ask houses-on patches with[patch-road?]
  [
    move-to one-of patches with[not patch-road? and not patch-any-trees? and not patch-any-houses?]
  ]


  ask houses[st]

end

to initialise-truck
  create-trucks 1
  [
    setxy max-pxcor y-center
    set size 18
    set color 25
    set heading 270
    set shape "truck2"
    set truck-to-load? false
    set truck-to-transport? false
  ]
end

to initialise-agent
  set-default-shape agents "person"
  ask patches with[patch-any-houses?]
  [
    let i [house-id]of one-of houses-here
    let n 4 + random 2
    let s count patches with[patch-farmer-household-land-id = i]
    let t (9 + random 9) * n
    sprout-agents n
    [
      ht
      set agent-farmer-household-id i
      set agent-type "farmer"
      set agent-farmer-to-harvest? true
      set agent-farmer-to-go-home? false
      set agent-farmer-to-pool? false
      set size 6.3
      set color 47
      set agent-farmer-capital-harvest-timber 0
      set agent-farmer-capital-timber t
      set agent-farmer-consumption .45
      set agent-trader-consumption 0
      set agent-trader-capital-financial 0
    ]
  ]

  ;; define farmer land
  ask houses
  [
    let index house-id
    let s house-capital-land
    let l patches with[not patch-any-trees? and not patch-road? and not patch-any-houses? and not patch-protected-forest? and patch-farmer-household-land-id = -9999]
    let n1 l in-radius 9
    let n2 l in-cone 18 36
    let n remove sort n1 sort n2

    set s min list s length n

    let f n-of s n
    foreach f
    [
      ask ?
      [
        set pcolor pcolor - .9
        set patch-farmer-household-land-id index
      ]
    ]
  ]

end

to initialise-farmer-tree
  ask houses
  [
    let id house-id
    let n1 round(timber-production-policy * mean[agent-farmer-capital-timber]of agents with[agent-type = "farmer" and agent-farmer-household-id = id])
    let n2 count patches with[patch-farmer-household-land-id = id]
    let n min list n1 n2

    if(any? patches with[patch-farmer-household-land-id = id])
    [
      ask n-of n patches with[patch-farmer-household-land-id = id]
      [
        sprout-trees 1
        [
          ht
          set shape one-of["tree1" "tree2" "tree3" "tree4"]
          set tree-center? false
          set tree-distance-to-upperstream distancexy 0 0
          set tree-protected-forest? false
          set tree-natural? false
          set tree-domesticated? true
          set tree-farmer-household-id id
          set color 61 + random-float 6.3
          set size 5.4 - 1.8 * random-float 1
        ]
      ]
    ]
  ]

  ask trees with[tree-domesticated?]
  [
    st
  ]
end

to setup
  ca
  set farmer-tree-recruitment-rate 2 ;;trees per household

  initialise-patch
  initialise-truck
  initialise-natural-tree
  initialise-house
  initialise-agent
  initialise-farmer-tree
  reset-ticks
end

to move-agent
  ask agents with[agent-type = "farmer"]
  [
    let id agent-farmer-household-id
    let h agent-farmer-capital-harvest-timber
    ifelse(not any? houses-here)
    [
      st
    ]
    [
      ht
      set shape "person"
      set color 47
    ]

    if(agent-farmer-to-harvest? and not agent-farmer-to-pool? and not agent-farmer-to-go-home?)
    [
      set shape "person"
      set color 47
      let hh one-of houses with[house-id = id]
      let tt trees with[(tree-domesticated? and tree-farmer-household-id = id) or tree-natural?]
      face min-one-of tt[distance hh]

      fd 1

      if(any? trees-here)
      [
        let t trees-here
        set agent-farmer-capital-harvest-timber count t
        set agent-farmer-to-harvest? false
        set agent-farmer-to-pool? true
        ask patch-here
        [
          set patch-any-trees? false
        ]
        ask t [die]
      ]

    ]

    if(agent-farmer-to-pool? and not agent-farmer-to-harvest? and not agent-farmer-to-go-home?)
    [
      set shape "person2"
      set color 47 - .9
      let p one-of patches with[patch-harvest-pool?]
      face p

      fd 1

      if([patch-harvest-pool?]of patch-here = true)
      [
        ask patch-here
        [
          sprout-harvests h
          [
            set shape "harvest1"
            set size 9
            set color red
            set heading random-float 18
          ]
        ]

        set agent-farmer-to-pool? false
        set agent-farmer-to-go-home? true
        let hh one-of houses with[house-id = id]
        let capital-trader agent-farmer-capital-harvest-timber * 2.7
        let capital-farmer (min list .9 max list .09 timber-trading-policy) * capital-trader

        let consumption-farmer agent-farmer-consumption
        let consumption-trader first[agent-trader-consumption]of agents with[agent-type = "trader"]
        ask hh
        [
          set house-capital-financial house-capital-financial + capital-farmer - consumption-farmer
        ]
        ask agents with [agent-type = "trader"]
        [
          set agent-trader-capital-financial agent-trader-capital-financial + capital-trader - consumption-trader
        ]
        set agent-farmer-capital-harvest-timber 0
      ]
    ]

    if(agent-farmer-to-go-home? and not agent-farmer-to-pool? and not agent-farmer-to-harvest?)
    [
      set shape "person3"
      set color 47 - 1.8
      face one-of houses with[house-id = id]
      fd 1
      if(any? houses-here with[house-id = id])
      [
        set agent-farmer-to-go-home? false
        set agent-farmer-to-harvest? true
      ]
    ]
  ]
end

to move-truck
  let h count harvests-on patches with[patch-harvest-pool?]
  let n 1

  if(h > 0)
  [
    ask trucks
    [
      set truck-to-load? true
    ]
  ]

  ask trucks
  [
    if(truck-to-load?)
    [
      set shape ifelse-value(heading = 90) ["truck1"] ["truck2"]

      let d ifelse-value(heading = 270)
      [
        distancexy x-center y-center
      ]
      [
        distancexy max-pxcor y-center
      ]

      ifelse(d > 1.8)
      [
        set truck-speed 1

        repeat n
        [
          fd truck-speed / n
        ]
      ]
      [
        ask harvests-on patches with[patch-harvest-pool?] [die]
        set truck-to-load? false
        set truck-to-transport? true
        let x 1 + (read-from-string last shape mod 2)
        set shape word "truck" x
        set heading heading + 180
      ]
    ]

    if(truck-to-transport?)
    [
      set shape ifelse-value(heading = 90) ["truck1"] ["truck2"]

      let d ifelse-value(heading = 270)
      [
        distancexy x-center y-center
      ]
      [
        distancexy max-pxcor y-center
      ]

      ifelse(d > 1.8)
      [
        set truck-speed 1

        repeat n
        [
          fd truck-speed / n
        ]
      ]
      [
        set truck-to-load? false
        set truck-to-transport? false
        let x 1 + (read-from-string last shape mod 2)
        set shape word "truck" x
        set heading heading + 180
      ]
    ]
  ]
end

to recruit-farmer-tree
  ask houses
  [
    let id house-id
    let n1 round(timber-production-policy * farmer-tree-recruitment-rate)
    let n2 count patches with[patch-farmer-household-land-id = id]
    let nt count trees with[tree-domesticated? and tree-farmer-household-id = id]
    let d ifelse-value(n2 > 0) [nt / n2] [0]
    let n ifelse-value(d < .72)[min list n1 n2] [0]


    if(any? patches with[patch-farmer-household-land-id = id])
    [
      ask n-of n patches with[patch-farmer-household-land-id = id]
      [
        sprout-trees 1
        [
          ht
          set shape one-of["tree1" "tree2" "tree3" "tree4"]
          set tree-center? false
          set tree-distance-to-upperstream distancexy 0 0
          set tree-protected-forest? false
          set tree-natural? false
          set tree-domesticated? true
          set tree-farmer-household-id id
          set color 61 + random-float 6.3
          set size 5.4 - 1.8 * random-float 1
        ]
      ]
    ]
  ]

  ask trees with[tree-domesticated?]
  [
    st
  ]
end

;to export-landscape
;  let t ticks
;  let f word "output/" word "land-" word t ".png"
;  export-view f
;end


to go
 ifelse(ticks < 1800)
 [
   ;;export-landscape
   move-agent
   move-truck
   recruit-farmer-tree
   tick
 ]
 [
   stop
 ]
end
@#$#@#$#@
GRAPHICS-WINDOW
74
10
845
510
-1
-1
3.24
1
10
1
1
1
0
0
0
1
0
234
0
144
0
0
1
ticks
30.0

BUTTON
6
47
69
80
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
1068
300
1331
522
timber yield
time
standing trees' stock
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"forest reserve" 1.0 0 -2674135 true "" "plot count trees with[tree-protected-forest?]"
"natural forest" 1.0 0 -1184463 true "" "plot count trees with[tree-natural? and not tree-protected-forest?]"
"timber plantation" 1.0 0 -10899396 true "" "plot count trees with[tree-domesticated?]"

BUTTON
6
10
69
43
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
863
299
1051
332
timber-production-policy
timber-production-policy
0
1
0.25
.01
1
NIL
HORIZONTAL

PLOT
1114
10
1325
273
farmers' income from timber
time
monetary unit per household
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"kk 1" 1.0 0 -15390905 true "" "plot first [house-capital-financial]of houses with[house-id = 0]"
"kk 2" 1.0 0 -13345367 true "" "plot first [house-capital-financial]of houses with[house-id = 1]"
"kk 3" 1.0 0 -8020277 true "" "plot first [house-capital-financial]of houses with[house-id = 2]"
"kk 4" 1.0 0 -2695187 true "" "plot first [house-capital-financial]of houses with[house-id = 3]"

SLIDER
861
341
1050
374
timber-trading-policy
timber-trading-policy
0
1
0.1
.01
1
NIL
HORIZONTAL

PLOT
861
12
1106
273
traders' income from timber
time
monetary unit
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"pengusaha" 1.0 0 -5825686 true "" "plot first [agent-trader-capital-financial]of agents with[agent-type = \"trader\"]"

@#$#@#$#@
## WHAT IS IT?

A model to explore that sustainability of forests in supplying timbers is determined by timber production policies (i.e. any policies facilitating farmers to easily grow trees); while income inequality between timber growers (farmres) and timber traders is determined by timber trading policies.


## CREDITS AND REFERENCES

Desi suyamto - Forest2020 - Faculty of Forestry - Bogor Agricultural University - Indonesia
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

harvest1
true
0
Rectangle -7500403 true true 0 135 300 165

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

house1
false
0
Polygon -16777216 true false 0 120 150 0 300 120
Polygon -16777216 true false 75 105 150 45 225 105
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 105 180 195 285
Line -16777216 false 30 120 270 120
Rectangle -16777216 true false 105 150 195 165
Polygon -7500403 true true 15 120 150 15 285 120
Rectangle -16777216 true false -15 120 300 135
Polygon -16777216 true false 75 105 150 45 225 105
Rectangle -16777216 true false 30 135 45 300
Rectangle -16777216 true false 255 135 270 300
Rectangle -16777216 true false 45 285 255 300

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person2
false
0
Rectangle -2674135 true false 0 45 300 90
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person3
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
Polygon -13345367 true false 225 165 240 210 210 210
Polygon -13345367 true false 75 165 60 210 90 210
Circle -13345367 true false 180 193 92
Circle -13345367 true false 28 193 92

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

tree1
false
0
Polygon -7500403 true true 105 300 180 300 150 0 120 300
Circle -7500403 true true 75 30 30
Polygon -7500403 true true 150 225 150 210 135 225 75 105 150 210
Polygon -7500403 true true 165 150 165 135 150 150 90 30 165 135
Polygon -7500403 true true 135 150 135 135 150 150 210 30 135 135
Polygon -7500403 true true 150 225 150 210 165 225 225 105 150 210
Polygon -7500403 true true 150 180 150 165 165 180 225 60 150 165
Polygon -7500403 true true 150 180 150 165 135 180 75 60 150 165
Circle -7500403 true true 135 0 30
Circle -7500403 true true 45 15 30
Circle -7500403 true true 45 60 30
Circle -7500403 true true 210 45 30
Circle -7500403 true true 225 90 30
Circle -7500403 true true 60 45 30
Circle -7500403 true true 90 210 30
Circle -7500403 true true 180 15 30
Circle -7500403 true true 15 75 30
Circle -7500403 true true 195 195 30
Circle -7500403 true true 240 165 30
Circle -7500403 true true 150 15 30
Circle -7500403 true true 165 210 30
Circle -7500403 true true 165 0 30
Circle -7500403 true true 45 195 30
Circle -7500403 true true 255 75 30
Circle -7500403 true true 195 45 30
Circle -7500403 true true 210 90 30
Circle -7500403 true true 30 45 30
Circle -7500403 true true 210 45 30
Circle -7500403 true true 30 105 30
Circle -7500403 true true 240 120 30
Circle -7500403 true true 45 165 30
Circle -7500403 true true 210 120 30
Circle -7500403 true true 255 45 30
Circle -7500403 true true 210 225 30
Circle -7500403 true true 15 135 30
Circle -7500403 true true 45 135 30
Circle -7500403 true true 210 165 30
Circle -7500403 true true 225 30 30
Circle -7500403 true true 15 150 30
Circle -7500403 true true 75 0 30
Circle -7500403 true true 255 180 30
Circle -7500403 true true 0 105 30
Circle -7500403 true true 105 30 30
Circle -7500403 true true 225 60 30
Circle -7500403 true true 15 180 30
Circle -7500403 true true 75 180 30
Circle -7500403 true true 270 105 30
Circle -7500403 true true 45 90 30
Circle -7500403 true true 225 195 30
Circle -7500403 true true 255 135 30
Polygon -7500403 true true 165 195 240 165 165 180
Polygon -7500403 true true 135 195 60 165 135 180
Polygon -7500403 true true 105 165 30 135 105 150
Polygon -7500403 true true 165 150 240 120 165 135
Circle -7500403 true true 180 120 30
Circle -7500403 true true 165 75 30
Circle -7500403 true true 105 75 30
Circle -7500403 true true 90 120 30
Circle -7500403 true true 75 75 30
Circle -7500403 true true 150 45 30
Circle -7500403 true true 105 195 30
Circle -7500403 true true 165 180 30

tree2
false
0
Rectangle -7500403 true true 135 195 165 300
Polygon -7500403 true true 45 240 150 210 255 240 150 150
Polygon -7500403 true true 60 210 150 165 240 210 150 135
Polygon -7500403 true true 75 180 150 150 225 180 150 105
Polygon -7500403 true true 75 165 150 120 225 165 150 60
Polygon -7500403 true true 90 120 150 90 210 120 150 30
Polygon -7500403 true true 105 75 150 45 195 75 150 0

tree3
false
0
Rectangle -7500403 true true 135 240 165 300
Rectangle -7500403 true true 135 15 165 240
Polygon -7500403 true true 135 15 150 0 165 15
Rectangle -10899396 true false 60 210 105 210
Polygon -7500403 true true 135 195 90 150 75 90 90 165 135 210
Polygon -7500403 true true 165 195 210 150 225 90 210 165 165 210
Polygon -7500403 true true 135 135 90 90 75 60 90 105 135 150
Polygon -7500403 true true 165 135 210 90 225 60 210 105 165 150
Polygon -7500403 true true 150 90 105 45 90 15 105 60 150 105
Polygon -7500403 true true 150 90 195 45 210 15 195 60 150 105
Polygon -7500403 true true 105 165 60 120 45 60 60 135 105 180
Polygon -7500403 true true 195 165 240 120 255 60 240 135 195 180
Polygon -7500403 true true 90 90 45 45 30 15 45 60 90 105
Polygon -7500403 true true 210 90 255 45 270 15 255 60 210 105
Polygon -7500403 true true 180 60 225 15 240 -15 225 30 180 75
Polygon -7500403 true true 120 60 75 15 60 -15 75 30 120 75
Polygon -7500403 true true 75 135 30 90 15 30 30 105 75 150
Polygon -7500403 true true 225 135 270 90 285 30 270 105 225 150
Polygon -7500403 true true 225 150 240 150 255 165 255 180 240 180 225 165
Polygon -7500403 true true 255 120 270 120 285 135 285 150 270 150 255 135
Polygon -7500403 true true 225 90 240 90 255 105 255 120 240 120 225 105
Polygon -7500403 true true 255 60 270 60 285 75 285 90 270 90 255 75
Polygon -7500403 true true 225 30 240 30 255 45 255 60 240 60 225 45
Polygon -7500403 true true 195 60 210 60 225 75 225 90 210 90 195 75
Polygon -7500403 true true 180 135 195 135 210 150 210 165 195 165 180 150
Polygon -7500403 true true 195 180 210 180 225 195 225 210 210 210 195 195
Polygon -7500403 true true 165 75 180 75 195 90 195 105 180 105 165 90
Polygon -7500403 true true 105 180 90 180 75 195 75 210 90 210 105 195
Polygon -7500403 true true 75 150 60 150 45 165 45 180 60 180 75 165
Polygon -7500403 true true 45 120 30 120 15 135 15 150 30 150 45 135
Polygon -7500403 true true 120 135 105 135 90 150 90 165 105 165 120 150
Polygon -7500403 true true 75 90 60 90 45 105 45 120 60 120 75 105
Polygon -7500403 true true 45 60 30 60 15 75 15 90 30 90 45 75
Polygon -7500403 true true 75 30 60 30 45 45 45 60 60 60 75 45
Polygon -7500403 true true 105 60 90 60 75 75 75 90 90 90 105 75
Polygon -7500403 true true 135 75 120 75 105 90 105 105 120 105 135 90
Polygon -7500403 true true 165 15 180 15 195 30 195 45 180 45 165 30
Polygon -7500403 true true 135 15 120 15 105 30 105 45 120 45 135 30

tree4
false
0
Rectangle -7500403 true true 150 210 165 300
Rectangle -6459832 true false 135 195 135 240
Rectangle -7500403 true true 135 210 150 300
Polygon -7500403 true true 135 210 120 210 105 180 60 180 75 150 45 150 60 135 45 120 60 105 90 105 90 90 75 90 75 45 105 45 120 30 150 15 165 15 210 30 225 15 240 30 240 60 255 75 240 90 225 90 240 135 270 135 255 165 240 180 210 165 195 180 210 195 195 210 195 225

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck1
true
0
Polygon -7500403 true true 193 4 150 4 134 41 104 56 104 92 194 93
Circle -16777216 true false 162 12 66
Rectangle -7500403 true true 185 86 194 119
Rectangle -7500403 true true 90 105 187 296
Circle -16777216 true false 162 102 66
Circle -16777216 true false 162 222 66
Rectangle -1 true false 195 195 195 240
Polygon -16777216 true false 112 62 141 48 141 81 112 82
Circle -16777216 true false 174 24 42
Circle -16777216 true false 174 114 42
Circle -16777216 true false 174 234 42
Circle -7500403 false true 174 114 42
Circle -7500403 false true 174 24 42
Circle -7500403 false true 174 234 42
Rectangle -6459832 true false 75 120 90 270
Rectangle -2674135 true false 60 120 75 270
Rectangle -955883 true false 45 120 30 240
Rectangle -6459832 true false 45 120 60 255
Rectangle -2674135 true false 30 120 45 240

truck2
true
0
Polygon -7500403 true true 107 4 150 4 166 41 196 56 196 92 106 93
Circle -16777216 true false 72 12 66
Rectangle -7500403 true true 106 86 115 119
Rectangle -7500403 true true 113 105 210 296
Circle -16777216 true false 72 102 66
Circle -16777216 true false 72 222 66
Rectangle -1 true false 195 195 195 240
Polygon -16777216 true false 188 62 159 48 159 81 188 82
Circle -16777216 true false 84 24 42
Circle -16777216 true false 84 114 42
Circle -16777216 true false 84 234 42
Circle -7500403 false true 84 114 42
Circle -7500403 false true 84 24 42
Circle -7500403 false true 84 234 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
