breed [households household]

patches-own [
  psize
]

households-own [
  income
]

globals [
  average-estimate
  average-100-estimates
  n
]

to setup
  clear-all
  
  set-default-shape households "house"
  
  ask patches [set pcolor green]
  
  ask n-of No-of-settlements patches [
    set psize random-normal Average-settlement-size Std-dev-settlement-size
    sprout-households psize [
      set size 0.5
      set income psize * 2 + random-float 3
      set color white
      left random-float 360
      jump random-normal 0 psize / 10000
    ]
  ] 
  
  reset-ticks
end

to random-sample
  let pom 0
  ask households [set color white]
  ask n-of Sample-size households [
    set color red
    set pom pom + income
  ]
  set average-estimate pom / Sample-size 
end

to hundred-random-samples
  set average-100-estimates 0
  let pom 0
  set n 0
  clear-plot
  repeat 100 [
    set n n + 1
    random-sample
    set pom pom + abs (average-estimate - mean [income] of households) * 100 / mean [income] of households
    tick
  ]
  set average-100-estimates pom / 100
end

to convenience-sample
  let pom 0
  ask households [set color white]
  ask one-of patches with [((count turtles-here + count turtles-on neighbors) >= Sample-size) and (count turtles-here > 0)] [
    ask one-of households-here [
      set color red
      ask n-of Sample-size households in-radius 7 [
        set color red
        set pom pom + income
      ]
      set average-estimate pom / Sample-size 
    ]
  ]
end

to hundred-convenience-samples
  set average-100-estimates 0
  let pom 0
  set n 0
  clear-plot
  repeat 100 [
    set n n + 1
    convenience-sample
    set pom pom + abs (average-estimate - mean [income] of households) * 100 / mean [income] of households
    tick
  ]
  set average-100-estimates pom / 100
end
@#$#@#$#@
GRAPHICS-WINDOW
9
28
444
484
12
12
17.0
1
10
1
1
1
0
1
1
1
-12
12
-12
12
0
0
1
ticks
30.0

BUTTON
569
140
674
185
Setup
Setup
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

SLIDER
454
28
674
61
No-of-settlements
No-of-settlements
0
100
5
1
1
NIL
HORIZONTAL

SLIDER
454
65
674
98
Average-settlement-size
Average-settlement-size
0
20000
2000
100
1
NIL
HORIZONTAL

SLIDER
454
102
674
135
Std-dev-settlement-size
Std-dev-settlement-size
0
20000
2000
100
1
NIL
HORIZONTAL

MONITOR
454
140
564
185
Households
count households
0
1
11

MONITOR
454
191
564
236
Average income
mean [income] of households
2
1
11

SLIDER
454
277
674
310
Sample-size
Sample-size
10
5000
30
10
1
NIL
HORIZONTAL

BUTTON
454
315
605
348
Simple random sample >
random-sample
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
454
394
650
439
Estimate of average income
average-estimate
2
1
11

MONITOR
656
394
752
439
Error [%]
abs (average-estimate - mean [income] of households) * 100 / mean [income] of households
2
1
11

BUTTON
611
315
674
348
100x
hundred-random-samples
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
454
353
605
386
Convenience sample >
convenience-sample
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
611
353
674
386
100x
hundred-convenience-samples
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
682
326
752
371
Sample no
n
0
1
11

PLOT
9
490
734
703
Errors for 100 estimates
Sample no
Error [%]
0.0
100.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 1 -2674135 true "" "if ticks != 0 [plot abs (average-estimate - mean [income] of households) * 100 / mean [income] of households]"

PLOT
682
28
920
185
Income distribution
Income
Frequency
0.0
10000.0
0.0
10.0
true
false
"" ""
PENS
"default" 1000.0 1 -6459832 true "" "set-histogram-num-bars 10\nhistogram [income] of households"

MONITOR
520
495
729
540
Average error for 100 estimates [%] 
average-100-estimates
2
1
11

@#$#@#$#@
## WHAT IS IT?

This model should help students in understanding of basic research sampling concepts and methods - simple random (probability) sampling and convenience (nonprobability) sampling. It also shows differences in estimates that these methods provide.

## HOW IT WORKS

Research population of households is being generated and then it is possible to virtually survey samples from this population about their income. Data from these surveys are being used for calculating estimates of average income for the whole population.

Two sampling methods are available. Simple random sampling randomly chooses selected amount of households to survey. Convenience sampling randomly generates the first household and then chooses other households in its neighborhood.

## HOW TO USE IT

At first, population for sampling has to be generated using Setup button. It is possible to define some basic parameters for the population to be generated - number of settlements, average settlement size and standard deviation of the settlement size.

After the first step, an average income and distribution of income of the generated population is being shown. Estimates that are calculated from samples being surveyed by different methods and with different sizes then can be easily compared to the known population characteristics (average income).

Then 2 decisions about sampling have to be made:
1) Sample size - can be set up by the appropriate slider
2) Sampling method - can be chosen by clicking the appropriate button

It is also possible to repeat sampling 100 times which shows a more general pattern of differences between estimates and the real value of average income.

## THINGS TO NOTICE

Simple random sampling (SRS) gives better and with increasing sample size also more precise results (i.e. with smaller estimate error). It is due to the way how the probability laws are being involved. It is also quite clear that a meaningful statistical error may be calculated for SRS - which can be vizualized on the chart with 100 samples (for 95 % confidence level it is possible to find and show the lowest error value with 5 occurences, i.e. 5 % of 100).  

Convenience sampling and estimates based on that typically gives very confounding results and there is no clear relationship between the sample size and errors in estimates. This shows, how for instance sampling based on Facebook friends network or geographical closeness may be very problematic for further generalization to the whole population.

## THINGS TO TRY

It is possible to explore the relationship between sampling methods, sample size and errors in estimates. E.g. to try 100 samples for 5 different sample sizes (30, 100, 200, 500, 1000) and compare results.

## EXTENDING THE MODEL

The income is being generated based on settlement size and the final distribution is not statistically normal which could be changed. 

## CREDITS AND REFERENCES

(c) 2014 Viktor Vojtko, Faculty of Economics, University of South Bohemia. All rights reserved.

Permission to use, modify or redistribute this model is hereby granted, provided that both of the following requirements are followed:

a) this copyright notice is included.

b) this model will not be redistributed for profit without permission from Viktor Vojtko, Faculty of Economics, University of South Bohemia. Contact the author for appropriate licenses for redistribution for profit.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
