;;-----------------------------------------------------------------------------|
;; SECTION A – AUTHOR IDENTIFICATION AND CODE ABSTRACT
;;-----------------------------------------------------------------------------|
;;
;; File Name: CmLab_V1.xx.nlogo
;; By Orrery Software
;; Dated: 2016-05-09
;; Author contact:
;;   Garvin H Boyle
;;   orrery@rogers.com
;;   http://orrery-software.webs.com

;; As the author, I welcome questions, discussion of issues and suggestions
;;   for improvements.

;;-----------------------------------------------------------------------------|
;; This CmLab app is a laboratory in which students can study aspects 
;;   of the proposed law of conservation of money.

;;-----------------------------------------------------------------------------|
;; SECTION B – INITIAL DECLARATIONS OF GLOBALS AND BREEDS
;;-----------------------------------------------------------------------------|
;;
;;-----------------------------------------------------------------------------|
;; This program was developed on NetLogo Version 5.0.5
;;

;;-----------------------------------------------------------------------------|
;; code-determined global variables
globals
[
  ;; The version should be coded in this global variable to be included in
  ;;   output files.
  gs-Version
  
  ;; Note: Some global variables are declared inside of switches, sliders and 
  ;;   choosers when the interface is constructed and are not declared here.
  ;;   For the sake of clarity and completeness, they are noted here.
  
  ;; There are several uses of global variables:
  ;;  - Toggles (switches), and choosers which enable or disable features;
  ;;  - Numbers (in variables or sliders) which act as parameters;
  ;;  - Numbers (in variables) which collect data.
  ;;
  ;; Those marked as 'native Boolean' have values of true or false.
  ;; Those marked as 'numeric Boolean' have values of 1 or 0.
   
  ;;---------------------
  ;; MODELING ENVIRONMENT
  ;;---------------------
  
  ;; Assumed “Model Settings” on startup
  ;; horizontal wrap: on
  ;; vertical wrap: on
  ;; location of origin: centre
  ;; patch size: 9.63 pixels
  ;;-----------------------------------------------------------------------------|
  ;; Implicit global variables due to model settings – patch locations
  ;; min-pxcor  -15
  ;; max-pxcor   15
  ;; min-pycor  -15
  ;; max-pycor   15
  
  ;;----------------------------
  ;; SCENARIO SELECTION CONTROLS
  ;;----------------------------
  
  ;; gs-scenario         ;; Chooser, string converts to a scenario number
  g-scenario-number      ;; scenario no., 0 or 1; interpretation of gs-scenario
  ;; The possible scenarios.
  ge-scenario-with-prsns ;; scenario 0
  ge-scenario-with-corps ;; scenario 1

  ;; To halt a scenario at a pre-determined tick.
  ;; g-halt-at-tick       ;; Has it's own input box

  ;; Initialize the Pseudo Random Number Generator (PRNG).
  ;; g-use-this-seed      ;; Slider, ( 1 <= g-use-this-seed <= 100 )

  ;;-----------------------------------------------
  ;; ECONOMIC MODEL PARAMETERS AND CONTROLS
  ;;-----------------------------------------------

  ;; SWITCHES
  ;; These can be turned on and off during operations.
  ;; They are declared in the switches, and noted here.
  ;; -btfs- stands for bank-to-prsns flows, and these control the way
  ;;   that interest collected by banks can flow back into the real
  ;;   economy.
  ;; gb-btpfs-bankruptcies     ;; Always on, set in do-pre-tick.
  ;; gb-btpfs-daily-purchases  ;; Banks buy but do not sell.
  ;; gb-btpfs-monthly-taxes    ;; All C1 assets taxed and redistributed
  
  ;; INTEREST RATES (Sliders) [min, inc, max, val]
  ;; Sliders can be altered during operations.
  ;; g-iorr    ;; Interest On Required Reserves [ 0 .1 100 2 ]
  ;; g-ioer    ;; Interest On Excess Reserves   [ 0 .1 100 1 ]
  ;; g-iosd    ;; Interest On Savings Deposits  [ 0 .1 100 1 ]
  ;; g-iobl    ;; Interest On Bank Loans        [ 0 .1 100 2 ]
  ;; TODO: Put g-docs into a % slider when Corps activated.
  ;; g-docs    ;; Dividends on Corporate Stocks [ 0 .1 100 2 ]

  ;; OTHER SLIDERS:
  ;; The first three can be changed at any time, but are effective only
  ;;   during setup.
  ;; g-no-of-banks-max       ;;                   [ 1   1   20    10    ]
  ;; g-no-of-prsns-per-bank  ;;                   [ 1   1   200   10    ]
  ;; g-crb-assets-per-prsn   ;; currency at start [ 100 100 10000 1000  ]
  g-no-of-corps-per-bank  ;; at start          [ 1   1   20    4     ]

  ;; These are effective during operations.
  ;; g-net-worth-tax-rate    ;; Calculate taxes   [ 0 0.1   0.5   10    ]
  ;; g-reserve-requirement-ratio ;;               [ 1 0.1   100   20    ]
  
  ;; REALLY ADVANCED CONTROLS - PANEL 04
  ;; gb-bank-insurance       ;; When true, banks share loss of bankruptcy.
  ;; g-bankruptcy-factor     ;; Used to determine bankruptcy.
  
  ;; Derived variables:
  g-no-of-banks              ;; Calculated value
  ;; g-no-of-banks-max       ;; A slider
  g-no-of-prsns              ;; Calculated value
  g-no-of-prsns-max          ;; Calculated value
  g-no-of-corps              ;; Calculated value
  g-no-of-corps-max          ;; Calculated value

  ;; Various internal global constants derived from g-crb-assets-per-prsn.
  g-p-daily-cost-of-living   ;; Used to determine daily purchases.
  g-p-daily-L0-allocation    ;; Used to determine daily cash purchases.
  g-p-daily-L1-allocation    ;; Used to determine daily purchases by check.
  g-p-standard-loan          ;; Used to set up loans.
  g-p-standard-loan-payment  ;; Used to pay principal on loans.
  g-minimum-vault-cash       ;; Used to manage reserves

  ;;-------------------------------------
  ;; END OF MODEL PARAMETERS AND CONTROLS
  ;;-------------------------------------
  
  ;;-------------------------------------
  ;; DATA COLLECTION AND DISPLAY CONTROLS
  ;;-------------------------------------
  
  ;; The following global variables are not model controls or paramaters, 
  ;;   but, rather, are variables used to collect data about the model 
  ;;   for display in the user interface, in some fashion (monitors or plots),
  ;;   or used to manage all of the debug routines and output.
  
  ;; DATA COLLECTION

  ;; In the following I use "debts" to mean "liabilities".
  ;; Money supplies
  g-msi-ttl-assets        ;; Money supply I, Physical money supply.
  g-msii-ttl-assets       ;; Money supply II, Logical money supply.
  g-msiii-ttl-assets      ;; Money supply III, Shadow money supply.
  g-msi-ttl-debts         ;; Money supply I, Physical money supply.
  g-msii-ttl-debts        ;; Money supply II, Logical money supply.
  g-msiii-ttl-debts       ;; Money supply III, Shadow money supply.
  g-msi-net               ;; Money supply I, Net money
  g-msii-net              ;; Money supply II, Net money
  g-msiii-net             ;; Money supply III, Net money
  
  ;; Money Categories - by money supply.
  ;; MS-I - The money base - Physical money supply.
  g-msi-prsn-P0-cash      ;; cash in circulation - assets
  g-msi-corp-P0-cash      ;; cash in circulation - assets
  g-msi-bank-vc           ;; bank vault cash - assets
  g-msi-bank-rr-assets    ;; bank required reserves - assets
  g-msi-bank-er-assets    ;; bank excess reserves - assets
  g-msi-bank-rr-debts     ;; bank required reserves - assets
  g-msi-bank-er-debts     ;; bank excess reserves - assets
  g-msi-crb-L0-assets     ;; money base logical endowment
  g-msi-crb-P0-assets     ;; money base physical endowment
  g-msi-crb-L0-debts      ;; money base logical endowment
  g-msi-crb-P0-debts      ;; money base physical endowment
  g-msi-crb-rr            ;; CRB required reserves - debts
  g-msi-crb-er            ;; CRB excess reserves - debts
  
  ;; MS-II - The logical money supply. 
  g-msii-prsn-L0-cash     ;; cash in circulation, overlaps with MS-I.
  g-msii-corp-L0-cash     ;; cash in circulation, overlaps with MS-I.
  g-msii-crb-C1-assets    ;; private corp level debts
  ;; xx g-msii-crb-c2-assets ;; private corp level assets

  g-msii-gcra-L1-assets   ;; govt checking assets
  g-msii-gcra-L1-loan-debts ;; govt loan debts
  ;; xx g-msii-gcra-L2-assets ;; govt savings assets
  ;; ss g-msii-gcra-L3-debts    ;; govt bond debts
  
  g-msii-bank-L1-assets   ;; bank checking assets
  g-msii-bank-L1-loan-assets ;; bank loan assets
  g-msii-bank-L1-debts    ;; bank checking debts
  g-msii-bank-L2-assets   ;; bank savings assets
  g-msii-bank-L2-debts    ;; bank savings debts
  ;; ss g-msii-bank-L3-assets   ;; bank bond assets
  g-msii-bank-C1-assets   ;; private L1 checking assets
  ;; g-msii-bank-c2-assets   ;; private L2 savings assets
  
  g-msii-prsn-L1-assets   ;; prsn checking assets
  g-msii-prsn-L1-loan-debts ;; prsn loan debts
  g-msii-prsn-L2-assets   ;; prsn savings assets
  ;; ss g-msii-prsn-L3-assets   ;; prsn bond assets
  ;; ss g-msii-prsn-L4-assets   ;; prsn bond assets
  
  g-msii-corp-L1-assets   ;; corp checking assets
  g-msii-corp-L1-loan-debts ;; corp loan debts
  g-msii-corp-L2-assets   ;; corp savings assets
  ;; ss g-msii-corp-L3-assets   ;; corp bond assets
  ;; ss g-msii-corp-L3-debts    ;; corp bond debts
  ;; ss g-msii-corp-L4-assets   ;; corp bond assets
  ;; ss g-msii-corp-L4-debts    ;; corp bond debts

  ;; MS-III - The shadow money supply. 
  g-msiii-crb-S1-rrip-debts  ;; interest payable on rr - debts
  g-msiii-crb-S1-erip-debts  ;; interest payable on er - debts
  g-msiii-gcra-S1-L1ip-debts ;; govt interest payable on loan - debts
  ;; ss g-msiii-gcra-S1-L3ip-debts   ;; govt interest payable on bonds - debts
  g-msiii-bank-S1-L1ir-assets  ;; bank interest receivable on loans - assets
  g-msiii-bank-S1-L2ip-debts   ;; bank interest payable on savings - debts
  g-msiii-bank-S1-rrir-assets  ;; bank interest receivable on rr - assets
  g-msiii-bank-S1-erir-assets  ;; bank interest receivable on er - assets
  g-msiii-prsn-S1-L1ip-debts   ;; prsn interest payable on L1 loans - debts
  g-msiii-prsn-S1-L1tp-debts   ;; prsn 30day total payables - debts
  g-msiii-prsn-S1-L1tr-assets  ;; prsn 30day total receivables - assets
  g-msiii-prsn-S1-L2ir-assets  ;; prsn interest receivable on savings - assets
  ;; ss g-msiii-prsn-S1-L3ir-assets  ;; prsn interest receivable on bonds - assets
  ;; ss g-msiii-prsn-S1-L4dr-assets  ;; prsn dividend receivable on stocks - assets
  g-msiii-corp-S1-L1tp-debts   ;; corp 30day total payables - debts
  g-msiii-corp-S1-L1tr-assets  ;; corp 30day total receivables - assets
  g-msiii-corp-S1-L2ir-assets  ;; corp interest receivable on savings - assets
  ;; ss g-msiii-corp-S1-L3ip-assets  ;; corp interest payable on bonds - debts
  ;; ss g-msiii-corp-S1-L4dp-assets  ;; corp dividend payable on stocks - debts

  ;; Public funds in trust vs Private funds 
  g-crb-P0-assets        ;; In public trust
  g-crb-publ-assets      ;; In public trust
  g-crb-priv-assets      ;; Profit/Loss related
  g-crb-publ-debts       ;; In public trust
  g-crb-priv-debts       ;; Profit/Loss related
  g-crb-publ-net-worth   ;; In public trust
  g-crb-priv-net-worth   ;; Profit/Loss related
  
  g-gcra-P0-assets       ;; In public trust
  g-gcra-publ-assets     ;; In public trust
  g-gcra-priv-assets     ;; Profit/Loss related
  g-gcra-publ-debts      ;; In public trust
  g-gcra-priv-debts      ;; Profit/Loss related
  g-gcra-publ-net-worth  ;; In public trust
  g-gcra-priv-net-worth  ;; Profit/Loss related
  
  g-bank-P0-assets       ;; In public trust
  g-bank-publ-assets     ;; In public trust
  g-bank-priv-assets     ;; Profit/Loss related
  g-bank-publ-debts      ;; In public trust
  g-bank-priv-debts      ;; Profit/Loss related
  g-bank-publ-net-worth  ;; In public trust
  g-bank-priv-net-worth  ;; Profit/Loss related
  
  g-prsn-P0-assets       ;; In public trust
  g-prsn-publ-assets     ;; In public trust
  g-prsn-priv-assets     ;; Profit/Loss related
  g-prsn-publ-debts      ;; In public trust
  g-prsn-priv-debts      ;; Profit/Loss related
  g-prsn-publ-net-worth  ;; In public trust
  g-prsn-priv-net-worth  ;; Profit/Loss related
  
  g-corp-P0-assets       ;; In public trust
  g-corp-publ-assets     ;; In public trust
  g-corp-priv-assets     ;; Profit/Loss related
  g-corp-publ-debts      ;; In public trust
  g-corp-priv-debts      ;; Profit/Loss related
  g-corp-publ-net-worth  ;; In public trust
  g-corp-priv-net-worth  ;; Profit/Loss related
  
  ;; DATA DISPLAY - Histogram axes
  g-agents-nw-xaxis-min  ;; Minimum value on prsn net worth histogram.
  g-agents-nw-xaxis-max  ;; Maximum value on prsn net worth histogram.
  g-prsns-nw-xaxis-min   ;; Minimum value on prsn net worth histogram.
  g-prsns-nw-xaxis-max   ;; Maximum value on prsn net worth histogram.
  g-banks-nw-xaxis-min   ;; Minimum value on prsn net worth histogram.
  g-banks-nw-xaxis-max   ;; Maximum value on prsn net worth histogram.
  g-banks-P0-xaxis-min   ;; Minimum value on P0-all-assets.
  g-banks-P0-xaxis-max   ;; Maximum value on P0-all-assets.
  g-banks-P0-all-assets-min  ;; Minimum value on P0-all-assets.
  g-banks-P0-all-assets-mean ;; Mean value on P0-all-assets.
  g-banks-P0-all-assets-max  ;; Max value on P0-all-assets.

  ;; DATA DISPLAY - Line Graphs
  g-max-net-worth-priv-prsns   ;; What it says.
  g-mean-net-worth-priv-prsns  ;; What it says.
  g-min-net-worth-priv-prsns   ;; What it says.
  g-max-net-worth-priv-banks   ;; What it says.
  g-mean-net-worth-priv-banks  ;; What it says.
  g-min-net-worth-priv-banks   ;; What it says.

  ;; DATA DISPLAY - Event Counts
  g-counts-loans
  g-counts-p-deaths
  g-counts-p-births
  g-counts-b-deaths
  g-counts-b-births

  ;;---------------
  ;; DEBUG CONTROLS
  ;;---------------
  
  gb-debug-on                 ;; Numeric Boolean, opens debug log file, 0 or 1.
  gs-debug-status             ;; for monitor, '1 (On)' or '0 (Off)', 
  ;; gs-debug-step-chooser    ;; Chooser, used with gb-debug-flow-on
  gb-debug-flow-on            ;; Numeric Boolean, in association with chooser, 
  gs-log-file-name            ;; name of the debug log file
                              ;;   opens flow to log file
  ;; gb-debug-show-steps      ;; Switch, Native Boolean, show in command centre
]


;;-----------------------------------------------------------------------------|
;; Attributes of patches
patches-own 
[
  ;; BUILT-IN ATTRIBUTES 
  ;; pxcor        ;; min-pxcor <= pxcor < max-pxcor
  ;; pycor        ;; min-pxcor <= pxcor < max-pxcor 
  ;; pcolor       ;; color of this patch ( 0 <= color < 140 ) 
  ;; plabel       ;; label of this patch
  ;; plabel-color ;; color of this patch's label ( 0 <= label-color < 140 ) 
   
  ;; CmLab-DETERMINED ATTRIBUTES
  ;; Nil.
]

;;-----------------------------------------------------------------------------|
;; Attributes of links
;;-----------------------------------------------------------------------------|
;; nil
;; I don't understand links and did not use any.

;;-----------------------------------------------------------------------------|
;; THEORY:  ATTRIBUTES WITH MONEY SUPPLY DESIGNATORS
;;          P0, L0, L1, L2, L3, L4, S1, C1.
;;          REPLACING M0, M1, M2, M3, M4.
;;-----------------------------------------------------------------------------|
;; WARNING -   I am NOT using the Mx designations as they are used in the
;;             the real world - for two reasons.
;;             1.  In the real world M4 includes M3, M3 includes M2, etc. until
;;                 the end where M1 includes M0.  For me, each category of money
;;                 is independent of the other.  It's easier to track.  The real
;;                 world meaning can be recovered simply by adding the included
;;                 data, at your choice.  So I use L0, L1, L2, ... and P0.
;;             2.  No two countries seem to have the same definitions for each
;;                 of the categories of money, so I do not try to accurately
;;                 simulate or replicate that money supply structure of any one
;;                 country, but, rather, I abstract a simplified model that is
;;                 relatively close to all of them.
;;
;;          In addition, I use C1 and S1 as special temporary designators.
;;
;; Which agents can hold which types of assets and debts is a bit of
;;   a tricky question.  I have resolved it this way.
;;
;; L0 assets - only prsns and corps can use cash.  All others make payments by 
;;             check.  L0 assets are in the wallets of prsns and corps.
;; P0-assets - this is physical part of currency, stored in wallets and vaults.
;;             P0 savings accounts are the only investment option for commercial 
;;             banks, but are called P0-RR and P0-ER deposits, with the CRB.
;;             Prsns and Corps hold P0-assets in their wallets.
;; L0-debts -  don't really exist.  They become L1 debts. 
;; L1-assets - checking accounts are the work horse of this economy.  All agents
;;             have checking accounts.  They accept L1 payments into their 
;;             L1 checking account and make L1 payments out of it.  In the case  
;;             of the CRB or commercial banks, it is called C1-assets, to 
;;             distinguish those accounts held in public trust from those that
;;             function as their private funds.  The CRB's C1-assets are a 
;;             part of the GCRA L1-assets and get merged there regularly.
;; L1-loan-assets  - Commercial banks are the only ones that can provide loans.
;;             The loans stick with the borrower and the bank until they are paid
;;             off.  The loans are also the primary means for expanding the 
;;             MS-II money supply, using a pair of double-entry records.  
;;             When a loan is "signed" in two copies it creates a liability 
;;             for the borrower and an asset for the lender.  Then the money 
;;             is created by entering an L1 liability for the bank, and an L1 
;;             asset for the borrower.  The two double-entries, or four entries 
;;             in total, represent the loan.  No net worth is altered by such 
;;             an event since the entries counter-balance each other.  
;;                 Any payment that alters the networth of participants involves
;;             two entries that do not counter-balance.  When a payment is 
;;             made on a loan, it requires two double-entries (four entries) 
;;             that counter-balance again to record the payment. Again, no 
;;             change in networth of either party happens, but the MS-II money
;;             supply constracts again.
;; L1-debts -  For commercial banks, this is the hind end of L1-assets and
;;             C1-assets.  Non-bank agents (GCRA, CRB, prsns, corps) have no 
;;             need of these.  The sum of all explicit bank L1-debts is the 
;;             standard money supply (MS-II).
;; L1-loan-debts - This is the second entry of the four that are required
;;             to record a loan.  This and the L1-loan-assets must always be 
;;             incremented or decremented by matching records, indicating
;;             the expansion or reduction of the MS-II money supply.  Chartered
;;             banks do not have loan debts.  Their clients do.  I.e. loan
;;             debts are for prsns, corps, and the GCRA.
;;
;; Other L1-type assets - all receivables are S1-type assets.
;; Other L1-type debts  - all payables are S1-type debts.
;;             S1-type money is convertible to L1-type money when paid.
;;
;; L2-assets - L2 savings accounts are the primary investment option for agents
;;             other than banks.  GCRA, prsns and corps may hold L2-assets.
;; L2-debts -  only banks hold L2-debts.   
;;
;; TODO: Beyond L2 nothing has been implemented.
;; In the real world M3 and M4 are more and more broad designations.  In this
;;   program I have changed that.  L3 are bonds.  L4 are stocks.
;;
;; L3-assets - these are the assets of bond buyers/holders.  That might include
;;             prsns and corps.
;; L3-debts -  these are the debts of bond sellers.  That includes
;;             The GCRA, banks and corps.
;;
;; L4-assets - these are the assets of stock buyers/holders.  That might include
;;             prsns and corps.
;; L4-debts -  these are the debts of stock sellers.  That includes
;;             only the corps.
;;
;; All interest on savings deposits (with CRB or banks), on bonds, on loans, or
;;             all dividends, are S1-type assets and debts, convertible to 
;;             L1-type money when paid.
;;
;; C1-assets and C2-assets - both the CRB and chartered banks have a dual role.
;;             In the "back room" role they guard the public trust by ensuring 
;;             that money is properly conserved at the level of client-to-client
;;             transactions.  In the "front room" role they are organizations 
;;             that charge fees for financial services.  The net worth of the 
;;             back room must always be zero.  The net worth of the front room
;;             is where corporate profits and losses are recorded.  The back 
;;             room staff may have many "clients" consisting of prsns and corps,
;;             but they have one special client, which is their own front room
;;             organization.
;;             Each client must maintain its own checking and savings bank books
;;             (in the variables L1-assets and L2-assets.  The front room 
;;             client must also keep such records separate from back room assets,
;;             which would also be in variables of the same name.  So the front
;;             room assets I have designated as C1-assets and C2-assets.
;;
;; S1-assets and S1-debts - those persistent debts that exist unpaid for a 
;;             duration longer than the moment required to create them are 
;;             part of the shadow money supply and are designated as S1-type.
;;             In some sense, I mean the shadow money supply to be that part of
;;             the money supply that is invisible to the governing monetary
;;             architecture (i.e. the CRB and its chartered banks), and I still
;;             think that is the best definition for a real-world system.  But
;;             for this model I have implemented the shadow money supply as
;;             all such persistent debts, excluding only the persistent debts 
;;             associated with L1-loans from chartered banks.  Double-entry
;;             book-keeping still applies: for every S1-debt created a counter-
;;             balancing S1-asset is also created.
;; TODO: when stocks and bonds are implemented as part of the activation of 
;;             corps, they will be in the shadow money supply, and I may change
;;             the implementation to be more consistent with the "visibility"
;;             criterion.

;;-----------------------------------------------------------------------------|
;; Turtles and breeds
;;-----------------------------------------------------------------------------|

breed [ GCRAs GCRA ]
breed [ CRBs  CRB  ]
breed [ banks bank ]
breed [ prsns prsn ]
breed [ corps corp ]

;;-----------------------------------------------------------------------------|
;; Attributes of GCRAs (Government Consolidated Revenue Accounts)
GCRAs-own 
[
  ;; BUILT-IN ATTRIBUTES
  ;; who         ;; fixed id number
  ;; breed       ;; to which breed this turtle belongs [GCRA]
  ;; heading     ;; 0 <= heading < 360, 0 = north
  ;; xcor        ;; min-pxcor <= xcor < max-pxcor
  ;; ycor        ;; min-pxcor <= xcor < max-pxcor
  ;; size        ;; size relative to a patch, default is 1
  ;; shape       ;; a shape chosen from the shape library
  ;; color       ;; color of this turtle ( 0 <= color < 140 )
  ;; pen-mode    ;; "up" or "down"
  ;; pen-size    ;; in pixels
  ;; hidden?     ;; true or false
  ;; label       ;; label of this turtle
  ;; label-color ;; color of this turtle's label ( 0 <= label-color < 140 )
  
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with GCRA dynamics.
  default-colour       ;; as it says
  bank-who             ;; bank that holds the loan
  L1-assets            ;; assets of the government
  L1-loan-debts        ;; debts of the government (bank loans)
  S1-L1ip-debts        ;; interest payable on L1 loan
  
  ;; xx L2-assets           ;; savings of the government

  ;; ss L3-debts            ;; debts of the government - bonds
  ;; ss S1-L3ip-debts       ;; payable on bonds
  
  ttl-P0-assets     ;; aggregate of all physical assets
  ttl-publ-assets   ;; aggregate of all public assets
  ttl-publ-debts    ;; aggregate of all public debts
  ttl-priv-assets   ;; aggregate of all private assets
  ttl-priv-debts    ;; aggregate of all private debts
  net-worth-publ    ;; total public assets minus debts
  net-worth-priv    ;; total private assets minus debts
  
  ;; Money supply aggregates
  msi-assets        ;; Physical money supply
  msi-debts         ;; Physical money supply
  msii-assets       ;; Logical money supply
  msii-debts        ;; Logical money supply
  msiii-assets      ;; Shadow money supply
  msiii-debts       ;; Shadow money supply
]

;;-----------------------------------------------------------------------------|
;; Attributes of CRBs (Central Reserve Banks)
CRBs-own 
[
  ;; BUILT-IN ATTRIBUTES
  ;; who         ;; fixed id number
  ;; breed       ;; to which breed this turtle belongs [CRB]
  ;; heading     ;; 0 <= heading < 360, 0 = north
  ;; xcor        ;; min-pxcor <= xcor < max-pxcor
  ;; ycor        ;; min-pxcor <= xcor < max-pxcor
  ;; size        ;; size relative to a patch, default is 1
  ;; shape       ;; a shape chosen from the shape library
  ;; color       ;; color of this turtle ( 0 <= color < 140 )
  ;; pen-mode    ;; "up" or "down"
  ;; pen-size    ;; in pixels
  ;; hidden?     ;; true or false
  ;; label       ;; label of this turtle
  ;; label-color ;; color of this turtle's label ( 0 <= label-color < 140 )
  
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with CRB dynamics.
  default-colour       ;; as it says
  P0-assets            ;; physical assets of the CRB
  L0-assets            ;; logical assets of the CRB
  P0-debts             ;; physcial debts of the CRB
  L0-debts             ;; logical debts of the CRB
  P0-rr-assets         ;; required reserves of all banks
  P0-er-assets         ;; excess reserves of all banks

  ;; Associated with corporate bank dynamics.
  bank-who             ;; chartered bank that holds C1 account.
  S1-rrip-debts        ;; interest payable on required reserves - debts
  S1-erip-debts        ;; interest payable on excess reserves - debts
  C1-assets            ;; corporate bank equivalent of L1-assets
  ;; xx c2-assets            ;; corporate bank equivalent of L2-assets
  
  ttl-P0-assets        ;; aggregate of all physical assets
  ttl-publ-assets      ;; aggregate of all public assets
  ttl-publ-debts       ;; aggregate of all public debts
  ttl-priv-assets      ;; aggregate of all private assets
  ttl-priv-debts       ;; aggregate of all private debts
  net-worth-publ       ;; total public assets minus debts
  net-worth-priv       ;; total private assets minus debts
  
  ;; Money supply aggregates
  msi-assets        ;; Physical money supply
  msi-debts         ;; Physical money supply
  msii-assets       ;; Logical money supply
  msii-debts        ;; Logical money supply
  msiii-assets      ;; Shadow money supply
  msiii-debts       ;; Shadow money supply
]

;;-----------------------------------------------------------------------------|
;; Attributes of banks (deposit-taking banks)
banks-own 
[
  ;; BUILT-IN ATTRIBUTES
  ;; who         ;; fixed id number
  ;; breed       ;; to which breed this turtle belongs [bank]
  ;; heading     ;; 0 <= heading < 360, 0 = north
  ;; xcor        ;; min-pxcor <= xcor < max-pxcor
  ;; ycor        ;; min-pxcor <= xcor < max-pxcor
  ;; size        ;; size relative to a patch, default is 1
  ;; shape       ;; a shape chosen from the shape library
  ;; color       ;; color of this turtle ( 0 <= color < 140 )
  ;; pen-mode    ;; "up" or "down"
  ;; pen-size    ;; in pixels
  ;; hidden?     ;; true or false
  ;; label       ;; label of this turtle
  ;; label-color ;; color of this turtle's label ( 0 <= label-color < 140 )
  
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with book-keeping bank dynamics.
  default-colour       ;; as it says
  b-bank-can-make-loans ;; boolean - 0 or 1
  b-bank-is-bankrupt    ;; boolean - 0 or 1

  L1-assets            ;; assets in checking accounts
  L1-loan-assets       ;; assets associated with a loan
  L1-debts             ;; debts in checking accounts
  S1-L1ir-assets       ;; interest receibable on L1 loans - C1-assets
  
  L2-assets            ;; assets in savings accounts
  L2-debts             ;; debts in savings accounts
  S1-L2ip-debts        ;; on savings deposits

  ;; ss L3-assets            ;; assets in bonds
  ;; ss L3-debts             ;; debts in bonds
  
  crb-who              ;; central reserve bank
  P0-vc-assets         ;; $c in the vault - assets
  P0-er-assets         ;; excess reserves - assets
  P0-er-debts          ;; excess reserves - debts
  P0-rr-assets         ;; required reserves - assets
  P0-rr-debts          ;; required reserves - debts
  P0-all-assets        ;; An aggregate of VC, ER and RR.

  ;; Associated with corporate bank dynamics.
  no-of-prsn-clients   ;; How many clients currently
  no-of-corp-clients   ;; How many clients currently
  no-of-gcra-clients   ;; How many clients currently
  no-of-crb-clients    ;; How many clients currently
  S1-rrir-assets       ;; interest on required reserves
  S1-erir-assets       ;; interest on excess reserves
  C1-assets            ;; corporate bank equivalent of L1-assets
  ;; c2-assets            ;; corporate bank equivalent of L2-assets
  
  ttl-P0-assets        ;; aggregate of all physical assets
  ttl-publ-assets      ;; aggregate of all public assets
  ttl-publ-debts       ;; aggregate of all public debts
  ttl-priv-assets      ;; aggregate of all private assets
  ttl-priv-debts       ;; aggregate of all private debts
  net-worth-publ       ;; total public assets minus debts
  net-worth-priv       ;; total private assets minus debts
  
  ;; Money supply aggregates
  msi-assets        ;; Physical money supply
  msi-debts         ;; Physical money supply
  msii-assets       ;; Logical money supply
  msii-debts        ;; Logical money supply
  msiii-assets      ;; Shadow money supply
  msiii-debts       ;; Shadow money supply
]

;;-----------------------------------------------------------------------------|
;; Attributes of prsns (non-corporate economic agents)
prsns-own 
[
  ;; BUILT-IN ATTRIBUTES
  ;; who         ;; fixed id number
  ;; breed       ;; to which breed this turtle belongs [prsn]
  ;; heading     ;; 0 <= heading < 360, 0 = north
  ;; xcor        ;; min-pxcor <= xcor < max-pxcor
  ;; ycor        ;; min-pxcor <= xcor < max-pxcor
  ;; size        ;; size relative to a patch, default is 1
  ;; shape       ;; a shape chosen from the shape library
  ;; color       ;; color of this turtle ( 0 <= color < 140 )
  ;; pen-mode    ;; "up" or "down"
  ;; pen-size    ;; in pixels
  ;; hidden?     ;; true or false
  ;; label       ;; label of this turtle
  ;; label-color ;; color of this turtle's label ( 0 <= label-color < 140 )
  
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with prsn dynamics.
  default-colour       ;; as it says
  b-prsn-is-bankrupt   ;; boolean - 0 or 1

  L0-assets            ;; assets of the prsn - logical
  P0-assets            ;; assets of the prsn - physical

  bank-who             ;; bank that holds the loan
  L1-assets            ;; assets in checking accounts
  L1-loan-debts        ;; debts associated with loans
  S1-L1ip-debts        ;; payable on bank loans - debts
  payables-30day       ;; debts to be paid in 30 days
  S1-30day-total-debts ;; sum of 30-day payables
  S1-30day-total-assets ;; sum of 30-day receivables

  L2-assets            ;; assets in savings accounts
  S1-L2ir-assets       ;; interest on savings accounts

  ;; ss L3-corpwho           ;; Holds a bond with this corp
  ;; ss L3-assets            ;; assets in bonds
  ;; ss S1-L3ir-assets ;; receivable on bond

  ;; ss L4-corpwho           ;; Holds a stock with this corp
  ;; ss L4-assets            ;; assets in stocks
  ;; ss L4-dividend-receivable ;; receivable on stocks
  
  ttl-P0-assets        ;; aggregate of all physical assets
  ttl-publ-assets      ;; aggregate of all public assets
  ttl-publ-debts       ;; aggregate of all public debts
  ttl-priv-assets      ;; aggregate of all private assets
  ttl-priv-debts       ;; aggregate of all private debts
  net-worth-publ       ;; total public assets minus debts
  net-worth-priv       ;; total private assets minus debts
  
  ;; Money supply aggregates
  msi-assets        ;; Physical money supply
  msi-debts         ;; Physical money supply
  msii-assets       ;; Logical money supply
  msii-debts        ;; Logical money supply
  msiii-assets      ;; Shadow money supply
  msiii-debts       ;; Shadow money supply
]

;;-----------------------------------------------------------------------------|
;; Attributes of corps (corporate economic agents)
corps-own 
[
  ;; BUILT-IN ATTRIBUTES
  ;; who         ;; fixed id number
  ;; breed       ;; to which breed this turtle belongs [corp]
  ;; heading     ;; 0 <= heading < 360, 0 = north
  ;; xcor        ;; min-pxcor <= xcor < max-pxcor
  ;; ycor        ;; min-pxcor <= xcor < max-pxcor
  ;; size        ;; size relative to a patch, default is 1
  ;; shape       ;; a shape chosen from the shape library
  ;; color       ;; color of this turtle ( 0 <= color < 140 )
  ;; pen-mode    ;; "up" or "down"
  ;; pen-size    ;; in pixels
  ;; hidden?     ;; true or false
  ;; label       ;; label of this turtle
  ;; label-color ;; color of this turtle's label ( 0 <= label-color < 140 )
  
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with corp dynamics.
  default-colour       ;; as it says
  b-corp-is-bankrupt   ;; boolean - 0 or 1

  L0-assets            ;; assets of the corp - logical
  P0-assets            ;; assets of the corp - physical

  bank-who             ;; Does banking with this bank
  L1-assets            ;; assets in checking accounts
  L1-loan-debts        ;; debts associated with loans
  S1-L1ip-debts        ;; payable on bank loans
  payables-30day       ;; debts payable in 30 days
  S1-30day-total-debts ;; sum of 30 day payables
  S1-30day-total-assets ;; sum of 30 day receivables

  L2-assets            ;; assets in savings accounts
  S1-L2ir-assets       ;; interest on savings accounts

  ;; ss no-of-bond-clients   ;; prsns owning bonds
  ;; ss L3-assets            ;; assets in bonds
  ;; ss L3-debts             ;; debts in bonds
  ;; ss S1-L3ip-debts        ;; payable on bond

  ;; ss no-of-stock-clients  ;; prsns owning stocks
  ;; ss L4-assets            ;; assets in stocks
  ;; ss L4-debts             ;; debts in stocks
  ;; ss S1-L4dp-debts  ;; payable-on-stocks
  
  ttl-P0-assets        ;; aggregate of all physical assets
  ttl-publ-assets      ;; aggregate of all public assets
  ttl-publ-debts       ;; aggregate of all public debts
  ttl-priv-assets      ;; aggregate of all private assets
  ttl-priv-debts       ;; aggregate of all private debts
  net-worth-publ       ;; total public assets minus debts
  net-worth-priv       ;; total private assets minus debts
  
  ;; Money supply aggregates
  msi-assets        ;; Physical money supply
  msi-debts         ;; Physical money supply
  msii-assets       ;; Logical money supply
  msii-debts        ;; Logical money supply
  msiii-assets      ;; Shadow money supply
  msiii-debts       ;; Shadow money supply
]

;;-----------------------------------------------------------------------------|
;; SECTION C – INITIALIZATION OR SETUP PROCEDURE( S )
;;-----------------------------------------------------------------------------|

;;-----------------------------------------------------------------------------|
;; The 'autostart' startup routine
to startup
  ;; This routine is to be executed by the observer.

  ;; The manual describes this routine as follows:
  ;; This procedure, if it exists, will be called when a model is first loaded in 
  ;;   the NetLogo application.  Startup does not run when a model is run headless 
  ;;   from the command line, or by parallel BehaviorSpace.

  ;; On loading the model, the debug feature is always off.
  set gb-debug-on 0
  set gs-debug-status "0 (Off)"
  
  ;; On loading the model, the choosers, switches and sliders are
  ;;   always reset to the values that are known to work.  Only the chooser
  ;;   for the scenario is not reset.  The last saved 
  ;;   selection of scenario is persistant.  This allows the 'Reset Defaults'
  ;;   button to NOT reset the scenario.
  f-reset-default-parameters

  ;; Run the setup routine to initialize other globals.
  Setup
  ;; End of startup
end

;;-----------------------------------------------------------------------------|
;; Reset the debug values for the interface-declared items.
to f-reset-debug-parameters 
  ;; The observer executes this routine.

  ;; I only reset here the ones that differ for a debug run.c
  set g-no-of-banks-max           4
  set g-no-of-prsns-per-bank      2
  set g-reserve-requirement-ratio 40
  set g-bankruptcy-factor         1.5

  ;; Run the setup routine to initialize other globals.
  ;; End of f-reset-debug-parameters
end

;;-----------------------------------------------------------------------------|
;; Reset the default values for the interface-declared items.
to f-reset-default-parameters 
  ;; The observer executes this routine.

  ;; Switches, sliders and choosers implicitly declare global variables.  The
  ;;   values in these variables are parameters for the model, and many 
  ;;   combinations of those parameters are not sustainable.  However, the
  ;;   values in those user interface devices are stored with the model and
  ;;   are persistant across a save/load action.  The default values must
  ;;   be reset on load, or available to a user as a parameter set.  The
  ;;   purpose of this routine is to store at least one viable set of 
  ;;   parameter values.
  
  ;; To be clear, variables declared in the interface should be initialized
  ;;   here and not in the setup procedure.  They will be reset on startup
  ;;   (i.e. on load) but not on "Setup".  A separate "Reset" button is on the
  ;;   interface to enable the user to reset these at will.  Any interface-
  ;;   declared variable (as opposed to those declared in the "globals"
  ;;   block) not included here will be persistent through a save/load
  ;;   action.
  
  ;;-----------------------------------------------
  ;; CHOOSERS, SWITCHES AND SLIDERS
  ;;-----------------------------------------------

  ;; Initialize the chooser.
  set gs-scenario "Prsns Only"

  ;; Initialize the Pseudo Random Number Generator (PRNG).
  set g-use-this-seed 7
  
  ;; Interest sliders
  set g-iorr 2
  set g-ioer 1
  set g-iosd 1
  set g-iobl 2
  ;; set g-docs 2
  
  ;; Other startup and operations sliders
  set g-crb-assets-per-prsn       3000
  set g-no-of-banks-max           20
  set g-no-of-prsns-per-bank      20
  set g-no-of-corps-per-bank      1
  set g-net-worth-tax-rate        0.5
  set g-reserve-requirement-ratio 20
  set g-bankruptcy-factor         2
  
  ;; Switches
  set gb-plot-data                true
  set gb-btpfs-bankruptcies       true
  set gb-btpfs-daily-purchases    false
  set gb-btpfs-monthly-taxes      false
  set gb-bank-insurance           true
end

;;-----------------------------------------------------------------------------|
;; The setup button(s)
to setup
  ;; This routine is to be executed by the observer.

  ;; NOTE: The contents of switches, sliders, and choosers seem to be 
  ;;   immune to these 'clear' commands.
  clear-ticks
  clear-turtles
  clear-patches
  clear-drawing
  clear-all-plots
  clear-output
  ;; clear-globals   ;; Suppressed to make gb-debug-on value persistent.
  ;; NOTE: Instead of 'clear-globals', you must ensure all globals are 
  ;;   initialized properly in 'setup'.
  
  ;; import-drawing "01-B OrrSW.jpg"
  
  ;; The version should be coded in this global variable to be included in
  ;;   output files.
  set gs-Version "CmLab_V1.00" 

  ;; Debug features may be off or on depending on history.
  ;;   - Perhaps 'setup' was called by 'to Startup'.
  ;;   - Perhaps 'setup' was called during a 'BehaviorSpace' run.
  ;;   - Perhaps 'setup' was called by a user-pushed 'setup' button.
  ;; Setup needs to handle some quasi-persistant values correctly regardless of
  ;;   the history.  For gb-debug-on, in particular, I want it to be 
  ;;   persistant so I can have debug output from the 'setup' routine routed
  ;;   to the debug log file, or to the command centre.
  
  ;; 'startup' automatically sets gb-debug-on to 0 when the application is first
  ;;   loaded.  I want to be able to (A) toggle debug on, then, (B) press 
  ;;   'setup' and watch the debug output of the 'setup' command.  The gb-debug-on
  ;;   must be persistant through the above 'clear' commands.  The debug log 
  ;;   file name and status, however, should not be persistent and must be 
  ;;   reset when setup runs, if appropriate.
  ifelse ( gb-debug-on = 1 )
  [
    ;; Debug is on due to user setting, so file name and status should be 
    ;;   reset.  I do this by turn the feature off then on.
    ;; First toggle it off, closing any remnant log file, if needed.
    f-toggle-debug
    ;; Then toggle it back on, opening a new time-stamped log file.
    f-toggle-debug
  ]
  ;; else
  [
    ;; Debug is off, possibly due to startup execution, possibly due to user 
    ;;   choice.
    ;; Ensure associated variables have compatible settings.
    set gb-debug-on 0              ;; Redundant but ensures consistency.
    set gs-debug-status "0 (Off)"  ;; Redundant but ensures consistency.
    set gb-debug-flow-on 0         ;; Step-specific flow is off.
    file-close-all                 ;; Close the debug log file.
    set gs-log-file-name "dummyname"
  ]
  
  ;; Now, do the standard check that is done at the start of each debuggable 
  ;;   routine.  This must follow the clear commands, which reset everything 
  ;;   except globals, switches, sliders and choosers.
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "setup" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-setup: Debug on; tick = " 0 ]
    [ set gb-debug-flow-on 0 ]
  ]

  ;; g-use-this-seed comes from a slider, and is persistant.
  random-seed g-use-this-seed      ;; Tells the PRNG to use this seed.
  
  ;; Override the scenario chooser.
  set gs-scenario "Prsns Only"
  f-set-scenario-number

  ;; SETUP FOR CONSERVEMONEYLAB
  LOG-TO-FILE ( "  INTEREST RATES (Sliders):" )
  LOG-TO-FILE ( word  "  Int. on Required Reserves --- " g-iorr " %" )
  LOG-TO-FILE ( word  "  Int. on Excess Reserves ----- " g-ioer " %" )
  LOG-TO-FILE ( word  "  Int. on Savings Deposits ---- " g-iosd " %" )
  LOG-TO-FILE ( word  "  Int. on Bank Loans ---------- " g-iobl " %" )
  ;; LOG-TO-FILE ( word  "  Dividends on Corp Stocks ---- " g-docs " %" )

  LOG-TO-FILE ( "  OTHER GLOBALS" )
  LOG-TO-FILE ( word  "  g-crb-assets-per-prsn ------- " g-crb-assets-per-prsn )
  LOG-TO-FILE ( word  "  g-no-of-banks-max ----------- " g-no-of-banks-max )
  LOG-TO-FILE ( word  "  g-no-of-prsns-per-bank ------ " g-no-of-prsns-per-bank )
    
  ;; TODO: Remove this when slider is replaced.
  set g-no-of-corps-per-bank      1
  LOG-TO-FILE ( word  "  g-no-of-corps-per-bank ------ " g-no-of-corps-per-bank )
  LOG-TO-FILE ( word  "  g-net-worth-tax-rate -------- " g-net-worth-tax-rate " %" )
  LOG-TO-FILE ( word  "  g-reserve-requirement-ratio - " g-reserve-requirement-ratio " %" )
  
  set g-no-of-banks ( count banks )
  set g-no-of-prsns-max ( g-no-of-banks-max * g-no-of-prsns-per-bank )
  set g-no-of-prsns ( count prsns )
  set g-no-of-corps ( g-no-of-banks-max * g-no-of-corps-per-bank )
  set g-p-daily-cost-of-living round( g-crb-assets-per-prsn / 30 ) ;; 30 days per month
  set g-p-daily-L0-allocation round( g-p-daily-cost-of-living / 4 )
  set g-p-daily-L1-allocation ( g-p-daily-cost-of-living - g-p-daily-L0-allocation )
  set g-p-standard-loan ( g-p-daily-cost-of-living * 64 ) ;; 60+4; Used to set up loans.
  set g-p-standard-loan-payment ( g-p-standard-loan / 8 ) ;; Used to pay principal on loans.
  
  ;; TODO: The minimum vault cash must increase when corps are activated.  
  ;;   Used to manage reserves
  set g-minimum-vault-cash ( g-p-daily-L0-allocation * g-no-of-prsns-per-bank ) 

  LOG-TO-FILE ( word  "  g-no-of-banks-max ----------- " g-no-of-banks-max )
  LOG-TO-FILE ( word  "  g-no-of-banks --------------- " g-no-of-banks )
  LOG-TO-FILE ( word  "  g-no-of-prsns-max ----------- " g-no-of-prsns-max )
  LOG-TO-FILE ( word  "  g-no-of-prsns --------------- " g-no-of-prsns )
  LOG-TO-FILE ( word  "  g-no-of-corps-max ----------- " g-no-of-corps-max )
  LOG-TO-FILE ( word  "  g-no-of-corps --------------- " g-no-of-corps )
  LOG-TO-FILE ( word  "  g-p-daily-cost-of-living ---- " g-p-daily-cost-of-living )
  LOG-TO-FILE ( word  "  g-p-daily-L0-allocation ----- " g-p-daily-L0-allocation )
  LOG-TO-FILE ( word  "  g-p-daily-L1-allocation ----- " g-p-daily-L1-allocation )
  LOG-TO-FILE ( word  "  g-p-standard-loan ----------- " g-p-standard-loan )
  LOG-TO-FILE ( word  "  g-p-standard-loan-payment --- " g-p-standard-loan-payment )
  LOG-TO-FILE ( word  "  g-minimum-vault-cash -------- " g-minimum-vault-cash )
  LOG-TO-FILE ( word  "  g-bankruptcy-factor --------- " g-bankruptcy-factor )

  LOG-TO-FILE ( word  "  gb-plot-data ---------------- " gb-plot-data )
  LOG-TO-FILE ( word  "  gb-bank-insurance ----------- " gb-bank-insurance )
  LOG-TO-FILE ( word  "  gb-btpfs-bankruptcies ------- " gb-btpfs-bankruptcies )
  LOG-TO-FILE ( word  "  gb-btpfs-daily-purchases ---- " gb-btpfs-daily-purchases )
  LOG-TO-FILE ( word  "  gb-btpfs-monthly-taxes ------ " gb-btpfs-monthly-taxes )

  ;; END OF SETUP FOR CONSERVEMONEYLAB
  

  ;; There are 2 scenarios possible
  set ge-scenario-with-prsns  0  ;; Prsns are active
  set ge-scenario-with-corps  1  ;; Corps are active

  ;; Use the input from the chooser gs-scenario to invoke the selected scenario.
  f-set-scenario-number
  
  ;; For debugging the setup procedure, log the values of the globals.
  LOG-TO-FILE ( word "  Scenario number ------------- " g-scenario-number ) 
  LOG-TO-FILE ( word "  Scenario name --------------- " gs-scenario )
  LOG-TO-FILE ( word "  Random seed ----------------- " g-use-this-seed )

  ;; For debugging the debug feature!!!
  LOG-TO-FILE ( word "SETUP: Debug Is --------------- " gb-debug-on )
  LOG-TO-FILE ( word "SETUP: Debug Status Is -------- " gs-debug-status )
  LOG-TO-FILE ( word "SETUP: Step Chooser Is -------- " gs-debug-step-chooser )
  LOG-TO-FILE ( word "SETUP: Flow Control Is -------- " gb-debug-flow-on )

  ask patches 
  [ 
    set pcolor brown
  ]
  
  set g-agents-nw-xaxis-min 0
  set g-agents-nw-xaxis-max 1000 
  set g-prsns-nw-xaxis-min  0
  set g-prsns-nw-xaxis-max  1000 
  set g-banks-nw-xaxis-min  0
  set g-banks-nw-xaxis-max  1000 
  set g-banks-P0-xaxis-min  0
  set g-banks-P0-xaxis-max  1000 
  set g-banks-P0-all-assets-min  0    ;; Minimum value on P0-all-assets.
  set g-banks-P0-all-assets-mean 500  ;; Mean value on P0-all-assets.
  set g-banks-P0-all-assets-max  1000 ;; Max value on P0-all-assets.

  set g-counts-loans        0
  set g-counts-p-deaths     0
  set g-counts-p-births     0
  set g-counts-b-deaths     0
  set g-counts-b-births     0
  
  reset-ticks      ;; restarts tick counter and runs setup commands within plots

  ;; Set the switches to default setup values.
  set gb-plot-data            true ;; Enables all plotting calls.
  set gb-bank-insurance       true ;; Default insurance is on.

  if( g-scenario-number = ge-scenario-with-prsns )
  [
    set gb-plot-data            true ;; Enables all plotting calls.
  ]
  if( g-scenario-number = ge-scenario-with-corps )
  [
    set gb-plot-data            true ;; Enables all plotting calls.
  ]
  
  ;; Initalization of CmLab Turtles
  set-default-shape GCRAs  "triangle"   ;; pulled from shapes library
  set-default-shape CRBs   "triangle"   ;; pulled from shapes library
  set-default-shape banks  "target"     ;; pulled from shapes library
  set-default-shape prsns  "truck"      ;; pulled from shapes library
  set-default-shape corps  "house"      ;; pulled from shapes library
  f-initialize-basic-scenario

  ;; Do the bank visits to arrange deposits.
  f-everybody-visits-their-bank
  ;; Then update the net worth statements and global aggregates.
  ;; This call requires that 'reset-ticks' be called first.
  f-update-aggregates  ;; Totals and averages.

  ;; TODO: suppress or remove after debug.
  f-dump-all-agent-data
  
  ;; Clears unwanted zeros in plots.
  clear-all-plots
  setup-plots
  
  ;; Debug controls
  set gb-debug-flow-on 0 ;; Boolean, in association with chooser, turns debug LOG-TO-FILE on/off
  set g-halt-at-tick -1  ;; input variable to set a tick for stopping

  ;; ASSERT ( frb-EMgr-is-valid ) ( "EMgr validity check: D-Setup" ) -1
  LOG-TO-FILE "  Do-Setup: procedure completed" 

  ;; end of to setup
end

;;-----------------------------------------------------------------------------|
;; Set the scenario number using the input from the chooser.
to f-set-scenario-number
  ;; This routine is to be executed by the observer.

  set g-scenario-number ge-scenario-with-prsns  ;; default
  ;; if( gs-scenario = "Corps Not Implemented Yet" )
  ;;   [ set g-scenario-number ge-scenario-with-corps ]
  set gs-scenario "Prsns Only"

  ;; End f-set-scenario-number
end

;;-----------------------------------------------------------------------------|
;; Initialize a GCRA, CRB, banks, corps and prsns.
to f-initialize-basic-scenario
  ;; This routine is to be executed by the observer.

  ;; NOTE: the order of initialization is critical since there are links 
  ;;   established between them, once appropriate linkable agents are created.
  
  ;; Initialize a GCRA.  (Government Consolidated Revenue Account)
  create-gcras 1 
  [ 
    f-initialize-gcra
    setxy 0 0
  ]
  ;; Note: bank-who not set yet.

  ;; Initialize a CRB.   (Central Reserve Bank)
  create-crbs 1 
  [ 
    f-initialize-crb
    ;; Move to a random point.
    setxy 0 1
  ]
  ;; Note: bank-who not set yet.

  ;; Initialize the banks.
  create-banks g-no-of-banks-max 
  [ 
    set g-counts-b-births ( g-counts-b-births + 1 )
    f-initialize-new-bank 
    ;; Move to a random point.
    setxy random-xcor random-ycor
  ]
  set g-no-of-banks ( count banks )
  ;; Move P0-assets to VC, ER and RR deposits, as appropriate.
  f-the-crb-reconciles-with-banks-daily

  ;; Assign a bank to the GCRA
  ask gcras [ f-bsvcs-gcra-find-bank ]
  ;; Assign a bank to the CRB
  ask crbs [ f-bsvcs-crb-find-bank ]
  
  ;; Initialize the prsns.
  ;; Must do banks and corps first, then link prsns to both.
  create-prsns g-no-of-prsns-max 
  [ 
    set g-counts-p-births ( g-counts-p-births + 1 )
    f-initialize-new-prsn 
    set heading 90
    ;; Move to a random point.
    setxy random-xcor random-ycor
  ]
  set g-no-of-prsns ( count prsns )

  ;; Initialize the corps.
  ;; Must do banks first, then link corps to banks.
  ;; TODO: Initialization of corps suppressed.
  ;; create-corps g-no-of-corps 
  ;; [ 
  ;;   set g-counts-c-births ( g-counts-c-births + 1 )
  ;;   f-initialize-new-corp 
  ;;   ;; Move to a random point.
  ;;   setxy random-xcor random-ycor
  ;; ]

  ;; The initial endowment of cash must be distributed.
  ask crbs
  [
    f-cbsvcs-distribute-assets-to-prsns
    ;; TODO: When corps implemented, include here.
  ]
  
  ;; End f-initialize-basic-scenario
end

;;-----------------------------------------------------------------------------|
;; Initialize a single GCRA.
to f-initialize-gcra
  ;; This routine is to be executed by a GCRA.
  ;; I.e. government consolidated revenue account.
  set heading 0  ;; direction of motion
  set color black

  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with GCRA dynamics.
  set default-colour      black              ;; distinctive colour for GCRA
  set bank-who           -1                  ;; bank that holds the loan
  set L1-assets           0                  ;; standard checking account
  set L1-loan-debts       0                  ;; debts associated with loan
  set S1-L1ip-debts       0                  ;; payable on loans

  ;; TODO: If these are not used, remove them.
  ;; xx set L2-assets           0                  ;; standard savings account

  ;; ss set L3-debts            0                  ;; bonds
  ;; ss set S1-L3ip-debts       0                  ;; payable on bonds

  LOG-TO-FILE ( word "  Initialize GCRA " who )
  LOG-TO-FILE ( word "  L1-assets ------------------- " L1-assets )
  LOG-TO-FILE ( word "  L1-loan-debts --------------- " L1-loan-debts )
  LOG-TO-FILE ( word "  S1-L1ip-debts --------------- " S1-L1ip-debts )
  ;; xx LOG-TO-FILE ( word "  L2-assets ------------------- " L2-assets )
  ;; ss LOG-TO-FILE ( word "  L3-debts -------------------- " L3-debts )
  ;; ss LOG-TO-FILE ( word "  S1-L3ip-debts -------- " S1-L3ip-debts )

  set ttl-P0-assets     0 ;; aggregate of all physical assets
  set ttl-publ-assets   0 ;; aggregate of all public assets
  set ttl-publ-debts    0 ;; aggregate of all public debts
  set ttl-priv-assets   0 ;; aggregate of all private assets
  set ttl-priv-debts    0 ;; aggregate of all private debts
  set net-worth-publ    0 ;; total public assets minus debts
  set net-worth-priv    0 ;; total private assets minus debts
  
  ;; Money supply aggregates
  set msi-assets        0 ;; Physical money supply
  set msi-debts         0 ;; Physical money supply
  set msii-assets       0 ;; Logical money supply
  set msii-debts        0 ;; Logical money supply
  set msiii-assets      0 ;; Shadow money supply
  set msiii-debts       0 ;; Shadow money supply
  
  ;; Suppressed.  Done after all banks initialized.
  ;; f-bsvcs-gcra-find-bank ;; sets bank-who to a valid number
  
  ;; end f-initialize-gcra
end

;;-----------------------------------------------------------------------------|
;; Initialize a single CRB.
to f-initialize-crb
  ;; This routine is to be executed by a CRB.
  ;; I.e. central reserve bank.
  set heading 0  ;; direction of motion
  set color yellow

  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with CRB dynamics.
  set default-colour      yellow  ;; distinctive colour for CRB
  ;; TODO: Change when corps activated.
  
  ;; The functional values of the assets are set in 
  ;;   the routine f-cbsvcs-distribute-assets-to-prsns
  set P0-assets           0
  set P0-debts            0 ;; initial physcial debts on start
  set L0-assets           0 ;; initial logical assets on start
  set L0-debts            0 ;; initial logical debts on start

  set P0-rr-assets        0 ;; required reserves
  set P0-er-assets        0 ;; excess reserves

  set bank-who           -1 ;; chartered bank for C1 account
  set S1-rrip-debts       0 ;; interest payable on required reserves
  set S1-erip-debts       0 ;; interest payable on excess reserves
  set C1-assets           0 ;; corporate bank assets
  ;; xx set c2-assets           0 ;; corporate bank assets

  LOG-TO-FILE ( word "  Initialize CRB " who )
  LOG-TO-FILE ( word "  CRB MS-I P0 Assets ----------- " P0-assets )
  LOG-TO-FILE ( word "  CRB MS-I F0 Assets ----------- " L0-assets )
  LOG-TO-FILE ( word "  CRB MS-I P0 debts ------------ " P0-debts )
  LOG-TO-FILE ( word "  CRB MS-I F0 debts ------------ " L0-debts )
  LOG-TO-FILE ( word "  CRB Required reserves -------- " P0-rr-assets )
  LOG-TO-FILE ( word "  S1-rrip-debts ---------------- " S1-rrip-debts )
  LOG-TO-FILE ( word "  CRB Excess reserves ---------- " P0-er-assets )
  LOG-TO-FILE ( word "  S1-erip-debts ---------------- " S1-erip-debts )

  set ttl-P0-assets     0 ;; aggregate of all physical assets
  set ttl-publ-assets   0 ;; aggregate of all public assets
  set ttl-publ-debts    0 ;; aggregate of all public debts
  set ttl-priv-assets   0 ;; aggregate of all private assets
  set ttl-priv-debts    0 ;; aggregate of all private debts
  set net-worth-publ    0 ;; total public assets minus debts
  set net-worth-priv    0 ;; total private assets minus debts
  
  ;; Money supply aggregates
  set msi-assets        0 ;; Physical money supply
  set msi-debts         0 ;; Physical money supply
  set msii-assets       0 ;; Logical money supply
  set msii-debts        0 ;; Logical money supply
  set msiii-assets      0 ;; Shadow money supply
  set msiii-debts       0 ;; Shadow money supply
  
  ;; Suppressed.  Done after all banks initialized.
  ;; f-bsvcs-crb-find-bank ;; sets bank-who to a valid number
  
  ;; end f-initialize-crb
end

;;-----------------------------------------------------------------------------|
;; Initialize a single bank.
to f-initialize-new-bank
  ;; This routine is to be executed by a bank.

  ;; BUILT-IN ATTRIBUTES
  set heading 0  ;; direction of motion
  set color red

  LOG-TO-FILE ( word "  Initialize bank " who )
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with bank dynamics.
  set default-colour       red  ;; distinctive colour for banks
  set b-bank-can-make-loans  1  ;; boolean - 0 or 1
  set b-bank-is-bankrupt     0  ;; boolean - 0 or 1

  set L1-assets              0
  set L1-loan-assets         0
  set L1-debts               0
  set S1-L1ir-assets         0
  
  set L2-assets              0
  set L2-debts               0
  set S1-L2ip-debts          0
  
  ;; xx set L3-assets              0
  
  ;; There is only one CRB, but the breed must be treated as a set.
  set crb-who ( [who] of ( one-of crbs ) )

  set P0-vc-assets           0
  set P0-er-assets           0
  set P0-er-debts            0
  set P0-rr-assets           0
  set P0-rr-debts            0
  set P0-all-assets          0
  
  ;; Associated with corporate bank dynamics.
  set no-of-prsn-clients     0
  set no-of-corp-clients     0
  set no-of-gcra-clients     0
  set no-of-crb-clients      0
  set S1-rrir-assets         0  ;; interest on required reserves
  set S1-erir-assets         0  ;; interest on excess reserves
  set C1-assets              0  ;; corporate bank equivalent of L1-assets
  ;; xx set c2-assets           0  ;; corporate bank equivalent of L2-assets

  set ttl-P0-assets     0 ;; aggregate of all physical assets
  set ttl-publ-assets   0 ;; aggregate of all public assets
  set ttl-publ-debts    0 ;; aggregate of all public debts
  set ttl-priv-assets   0 ;; aggregate of all private assets
  set ttl-priv-debts    0 ;; aggregate of all private debts
  set net-worth-publ    0 ;; total public assets minus debts
  set net-worth-priv    0 ;; total private assets minus debts
  
  ;; Money supply aggregates
  set msi-assets        0 ;; Physical money supply
  set msi-debts         0 ;; Physical money supply
  set msii-assets       0 ;; Logical money supply
  set msii-debts        0 ;; Logical money supply
  set msiii-assets      0 ;; Shadow money supply
  set msiii-debts       0 ;; Shadow money supply
  
  ;; end f-initialize-new-bank
end

;;-----------------------------------------------------------------------------|
;; Initialize a single prsn.
to f-initialize-new-prsn
  ;; This routine is to be executed by a prsn.

  ;; BUILT-IN ATTRIBUTES
  set heading 0  ;; direction of motion
  set color green

  LOG-TO-FILE ( word "  Initialize prsn " who )
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with prsn dynamics.
  set default-colour    green ;; distinctive colour for prsns
  set b-prsn-is-bankrupt   0 ;; boolean - 0 or 1

  set P0-assets            0
  set L0-assets            0

  set bank-who             -1  ;; Does banking with this bank.
  set L1-assets             0
  set L1-loan-debts         0   
  set S1-L1ip-debts         0 ;; payable on bank loans
  set payables-30day       []  ;; A list of 30-day payables
  set S1-30day-total-debts  0  ;; sum of 30 day payables
  set S1-30day-total-assets 0  ;; sum of 30 day receivables

  set L2-assets             0

  ;; ss set L3-corpwho       -1    ;; Holds bond from this corp.
  ;; ss set L3-assets         0

  ;; ss set L4-corpwho       -1    ;; Holds stock from this corp.
  ;; ss set L4-assets         0

  set ttl-P0-assets     0 ;; aggregate of all physical assets
  set ttl-publ-assets   0 ;; aggregate of all public assets
  set ttl-publ-debts    0 ;; aggregate of all public debts
  set ttl-priv-assets   0 ;; aggregate of all private assets
  set ttl-priv-debts    0 ;; aggregate of all private debts
  set net-worth-publ    0 ;; total public assets minus debts
  set net-worth-priv    0 ;; total private assets minus debts
  
  ;; Money supply aggregates
  set msi-assets        0 ;; Physical money supply
  set msi-debts         0 ;; Physical money supply
  set msii-assets       0 ;; Logical money supply
  set msii-debts        0 ;; Logical money supply
  set msiii-assets      0 ;; Shadow money supply
  set msiii-debts       0 ;; Shadow money supply
  
  f-bsvcs-prsn-find-bank  ;; Assign a bank to this prsn.
  ;; end f-initialize-new-prsn
end

;;-----------------------------------------------------------------------------|
;; Initialize a single corp.
to f-initialize-new-corp
  ;; This routine is to be executed by a corp.

  ;; BUILT-IN ATTRIBUTES
  set heading 0  ;; direction of motion
  set color black

  LOG-TO-FILE ( word "  Initialize corp " who )
  ;; USER-DETERMINED ATTRIBUTES
  ;; Associated with corp dynamics.
  set default-colour   black ;; distinctive colour for corps
  set b-corp-is-bankrupt   0 ;; boolean - 0 or 1

  set P0-assets            0
  set L0-assets            0

  set bank-who             -1 ;; Does banking with this bank.
  set L1-assets            0
  set L1-loan-debts        0
  set S1-L1ip-debts        0 ;; payable on bank loans
  set payables-30day      []
  set S1-30day-total-debts 0
  set S1-30day-total-assets 0

  set L2-assets            0
  set S1-L2ir-assets       0 ;; receivable on savings

  ;; ss set no-of-bond-clients  0 ;; prsns holding bonds
  ;; ss set L3-assets           0
  ;; ss set L3-debts            0

  ;; ss set no-of-stock-clients 0 ;; prsns holding stocks
  ;; ss set L4-assets           0
  ;; ss set L4-debts            0

  set ttl-P0-assets     0 ;; aggregate of all physical assets
  set ttl-publ-assets   0 ;; aggregate of all public assets
  set ttl-publ-debts    0 ;; aggregate of all public debts
  set ttl-priv-assets   0 ;; aggregate of all private assets
  set ttl-priv-debts    0 ;; aggregate of all private debts
  set net-worth-publ    0 ;; total public assets minus debts
  set net-worth-priv    0 ;; total private assets minus debts
  
  ;; Money supply aggregates
  set msi-assets        0 ;; Physical money supply
  set msi-debts         0 ;; Physical money supply
  set msii-assets       0 ;; Logical money supply
  set msii-debts        0 ;; Logical money supply
  set msiii-assets      0 ;; Shadow money supply
  set msiii-debts       0 ;; Shadow money supply
  
  f-bsvcs-corp-find-bank ;; Assign a bank to this corp.
  ;; end f-initialize-new-corp
end

;;-----------------------------------------------------------------------------|
;; SECTION D – GO OR MAIN-LOOP PROCEDURE( S )
;;-----------------------------------------------------------------------------|

;;-----------------------------------------------------------------------------|
;; The go button
to go
  ;; This routine is to be executed by the observer.

  ;; Stop codes:
  ;; All stop decisions must be here in the 'go' procedure, as it causes an
  ;;   exit from the current procedure only.

  if( g-halt-at-tick = ticks  ) 
  [
    set g-halt-at-tick -1
    stop
  ]
  
  ;; Ensure that the gb-btpfs-bankruptcies flag is always on.
  set gb-btpfs-bankruptcies true
  
  ;; MANUAL CHANGE FOR DEBUG
  ;; If needed, each check for validity can be enabled between steps.
  ;; They have been suppressed (turned into comments) for the sake 
  ;;   of speed of execution, but can be re-enabled if a bug has 
  ;;   somehow been re-introduced.
  ;; A single call to the validity check has been left active inside of the
  ;;   Do-Post-Tick step.  If it flags a problem, re-activate these to
  ;;   narrow down where the problem starts.
  
  ;; Major steps or functions, done once per tick, in order of execution.
  do-pre-tick
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-pre-tick." ) ]

  do-move
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-move." ) ]

  do-buy-sell
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-buy-sell." ) ]

  do-accrue-interest
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-accrue-interest." ) ]

  do-monthly
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-monthly." ) ]

  do-banking
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-banking." ) ]

  do-post-tick
  ;; if( frb-agents-are-all-valid = false ) 
  ;;   [ LOG-TO-FILE ( word "Agents failed validity test: Do-post-tick." ) ]

  ;; end of go
end

;;-----------------------------------------------------------------------------|
;; D1 - do-pre-tick procedure( s )
;;-----------------------------------------------------------------------------|
to do-pre-tick
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "pre-tick" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-pre-tick: Debug on.; tick was " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; Enter all commands that need to be done before a tick begins.
  ;; f-update-aggregates
  
  ;; Override the scenario chooser.
  set gs-scenario "Prsns Only"
  f-set-scenario-number

  ;; Advance the tick counter by 1 tick.
  ifelse( gb-plot-data = true )
  [
    ;; Advance the ticks by one and update the plots.
    tick
    ;; 'tick' is exactly the same as 'update-plots' except that the tick counter 
    ;;   is incremented before the plot commands are executed.
    
  ]
  ;; else
  [
    ;; Advance ticks by one but do not update the plots.
    tick-advance 1
  ]
  ;; End else

  ;; Once the data is plotted, the per-tick counts can be cleared.
  ;; TODO: Clear such data collection per-tick aggregates here.
  
  ;; Reset the scenario number, in case the chooser has been changed.
  f-set-scenario-number
  
  LOG-TO-FILE ( word "  Halt at tick - " g-halt-at-tick  ) 
  LOG-TO-FILE ( word "  Current tick - " ticks ) 

  LOG-TO-FILE "  Do-pre-tick: Routine completed."
;; end of Do-pre-tick
end

;;-----------------------------------------------------------------------------|
;; D2 – do-move procedure(s)
;;-----------------------------------------------------------------------------|
to do-move
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "move" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-move: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; Implement 'arrow' behaviour from PSoup application.  I.e. a strong 
  ;;   probability of movement directly forward, and small probability of a 
  ;;   slight turn.  This represents the most effective search pattern for
  ;;   an arena that is wrapped on all sides.  Of course, it doesn't matter 
  ;;   since they don't actually feed.
  
  let heading-list [ -1 0 0 0 0 0 0 0 0 0 1 ]

  ;; The prsns move.  'Arrow' search pattern.
  ask prsns
  [
    let delta-heading ( item ( random length heading-list ) heading-list )
    set heading ( heading + delta-heading )
    if( heading > 115 ) [ set heading 115 ]
    if( heading <  65 ) [ set heading  65 ]
    forward 1
  ]  ;; End ask prsns

  ;; f-update-aggregates

  LOG-TO-FILE "  Do-move: procedure completed"
;; end of Do-move
end

;;-----------------------------------------------------------------------------|
;; D3 – do-buy-sell procedure(s)
;;-----------------------------------------------------------------------------|
to do-buy-sell
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "buy-sell" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-buy-sell: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; Each tick the prsns are paired as (buyer, seller) for cash transactions.
  f-prsns-buy-sell-using-cash

  ;; Each tick the banks buy using checks on their C1 accounts.
  f-btpfs-banks-buy-using-checks

  ;; Each tick the prsns are re-paired as (buyer, seller) on 30-day terms.
  f-prsns-buy-sell-on-terms
  
  ;; Each tick each prsn then pays those bills that are 30 days old or more.
  f-process-30-day-payables
  ;; TODO: When corps implemented, this needs to be added for them too.
  
  f-update-aggregates

  LOG-TO-FILE "  Do-buy-sell: procedure completed"
  
;; end of Do-buy-sell
end

;;-----------------------------------------------------------------------------|
;; Prsns buy and sell, using cash.
to f-prsns-buy-sell-using-cash
;; This routine is to be executed by the observer.

  ;; Prsns buy and sell using cash.
  ;; Each tick the prsns are paired as (buyer, seller) for cash transactions.
  LOG-TO-FILE ( word "" )
  LOG-TO-FILE ( word "Do-buy-sell: cash" )

  ;; Make a list.
  let mylist []
  ask prsns 
  [
    set mylist lput self mylist 
  ]
  
  let no-of-prsns-left ( length mylist )
  ;; LOG-TO-FILE ( word "  Do-buy-sell: no-of-prsns-left " no-of-prsns-left )
  
  while [ no-of-prsns-left > 1 ]
  [
    ;; Isolate the first two prsns.
    let buyer ( item 0 mylist )
    set mylist ( but-first mylist )
    let seller ( item 0 mylist )
    set mylist ( but-first mylist )
    set no-of-prsns-left ( length mylist )
    
    let buyer-who ( [who] of buyer )
    let seller-who ( [who] of seller )
    
    ask buyer
    [
      ;; Buyer transfers cash (P0+L0) to seller.
      ;; This is a similar technique to Yakovenko's capital exchange models.
      ;; Dragulescu and Yakovenko, 2000.
      let amount-to-spend ( 1 + ( random ( g-p-daily-L0-allocation - 1 ) ) )
      LOG-TO-FILE ( word "Buyer: " buyer-who "; Seller: " seller-who )
      LOG-TO-FILE ( word "  L0-assets of buyer ------------------ " L0-assets )
      LOG-TO-FILE ( word "  L0-assets of seller ----------------- " ( [L0-assets] of seller ) )
      LOG-TO-FILE ( word "  L0 cost of purchase ----------------- " amount-to-spend )
      
      f-bsvcs-prsn1-pays-prsn2-by-cash seller-who amount-to-spend
      
      LOG-TO-FILE ( word "  L0-assets of buyer ------------------ " L0-assets )
      LOG-TO-FILE ( word "  L0-assets of seller ----------------- " ( [L0-assets] of seller ) )
    ]
  ]
  
;; end of f-prsns-buy-sell-using-cash
end

;;-----------------------------------------------------------------------------|
;; Prsns buy and sell, on 30-day terms.
to f-prsns-buy-sell-on-terms
;; This routine is to be executed by the observer.

  ;; THEORY: Prsns buy and sell, paying by check after 30 days.
  ;; Each tick the prsns are randomly paired as (buyer, seller) on 30-day terms.
  LOG-TO-FILE ( word "  " )
  LOG-TO-FILE ( word "Do-buy-sell: 30-day terms" )

  ;; Make a list of prsns other than me.
  let mylist []
  ask other prsns ;; excludes me
  [
    ;; Add themself to my list of prsns.
    set mylist lput self mylist 
  ]
  
  let no-of-prsns-left ( length mylist )
  ;; LOG-TO-FILE ( word "  Do-buy-sell: no-of-prsns-left " no-of-prsns-left )
  while [ no-of-prsns-left > 1 ]
  [
    ;; Isolate the first two prsns.
    let buyer  ( item 0 mylist )
    set mylist ( but-first mylist )
    let seller ( item 0 mylist )
    set mylist ( but-first mylist )
    set no-of-prsns-left ( length mylist )
    
    let buyer-who ( [who] of buyer )
    let seller-who ( [who] of seller )
    
    ask buyer
    [
      ;; THEORY:  This is totally happening in the shadow money supply, and 
      ;;   no bank of any kind is involved.  So, there is no "banking services"
      ;;   routine (i.e. one with -bsvcs- in the name) to handle this.  It is
      ;;   coded in detail here.
      
      ;; Buyer puts purchase on a 30-day tab.
      ;; This puts the purchase into the MS-III money supply.
      let amount-to-spend ( 1 + ( random ( g-p-daily-L1-allocation - 1 ) ) )

      ;; Buyer spends expecting to pay by check in 30 days.
      ;; Buyer does not/cannot check for future solvency.
      ;; This must be paid 30 ticks from now.
      LOG-TO-FILE ( word "Buyer: " buyer-who "; Seller: " seller-who )
      LOG-TO-FILE ( word "  30day payables of buyer ------------- " S1-30day-total-debts )
      LOG-TO-FILE ( word "  30day receivables of seller --------- " ( [S1-30day-total-assets] of seller ) )
      set S1-30day-total-debts ( S1-30day-total-debts + amount-to-spend )
      ask seller [ set S1-30day-total-assets ( S1-30day-total-assets + amount-to-spend ) ]
      let payable ( list ( [who] of seller ) ( ticks + 30 ) amount-to-spend )
      set payables-30day lput payable payables-30day
      LOG-TO-FILE ( word "  This purchase [sllr, tick due, amt] - " payable )
      LOG-TO-FILE ( word "  30day payables of buyer ------------- " S1-30day-total-debts )
      LOG-TO-FILE ( word "  30day receivables of seller --------- " ( [S1-30day-total-assets] of seller ) )
    ]
  ]

;; end of f-prsns-buy-sell-on-terms
end

;;-----------------------------------------------------------------------------|
;; Corps buy and sell, using cash and on 30-day terms.
to f-corps-buy-sell
;; This routine is to be executed by the observer.

;; TODO: Not implemented yet.

;; end of f-corps-buy-sell
end

;;-----------------------------------------------------------------------------|
;; Process 30-day payables.
to f-process-30-day-payables
;; This routine is to be executed by the observer.

  ;; THEORY:  This is a connection between the shadow and the logical 
  ;;   money supplies.  The payables and receivables that were not in bank 
  ;;   records are now paid by checks and a -bsvcs- routine, and they become 
  ;;   visible to the banks and their back room accountants.
  
  ;;  All prsns may have 30-day payables.
  ask prsns
  [
    ;; If there are no payables, nothing need be done my this prsn.
    ;; TODO: For performance, add boolean to determine if payables are due 
    ;;   this tick.
    if( S1-30day-total-debts > 0 )
    [
      ;; I used lput to put the payables into a list.  So I should be able to 
      ;;   pull them off of the front until those that are payable this tick
      ;;   have been looked after.
      
      let this-payable ( item 0 payables-30day )
      let seller-who item 0 this-payable
      let tick-when-due item 1 this-payable
      let this-amount item 2 this-payable

      if( tick-when-due <= ticks )
      [
        LOG-TO-FILE ( word "  " )
        LOG-TO-FILE ( word "PRSN " who " processing 30-day payables" )
      ]
      
      while [ tick-when-due <= ticks ]
      [
        let seller ( prsn seller-who )
        LOG-TO-FILE ( word "  This payable ---------------- " this-payable )
        LOG-TO-FILE ( word "  Seller ---------------------- " seller-who )
        LOG-TO-FILE ( word "  Tick-when-due --------------- " tick-when-due "; now - " ticks )
        LOG-TO-FILE ( word "  Seller's assets were -------- " ( [L1-assets] of seller ) )
        LOG-TO-FILE ( word "  Buyer's assets were --------- " L1-assets )
        LOG-TO-FILE ( word "  Amount due ------------------ " this-amount )
        f-bsvcs-prsn1-pays-prsn2-by-check seller-who this-amount
        LOG-TO-FILE ( word "  Seller's assets are --------- " ( [L1-assets] of seller ) )
        LOG-TO-FILE ( word "  Buyer's assets are ---------- " L1-assets )
        
        ;; Update the aggregator of the buyer.
        set S1-30day-total-debts ( S1-30day-total-debts - this-amount )
        ;; Update the aggregator of the seller.
        ask seller [ set S1-30day-total-assets 
          ( S1-30day-total-assets - this-amount ) ]

        ;; The first payable in list is done.  Drop from list.
        set payables-30day ( but-first payables-30day ) 
        ;; Check if there are any more.
        ifelse( 0 = length payables-30day )
        [
          set tick-when-due ( ticks + 1 )  ;; Create end condition.
        ]
        ;; Else
        [
          ;; Unpack the next payable.
          set this-payable ( item 0 payables-30day )
          set seller-who item 0 this-payable
          set tick-when-due item 1 this-payable
          set this-amount item 2 this-payable
        ]
      ] 
    ]
    
  ]
;;  end of f-process-30-day-payables
end

;;-----------------------------------------------------------------------------|
;; D4 – do-accrue-interest procedure(s)
;;-----------------------------------------------------------------------------|
to do-accrue-interest
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "accrue-interest" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-accrue-interest: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; TODO: Corps and GCRA do not presently take out L1 loans, or make savings
  ;;   deposits, so some of this code is anticipating that change.  When those
  ;;   things are added, walk through this again.
  
  ;; There are six kinds of interest that must be accrued, and paid monthly.
  ;;   - interest on L1 bank loans - client to bank
  ;;   - interest on L2 savings deposits - bank to client
  ;;   - interest on required reserves - CRB to bank
  ;;   - interest on excess reserves - CRB to bank
  ;;   - dividends on stocks - corps to shareholders (not implemented yet)
  ;;   - interest on bonds - GCRA and corps to bondholders (not implemented yet)
  
  f-accrue-interest-on-bank-loans-and-deposits
  f-accrue-interest-on-reserves
  ;; TODO: Implement when corps activated.
  ;; f-accrue-dividends-on-corporate-stocks
  
  f-update-aggregates

  LOG-TO-FILE "  Do-accrue-interest: procedure completed"
;; end of do-accrue-interest
end

;;-----------------------------------------------------------------------------|
;; In this routine all per-tick interest and dividends are accrued.
to f-accrue-interest-on-bank-loans-and-deposits
;; This routine is to be executed by the observer.
  
  ;; For each prsn (and corp, and gov't) figure out how much interest
  ;;   must be paid on the current extant amount on a loan.  This is calculated
  ;;   daily (per tick) and added up, and paid at the end of the month.
  
  ;; First, check the government's consolidated revenue account (GCRA).
  ;; TODO: enable this when GCRA loans are implemented.
  ;; ask gcras
  ;; [
  ;;   if( L1-loan-debts > 0 )
  ;;   [ 
  ;;     LOG-TO-FILE ( word "  " )
  ;;     LOG-TO-FILE ( word "GCRA Bank Loan " )
  ;;     LOG-TO-FILE ( word "  Size of L1 loan --------------- " L1-loan-debts )
  ;;     f-bsvcs-client-accrues-daily-interest-on-L1-loan
  ;;     LOG-TO-FILE ( word "  Total interest due ------------ " S1-L1ip-debts )
  ;;   ]
  ;; ]

  ;; Next, check the prsns loans (L1) and savings (L2) accounts.
  ;;
  ask prsns
  [
    ;; Loans appear as L1 debts.
    if( L1-loan-debts > 0 )
    [
      LOG-TO-FILE ( word "  " )
      LOG-TO-FILE ( word "PRSN " who " - Bank Loan" )
      LOG-TO-FILE ( word "  Size of L1 loan --------------- " L1-loan-debts )
      f-bsvcs-client-accrues-daily-interest-on-L1-loan
      LOG-TO-FILE ( word "  Total interest due ------------ " S1-L1ip-debts )
    ]

    ;; Savings appear as L2 assets.
    if( L2-assets > 0 )
    [
      LOG-TO-FILE ( word "  " )
      LOG-TO-FILE ( word "PRSN " who " - Savings Deposit" )
      LOG-TO-FILE ( word "  Size of L2 savings deposit ---- " L2-assets )
      f-bsvcs-client-accrues-daily-interest-on-L2-savings
      LOG-TO-FILE ( word "  Total interest due ------------ " S1-L2ir-assets )
    ]
  ]

  ;; TODO:  Interest for corps not yet implemented.  Do like prsns.
  ;; Savings acct for GCRA not yet implemented.

;; end of f-accrue-interest-on-bank-loans-and-deposits
end

;;-----------------------------------------------------------------------------|
;; In this routine all per-tick interest is accrued.
to f-accrue-interest-on-reserves
;; This routine is to be executed by the observer.
  
  ;; For each bank figure out how much interest is payable on their CRB
  ;;   deposits.  This is calculated daily (per tick) and added up, 
  ;;   and paid at the end of the month.
  
  ask banks
  [
    ;; Do required reserves first.
    if( P0-rr-assets > 0 )
    [
      LOG-TO-FILE ( word "  " )
      LOG-TO-FILE ( word "BANK " who " - RR Deposit" )
      LOG-TO-FILE ( word "  Size of RR deposit ------------ " P0-rr-assets )
      f-cbsvcs-bank-accrues-daily-interest-on-RR-deposits      ;; Contact the bank.
      LOG-TO-FILE ( word "  Total interest due ------------ " S1-rrir-assets )
    ]

    ;; Now do excess reserves.
    if( P0-er-assets > 0 )
    [
      LOG-TO-FILE ( word "  " )
      LOG-TO-FILE ( word "BANK " who " - ER Deposit" )
      LOG-TO-FILE ( word "  Size of ER deposit ------------ " P0-er-assets )
      f-cbsvcs-bank-accrues-daily-interest-on-ER-deposits      ;; Contact the bank.
      LOG-TO-FILE ( word "  Total interest due ------------ " S1-erir-assets )
    ]
  ]
;; end of f-accrue-interest-on-reserves
end

;;-----------------------------------------------------------------------------|
;; Accrue per-tick dividends on corporate stocks.
to f-accrue-dividends-on-corporate-stocks
;; This routine is to be executed by the observer.

  ;; TODO:  Add a body to this hook.

;; end of f-accrue-dividends-on-corporate-stocks
end

;;-----------------------------------------------------------------------------|
;; D5 – do-monthly procedure(s)
;;-----------------------------------------------------------------------------|
to do-monthly
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "monthly" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-monthly: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; There are four or five procedures that need to be done once a 
  ;;   month (every 30 days)
  let check-value ( ticks mod 30 )
  if( check-value = 0 )
  [
    f-cbsvcs-gcra-reconciles-with-crb-monthly
    f-process-interest-payments-monthly
    f-process-payments-on-loans-monthly
    f-government-spends-and-taxes-monthly
    f-btpfs-government-special-monthly-transfer
  ]
  
  f-update-aggregates

  LOG-TO-FILE "  Do-monthly: procedure completed"
;;  end of do-monthly
end

;;-----------------------------------------------------------------------------|
;; Process interest payments monthly.
to f-process-interest-payments-monthly
;; This routine is to be executed by the observer.
  
  ;; Monthly interest payments will be made by check 
  ;;   from/to the L1 checking accts.
  
  ;; Prsns can make payments on L1 loans and collect payments on L2 savings.
  ask prsns
  [
    ;; Contact the bank.
    let mybank ( bank bank-who )

    ;; NOTE: a payment of interest on a loan does not affect the principal.
    ;;   It causes a change of net-worth of both participants.  The payables
    ;;   and receivables do not appear on the official books of either 
    ;;   party until the month-end reconciliation happens.  The changes to the 
    ;;   C1-assets and the L1-assets are the effective transfer of 
    ;;   net-worth monthly.  Only due payments above $1 are processed.
    
    ;; Make interest payments on L1 loans.
    if( S1-L1ip-debts > 1 )
    [
      LOG-TO-FILE ( word "INTEREST PAYMENT ON LOAN:" )
      LOG-TO-FILE ( word "  Prsn " who " to bank " bank-who "." )
      LOG-TO-FILE ( word "  Prsn L1 loan ------------------ " L1-loan-debts )         
      LOG-TO-FILE ( word "  Prsn L1 assets before payment - " L1-assets )      
      LOG-TO-FILE ( word "  Bank C1 assets before payment - " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Current amount payable -------- " ( S1-L1ip-debts ) )
      f-bsvcs-client-pays-monthly-interest-on-L1-loan
      ;; NOTE: Due to the rounding of the interest-paid, a residual
      ;;   of interest payable will remain each month.  I do this to
      ;;   keep net worth integral.
      LOG-TO-FILE ( word "  Prsn L1 assets after payment -- " L1-assets )         
      LOG-TO-FILE ( word "  Bank C1 assets after payment -- " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Residual payable -------------- " ( S1-L1ip-debts ) )
    ]

    ;; Collect interest payments on L2 savings deposits.
    if( S1-L2ir-assets > 1 )
    [
      let interest-due floor( S1-L2ir-assets )
      LOG-TO-FILE ( word "INTEREST PAYMENT ON SAVINGS ACCOUNT:" )
      LOG-TO-FILE ( word "  Bank " bank-who " to prsn " who )
      LOG-TO-FILE ( word "  Prsn L1 assets before payment - " L1-assets )
      LOG-TO-FILE ( word "  Prsn L2 assets ---------------- " L2-assets )
      LOG-TO-FILE ( word "  Bank C1 assets before payment - " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Current amount receivable ----- " ( S1-L2ir-assets ) )
      f-bsvcs-client-paid-monthly-interest-on-L2-savings
      ;; NOTE: Due to rounding above, some residual interest-receivable 
      ;;   will remain.
      LOG-TO-FILE ( word "  Prsn L1 assets after payment -- " L1-assets )         
      LOG-TO-FILE ( word "  Bank C1 assets after payment -- " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Residual receivable ----------- " ( S1-L2ir-assets ) )
    ]
    
    ;; Prsns can collect payments on stocks and bonds.
    ;; TODO:  Not yet implemented.

  ] ;; End ask prsns
  
  ;; Corps can make payments on L1 loans and collect payments on L2 savings.
  ;; TODO:  Not yet implemented.
  
  ;; The government can pay interest on bank loans.
  ask gcras
  [
    ;; Contact the bank.
    let mybank ( bank bank-who )
    ;; Make interest payments on L1 loans.
    if( S1-L1ip-debts > 1 )
    [
      LOG-TO-FILE ( word "INTEREST PAYMENT ON LOAN:" )
      LOG-TO-FILE ( word "  GCRA " who " to bank " bank-who "." )
      LOG-TO-FILE ( word "  GCRA L1 loan ------------------ " L1-loan-debts )         
      LOG-TO-FILE ( word "  GCRA L1 assets pre-payment ---- " L1-assets )      
      LOG-TO-FILE ( word "  Bank C1 assets pre-payment----- " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Current payable --------------- " ( S1-L1ip-debts ) )
      f-bsvcs-client-pays-monthly-interest-on-L1-loan
      ;; NOTE: Due to the rounding of the interest-paid, a residual
      ;;   of interest payable will remain each month.  I do this to
      ;;   keep net worth integral.
      LOG-TO-FILE ( word "  GCRA L1 assets post-payment --- " L1-assets )         
      LOG-TO-FILE ( word "  Bank C1 assets post-payment --- " ( [C1-assets] of mybank ) )         
      LOG-TO-FILE ( word "  Residual payable -------------- " ( S1-L1ip-debts ) )
    ]
  ]
  
  ;; The CRB can pay interest to banks on reserve deposits.  
  ask banks
  [
    ;; Collect interest payments on required reserve deposits.
    if( S1-rrir-assets > 1 )
    [
      let the-crb ( crb crb-who )
      LOG-TO-FILE ( word "INTEREST PAYMENT ON RR:" )
      LOG-TO-FILE ( word "  CRB " crb-who " to bank " who "." )
      LOG-TO-FILE ( word "  Bank C1 assets ---------------- " C1-assets )
      LOG-TO-FILE ( word "  Bank L1 debts ----------------- " L1-debts )
      LOG-TO-FILE ( word "  CRB C1 assets ----------------- " ( [C1-assets] of the-crb ) )        
      LOG-TO-FILE ( word "  Current receivable ------------ " ( S1-rrir-assets ) )
      f-cbsvcs-bank-paid-monthly-interest-on-rr-deposits
      LOG-TO-FILE ( word "  CRB C1 assets ----------------- " ( [C1-assets] of the-crb ) )        
      LOG-TO-FILE ( word "  Bank C1 assets ---------------- " ( C1-assets ) )
      LOG-TO-FILE ( word "  Residual receivable ----------- " ( S1-rrir-assets ) )
    ]

    ;; Collect interest payments on excess reserve deposits.
    if( S1-erir-assets > 1 )
    [
      let the-crb ( crb crb-who )
      LOG-TO-FILE ( word "INTEREST PAYMENT ON ER:" )
      LOG-TO-FILE ( word "  CRB " ( [who] of the-crb ) " to bank " who "." )
      LOG-TO-FILE ( word "  Bank C1 assets ---------------- " C1-assets )
      LOG-TO-FILE ( word "  Bank L1 debts ----------------- " L1-debts )
      LOG-TO-FILE ( word "  CRB C1 assets ----------------- " ( [C1-assets] of the-crb ) )        
      LOG-TO-FILE ( word "  Current receivable ------------ " ( S1-erir-assets ) )
      f-cbsvcs-bank-paid-monthly-interest-on-er-deposits
      LOG-TO-FILE ( word "  CRB C1 assets ----------------- " ( [C1-assets] of the-crb ) )        
      LOG-TO-FILE ( word "  Bank C1 assets ---------------- " ( C1-assets ) )
      LOG-TO-FILE ( word "  Residual receivable ----------- " ( S1-erir-assets ) )
    ]

  ] ;; End ask banks
;;  end of f-process-interest-payments-monthly
end

;;-----------------------------------------------------------------------------|
;; Process payments on loans.
to f-process-payments-on-loans-monthly
;; This routine is to be executed by the observer.

  ;; Monthly loan payments of principal will be made by check 
  ;;   from/to the loan accts.
  
  ;; The GCRA can make a payment on L1 loans.
  ask gcras with [L1-loan-debts > 0]
  [
    LOG-TO-FILE ( word "GCRA'S PAYMENT ON L1 BANK LOAN" )
    f-bsvcs-agent-makes-a-payment-on-loan
  ]

  ;; Prsns can make payments on L1 loans.
  ask prsns with [L1-loan-debts > 0]
  [
    LOG-TO-FILE ( word "PRSN-" who "'S PAYMENT ON L1 BANK LOAN" )
    f-bsvcs-agent-makes-a-payment-on-loan
  ]

  ;; Corps can make payments on L1 loans.
  ;; TODO: Not implemented yet.
  ;; ask corps with [L1-loan-debts > 0]
  ;; [
  ;;   LOG-TO-FILE ( word "CORP-" who "'S PAYMENT ON L1 BANK LOAN" )
  ;;   f-bsvcs-agent-makes-a-payment-on-loan
  ;; ]

;; end of f-process-payments-on-loans-monthly
end

;;-----------------------------------------------------------------------------|
;; Government taxes and spends.
to f-government-spends-and-taxes-monthly
;; This routine is to be executed by the observer.

  ask gcras
  [
    ;; Tax first, spend second.  Ensures money is in the coffers.
    f-government-collects-taxes
    f-government-spends-money
  ]

;; end of f-government-spends-and-taxes-monthly
end

;;-----------------------------------------------------------------------------|
;; Government spends money.
to f-government-spends-money
;; This routine is to be executed the GCRA.

  ;; THEORY:  
  ;; This applies to this routine, and also to f-government-collects-taxes.
  ;;
  ;; How government spending and taxes are implemented are a matter of social
  ;;   policy.  Of course the government performs services when money is spent,
  ;;   but as long as the money goes back into its own economy, efficiency of
  ;;   of delivery of those services is somewhat irrelevant to the economy.
  ;; Taxing and spending are a means to re-distribute the money from some agents
  ;;   to other agents.  If that also happens to build infrastructure, good.
  ;; So, I tax a slider-determined % based on net-worth-priv values.  Taxes
  ;;   are collected monthly, so, e.g., a 1% tax rate amounts to 12% annual tax.
  ;; Then I spend a fixed amount on each person.  This is as if they receive
  ;;   a regular wage, independent of their wealth.  
  ;; The result is I redistribute money from the most wealthy to the most poor.
  ;;   For example, I will tax a large amount from a wealthy person and pay
  ;;   back a modest wage, while a poor person will pay little and receive a
  ;;   modest wage.
  ;; If you vary the tax rate, and the wage rate, then you should be able to
  ;;   effectively resist the effects of entropy production (inequitable 
  ;;   distribution of wealth).
  ;; To achieve the best effect, I need to set the taxes and expenditures to 
  ;;   roughly equal.  I.e. I need to balance the monthly gov't budget.
    
  LOG-TO-FILE ( word "" )
  LOG-TO-FILE ( word "GCRA SPENDS MONEY" )
  ;; Government spends by paying a wage to prsns.
  ;; The government will spend all of its assets.
  ;; I am assuming that taxes have been collected previously and are waiting 
  ;;   to be spent.
  
  ;; Contact the bank of the GCRA.
  let gcra-bank ( bank bank-who )
  
  ;; Determine what the monthly wage will be.
  ;; All monies are spent.  The budget is balanced.
  let monthly-wage round( L1-assets / g-no-of-prsns )  
  ;; Initialize an aggregate variable.
  let wages-paid 0
  
  LOG-TO-FILE ( word "  GCRA L1 assets prior to payments -- " L1-assets )
  LOG-TO-FILE ( word "  Monthly wage ---------------------- " monthly-wage )
  
  ;; This functions like a prsn-to-prsn check, and requires six entries.
  ;;   Two in client's check books.  Four in bank back room records.
  ask prsns
  [
    ;; Contact bank
    let prsn-bank ( bank bank-who )
    ;; Put money into prsn's bank account.  Entry #1.
    ask prsn-bank [ set L1-debts ( L1-debts + monthly-wage ) ]
    ;; Assets follow debts.  Entry #2.
    ask prsn-bank [ set L1-assets ( L1-assets + monthly-wage ) ]
    ;; Enter the deposit into prsns check-book.  Entry #3.
    ;; At this point the net change in prsn-bank is zero.
    LOG-TO-FILE ( word "  PRSN " who " L1 assets prior to payment - " L1-assets )
    set L1-assets ( L1-assets + monthly-wage )
    LOG-TO-FILE ( word "  PRSN " who " L1 assets after payment ---- " L1-assets )
    
    ;; Enter the payment into the gov't tally-book.
    set wages-paid ( wages-paid + monthly-wage )
  ]
  ;; Remove the money from GCRA bank account.  Entry #4.
  ask gcra-bank [ set L1-debts ( L1-debts - wages-paid ) ]
  ;; Assets follow debts.  Entry #5.
  ask gcra-bank [ set L1-assets ( L1-assets - wages-paid ) ]
  ;; At this point the net change in gcra-bank is zero.
  ;; Note the payments in the gov't check book.  Entry #6.
  set L1-assets ( L1-assets - wages-paid )
  LOG-TO-FILE ( word "  Total wages paid ------------------ " wages-paid )
  LOG-TO-FILE ( word "  GCRA L1 assets after all payments - " L1-assets )
  
  ;; TODO: When I start taxing banks and corps, I need to add payments 
  ;;   to banks and corps.

;; end of f-government-spends-money
end

;;-----------------------------------------------------------------------------|
;; Government collects a tax of net worth.
to f-government-collects-taxes
;; This routine is to be executed by the GCRA.

  if( g-net-worth-tax-rate > 0 )
  [
    ;; THEORY: See the routine f-government-spends-money for a complete 
    ;;   description of the approach to government taxing and spending.
  
    ;; The government collects a "net worth" tax and puts it into its
    ;;   "Government Consolidated Revenue Account", i.e. its GCRA.
    ;; It does not tax GCRA or crb accounts.  
    ;; Private CRB "C" accounts are considered a sub-account of GCRA.
  
    ;; TODO: Add taxes for corps and private bank worth.

    ;; Identify the bank of the GCRA.
    ;; The GCRA is not a bank.  It keeps its accounts in a commercial bank.
    let gcra-bank ( bank bank-who )
  
    let taxes-due 0        ;; Initialize a working variable.
    let all-taxes-paid 0   ;; initialize an aggregate to collect all taxes paid.
  
    ;; This functions like a prsn-to-prsn check, and requires six entries.
    ;;   Two in client's check books.  Four in bank back room records.
    ask prsns
    [
      LOG-TO-FILE ( word "PRSN " who " PAYS TAXES" )
      f-compute-prsn-net-worth
      LOG-TO-FILE ( word "  Prsn net worth -------------------- " net-worth-priv )
      set taxes-due round( net-worth-priv * g-net-worth-tax-rate / 100 )
    
      ;; Taxes are paid by bank-to-bank check.
      ;; Contact the prsn's bank.
      let prsn-bank ( bank bank-who )
    
      LOG-TO-FILE ( word "  Prsn L1 assets before payment ----- " L1-assets )
      ;; Remove taxes from prsns bankbook.  Entry #1.
      set L1-assets ( L1-assets - taxes-due )
      ;; Remove the taxes from the prsns checking account. Entry #2.
      ask prsn-bank [ set L1-debts ( L1-debts - taxes-due ) ]
      ;; Assets follow debts.  Entry #3.
      ask prsn-bank [ set L1-assets ( L1-assets - taxes-due ) ]
      ;; Record the amount as paid, for later entry to GCRA bankbook.
      ;; At this point the net change in prsn-bank is zero.
      set all-taxes-paid ( all-taxes-paid + taxes-due )
      LOG-TO-FILE ( word "  Taxes paid ------------------------ " taxes-due )
      LOG-TO-FILE ( word "  Prsn L1 assets after payment ------ " L1-assets )
    ]
    LOG-TO-FILE ( word "  GCRA L1 assets before collection -- " L1-assets )
    LOG-TO-FILE ( word "  Total of all taxes collected ------ " all-taxes-paid )
    ;; Government adjusts its own bankbook.  Entry #4.
    set L1-assets ( L1-assets + all-taxes-paid )
    ;; Add the money to the gov't checking account.  Entry #5.
    ask gcra-bank [ set L1-debts ( L1-debts + all-taxes-paid ) ]
    ;; Assets follow debts.  Entry #6.
    ask gcra-bank [ set L1-assets ( L1-assets + all-taxes-paid ) ]
    ;; At this point the net change in gcra-bank is zero.
    LOG-TO-FILE ( word "  GCRA L1 assets after collection --- " L1-assets )
  
    ;; TODO: Add taxes on corporations.
    ;; TODO: Add taxes on private net worth of banks.
  ]

;; end of f-government-collects-taxes
end

;;-----------------------------------------------------------------------------|
;; Everybody visits their bank.
to f-everybody-visits-their-bank
;; This routine is to be executed by the observer.
;; It is executed on setup, and monthly.

  LOG-TO-FILE ( word "  EVERYBODY VISITS BANK" )
  ;; The prsns and corps must visit their banks.
  f-prsns-visit-banks-daily
  
  ;; TODO: Add corps here.
  ;; f-corps-visit-banks-daily

;; end of f-everybody-visits-their-bank
end

;;-----------------------------------------------------------------------------|
;; Each prsn has accounts with one bank.
to f-prsns-visit-banks-daily
;; This routine is to be executed by the observer.

  ask prsns 
  [
    ;; The following routine is used for daily visits, but also for setup,
    ;;   and to "initialize" new prsns.
    f-prsn-visits-a-bank
  ]

;; end of f-prsns-visit-banks-daily
end

;;-----------------------------------------------------------------------------|
;; A prns deposits cash into an L1 (checking) account and moves it about.
to f-prsn-visits-a-bank
  ;; This routine is to be executed by a prsn.
 
  ;; This routine is used for daily visits, but also for setup,
  ;;   and to initialize new prsns.

  ;; THEORY: The money must be shifted from the broadest categories towards the
  ;;   most narrow categories to be useful when needed.  Each shift requires
  ;;   an assessment of needs and supply all of the way up the chain.
  ;;   That is tricky and tedious, and prone to coding error.
  ;; The easiest way to handle it is to work through the categories of money
  ;;   from L0, L1, L2 to loan, and at each step, (PART A) deposit all of
  ;;   it to the next broader category of money, and then (PART B) determine 
  ;;   what is needed and move that much back. Ultimately any shortage must 
  ;;   come from a bank loan if possible, and any overage goes to savings.
  ;; This approach depends on the use of negatives to handle subtractions
  ;;   implicitly, and so makes for much simpler code.
    
  ;; Contact the bank.
  let my-bank ( bank bank-who )
  LOG-TO-FILE ( word "PRSN " who " VISITS BANK " bank-who "." ) 

  let affected-assets ( L0-assets + L1-assets + L2-assets )
  LOG-TO-FILE ( word "  My P0-assets were ------------- " P0-assets ) 
  LOG-TO-FILE ( word "  My L0-assets were ------------- " L0-assets ) 
  LOG-TO-FILE ( word "  My L1-assets were ------------- " L1-assets ) 
  LOG-TO-FILE ( word "  My L2-assets were ------------- " L2-assets ) 
  LOG-TO-FILE ( word "  Total affected assets --------- " affected-assets ) 
  
  ;; ----------------------------------
  ;; Establish appropriate P0/L0 holdings.
  ;; ----------------------------------
  ;; (PART A) Deposit all cash.
  ASSERT ( P0-assets = L0-assets ) "Bad cash" who
  f-bsvcs-prsn-deposits-cash L0-assets 
  LOG-TO-FILE ( word "  My P0-assets are -------------- " P0-assets ) 
  LOG-TO-FILE ( word "  My L0-assets are -------------- " L0-assets ) 

  ;; (PART B) Remove required amount of cash.
  f-bsvcs-prsn-withdraws-cash g-p-daily-L0-allocation 
  LOG-TO-FILE ( word "  My P0-assets are -------------- " P0-assets ) 
  LOG-TO-FILE ( word "  My L0-assets are -------------- " L0-assets ) 
    
  ;; ----------------------------------
  ;; Establish appropriate L1 holdings.
  ;; ----------------------------------
  ;; (PART A) Deposit all checking into savings.
  LOG-TO-FILE ( word "  My L1-assets are -------------- " L1-assets ) 
  f-bsvcs-prsn-moves-L1-to-L2 L1-assets 
  LOG-TO-FILE ( word "  My L1-assets are -------------- " L1-assets ) 

  ;; (PART B) Put required amount of money back into L1.
  f-bsvcs-prsn-moves-L2-to-L1 g-p-daily-L1-allocation 
  LOG-TO-FILE ( word "  My L1-assets are -------------- " L1-assets ) 
    
  ;; ----------------------------------
  ;; Establish appropriate L2 holdings.
  ;; ----------------------------------
  ;; THEORY: This will be different.  Savings cannot be negative.
  ;; A prsn must maintain sufficient money in checking to get
  ;;   throught a typical day (as determined by the standard
  ;;   allocations), and this is done from the savings.  When
  ;;   savings fall below zero, it must be topped up by a bank
  ;;   loan of a standard size.  If the bank has insufficient
  ;;   cash reserves, then it can no longer offer loans, and
  ;;   the prsn becomes insolvent (bankrupt).
    
  LOG-TO-FILE ( word "  Pre-loan - My L2-assets are --- " L2-assets ) 
  ;; This routine will determine:
  ;;   - if a loan is needed to top up the L2 assets.
  ;;   - if the bank has excess reserves.
  ;;   - size of the loan.
  ;;   - whether the bank can continue to make loans.
  ;;   - if this agent is solvent or insolvent.
  f-bsvcs-prsn-negotiates-an-L1-loan
  LOG-TO-FILE ( word "  Post-loan - My L0-assets are -- " L0-assets ) 
  LOG-TO-FILE ( word "  Post-loan - My L1-assets are -- " L1-assets ) 
  LOG-TO-FILE ( word "  Post-loan - My L2-assets are -- " L2-assets ) 
  ;; Note, the amount of the loan is placed in the agent's 
  ;;   L1 checking account, and is moved to savings the next
  ;;   time the agent visits a bank, using this procedure.
  set affected-assets ( L0-assets + L1-assets + L2-assets )
  LOG-TO-FILE ( word "  Total affected assets --------- " affected-assets ) 

  ;; End of f-prsn-visits-a-bank
end

;;-----------------------------------------------------------------------------|
;; The CRB supervises the management of reserve deposits.
to f-the-crb-reconciles-with-banks-daily
;; This routine is to be executed by the observer.

  LOG-TO-FILE ( word "" )
  LOG-TO-FILE ( word "CRB RECONCILES RESERVE DEPOSITS" )
  
  let crb-bank ( one-of crbs ) ;; More efficient this way.
  ask banks
  [
    LOG-TO-FILE ( word "BANK " who )

    LOG-TO-FILE ( word "  L1-loan-assets ---------------- " L1-loan-assets )
    LOG-TO-FILE ( word "  Old settings:" )
    LOG-TO-FILE ( word "  P0-vc-assets ------------------ " P0-vc-assets )
    LOG-TO-FILE ( word "  P0-rr-assets ------------------ " P0-rr-assets )
    LOG-TO-FILE ( word "  P0-er-assets ------------------ " P0-er-assets )
    let ttl-reserves ( P0-vc-assets + P0-rr-assets + P0-er-assets )
    LOG-TO-FILE ( word "  Total reserves ---------------- " ttl-reserves )
    
    ;; This bank controls limited reserves of cash

    ;; I am going to withdraw all CRB deposits and re-deposit the correct amounts.
    ;;   This is instead of shifing cash from place to place, which gets tricky.
    ;; This handles any negatives that may have occured 
    ;;   in the course of business.
    f-cbsvcs-bank-moves-er-to-vc P0-er-assets
    f-cbsvcs-bank-moves-rr-to-vc P0-rr-assets

    ;; Deposit the required reserves first.
    ;; The given required reserve ratio is a percentage.
    ;; We need a numeric factor.  Convert percentage to numeric factor. 
    let rr-factor ( g-reserve-requirement-ratio / 100 )
    let needed-rr-deposits floor( L1-loan-assets * rr-factor )
    if( needed-rr-deposits > ttl-reserves )
    [
      set needed-rr-deposits ttl-reserves
    ]
    f-cbsvcs-bank-moves-vc-to-rr needed-rr-deposits
    let remaining-reserves ( ttl-reserves - needed-rr-deposits )
    
    ;; Now I save some in the vault.
    let my-vc g-minimum-vault-cash
    if( my-vc > remaining-reserves )
    [
      set my-vc remaining-reserves
    ]
    set remaining-reserves ( remaining-reserves - my-vc )
    
    ;; The rest is excess reserves.
    f-cbsvcs-bank-moves-vc-to-er remaining-reserves
    LOG-TO-FILE ( word "  New settings:" )
    LOG-TO-FILE ( word "  P0-vc-assets ------------------ " P0-vc-assets )
    LOG-TO-FILE ( word "  P0-rr-assets ------------------ " P0-rr-assets )
    LOG-TO-FILE ( word "  P0-er-assets ------------------ " P0-er-assets )
    Set ttl-reserves ( P0-vc-assets + P0-rr-assets + P0-er-assets )
    LOG-TO-FILE ( word "  Total reserves ---------------- " ttl-reserves )
    ifelse( P0-er-assets > 0 )
    [ 
      set b-bank-can-make-loans 1
      LOG-TO-FILE ( word "  Bank loan dept status - OPEN" ) 
    ]
    ;; Else
    [ 
      set b-bank-can-make-loans 0
      LOG-TO-FILE ( word "  Bank loan dept status - CLOSED" ) 
    ]
  ]

;; end of f-the-crb-reconciles-with-banks-daily
end

;;-----------------------------------------------------------------------------|
;; D6 Process all end-of-day banking activities.
;;-----------------------------------------------------------------------------|
to do-banking
  ;; This routine is to be executed by the observer.
  
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "banking" ) )
    [ set gb-debug-flow-on 1 LOG-TO-FILE "" LOG-TO-FILE word "Do-banking: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  f-everybody-visits-their-bank
  ;; The visit to the bank can set prsn or bank bankruptcy flags.

  ;; TODO: also banks and corps, when implemented.  Banks may open savings
  ;;   accounts, as may corps?
  
  ;; Banks will now have odd reserves, and will need to reconcile them.
  ;; The government records need to be reconciled with bank records.
  ;;   The CRB reconciles reserve deposits with each bank daily.
  f-the-crb-reconciles-with-banks-daily
  
  ;; Banks may have been exhausted of their last abilities to earn C1-assets.
  ;; This sets a bankruptcy flag for banks.
  f-bsvcs-bank-checked-for-bankruptcy
  
  ;; Process bankruptcies of prsns.
  let prsn-bankruptcies ( prsns with [b-prsn-is-bankrupt = 1] )
  ask prsn-bankruptcies
  [
    f-bsvcs-process-prsn-bankruptcy
  ]

  ;; Process bankruptcies of banks.
  let bank-bankruptcies ( banks with [b-bank-is-bankrupt = 1] )
  ask bank-bankruptcies
  [
    f-bsvcs-process-bank-bankruptcy
  ]

  ;; TODO: Also corps, when implemented.
  
;; end of do-banking
end

;;-----------------------------------------------------------------------------|
;; D7 - do-post-tick procedure(s)
;;-----------------------------------------------------------------------------|
to do-post-tick
  ;; This routine is to be executed by the observer.
   
  if( gb-debug-on = 1 )
  [
    ifelse( ( gs-debug-step-chooser = "all" ) or ( gs-debug-step-chooser = "post-tick" ) )
    [ set gb-debug-flow-on 1  LOG-TO-FILE "" LOG-TO-FILE word "Do-Post-tick: Debug on; tick = " ticks ]
    [ set gb-debug-flow-on 0 ]
  ]
  
  ;; This code ensures that the number of banks active in the economy
  ;;   matches the numbers implied by the sliders.
  ;; Missing banks are created.  Overages are allowed to fall by
  ;;   attrition, through bankruptcies.
  set g-no-of-prsns-max ( g-no-of-prsns-per-bank * g-no-of-banks-max )
  let no-of-banks ( count banks )
  while[ no-of-banks < g-no-of-banks-max ]
  [
    ;; Create a new bank, and it as an average bank.
    f-bank-is-funded-as-average
    set no-of-banks ( count banks )  
  ]
  
  ;; This code ensures that the number of prsns active in the economy
  ;;   matches the numbers implied by the sliders.
  ;; Missing prsns are created.  Overages are allowed to fall by
  ;;   attrition, through bankruptcies.
  ;; Recompute the expected number of prsns, given that the slider may
  ;;   have been changed.
  set g-no-of-prsns-max ( g-no-of-prsns-per-bank * g-no-of-banks-max )
  set g-no-of-prsns ( count prsns )
  while[ g-no-of-prsns < g-no-of-prsns-max ]
  [
    ;; Create a new prsn, and fund him/her as an average prsn.
    f-prsn-is-funded-as-average
    set g-no-of-prsns ( count prsns )
  ]
  
  ;; MANUAL CHANGE FOR DEBUG.
  ;; This is a call to a debug routine which could be suppressed if all is okay.
  ;; This is one of a group of such calls, most of which are between step                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             