globals [tick-velocity                                      ;tick-velocity is for the scaled-down (1/4) velocity for visual purposes within the patch-based world
  data-velocity                                             ;data-velocity is for the actual velocity for data purposes outside of the world
  car-position                                              ;car-position keeps track of the displacement of the car relative to the origin
  x-axis                                                    ;x-axis allows plot to graph x-axis and remains constant
  barrier-written                                           ;barrier-written shows if the mach speed string has been displayed already, to prevent repetition
  ] 

turtles-own [cloud-speed]                                   ;speed of individual clouds


to setup                                                    ;resets and creates the world
  ca                                                        ;clears previous world
  reset-ticks                                               ;and resets ticks for graphs
  ask patches                                               ;asks all patches to
   [set pcolor 66]                                          ;turn bottom half light green
  ask patches with [pycor >= 0] 
   [set pcolor 96]                                          ;and turn top half sky blue
  ask patches with [pycor <= 0 and pycor >= -2] 
    [set pcolor 6]                                          ;creates road at certain patch y-coordinates
  create-turtles 1 [set shape "car"                         ;creates car
    set size 6                                              ;of size 6
    set heading 90                                          ;makes car face right
    set color 24]                                           ;set car color orange 
  create-turtles 30 [set shape "cloud"                      ;creates aesthetic clouds
    set size 2 + random 7                                   ;and varies their shape
    set heading 90                                          ;and sets their heading right
    set color white                                         ;with a white color
    set ycor (8 + random 5)                                 ;places clouds above road and below top of world 
    set xcor random-pxcor                                   ;and randomly on the x-axis
  ]
  ask turtles                                               ;defines random speed of each cloud
    [set cloud-speed .1 + (random 3 / 10)]                  
  set tick-velocity (initial-velocity / 25)                 ;sets velocity during model and applies scaling of 1/4 
  set data-velocity initial-velocity                        ;sets velocity during model for un-scaled (1/1) graphical and data purposes
  set car-position 0                                        ;sets displacement equal to zero 
  set x-axis 0                                              ;sets x-axis value for 0
end                                                         

to go                                                       ;continuous procedure that runs the model
  value-update                                              ;calls the value-update procedure
  change-position                                           ;calls the change-position procedure
  cloud-movement                                            ;calls the cloud-movement procedure
  mach-speed                                                ;calls the mach-speed procedure
                                                            
  ifelse stop? [                                            ;checks if car should stop instead of reverse as set in interface
                                                            ;if stop? is ON, then allows one iteration of the go procedure before stopping program
  if ticks > 10 [                                           ;prevents program from stopping if initial-velocity is 0 
  ifelse ((data-velocity < 0.5)                             ;checks if the actual (data) velocity is near 0
    and (data-velocity > -0.5))                            
   [ask turtles with [shape = "car"]                        ;continues to move the car with one more "go" iteration 
     [fd tick-velocity]                                     ;at the given velocity
    tick                                                    ;ticks for final graph update
    value-update                                            ;then updates values for velocity 
    change-position                                         ;and for displacement
    stop]                                                   ;then stops the model
   
   [ask turtles with [shape = "car"]                        ;if velocity is not near 0, move regularly 
     [fd tick-velocity]  ]
  ]
  ]
  
  [
   ask turtles with [shape = "car"]                         ;if Stop? switch is OFF move regularly
     [fd tick-velocity]                                     ;at the given tick-velocity 
  ]
 
  
  tick                                                      ;ticks for graph update
  wait .05                                                  ;slows "go" procedure 
end                                                         ;ends command code for setup

to value-update                                             ;procedure to update multiple values
  set tick-velocity                                         ;updates tick-velocity based on the
    (tick-velocity                                          ;previous tick-velocity and  
    + (acceleration / 25)                                   ;the scaled acceleration 
     )                                
    
  set data-velocity (data-velocity   
    + acceleration)                                         ;updates data-velocity based on actual acceleration
end                              

to change-position                                          ;procedure to update position
  set car-position (car-position +  
    data-velocity)                                          ;changes position based on unscaled velocity
end                                                         

to cloud-movement                                           ;procedure to move aesthetic clouds
  ask turtles with [shape = "cloud"]                        
    [fd cloud-speed]                                        ;moves clouds forward based on random speed given during "setup"
end

to mach-speed                                               ;proecedure to display when sound barrier is broken
  if data-velocity > 343.3 and                              ;if velocity breaks the sound barrier, 
  barrier-written != 1                                      ;ensures that the message has not been displayed yet
    [type "You broke the sound barrier! "                   ;displays message in command center
      set barrier-written 1]                                ;prevents further displays of the string above
    
  if data-velocity < -343.3 and                             ;copy as above but for negative velocities
  barrier-written != 1                                      ;ensures that the message has not been displayed yet
    [type "You broke the sound barrier! "                   ;displays message in command center
      set barrier-written 1]                                ;prevents further displays of the string above
    
  if data-velocity > -343.3 and                             ;if the velocity returns within the sound barrier
  data-velocity < 343.3
    [set barrier-written 0]                                 ;resets display so that message can be redisplayed later
end

;Written by

;Kailey Sarmiento
;Joshua Abraham
;Period 1
;IB Physics SL
;Sept. 19, 2014
@#$#@#$#@
GRAPHICS-WINDOW
18
231
1074
433
100
16
5.204
1
10
1
1
1
0
1
1
1
-100
100
-16
16
1
1
1
ticks
30.0

BUTTON
18
22
85
55
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
126
23
189
56
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
19
62
191
95
Initial-Velocity
Initial-Velocity
-30
30
0
1
1
(m/s)
HORIZONTAL

SLIDER
19
101
192
134
Acceleration
Acceleration
-1
1
0.25
.05
1
(m/s^2)
HORIZONTAL

PLOT
301
46
552
221
Position vs. Time
Time (s)
Position (m)
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -11881837 true "" "plot x-axis"
"pen-1" 1.0 0 -16777216 true "" "plot car-position"

PLOT
558
46
811
221
Velocity vs. Time
Time (s)
Velocity (m/s)
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -11881837 true "" "plot x-axis"
"pen-1" 1.0 0 -16777216 true "" "plot data-velocity"

PLOT
818
45
1073
221
Acceleration vs. Time
Time (s)
Acceleration (m/s^2)
0.0
2.0
-2.0
2.0
true
false
"" ""
PENS
"default" 1.0 0 -11881837 true "" "plot x-axis"
"pen-1" 1.0 0 -16777216 true "" "plot acceleration"

SWITCH
200
180
290
213
stop?
stop?
1
1
-1000

TEXTBOX
302
26
481
44
(x-axis is displayed as a teal line)
11
0.0
0

TEXTBOX
303
10
345
28
Graphs:
11
0.0
1

MONITOR
200
74
288
119
Velocity (m/s)
data-velocity
5
1
11

MONITOR
200
127
289
172
 Accel. (m/s^2)
Acceleration
5
1
11

MONITOR
200
22
289
67
Position (m)
car-position
5
1
11

TEXTBOX
19
438
375
456
Width of the world is approximately 804 meters or 4 meters per patch. 
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model simulates the relationship between position, velocity, and acceleration of an object. It is assumed there is no other variables like friction, wind resistance, et cetera.

Position, also defined as displacement, is determined by the location of the object relative to its initial position. Assuming that the initial position is 0 meters (m), then 1m is to the right of the origin and -1m is to the left of the origin.

Velocity is the change in position divided by the change in time. Unlike speed, however, velocity provides directionality. Velocity can be graphically represented as the slope of the tangent line at a point on a position versus time graph. In calculus, the equation for velocity is the derivative of an equation for the change in position, with respect to position. In this model, velocity is measured in meters per second (m/s).

Acceleration is the change in velocity divided by the change in time, or the rate of change of velocity. Acceleration can be respresented by the slope of the tangent line of a point on the velocity graph. In this model, acceleration is measured in meters per second squared (m/s^2)

The model examines how each variable is related. The user controls the initial velocity, acceleration, and if the car will stop at a velocity of zero or continue accelerating. Exploration of the various variables will demonstrate how veloctiy and acceleration affect position. The effects can be viewed on the various graphs on the User Interface (UI). 

## HOW IT WORKS

This model keeps track of four key variables: ticks, position, velocity, and acceleration.

* {Ticks} are used by NetLogo to keep track of time. Each iteration of the "go" procedure adds one tick. Ticks, as time, are used for displaying position, velocity, and acceleration at a given time. 


* {Position}, also defined as displacement, is kept track of in this model based on the velocity. At each tick, the value for "car-position" is increased or decreased depending on the "data-velocity" described below. 


* {Velocity} is the change in position over time. The value for velocity in this model is separated with two variables: one for data display and one for physical movement in the world. Velocity is separated in this way to apply a 1/4 scaling of the model for 1 patch per 4 meters. 
"Data-velocity" keeps track of the unscaled velocity for data display on the UI.
"Tick-velocity" keeps track of the 1/4 scaled velocity for movement at a given tick.


* {Acceleration} is the cange in velocity over time. The value for acceleration is added to the value for velocity at each tick to represent this relationship. Acceleration is also scaled down by 1/4 when applied to "tick-velocity" and unscaled when added to "data-velocity."

Various data is displayed on the UI:

* Monitors display the position, (data) velocity, and acceleration at a given tick. 


* Three graphs display the position, (data) velocity, and acceleration at each tick during the model. The graphs also plot an x-axis as a teal line for ease of reference. 

## HOW TO USE IT

(1) Choose an initial velocity using the "Initial-Velocity" slider. 
(2) Choose a starting acceleration using the "Acceleration" slider. 
(3) Decide if you want the program to stop or the car to begin reversing when velocity is zero by using the "Stop?" switch. If "Stop?" is selected as ON, then the program will halt once velocity 
(4) Click setup. An orange car on a road facing the right of the world should appear.
(5) Select the "go" button. This will make the car move according to the information provided by the sliders.

At any point during the model, the "go" button can be deslected to stop the model manually.

During the model, the acceleration value can either be kept constant or manipulated through the slider. However, velocity during the simulation cannot be direcly changed. Only "initial-velocity" can be altered before the simulation begins. 

## THINGS TO NOTICE

Using the graphs in the user interface, how are displacement/position, velocity, and acceleration related? Do the displayed graphs illustrate that velocity is the slope of a position versus time graph and that acceleration is the slope of a veloicty versus time graph? Is velocity positive or negative when the slope of the position graph is positive? Is acceleration positive or negative when the slope of the velocity graph negative? 

Also, what happens to the position graph when the car is moving backwards (make sure the "Stop?" switch is turned OFF)? Why do you think the happens?

## THINGS TO TRY

1) Make the velocity and acceleration positive numbers. What does the car do?

2) Make both the velocity and acceleration negative. What does the car do?

3) Make the velocity positive and the acceleration negative. Make sure "Stop?" is set at OFF. Now what does the car do? How is this different from the previous two scenarios? What happens when velocity approaches and then passes the x-axis? Do these results still verify the relationship between position, velocity and acceleration?


## EXTENDING THE MODEL

To make the code more complicated, a person could add in the effect of air resistance on speed. How will the car move with wind speeds at 10m/s versus 30m/s? 

Also, factors such as weight can be added. The model could demonstrate how a race car will take less time to speed up than a semi-truck or how aerodynamics help affect movement.

## NETLOGO FEATURES

Note the use of "Globals" at the top of the code to define variables not present in the user interface. 

Graphs are particularly helpful in this model for demonstrating relationships between each property of movement.

## RELATED MODELS

Traffic basic under "Social Science" in the NetLogo models library is useful for examining effects of car traffic and its relationship to speed. 

## CREDITS AND REFERENCES

Programmed by: Joshua Abraham and Kailey Sarmiento
Teacher: Mr. Reese
Tracy High School IB Physics Period 1

* Tsokos, K.A. Physics for the IB Diploma. 5th Edition. Cambridge Learning. 

Credit to NetLogo program and for the "Traffic Basic" model for fractions of this simulation's code:

* Wilensky, U. (1997).  NetLogo Traffic Basic model.  http://ccl.northwestern.edu/netlogo/models/TrafficBasic.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cloud
false
0
Circle -7500403 true true 13 118 94
Circle -7500403 true true 86 101 127
Circle -7500403 true true 51 51 108
Circle -7500403 true true 118 43 95
Circle -7500403 true true 158 68 134

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
