extensions [gogo]
globals
[
  raw-inner-width
  raw-inner-height
  raw-outer-width
  raw-outer-height
  raw-parallel-width
  raw-parallel-height
  new-px
  new-py
  speed
  leftE
  rightE
  topE
  bottomE
  TotalR
  r1
  r2
  Resistance1
  Resistence2
  serial-port
  BatteryVoltage
]
breed [ electrons electron ]

to gogo-ping
  carefully
  [ if not gogo:ping
    [ user-message "Unable to ping GoGo Board." ] ]
  [ user-message error-message ]
end
to setup
  set serial-port user-one-of "Select a port:" gogo:ports
  gogo:open serial-port
  repeat 5
  [ if not gogo:ping
    [ user-message "The GoGo Board is not responding." ] ]
  gogo:talk-to-output-ports [ "a" "b" "c" "d" ]
  
  
  
  ca
  set speed 0.5 
  setup-battery
  
  if Parallel
  [
  setup-parallel-bulbs
    
  set-default-shape electrons "circle"
  
  set raw-parallel-width  70
  set raw-parallel-height 30
  
  set raw-outer-width  80
  set raw-outer-height 80
 
  
  make-outside-box
  make-parallel-boxes
  set-default-shape electrons "circle"
  ]
  if not Parallel
  [
    setup-series-bulbs
  set-default-shape electrons "circle"
  
  set raw-inner-width  70
  set raw-inner-height 70
  
  set raw-outer-width  80
  set raw-outer-height 80
  
  
  make-outside-box
  make-inside-box
  set-default-shape electrons "circle"
  ]
end
to setup-battery
  crt 1
  [set color red
  set shape "i beam"
  set size 20
  set speed 0
  setxy 0 -75]
end
to setup-parallel-bulbs
  crt 1
  [set color yellow
  set shape "ufo top"
  set size 25
  set label "Lightbulb 2"
  set speed 0
  setxy 0 75]
  
  crt 1
  [set color yellow
  set shape "ufo top"
  set size 25  
  set label "Lightbulb 1"
  set speed 0
  setxy 0 5]
  
  
  crt 1
  [set color green
  set shape "crate"
  set size 25  
  set label "Resistance 1"
  set speed 0
  setxy -40 5]
  
  crt 1
  [set color green
  set shape "crate"
  set size 25  
  set label "Resistance 2"
  set speed 0
  setxy -40 75]
  
  
end

to setup-series-bulbs
  crt 1
  [set color yellow
  set shape "ufo top"
  set size 25
  set label "Lightbulb 1"
  set speed 0
  setxy -75 0]
  
  crt 1
  [set color yellow
  set shape "ufo top"
  set size 25
  set label "Lightbulb 2"
  set speed 0
  setxy 75 0]
  
  crt 1
  [set color green
  set shape "crate"
  set size 25  
  set label "Resistance 1"
  set speed 0
  setxy -40 75]
  
  crt 1
  [set color green
  set shape "crate"
  set size 25  
  set label "Resistance 2"
  set speed 0
  setxy 40 75]
end


to make-outside-box
  ask patches with [((abs pxcor = raw-outer-width) and (abs pycor <= raw-outer-height)) or
                    ((abs pycor = raw-outer-height) and (abs pxcor <= raw-outer-width))]
    [ set pcolor blue ]
end
to make-inside-box
  ask patches with [((abs pxcor = raw-inner-width) and (abs pycor <= raw-inner-height)) or
                    ((abs pycor = raw-inner-height) and (abs pxcor <= raw-inner-width))]
    [ set pcolor blue ]
end
to make-parallel-boxes
  ask patches with [((abs pxcor = raw-parallel-width) and (pycor <= raw-parallel-height + 40)) and
                    ((abs pxcor = raw-parallel-width) and (pycor >=  (-(raw-parallel-height) + 40))) or
                    ((pycor = raw-parallel-height + 40) and (abs pxcor <= raw-parallel-width)) or
                    ((pycor = (-(raw-parallel-height) + 40)) and (abs pxcor <= raw-parallel-width))]
  [set pcolor blue]
    
   ask patches with [((abs pxcor = raw-parallel-width) and (pycor <= raw-parallel-height - 30)) and
                    ((abs pxcor = raw-parallel-width) and (pycor >=  (-(raw-parallel-height) - 40))) or
                    ((pycor = raw-parallel-height - 30) and (abs pxcor <= raw-parallel-width)) or
                    ((pycor = (-(raw-parallel-height) - 40)) and (abs pxcor <= raw-parallel-width))]
   
  [set pcolor blue]
end
to make-electrons
  if Parallel
  [
 ;;   let leftE1 BatteryVoltage / 5 * (100 - TotalR)
    let leftE2 BatteryVoltage / 5 * (100 - Resistence2)
    let middleE BatteryVoltage / 5 * (100 - Resistance1)
    let rightE2 leftE2
    set topE leftE2
    set bottomE (leftE2 + middleE)
    let leftE1 bottomE
    let rightE1 leftE1
;;    set TotalR ((Resistance1 * Resistence2) / (Resistance1 + Resistence2))
  create-electrons topE [
    random-position-top-wire
    set color green ]
  create-electrons bottomE [
    random-position-bottom-wire
    set color yellow
  ]
  
  create-electrons middleE [
    random-position-middle-wire
    set color green
  ]
    
  create-electrons leftE1 [
    random-position-leftE1-wire
    set color yellow
  ]
  create-electrons leftE2 [
    random-position-leftE2-wire
    set color green
  ]
  create-electrons rightE1 [
    random-position-rightE1-wire
    set color yellow
  ]
  create-electrons rightE2 [
    random-position-rightE2-wire
    set color green
  ]
  ]
  
  if not Parallel
  [
    set TotalR (Resistance1 + Resistence2)
    set leftE BatteryVoltage / 5 * (200 - TotalR)
    set rightE BatteryVoltage / 5 * (200 - TotalR)
    set topE BatteryVoltage / 5 * (200 - TotalR)
    set bottomE BatteryVoltage / 5 * (200 - TotalR)
  
  create-electrons leftE [
    random-position-left-wire
    set color green
  ]
  create-electrons rightE [
    random-position-right-wire
    set color green
  ]
  create-electrons topE [
    random-position-top-wire
    set color green
  ]
  create-electrons bottomE [
    random-position-bottom-wire
    set color green
  ]
  ]
end
to random-position-left-wire
  if (((1 - raw-outer-width)  + random-float (raw-outer-width - 2)) < raw-inner-width)
  [
    setxy ((1 - raw-outer-width)  + random-float 8)
    ((1 - raw-outer-height) + random-float (2 * raw-outer-height - 2))
  ]
end
to random-position-leftE1-wire
  if (((1 - raw-outer-width)  + random-float (raw-outer-width - 2)) < raw-inner-width)
  [
    setxy ((1 - raw-outer-width)  + random-float 8)
    ((1 - raw-outer-height) + random-float (raw-outer-height - 2))
  ]
end
to random-position-leftE2-wire
  if (((1 - raw-outer-width)  + random-float (raw-outer-width - 2)) < raw-inner-width)
  [
    setxy ((1 - raw-outer-width)  + random-float 8) random-float (raw-outer-height - 2)
;;    ((1 - raw-outer-height) + random-float (raw-outer-height - 2))
  ]
end
to random-position-right-wire
    setxy (71 + random-float 8)
    ((1 - raw-outer-height) + random-float (2 * raw-outer-height - 2))
end
to random-position-rightE1-wire
    setxy (71 + random-float 8)
    ((1 - raw-outer-height) + random-float (raw-outer-height - 2))
end
to random-position-rightE2-wire
    setxy (71 + random-float 8)
;;    ((1 - raw-outer-height) + random-float (raw-outer-height - 2))
    random-float (raw-outer-height - 2)
end
to random-position-top-wire
    setxy ((1 - raw-outer-width) + random-float (2 * raw-outer-width - 2))
    (71 + random-float 8)
end
to random-position-bottom-wire
    setxy ((1 - raw-outer-width) + random-float (2 * raw-outer-width - 2))
    (- 71 - random-float 8)
end
to random-position-middle-wire
    setxy ((1 - raw-outer-width) + random-float (2 * raw-outer-width - 2))
    (1 + random-float 8)
end
to go
  convert-resistance
  set BatteryVoltage ((gogo:sensor 5) / 40)
  if gogo:sensor 5 < 50
  [
    set BatteryVoltage 0.5
  ]
  ask electrons
  [ die]
  make-electrons
  ;;calculate-speed
  ask electrons [
    bounce ]
  if Parallel [
  if (Resistance1 >= 0) and (Resistance1 >= 19)
  [set r1 45 ]
  if (Resistance1 >= 20) and (Resistance1 >= 39)
  [set r1 46 ]
  if (Resistance1 >= 40) and (Resistance1 >= 59)
  [set r1 47 ]
  if (Resistance1 >= 60) and (Resistance1 >= 79)
  [set r1 48 ]
  if (Resistance1 >= 80) and (Resistance1 >= 100)
  [set r1 49 ]
  if (Resistence2 >= 0) and (Resistence2 >= 19)
  [set r2 45 ]
  if (Resistence2 >= 20) and (Resistence2 >= 39)
  [set r2 46 ]
  if (Resistence2 >= 40) and (Resistence2 >= 59)
  [set r2 47 ]
  if (Resistence2 >= 60) and (Resistence2 >= 79)
  [set r2 48 ]
  if (Resistence2 >= 80) and (Resistence2 >= 100)
  [set r2 49 ]
  
  ask turtles [
  if bulb1? [ set color r1 ]
  if bulb2? [ set color r2 ]
  ]
  ]
;;  ask electrons [    move ]
end
to convert-resistance
   set Resistance1 (100 - ((gogo:sensor 1) - 23) / 10)
   set Resistence2 (100 - ((gogo:sensor 6) - 23) / 10)
end
to-report bulb1?
  report who = 1
end
to-report bulb2?
  report who = 2
end
to calculate-speed
  set speed ((100 - Resistance1) / 500)
end
to bounce
  if ((abs xcor < 80) and (abs xcor > 70)) ;; left or right
  [
    ;; get the coordinates of the patch we'll be on if we go forward 1
  let new-patch patch-ahead 1
  set new-px [pxcor] of new-patch
  set new-py [pycor] of new-patch
  ; if we're not about to hit a wall (yellow patch) or piston (orange patch)
  ; we don't need to do any further checks
  ; check: hitting left or right wall?
  if (abs new-px = 70) or (abs new-px = 80)
    ; if so, reflect heading around x axis
    [
      ;;  if the particle is hitting a vertical wall, only the horizontal component of the speed
      ;;  vector can change.  The change in velocity for this component is 2 * the speed of the particle,
      ;; due to the reversing of direction of travel from the collision with the wall
      set heading (- heading) ]
  ; check: hitting top or bottom wall? (Should never hit top, but this would handle it.)
  if (abs new-py = 80)
  [
    ;;  if the particle is hitting a horizontal wall, only the vertical component of the speed
    ;;  vector can change.  The change in velocity for this component is 2 * the speed of the particle,
    ;; due to the reversing of direction of travel from the collision with the wall
    set heading (180 - heading)
  ]
  fd speed
  ]
 if (abs xcor < 70)  ;; top or bottom or middle wire
  [
    ;; get the coordinates of the patch we'll be on if we go forward 1
  let new-patch patch-ahead 1
  set new-px [pxcor] of new-patch
  set new-py [pycor] of new-patch
  ; if we're not about to hit a wall (yellow patch) or piston (orange patch)
  ; we don't need to do any further checks
  ; check: hitting left or right wall?
  if (abs new-px = 69) 
    ; if so, reflect heading around x axis
    [
      ;;  if the particle is hitting a vertical wall, only the horizontal component of the speed
      ;;  vector can change.  The change in velocity for this component is 2 * the speed of the particle,
      ;; due to the reversing of direction of travel from the collision with the wall
      set heading (- heading) ]
  ; check: hitting top or bottom wall? (Should never hit top, but this would handle it.)
  if (abs new-py = 70) or (abs new-py = 80)
  [
    ;;  if the particle is hitting a horizontal wall, only the vertical component of the speed
    ;;  vector can change.  The change in velocity for this component is 2 * the speed of the particle,
    ;; due to the reversing of direction of travel from the collision with the wall
    set heading (180 - heading)
  ]
  if (abs new-py = 0) or (abs new-py = 10)
  [
    ;;  if the particle is hitting a horizontal wall, only the vertical component of the speed
    ;;  vector can change.  The change in velocity for this component is 2 * the speed of the particle,
    ;; due to the reversing of direction of travel from the collision with the wall
    set heading (180 - heading)
  ]
  fd speed
  ]
end
to move  ;; particle procedure
   jump 1
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
823
644
100
100
3.0
1
10
1
1
1
0
1
1
1
-100
100
-100
100
0
0
1
ticks
BUTTON
7
17
73
50
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
126
17
189
50
Go
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
SWITCH
50
55
153
88
Parallel
Parallel
1
1
-1000
MONITOR
110
308
200
353
Resistance 1
Resistance1
17
1
11
TEXTBOX
488
513
638
533
Battery\\n
16
9.9
1
MONITOR
108
97
198
142
Resistance 2
Resistence2
17
1
11
MONITOR
103
542
205
587
NIL
BatteryVoltage
17
1
11
@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.

HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.

HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.

THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.

THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.

EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.

NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.

CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
computer server
false
0
Rectangle -7500403 true true 75 30 225 270
Line -16777216 false 210 30 210 195
Line -16777216 false 90 30 90 195
Line -16777216 false 90 195 210 195
Rectangle -10899396 true false 184 34 200 40
Rectangle -10899396 true false 184 47 200 53
Rectangle -10899396 true false 184 63 200 69
Line -16777216 false 90 210 90 255
Line -16777216 false 105 210 105 255
Line -16777216 false 120 210 120 255
Line -16777216 false 135 210 135 255
Line -16777216 false 165 210 165 255
Line -16777216 false 180 210 180 255
Line -16777216 false 195 210 195 255
Line -16777216 false 210 210 210 255
Rectangle -7500403 true true 84 232 219 236
Rectangle -16777216 false false 101 172 112 184
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
crate
false
0
Rectangle -7500403 true true 45 45 255 255
Rectangle -16777216 false false 45 45 255 255
Rectangle -16777216 false false 60 60 240 240
Line -16777216 false 180 60 180 240
Line -16777216 false 150 60 150 240
Line -16777216 false 120 60 120 240
Line -16777216 false 210 60 210 240
Line -16777216 false 90 60 90 240
Polygon -7500403 true true 75 240 240 75 240 60 225 60 60 225 60 240
Polygon -16777216 false false 60 225 60 240 75 240 240 75 240 60 225 60
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
electric outlet
false
0
Rectangle -7500403 true true 45 0 255 297
Polygon -16777216 false false 120 270 90 240 90 195 120 165 180 165 210 195 210 240 180 270
Rectangle -16777216 true false 169 199 177 236
Rectangle -16777216 true false 169 64 177 101
Polygon -16777216 false false 120 30 90 60 90 105 120 135 180 135 210 105 210 60 180 30
Rectangle -16777216 true false 123 64 131 101
Rectangle -16777216 true false 123 199 131 236
Rectangle -16777216 false false 45 0 255 296
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
i beam
false
0
Polygon -7500403 true true 165 15 240 15 240 45 195 75 195 240 240 255 240 285 165 285
Polygon -7500403 true true 135 15 60 15 60 45 105 75 105 240 60 255 60 285 135 285
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
ufo top
false
0
Circle -1 true false 15 15 270
Circle -16777216 false false 15 15 270
Circle -7500403 true true 75 75 150
Circle -16777216 false false 75 75 150
Circle -7500403 true true 60 60 30
Circle -7500403 true true 135 30 30
Circle -7500403 true true 210 60 30
Circle -7500403 true true 240 135 30
Circle -7500403 true true 210 210 30
Circle -7500403 true true 135 240 30
Circle -7500403 true true 60 210 30
Circle -7500403 true true 30 135 30
Circle -16777216 false false 30 135 30
Circle -16777216 false false 60 210 30
Circle -16777216 false false 135 240 30
Circle -16777216 false false 210 210 30
Circle -16777216 false false 240 135 30
Circle -16777216 false false 210 60 30
Circle -16777216 false false 135 30 30
Circle -16777216 false false 60 60 30
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
