extensions [sound nw] ;; For using soune and Network package

globals [
  min-prevalence ;; minimale value of prevalence
  max-prevalence ;; maximal value of prevalence
  meta-influencers-droit ;; Method of sélection for meta-influencers right field
  meta-influencers-gauche ;; Methode of sélection for meta-influencers left field
  iter change total inversion try major
  ordonnee abcisse profondeur
  list_data file-in in_data in repet_data
  opinion-previous influence-previous
  links-dead links-create meta-create meta-agents
]

turtles-own [
  opinion ;; Opinion value of agent, between -1 and 1
  prevalence ;; Prevalence of agent, between min-prevalence and max-prevalence
  agent-type ;; Agent type : "Right side" or "Left side"
  influence ;; Agent level of influence, between  0 and 1
  infl_list
]

to setup
  clear-all
  set repet_data false
  set iter 0
  set min-prevalence 0
  set max-prevalence 99
  set-default-shape turtles "person"
  set try 1
  set major 0
  set links-dead 0
  set links-create 0
  set meta-create 0
  if vary-influence = true [set meta-links 0]
  create
  rapport
end

  to create
  ;; Créer les agents Right sides
  create-turtles pop / 2 [
    set agent-type "Right side"
    set opinion random-float 1 ;; Agent random opinion attribution between 0 and 1
    if opinion > 0 [set color blue]
    set prevalence random-float (opinion * 100) ;; Agent random prevalence attribution in function of opinion polarization
    set influence random-float 1 ;; Agent random influence attribution between 0 and 1
    set abcisse opinion * 16
    set ordonnee prevalence / 5.9
    set profondeur influence * 16
    setxyz abcisse ordonnee profondeur
  ]

  ;; Créer les agents Left sides
  create-turtles pop / 2 [
    set agent-type "Left side"
    set opinion random-float 1 - 1 ;; Agent random opinion attribution between -1 and 0
    if opinion < 0 [set color red]
    set prevalence random-float ((abs(opinion)) * 100) ;; Agent random prevalence attribution in function of opinion polarization
    set influence random-float 1 ;; Agent random influence attribution between 0 and 1
    set abcisse opinion * 16
    set ordonnee prevalence / 5.9
    set profondeur influence * 16
    setxyz abcisse ordonnee profondeur
  ]

influenceurs ;; create metas-influencers
  reset-ticks

    update-networks
  set total 0
  set change 0
end

to rapport
   ;; titles for Statistics or Values inside compute-statistics
   if output = "Statistics" [
      output-print (word "Try ; " "Iter ; " "Opinion global ; " "Opinion right side ; " " Opinion left side ; " "Prevalence right side ; " "Prevalence left side ; " "Influence right side ; " "Influence left side ; "  "Left % ; "  "Right % ; " "Links-Remove ; " "Links-Create ; " "Inversion % ; " " change ; " "total")
  ]
  if output = "Values" [output-print (word "Try ; " "Ticks ; "  "Agents ; " "Prevalence ; " "Opinion ; " "Influence ;" " meme droit") ]

  if output = "File" [
     ask turtles [
    let pre prevalence
    let mem opinion
    let infl influence
    let ti ticks
    output-print (word ti " " pre " " mem " " infl )
    ]
  ]
end

to influenceurs
  ;; create status of meta-influencers
  if meta-influencers-selection = "All" [
    ask n-of (round (count turtles * meta-influencers)) turtles [
      if prevalence > meta-low and prevalence <= meta-high [set influence 1 ;; maximal influence  (1) to X % of agents
        set color yellow set meta-agents meta-agents + 1]
  ]
  ]
  if meta-influencers-selection = "Right side" [
    set meta-influencers-droit round (count turtles * meta-influencers)
    ask n-of meta-influencers-droit turtles with [opinion > 0 ] [
      if prevalence > meta-low and prevalence <= meta-high [set influence 1 ;; maximal influence  (1) to X % of agents from type "Right side"
        set color yellow set meta-agents meta-agents + 1]
    ]
  ]
  if meta-influencers-selection = "Left side" [
   set meta-influencers-gauche round (count turtles * meta-influencers)
    ask n-of meta-influencers-gauche turtles with [opinion < 0] [
      if prevalence > meta-low and prevalence <= meta-high [set influence 1 ;; maximal influence  (1) to X % of agents from type "Left side"
        set color yellow set meta-agents meta-agents + 1]
    ]
  ]
end

to go
   ifelse iter < max_iter [set iter iter + 1
   if auto_event = true [if tick-event = iter [event]]
   if meta-ok = true [meta]
    update-opinions
    update-networks
    ask links [hide-link]
  if output = "Statistics" [ let avg-opinion mean [opinion] of turtles
  let positive-opinion median [opinion] of turtles with [opinion >= 0]
  let negative-opinion median [opinion] of turtles with [opinion < 0]
  let positive-prevalence median [prevalence] of turtles with [opinion >= 0] / 100
  let negative-prevalence median [prevalence] of turtles with [opinion < 0] / 100
  let negative-influence median [influence] of turtles with [opinion < 0]
  let positive-influence median [influence] of turtles with [opinion >= 0]
  let Left%  (count turtles with [opinion < 0]) / (pop / 100)
  Let Right% (count turtles with [opinion >= 0]) / (pop / 100)
  let ti iter
  output-print (word try " ; " ti " ; " avg-opinion " ; " positive-opinion " ; " negative-opinion " ; " positive-prevalence " ; " negative-prevalence " ; " positive-influence " ; " negative-influence " ; " Left% " ; " Right% " ; " links-dead " ; " links-Create " ; " inversion " ; " change " ; " total)
  ]
  tick
  if cumulative = False [set change 0
      set total 0]
  colorer
  ;;rafraichir le graphique
  if refresh = true [if ticks > 200 [reset-ticks
      clear-plot]]
    if threshold <= (count turtles with [opinion > 0]) / (pop / 100) [set major major + 1]
    ] [ifelse try < nb_try [set try try + 1 set major 0 clear-turtles clear-plot ifelse repet_data = true [data] [create set meta-links 0]
  set iter 0
  set Major 0
  set links-create 0
  set links-dead 0
  set meta-create 0
  set min-prevalence 0
  set max-prevalence 99]
    [sound:play-note "Tubular Bells" 60 64 1 stop]]
end

to update-opinions
  ask turtles [
    let target one-of link-neighbors ;; Selecting a neighbor randomly in the social network
    if target != nobody [ ;; verifying that this neighbor exist
      let difference-in-prevalence [prevalence] of self - [prevalence] of target ;; Calculer la différence de prégnance entre les deux agents
      ;; If the prevalence of the agent is lower than that of the neighbour, the agent adopts the opinion of the neighbor with a probability proportional to the difference of prevalence
      if difference-in-prevalence < 0 [
        let probability-of-adoption abs difference-in-prevalence / max-prevalence ;; Calculate the probability of adoption based on the difference in prevalence
        let opinion-difference abs (opinion - [opinion] of target) ;; Calculate the difference of opinion between the agent and the neighbor
         set opinion-difference opinion-difference * [influence] of target

        ;; Change adoption likelihood based on bias and influence
        set probability-of-adoption probability-of-adoption * (1 - polarization-factor * opinion-difference)

        ;filter the probability of adoption based on neighbor influence and agent influence.
        if ([influence] of target > probability-of-adoption or [influence] of self < probability-of-adoption ) [set opinion-previous opinion ;random-float 1
          set opinion [opinion] of target ;Adopt the neighbor's opinion
          set total total + 1 ;print total

          ;make the influence of the agent evolve according to the change of opinion of the agent
          set influence-previous influence
          if vary-influence = true [if abs(opinion-previous) > abs (opinion) [set influence (influence + rate-infl) if influence >= 1 [set influence 1 set color yellow
            if influence-previous < influence and influence = 1 [if meta-links < meta-limits [set meta-links meta-links + 1] set meta-agents meta-agents + 1]]]
            if abs(opinion-previous) < abs (opinion) [set influence (influence - rate-infl)  if influence < 0 [set influence 0]
              if influence < influence-previous and influence-previous = 1 [set meta-agents meta-agents - 1 ifelse opinion >= 0 [set color blue] [set color red]]]] ;; faire varier l'influence
            if (opinion < 0 and opinion-previous > 0) or (opinion > 0 and opinion-previous < 0) [set change change + 1]
      ] if total != 0 [set inversion change / total * 100]]
        ]

   ;;modulation of the prevalence according to the difference of opinion
   if modulation-prevalence = true [
      if prevalence > abs opinion * 100 [set prevalence prevalence - abs (opinion - opinion-previous) * [influence] of self * Rate-modulation]
      if prevalence < abs opinion * 100 [set prevalence prevalence + abs (opinion - opinion-previous)  * [influence] of self * Rate-modulation]
  ]
    ;; add stochastic noise to each iteration
    if random-float 1 < noise [
      ;; Change the agent's opinion by adding or subtracting a random value less than noise
      set opinion opinion + (random-float 0.4 - 0.2)
      ;; Make sure the opinion stays in the interval [-1, 1]
      if opinion > 1 [ set opinion 1 ]
        if opinion < -1 [ set opinion -1 ]
    ]
    ;;position agents on the chart based on opinion and influence
    set abcisse opinion * 16
    set ordonnee prevalence / 5.9 * 4 / 5
    set profondeur influence * 16
    setxyz abcisse ordonnee profondeur
    if output = "Values" or output = "File" [compute-statistics]

  ]

end

to colorer ; change the color of agents who have changed sides
  ask turtles [if color != yellow [ifelse opinion >= 0
    [set color blue]
    [set color red]
    ] ]

end

to update-networks
  ;; Remove links between agents with prevalences that are too different
  ask links with [abs([opinion] of end1 - [opinion] of end2) > (link-removal-threshold / 100)] [if random-float 1 < prob [set links-dead links-dead + 1 die]]
  ;; Form bonds between like-minded agents
  ask turtles [
    let potential-friends other turtles with [abs((opinion - [opinion] of myself)) < (link-formation-threshold / 100)]
    let friend one-of potential-friends
    if friend != nobody and not link-neighbor? friend [
      if random-float 1 < prob [create-link-with friend
        set links-create links-create + 1]
  ]
  ]
end
to meta
  ;; add links to meta-influencers
   ask turtles [
    let potential-friends other turtles with [color = yellow]
    let friend one-of potential-friends
    if friend != nobody and not link-neighbor? friend [
      if meta-create <= (meta-links - 1) [create-link-with friend set meta-create meta-create + 1]
        ]
  ]

end

to compute-statistics
 if output = "Values" [
  ;ask turtles [
    let pre prevalence
    let mem opinion
    let infl influence
    let ag who
    let ti ticks
    let ess try
    let memed (count turtles with [opinion > 0]) / (pop / 100)
    let maj major
    output-print (word ess " ; " ti " ; "  ag " ; " pre " ; "  mem " ; " infl " ; " memed)
  ;]
]
  if output = "File" [
     ;ask turtles [
    let pre prevalence
    let mem opinion
    let infl influence
    let ti ticks
    output-print (word ti " " pre " " mem " " infl )
    ;]
  ]

end

;;reading an input file of list of agents
to in_file ;File d'entrée
  carefully [
    set file-in user-file
    if (file-in != false) [
      set list_data []
      file-open file-in
      while [not file-at-end?] [
        set list_data sentence list_data (list (list file-read file-read file-read file-read))
      ]
      file-close ;; Add this line to close the File after reading it
      user-message "File uploaded!"
      set in true
    ]
  ] [
    user-message "File read error"
  ]
  data
end

to data
  clear-turtles
  clear-links
  let tick_to_load choice_iter

  ifelse (is-list? list_data) [
    let filtered_data filter [row -> first row = tick_to_load] list_data

    create-turtles length filtered_data [
      let my_index who
      let agent_data item my_index filtered_data

      set prevalence item 1 agent_data
      set opinion item 2 agent_data
      set influence item 3 agent_data
      setxy opinion prevalence

      if opinion < 0 [set color red set agent-type "Left side"]
      if opinion > 0 [set color blue set agent-type "Right side"]
      if influence = 1 [set color yellow]
    ]
  ] [
    set in false user-message "Read error"
  ]
  ;; create links
  update-networks
  ask links [hide-link]
  influenceurs
update-opinions
set repet_data true
end

to event ; moving agents to the right or left side by increasing or decreasing the prevalence
  ask turtles [
    ifelse meme_set = true [ if to_left = false [if agent-type = "Right side" [if opinion < 0 [set opinion opinion + event_size if opinion > 1 [set opinion 1]]]]
      if to_left = true [if agent-type = "Left side" [if opinion > 0 [set opinion opinion - event_size if opinion < -1 [set opinion -1]]]]]
    [if to_left = false [if opinion < high_meme and opinion > low_meme and  prevalence < high-prev and prevalence > low-prev [set opinion opinion + event_size
      if prev_change != 0  [set prevalence prevalence + prev_change] if opinion > 1 [set opinion 1]]]
      if to_left = true [if opinion > low_meme  and opinion < high_meme and prevalence > low-prev  and prevalence < high-prev  [set opinion opinion - event_size
      if prev_change != 0  [set prevalence prevalence + prev_change] if opinion < -1 [set opinion -1]]]
    ]]


end
@#$#@#$#@
GRAPHICS-WINDOW
0
0
903
423
-1
-1
21.85
1
10
1
1
1
0
1
1
1
-20
20
0
18
0
18
1
0
1
ticks
30.0

MONITOR
118
337
215
382
Agents % right
(count turtles with [opinion >= 0]) / (pop / 100)
2
1
11

MONITOR
19
336
116
381
Agents % left
(count turtles with [opinion < 0]) / (pop / 100)
2
1
11

BUTTON
13
12
68
46
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
77
13
132
47
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
85
248
151
308
max_iter
2000.0
1
0
Number

PLOT
621
10
1816
628
Curves of agents
Iterations
Proportions
0.0
200.0
30.0
70.0
true
true
"" ""
PENS
"Agents % right" 1.0 0 -14985354 true "" "if ticks > 0 [plot (count turtles with [opinion > 0] * 100 / pop) ]"
"Prevalence right" 1.0 0 -12345184 true "" "if ticks > 0 [plot abs(median [prevalence] of turtles with [opinion > 0])]"
"Prevalence left" 1.0 0 -2674135 true "" "if ticks > 0 [plot abs(median [prevalence] of turtles with [opinion < 0 / 100])]"
"Opinion right" 1.0 0 -11221820 true "" ";if ticks > 0 [plot median [opinion * 100] of turtles with [opinion > 0] ]"
"Opinion left" 1.0 0 -2139308 true "" ";if ticks > 0 [plot abs(median [opinion * 100] of turtles with [opinion < 0]) ]"
"Influence right" 1.0 0 -8990512 true "" "if ticks > 0 [plot median [influence] of turtles with [opinion > 0] * 100 ]"
"Influence left" 1.0 0 -1069655 true "" "if ticks > 0 [plot median [influence] of turtles with [opinion < 0] * 100 ]"
"Agents % left" 1.0 0 -5298144 true "" "if ticks > 0 [plot (count turtles with [opinion < 0] * 100 / pop) ]"

SLIDER
301
337
520
370
noise
noise
0
0.2
0.05
0.002
1
NIL
HORIZONTAL

SLIDER
301
375
521
408
polarization-factor
polarization-factor
0.00
1
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
301
453
522
486
link-formation-threshold
link-formation-threshold
0
10
1.5
0.1
1
NIL
HORIZONTAL

SLIDER
301
414
523
447
link-removal-threshold
link-removal-threshold
0
10
0.5
0.1
1
NIL
HORIZONTAL

SLIDER
298
67
517
100
meta-influencers
meta-influencers
0
0.40
0.4
0.01
1
NIL
HORIZONTAL

TEXTBOX
551
505
624
537
Output
18
0.0
1

CHOOSER
301
496
522
541
Output
Output
"None" "Values" "Statistics" "File"
2

CHOOSER
298
104
517
149
meta-influencers-selection
meta-influencers-selection
"None" "All" "Right side" "Left side"
2

SWITCH
299
152
479
185
modulation-prevalence
modulation-prevalence
0
1
-1000

SLIDER
299
194
516
227
rate-modulation
rate-modulation
0
1
0.15
0.01
1
NIL
HORIZONTAL

INPUTBOX
533
16
598
76
pop
500.0
1
0
Number

MONITOR
119
438
207
483
Opinion right
median [opinion * 100] of turtles with [opinion > 0]
2
1
11

MONITOR
17
438
116
483
Opinion left
abs (median [opinion * 100] of turtles with [opinion < 0])
2
1
11

MONITOR
117
491
205
536
Preval. right
median [prevalence] of turtles with [opinion > 0]
2
1
11

MONITOR
17
490
114
535
Preval. left
abs(median [prevalence] of turtles with [opinion < 0])
2
1
11

MONITOR
18
386
116
431
Influence left
median [influence] of turtles with [opinion < 0] * 100
2
1
11

MONITOR
119
386
213
431
Influence right
median [influence] of turtles with [opinion > 0] * 100
2
1
11

INPUTBOX
15
247
81
307
choice_iter
0.0
1
0
Number

BUTTON
139
14
194
47
NIL
in_file
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
214
440
295
485
Inversion %
inversion
2
1
11

SWITCH
417
15
517
48
cumulative
cumulative
0
1
-1000

BUTTON
12
60
76
93
NIL
event
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
79
61
169
94
to_left
to_left
1
1
-1000

SLIDER
14
102
290
135
event_size
event_size
0
2
0.6
0.01
1
NIL
HORIZONTAL

BUTTON
526
158
601
191
Influent
influenceurs
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

INPUTBOX
156
248
224
308
threshold
50.0
1
0
Number

SWITCH
173
62
270
95
meme_set
meme_set
1
1
-1000

INPUTBOX
83
178
149
238
high_meme
0.0
1
0
Number

INPUTBOX
12
178
78
238
low_meme
-0.3
1
0
Number

SWITCH
301
234
439
267
vary-influence
vary-influence
0
1
-1000

INPUTBOX
527
302
592
362
rate-infl
0.01
1
0
Number

INPUTBOX
153
178
220
238
high-prev
100.0
1
0
Number

INPUTBOX
224
179
291
239
low-prev
0.0
1
0
Number

INPUTBOX
533
85
597
145
nb_try
10.0
1
0
Number

SWITCH
323
15
413
48
refresh
refresh
0
1
-1000

SLIDER
13
140
290
173
prev_change
prev_change
-50
100
30.0
1
1
NIL
HORIZONTAL

SWITCH
197
14
317
47
auto_event
auto_event
1
1
-1000

MONITOR
219
338
276
383
iter
iter
17
1
11

MONITOR
219
389
276
434
Try
try
17
1
11

INPUTBOX
230
249
289
309
tick-event
10.0
1
0
Number

MONITOR
215
493
301
538
Major right
major
2
1
11

OUTPUT
15
552
607
671
11

MONITOR
529
366
604
411
Links-remove
links-dead
4
1
11

MONITOR
531
417
604
462
Links-create
links-create
17
1
11

INPUTBOX
531
466
604
526
prob
0.01
1
0
Number

SWITCH
522
196
612
229
meta-ok
meta-ok
0
1
-1000

INPUTBOX
447
273
517
333
meta-links
0.0
1
0
Number

INPUTBOX
372
272
441
332
meta-low
40.0
1
0
Number

INPUTBOX
302
271
366
331
meta-high
80.0
1
0
Number

INPUTBOX
622
628
682
688
noise
0.05
1
0
Number

MONITOR
443
230
518
275
Influencers
meta-agents
17
1
11

INPUTBOX
529
239
592
299
meta-limits
100.0
1
0
Number

@#$#@#$#@
## WHAT IS IT?

This software has been designed from the results of work done by the Public Opinion Research Group https://www.grop.ca

This work has focused on modelling the Quebec electorate facing political issues. Surveys have revealed the close relationship among the electorate between the bias level on these issues and the importance of representations underlying the accession of voters to these issues, ie the significance of this adhesion for each of the voters.

The operation of this multi-agent simulator is established on this relationship. It models the transmission in a population of a bipolar view.

Four factors are used to simulate the rules of meme transmission: prevalence, polarization of opinion, influence and social links.

Prevalence simulates the quality and quantity of neural representations an individual could have an opinion or meme. The meme could be more or less prominent or polarize in the mind of its owner. Those two factors act like the role of CO2 attributes to global warming and the profoundness of representations against or in favour of its role. Influence is the ability of individuals to dissipate their own meme  and social links simulate the relations of proximity or randomness among individuals sharing similar memes or having antagonistic opinions.


## HOW TO USE IT

By pressing "Setup", the model creates a population of agents according to the size of the population of agents desired in the "pop" window and which can follow two distributions: the first is only random and assigns multiple links to all agents, the second establishes links between agents according to the proximity of the agents with regard to their "opinion" and uses the "update-networks" procedure. The parameters of this procedure can be modified with the sliders "link-removal-threshold" establishing a threshold to eliminate links between agents whose opinions are distant and "link-formation-threshold" creating links between agents whose opinions are closer.ù The input box "prob" permits to add a probability of links formation or removal.

It is also possible to upload a file containing an agent distribution. This may have been produced using the "File" choice in the "Output" selector. If the file created contains several iterations, the distribution can be chosen according to the iteration number of the "choice_iter" entry. It is also possible to import files created by other software as long as the columns are separated by spaces and the columns from left to right contain the iteration number and the prevalence values ​​(between 0 and 99 ), opinion and influence (between 0 and 1).

The user can also create a proportion of meta-influencers distributed either in the entire population of agents either on the left side or on the right side with the "meta-influencers-selection" selector. The proportion of the whole population is selected using the "meta-influencers" slider. The value of the influence of the selected agents is then set to its maximum value, 1. At any time during the simulation, the user can also insert meta influencers by pressing the "Influential" button. The user can manage the number of additionnal links meta-influencers can have with the "meta-links" input and at about what upper ("meta-high") and lower ("meta-low") treshold of the prevalence should be placed for those meta-influencers.

A modulation of the prevalence according to the change of opinion of the agents can also be activated. A modulation rate is through the "modulation-prevalence" slider. In the same way, it is possible to vary the influence of the agents according to the capacity of agent to modify the opinion of the other agent according to a rate which one can establish in the entry "rate-infl". You can limit the number of links created around meta-influencers with "meta-limits" and it will grow until joining the limit prescribed. It is recommended to add a noise level to the simulation in the "noise" input in order to take into account external variables that may interfere with the simulation.

The "max_iter" entry sets the maximum number of iterations per trial. The "threshold" button establishes a threshold setting the proportion of agents on the right side that must be exceeded to count in the calculation of "Major% right".

The "Output" selector allows the "values" choice to extract the parameters, prevalence, opinion and influence for each of the agents. as well as the proportion of agents on the right side, during each iteration. In the "Statistics" selection, the following results are obtained for each iteration: the average of the opinion parameter for all the agents, the median of the values ​​of the opinion, prevalence and influence parameters of the left and right sides respectively. Finally, the "file" selection allows, as we have seen above, to save the parameters of all the agents (excluding the distribution of links) in order to be able to download them during another simulation.

You can also choose the number of consecutive attempts of the same simulation by indicating this number in the "nb_try" entry (by default 1). The "max_iter" entry gives the maximum number of iterations for each trial. You push on the button "Go" to lunch a simulation.

The simulator can create events that modify the course of the simulation. The contour of the event is established choosing the upper and lower limits for the opinion parameter ("low_meme" and "high_meme") which are between -1 and 1, as well as the upper and lower limits for the prevalence being located between 0 and 99. The button "On/Off to left" allows to choose the movement towards the left side if on "On" and on the right side if on "Off". Once these selections have been made, the "event_size" slider is used to choose the size of the change on the opinion scale and the "prev_change" slider is used to establish the size of the change in prevalence for each of the selected agents. more or less. The "event" button is used to activate the event at the time chosen by the user, while the "On/Off (auto_event)" button is used to automate the launch of the event at the iteration chosen with the entry tick event. It is also possible to select only the agents defined at the starting point as being of the right side type or of the left side type by activating on "On" the "On/off same set" button.

Twelve monitors show the following results:
• Agents % left: the proportion of agents on the left side
• Agents% right: the proportion of agents on the right side
• Iter: the current iteration number
• Influence left: the median value of the Influence factor for agents on the left side
• Influence right: the median value of the Influence factor for agents on the right side
• Try: the current test number
• Opinion left: the median value of the Opinion factor for agents on the left side
• Opinion right: The median value of the Opinion factor for agents on the right side
• Inversion %: the proportion of side inversion of the agents at each iteration
• Preval left: the median value of the Prevalence factor for agents on the left side
• Preval right: the median value of the Prevalence factor for agents on the right side
• Major  right: The number of times agents exceeded the threshold on the right side for one trial.

The graph presents the curves of the proportion of agents on the right side and the left side, as well as the factors Opinion, Prevalence, Influence for each of these two sides.


## THINGS TO NOTICE

This Netlogo simulation program used GPT-4 to enhance the simulator and add new functionalities. Here is the initial proposal received from this LLM:

To create an agent-based simulation model using Netlogo according to the characteristics described, here is a basic plan for structuring the model:

1. Agents: Create two types of Agents: Partisans and Centrists. Supporters have strongly held opinions and are less likely to change their opinion, while centrists have weaker opinions and are more likely to change their opinion.
2. Agent variables: Each agent should have a variable representing their opinion (values ​​between -1 and 1, for example), a variable representing their salience (measured in percentage) and a variable describing their social network (list of agents connected).
3. Initialization: At the start of the simulation, assign random opinions and levels of pregnance to the agents. Connect agents to form a social network based on desired connectivity settings.
4. Forwarding: Create rules for forwarding opinions between agents. For example, when an agent interacts with another agent of its social network having a higher pregnance, it adopts the opinion of this agent with a probability proportional to the difference in pregnance.
5. Polarization: Modify transmission rules to account for polarization of opinions. Agents can take more extreme or moderate views depending on their interactions.
6. Updating social networks: Agents' social networks may change over time. Create rules to determine how agents form new connections or lose connections.
7. Meta-influencers: Introduce special agents (meta-influencers) who have a greater impact on the opinions of other agents. Their influence can be modeled by increasing their salience or changing the rules of transmission for them.
8. Outside Events: Add random or scheduled events that can influence agent opinions, such as news or political changes.
9. Visualization and analysis: Use Netlogo's visualization features to represent agents and their evolution over time. Analyze the results to study the dynamics of opinion transmission and polarization within the population.

By following these steps, yo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         