globals [
  initial-trees   ;; how many trees (green patches) we started with
  burned-trees    ;; how many have burned so far
  on-fire         ;; how many trees are currently on fire
  fire-break-orientation ;;the orientation of upcoming fire-breaks
  beetle-trees    ;; how many trees have been infested with beetles
]

breed [fires fire]    ;; bright red turtles -- the leading edge of the fire
breed [embers ember]  ;; turtles gradually fading from red to near black

to setup
  clear-all
  set-default-shape turtles "square"
  ;; make some green trees
  ;;KEEP - all of our trees in forest
  ask patches with [(random-float 100) < density] 
    [ set pcolor green ]
  ;; identify number of beetles in forest ecosystem
  ask patches with [ pcolor = green]
    [if (random-float 100) < beetle-percent [ set pcolor brown ]]
  ;; make a column of burning trees
  ;ask patches with [pxcor = min-pxcor]
  ;  [ ignite ]
  ;; select a random point in trees for burn source - for now center of patch
  ask patch 0 0 [ ignite ]
  ;; set tree counts
  set initial-trees count patches with [pcolor = green or pcolor = brown]
  set burned-trees 0
  set beetle-trees count patches with [pcolor = brown]
  reset-ticks
end

to go
  if not any? turtles  ;; either fires or embers
    [ stop ]
  ask fires
    [ ask neighbors4 with [pcolor = green or pcolor = brown]
        [ ignite ]
      set breed embers ]
  fade-embers
  set on-fire count patches with [pcolor = red]
  tick
;;end

;;;;;;;;;;;;;;;;;;;;;;;;;; we removed these [upper and lower lines]

;;to go
  fire-break
  if not any? turtles  ;; either fires or embers
    [ stop ]
  consume
  fade-embers
  tick
end

to forty-five
   set fire-break-orientation 45
end

to horiz
  set fire-break-orientation 90
end

to neg-forty-five
  set fire-break-orientation 135
end

to vert
  set fire-break-orientation 180
end


; Creates a fire-break, 30 units long and fire-break-width units wide
; If the wind is blowing, the fire-breaks is automatically built
; orthoganal to the wind.  Otherwise, it is build in the direction specified
; via the user interface buttons.

to fire-break
  if mouse-inside? and mouse-down?
  [
    if wind-strength > 0
    [
      set fire-break-orientation wind-direction + 90
    ]
    
    let width-rpt fire-break-width
    print width-rpt
    let length-rpt 30
    
    let start-patch patch mouse-xcor mouse-ycor
    repeat width-rpt
    [
      let l 0
      repeat length-rpt
      [
        if is-patch? start-patch
        [
          ask start-patch 
          [let next-p patch-at-heading-and-distance fire-break-orientation l
            if is-patch? next-p [ask next-p [ set pcolor red - 4]]
          ]
        ]
        set l (l + 1)
      ]
      
      if is-patch? start-patch
      [
        ask start-patch [set start-patch patch-at-heading-and-distance (fire-break-orientation - 90) 1]
      ]
    ]
  ]
end

to consume
ask fires
[
  ;; if there is wind, blow an ember in the direction of the
  ;; wind, according to the strength
  ifelse wind-strength > 0
[
  ;; get the direction, taking into account variability
  let dir (wind-direction + (((random wind-direction-variability) * 2) - wind-direction-variability))
      
  ;; get the wind strength, taking into account variability
  let str (wind-strength + (random gust-strength))
      
  ;; Verify that we are landing the ember on a valid patch
  ;; If so, ignite it
  let p patch-at-heading-and-distance dir str
  if is-patch? p
[
  ask p [ if ( pcolor = green and random 10 < 3 ) [ ignite ]]
  ask p [ if pcolor = brown [ ignite ]]
]
      
  ;; burn local forest, taking into account wind direction
  let dir-min wind-direction - (45 - random 10) ;
  ;; if dir-min < 0 [set dir-min 360 + dir-min]
  let dir-max wind-direction + (45 + random 10);
  if dir-max > 360 [
  set dir-max dir-max - 360
  set dir-min dir-min - 360
]
  ask neighbors with [pcolor = green or pcolor = brown]
[
  ;; if this patch is within our direction window, then burn it
  let corrected-dir towards myself
  ifelse corrected-dir >= 180
  [ set corrected-dir corrected-dir - 180 ]
  [ set corrected-dir corrected-dir + 180 ]
        
  if (corrected-dir >= dir-min) and (corrected-dir <= dir-max) [ignite]
]
]
[
  ;; burn local forest, in all directions if there is no wind
  ask neighbors4 with [pcolor = green or pcolor = brown] [ ignite ]
]
    
  set breed embers
]
end

;; creates the fire turtles
to ignite  ;; patch procedure
  sprout-fires 1
    [ set color red ]
  set pcolor black
  set burned-trees burned-trees + 1
end

;; achieve fading color effect for the fire as it burns
to fade-embers
  ask embers
    [ set color color - 0.3  ;; make red darker
      if color < red - 3.5     ;; are we almost at black?
        [ set pcolor color
          die ] ]
end


; Copyright 2015 Christina Belardo and Kali Nicholas 
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
200
10
712
543
125
125
2.0
1
10
1
1
1
0
0
0
1
-125
125
-125
125
1
1
1
ticks
30.0

MONITOR
8
128
193
173
percent of trees burned
(burned-trees / initial-trees)\n* 100
1
1
11

SLIDER
5
38
190
71
density
density
0.0
99.0
80
1.0
1
%
HORIZONTAL

BUTTON
105
182
174
218
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
23
182
93
218
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
6
83
191
116
beetle-percent
beetle-percent
0
100
100
1
1
%
HORIZONTAL

SLIDER
9
231
190
264
wind-direction
wind-direction
0
100
63
1
1
NIL
HORIZONTAL

SLIDER
10
310
192
343
wind-strength
wind-strength
0
15
4
1
1
NIL
HORIZONTAL

SLIDER
11
349
193
382
wind-direction-variability
wind-direction-variability
0
45
0
1
1
NIL
HORIZONTAL

SLIDER
11
388
194
421
fire-break-width
fire-break-width
2
12
7
1
1
NIL
HORIZONTAL

SLIDER
9
270
190
303
gust-strength
gust-strength
0
10
0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This project simulates the spread of a fire through a forest with respect to Pine Beetle kill impacts and wind conditions.  This is an example of a common feature of complex systems (specifically within the Rocky Mountain Region). This visualization can help students understand and see the relationships between excessive beetle kill and fire ecology connections.

## HOW IT WORKS

The fire starts from the center and spreads to neighboring trees. The fire can spread based on wind conditions and beetle kill presence.

The model allows for wind condition and beetle kill manipulation of variables. So, the fire must have trees along its path in order to advance.  In order for the fire to spread, beetle kill trees must be neighboring. While the fire spread to 3 out of 10 green healthy trees in this targeted environment. In addtion, the fire will not spread in unwooded areas (patch), so such a patch blocks the fire's motion in that direction.

## HOW TO USE IT

Click the SETUP button to set up the trees (green) and fire (red on the left-hand side).

Click the GO button to start the simulation.

The DENSITY slider controls the density of trees in the forest. (Note: Changes in the DENSITY slider do not take effect until the next SETUP.)

The BEETLE-PERCENT slider controls the amount of beetle-kill trees present the system.

The WIND-DIRECTION, GUST-STRENGTH, WIND-STRENGTH, WIND-DIRECTION-VARIABILTIY, FIRE-BREAK-WIDTH sliders control the directions of wind in the system, the gust strength, wind strength, the variabilty of wind direction, and breaks in fire spreading respectively.

## THINGS TO NOTICE

When you run the model, how much of the forest burns with respect to the other variables. If you run it again with the same settings, do the same trees burn? How similar is the burn from run to run? Hows does increased beetle-percent impact rate of spreading (we counted through the number of ticks as a unit of time).

## THINGS TO TRY

Students can use the model to answer these following questions:
a. What happens if all variables are set to lowest condition/level?
b. How does wind direction and strength impact fire spreading patterns?
c. What happens as the percentage of beetle kill increases?
d. How is the rate (based on number of ticks) of fire spreading impacted by increased beetle kill, alone? 
e. How is the rate (based on number of ticks)of fire spreading impacted by wind speed and direction, alone?
f. How is the rate (based on number of ticks)of fire spreading impacted by both high beetle kill and wind strength?
g. How could this model/program be improved?
h. How can computer modeling help fire & forest ecologists?

## EXTENDING THE MODEL

Wind conditions could be improved upon - feel free to edit and modify this Model. We would appreciate feedback and comments on how to make this model more effective and accurate to simulate real-ecological systems.

## NETLOGO FEATURES

Unburned trees are represented by green patches; burning trees are represented by turtles.  Two breeds of turtles are used, "fires" and "embers".  When a tree catches fire, a new fire turtle is created; a fire turns into an ember on the next turn.  Notice how the program gradually darkens the color of embers to achieve the visual effect of burning out.

The `neighbors4` primitive is used to spread the fire.

You could also write the model without turtles by just having the patches spread the fire, and doing it that way makes the code a little simpler.   Written that way, the model would run much slower, since all of the patches would always be active.  By using turtles, it's much easier to restrict the model's activity to just the area around the leading edge of the fire.

See the "CA 1D Rule 30" and "CA 1D Rule 30 Turtle" for an example of a model written both with and without turtles.

## RELATED MODELS

* Percolation
* Rumor Mill

## CREDITS AND REFERENCES

http://en.wikipedia.org/wiki/Forest-fire_model


## HOW TO CITE

If you mention this model in a publication, we ask that you include these citations for the model itself and for the NetLogo software:

* Belardo, C., and Nicholas, K. (2015). NetLogo Fire Ecology with Pine Beetle Kill Model. http://modelingcommons.org/browse/one_model/4289
* Bryant, C. (1997). NetLogo Fire model. http://modelingcommons.org/browse/one_model/2802
* Wilensky, U. (1997).  NetLogo Fire model.  http://ccl.northwestern.edu/netlogo/models/Fire.  Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.
* Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern Institute on Complex Systems, Northwestern University, Evanston, IL.

## COPYRIGHT AND LICENSE

Copyright 2015 Christina Belardo & Kali Nicholas.

![CC BY-NC-SA 3.0](http://i.creativecommons.org/l/by-nc-sa/3.0/88x31.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit http://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

This model was created as part of the project: CONNECTED MATHEMATICS: MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL MODELS (OBPML).  The project gratefully acknowledges the support of the National Science Foundation (Applications of Advanced Technologies Program) -- grant numbers RED #9552950 and REC #9632612.

This model was developed at the MIT Media Lab using CM StarLogo.  See Resnick, M. (1994) "Turtles, Termites and Traffic Jams: Explorations in Massively Parallel Microworlds."  Cambridge, MA: MIT Press.  Adapted to StarLogoT, 1997, as part of the Connected Mathematics Project.

This model was converted to NetLogo as part of the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT. The project gratefully acknowledges the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227. Converted from StarLogoT to NetLogo, 2001.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.1.0
@#$#@#$#@
set density 60.0
setup
repeat 180 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
