;; this is the most up-to-date version



globals [
  regions ; a list of regions definitions, where each region is a list of its min pxcor and max pxcor
]

breed [ blue-strains blue-strain ]

breed [ red-strains red-strain ]

;;red-strains-own [red-resistance-cost]
;;blue-strains-own [blue-resistance-cost] ; removing cost of resistance as a paramter for now

turtles-own [ resistant? energy mutation-rate cost-of-repair benefit? benefit-gain] ;; some variables that apply to both strains, ;resistance-cost removed

patches-own [
  region ; the region that the patch is in, patches outside all regions have region = 0
  antibiotic ;
]

to setup ; this procedure sets up the "world" into 2 different regions. It contains a few subprocedures described next
  clear-all
  setup-regions 2
  color-regions
  ; Finally, distribute the turtles in the different regions
  setup-turtles
  if (resistance + lethal + metabolic-benefit) > 100.00 [user-message ("Mutation rates should not sum to more than 100%")] ; this message appears to warn users about mutation rate settings
  reset-ticks
end

to color-regions ;this subprocedure colors the regions
  ; The patches with region = 0 act as dividers and are
  ; not part of any region. All other patches get colored
  ; according to the region they're in.
  ask patches with [ region != 0 ] [
    set pcolor 1 ;; what color is this - started at  times 10
    set plabel-color pcolor + 0
    ;set plabel region
    check-antibiotic
  ]
end

to setup-turtles ; this subprocedure creates the strains

  foreach n-values length regions [ [?1] -> ?1 + 1 ] [ [?1] ->
    let region-patches patches with [ region = ?1 ]
    create-blue-strains initial-blue-strain-population [
      move-to one-of region-patches
      if (count other turtles-here > 1) [move-to one-of region-patches]
      set shape "circle"
      set size 0.15
      set color blue
      set resistant? false ;; they all start not resistant
      ;;if ( show-resistance? ) [ show-resistance ]
      set energy random blue-life-span ;;they all start out with some amt of energy - a random value between 0 and blue-life-span
      set mutation-rate blue-mutation-rate
      set benefit? false ; they all start without beneficial mutations
    ]
    create-red-strains initial-red-strain-population [
      move-to one-of region-patches
      set shape "circle"
      set size 0.15
      set color red
      set resistant? false ;; they all start not resistant
      ;;if ( show-resistance? ) [ show-resistance ]
      set energy random red-life-span ;;they all start out with some amt of energy
      set mutation-rate red-mutation-rate
      set benefit? false
    ]
  ]
end

to go
  every 0.1 [ ; can be manipulated to make things happen faster
    ask turtles [ ; below are the things turtles do every half tick
      move ; see details under this procedure
      metabolize ; see details under this procedure
      mutate ; see details under this procedure
      if ( count other turtles-here > 20) [ die ] ;; this is where carrying capacity is specified at the moment
      if ( [antibiotic] of patch-here = true and not resistant? ) [ die ] ;; womp womp...notice antibiotic is 100% lethal
      if (energy <= 0) [die] ;; so tired...
      reproduce ;; see details under this procedure
    ;;if ( show-resistance? ) [ show-resistance ]
    ;if ( show-benefit?) [show-benefit] ;; obviously
    ;set-resistance-values
    ;]

   ; ifelse (resistant?)
  ; [
 ; if cost-of-resistance = "high" [set resistance-cost 5]
 ; if cost-of-resistance = "low" [set resistance-cost 2]
 ; if cost-of-resistance = "none" [set resistance-cost 0]
 ; ]
 ;  [set resistance-cost 0]
show-resistance
  ]
    check-antibiotic ; this checks the status of the antibiotic so that it can be changed mid run
    check-mutation-rates ; this checks to see if the mutation rate has been changed mid-run
  if ( count turtles = 0 ) [ stop ] ; the simulation stops if all the turtles die
  update-plots
  display
    ;if vid:recorder-status = "recording" [ vid:record-interface ]
  tick
  ]
end

to move ; turtle procedure

  ; First, save the region that the turtle is currently in:
  let current-region region
  ; Then, after saving the region, we can move the turtle:
  right random 30
  left random 30
  forward 0.25
  ; Finally, after moving, make sure the turtle
  ; stays in the region it was in before:
  keep-in-region current-region

end

to check-mutation-rates
  ask red-strains [if red-mutation-rate != mutation-rate [user-message ("You cannot change the mutation rate in the middle of a run. Restart the model!")]]
  ask blue-strains [if blue-mutation-rate != mutation-rate [user-message ("You cannot change the mutation rate in the middle of a run. Restart the model!")]]
end

to show-resistance ;; turtle procedure that colors bacteria to show resistance
 ifelse resistant?
 [ifelse (breed = red-strains) [ set color red + 3] [set color blue + 3]] ; if resistant set to lighter colors
 [ifelse (breed = red-strains) [ set color red ] [set color blue]] ; otherwise keep original colors

end

to show-benefit ;; turtle procedure that colors bacteria to show resistance
 ifelse benefit?
 [ifelse (breed = red-strains) [ set color yellow] [set color green]] ; if resistant set to lighter colors
 [ifelse (breed = red-strains) [ set color red ] [set color blue]] ; otherwise keep original colors

end

to mutate ;; turtle procedure

  if random-float 100 < mutation-rate [ ;; random float chooses a number between 0-100. If that number is less than mutation-rate (set by a slider on the interface) then...

    if random-float 100 < resistance ;; roll the resistant dice (this used to be ifelse for some reason)
    [ ;; this is the if part
      if ( not resistant? ) [ ;; toggle the resistance
      set resistant? true ] ;; YOUR POISON IS FUTILE!!
      ;[set resistant? false]
        ;[ if random-float 100 < 20 [set resistant? false ]
         ;] ;; back mutations set to 20%
    ]

     ;this is the else part
      if random-float 100 < lethal [ ;; roll the lethal dice...switch the greater than to less than
        die ;; end of the line :(
      ]


    ifelse benefit? [set benefit-gain random 2] [set benefit-gain 0] ; make this a random value - this specifies the value of benefit from beneficial mutation
    if random-float 100 > ( 100 - metabolic-benefit)
    [if ( not benefit?)
      [set benefit? true]
    ]


  ]

end

to metabolize ;; turtle procedure that sucks your life away
  let total-cost ( cost-of-repair  + 1) ;; metabolic cost is sum of all costs, + resistance-cost removed
  set energy (energy - total-cost + benefit-gain)
end

to reproduce ;; turtle procedure
  ;; i guess we'll make all the bacteria reproduce all the time.
  set energy energy / 2 ;; takes money to make money - but what is the point of this? sets effective lifespan to half so changed it to same energy as parents
  hatch 1 [ ;; they're cloning, so inherits any mutation including resistance (or not) and they are the same strain as parent
    rt random 360
    let current-region region
    fd random-float .5 ;; move a bit
    keep-in-region current-region
    ifelse breed = red-strains [set energy red-life-span] [set energy blue-life-span] ;; so lively
  ]
end

to check-antibiotic
  ifelse antibiotic? [
    ask patches with [pxcor >= 0] [set pcolor grey set antibiotic true]
    ask patches with [pxcor < 0] [set antibiotic false]
  ]
  [
  ask patches with [pxcor >= 0] [set pcolor 22 set antibiotic false]
    ask patches with [pxcor < 0] [set antibiotic false]
  ]
end

;;to plate-on-agar
 ;; let blue-plated-cells round concentration / 100 * count blue-strains
 ;;set blue-plated-cells count blue-strains - blue-plated-cells
 ;; ask n-of blue-plated-cells blue-strains [
;;    die]
;;  let red-plated-cells round concentration / 100 * count red-strains
;; set red-plated-cells count red-strains - red-plated-cells
;;  ask n-of red-plated-cells red-strains [
;;    die]
;;end

;;to plate-on-antibiotic
 ;; let blue-plated-cells round concentration / 100 * count blue-strains
;; set blue-plated-cells count blue-strains - blue-plated-cells
;;  ask n-of blue-plated-cells blue-strains [
;;    die
;;  ]
;;  ask blue-strains [
;;    if not resistant? [die]]
;;  let red-plated-cells round concentration / 100 * count red-strains
;; set red-plated-cells count red-strains - red-plated-cells
;;  ask n-of red-plated-cells red-strains [
;;    die]
;;  ask red-strains [
;;    if not resistant? [die]]
;;end



to setup-regions [ n ]
  ; First, draw some dividers at the intervals reported by `region-divisions`:
  foreach region-divisions n draw-region-division
  ; Store our region definitions globally for faster access:
  set regions region-definitions n
  ; Set the `region` variable for all patches included in regions:
  (foreach regions (n-values n [ [?1] -> ?1 + 1 ]) [ [?1 ?2] ->
    ; We're looping through region definitions (?1) and region numbers (?2)
    ask patches with [ pxcor >= first ?1 and pxcor <= last ?1 ] [ set region ?2 ]
  ])
end

to-report region-definitions [ n ]
  ; The region definitions are built from the region divisions:
  let divisions region-divisions n
  ; Each region definition lists the min-pxcor and max-pxcor of the region.
  ; To get those, we use `map` on two "shifted" copies of the division list,
  ; which allow us to scan through all pairs of dividers
  ; and built our list of definitions from those pairs:
  report (map [ [?1 ?2] -> list (?1 + 1) (?2 - 1) ] (but-last divisions) (but-first divisions))
end

to-report region-divisions [ n ]
  ; This procedure reports a list of pxcor that should be outside every region.
  ; Patches with these pxcor will act as "dividers" between regions.
  report n-values (n + 1) [ [?1] ->
    [ pxcor ] of patch (min-pxcor + (?1 * ((max-pxcor - min-pxcor) / n))) 0
  ]
end

to draw-region-division [ x ]
  ; This procedure makes the division patches grey
  ; and draw a vertical line in the middle. This is
  ; arbitrary and could be modified to your liking.
  ask patches with [ pxcor = x ] [
    set pcolor grey + 1.5
  ]
  create-turtles 1 [
    ; use a temporary turtle to draw a line in the middle of our division
    setxy x max-pycor + 0.5
    set heading 0
    set color grey - 3
    pen-down
    forward world-height
    set xcor xcor + 1 / patch-size
    right 180
    set color grey + 3
    forward world-height
    die ; our turtle has done its job and is no longer needed
  ]
end

to keep-in-region [ which-region ] ; turtle procedure

  ; This is the procedure that make sure that turtles don't leave the region they're
  ; supposed to be in. It is your responsability to call this whenever a turtle moves.
  if region != which-region [
    ; Get our region boundaries from the global region list:
    let region-min-pxcor first item (which-region - 1) regions
    let region-max-pxcor last item (which-region - 1) regions
    ; The total width is (min - max) + 1 because `pxcor`s are in the middle of patches:
    let region-width (region-max-pxcor - region-min-pxcor) + 1
    ifelse xcor < region-min-pxcor [ ; if we crossed to the left,
      set xcor xcor + region-width   ; jump to the right boundary
    ] [
      if xcor > region-max-pxcor [   ; if we crossed to the right,
        set xcor xcor - region-width ; jump to the left boundary
      ]
    ]
  ]

end


; Public Domain:
; To the extent possible under law, Uri Wilensky has waived all
; copyright and related or neighboring rights to this model.
@#$#@#$#@
GRAPHICS-WINDOW
545
145
1332
650
-1
-1
23.62
1
10
1
1
1
0
1
1
1
-16
16
-10
10
1
1
1
ticks
30.0

BUTTON
26
10
107
53
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
669
11
879
44
initial-red-strain-population
initial-red-strain-population
0
200
50.0
1
1
NIL
HORIZONTAL

SLIDER
667
74
881
107
initial-blue-strain-population
initial-blue-strain-population
0
200
50.0
1
1
NIL
HORIZONTAL

SLIDER
887
74
1073
107
blue-life-span
blue-life-span
0
50
9.0
1
1
replications
HORIZONTAL

SLIDER
887
12
1072
45
red-life-span
red-life-span
0
50
9.0
1
1
replications
HORIZONTAL

SLIDER
211
83
393
116
resistance
resistance
0
100
16.0
1
1
%
HORIZONTAL

SLIDER
22
82
203
115
lethal
lethal
0
100
5.0
1
1
%
HORIZONTAL

SWITCH
1042
664
1162
697
antibiotic?
antibiotic?
0
1
-1000

BUTTON
126
10
221
53
go/ pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

TEXTBOX
457
38
531
73
Red strain 
11
15.0
1

TEXTBOX
454
113
532
153
Blue strain 
11
105.0
1

TEXTBOX
31
59
187
77
Set mutation proportions
12
0.0
1

PLOT
19
340
273
506
R1: % Resistance mutations
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"%resistant" 1.0 0 -2674135 true "" "plot 100 * ((count red-strains with [resistant?] with [region = 1]) / (count red-strains with [region = 1]))"
"pen-1" 1.0 0 -13345367 true "" "plot 100 * ((count blue-strains with [resistant?] with [region = 1]) / (count blue-strains with [region = 1]))"

PLOT
22
175
274
343
R1: Percent of Each Strain
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"red-strain" 1.0 0 -5298144 true "" "plot 100 * ( count red-strains with [region = 1] ) / (count red-strains with [region = 1] + count blue-strains with [region = 1])"
"blue-strain" 1.0 0 -14454117 true "" "plot 100 * ( count blue-strains with [region = 1] ) / (count red-strains with [region = 1] + count blue-strains with [region = 1])"

PLOT
273
175
525
344
R2: Percent of Each Strain
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"red-strain" 1.0 0 -5298144 true "" "plot 100 * ( count red-strains with [region = 2] ) / (count red-strains with [region = 2] + count blue-strains with [region = 2] )"
"blue-strain" 1.0 0 -14454117 true "" "plot 100 * ( count blue-strains with [region = 2] ) / (count red-strains with [region = 2] + count blue-strains with [region = 2])"

INPUTBOX
543
10
656
70
red-mutation-rate
10.0
1
0
Number

INPUTBOX
543
72
656
132
blue-mutation-rate
1.0
1
0
Number

PLOT
273
342
525
506
R2: % Resistance mutations 
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"%resistant" 1.0 0 -2674135 true "" "plot 100 * (count red-strains with [resistant?] with [region = 2]) / count red-strains with [region = 2]"
"pen-1" 1.0 0 -13345367 true "" "plot 100 * (count blue-strains with [resistant?] with [region = 2]) / count blue-strains with [region = 2]"

MONITOR
211
121
299
166
% neutral 
100.00 - (resistance + lethal + metabolic-benefit)
17
1
11

SLIDER
22
122
203
155
metabolic-benefit
metabolic-benefit
0
100
7.0
1
1
%
HORIZONTAL

MONITOR
17
305
79
350
total R1
count turtles with [region = 1]
17
1
11

MONITOR
280
295
346
340
total R2
count turtles with [region = 2]
17
1
11

TEXTBOX
1174
669
1271
697
Turns antibiotic on in Region 2
11
0.0
1

TEXTBOX
561
665
789
686
Resistant bacteria are lighter in color
12
0.0
1

TEXTBOX
379
10
533
34
Set population properties
12
0.0
1

TEXTBOX
842
665
909
683
Region 1
14
0.0
1

TEXTBOX
938
666
1027
684
Region 2
14
0.0
1

PLOT
20
506
275
664
R1: % Beneficial mutations
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"percent" 1.0 0 -2674135 true "" "plot 100 * (count red-strains with [benefit?] with [region = 1] / count red-strains with [region = 1])"
"pen-1" 1.0 0 -13345367 true "" "plot 100 * (count blue-strains with [benefit?] with [region = 1] / count blue-strains with [region = 1])"

PLOT
275
505
525
664
R2: % Beneficial mutations
generations
percent
0.0
100.0
0.0
100.0
true
false
"" ""
PENS
"percent" 1.0 0 -2674135 true "" "plot 100 * (count red-strains with [benefit?] with [region = 2] / count red-strains with [region = 2])"
"pen-1" 1.0 0 -13345367 true "" "plot 100 * (count blue-strains with [benefit?] with [region = 2] / count blue-strains with [region = 2])"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)


## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="low MB high" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count red-strains with [region = 1]</metric>
    <metric>count blue-strains with [region = 1]</metric>
    <enumeratedValueSet variable="red-mutation-rate">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lethal">
      <value value="1"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="metabolic-benefit">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="resistance">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-blue-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="carrying_capacity">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="antibiotic?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-red-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="higher overall" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count red-strains with [region = 1]</metric>
    <metric>count blue-strains with [region = 1]</metric>
    <enumeratedValueSet variable="red-mutation-rate">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lethal">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="metabolic-benefit">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="resistance">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-blue-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="carrying_capacity">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="antibiotic?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-red-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="high lethal low rates" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count red-strains with [region = 1]</metric>
    <metric>count blue-strains with [region = 1]</metric>
    <enumeratedValueSet variable="red-mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lethal">
      <value value="30"/>
      <value value="40"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="metabolic-benefit">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="resistance">
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-blue-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="carrying_capacity">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="antibiotic?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-red-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-mutation-rate">
      <value value="0.1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="MB 5 increasing lethal" repetitions="10" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>count red-strains with [region = 1]</metric>
    <metric>count blue-strains with [region = 2]</metric>
    <enumeratedValueSet variable="red-mutation-rate">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lethal">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="25"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="metabolic-benefit">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="resistance">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-blue-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="antibiotic?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-red-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="Test" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="500"/>
    <metric>count red-strains with [region = 1]</metric>
    <metric>count blue-strains with [region = 1]</metric>
    <enumeratedValueSet variable="red-mutation-rate">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="red-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="lethal">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="metabolic-benefit">
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="resistance">
      <value value="5"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-blue-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="antibiotic?">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-life-span">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="initial-red-strain-population">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="blue-mutation-rate">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
