;;
;; Global Variables
;;
globals [
  mortgage-loan-amount
  mloan-capital
  mloan-reserve
  mloans-count
  consumer-loan-amount
  cloan-capital
  cloan-reserve
  cloans-count
  mortgage-loan-interest
  consumer-loan-interest
  mortgage-loan-duration
  consumer-loan-duration
  mloan-payment
  mloan-payments-received
  cloan-payment
  cloan-payments-received
  depserv-capital
  depserv-reserve
  banking-count
  depserv-payment
  depserv-payments-received
]
;
to setup
  clear-all
  setup-turtles
  setup-loans
  reset-ticks
end
;;
;;
;;
to setup-turtles
  clear-all
  create-turtles 1 [
  set shape "house"
  set color white
  set size 4
  ]
  create-turtles 868 [
    set shape "person"
    set color magenta ; magenta color turtle is a bank checking account holder or depositor
    setxy random-xcor random-ycor
  ]
  create-turtles 100 [
    set shape "person"
    set color lime ; lime (light green) turtle is a bank investor
    setxy random-xcor random-ycor
  ]
  create-turtles 100 [
    set shape "person"
    set color orange ; orange turtle is a bank consumer loan (car, home improvement etc.) customer
    setxy random-xcor random-ycor
  ]
  create-turtles 32 [
    set shape "person"
    set color blue ; blue turtle is a bank home mortgage customer
    setxy random-xcor random-ycor
  ]
 end
;;
;; Mortgage Loans are for $500,000 for 30 years with 7% interest/year
;; Consumer Loans are for $30,000 for 6 years with 5% interest/year
;;
to setup-loans
  set mortgage-loan-amount 500000
  set mortgage-loan-interest .07
  set mortgage-loan-duration 30 ;; 30 years
  set consumer-loan-amount 25000
  set consumer-loan-interest .05
  set consumer-loan-duration 6 ;; 6 years, when 1 loan is paid another one is initiated
  set depserv-payments-received 40 ;; recurring payments 30 years for 5000 customers
end

;;
;; 10% of the households have enough ongoing income & savings to invest $260000X100=26,000,000 in setting up a local community bank that provides depositer& loan services to the community
;;

to run-services-deptt
 ;;
 ;; 20 million investment made in mortgage loans, 20% or $4 million kept in reserve, 16 million invested in 32 home loans 0f $500,000 each
 ;;
  set mloan-capital 16000000
  set mloan-reserve 4000000
 ;;
 ;; Collect monthly payments on 32 mortgages of $3,326.51 that includes principal & interest for 360 months or 30 years at 7%
 ;;
  set mloan-payments-received (mloan-payments-received + mloan-payment)

 ;;
 ;; 4 million investment made in consumer loans, 20% or $1 million kept in reserve, 3 million invested in 100 consumer (car, home improvement etc.) loans of 30,000 each
 ;;
  set cloan-capital 1000000
  set cloan-reserve 1000000
  set cloan-payments-received (cloan-payments-received + cloan-payment)
 ;;
 ;; Collect monthly payments on 100 consumer loans that includes principal & interest for 72 months or 6 years, as each loan is paid and new loan is made and it continues for 30
 ;; years. Making the loan total 500
 ;;

  set cloan-payments-received (cloan-payments-received + cloan-payment) ;; as soon as a loan is paid another new loan is authorized, thus consumers loans exist for 30 years the life of the model
 ;;
 ;; 1 million investment made in depositer services, 1 million kept in reserve
 ;;
  set depserv-capital 1000000
  set depserv-reserve 1000000
 ;; Collect monthly depositer services (monthly checking account servicess, overdraft, over draft protection fees & loan late payment fees) from 768 customers at $40 average each per month
 ;; for 30 years
 ;;
  set depserv-payments-received (depserv-payments-received + depserv-payment)  ;; monthly for 30 years
 end

to go
  loop [
   if ticks = 0 [collect-lpayments0]
   if ticks = 120 [collect-lpayments1]
   if ticks = 240 [collect-lpayments2]
   if ticks >= 360 [STOP]
  run-services-deptt
  update-plot1
  update-plot2
  tick-advance 1
   ]
 end
;
to update-plot1
  set-current-plot "Customer Payment Receipts"
  set-current-plot-pen "mortgage payments"
  plot  (mloan-payments-received)
  set-current-plot-pen "loan payments"
  plot (cloan-payments-received)
  set-current-plot-pen "depositor payments"
  plot (depserv-payments-received)
end
;
to update-plot2
  set-current-plot "Number of Customers"
  set-current-plot-pen "mortgage customers"
  plot  (mloans-count)
  set-current-plot-pen "loan customers"
  plot (cloans-count)
  set-current-plot-pen "banking customers"
  plot (banking-count)
end
;
;37.5 % of customers are lost because of the great recession  i.e 12 mortgages, 38 consumer loans 5% and X depositors lost because of the great recession
;24 mortgages, 76 consumer loans, 77 depositors gained in the great recovery
;
to collect-lpayments0
  set mloan-payment 106448.40 ; 32 mloans monthly payments collected
  set mloans-count 32
  set cloan-payment 48314.80 ; 100 cloans monthly payments collected
  set cloans-count 100
  set depserv-payment 41664.00 ; 868 depositer services fees collected
  set banking-count 868
end
;
to collect-lpayments1
  set mloan-payment 79836.30 ;24 mloans monthly payments collected (great recession)
  set mloans-count 24
  set cloan-payment 29955.17 ; 62 cloans monthly payments collected (great recession);
  set cloans-count 62
  set depserv-payment 27776.00 ;614 depositor services fees collected ( great recession);
  set banking-count 694
  ;
  if ticks = 120 [
  clear-turtles
  create-turtles 1 [
  set shape "house"
  set color white
  set size 4
  ]
  create-turtles 868 [
    set shape "person"
    set color magenta ; magenta color turtle is a bank checking account holder or depositor
    setxy random-xcor random-ycor
  ]
  create-turtles 100 [
    set shape "person"
    set color lime ; lime (light green) turtle is a bank investor
    setxy random-xcor random-ycor
  ]
  create-turtles 62 [
    set shape "person"
    set color orange ; orange turtle is a bank consumer loan (car, home improvement etc.) customer
    setxy random-xcor random-ycor
  ]
  create-turtles 24 [
    set shape "person"
    set color blue ; blue turtle is a bank home mortgage customer
    setxy random-xcor random-ycor
  ]
  ]
end
;
to collect-lpayments2
  set mloan-payment 133060.50 ; 40 mloans monthly payments collected (great recovery)
  set mloans-count 40
  set cloan-payment 66674.42 ; 138 cloans monthly payments collected (great recovery);
  set cloans-count 138
  set depserv-payment 41664.00 ; 922 depositor services fees collected (great recovery);
  set banking-count 1042
  clear-turtles
  create-turtles 1 [
  set shape "house"
  set color white
  set size 4
  ]
  create-turtles 922 [
    set shape "person"
    set color magenta ; magenta color turtle is a bank checking account holder or depositor
    setxy random-xcor random-ycor
  ]
  create-turtles 100 [
    set shape "person"
    set color lime ; lime (light green) turtle is a bank investor
    setxy random-xcor random-ycor
  ]
  create-turtles 138 [
    set shape "person"
    set color orange ; orange turtle is a bank consumer loan (car, home improvement etc.) customer
    setxy random-xcor random-ycor
  ]
  create-turtles 40 [
    set shape "person"
    set color blue ; blue turtle is a bank home mortgage customer
    setxy random-xcor random-ycor
  ]
 end
@#$#@#$#@
GRAPHICS-WINDOW
226
10
663
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
26
11
89
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
129
11
192
44
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

MONITOR
690
10
832
55
mortgage investment
mloan-capital
0
1
11

MONITOR
871
10
1013
55
loan investment
cloan-capital
0
1
11

MONITOR
1051
10
1213
55
banking investment
depserv-capital
0
1
11

MONITOR
691
147
835
192
mortgage payments
mloan-payments-received
0
1
11

MONITOR
873
147
1014
192
loan payments
cloan-payments-received
0
1
11

MONITOR
1054
145
1220
190
banking payments
depserv-payments-received
3
1
11

PLOT
694
292
1239
619
Customer Payment Receipts
time (months)
Receipts ($'s)
0.0
360.0
0.0
0.0
true
true
"" ""
PENS
"mortgage payments" 1.0 0 -13345367 true "" ""
"loan payments" 1.0 0 -955883 true "" ""
"depositor payments" 1.0 0 -5825686 true "" ""

MONITOR
691
219
856
264
mortgage customers (blue)
mloans-count
17
1
11

MONITOR
875
217
1025
262
loan customers (orange)
cloans-count
17
1
11

MONITOR
1058
215
1238
260
banking customers (magenta)
banking-count
17
1
11

PLOT
224
465
664
620
Number of Customers
time (months)
customers (#)
0.0
360.0
0.0
0.0
true
true
"" ""
PENS
"mortgage customers" 1.0 0 -13345367 true "" ""
"loan customers" 1.0 0 -955883 true "" ""
"banking customers" 1.0 0 -5825686 true "" ""

MONITOR
690
78
803
123
mortgage reserve
mloan-reserve
17
1
11

MONITOR
873
78
962
123
loan reserve
cloan-reserve
0
1
11

MONITOR
1055
78
1159
123
banking reserve
depserv-reserve
0
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

This simple model explains the customer cash flow of a small community bank for 30 years since its inception. The Bank provides banking services (checking, savings accounts etc.), consumer loans (cars, home improvement etc.) and home mortgage loans. The bank sees a steady growth in cash flow through the first 10 years. At the 10-year mark the economy goes through a 10-year recession and the bank loses customers. The bank survives through the continued support of the investors and productivity increases. The economy goes through a boom at the 20-year mark fueling the banks recovery of lost customers and further growth.


## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

There are 5 types of agents: the bank, banking customers, mortgage customers, loan customers and investors. Each investor and customer interact with the bank. The bank cash flow from banking services, consumer loans and home mortgages accumulate cash at a consistent level through the 30-year operations shown in the model.


## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

The interface tab at its center shows a physical view of the model as a square. The square shows 1001 of its initial stakeholders in a 16 X 16 square view. The number of stakeholders in the view changes as their number changes. The dimensions of the square can be seen by pressing the settings button on the interface tab. The bank is a white building in an assigned location. The other 4 bank stakeholders are shown in a human shape at a random location with a color assigned to each stakeholder type. Green is assigned to an investor, blue to a mortgage customer, orange to a loan customer and magenta to a banking customer.

The model has a setup mode button and a go mode button to the left of the square. The model user needs to click on the setup button first. After the setup has completed, the user needs to click on the go button to run the model.

The investment at the inception of the bank is shown in the first top three buttons. The investors have a choice to invest in all 3 investment pools, 2 of them or just one not exceeding the investments needed. The bank reserves are shown in 3 buttons below the investment funds. The reserves are also provided by the investors as an investment into the bank.

The model runs for 360 months showing the accumulated cash every month. There are 3 buttons showing the incoming cash flow from mortgages, loans, and banking services fees respectively. The cash flow buttons are to the right of the square followed by a row of 3 buttons that show the number of mortgage, loan, and banking customers.

The buttons on the right of the square are followed by an accumulated cash flow graph by month for each one of the three revenue streams i.e., mortgage, loan and banking. As the model run completes, all 360 months are shown as a trend line in blue, orange, and magenta colors respectively. 

To the left of the cash flow graph and below the quadrant is a timeline of number of customers over the 360 months from inception through the recession and growth periods.  



## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

Some of things to notice as the model runs are the visuals in the interface tab. They are:

1. Customer counts and cash flow trend changes at the 120-month (10 year) and 240-month (20 year) anniversaries of banks operations. 

2. The cash flow graph shows a linear increase since the inception of the bank, then a linear decline followed by a stronger linear increase in the last 10 years.


## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

This is a simple Netlogo  model. It runs as described without any opportunity for the user to provide an input. The next few upgradees of the model will allow users the option to simulate different cash flow scenarios through different what if scenarios.

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

The following are proposed upgrades that can considered to allow users to do what if scenario testing. 

1. Customer count user input at bank startup, at the start of the recession and at the start of growth period.

2. Rate of the increase and decrease of customer counts e.g., step increase/decrease (current model), logistic increase or decrease etc.

3. Customer satisfaction measurement and its impact on the bank business allowing users to input customer satisfaction and magnitude of positive and negative revenue impact from it.

4. P & L statement of the bank and distribution of income to the investors allowing users to input annual return and bank services fees.



## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)

This model and its documentation are published at the Netlogo Modelling Commons at http://modellingcommons.org/. Access can be requested by providing a name, email and purpose of request to ststsi@outlook.com.


In addition to the Netlogo documentation which is very well done, the book "Agent-Based Modelling in Economics" by Lynne Hamill and Nigel Gilbert was a source of help to the author of this model.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.3.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
