globals [
brands  
A-brand
B-brand
C-brand
D-brand
E-brand
F-brand
G-brand
H-brand
p1                                                      ; parameter 1 in utility function
p2                                                      ; parameter 2 in utility function
p3                                                      ; parameter 3 in utility function
p4                                                      ; parameter 4 in utility function
p5                                                      ; parameter 5 in utility function
p6                                                      ; parameter 6 in utility function
p7                                                      ; parameter 7 in utility function
u_price
u_fhr
u_MPG
u_age
u_gender
u_income
temp-color
plot-sales-volume
A-sales-volume
B-sales-volume
C-sales-volume
D-sales-volume
E-sales-volume
F-sales-volume
G-sales-volume
H-sales-volume
total-sales-volume
A-market-share
B-market-share
C-market-share
D-market-share
E-market-share
F-market-share
G-market-share
H-market-share
]

breed [cars car]
breed [customers customer]
breed [dealers dealer]
breed [manufacturers manufacturer]

cars-own [
  price                                                  ; selling price, set by dealer at the beginning of each week
  front-head-room                                        ; vehicle attributes - front headroom in the utility function
  MPG                                                    ; vehicle attributes - mileage per gallon in the utility function
  sold?                                                  ; status, true = sold, false = for sale
  brand                                                  ; brand, responding to manufacturer
]

customers-own [
  age                                                    ; age, from 20 to 80
  gender                                                 ; gender, either female (1) or male (0)
  income                                                 ; annual household income, unit: 10k
  found-dealer?                                          ; indicates wether they found a dealer nearby
]

dealers-own [
  BSC                                                    ; brand specific constants in utility function, reflecting customers' preference in brands
  ccar-price                                             ; price of conventional car it offers
  ccar-front-head-room                                   ; front headroom of conventional car it offers
  ccar-MPG                                               ; MPG of conventional car it offeres
  inventory                                              ; inventory level, number of cars at the dealers
  sales-volume                                           ; sales volume this week
  revenue                                                ; revenue this week
  utility                                                ; utility value
]

manufacturers-own [
  sales-volume
  revenue
  inventory
]

;********************INITIALIZE********************
to setup 
  clear-all
  
  ;; initialize parameters
  initialize
  
  ;; set up brands
  set brands [red green brown yellow blue pink grey turquoise] ; at most 8 brands in the model
  
  ;; initialize manufacturers
  set-default-shape manufacturers "car"
  let i 0
  repeat number-of-manufacturers
  [
    create-manufacturers 1
    ask manufacturer i
    [
      set size 2
      setxy min-pxcor + 0.5 min-pycor - i + 8                  ; align manufacturers in the lower left corner
      set color item i brands
    ]
    set i (i + 1)
  ]
  ;; create dealers
  set-default-shape dealers "house"
  ask n-of number-of-dealers patches
  [
    sprout-dealers 1 
    [ 
      set size 1.8
      set color item random number-of-manufacturers brands     ; set to different color representing different brands
      set inventory random max-dealer-inventory                ; set initial inventory levels
      set sales-volume 0                                       ; starts with zero sales
      set revenue 0
      ;show inventory                                          ; #debug
      set-up-vehicle-data                                      ; set up vehicle data of each brand
    ]
  ]

  ;; create cars
  set-default-shape cars "car"
  
  ;set-default-shape manufacturers "manufacturer"
;  update-variables
  do-plots
end

;********************RUN********************
to go
  ;; old customers leave the market
  ask customers 
  [
   die
  ]
  
  ;; at the beginning of each sales week
  ask dealers
  [
    adjust-price
  ]

  ;; new customers enter the market
  initialize-customers
  ask customers
  [ 
    ask dealers
    [
      set utility -100000
    ]
    visit-dealers
    make-a-choice
  ]
  
  update-variables
  tick
  do-plots
end

;; initialize parameters
to initialize
  set A-brand 0
  set B-brand 0.1
  set C-brand 0.2
  set D-brand 0.3
  set E-brand 0.4
  set F-brand 0.5
  set G-brand 0.6
  set H-brand 0.7
  set p1 1
  set p2 (1 / 20000)
  set p3 (1 / 40)
  set p4 (1 / 22.5)
  set p5 (1 / 50)
  set p6 (1 / 0.5)
  set p7 (1 / 10)
end

; to set up vehicle attributes of each brand
to set-up-vehicle-data
  ifelse color = red
  [
   set BSC A-brand
   set ccar-price A-price
   set ccar-front-head-room A-front-head-room
   set ccar-MPG A-MPG   
  ]
  [
   ifelse color = green
   [
    set BSC B-brand
    set ccar-price B-price
    set ccar-front-head-room B-front-head-room
    set ccar-MPG B-MPG   
   ]
   [
    ifelse color = brown
    [
     set BSC C-brand
     set ccar-price C-price
     set ccar-front-head-room C-front-head-room
     set ccar-MPG C-MPG   
    ]
    [
     ifelse color = yellow
     [
      set BSC D-brand
      set ccar-price D-price
      set ccar-front-head-room D-front-head-room
      set ccar-MPG D-MPG   
     ]
     [
      ifelse color = blue
      [
       set BSC E-brand
       set ccar-price E-price
       set ccar-front-head-room E-front-head-room
       set ccar-MPG E-MPG   
      ]
      [
       ifelse color = pink
       [
        set BSC F-brand
        set ccar-price F-price
        set ccar-front-head-room F-front-head-room
        set ccar-MPG F-MPG   
       ]
       [
        ifelse color = grey
        [
         set BSC G-brand
         set ccar-price G-price
         set ccar-front-head-room G-front-head-room
         set ccar-MPG G-MPG   
        ]
        [
         set BSC H-brand
         set ccar-price H-price
         set ccar-front-head-room H-front-head-room
         set ccar-MPG H-MPG
        ]
       ]
      ]
     ]
    ]
   ] 
  ]
end

to adjust-price
  
end

to initialize-customers
  set-default-shape customers "person"
  create-customers number-of-customers
  [
   setxy random-xcor random-ycor
   set color white
   ifelse random 100 < 50
   [set gender 1]
   [set gender 0]
   set age (20 + random 60)
   set income (5 + random 10)
   set found-dealer? false
  ]
end

; customers visit the first 4 dealers they see
to visit-dealers
  ;let i 0
  repeat choice-set-size
  [
   while [not found-dealer?] 
   [
     wiggle
     if any? dealers-here
     [
       set found-dealer? true
     ]
   ]
   calculate-utility
   ;set i (i + 1)
   set found-dealer? false
  ]
end

to wiggle
  forward random 3
  rt (random 180 - 90)
end

;; calculate utility for customer i and brand j
to calculate-utility
  set u_age age
  set u_gender gender
  set u_income income
  ask one-of dealers-here
  [
    set utility ( p1 * BSC + p2 * ccar-price + p3 * ccar-front-head-room + p4 * ccar-MPG + p5 * u_age + p6 * u_gender + p7 * u_income + (random 100 / 100) )
  ]
end

; customers make a choice among 4 cars
to make-a-choice
  ask one-of dealers with-max [utility]
  [
    set sales-volume (sales-volume + 1)
    set revenue (revenue + ccar-price)
    ;show sales-volume
    set inventory (inventory - 1)
    ;show inventory
  ]
end

to update-variables
  set total-sales-volume sum [sales-volume] of dealers
  show total-sales-volume
  
    ask manufacturer 0
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set A-sales-volume sales-volume
      set A-market-share (A-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 1
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set B-sales-volume sales-volume
      set B-market-share (B-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 2
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set C-sales-volume sales-volume
      set C-market-share (C-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 3
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set D-sales-volume sales-volume
      set D-market-share (D-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 4
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set E-sales-volume sales-volume
      set E-market-share (E-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 5
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set F-sales-volume sales-volume
      set F-market-share (F-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 6
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set G-sales-volume sales-volume
      set G-market-share (G-sales-volume / total-sales-volume) * 100
    ]

    ask manufacturer 7
    [
      set temp-color color
      set sales-volume sum [ sales-volume ] of dealers with [color = temp-color] 
      set inventory sum [ inventory ] of dealers with [color = temp-color]
      set H-sales-volume sales-volume
      set H-market-share (H-sales-volume / total-sales-volume) * 100
    ]
    
end

to do-plots
  set-current-plot "sales-volume"

    set-current-plot-pen "1"
    plot A-sales-volume
    ;show A-sales-volume
    set-current-plot-pen "2"
    plot B-sales-volume
    ;show B-sales-volume
    set-current-plot-pen "3"
    plot C-sales-volume    
    set-current-plot-pen "4"
    plot D-sales-volume
    set-current-plot-pen "5"
    plot E-sales-volume    
    set-current-plot-pen "6"
    plot F-sales-volume    
    set-current-plot-pen "7"
    plot G-sales-volume    
    set-current-plot-pen "8"
    plot H-sales-volume
    
  set-current-plot "market-share"
    set-current-plot-pen "1"
    plot A-market-share
    set-current-plot-pen "2"
    plot B-market-share
    set-current-plot-pen "3"
    plot C-market-share   
    set-current-plot-pen "4"
    plot D-market-share
    set-current-plot-pen "5"
    plot E-market-share 
    set-current-plot-pen "6"
    plot F-market-share  
    set-current-plot-pen "7"
    plot G-market-share  
    set-current-plot-pen "8"
    plot H-market-share
end
@#$#@#$#@
GRAPHICS-WINDOW
300
15
973
709
25
25
13.0
1
10
1
1
1
0
1
1
1
-25
25
-25
25
0
0
1
ticks

BUTTON
20
15
83
48
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
90
15
153
48
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
20
50
170
83
number-of-dealers
number-of-dealers
0
100
80
1
1
NIL
HORIZONTAL

SLIDER
20
85
170
118
number-of-manufacturers
number-of-manufacturers
4
8
8
1
1
NIL
HORIZONTAL

SLIDER
20
120
170
153
max-dealer-inventory
max-dealer-inventory
50
100
50
1
1
NIL
HORIZONTAL

INPUTBOX
1010
10
1075
70
A-price
20000
1
0
Number

INPUTBOX
1080
10
1180
70
A-front-head-room
40
1
0
Number

INPUTBOX
1185
10
1235
70
A-MPG
25
1
0
Number

INPUTBOX
1010
75
1075
135
B-price
21000
1
0
Number

INPUTBOX
1080
75
1180
135
B-front-head-room
41
1
0
Number

INPUTBOX
1185
75
1235
135
B-MPG
25
1
0
Number

INPUTBOX
1010
140
1075
200
C-price
25000
1
0
Number

INPUTBOX
1080
140
1180
200
C-front-head-room
39
1
0
Number

INPUTBOX
1185
140
1235
200
C-MPG
23
1
0
Number

INPUTBOX
1010
205
1075
265
D-price
19000
1
0
Number

INPUTBOX
1080
205
1180
265
D-front-head-room
38
1
0
Number

INPUTBOX
1185
205
1235
265
D-MPG
23
1
0
Number

INPUTBOX
1010
270
1075
330
E-price
22000
1
0
Number

INPUTBOX
1080
270
1180
330
E-front-head-room
39.5
1
0
Number

INPUTBOX
1185
270
1235
330
E-MPG
24
1
0
Number

INPUTBOX
1010
335
1075
395
F-price
24000
1
0
Number

INPUTBOX
1080
335
1180
395
F-front-head-room
40.1
1
0
Number

INPUTBOX
1185
335
1235
395
F-MPG
24
1
0
Number

INPUTBOX
1010
400
1075
460
G-price
23000
1
0
Number

INPUTBOX
1080
400
1180
460
G-front-head-room
39.8
1
0
Number

INPUTBOX
1185
400
1235
460
G-MPG
22
1
0
Number

INPUTBOX
1010
465
1075
525
H-price
25000
1
0
Number

INPUTBOX
1080
465
1180
525
H-front-head-room
41.2
1
0
Number

INPUTBOX
1185
465
1235
525
H-MPG
22
1
0
Number

SLIDER
20
155
170
188
number-of-customers
number-of-customers
0
100
50
1
1
NIL
HORIZONTAL

SLIDER
20
190
170
223
choice-set-size
choice-set-size
2
6
4
1
1
NIL
HORIZONTAL

PLOT
20
230
220
380
sales-volume
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true
"1" 1.0 0 -2674135 true
"2" 1.0 0 -10899396 true
"3" 1.0 0 -6459832 true
"4" 1.0 0 -1184463 true
"5" 1.0 0 -13345367 true
"6" 1.0 0 -2064490 true
"7" 1.0 0 -7500403 true
"8" 1.0 0 -14835848 true

PLOT
20
385
220
535
market-share
NIL
NIL
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true
"1" 1.0 0 -2674135 true
"2" 1.0 0 -10899396 true
"3" 1.0 0 -6459832 true
"4" 1.0 0 -1184463 true
"5" 1.0 0 -13345367 true
"6" 1.0 0 -2064490 true
"7" 1.0 0 -7500403 true
"8" 1.0 0 -14835848 true

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.


HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1beta3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
