extensions [gogo]
breed [persons person]
breed [heats hot]
patches-own [ pheat border outside]
persons-own [ heat ]
heats-own [life cheat]
globals [ serial-port max_heat raw_height raw_width xlist ylist sum_heat room_heat room_size gogo_in_use]

to setup-gogo
   set serial-port user-one-of "Select a port:" gogo:ports
  gogo:open serial-port
  repeat 5
  [ if not gogo:ping
    [ user-message "The GoGo Board is not responding." ] ]
  gogo:talk-to-output-ports [ "a" "b" "c" "d" ]
  set gogo_in_use true
end
to setup
  clear-all
  set room_size (room-width * room-width)
  set xlist []
  set ylist []
  set sum_heat 0
  set room_heat 0
  create-campfire-people
  create-fire
  set raw_height (room-width / 2)
  set raw_width (room-width / 2)
  set gogo_in_use false
  draw-box
  initiate-people
  ;;show-heat
end

to add-people
   create-persons 1[
    set shape "person"
    set size 2
    set color brown
    set-random-direction
    set heat human-heat
    forward distance_from_center
    ]
   set people (count persons)
end

to go
  if (use-light-sensor) [set fire (gogo:sensor 1 > light-threshold)]
  find-people
  add-fire-heat
  ifelse activity[
  move-people
  radiate-heat
  absorb-heat]
  [add-heat
  radiate-heat
  absorb-heat]
  do-sums
  if (sum_heat < auto-cluster-threshold)
  [
    if (auto-cluster)
    [cluster-people]
  ]
  if room_heat < 0 [set fire true]
  do-plot
end

to cluster-people
  ask persons[
    facexy 0 0
    forward 1
  ]
end
to create-campfire-people
  create-persons people[
    set shape "person"
    set size 2
    set color brown
    facexy xcor max-pycor
    set heat human-heat
    ]
end

to create-fire
  if fire[
  ask patch 0 0 [ 
    set pheat 100
    set pcolor 15
  ]]
end

to draw-box
;;creating a bounding box based on the size of input
ask patches[ 
  if ((abs pxcor = raw_width and abs pycor <= raw_height) or (abs pycor = raw_height and abs pxcor <= raw_width))
  [set pcolor white
    set border true]
]
  
end


to initiate-people
  let angle (360 / people)
  let cpeople 0
  ask turtles[
    rt ( angle * cpeople )
     forward distance_from_center
     set cpeople (cpeople + 1)
    ]
end

to find-people
;;used to keep track of different turtle locations in the form of two lists
  ask persons[
    set xlist lput xcor xlist
    set ylist lput ycor ylist
  ]
end

to add-fire-heat
ifelse fire
[
  create-heats abs fire_heat [
    set shape "dot"
    set size 1
    set life 4
    set xcor 0
    set ycor 0
    ifelse (fire_heat > 0)
    [set cheat 1
      set color blue]
    [set cheat -1
      set color green
      set life 5]
    ]
  ]
  [
    if gogo_in_use[carefully [
      create-heats (1028 - gogo:sensor 1) [
        set shape "dot"
        set size 1
        set life 4
        set xcor ((random room-width) + (0 - raw_width)) 
        set ycor ((random room-width) + (0 - raw_height)) 
        set color blue
        set cheat 1
        ]
    ]
    []
    ]
   ]
end

to add-heat
  ;; add up the heat of each person and see how long it takes for the temperature in the room to change
  let iter 0
  
  repeat people
  [
    create-heats heat_rad[
    set shape "dot"
    set size 1
    set life 3
    set xcor (item iter xlist )
    set ycor (item iter ylist)
    set color blue
    set cheat 1
    ]
    set iter (iter + 1)
  ]
end

to radiate-heat
  ask heats [
    if (color != orange and color != white) 
    [set-random-direction]
    check-border
    if (color = white) [set life (life - 1) set cheat 0.75]
    if (life = 0) [die]
    if color = orange [set color white set cheat 0.75]
    if color = blue [ set color orange set cheat 0.9]
    if color = green [set life (life - 1)]
    ]
  ask persons [set heat (heat - (heat_rad))]
  ;; have each turtle emit some heat to the room
end

to absorb-heat
  ask persons [ 
    let hcount 0 
    ask patch-here [ask heats-here [ 
        if color = blue[set hcount (hcount + cheat)]
        if color = orange [ set hcount (hcount + cheat)]
        if color = white [set hcount (hcount + cheat)]
        die
        ]]
    ifelse activity[set heat (heat + hcount + (activity_level * room_heat))]
    [ set heat (heat + hcount + room_heat)]
  ]
  ifelse activity[set room_heat ((room_heat * room_size) - (count persons * room_heat * activity_level))]
  [set room_heat ((room_heat * room_size) - (count persons * room_size))]
  ;;have turtles absorb heat if the current patch has more heat than they do?
end

to set-random-direction
  facexy ((random 32) + -16)  ((random 32) + -16)
end


to check-border
  let checkcolor false
    ask patch-ahead 1[set checkcolor (pcolor = white)]
    ifelse checkcolor = false
    [forward 1]
    [set-random-direction]
end

to move-people 
  repeat activity_level [
    add-heat
    ask persons 
    [
      if activity[set-random-direction
      check-border]
      absorb-heat
     ]
    find-people
  ]
end

to do-sums
set sum_heat 0
set room_heat 0
set room_heat (room_heat * room_size)

ask persons[
  set sum_heat (sum_heat + heat)
]
ask heats[
  ifelse color = orange
  [set room_heat (room_heat + 1)]
  [set room_heat (room_heat + 0.5)]
]

set sum_heat (sum_heat / people)
set room_heat (room_heat / room_size)
end

to do-plot
  set-current-plot "people-heat"
  plot sum_heat
  set-current-plot "room-heat"
  plot room_heat
  set-current-plot "actual_heat"
  plot gogo:sensor 8
end
@#$#@#$#@
GRAPHICS-WINDOW
331
12
709
411
16
16
11.152
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks

BUTTON
83
11
156
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
11
50
183
83
room-width
room-width
6
20
10
2
1
NIL
HORIZONTAL

SLIDER
12
91
184
124
people
people
0
100
10
1
1
NIL
HORIZONTAL

SWITCH
109
327
199
360
fire
fire
0
1
-1000

BUTTON
12
10
75
43
NIL
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
10
425
88
470
NIL
sum_heat
17
1
11

MONITOR
102
424
185
469
NIL
room_heat
17
1
11

SLIDER
12
131
178
164
distance_from_center
distance_from_center
0
10
2
1
1
NIL
HORIZONTAL

SWITCH
10
328
100
361
activity
activity
1
1
-1000

INPUTBOX
226
48
283
108
heat_rad
15
1
0
Number

SLIDER
12
168
184
201
activity_level
activity_level
1
5
1
1
1
NIL
HORIZONTAL

SLIDER
11
211
183
244
fire_heat
fire_heat
-200
200
50
1
1
NIL
HORIZONTAL

BUTTON
170
11
265
44
NIL
setup-gogo
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SWITCH
203
326
316
359
auto-cluster
auto-cluster
1
1
-1000

MONITOR
9
371
102
416
NIL
gogo:sensor 8
1
1
11

MONITOR
114
371
207
416
NIL
gogo:sensor 1
1
1
11

BUTTON
202
110
296
143
NIL
add-people
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
199
149
309
182
NIL
cluster-people
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

MONITOR
224
374
317
419
NIL
gogo:sensor 2
17
1
11

PLOT
710
15
910
165
people-heat
ticks
heat
0.0
10.0
0.0
10.0
true
false
PENS
"human_heat" 1.0 0 -11221820 true

PLOT
710
330
910
480
room-heat
heat
ticks
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

SWITCH
12
292
156
325
use-light-sensor
use-light-sensor
1
1
-1000

PLOT
711
173
911
323
actual_heat
heat
ticks
0.0
10.0
0.0
10.0
true
false
PENS
"default" 1.0 0 -16777216 true

SLIDER
9
255
149
288
light-threshold
light-threshold
0
1000
599
1
1
NIL
HORIZONTAL

SLIDER
153
253
331
286
auto-cluster-threshold
auto-cluster-threshold
0
200
75
1
1
NIL
HORIZONTAL

INPUTBOX
213
191
295
251
human-heat
150
1
0
Number

@#$#@#$#@
WHAT IS IT?
-----------
Bundling turtles is a simulation that allows for students to explore why it's best to huddle up when you're code. The simulation also has sensor based components that can work with a GoGo Board. The model was designed to approach this problem from a altogether non-scientifically rigorous perspective. It does not contain any mathematical equations. Instead it provides a space for students to learn about heat transfer outside of the formulaic work that they see in school.


HOW IT WORKS
------------
The simulation allows the user to adjust the number of people, size of the room, level of activity, the presence of a fire, the amount of heat generated by the fire, and the amount of heat radiated by each individual. It also has build in features for doing automatic people clustering. The user can adjust these different sliders to get a better understanding of how certain aspects of heat radiation and absorption work. Additionally, there is a bifocal modeling component that leverages a temperature probe. Using this probe students can get a group of their friends and try to create a computer model that matches their behavior.


HOW TO USE IT
-------------
Press the gogo-setup button, select the appropriate port.
Adjust the parameters as you please and then press go.


THINGS TO NOTICE
----------------
One thing to notice is that all of the parameters have different impacts on how warm people feel. 

THINGS TO TRY
-------------
Try making a change to a single slider while holding everything else constant to see how the different parameters affecting the model. You may also like to set up something in behaviorspace that allows you to easily watch what's taking place.


EXTENDING THE MODEL
-------------------
1. Adding a more accurate unit comparison for temperature and time. These would help in the bifocal modeling aspect and allow you to go more in depth on the numerical differences that may occur in the real world but are omitted from the simulation.

2. Add a fan to the room so that it can start to cool off if things get to hot. This would be quite easy to also add to the gogo board.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="30"/>
    <metric>sum_heat</metric>
    <metric>room_heat</metric>
    <enumeratedValueSet variable="auto-cluster">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="room-width">
      <value value="10"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activity_level">
      <value value="1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="activity">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fire">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="fire_heat">
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="use-light-sensor">
      <value value="false"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="people">
      <value value="10"/>
      <value value="2"/>
      <value value="50"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="heat_rad">
      <value value="15"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="distance_from_center">
      <value value="3"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
