globals [ business-cycle-count wage-cycle costs-cycle unemployed-list ]

turtles-own [ wage expenditures unemployed? ]

patches-own [ average-wage original-wage average-costs original-costs original-available-jobs available-jobs city-num]

to setup
  ca
  ask n-of number-cities patches [ ;setting up cities
    set pcolor red 
    set average-costs random 10
    set original-costs average-costs
    ;set average-wage random 10
    set average-wage random-float random-wage-cost-seed + original-costs ;setting staring wage to be at least greater than the costs
    set original-wage average-wage
    set original-available-jobs random 20 + 1
    set available-jobs original-available-jobs
    set city-num 0
    ] ;assign it a different color
  set business-cycle-count 0
  let counter 1
  while [ counter < number-cities + 1 ] [ ; workaround to set each city a different number label "city-num"
    ask one-of patches with [ pcolor = red and city-num = 0 ] [ set city-num counter ]
    set counter counter + 1 
  ] 
  create-turtles number-workers [ ;worker setup
    setxy random-xcor random-ycor 
    set wage random 10
    set expenditures random 10
    set shape "person"
    face one-of patches with [ pcolor = red and available-jobs > 0] 
    set unemployed? false ]
  set unemployed-list (list 0)
  setup-available-job-plot
  setup-attractive-city-plot
  setup-business-cycle-plot
  update-available-job-plot
  update-attractive-city-plot
  update-business-cycle-plot
end

to go
  ask turtles [ 
    update-worker-parameters
    stay-or-go ]
  
  ask patches with [ pcolor = red ] [ update-city-parameters move-too-many-workers]
  update-business-cycle
  tick
  update-available-job-plot
  update-attractive-city-plot
  set business-cycle-count business-cycle-count + 1 ;updating the tick counter so the business cycle can change over time
  update-business-cycle-plot
end

to update-city-parameters ; patch function
  ; used to change the wages and costs at the given city. each worker at that city adds a cost-increase to costs and removes a wage-decrease from wages
  ; here is also where the wages and costs are scaled to account for the business cycles
   set available-jobs ( original-available-jobs - ( count turtles-here ) )
   ifelse apply-business-cycle? [
     set average-wage ( original-wage - ( ( original-available-jobs - available-jobs ) * wage-decrease-per-additional-worker ) ) * wage-cycle
     set average-costs ( original-costs + ( ( original-available-jobs - available-jobs ) * cost-increase-per-additional-worker ) ) * costs-cycle] 
   [ set average-wage ( original-wage - ( ( original-available-jobs - available-jobs ) * wage-decrease-per-additional-worker ) )
     set average-costs ( original-costs + ( ( original-available-jobs - available-jobs ) * cost-increase-per-additional-worker ) )]
end

to update-worker-parameters ; turtle function
  set wage [ average-wage ] of patch-here
  set expenditures [ average-costs ] of patch-here
end

to move-too-many-workers ; patch function
  let num-movers (-1 * ( original-available-jobs - (count turtles-here) ) ) ;finding the number of workers that need to leave this city
  if num-movers < 0 [ set num-movers 0 ] ; must be a positive number
  let temp one-of patches with [ pcolor = red and available-jobs > 0 ]
  if is-patch? temp [ ifelse [ average-wage ] of temp - [ average-costs ] of temp - wage-decrease-per-additional-worker + cost-increase-per-additional-worker > 0 [ ] [ set temp 0 ] ]
  ; if the patch where they want to go can hold them there, then they can go, or else try again another time
  if ( pcolor = red and available-jobs < 0 ) or ( pcolor = red and ( average-wage - average-costs ) < 0 ) [ ask n-of num-movers turtles-here [ ifelse is-patch? temp [ move ] [ go-unemployed ]] ]
  ; if there are no available jobs at your current city or you're paying more in costs than you're earning, then you have to leave. if there's nowhere else that satisfies that
  ; then you become unemployed
end

to go-unemployed ; turtle function
  set unemployed? true
  face one-of patches with [ pycor > 10 ] move
end

to stay-or-go ; turtle function
  let temp one-of patches with [ pcolor = red and available-jobs > 0 and ( average-wage - average-costs > 0 ) ] ;find a suitable new city
  ifelse unemployed? [ if is-patch? temp [ face temp move ] set unemployed? false] [ ] ; if you are unemployed face this suitable city and move to it and become employed
  if [ pcolor ] of patch-here != red and not unemployed? [ move ] ; if you're not at a city but aren't unemployed then keep moving to the city you had turned to face
  if ( [ pcolor ] of patch-here = red and ( wage - expenditures ) < 0 ) [ if is-patch? temp or is-patch-set? temp [face temp move ] ] ;if you can't sustain your lifestyle at your current city, leave
  if [ pcolor ] of patch-here = red and ( wage - expenditures ) > 0 [ ] ; stay if you can sustain
end

to stay ;turtle function

end

to move ;turtle function
  fd 1
end

to update-business-cycle
  set wage-cycle cos ( business-cycle-count * 0.1 ) + 1.03 * business-cycle-count * 0.0005 + .15 ; bunch of scaling here to get the correct business cycle
  set costs-cycle 1.03 * business-cycle-count * 0.0005 ; no cosine function for costs-cycle
end

to setup-available-job-plot
  set-current-plot "Available Jobs"
  set-plot-y-range 0 ( [original-available-jobs ] of max-one-of patches [ original-available-jobs ] + 3)
  let counter 1
  while [ counter < number-cities + 1 ] [ ;plot all the cities (which is a slider variable). this is a workaround
    create-temporary-plot-pen word "City " counter 
    set-current-plot-pen word "City " counter
    set-plot-pen-color one-of base-colors 
    set counter counter + 1 ]
end

to update-available-job-plot
  set-current-plot "Available Jobs"
  let counter 1
  while [ counter < number-cities + 1 ] [
    set-current-plot-pen word "City " counter 
    plot first [ available-jobs ] of patches with [ city-num = counter ]
    set counter counter + 1 ]
end

to setup-business-cycle-plot
  set-current-plot "Business Cycle"
end

to update-business-cycle-plot
  if apply-business-cycle? [
    set-current-plot "Business Cycle"
    set-current-plot-pen "wage-cycle"
    plot wage-cycle
    set-current-plot-pen "costs-cycle"
    plot costs-cycle
    set-current-plot-pen "unemployed"
    plot count turtles with [ unemployed? ] 
    set unemployed-list lput count turtles with [ unemployed? ] unemployed-list ] ; adding the list together for the BehaviorSpace model
end

to setup-attractive-city-plot
  set-current-plot "Most Attractive City"
end

to update-attractive-city-plot
  set-current-plot "Most Attractive City"
  set-current-plot-pen "attractive-wages"
  let temp max-one-of patches [ original-wage - original-costs ] ; city that is most attractive
  plot [ average-wage ] of temp
  set-current-plot-pen "attractive-expenditures"
  plot [ average-costs ] of temp
  set-current-plot-pen "least-attractive-wages"
  set temp min-one-of patches with [ pcolor = red ] [ original-wage - original-costs ] ; city that is least attractive
  plot [ average-wage ] of temp
  set-current-plot-pen "least-attractive-expenditures"
  plot [ average-costs ] of temp
end
@#$#@#$#@
GRAPHICS-WINDOW
590
13
1029
473
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks

BUTTON
45
265
108
298
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
155
265
218
298
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
15
10
260
43
number-cities
number-cities
0
10
5
1
1
NIL
HORIZONTAL

SLIDER
15
130
260
163
wage-decrease-per-additional-worker
wage-decrease-per-additional-worker
0
1
0.1
.05
1
NIL
HORIZONTAL

SLIDER
15
170
260
203
cost-increase-per-additional-worker
cost-increase-per-additional-worker
0
1
0.1
.05
1
NIL
HORIZONTAL

PLOT
272
17
585
205
Available Jobs
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"default" 1.0 0 -13345367 false

PLOT
273
231
587
410
Most Attractive City
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"attractive-wages" 1.0 0 -2674135 true
"attractive-expenditures" 1.0 0 -8053223 true
"least-attractive-wages" 1.0 0 -13345367 true
"least-attractive-expenditures" 1.0 0 -13791810 true

PLOT
10
315
264
465
Business Cycle
NIL
NIL
0.0
10.0
0.0
10.0
true
true
PENS
"wage-cycle" 1.0 0 -16777216 true
"costs-cycle" 1.0 0 -13345367 true
"unemployed" 1.0 0 -8630108 true

SLIDER
15
90
260
123
random-wage-cost-seed
random-wage-cost-seed
0
10
5
1
1
NIL
HORIZONTAL

SLIDER
15
50
260
83
number-workers
number-workers
1
100
50
1
1
NIL
HORIZONTAL

SWITCH
45
220
217
253
apply-business-cycle?
apply-business-cycle?
0
1
-1000

@#$#@#$#@
WHAT IS IT?
-----------
Unskilled workers, by definition, do not have a specialized skill to accell in. This normally includes under-educated high school dropouts or graduates. The uniqueness about these workers is their ability to move between areas where they will receive the most utility. If there are no jobs left in the city the worker is currently living, or if they cannot sustain their own lifestyle in that city, they may choose to leave.

This unskilled workers movement model simulates how real world economic changes affect the movement in an attempt to find labor. This model allows for migration between multiple different cities, depending on wage, costs of living, and job availability. As these unskilled workers come and go from city to city, parameters and economic conditions alter. At a certain point, it no longer becomes sustainable and efficient for these workers to remain at their current location and they choose to move. This movement is very easy for them, as unskilled labor is something that is available in many cities.


HOW IT WORKS
------------
The workers and cities' economic conditions interact with each other. If there are available jobs in a particular city and the wages they will receive will be greater than the costs expended in that city, then the worker will move to that city. If their lifestyle is sustainable in their current city, i.e. the costs in that city are less than the wage they receive, they will stay. However, as more workers flock to this more desirable city, supply of labor increases, driving costs of living higher and wages lower. Additionally, wages and costs in each of these cities are affected by business-cycles. Wages conform to a cos(x) + x function, where costs increase linearly.


HOW TO USE IT
-------------
First, setup the number of cities and number of workers desired using the given sliders. Random-wage-cost-seed is the basis for determining the difference between costs and wages per city. Using this parameter, a random number is generated and is added to the original costs of that city and assigned to that city's wages. This allows for an initial setup of wages to always be greater than the costs in that city. The two final sliders allow the model to adjust the cities' average-costs and average-wages depending on the number of people currently working in that city. The higher the wage-decrease-per-additional-worker, the less the average wage in that city is, and vice versa for cost-increase.


THINGS TO NOTICE
----------------
While watching the business cycle plot, take a look at how when the oscillating wage-cycle is greater than the cost-cycle, homelessness decreases. Also, when comparing the business cycle to the available jobs plot, watch and see how in times of expansion (wage-cycle greater than cost-cycle) that people the number of available jobs stays constant. Workers are more likely to stay in place because their lifestyle is sustainable.


THINGS TO TRY
-------------
Try moving around the random-wage-cost-seed. At what values does this seed start to generate less movement from the workers? Why do you think this happens?

When turning off apply-business-cycle?, what do you notice as the differences between the models when on vs off?


EXTENDING THE MODEL
-------------------
In addition to wage and cost of living changes depending on an economic business cycle, an extension to this model could also include changes to available jobs in each of the cities.

In economic terms, there is no set amount that wage decreases or costs increase per each additional workers. This model could be extended to include a better-scaled estimate of how supply and demand for labor and goods are altered according to number of occupants in that city.

This model uses very rudimentary numbers to estimate wages and costs. An extension to this model could include real numbers from empirical data, where wages and costs of living are more accurate and are altered accordingly.


NETLOGO FEATURES
----------------
As part of this model, there is a plot included that draws all available jobs in each city. This was only possible by using the create-temporary-plot-pen, which was looped through depending on the total number of cities the user has chosen. In order to plot each of these cities' available jobs, this model also uses a looping procedure which initializes a city-num parameter (from 1 to number-cities, inclusive).


RELATED MODELS
--------------
The Urban Suite model located in the NetLogo Models Library explores land-usage patterns from an economic perspective, where agents choose where to live depending on various parameters.


CREDITS AND REFERENCES
----------------------
N/A
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="unemployed" repetitions="10" runMetricsEveryStep="false">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="1000"/>
    <metric>mean unemployed-list</metric>
    <enumeratedValueSet variable="wage-decrease-per-additional-worker">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="cost-increase-per-additional-worker">
      <value value="0.1"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="apply-business-cycle?">
      <value value="true"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-workers">
      <value value="50"/>
    </enumeratedValueSet>
    <steppedValueSet variable="random-wage-cost-seed" first="0" step="1" last="10"/>
    <enumeratedValueSet variable="number-cities">
      <value value="5"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
1
@#$#@#$#@
