breed [ males BP_male]
breed [ females BP_female]
breed [ BAR bar_staff ]
breed [ Tablefour four_top ]
breed [ TableEight eight_top  ]
breed [ barstools barstool]
breed [ customers customer]



globals
[
 MensRoom
 WomensRoom
 DanceFloorCor
 CurrentBarValue
 AVGBarValue
 Crowd
 BestGuy
 BestGirl
 NetworkB
 NetworkG
 AVGDrinkCount
]

patches-own
[
 obstacle
 openspace
 BarCounter
 DrinkPoints
 Swarm
]

customers-own
[
  power
  path
  BarCoordinates
  powerrank
  placeinlist
  gender
  bladderrate
  drinkcount
  stuck
  drinkconsume
  drinkhand
  bathroom
  rate
  dance
  danceCor
  single
  seat
  looks
  crush
  numfollowingme
 
]


Bar-own
[
  DrinkMakingRate  
  CurrentDrinks
]

to Floor_Plan
  clear-all
  
  set-patch-size 15
  resize-world 0 60 0 60
  ask patches [set pcolor black]
 
  ifelse( file-exists? "bar_floor_plan.txt")
  [
    file-open "bar_floor_plan.txt"
    while [not file-at-end?]
    [
      let next-x file-read
      let next-y file-read
      let next-color file-read
      ask patch next-x next-y [set pcolor next-color]
    ]
    user-message "Bar Floor Plan Loaded Correctly!"
    file-close
  ]
  [ user-message "**ERROR** Cannot find the file: bar_floor_plan.txt in the current directory"]

  set WomensRoom patch 48 44
  set MensRoom patch 52 44
  ask patches with [pcolor = 9.9]
  [
    set obstacle 1
  ]
  ask patches with [pcolor = 6]  
  [
    set obstacle 1
  ]
  ask patches with [pcolor = 35]
  [
    set Barcounter 1
    set drinkpoints 30
  ]
  set avgbarvalue 0 
  set AVGDrinkCount 0
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to default
  Floor_Plan
  ifelse( file-exists? "dance_floor.txt")
  [
    file-open "dance_floor.txt"
    while [not file-at-end?]
    [
      let next-x file-read
      let next-y file-read
      let next-color file-read
      ask patch next-x next-y [set pcolor next-color]
    ]
    user-message "Dance Floor Loaded Correctly!"
    file-close
  ]
  [ user-message "**ERROR** Cannot find the file: dance_floor.txt in the current directory"]
  setupTablesDefault
  Setup-people
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to SetupTablesDefault
  set-default-shape Tablefour "square"
  set-default-shape barstools "dot"
  create-Tablefour 10 
  ask Tablefour [
    set size 2.5
    set color 45
    setxy 45 10
  ]
  set-default-shape TableEight "square"
  create-TableEight 4 
  ask TableEight [
    set size 4
    set color 26
    setxy 48 10
  ]
 ask four_top 1 [
   setxy 17 37]
 ask four_top 2 [
   setxy 17 42
 ]
 ask four_top 3 [
   setxy 17 47
 ]
 ask four_top 0 [
   setxy 11 47
 ]
 ask four_top 4 [
   setxy 11 42
 ]
 ask four_top 5 [
   setxy 11 37
 ]
 ask four_top 6 [
   setxy 27 37
 ]
 ask four_top 7 [
   setxy 27 31
 ]
 ask four_top 8 [
   setxy 27 26
 ]
 ask four_top 9[
   setxy 27 21
 ]
 ask eight_top 10 [
   setxy 38 15
 ]
 ask eight_top 11 [
   setxy 38 21
 ]
 ask eight_top 12 [
   setxy 38 27
 ]
 ask eight_top 13 [
   setxy 38 33
 ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to SetupTables
  set-default-shape Tablefour "square"
  set-default-shape barstools "dot"
  create-Tablefour Num_Four_Top_Tables 
  ask Tablefour [
    set size 2.5
    set color 45
    setxy 45 10
  ]
  set-default-shape TableEight "square"
  create-TableEight Num_Eight_Top_Tables 
  ask TableEight [
    set size 4
    set color 26
    setxy 48 10
  ]
  if (Num_Four_Top_Tables > 1)
  [
    let i 0
    let y4t 10
    while [i < Num_Four_Top_Tables]
    [
      ask four_top i [
        setxy 45 y4t]
      set i i + 1
      set y4t y4t + 2.5
    ]
  ]
  if (Num_Eight_Top_Tables > 1)
  [
    let i count Tablefour
    let y4t 10
    while [i < Num_Four_Top_Tables + Num_Eight_Top_Tables]
    [
      ask eight_top i [
        setxy 48 y4t]
      set i i + 1
      set y4t y4t + 3.5
    ]
  ]
  let tag1 0
  let tag2 0
  
  ask four_top (Num_Four_Top_Tables - 1) [                       
    set tag1 ycor + 2]
  ask eight_top (Num_Four_Top_Tables + Num_Eight_Top_Tables - 1) [
    set tag2 ycor + 2]
  
  ask patch (46) (tag1) [
    set plabel-color black
    set plabel "4-Tops"
  ]
  
  ask patch (48) (tag2) [
    set plabel-color black
    set plabel "8-Tops"
  ]
  ask patch 49 40 [
    set plabel-color black
    set plabel "TABLES CHOICES"
  ] 
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to MoveTables
  
  if mouse-down? [
    let pickup4 min-one-of Tablefour [distancexy mouse-xcor mouse-ycor]
    let pickup8 min-one-of TableEight [distancexy mouse-xcor mouse-ycor]
    let pick4 [distancexy mouse-xcor mouse-ycor] of pickup4
    let pick8 [distancexy mouse-xcor mouse-ycor] of pickup8
    while [mouse-down?] [
      ifelse (pick4 < pick8)
          [
            ask pickup4 [ 
              setxy (round mouse-xcor) (round mouse-ycor)
            ]
          ][ask pickup8 [setxy (round mouse-xcor) (round mouse-ycor)]]
      display
    ]
  ]
end
    
;;///////////////////////////////////////////////////////////////////////////////////////////////
to Erasedance
    ask patches with [pcolor = 114]
    [
      set pcolor black
    ]     
    set dancefloorcor nobody
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Dancefloor
  if (mouse-down?)
    [
      let TX round mouse-xcor
      let TY round mouse-ycor
      ask patch TX TY [
        if (pcolor = black)
        [
          set pcolor 114]
        ]
    ]  
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Setup-people  
  reset-ticks
  GenerateBarStools
  set dancefloorcor one-of patches with [pcolor = 114]
    ask patches with [pcolor = black]
  [
    if (not any? turtles-here)
    [set openspace 1
    ]
  ]
  set-default-shape customers "person"
  set-default-shape BAR "person service"
  set-default-shape TableEight "square"
  
  ask n-of Patrons (patches with [pcolor = black and pycor < 25 ])
  [
    if not any? turtles-here
    [
      sprout-customers 1 [
        set path (list (patch (6 + random 36) 52) (patch (7 + random 35) 52) (patch (8 + random 34) 52) (patch 40 52) (patch (10 + random 32) 52))
        set power (list (1 + random 20) (1 + random 20) (1 + random 20) (1 + random 20) (1 + random 20) )
        set powerrank (list 0 0 0 0 0)
        calculateRanking
        
        set heading random 360
        set color blue
        set size 2
        set drinkcount 0
        set gender 1
        set bathroom MensRoom
        set drinkconsume .99
        set bladderrate .4
        set rate 3.1 + random-float .5
        set dance 0
        set dancecor dancefloorcor
        set single 1
        set looks (30 + random 71)
        set crush nobody
      ]
    ]
  ]
  ask n-of (round (( PercentageFemale / 100) * Patrons)) customers [
    set  gender 0
    set color pink
    set rate 2.1 + random-float .5
    set bathroom WomensRoom
    set dance 1
  ]
ask n-of (0.57 * patrons) customers [
  set single 0
]
  ask n-of Number_staff (patches with [pcolor = 6])
    [
      sprout-BAR 1 [set heading random 360
    set color white
    set size 2
    set drinkmakingrate (skills * (1 + random-float 1))
    set CurrentDrinks 0
      ]
    ]  
  set bestguy nobody
  set bestgirl nobody
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to GenerateBarStools

 ask Tablefour [
   if ((xcor < 42) and (xcor > 5 ) and (ycor > 10) and (ycor < 60))
   [
     let i 0
     ask patch-here[
       set pcolor 9.9 
       set obstacle 1 ]
     ask neighbors4[
       set pcolor 9.9
       set obstacle 1]
     while [i < 4 ]
     [
      hatch-barstools 1 [
        set size 2
        set color 8
        set heading (i * 90)
        forward 1.75
      ]    
       set i i + 1
     ]
   ]
 ]
 ask Tableeight [
   if ((xcor < 42) and (xcor > 5 ) and (ycor > 10) and (ycor < 60))
     [   
       let i 0
       ask neighbors [
         set pcolor 9.9
         set obstacle 1]
       while [i < 4 ]
         [
           hatch-barstools 1 [
             set size 2
             set color 8
             set heading (i * 90)
             forward 2
             right 90
             forward 0.5
             left 180 
             hatch-barstools 1 [
               forward 1
             ]
           ]
         set i i + 1
         ]
     ]
 ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to GO
  DoCalculations
  ask customers [
    routine
    set numfollowingme count customers with [crush = myself]
  ]
  
  ask Bar [
    staff-routine
  ]

  if (any? patches with [swarm > 1])
    [ 
      diffuse swarm 0.75
      RecolorCrowd
    ]
  tick
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to DoCalculations
  if (bestguy != nobody)
  [
    set networkB (sum [numfollowingme] of customers with [crush = bestguy]) + (count customers with [crush = bestguy])
    set networkG (sum [numfollowingme] of customers with [crush = bestgirl]) + (count customers with [crush = bestgirl])
  ]
  set CurrentBarValue sum [drinkpoints] of patches with [pcolor = 35]
  set AvgBarValue mean [drinkpoints] of patches with [pcolor = 35]
  set Crowd max-one-of patches [count customers in-radius 10]
  set AvgDrinkCount mean [drinkcount] of customers
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to MarkBestLooking
  set BestGuy max-one-of (customers with [gender = 1]) [looks]
  ask bestguy [
    set shape "Markedmale"
    set size 2
  ]
  set Bestgirl max-one-of (customers with [gender = 0]) [looks]
  ask bestgirl [
    set shape "markedfemale"
    set size 2
  ]
end
;;///////////////////////////////////////////////////////////////////////////////////////////////
to Routine
  Intoxicated
  ifelse (bladderrate > 20)
    [
      face bathroom
      checkobstacle
      BathRoomFunction
    ]
    [
      ifelse (drinkhand < 1.5)
      [ 
        usememory
        face BarCoordinates
        checkobstacle
        BarCounterFunction (BarCoordinates)
      ]
      [
        ifelse (single = 0)
        [
          FindBarstool
        ]
        [
          ifelse (single = 1) and (drinkcount < Drinks_till_dance)
          [
            finddate
            ConsumeDrink
            checkobstacle
          ]
          [
            if (gender = 1) and (crush != nobody)
            [
              set dance 1
            ]
            
            ifelse (dance = 1) and (drinkcount >= Drinks_till_Dance)
            [
              ifelse any? patches with [pcolor = 114]
                [
                  face dancecor
                  checkobstacle
                  danceaway
                  ConsumeDrink
                ]
                [set dance  0]
                ]
                [ConsumeDrink
                checkobstacle
                ]
            ]
          ]
        ]
      ]
            
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Intoxicated
  if (gender = 1) and (drinkcount > max_drinks_male)
  [
    hatch 1 [
      set crush nobody
      set drinkcount 0
      set rate 3.1 + random-float .5
      set dance 0
      set dancecor dancefloorcor
      set single random 2
      set looks (30 + random 71)
      set bladderrate .4
      set numfollowingme 0
      set shape "person"
    ]
      
    ask self [die] 
  ]
  if (gender = 0) and (drinkcount > max_drinks_male)
  [
    hatch 1 [
      set crush nobody
      set drinkcount 0
      set rate 2.1 + random-float .5
      set dance 1
      set dancecor dancefloorcor
      set single random 2
      set looks (30 + random 71)
      set bladderrate .4
      set numfollowingme 0
      set shape "person"
      ]
    ask self [die]
    ]
  
  
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Checkobstacle 
    ifelse ([obstacle] of patch-ahead 1 != 1) and (not any? customers-on patch-ahead 1)
    [
        walkabout
        set stuck 0 
    ]
    [ 
      ifelse (stuck > 2)
      [
        while [[obstacle] of patch-ahead 1 = 1]
        [
          right random-float 90
        ]
        walkabout
        while [[obstacle] of patch-ahead 1 = 1]
        [
          left random-float 180
          set stuck 0
        ]
        walkabout
      ]
      [
        left random-float 90 
        set stuck stuck + 1
        checkobstacle
      ]
    ]
   
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Danceaway
  if (patch-here = dancecor)
  [
    right random-float 360
    checkobstacle
    forward random-float 1
    back random-float 1
    left random-float 360
    checkobstacle
    forward random-float 1
    back random-float 1
    if (gender = 0)
    [
      set color scale-color pink drinkhand 20 0 
    ]
    if (gender = 1)
    [
      set color scale-color blue drinkhand 20 0
    ]
    set dancecor one-of patches with [pcolor = 114]
  ]
end

;;////////////////////////////////////////////////////////////////////////////////////////////////
to FindBarstool
  ifelse (any? barstools-here) 
  [
    ConsumeDrink
  ][
  checkobstacle
  if(any? barstools in-cone 4 160)
  [
    set Seat min-one-of barstools [distance myself]
    face Seat
    ConsumeDrink
    checkobstacle
  ]
  ]  
end

;;////////////////////////////////////////////////////////////////////////////////////////////////
to FindDate
 
  
  if (gender = 0)
  [
    if (crush = nobody) and (any? customers in-radius Look_Vision with [gender = 1])
    [
      let potentiallist customers in-radius Look_Vision with [gender = 1]
      let tempA max-one-of potentiallist [looks]
      let theirlooks 0
      ask tempA [
        set theirlooks looks
      ]
      if (theirlooks >= looks ); and (theirlooks <= (looks + drinkcount * 3 ))
      [
        set crush tempA 
      ]
    ]
  ]
  
  if (gender = 1)
  [
    if (crush = nobody) and (any? customers in-radius Look_Vision with [gender = 0])
    [
      let potentiallist customers in-radius Look_Vision with [gender = 0]
      let tempA max-one-of potentiallist [looks]
      let theirlooks 0
      ask tempA [
        set theirlooks looks
      ]
      if (theirlooks > looks); and (theirlooks < (looks + drinkcount * 3))
      [
        set crush tempA  
      ]
    ]
  ]
  if (crush != nobody)
  [
    face crush
    if (any? customers in-radius 5 = crush)
    [
      right random-float 90
    ] 
  ]

end

;;////////////////////////////////////////////////////////////////////////////////////////////////
to Walkabout
forward random-float 1
end

;;////////////////////////////////////////////////////////////////////////////////////////////////
to ConsumeDrink
  let waste drinkhand
  set drinkhand (drinkhand * drinkconsume) 
  set waste ((waste - drinkhand) / rate)
  set bladderrate bladderrate + waste  
  
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to WhereIsCrowd
  ask crowd [
    set swarm 10]
  diffuse swarm 0.75
  RecolorCrowd
  
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to RecolorCrowd
  ask patches with [swarm > 0]
   [
     if (openspace = 1)
     [
       set pcolor scale-color red swarm 0 10
     ]
   ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to BathRoomFunction
  if (patch-here = bathroom) 
  [
    set bladderrate (bladderrate / (1 + random 20))
  ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to BarCounterFunction [Coordinates]
  let BC 0

  if (patch-here = Coordinates) 
  [

    ask patch-here
      [
        ifelse (drinkpoints > 25)
        [
          
          set drinkpoints 0
          set BC 25
        ][
       
        set BC drinkpoints
        set drinkpoints 0
        ]
      ]
    set drinkhand drinkhand + BC
    set drinkcount drinkcount + (BC / 25)
    ifelse (BC < 25)
      [
        let pvalue (random 21) + 5
        let pathvalue patch (10 + random 10) (52) 
        let ranvalue (random-float 1) * pvalue
        let PowNew rebuildlist(power)
        let PatNew rebuildlist(path)
        let RanNew rebuildlist(powerrank)
        set PowNew lput pvalue PowNew
        set PatNew lput pathvalue PatNew
        set RanNew lput ranvalue RanNew       
        set power PowNew
        set path PatNew
        set powerrank RanNew
        calculateranking
      ][ set power lput [BC] of patch-here power
      set power but-first power
      set path lput patch-here path
      set path but-first path
      calculateRanking
      ]
     
  ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to CalculateRanking
  let n 0
  let large patch-here
  let x1 0
  let y1 0
  let mydist 0
  let distrank (list 0 0 0 0 0)
  while [n < 5]
  [
    set large item n path
    ask large [ 
      set x1 pxcor
      set y1 pycor
    ]
    set mydist distancexy x1 y1  
    set mydist (1.00 / (mydist + .1))
    set distrank lput mydist distrank
    set distrank but-first distrank
    set n n + 1
  ]
  set powerrank (map + (distrank)(power))
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to-report Rebuildlist [finlist]
  let T1 sublist finlist 0 placeinlist
  let T2 sublist finlist (placeinlist + 1) 5  
  let R 5 - (length T1) - 1
  let i 0
  while [i < R]
  [
    set T1 lput (item i T2) T1 
    set i i + 1
  ]    
  report T1
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to UseMemory
  let n 0
  let current 0
  let large 0
  let pos1 0
  while [n < 5]
  [
    set large item n powerrank
    if ( large > current)
    [
      set pos1 n
      set current large
    ]
    set n n + 1
  ]
  ifelse (current > 0)
  [ 
    set BarCoordinates item pos1 path
    set placeinlist pos1
  ][checkobstacle]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Staff-routine
  ifelse (currentdrinks < 5)
  [
    set color blue
    makedrinks
  ][
    set color white
    placedrinks
  ]
end

;;///////////////////////////////////////////////////////////////////////////////////////////////
to Makedrinks
  if (drinkmakingrate > 1)
  [
    ifelse (drinkmakingrate > 2)
    [
      ifelse (drinkmakingrate > 4)
      [
        ifelse (drinkmakingrate > 6)
        [
          ifelse (drinkmakingrate > 8)
          [
            ifelse (drinkmakingrate > 10)
            [
              ifelse (drinkmakingrate > 12)
              [
                ifelse (drinkmakingrate > 14)
                [
                  ifelse (drinkmakingrate > 16)
                  [
                    ifelse (drinkmakingrate > 18)
                    [
                      set currentdrinks currentdrinks + (40 + random 11)
                    ][set currentdrinks currentdrinks + (30 + random 11)]
                  ][set currentdrinks currentdrinks + (25 + random 6)]
                ][set currentdrinks currentdrinks + (20 + random 6)]
              ][set currentdrinks currentdrinks + (15 + random 6)]
            ][set currentdrinks currentdrinks + (10 + random 6)]
          ][set currentdrinks currentdrinks + (6 + random 5)]
        ][set currentdrinks currentdrinks + (4 + random 3)]
      ][set currentdrinks currentdrinks + (1 + random 4)]
    ][set currentdrinks currentdrinks + (1 + random 2)]
  ]
end

;;////////////////////////////////////////////////////////////////////////////////////////////////
to Placedrinks
  let DrinkPlace nobody
  let oldp patch-here
  ifelse ([pcolor] of patch-ahead 1 = 6) and (not any? turtles-on patch-ahead 1)
    [
      forward 1
      if(any? patches in-cone 3 160 with [pcolor = 35])
      [
        let Pdrinks currentdrinks
        ask patches in-cone 3 160
          [
            if (barcounter = 1)
            [
              set DrinkPlace min-one-of patches [distance myself]
            ]
          ] 
        ask DrinkPlace [
          if (any? customers in-radius 5) and (drinkpoints < 50)
            [          
              set drinkpoints drinkpoints + Pdrinks
              set Pdrinks 0
            ]
        ]
        set currentdrinks Pdrinks
      ]
      left random-float 360
    ]
    [ 
      ifelse ([pcolor] of patch-ahead 1 = 9.9)
      [
        right random-float 180
      ][
      ]
    ]
  let newp patch-here
  if (oldp = newp)
    [
      let space1 patch-here
      ask neighbors with [pcolor = 6][
        set space1 min-one-of patches [distance myself]
      ]
      face space1
      forward 1
    ]
    
end
@#$#@#$#@
GRAPHICS-WINDOW
324
0
1249
946
-1
-1
15.0
1
10
1
1
1
0
0
0
1
0
60
0
60
0
0
1
ticks
30.0

BUTTON
182
504
317
537
1.) User Defined
Floor_plan
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
122
582
316
615
3) Draw Dance Floor
dancefloor
T
1
T
PATCH
NIL
NIL
NIL
NIL
1

SLIDER
8
40
205
73
Num_Four_Top_Tables
Num_Four_Top_Tables
1
11
10
1
1
NIL
HORIZONTAL

SLIDER
7
77
200
110
Num_Eight_Top_Tables
Num_Eight_Top_Tables
1
7
4
1
1
NIL
HORIZONTAL

BUTTON
146
663
305
696
4) Move Tables
movetables
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
158
623
305
656
Clear Dance Floor
EraseDance
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
143
703
307
736
5) Place People
setup-people
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
195
308
318
426
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
6
150
178
183
Number_Staff
Number_Staff
1
5
4
1
1
NIL
HORIZONTAL

SLIDER
6
114
178
147
Skills
Skills
1
10
3
1
1
NIL
HORIZONTAL

SLIDER
4
222
178
255
PercentageFemale
PercentageFemale
0
100
40
5
1
NIL
HORIZONTAL

SLIDER
6
186
178
219
Patrons
Patrons
1
175
135
1
1
NIL
HORIZONTAL

SLIDER
6
258
178
291
Drinks_till_Dance
Drinks_till_Dance
5
15
6
1
1
NIL
HORIZONTAL

MONITOR
1389
669
1476
714
People at Bar
count customers with [ycor >= 50]
2
1
11

MONITOR
1647
719
1766
764
Bar Stool Utilization
(count barstools with [any? customers-here] / count barstools )
4
1
11

PLOT
1258
325
1832
659
Bar, Bathroom, and Dance 
Ticks
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Bathroom Area" 1.0 0 -8990512 true "" "plot count customers with [xcor >= 42]"
"Bar Counter" 1.0 0 -6459832 true "" "plot count customers with [ycor >= 50]"
"Dance Area" 1.0 0 -8630108 true "" "plot count customers with [dance = 1 and drinkcount >= Drinks_till_Dance]"
"Barstools" 1.0 0 -7500403 true "" "plot count customers with [any? barstools-here]"

MONITOR
1410
771
1607
816
Total Drink Value on Bar Counter
CurrentBarValue
2
1
11

MONITOR
1262
771
1402
816
Avg Drinkpoints Per BC
AvgBarValue
2
1
11

BUTTON
146
794
304
827
Show Dense Crowd
whereiscrowd
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
1300
170
1528
215
Customers that are single with crush
count (customers with [single = 1]) with [crush != nobody]
1
1
11

MONITOR
1298
121
1531
166
Customers that are single without crush
count (customers with [single = 1]) with [crush = nobody]
17
1
11

MONITOR
1579
72
1814
117
Total People Linked to Best Looking Male
NetworkB
1
1
11

MONITOR
1577
19
1826
64
Total People Linked to Best Looking Female
networkG
1
1
11

MONITOR
1613
771
1839
816
Mean # Drinks Each Customer has had
AvgDrinkCount
2
1
11

MONITOR
1264
668
1385
713
People at Bathroom
count customers with [xcor >= 42]
17
1
11

SLIDER
6
294
178
327
Max_Drinks_Male
Max_Drinks_Male
3
20
12
1
1
NIL
HORIZONTAL

SLIDER
3
331
178
364
Max_Drinks_Female
Max_Drinks_Female
3
12
9
1
1
NIL
HORIZONTAL

BUTTON
160
832
303
865
See Best Looking
markbestlooking
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
1480
669
1638
714
Number of People Dancing
count customers with [dance = 1 and drinkcount >= Drinks_till_Dance]
1
1
11

MONITOR
1375
220
1527
265
Single Males with a Crush
count customers with [single = 1 and gender = 1 and crush != nobody]
1
1
11

MONITOR
1361
272
1527
317
Single Females with a Crush
count customers with [single = 1 and gender = 0 and crush != nobody]
1
1
11

MONITOR
1449
69
1529
114
Single Males
count customers with [single = 1 and gender = 1]
1
1
11

MONITOR
1344
69
1438
114
Single Females
count customers with [single = 1 and gender = 0]
1
1
11

SLIDER
6
368
178
401
Look_Vision
Look_Vision
1
25
9
1
1
NIL
HORIZONTAL

MONITOR
1321
18
1527
63
Total Single Customers
count (customers with [single = 1])
1
1
11

MONITOR
1645
668
1772
713
People at a Bar stool
count customers with [any? barstools-here]
1
1
11

MONITOR
1517
719
1644
764
Dance Floor Utilization
(count customers with [dance = 1 and drinkcount >= Drinks_till_Dance]) / (0.01 + count patches with [pcolor = 114])
1
1
11

MONITOR
1264
720
1513
765
Avg. Drink Point Value Staff is making
mean [CurrentDrinks] of bar
2
1
11

BUTTON
183
544
318
577
2.) Setup Tables
Setuptables
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
10
412
135
445
Default
Default
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?

This model was designed to demonstrate customer flow within a bar.  The default floorplan is based upon a college bar located within walking distance to Old Dominion University called Mojo Bones.
Mojo Bones has been in the area since 2005.  As a BBQ resturant during the day, Mojo Bones has an average lunch crowd, but during the night Mojo Bones gets incredibly crowded.  This model represents the crowd on a typical Thursday Night.
    
The partial version of the model loads the default template of Mojo Bones and only allows the user to place the dance floor and the different tables.

## HOW IT WORKS
The model is based off four simple rules that have precedence over each other.
Rule 1. If you have to use the restroom, go to the restroom.
Rule 2. If your drink is almost empty, go to the bar and get another drink.
Rule 3. If you're single, then you mingle.  If you're not single, you find the closest open barstool and take a seat.
Rule 4. Once you have had to much to drink: You dance.

All agents use a set of lists to determine what area of the bar to go to for service.  They will go to the initial service spot as long as they are receiving 'good' service.  If at one point they do not receive good service, they will go to the next area of the bar that to them has a 'high rank'.  

In order for a single agent to find a 'crush', he/she will only choose another agent that is better looking then themselves, but not too much 'better' looking.  This represents the general concept that people date within their 'class'.  However, as the agent drinks more, he/she will gain more confidence, resulting in the capability to date someone out of their class.

All single ladies will dance once they have hit a user threshold.  Only the men who have found a date, and who have hit the user threshold, will dance.   


## HOW TO USE IT 
# Default Mode

Follow the listed sequence to use this model.

The interface is setup into three areas.  
Area one: Left of the Environment includes all user functions related to setting the model up.
Area two: The Model Environment (center)
Area three: Right of the Environment, includes information and plots relevant to the model.

For use in Default Mode just hit the 'Default' button.  
Upon the file loading, it will confirm that the floor plan loaded, and then it will confirm if the dance floor loaded.  Hit okay.  If you receive an error message at this step please make sure that the text file listed within the error message is saved in the same directory as the model file.
*There are seven user defined sliders. These are the default settings for the current configuration. Listed below explains what each one does.
#User Sliders
'Skills' With a range from 1-10.  This will effect the 'rate' and 'quality' at which a bar staff member can make a drink.  The higher the skill, the higher the rate and quality.  
'Number_staff' Select the quantity of bar staff you would like to have.
'Patrons' Select the total amount of customers you would like to have at the bar.
'PercentageFemale' Is in terms of %, meaning that if you have '100 patrons' and you select 50 here, you will have 50 males and 50 females.  
'Drinks_Till_Dance' Sets the threshold at which point a customer has had X amount of drinks to have built up the urge to dance.
'Max_Drinks_Male' Sets the drink limit for customers who are male.  Once they have reached this limit, the customer will be asked to leave and another customer will be allowed in.
'Max_Drinks_Female' Sets the drink limit for customers who are female.  Once they have reached this limit, the customer will be asked to leave and another customer will be allowed in.
'Looks_Vision' Sets the vision at which each agent can detect a member of the opposite sex that they find appealing.
#Go Step
At this point you can run the model by hitting the 'Go' button.  
*Notice that there are still two buttons below the 'Go' button, these buttons allow you to gain more information visually.  The first button, 'Show Dense Crowd' will use a diffusion to allow you to see where the most customers are at in a relative area to the bar.  The second button 'See Best Looking' will mark the highest value 'looks' of both male and female by placing a color coded circle around them.  If you get an error with this button, it is because the shape used was a custom shape and needs to be imported into the model.

#Custom User Mode
# Step One
The setup process goes from top down.
Start with Area one, left of the environment, at the top two sliders.
'Num_Four_Top_Tables' A slider that allows you to set the number of tables that can sit four people.
'Num_Eight_Top_Tables' A slider that allows you to set the number of tables that can sit eight people.
Once you have set these sliders to your desired choice hit the button "1.) User Defined"
This button will load the default floor plan file.
# Step Two
Next hit '2.) Setup Tables' This will load the initialized user defined quantity of tables.  
*Notice the tables off to the side in the green area.
#Step Three
Hit the button that says "3.) Draw Dance Floor" 
*Notice that the button stays down.  
This button will allow you to draw the dance floor within the environment.  You can draw the dance floor any where there is a black colored patch within the environment.  Use the mouse to draw the area.  If at any point you make a mistake, you can hit the "Clear Dance Floor" button.  This will erase all previous work assocaited with the dance floor. Once you are finished drawing the dance floor, make sure to unclick the "Dance floor" button.
# Step Four
Hit the button that says "4) Move Tables" 
*Notice that the button stays down.
This button will allow you to 'grab' any one of the yellow or orange tables that were placed off to the side.  Use the mouse to select and place each table, place the desired tables within the area that there is a black colored patch.  You do not have to use all of the tables, just make sure that the tables you are not using are not within the bar environment (keep the unused tables outside the white area where the patches are green)
Once you have placed the desired tables within the environment, make sure to unclick the "Move tables" button.
#Step Five
There are seven user defined sliders.  They were mentioned in the default setting.  Make sure to adjust them to your specifications.  
After setting the desired user settings up, hit the button "5.) Place People" at which point the model will be filled with bar staff, customers, and bar stools.
#Go Step
At this point you can run the model by hitting the 'Go' button.  

#Area Three: The Right Side of the Model
You will see various monitors and a plot.  They are tracking information that might be relavent to the user.  The model's intentions are to visually monitor the area's of the bar.  Common area's to monitor involve the number of people at the bar counter, number of people designated to be dancing, number of people sitting down, and number of people in the bathroom area.
Starting from the Top:
'Total Single Customers' : Total customers who have their variable single = 1
'Single Females/males': Total customers, by gender, who have their variable single = 1
'Total Customers that are single without crush': total customers who are single but have not found a 'date' 
'Total Customers that are single with crush': total customers who are single that have found a 'date'
'Single Males/Females with a crush': Customers broken down by gender, who are single, that have found a 'date'
'Total People linked to best looking female/male': Is first a measure of how many people have found the best looking male/female as an interest of a 'crush' plus any customers who are crushing on the individual who has a crush on the best looking male/female.
'Bar,Bathroom, and Dance Plot': A visual plot of how many people are at each destination.
Directly below the plot are monitors associated with the plot- the numeric amounts associated with the plot.  
Utilization monitors: Taking the number of customers using/at the designated item/area, and dividing by the total amount of available item/area.
**'AvgDrinkPoints per BC': is a measure of the average value of each patch of the bar.  	This is measured based off its current 'Drink Points' value.  Drink points are assigned from the bartenders.  When a staff member makes a drink, it is given a point value.  This point value is a combination of the staff's skill and associated randomness with each different level of skill.  The staff are to place 'drinkpoints' at any patch of the bar that has a customer near it, and if the bar is below a value of 15.  So there is a chance that the value of a bar patch can be higher than 25.
'Total Drink Value on Bar Counter': a measure of the total 'drinkpoints' at the bar.
'Mean # drinks each customer has had': current average of all customers and how many drinks they have had.
'Avg. Drink Point Value Staff is making': the mean amount of 'drinkpoints' the staff is making, this is directly related to their skill level.


## THINGS TO NOTICE

Notice with the default setups that you see a mass of people form at one region of the bar, once the model gets up and fully running this mass will shift from the bar to the bathroom- as expected.  These wild swings are associated with the numeric values that are assigned to the agents.  Another predetermined function is the association of as more people get their drink counts up, they will begin to dance.  The system visually represents how the bar, Mojo Bones, has customer fluctuations throughout its floor plan- how around     

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

The full version of the model will have the capability to allow the user full control in the design concept of the model including: drawing the floor plan, placing the facilities (bathrooms), placing the service areas (bar), establishing a dance floor, and then placing different size tables.  

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

markedfemale
false
0
Circle -1184463 true false 12 12 277
Circle -16777216 true false 36 36 228
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

markedmale
false
0
Circle -955883 true false 12 12 277
Circle -16777216 true false 36 36 228
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person service
false
0
Polygon -7500403 true true 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -1 true false 120 90 105 90 60 195 90 210 120 150 120 195 180 195 180 150 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Polygon -1 true false 123 90 149 141 177 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -2674135 true false 180 90 195 90 183 160 180 195 150 195 150 135 180 90
Polygon -2674135 true false 120 90 105 90 114 161 120 195 150 195 150 135 120 90
Polygon -2674135 true false 155 91 128 77 128 101
Rectangle -16777216 true false 118 129 141 140
Polygon -2674135 true false 145 91 172 77 172 101

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
