breed [leaders leader]
breed [followers follower]
turtles-own [worm-number worm-position worm-heading reverse-counter stay-still]
leaders-own [direction-headed directions-checked obstacles]
patches-own [chemical-signal]
globals [average-leader-separation worm-number-in-reverse current-worm]




to setup
  clear-all
  
  ;;Set worm shapes
  set-default-shape leaders "head-2" ; "circle" 
  set-default-shape followers "worm-segment-2"
  
  ;;Initialize petri dish (background)
  ask patches [set pcolor white]  
  
  ;;Create worms by sprouting "leaders" on random patches
  ask n-of number-worms patches with [pcolor = white] 
  [sprout-leaders 1 [
    (set color black)
    (set size worm-display-thickness)
    (set worm-position 1)
    (set worm-heading heading)
    (set reverse-counter 0)]]
  
  ;;Append followers to grow worm, and assign worm number
  ask leaders [ 
    set worm-number who
    grow-worms 2 worm-number ]  
  
  
  
  
  if operating-mode = "chase-food" [
  ;Add "food" to plate for testing
  ask n-of food-added patches [set pcolor red]]
  
  
  reset-ticks  
end




to grow-worms [counter leader-who]
;;Function generates worm bodies by sequentially adding segments to a leader.

hatch-followers 1 
  [
  set worm-number leader-who
  set worm-position counter  
  ifelse worm-position = 2 [bk 2] [bk 1]
  set size worm-display-thickness
  set color black
  create-link-to myself

  set counter (counter + 1)
  if counter < worm-length [grow-worms counter worm-number] ;;Re-iterate worm growth
  ]
end




to go
;;GO code to run simulation
  
  calculate-metrics
  
  
  ask leaders [set-worm-heading]   ;;Set overall worm objectives
  ask leaders [lead]      ;;Execute leader motion
  ask followers [slither] ;;Execute segment motion
  
  
  ;;Runs chemical signaling
  ask followers with [worm-position = ceiling (worm-length / 2)] ;Ask worm mid-sections to drop chemical
    [ask patch-here [set chemical-signal chemical-signal + 200]] 
  diffuse chemical-signal (diffusion-rate / 100)  ;;Diffuse chemical signal. 
  ask patches [ set chemical-signal chemical-signal * (100 - evaporation-rate) / 100]  ;;  Evaporate chemical signal


  ;;If show-drivers is off, don't visualize signaling.
  if not show-drivers? 
    [ask patches with [pcolor != red] [set pcolor white]]
  
  update-patches
  tick

end


to set-worm-heading
  ;;Leader function: I set the overall worm's destination, depending upon the current operating mode.
  
  if operating-mode = "chase-food"
    [face min-one-of patches with [pcolor = red] [distance myself]
     set worm-heading heading]
  
  if operating-mode = "attractive-signaling"
    [carefully
        [face max-one-of neighbors in-cone 10 25 [chemical-signal]
        set worm-heading heading]
        []]  
    
  if operating-mode = "repulsive-signaling"
     [face min-one-of neighbors [chemical-signal]
      set worm-heading heading]
  
  if operating-mode = "random-heading"
    [if (random-float 100) < heading-change-probability
       [set heading random 360
        set worm-heading heading]]    
  


end



to lead

  ;;Executes forward or reverse mode
  ifelse reverse-counter > 0 
  
    ;;Reverse mode
    [set reverse-counter (reverse-counter - 1)
     face one-of in-link-neighbors]
  
    ;;Forward mode
    
    
    
    [let turn-radius random-normal slither-amplitude 5
     set heading ((cos ( ticks / oscillation-period * 360 ) * turn-radius) + worm-heading ) ;;Set individual leader heading
     set directions-checked 0
     avoid-collisions]  ;;I check to see if heading will collide with a wall or turtle, and adjust if so
  
  
  ;;I step forward
  ifelse stay-still = 0
    [fd worm-speed]
    []

end




to avoid-collisions
  
  ;;If I've checked more than 4 directions, switch to reverse slither.
  ifelse directions-checked > 4 
  
    [set worm-number-in-reverse who
     ask turtles with [worm-number = worm-number-in-reverse] 
       [set reverse-counter reversal-duration]]
  
    [set directions-checked (directions-checked + 1)
      ifelse patch-ahead 1 = nobody 
        [adjust-heading]
        [if (any? turtles-on patch-ahead minimum-proximity)  
          [adjust-heading]]]
end
  
  

  
to adjust-heading
    
    ;;Changes heading in direction of local worm curvature, then re-iterates "checking" procedure.
    
    ifelse  (subtract-headings heading worm-heading) > 0
    [set heading (heading + heading-adjustment)]
    [set heading (heading - heading-adjustment)]
  
    avoid-collisions
  
end




to slither
  
  ;;FORWARD SLITHER MODE
    
  ;;Each followers follows its local leader
  face one-of out-link-neighbors
  
  
  ;;REVERSE SLITHER MODE
  
  if reverse-counter > 0
  [ ifelse not any? in-link-neighbors 
      ;;If I am the back end of the worm, set direction in reverse by following opposite sinusoid
      [set heading ((cos ( ticks / oscillation-period * 360 ) * slither-amplitude) + worm-heading ) + 180 
      avoid-collisions-reverse]
       
      ;;If I am a worm segment, I follow the segment behind me
      [face one-of in-link-neighbors] 
      set reverse-counter (reverse-counter - 1)]
  
  
  ;;BOTH MODES - TAKE STEP 

  ifelse stay-still = 0
    [fd worm-speed]
    []
  
end



to avoid-collisions-reverse
  
  ;;If there is no patch ahead of me, or it is occupied by turtles, I stop moving in reverse
  ifelse patch-ahead 1 = nobody 
    [set stay-still 1] 
    [ifelse (any? turtles-on patch-ahead minimum-proximity) 
      [set stay-still 1]
      [set stay-still 0]]

  ifelse stay-still = 1 and reverse-counter > 1 
    [set current-worm worm-number
    ask turtles with [worm-number = current-worm] [set stay-still 1]]
    [set current-worm worm-number
    ask turtles with [worm-number = current-worm] [set stay-still 0]]

end



to update-patches

     if operating-mode = "chase-food" [
       ;;Reassign eaten food to random other location
       ask patches with [pcolor = red] [
         if (count turtles-here) > 0 [ 
           set pcolor white  
           ask one-of other patches [set pcolor red]]]]

     if operating-mode = "attractive-signaling" or operating-mode = "repulsive-signaling" [ 
       ;;Recolors patches according to chemical signal concentration
       ask patches with [pcolor != red] [ set pcolor scale-color green chemical-signal 100 0 ]]
  
end




to calculate-metrics
;;Store velocity, position, orientation distributions

;;TO BE DETERMINED



;;Average minimum distance between leaders
if count leaders > 1 [
  let total-distance 0
  ask leaders [
    set total-distance (total-distance + distance ( min-one-of other leaders [distance myself])) ];   
  set average-leader-separation (total-distance / ( count leaders ))]
  
end









@#$#@#$#@
GRAPHICS-WINDOW
210
13
811
635
100
100
2.9403
1
10
1
1
1
0
0
0
1
-100
100
-100
100
0
0
1
ticks
30.0

BUTTON
38
54
104
87
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
110
54
173
87
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
18
103
190
136
number-worms
number-worms
1
10
10
1
1
NIL
HORIZONTAL

SLIDER
23
148
195
181
worm-length
worm-length
0
40
40
1
1
NIL
HORIZONTAL

BUTTON
61
14
163
47
single-step
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
14
404
186
437
oscillation-period
oscillation-period
0
90
90
1
1
NIL
HORIZONTAL

SLIDER
16
449
188
482
slither-amplitude
slither-amplitude
0
180
80
1
1
NIL
HORIZONTAL

MONITOR
837
240
970
285
Average Separation
average-leader-separation
2
1
11

SLIDER
23
188
195
221
food-added
food-added
1
100
3
1
1
NIL
HORIZONTAL

SLIDER
16
306
188
339
worm-speed
worm-speed
0
2
1
0.1
1
NIL
HORIZONTAL

SLIDER
17
343
190
376
reversal-duration
reversal-duration
0
50
20
1
1
NIL
HORIZONTAL

SLIDER
825
129
1030
162
worm-display-thickness
worm-display-thickness
0
10
4
1
1
NIL
HORIZONTAL

TEXTBOX
850
350
1035
379
Chemical Signaling Parameters\n
11
0.0
1

SLIDER
843
417
1025
451
diffusion-rate
diffusion-rate
0
100
100
1
1
NIL
HORIZONTAL

SLIDER
844
455
1017
488
evaporation-rate
evaporation-rate
0
3
3
0.1
1
NIL
HORIZONTAL

SWITCH
849
373
1004
406
show-drivers?
show-drivers?
0
1
-1000

TEXTBOX
880
113
1047
133
Display Options
11
0.0
1

SLIDER
24
256
203
290
minimum-proximity
minimum-proximity
0
2
1
0.1
1
NIL
HORIZONTAL

SLIDER
23
512
196
546
heading-adjustment
heading-adjustment
0
90
20
10
1
NIL
HORIZONTAL

MONITOR
999
188
1132
234
Stationary Worms
count leaders with [stay-still = 1]
0
1
11

CHOOSER
839
17
1009
63
operating-mode
operating-mode
"random-heading" "chase-food" "attractive-signaling" "repulsive-signaling"
1

MONITOR
999
288
1133
334
Worms going forward
count leaders with [reverse-counter = 0]
0
1
11

MONITOR
999
237
1132
283
Worms going backward
count leaders with [reverse-counter > 0 and stay-still != 1 ]
0
1
11

SLIDER
830
555
1055
589
heading-change-probability
heading-change-probability
0
5
1
0.1
1
NIL
HORIZONTAL

TEXTBOX
887
535
1054
555
Random Heading
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

This model intends to reproduce the locomotive and social behavior of c. elegans, a roundworm species often used in biology and neuroscience experiments.  At present, several "interaction" mechanisms have been started, but none are working as desires.  Extensive work to date has focused on reproducing a somewhat representative slithering pattern, enforcing a 2-D constraint that worms cannot occupy the same space, and incorporating reversal/stopping mechanisms.  An example video of c. elegans motion can be seen below:

https://www.youtube.com/watch?v=GgZHziFWR7M


## HOW IT WORKS

	Setup:
		1. All patches are turned white.  These are effectively "inert" petri dish that serve as the background.
		2. If the "chase-food" mode is on, a fraction of the patches are seeded with food in the form of red dots.
		3. A fraction of the patches sprout a "leader" turtle
		4. The leader turtles grow worms by serving as the focal point for sequential addition of directed links to "follower" worm segments. 


	Go: At each tick:

	A. In chase-food mode, each patch with food does:
	If a worm is here, I disappear and re-sprout elsewhere.

	B. In attractive/repulsive signaling mode, each patch diffuses/evaporates chemical and updates its shade of green accordingly. The center-segment of each worm drops a finite packet of chemical onto its current patch.


	Each leader does:
		1. I decide upon a heading for the whole worm. (see SET WORM HEADING below)
		2. If I am in stationary or reverse modes, I stay still or follow the segment to which I am linked. Otherwise, I continue:
		3. I set my individual heading by super-imposing a sinusoid onto the worm heading.  The period and amplitude of the wave are set by the user, with noise added by a Gaussian.
		4. I check that my current heading is feasible, and if it is not, I adjust it.  At this stage I consider switching to stationary and/or reverse modes (see CHECK/ADJUST HEADING below)
		5. I take a step forward


	Each follower does:
		1. If I am in forward mode, I face the turtle from which I receive a link (i.e. the worm section in front of me). I step forward. If not in forward mode, I continue:
		2. If I am in stationary mode, I stop and increment my stationary countdown.
		3. If I am in reverse mode, I face directly opposite my overall worm heading, with a sinusoid superimposed upon my heading. 
		4. I check that my current heading is feasible (i.e. not facing a wall or another turtle). If not, I switch to stationary mode. If it is, I step forward.


	SET WORM HEADING:

	Several modes are available:

		chase-food : I set the worm-heading toward the nearest food source. 

		attractive-signaling : I set the worm heading to the highest chemical concentration in my cone of vision (distance+angle variable).

		repulsive-signaling : I set the worm heading to the lowest chemical concentration in my cone of vision (distance+angle variable).

		random-heading: At each tick there is a random chance that I change the worm heading to a random direction.


	CHECK/ADJUST HEADING:

		1. I increment my "directions-checked" counter
		2. If my directions-checked counter surpasses a threshold, I switch to reverse mode.
		3. I check that I am not facing a wall or another turtle. If I am not, I step forward. If I am, I adjust my heading in the direction of my worm-segment's current concavity and return to step 1.



## HOW TO USE IT

Set the number of worms, worm length, worm oscillation period, and worm turning amplitude using sliders on the interface.

The "mode" is set by a drop-down menu.


## THINGS TO NOTICE

	At present:
	1. In chase-food mode, the worms all converge toward a single cluster. Over time, they begin chasing the same "nearest" food particles.
	2. In random-heading mode, the worms eventually get stuck in the corners. I suspect this is because, when in a corner, if a heading is randomly selected from a 360 degree distribution there is only a 25% chance that it will get them out of the corner.  Even if that chance arises, they have to do it without running into themselves or a wall before the heading changes again.
	3. The two signaling modes aren't yet working as planned.  In the attractive mode, worms get stuck trying to chase their own signal and curl up into a ball. Perhaps they must be forced to avoid their own signal.
	4. The "repulsive-signaling" mode works a little bit better, but the frequent changes in heading tend to override the sinusoidal pattern, which detracts from the model as the qualitative "slithering" of the worms is lost.



## EXTENDING THE MODEL

Planned future work:
1. Add distributions of worm length
2. Add metrics (linear velocity distribution)
3. Improve chemical interaction mechanism, i.e. stop worms from following own signal.
4. Add age distribution (and its impact on speed, responsiveness, vision)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

head-2
true
0
Polygon -16777216 true false 15 285 147 1 270 285
Polygon -1 true false 27 287 150 0 21 281 27 287
Polygon -1 true false 273 287 150 0 279 281 273 287

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

worm-head
true
0
Polygon -16777216 true false 30 150 150 0 255 150
Polygon -16777216 true false 30 150 150 300 255 150

worm-segment
true
0
Rectangle -16777216 true false 60 30 240 270

worm-segment-2
true
0
Circle -16777216 true false 15 15 270
Line -1 false 60 60 30 150
Polygon -1 true false 240 60 240 60 270 165 225 255 270 195 285 150 270 90
Polygon -1 true false 60 60 60 60 30 165 75 255 30 195 15 150 30 90

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.2.0-RC4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="NumberFans" repetitions="1" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <timeLimit steps="100"/>
    <metric>red-contentness</metric>
    <metric>blue-contentness</metric>
    <enumeratedValueSet variable="minimum-proximity">
      <value value="0.5"/>
      <value value="0.75"/>
      <value value="1"/>
      <value value="1.25"/>
      <value value="1.5"/>
      <value value="1.75"/>
      <value value="2"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-blue-fans">
      <value value="500"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="number-red-fans">
      <value value="500"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
