to setup

  ca

  reset-ticks

  ask patches [if pycor >= 0 [set pcolor 95]]          ;makes the blue sky
  ask patches [if pycor  < 0[ set pcolor 95]]      ;sets active layer
  ask patches [if pycor <= -3 [set pcolor 85]]     ;sets permafrost


  ask patches [if pycor <= -3 and (pxcor = -16  or pxcor = 16) [set pcolor 132]] ;this makes the sides of the lake
  ask patches [if pycor <= -4 and (pxcor = -15 or pxcor = 15) [set pcolor 132]]
  ask patches [if pycor <= -4 and (pxcor = -14  or pxcor = 14) [set pcolor 132]]
  ask patches [if pycor <= -6 and( pxcor = -13  or pxcor = 13) [set pcolor 132]]
  ask patches [if pycor <= -7 and( pxcor = -12  or pxcor = 12) [set pcolor 132]]
  ask patches [if pycor <= -7 and( pxcor = -11  or pxcor = 11) [set pcolor 132]]
  ask patches [if pycor <= -8 and( pxcor = -10  or pxcor = 10) [set pcolor 132]]
  ask patches [if pycor <= -8 and( pxcor = -9  or pxcor = 9) [set pcolor 132]]
  ask patches [if pycor <= -9 and( pxcor = -8  or pxcor = 8) [set pcolor 132]]
  ask patches [if pycor <= -9 and( pxcor = -7  or pxcor = 7) [set pcolor 132]]
  ask patches [if pycor <= -9 and( pxcor = -6  or pxcor = 6) [set pcolor 132]]


  ask patches [if pycor <= -10 [set pcolor 132]]       ;water
  crt 1 [set shape "sun"  set size 4 set color 45 setxy xcor -10 setxy ycor 10]   ;create sun
  ;crt 10 [set shape "carbondioxide" set size 5 setxy random-xcor random-ycor if [(xcor <=  -3) or (xcor >= -15) ]]



ask n-of 40 patches with [ pcolor = 132] [sprout 1 [ set size 2 set shape "dot" set color black set label "C" ]]    ;makes carbon atoms in permafrost
end

to go

  tick

  ask turtles with [shape = "line half" ][if any? turtles with [ shape = "line half" and (xcor <= -15 or xcor >= 12 or ycor <= -15 or ycor >= 15)] [die]] ;line half represents sun rays

  ask patch -10  10 [sprout sunlight [set shape "line half" set color 45 set size 3]]   ;create sunlight with slider

 ;ask n-of 1 patches with [pcolor = 85]  [ if random 100 < sunlight [set pcolor 67]] ;permafrost thaws, changes color

while [count turtles with [shape = "caterpillar"] <= 10] [ask n-of 10 patches with [ pcolor = 132] [sprout 1[set shape "caterpillar" set color 125 set size 1]] ]  ;creates bacteria in water  set ticks = 2

  ask turtles with [shape = "line half"] [forward 1]



  wait .1


ask turtles with [shape = "dot"]
[ifelse [pcolor] of patch-ahead 1 = 95 [left 169 forward 1][forward 1]
ifelse [pcolor] of patch-ahead 1 = 135 [right 169 forward 1][forward 1]
if ycor < -3 and (xcor < 6 and xcor > -6)  [ ask patch-here[sprout (.05 * sunlight) [set shape "carbondioxide" set size 3]]die]]       ;carbon moves into water and forms CO2

ask turtles with [shape = "caterpillar"]
[
  if [pcolor] of patch-ahead 1 = 138 [right 180 forward 1]
  ifelse [pcolor] of patch-ahead 1 = 95   [left 169 forward 1][forward 1]
  if [pcolor] of patch-ahead 1 = 135 [right 30 forward 1]
  if [pcolor] of patch-ahead 1 = 95   [left 169 forward 1]
]

ask turtles with [shape = "carbondioxide"]
[
  if [pcolor] of patch-ahead 1 = 132 [right 180 forward 1]
]


moveup

end

to moveup

  ask turtles with [shape = "carbondioxide"][ifelse xcor >= 9 and xcor <= 16 and pcolor != 95[set heading 0 right random 10 left random 10 forward 1][rt random 360 fd 1]]

   ask turtles with [shape = "carbondioxide"][if ycor = 0 [die]]

  ask turtles with [shape = "carbondioxide"][if ycor = -12 and  xcor < 9[set heading 180 right random 10 left random 10]]

end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
649
470
16
16
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
34
71
100
104
NIL
Setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
33
199
96
232
NIL
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
24
291
196
324
Sunlight
Sunlight
0
100
100
1
1
NIL
HORIZONTAL

TEXTBOX
737
145
887
175
NIL
12
64.0
1

TEXTBOX
765
80
955
101
Permafrost.
12
132.0
1

TEXTBOX
872
43
1022
61
KEY
14
0.0
1

PLOT
767
330
967
480
Sunlight and CO2 Release
Sunlight
Amount CO2
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles with [shape = \"carbondioxide\"]"

MONITOR
768
255
878
300
Amount of CO2
Count turtles with [shape = \"carbondioxide\"]
1
1
11

TEXTBOX
764
107
914
242
Black circles represent dissolved carbon.\n\nBlack circles with pink represent carbon dioxide.\n\n\"Worm\" looking graphic represents microbes.
12
0.0
1

TEXTBOX
936
74
1021
253
Arctic watershed
12
85.0
1

@#$#@#$#@
## BACKGROUND

Climate change is happening most quickly in polar regions. Increasing temperatures affect amount and quality of sea ice, size of glaciers, and quality of permafrost.
These changes impact sea level, global weather patterns, polar ecosystems,  and access to natural resources. Travel and commercial shipping routes, pollution levels, social patterns and government policies on energy and defense are also impacted.

Understanding polar science helps to clarify the significance of these events.


## RESEARCH QUESTION BEHIND THE SIMULATION

Nine million square miles of permafrost are found globally. Carbon from decayed plants and animals is stored in the permafrost. As temperatures warm, permafrost thaws, releasing stored carbon into watersheds as disolved organic matter. Bacteria interacts with carbon and promotes oxidation to form carbon dioxide (CO2). What is the relationship between sunlight, bacteria, and CO2 production?

## MODEL PARAMETERS

The model simulates an arctic ecosystem.
Permafrost is represented by a dark pink color. Permafrost is soil that remains below zero degrees C for at least two years.

Carbon molecules are shown as black dots. Bacteria is found in the watershed. CO2 is represented by a black and pink model.

The amount of sunshine, or solar radiation may be varied (Remember, in polar summers the sun does not set. Cloud coverage influences amount of sun reaching the ground.)


## HOW TO USE MODEL

1. Adjust the slider to regulate amount of sunshine.

2. Observe amount of CO2 produced in relation to amount of sunshine.

## THINGS TO NOTICE

Notice the order of events.  Carbon from soil moves into water.  Bacteria in water oxidize carbon, creating CO2.  CO2 travels through water and is released into the atmosphere.


Watching the graph, notice the rate of CO2 production in relation to amount of sunlight.
As sunlight increases, CO2 is more rapidly produced.

##PROBING QUESTIONS

What is the source of carbon in the soil?  (Decayed plants and animals)
Why does permafrost thaw?  (Increased temperature)
What is the difference between "melt" and "thaw"? When an item melts, it changes form, going from a solid to liquid. When an objet thaws, it remains a solid, but is less compact.  Permafrost thaws. Permafrost does not melt.


## RELATED MODELS

See models related to climate change.

## CREDITS AND REFERENCES

The model is based on research conducted from Toolik Field Station, Alaska, by Rose Cory and George Kling, University of Michigan. See original publications at http://www.sciencemag.org/content/345/6199/925.short and
http://www.pnas.org/content/110/9/3429.short .

Model created by Regina Brinker, Granada High School, Livermore, California and is based on field with with Dr. Cory through the PolarTREC program. See http://www.polartrec.com/expeditions/arctic-sunlight-and-microbial-interactions-2014

Contact Regina Brinker at brinker.science@gmail.com
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

carbondioxide
true
0
Circle -16777216 true false 120 120 60
Circle -8630108 true false 180 120 30
Circle -8630108 true false 90 120 30

caterpillar
true
0
Polygon -7500403 true true 165 210 165 225 135 255 105 270 90 270 75 255 75 240 90 210 120 195 135 165 165 135 165 105 150 75 150 60 135 60 120 45 120 30 135 15 150 15 180 30 180 45 195 45 210 60 225 105 225 135 210 150 210 165 195 195 180 210
Line -16777216 false 135 255 90 210
Line -16777216 false 165 225 120 195
Line -16777216 false 135 165 180 210
Line -16777216 false 150 150 201 186
Line -16777216 false 165 135 210 150
Line -16777216 false 165 120 225 120
Line -16777216 false 165 106 221 90
Line -16777216 false 157 91 210 60
Line -16777216 false 150 60 180 45
Line -16777216 false 120 30 96 26
Line -16777216 false 124 0 135 15

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

co2
true
13
Circle -14835848 false false 133 134 34
Circle -8630108 false false 167 142 18
Circle -8630108 false false 112 142 20

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

sun
false
0
Circle -7500403 true true 75 75 150
Polygon -7500403 true true 300 150 240 120 240 180
Polygon -7500403 true true 150 0 120 60 180 60
Polygon -7500403 true true 150 300 120 240 180 240
Polygon -7500403 true true 0 150 60 120 60 180
Polygon -7500403 true true 60 195 105 240 45 255
Polygon -7500403 true true 60 105 105 60 45 45
Polygon -7500403 true true 195 60 240 105 255 45
Polygon -7500403 true true 240 195 195 240 255 255

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
