breed [females female]
breed [males male]
breed [dieticians dietician]


turtles-own
[
  male_height_squared   ; how tall a male person is in metres squared for calculation of BMI
  female_height_squared ; how tall a female person is in metres squared for calculation of BMI
  male_weight    ; the weight of a male person in kg
  female_weight   ; the weight of a female person in kg
  BMI_male    ; the body mass index of a male to indicate underweight, healthy, overweight or obese
  BMI_female  ; the body mass index of a female to indicate underweight, healthy, overweight or obese
  pride-shame
  gratification-remorse
  health-consciousness
  male_pride-shame
  female_pride-shame
  male_economic_class ;males are placed in an intial economic class
  female_economic_class  ;females are placed in an intial economic class
  male_attitude   ;individual attitude towards health(exercise)
  female_attitude  ;individual attitude towards health(exercise)
  male_pbc ;male perceived behavioral control
  female_pbc ;female perceived behavioral control
  male_vision ;how far a male sees
  female_vision ;how far a female sees
  male_total_seen  ;total number of males seen in turtle's vision
  female_total_seen ;total number of females seen in turtle's vision
  male_healthy_seen  ;indicates if a healthy male is seen
  female_healthy_seen  ;indicates if a healthy female is seen
  male_subjective_norm ;indicates a males SN value
  female_subjective_norm ;indicates a females SN value
  male_intention ;indicates a males total likelihood to engage in healthy behavior
  female_intention ;indicates a females total likelihood to engage in healthy behavior
  newmale_weight ;calculation of new male weight after each tick
  newfemale_weight ;calculation of new female weight after each tick
  my-group ; turtle group
  friends_total
  friends_healthy
  friends_influence
  male_emotions
  female_emotions
  just-exercised

]


to setup
  clear-all
  ;;set global variables to appropriate values
  setup-patches
  setup-turtles
  assign-turtle-groups
  reset-ticks
end


to setup-patches
  ask patches [ set pcolor pink ]  ;set patches to color pink
end


to go
   move-turtles ;moving around
   exercise-turtles ;exercise is used to mean "engage in healthy behavior (i.e. eat healthily and exercise)
   update-turtles ;give them their new weight all at once
   recolor-turtles ;recalculate BMI and assign new categories


   tick
end






to move-turtles  ;this allows turtles to move in a random direction
  ask turtles [
    ifelse (random 100 <  movement) ;controls for movement in society with slider
    [
     right random 360
      forward 1]
    [forward 0]
     ]
end


to setup-turtles
    set-default-shape turtles "person"
    create-males number / 2 [ setxy random-xcor random-ycor
    set male_height_squared random-normal 3.103219 .2077     ;setting initial male height squared to calculate BMI
    set male_weight  random-normal (72.1212 * starting-weight) 4.2335  ;initializing male's random weight
    set male_pride-shame max (list(min (list (random-normal .4 .2)1) )0)  ;initializing male's random body image
    set male_economic_class min( list (random-exponential (1 / 2)) 1)   ;initializing male'seconomic class
    set male_vision vision
    set just-exercised 0
    ifelse (random-float 100 < health-awareness)
      [set health-consciousness 1]
      [set health-consciousness 0]
    ]   ; initializing male vision
    create-females number / 2 [ setxy random-xcor random-ycor
    set female_height_squared random-normal 2.757414 0.1957    ;initializing female height squared to calculate BMI
    set female_weight  random-normal (61.4618 * starting-weight) 4.0067   ;initializing female's random weight
    set female_pride-shame max (list(min (list (random-normal .4 .2)1) )0)  ;initializing female's random body image
    set female_economic_class min( list (random-exponential (1 / 2)) 1)   ;initializing female's random economic class
    set female_vision vision
    ifelse (random-float 100 < health-awareness)
      [set health-consciousness 1]
      [set health-consciousness 0] ]  ;initializing female vision
    set-default-shape turtles "person"
    create-dieticians dietician-number [setxy random-xcor random-ycor
    set color white
    set just-exercised 0
  ]

end

to exercise-turtles
  ask males
  [set male_attitude (male_pride-shame - 2 * gratification-remorse) ;for now, attitude is just related to body image and does not change over time
    set male_pbc .4 * (max (list(min (list (random-normal male_economic_class .4) 1)) 0)) + random-float .7 ;behavioral control cares about economic class, but also has some random noise
    ask turtles in-radius male_vision ;how many total turtles are seen
    [set male_total_seen count males in-radius male_vision + count females in-radius male_vision
      set male_healthy_seen (count males in-radius male_vision with [BMI_male < 25]) + (count females in-radius male_vision with [BMI_female < 25])] ;how many healthy turtles are seen
    ask turtles with [my-group = [my-group] of myself]  ;how many total turtles are seen
    [set friends_total (count males with [my-group = [my-group] of myself] + count females with [my-group = [my-group] of myself])
      set friends_healthy (count males with [BMI_male < 25 and my-group = [my-group] of myself]) + (count females with [BMI_female < 25 and my-group = [my-group] of myself])]
    set friends_influence (friends_healthy / friends_total)
    set male_subjective_norm ((0.5 + (min (list male_total_seen 20))* (.05) *((male_healthy_seen / male_total_seen) - 0.5)) + friends_influence)

    set male_intention min (list (.4718 * male_attitude + .2554 * male_subjective_norm + .2728 * male_pbc) 1) ;assigns weights calculated from Godin review
    ifelse (random-float 1 < male_intention) ;likelihood to exercise doesn't guarantee exercise - random float allows for disparity between intention and behavior
    [
      ifelse (BMI_male > (20))
      [set newmale_weight (male_weight - random-float .1)
      set just-exercised 1] ;people above BMI of 20 will continue to lose weight when engaging in healthy behavior
      [set newmale_weight (male_weight + random-float .01 - random-float .01)
      set just-exercised 1] ;people at or below BMI of 20 will fluctuate around their current weight
    ifelse (health-consciousness = 1)
        [set gratification-remorse .5]
        [set gratification-remorse .1]
    ]
    [
      ifelse(random-float 1 < .75) ;possible either to stay the same weight or gain weight when not healthy
      [set newmale_weight (male_weight +  random-float 0.1)
      set just-exercised 0] ;weight gain is random between 0 and 0.1
      [set newmale_weight (male_weight)
      set just-exercised 0] ;possible to remain same weight
        ifelse (health-consciousness = 1)
        [set gratification-remorse -.5]
      [set gratification-remorse .5]]


    ifelse (random-float 1 < .01)
       [set health-consciousness (1 - health-consciousness)]
    [set health-consciousness health-consciousness]
  ifelse (count dieticians in-radius male_vision > 0)
    [set health-consciousness 1]
    [set health-consciousness health-consciousness]]
  ask females ;female procedure is identical to males above
  [set female_attitude (female_pride-shame - 2 * gratification-remorse)
    set female_pbc .4 * (max (list(min (list (random-normal female_economic_class .4) 1)) 0)) + random-float .7
    ask turtles in-radius female_vision
    [set female_total_seen count males in-radius female_vision + count females in-radius female_vision
      set female_healthy_seen (count males in-radius female_vision with [BMI_male < 25]) + (count females in-radius female_vision with [BMI_female < 25])]
     ask turtles with [my-group = [my-group] of myself]  ;how many total turtles are seen
    [set friends_total (count males with [my-group = [my-group] of myself] + count females with [my-group = [my-group] of myself])
      set friends_healthy (count males with [BMI_male < 25 and my-group = [my-group] of myself]) + (count females with [BMI_female < 25 and my-group = [my-group] of myself])]
    set friends_influence (friends_healthy / friends_total)
    set female_subjective_norm ((0.5 + (min (list female_total_seen 20))* (.05) *((female_healthy_seen / female_total_seen) - 0.5)) + friends_influence)

    set female_intention min (list (.4718 * female_attitude + .2554 * female_subjective_norm + .27728 * female_pbc) 1)
    ifelse (random-float 1 < female_intention)
    [
      ifelse (BMI_female > (20))
      [set newfemale_weight (female_weight - random-float .1)
      set just-exercised 1]
      [set newfemale_weight (female_weight + random-float .01 - random-float .01)
      set just-exercised 1]
      ifelse (health-consciousness = 1)
        [set gratification-remorse .5]
        [set gratification-remorse .1]
    ]
    [
        ifelse(random-float 1 < .75)
      [set newfemale_weight (female_weight +  random-float 0.1)
      set just-exercised 0]
      [set newfemale_weight (female_weight)
      set just-exercised 0]
              ifelse (health-consciousness = 1)
        [set gratification-remorse -.5]
        [set gratification-remorse .5]
    ]
    ifelse (random-float 1 < .01)
        [set health-consciousness (1 - health-consciousness)]
    [set health-consciousness health-consciousness]
    ifelse (count dieticians in-radius female_vision > 0)
    [set health-consciousness 1]
   [set health-consciousness health-consciousness]
  ]

end

to update-turtles
ask males
  [set male_weight newmale_weight ;all weights update at once
  set male_economic_class max ( list (min (list(male_economic_class + (social_mobility * .0001 * random-float 1) -  (social_mobility * .0001 * random-float 1)) 1 )) 0) ]
  ;depending on social mobility slider, people can move from one economic class to another (albeit slowly)
ask females
  [set female_weight newfemale_weight
    set female_economic_class max ( list (min (list(female_economic_class + (social_mobility * .0001 * random-float 1) -  (social_mobility * .0001 * random-float 1)) 1 )) 0) ]
end


to recolor-turtles
  ask males
  [  set BMI_male newmale_weight / male_height_squared  ; calculation of BMI to categorize health(underweight, healthy, overweight and obese)
    ifelse  (BMI_male < 18.4)
    [set color yellow] ;; underweight individuals set yellow
   [ ifelse ( 18.4 <= BMI_male and BMI_male <= 24.9)
      [set color green] ;; healthy eating set green
     [ifelse ( 25 <= BMI_male and BMI_male <= 29.9)
        [set color blue] ;;overweight individuals set blue
        [if ( BMI_male > 30)
          [set color red]  ;;obese individuals set red
                  ]
      ]
    ]
  ]



  ask females
   [ set BMI_female newfemale_weight / female_height_squared  ; calculation of BMI to categorize health(underweight, healthy, overweight and obese)
    ifelse  (BMI_female < 18.4)
    [set color yellow] ;; underweight individuals set yellow
   [ ifelse ( 18.4 <= BMI_female and BMI_female <= 24.9)
      [set color green] ;; healthy eating set green
     [ifelse ( 25 <= BMI_female and BMI_female <= 29.9)
        [set color blue] ;;overweight individuals set blue
        [ifelse ( BMI_female > 30)
          [set color red]  ;;obese individuals set red
          []
        ]
      ]
    ]
  ]

end



;;; this procedure randomly assigns turtles to groups based on the desired
;;; size of the groups. all the groups will have the desired size except for
;;; at most one group, which contains the remainder of the turtles. more
;;; formally, if there are n turtles, and the desired group size is k, this
;;; procedure will produce j = floor (n / k) groups of k turtles, and if
;;; n mod k > 0, it will produce one group of n mod k turtles.
to assign-turtle-groups

  ;; all turtles are initially ungrouped
  ask turtles [ set my-group -1 ]
  let unassigned turtles

  ;; start with group 0 and loop to build each group
  let group-number 0
  while [any? unassigned]
  [
    ;; place a randomly chosen set of group-size turtles into the current
    ;; group. or, if there are less than group-size turtles left, place the
    ;; rest of the turtles in the current group.
    ask n-of (min (list group-size (count unassigned))) unassigned
      [ set my-group group-number ]
    ;; consider the next group.
    set group-number group-number + 1
    ;; remove grouped turtles from the pool of turtles to assign
    set unassigned unassigned with [my-group = -1]
  ]
end
@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
120
45
183
78
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
33
44
96
77
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
764
66
964
216
BMI (overall)
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"Obese" 1.0 0 -2674135 true "" "plot count turtles with [color = red]"
"Healthy" 1.0 0 -13840069 true "" "plot count turtles with [color = green]"
"overweight" 1.0 0 -13345367 true "" "plot count turtles with [color = blue]"
"underweight" 1.0 0 -1184463 true "" "plot count turtles with [color = yellow]"

SLIDER
23
137
195
170
vision
vision
0
10
2.0
1
1
NIL
HORIZONTAL

SLIDER
23
90
195
123
number
number
020
400
200.0
2
1
NIL
HORIZONTAL

SLIDER
23
240
195
273
social_mobility
social_mobility
0
100
0.0
1
1
NIL
HORIZONTAL

SLIDER
23
291
195
324
movement
movement
0
100
52.0
1
1
NIL
HORIZONTAL

PLOT
317
472
517
622
Economic Class
Economic Class
Count
0.0
1.0
0.0
10.0
true
false
"set-plot-y-range 0 (count turtles) / 5\nset-histogram-num-bars 10" ""
PENS
"default" 0.1 1 -16777216 true "" "histogram [male_economic_class + female_economic_class] of turtles"

SLIDER
23
188
195
221
starting-weight
starting-weight
1
1.1
1.04
.01
1
NIL
HORIZONTAL

PLOT
1006
67
1206
217
BMI - Lower Class
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -2674135 true "" "plot (count turtles with [color = red and (male_economic_class + female_economic_class) < .8])/ (count turtles with [ (male_economic_class + female_economic_class) < .8] )"
"pen-1" 1.0 0 -13345367 true "" "plot (count turtles with [color = blue and (male_economic_class + female_economic_class) < .8]) / (count turtles with [ (male_economic_class + female_economic_class) < .8] )"
"pen-2" 1.0 0 -10899396 true "" "plot (count turtles with [color = green and (male_economic_class + female_economic_class) < .8]) / (count turtles with [ (male_economic_class + female_economic_class) < .8] )"
"pen-3" 1.0 0 -4079321 true "" "plot (count turtles with [color = yellow and (male_economic_class + female_economic_class) < .8]) / (count turtles with [ (male_economic_class + female_economic_class) < .8] )"

PLOT
1253
68
1453
218
BMI - Upper Class
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -2674135 true "" "plot (count turtles with [color = red and (male_economic_class + female_economic_class) > .8]) / (count turtles with [ (male_economic_class + female_economic_class) > .8] )"
"pen-1" 1.0 0 -13345367 true "" "plot (count turtles with [color = blue and (male_economic_class + female_economic_class) > .8]) / (count turtles with [ (male_economic_class + female_economic_class) > .8] )"
"pen-2" 1.0 0 -10899396 true "" "plot (count turtles with [color = green and (male_economic_class + female_economic_class) > .8]) / (count turtles with [ (male_economic_class + female_economic_class) > .8] )"
"pen-3" 1.0 0 -4079321 true "" "plot (count turtles with [color = yellow and (male_economic_class + female_economic_class) > .8]) / (count turtles with [ (male_economic_class + female_economic_class) > .8] )"

TEXTBOX
837
23
987
43
Overall
16
0.0
1

TEXTBOX
1058
25
1208
45
Lower Class
16
0.0
1

TEXTBOX
1310
25
1460
45
Upper Class
16
0.0
1

TEXTBOX
662
138
812
166
BMI Distribution\n(count)
11
0.0
1

SLIDER
25
347
197
380
group-size
group-size
1
20
3.0
1
1
NIL
HORIZONTAL

SLIDER
25
401
197
434
health-awareness
health-awareness
0
100
38.0
1
1
NIL
HORIZONTAL

SLIDER
26
452
198
485
dietician-number
dietician-number
0
20
9.0
1
1
NIL
HORIZONTAL

TEXTBOX
656
312
806
340
Count of health-\nconscious agents\n
11
0.0
1

PLOT
763
278
963
428
Health Consciousness
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"health" 1.0 0 -16777216 true "" "plot (count turtles with [health-consciousness = 1]) / (count turtles)"

PLOT
1003
281
1203
431
Percent Exercising
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot (count turtles with [just-exercised = 1]) / (count turtles)"

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
