
globals [
  
  

  
  gcounter
  gcounter2
  
  gupetani
  gupedagang
  gupabrcpo
  gupabrminygor
  gudistributor
  
  gw1_1petani
  gw2_1petani
  gw1_2petani
  gw2_2petani
  
  gw1_1pedagang
  gw2_1pedagang
  gw1_2pedagang
  gw2_2pedagang
  
  gw1_1pabrcpo
  gw2_1pabrcpo
  gw1_2pabrcpo
  gw2_2pabrcpo

  gw1_1pabrminygor
  gw2_1pabrminygor
  gw1_2pabrminygor
  gw2_2pabrminygor
  
  gw1_1distributor
  gw2_1distributor
  gw1_2distributor
  gw2_2distributor
  
  
  gformulayl1petani
  gformulayl1pedagang
  gformulayl1pabrcpo
  gformulayl1pabrminygor
  gformulayl1distributor
  
  gformulayl2petani
  gformulayl2pedagang
  gformulayl2pabrcpo
  gformulayl2pabrminygor
  gformulayl2distributor
  
  
  gntpetani
  gntpedagang
  gntpabrcpo
  gntpabrminygor
  gntdistributor
  
  gntriilpetani
  gntriilpedagang
  gntriilpabrcpo
  gntriilpabrminygor
  gntriildistributor
  
  
  
  gu_total
  gnt_total
  gntriil_total
  gselisih
  
  ]
        
turtles-own [
    
  risiko
  investasi
  u1
  u2
  formulayl1
  formulayl2
  nt
  ntriil
  alpha
  w1_1
  w1_2
  w2_1
  w2_2
  alphawx1
  alphawx2
  ]
 
breed [petani]
breed [pedagang]
breed [pabrik_cpo]
breed [pabrik_minygor]
breed [distributor]
breed [konsumen]




to do_setup
  clear-all

  if file-exists? "hasilutil.csv"
    [file-delete "hasilutil.csv"]
  
  file-open "hasilutil.csv"
  file-print 
  "W1_1PET,W2_1PET,FORMULAYL1PET,W2_2PET,W1_2PET,FORMULAYL2PET,SELISIHPET, W1_1PED,W2_1PED,FORMULAYL1PED,W2_2PED,W1_2PED,FORMULAYL2PED,SELISIHPED, W1_1CPO,W2_1CPO,FORMULAYL1CPO,W2_2CPO,W1_2CPO,FORMULAYL2CPO,SELISIHCPO, W1_1GOR,W2_1GOR,FORMULAYL1GOR,W2_2GOR,W1_2GOR,FORMULAYL2GOR,SELISIHGOR, W1_1IDIS,W2_1DIS,FORMULAYL1DIS,W2_2DIS,W1_2DIS,FORMULAYL2DIS,SELISIHDIS"
  file-close

  set gselisih 0  
  do_setup_patches
  do_setup_turtles
  
end

to do_setup_patches
  ask patches 
    [ set pcolor green ]
end

to do_setup_turtles
  set-default-shape petani "circle"
  create-petani 1
  [
    set color red
    ;setxy -10 0 
  ]
   
  set-default-shape pedagang "circle"
  create-pedagang 1
  [
    set color black
    ;setxy -5 0 
  ]
 
  
  set-default-shape pabrik_cpo "circle"
  create-pabrik_cpo 1
  [set color violet]
   
  set-default-shape pabrik_minygor "circle"
  create-pabrik_minygor 1
  [set color sky]
  
  set-default-shape distributor "circle"
  create-distributor 1
  [set color yellow]
  
  
  ;ask turtles [ 
  ;  setxy random-pxcor random-pycor]
  

end

to do_go

  do_optimal
  
  tick
  
end

to-report VARY [#low #high]
    ;; reports a random integer in given range, inclusive
   report #low + random(#high - #low + 1)
end 

to do_optimal
  set gcounter gcounter + 1

  ask turtle 0
    [
      ;biaya produksi petani
            
      ifelse gcounter > 1
        [
            if w1_1 < (1 - 0.001)
              [   
                set w1_1 w1_1 + 0.001 
              ]
              
            if w2_2 < (1 - 0.001)
              [   
                set w2_2 w2_2 + 0.001 
              ]
        ]
        [
            set risiko 0.355
            ;set investasi 0.49
            set investasi 0.00298
            set alpha 2
            ;w1 adalah bobot risiko  w2 investasi
            set w1_1 0.001 
            set w2_2 0.001
                       
        ]
      
      set w2_1 1 - w1_1
      ;gw1 global 
      set gw1_1petani w1_1
      set gw2_1petani w2_1
      set alphawx1 alpha * ( (w1_1 * risiko) + (w2_1 * investasi))
      ; u1 fungsi utility berdasar risiko sebelum dikalikan  alpha
      ; formulayl adalah fungsi utility  setelah dikalikan  alpha   
      ; formulayl = u * alpha
      set u1 exp(alphawx1)
      set formulayl1 u1 * alpha
      set gformulayl1petani formulayl1
      
      set w1_2 1 - w2_2
      set gw1_2petani w1_2
      set gw2_2petani w2_2
      set alphawx2 alpha * ( (w1_2 * risiko) + (w2_2 * investasi))
      set u2 exp(alphawx2)
      set formulayl2 u2 * alpha
      set gformulayl2petani formulayl2
                   
      set-current-plot "petani"
      set-current-plot-pen "Util-risk"
      plot formulayl1
      set-current-plot-pen "Util-inv"
      plot formulayl2
     
     
    ] 
    
  ask turtle 1
    [
      ;biaya produksi pedagang
      
      
      ifelse gcounter > 1
        [
            if w1_1 < (1 - 0.001)
              [   
                set w1_1 w1_1 + 0.001 
              ]
             
             if w2_2 < (1 - 0.001)
              [   
                set w2_2 w2_2 + 0.001 
              ]
        ]
        [
            set risiko 0.124
            set investasi 0.00854
            set alpha 2
            set w1_1 0.001
            set w2_2 0.001
            
            set ntriil 0.67
            set gntriilpedagang ntriil
            
        ]
      
      set w2_1 1 - w1_1
      set gw1_1pedagang w1_1
      set gw2_1pedagang w2_1
      set alphawx1 alpha * ( (w1_1 * risiko) + (w2_1 * investasi))
      set u1 exp(alphawx1)
      set formulayl1 u1 * alpha
      set gformulayl1pedagang formulayl1
      
      
      set w1_2 1 - w2_2
      set gw1_2pedagang w1_2
      set gw2_2pedagang w2_2
      set alphawx2 alpha * ( (w1_2 * risiko) + (w2_2 * investasi))
      set u2 exp(alphawx2)
      set formulayl2 u2 * alpha
      set gformulayl2pedagang formulayl2
      
      set-current-plot "Pengepul"
      set-current-plot-pen "Util-risk"
      plot formulayl1
      set-current-plot-pen "Util-inv"
      plot formulayl2
    ] 
    

  ;pabrcpo
  
  
 
  ask turtle 2 
    [
      ifelse gcounter > 1
        [
           if w1_1 < (1 - 0.001)
              [   
                 set w1_1 w1_1 + 0.001 
              ]
           if w2_2 < (1 - 0.001)
              [   
                 set w2_2 w2_2 + 0.001 
              ]
        ]
        [
            set risiko 0.224
            set investasi 0.39381
            set alpha 2
            set w1_1 0.1
            set w2_2 0.1
            
            ;set ntriil 1.35
            ;set gntriilpabrcpo ntriil
            ; instruksi ini sebetulnya tidak berperan karena tidak dipakai pada program
        ]
      
      set w2_1 1 - w1_1
      set gw1_1pabrcpo w1_1
      set gw2_1pabrcpo w2_1
      set alphawx1 alpha * ( (w1_1 * risiko) + (w2_1 * investasi))
      set u1 exp(alphawx1)
      set gupabrcpo u1
      set formulayl1 u1 * alpha
      set gformulayl1pabrcpo formulayl1
      
      set w1_2 1 - w2_2
      set gw1_2pabrcpo w1_2
      set gw2_2pabrcpo w2_2
      set alphawx2 alpha * ( (w1_2 * risiko) + (w2_2 * investasi))
      set u2 exp(alphawx2)
      set gupabrcpo u2
      set formulayl2 u2 * alpha
      set gformulayl2pabrcpo formulayl2
      
      set-current-plot "PKS"
      set-current-plot-pen "Util-risk"
      plot formulayl1
      set-current-plot-pen "Util-inv"
      plot formulayl2
    ]
    
   ;pabrcpo
  
  
 
  ask turtle 3 
    [
       ifelse gcounter > 1
        [
            if w1_1 < (1 - 0.001)
              [   
                 set w1_1 w1_1 + 0.001 
              ]
              
            if w2_2 < (1 - 0.001)
              [   
                set w2_2 w2_2 + 0.001 
              ]
        ]
        [
            set risiko 0.193
            set investasi 0.58575
            set alpha 2
            set w1_1 0.001
            set w2_2 0.001
            
            set ntriil 9.35
            set gntriilpabrminygor ntriil
        ]
      
      set w2_1 1 - w1_1
       set gw1_1pabrminygor w1_1
      set gw2_1pabrminygor w2_1
      set alphawx1 alpha * ( (w1_1 * risiko) + (w2_1 * investasi))
      set u1 exp(alphawx1)
      set formulayl1 u1 * alpha
      set gformulayl1pabrminygor formulayl1
      
      
      set w1_2 1 - w2_2
      set gw1_2pabrminygor w1_2
      set gw2_2pabrminygor w2_2
      set alphawx2 alpha * ( (w1_2 * risiko) + (w2_2 * investasi))
      set u2 exp(alphawx2)
      set formulayl2 u2 * alpha
      set gformulayl2pabrminygor formulayl2
      
      set-current-plot "Refinery"
      set-current-plot-pen "Util-risk"
      plot formulayl1
      set-current-plot-pen "Util-inv"
      plot formulayl2
    ]
    
  ask turtle 4 
    [
      ifelse gcounter > 1
        [
            if w1_1 < (1 - 0.001)
              [   
                 set w1_1 w1_1 + 0.001 
              ]
              
            if w2_2 < (1 - 0.001)
              [   
                set w2_2 w2_2 + 0.001 
              ]  
        ]
        [
            set risiko 0.103
            set investasi 0.00893
            set alpha 2
            set w1_1 0.001
            set w2_2 0.001
            ; sebetulnya ntriil nilai tambah riil tidak diapa-apakan dalam proses beirkutnya 
            set ntriil 0.42
            set gntriildistributor ntriil
        ]
      
      set w2_1 1 - w1_1
      set gw1_1distributor w1_1
      set gw2_1distributor w2_1
      set alphawx1 alpha * ( (w1_1 * risiko) + (w2_1 * investasi))
      set u1 exp(alphawx1)
      set formulayl1 u1 * alpha
      set gformulayl1distributor formulayl1
      
      
      set w1_2 1 - w2_2
      set gw1_2distributor w1_2
      set gw2_2distributor w2_2
      set alphawx2 alpha * ( (w1_2 * risiko) + (w2_2 * investasi))
      set u2 exp(alphawx2)
      set formulayl2 u2 * alpha
      set gformulayl2distributor formulayl2
      
      set-current-plot "distributor"
      set-current-plot-pen "Util-risk"
      plot formulayl1
      set-current-plot-pen "Util-inv"
      plot formulayl2
    ]
  
  file-open "hasilutil.csv"
  ; disini dihitung selisih-selisih utk mencari titik temu curva risiko dan curva investasi langsung di print di csv
  file-print (word gw1_1petani "," gw2_1petani "," gformulayl1petani "," gw2_2petani "," gw1_2petani "," gformulayl2petani "," (gformulayl1petani - gformulayl2petani) "," gw1_1pedagang "," gw2_1pedagang "," gformulayl1pedagang "," gw2_2pedagang "," gw1_2pedagang "," gformulayl2pedagang "," (gformulayl1pedagang - gformulayl2pedagang) "," gw1_1pabrcpo "," gw2_1pabrcpo "," gformulayl1pabrcpo "," gw2_2pabrcpo "," gw1_2pabrcpo "," gformulayl2pabrcpo "," (gformulayl1pabrcpo - gformulayl2pabrcpo) "," gw1_1pabrminygor "," gw2_1pabrminygor "," gformulayl1pabrminygor "," gw2_2pabrminygor "," gw1_2pabrminygor "," gformulayl2pabrminygor "," (gformulayl1pabrminygor - gformulayl2pabrminygor) "," gw1_1distributor "," gw2_1distributor "," gformulayl1distributor "," gw2_2distributor "," gw1_2distributor "," gformulayl2distributor "," (gformulayl1distributor - gformulayl2distributor))
  file-close 
  
 
end


@#$#@#$#@
GRAPHICS-WINDOW
1211
84
1383
213
30
18
2.66
1
10
1
1
1
0
1
1
1
-30
30
-18
18
0
0
1
ticks

BUTTON
3
10
58
43
Setup
do_setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

BUTTON
66
10
121
43
Go
do_go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

PLOT
5
57
228
488
Petani
iterasi
utilitas
0.0
10.0
0.0
10.0
true
true
PENS
"Util-risk" 1.0 0 -2674135 true
"Util-inv" 1.0 0 -10899396 true

PLOT
231
58
467
488
Pengepul
iterasi
utilitas
0.0
1000.0
0.0
10.0
true
true
PENS
"Util-risk" 1.0 0 -16777216 true
"Util-inv" 1.0 0 -10899396 true

PLOT
469
58
706
487
PKS
iterasi
utilitas
0.0
1000.0
0.0
10.0
false
true
PENS
"Util-risk" 1.0 0 -8630108 true
"Util-inv" 1.0 0 -10899396 true

PLOT
709
58
954
487
Refinery
iterasi
utilitas
0.0
1000.0
0.0
10.0
false
true
PENS
"Util-risk" 1.0 0 -13345367 true
"Util-inv" 1.0 0 -10899396 true

PLOT
958
59
1195
485
Distributor
iterasi
utilitas
0.0
1000.0
0.0
10.0
false
true
PENS
"Util-risk" 1.0 0 -1184463 true
"Util-inv" 1.0 0 -10899396 true

@#$#@#$#@
WHAT IS IT?
-----------
This section could give a general understanding of what the model is trying to show or explain.
tes

HOW IT WORKS
------------
This section could explain what rules the agents use to create the overall behavior of the model.


HOW TO USE IT
-------------
This section could explain how to use the model, including a description of each of the items in the interface tab.


THINGS TO NOTICE
----------------
This section could give some ideas of things for the user to notice while running the model.


THINGS TO TRY
-------------
This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.


EXTENDING THE MODEL
-------------------
This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.


NETLOGO FEATURES
----------------
This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.


RELATED MODELS
--------------
This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.


CREDITS AND REFERENCES
----------------------
This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

link
true
0
Line -7500403 true 150 0 150 300

link direction
true
0
Line -7500403 true 150 150 30 225
Line -7500403 true 150 150 270 225

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person business
false
0
Rectangle -1 true false 120 90 180 180
Polygon -13345367 true false 135 90 150 105 135 180 150 195 165 180 150 105 165 90
Polygon -7500403 true true 120 90 105 90 60 195 90 210 116 154 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 183 153 210 210 240 195 195 90 180 90 150 165
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 76 172 91
Line -16777216 false 172 90 161 94
Line -16777216 false 128 90 139 94
Polygon -13345367 true false 195 225 195 300 270 270 270 195
Rectangle -13791810 true false 180 225 195 300
Polygon -14835848 true false 180 226 195 226 270 196 255 196
Polygon -13345367 true false 209 202 209 216 244 202 243 188
Line -16777216 false 180 90 150 165
Line -16777216 false 120 90 150 165

person construction
false
0
Rectangle -7500403 true true 123 76 176 95
Polygon -1 true false 105 90 60 195 90 210 115 162 184 163 210 210 240 195 195 90
Polygon -13345367 true false 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Circle -7500403 true true 110 5 80
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -955883 true false 180 90 195 90 195 165 195 195 150 195 150 120 180 90
Polygon -955883 true false 120 90 105 90 105 165 105 195 150 195 150 120 120 90
Rectangle -16777216 true false 135 114 150 120
Rectangle -16777216 true false 135 144 150 150
Rectangle -16777216 true false 135 174 150 180
Polygon -955883 true false 105 42 111 16 128 2 149 0 178 6 190 18 192 28 220 29 216 34 201 39 167 35
Polygon -6459832 true false 54 253 54 238 219 73 227 78
Polygon -16777216 true false 15 285 15 255 30 225 45 225 75 255 75 270 45 285

person service
false
0
Polygon -7500403 true true 180 195 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285
Polygon -1 true false 120 90 105 90 60 195 90 210 120 150 120 195 180 195 180 150 210 210 240 195 195 90 180 90 165 105 150 165 135 105 120 90
Polygon -1 true false 123 90 149 141 177 90
Rectangle -7500403 true true 123 76 176 92
Circle -7500403 true true 110 5 80
Line -13345367 false 121 90 194 90
Line -16777216 false 148 143 150 196
Rectangle -16777216 true false 116 186 182 198
Circle -1 true false 152 143 9
Circle -1 true false 152 166 9
Rectangle -16777216 true false 179 164 183 186
Polygon -2674135 true false 180 90 195 90 183 160 180 195 150 195 150 135 180 90
Polygon -2674135 true false 120 90 105 90 114 161 120 195 150 195 150 135 120 90
Polygon -2674135 true false 155 91 128 77 128 101
Rectangle -16777216 true false 118 129 141 140
Polygon -2674135 true false 145 91 172 77 172 101

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

suit club
false
0
Circle -7500403 true true 148 119 122
Circle -7500403 true true 30 119 122
Polygon -7500403 true true 134 137 135 253 121 273 105 284 195 284 180 273 165 253 159 138
Circle -7500403 true true 88 39 122

suit heart
false
0
Circle -7500403 true true 135 43 122
Circle -7500403 true true 43 43 122
Polygon -7500403 true true 255 120 240 150 210 180 180 210 150 240 146 135
Line -7500403 true 150 209 151 80
Polygon -7500403 true true 45 120 60 150 90 180 120 210 150 240 154 135

suit spade
false
0
Circle -7500403 true true 135 120 122
Polygon -7500403 true true 255 165 240 135 210 105 183 80 167 61 158 47 150 30 146 150
Circle -7500403 true true 43 120 122
Polygon -7500403 true true 45 165 60 135 90 105 117 80 133 61 142 47 150 30 154 150
Polygon -7500403 true true 135 210 135 253 121 273 105 284 195 284 180 273 165 253 165 210

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.1.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
