breed [humans human]
breed [camas camass]
breed [elk elks]
camas-own [age]
humans-own [age]
elk-own [age]

To Setup
clear-all
  create-humans number-of-humans [
    set age age + 1
    set shape "person"
    set color  35
    set size 1.5
    move-to one-of patches
  ]

  create-elk number-of-elk [
  set age age + 1
    set shape "elk"
   set color 33
    set size 1.5
   move-to one-of patches
  ]

  create-camas number-of-camas [
   set age age + 0.5
    set shape "camas"
    set size 1.5
   set color 53
   move-to one-of patches
  ]



  ask patches [
    set pcolor 57]

reset-ticks
end

to go

  if not any? camas [ stop]
  ask humans [
    set age age + 1
    right random 10
    left random 10
    forward 1
    if random-float 150 < human-reproduction [
      hatch-humans 1 [
        set age 0
        set color 35
        move-to one-of neighbors]
    ]


    if age > 80 [die]
    if any? camas-here [
      if random-float 100 < human-harvest [
        ask camas-here
        [die]
      ]
    ]

    if any? elk-here [
       if random-float 100 < human-hunt [
      ask elk-here [die]
    ]
   ]
  ]


  ask elk [
    set age age + 1
    right random 10
    left random 10
    forward 1
    if random-float 100 < elk-reproduction [
      hatch-elk 1 [
        set age 0
        set color 33
        move-to one-of neighbors]
    ]
    if age > 13 [die]
    if any? camas-here [
      ask camas-here [die]
    ]
  ]

  ask camas [
  set age age + 0.5
    if age > 5 [die]
    if random-float 100 < camas-reproduction [
    hatch-camas 1 [
      set color 53
        set age 0
        move-to one-of neighbors]
    ]
  ]
  tick
end

@#$#@#$#@
GRAPHICS-WINDOW
210
10
647
448
-1
-1
13.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
23
18
87
51
Setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
112
18
175
51
Go
Go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
22
79
195
112
number-of-humans
number-of-humans
0
100
24.0
1
1
NIL
HORIZONTAL

PLOT
685
30
885
180
Populations
time
population
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"camas" 1.0 0 -13345367 true "" "plot count camas"
"humans" 1.0 0 -5207188 true "" "plot count humans"
"elk" 1.0 0 -10402772 true "" "plot count elk"

MONITOR
685
193
779
238
NIL
count humans
17
1
11

SLIDER
21
126
194
159
number-of-elk
number-of-elk
0
200
66.0
1
1
NIL
HORIZONTAL

SLIDER
15
167
200
200
number-of-camas
number-of-camas
0
500
371.0
1
1
NIL
HORIZONTAL

MONITOR
685
249
749
294
NIL
count elk
17
1
11

MONITOR
794
193
877
238
NIL
count camas
17
1
11

SLIDER
14
225
194
258
Human-reproduction
Human-reproduction
0
10
5.0
1
1
%
HORIZONTAL

SLIDER
17
265
190
298
Elk-reproduction
Elk-reproduction
0
10
5.0
1
1
%
HORIZONTAL

SLIDER
15
304
194
337
Camas-reproduction
Camas-reproduction
2
25
11.0
1
1
%
HORIZONTAL

SLIDER
15
370
188
403
Human-harvest
Human-harvest
0
100
22.0
1
1
%
HORIZONTAL

SLIDER
16
410
189
443
Human-hunt
Human-hunt
0
100
20.0
1
1
%
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

Camas, humans, and elk (among many other more-than-human animals, plants, insects, and natural kinds like water) interact in camas prairies in the Pacific Northwest region of the United States. Camas is a disturbance-loving plant, meaning that it grows better when humans harvest responsibly and when elk graze the prairie, so long as elk populations are near and not over carrying capacity for the land. This is a model of camas-human-elk relationships in the prairie.The model should illustrate how camas is a disturbance-loving plant that actually grows more rapidly when humans and elk harvest, but only up to a certain point. After humans and/or elk begin to over-harvest, the system stops functioning as well and the camas population begins to die off. 


## HOW IT WORKS

Sliders control human, elk, and camas reproduction rates and initial population numbers. Sliders also control the likelihood that humans will harvest the camas or hunt the elk they meet.
Humans eat both camas and elk. Elk eat camas, as well. 
Elk and humans will have instructions under To Go commands so that they move about randomly and consume or harvest camas as they find them.

## HOW TO USE IT

Click setup and then go. Use the sliders to change the variables. 

## THINGS TO NOTICE

Notice in the graph that as the human population increases, the elk and camas population increase as well for a short time. As the human population increases past a certain point, the elk and camas populations both decline rapidly. 

## THINGS TO TRY

Try changing the sliders to see how the model might run differently. What happens when you decrease or increase the populations of various species? What happens if you make the humans more or less likely to hunt elk or havest camas? 

## EXTENDING THE MODEL

Try to alter to the code to make the elk actively avoid the humans in the prairie, which would be more accurate. 
Try to alter the code to make the humans engage in the prairie more sustainably. 

## NETLOGO FEATURES

I'm not sure that any of this code is particuarly interesting, but do notice that the ages at which the humans, elk, and camas are meant to die is a fairly accurate repsentation of the life expectancies. 

## RELATED MODELS
This model is related to many of the predator-prey models in the models library and the commons.

## CREDITS AND REFERENCES

Referencing this model:
McDaid-Morgan, N. (2019). NetLogo camas-elk-human model. 
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

camas
false
5
Polygon -10899396 true true 150 75 165 165 165 210 165 240 150 300 165 300 180 240 180 195 165 135
Polygon -10899396 true true 150 300 210 195 234 173 264 188 225 195
Polygon -10899396 true true 165 300 165 270 135 180 90 195 135 195
Polygon -13345367 true false 225 120 270 75 225 105 225 45 210 105 150 60 210 120
Polygon -10899396 true true 170 170 105 135 175 182 210 120
Polygon -13345367 true false 210 105 285 135 225 120 210 180 210 120 150 135 210 105
Polygon -13345367 true false 150 75 225 105 165 90 150 150 150 90 90 105 150 75
Polygon -13345367 true false 165 90 210 45 165 75 165 15 150 75 90 30 150 90
Polygon -13345367 true false 120 135 165 90 120 120 120 60 105 120 45 75 105 135
Polygon -13345367 true false 105 120 180 150 120 135 105 195 105 135 45 150 105 120
Circle -1184463 true false 105 120 0

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

elk
false
0
Polygon -6459832 true false 225 120 249 61 241 31 265 56 272 27 280 59 300 45 285 90
Polygon -7500403 true true 196 228 198 297 180 297 178 244 166 213 136 213 106 213 79 227 73 259 50 257 49 229 38 197 26 168 26 137 46 120 101 122 147 102 181 111 217 121 256 136 294 151 286 169 256 169 241 198 211 188
Polygon -7500403 true true 74 258 87 299 63 297 49 256
Polygon -7500403 true true 25 135 15 186 10 200 23 217 25 188 35 141
Polygon -7500403 true true 270 150 253 100 231 94 213 100 208 135
Polygon -6459832 true false 225 120 204 66 207 29 185 56 178 27 171 59 150 45 165 90

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
