patches-own [my-sentiment ;; Each trader can have a positive sentiment (+1), in which case he is 'bullish',
                          ;; that is, he beleives the market will rise or he can have a
                           ;; negative sentiment (-1) in which case he is 'bearish', that is, he beleives the market will fall.
                          ;; if the sentiment is positive the trader buys one share if it is negative he sells
                          ;; one share.
             local-field ;; local sentiment field generated by neighbors
             number-of-shares ;; Number of shares that each trader has (if negative it implies that the
                              ;; trader is 'short' (we assume that there are no limits to short selling).
             opinion-vol  ;; Volatility in a trader's own interpretation of the news.
             propensity-to-sentiment-contagion ;; Propensity to be influenced by friends sentiments
                                                ;; regarding the news qualitative nature.
             base-propensity-to-sentiment-contagion
             news-sensitivity ;; Sensitivity that the traders have to the news qualitative meaning.
             market-impact ;; Volume of shares that the trader bids
             market-order ;; Market order.
             ]

globals [log-price
         returns
         sentiment-field
         news-qualitative-meaning  ;; There is a set of news concerning the market that reaches all traders
                                   ;; these news are attributed a qualitative meaning
         number-of-traders
         volatility-indicator
         total-bullish
         total-bearish
         ]

to setup
;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
ca
ask patches [
             set number-of-shares 1 ;; Each trader starts with one unit of shares
             set opinion-vol sigma + random-float 0.1
             set news-sensitivity (random-float max-news-sensitivity)
             set base-propensity-to-sentiment-contagion (random-float max-base-propensity-to-sentiment-contagion)
             set propensity-to-sentiment-contagion base-propensity-to-sentiment-contagion
             ]
set log-price random 10
set number-of-traders count patches
end


to go
news-arrival
agent-decision
market-clearing
update-market-sentiment
compute-volatility-indicator
do-plot
end


;;;;;;;;;;;;;;;;;;;;;;;;;;
; News Arrival mechanism ;
;;;;;;;;;;;;;;;;;;;;;;;;;;
to news-arrival
  ifelse (random-normal 0 1) > 0 [set news-qualitative-meaning 1] [set news-qualitative-meaning -1]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;
; Agent's decision rule ;
;;;;;;;;;;;;;;;;;;;;;;;;;
; The agent's (in this case trader) sentiment is positive (+1) and he buys if
; the friends sentiment regarding the market, multiplied by the agent's propensity to be contagiated by
; the sentiment of his friends, plus the news multiplied by the agent's news sensitivity, plus a random
; term is larger than zero, otherwise, the agent's sentiment is set (-1) and the agent sells.
to agent-decision

    ask patches
    [
      set local-field sum [my-sentiment] of neighbors4
      ifelse ((propensity-to-sentiment-contagion * local-field + news-sensitivity * news-qualitative-meaning + random-normal miu opinion-vol) > 0)
      [set my-sentiment 1] [set my-sentiment -1]]
    ; If the agent's sentiment is positive the colour is set green, if he is negative it is set red.
    set total-bullish count patches with [my-sentiment = 1]
    set total-bearish count patches with [my-sentiment = -1]
    set sentiment-field mean [my-sentiment] of patches
    ask patches [
      ifelse my-sentiment = 1
      [
        set pcolor green
        set market-impact my-sentiment * total-bullish
        set number-of-shares my-sentiment * number-of-shares + market-impact
        ]
      [
        set pcolor red
        set market-impact my-sentiment * total-bearish
        set number-of-shares number-of-shares + market-impact
        ]
      ]


end
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Market clearing mechanism ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to market-clearing

  set returns mean [market-impact] of patches / market-depth
  set log-price (log-price + returns)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;
; Update market sentiment;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to update-market-sentiment
  ask patches
  [; A good(bad) news confirmed by a market movement in the direction of that news
   ; leads to a greater propensity to sentiment contagion. If the good(bad) news is not
   ; confirmed by a market movement in the same direction the propensity to sentiment contagion
   ; decreases.
    if (returns > 0) and (news-qualitative-meaning > 0)
      [set propensity-to-sentiment-contagion base-propensity-to-sentiment-contagion + sentiment-field]
    if (returns > 0) and (news-qualitative-meaning < 0)
      [set propensity-to-sentiment-contagion base-propensity-to-sentiment-contagion - sentiment-field]
    if (returns < 0) and (news-qualitative-meaning < 0)
      [set propensity-to-sentiment-contagion base-propensity-to-sentiment-contagion - sentiment-field]
    if (returns < 0) and (news-qualitative-meaning > 0)
      [set propensity-to-sentiment-contagion base-propensity-to-sentiment-contagion + sentiment-field]

  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 