patches-own [
  chemicalTermite      ;; amount of chemical from termite on this patch
  chemicalAnt          ;; amount of chemical from ant on this patch
  food                 ;; amount of food on this patch (0, 1, or 2)
  nest?                ;; if it is a nest, whether it is a Termite or ant nest, it will be true
  nestTermite?         ;; true on termite nest patches, false elsewhere
  nestAnt?             ;; true on ant nest patches, false elsewhere
  nest-scent-termite   ;; number that is higher closer to the termite nest
  nest-scent-ant       ;; number that is higher closer to the ant nest
  foodSource?          ;;
             ]
breed [ants ant]
breed [termites termite]

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape turtles "bug"
  create-ants population / 2
  [ set size 2
    set color green ;; green = not carryiing food
    setxy AntX AntY]

  create-termites population / 2
  [ set size 3
    set color red ;; red = not carryiing food
    setxy TermiteX TermiteY]
  setup-patches
  reset-ticks
end

to setup-patches
  ask patches
  [ setup-nest
    setup-food  ;; if the statement is : if distancexy 0 0 [blah blah blah], it is from the point of view of the center 0 0
                ;; should be ifelse rather than if, when pcolor scale-color green chemical 0.1 5 is not blocked
    ifelse nest?
      [ set pcolor violet ]
      [ if food > 0 and foodSource? [ set pcolor cyan ]]
  ]
end

to setup-nest  ;; patch procedure
  ;; set nest? variable to true inside the nest, false elsewhere
  set nestTermite? false
  set nestAnt? false
  set nest? false
  set foodSource? false
  if (distancexy TermiteX TermiteY) < 5 [set nestTermite? true
                              set nest? true]  ;; for Termites
  if (distancexy AntX AntY) < 5 [set nestAnt? true
                             set nest? true]   ;; for Ants
  ;; spread a nest-scent over the whole world -- stronger near the nest
  set nest-scent-termite 200 - distancexy TermiteX TermiteY
  set nest-scent-ant 200 - distancexy AntX AntY
end

to setup-food  ;; patch procedure

  if numberFoodSource = 1 [foodSource_1]
  if numberFoodSource = 3 [foodSource_3]
  if numberFoodSource = 5 [foodSource_5]

  ;; set "food" at sources to either 1 or 2, randomly
  if foodSource? = true
  [ set food one-of [1 2] ]
end


to recolor-patch  ;; patch procedure

    ;; scale color to show chemical concentration
  ifelse ticks mod 2 = 1
    [ if foodSource? != true and chemicalAnt > 0.01 [set pcolor scale-color lime chemicalAnt 0.1 5]
      if foodSource? != true and chemicalTermite > 0.01 [set pcolor scale-color magenta chemicalTermite  0.1 5]]
    [ if foodSource? != true and chemicalTermite > 0.01 [set pcolor scale-color magenta chemicalTermite  0.1 5]
      if foodSource? != true and chemicalAnt > 0.01 [set pcolor scale-color lime chemicalAnt  0.1 5 ]]
 ;; give color to nest and food sources
  ifelse nest?
  [ set pcolor violet ]
  [ if food <= 0   ;; should be ifelse rather than if, when pcolor scale-color green chemical 0.1 5 is not blocked
     and foodSource? [ set pcolor 80 ]
  ]

end

;;;;;;;;;;;;;;;;;;;;;
;;; Go procedures ;;;
;;;;;;;;;;;;;;;;;;;;;

to go  ;; forever button
  ask termites
  [ if who mod 2 = 0 [ stop ] ;; delay initial departure
    if nestAnt? [bk 2]
    ifelse color = red
    [ look-for-food-termite  ]       ;; not carrying food? look for it
    [ return-to-nestTermite ]       ;; carrying food? take it back to nest
    wiggle
    if [chemicalAnt] of patch-here > 0.11 [downhill chemicalAnt]
    ifelse ([chemicalTermite] of patch-here > 0.3 and [chemicalTermite] of patch-here < 0.5) or [chemicalAnt] of patch-here > 0.1 [stop]
                                                                                                                              [fd 1 ]
  ]

  diffuse chemicalTermite (diffusion-rate / 100)
  ask patches
  [ set chemicalTermite chemicalTermite * (100 - evaporation-rate) / 100  ;; slowly evaporate chemical
    recolor-patch ]

   ask ants
  [ if who mod 2 = 1 [ stop ] ;; delay initial departure

    if nestTermite? [bk 2]
    ifelse color = green
    [ look-for-food-Ant  ]       ;; not carrying food? look for it
    [ return-to-nestAnt ]       ;; carrying food? take it back to nest
    wiggle
    if [chemicalTermite] of patch-here > 0.11 [downhill chemicalTermite]
    ifelse ([chemicalAnt] of patch-here > 0.3 and [chemicalAnt] of patch-here < 0.5) or [chemicalTermite] of patch-here > 0.1 [stop]
                                                                                                                              [fd 1 ]
  ]
  diffuse chemicalAnt (diffusion-rate / 100)
  ask patches
  [ set chemicalAnt chemicalAnt * (100 - evaporation-rate) / 100  ;; slowly evaporate chemical
    recolor-patch ]
  tick
end

to return-to-nestTermite  ;; turtle procedure
  ifelse nest?
  [ ;; drop food and head out again
    set color red
    rt 180 ]
  [ set chemicalTermite chemicalTermite + 60  ;; drop some chemical
    uphill-nest-scentTermite ]         ;; head toward the greatest value of nest-scent
end

to return-to-nestAnt  ;; turtle procedure
  ifelse nest?
  [ ;; drop food and head out again
    set color green
    rt 180 ]
  [ set chemicalAnt chemicalAnt + 60  ;; drop some chemical
    uphill-nest-scentAnt ]         ;; head toward the greatest value of nest-scent
end

to look-for-food-termite  ;; termite procedure
  if food > 0
  [ set color orange + 1     ;; pick up food
    set food food - 1        ;; and reduce the food source
    rt 180                   ;; and turn around
    stop ]
  ;; go in the direction where the chemical smell is strongest
  if (chemicalTermite >= 0.05) and (chemicalTermite < 2)
  [ uphill-chemicalTermite ]
end

to look-for-food-ant  ;; ant procedure
   if food > 0
  [ set color blue + 1     ;; pick up food
    set food food - 1        ;; and reduce the food source
    rt 180                   ;; and turn around
    stop ]
  ;; go in the direction where the chemical smell is strongest
  if (chemicalAnt >= 0.05) and (chemicalAnt < 2)
  [ uphill-chemicalAnt ]
end

;; sniff left and right, and go where the strongest smell is
to uphill-chemicalTermite  ;; Termite procedure
  let scent-ahead chemical-scentTermite-at-angle   0
  let scent-right chemical-scentTermite-at-angle  45
  let scent-left  chemical-scentTermite-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

;; sniff left and right, and go where the strongest smell is
to uphill-chemicalAnt  ;; Termite procedure
  let scent-ahead chemical-scentAnt-at-angle   0
  let scent-right chemical-scentAnt-at-angle  45
  let scent-left  chemical-scentAnt-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

;; sniff left and right, and go where the strongest smell is for termite
to uphill-nest-scentTermite  ;; turtle procedure
  let scent-ahead nest-scentTermite-at-angle   0
  let scent-right nest-scentTermite-at-angle  45
  let scent-left  nest-scentTermite-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

;; sniff left and right, and go where the strongest smell is for ant
to uphill-nest-scentAnt  ;; turtle procedure
  let scent-ahead nest-scentAnt-at-angle   0
  let scent-right nest-scentAnt-at-angle  45
  let scent-left  nest-scentAnt-at-angle -45
  if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  [ ifelse scent-right > scent-left
    [ rt 45 ]
    [ lt 45 ] ]
end

to wiggle  ;; turtle procedure
  rt random 40
  lt random 40
  if not can-move? 1 [ rt 180 ]
end

to-report nest-scentTermite-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [nest-scent-termite] of p
end

to-report nest-scentAnt-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [nest-scent-Ant] of p
end

to-report chemical-scentTermite-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [chemicalTermite] of p
end

to-report chemical-scentAnt-at-angle [angle]
  let p patch-right-and-ahead angle 1
  if p = nobody [ report 0 ]
  report [chemicalAnt] of p
end


to foodSource_1


  if (distancexy (-0.7 * max-pxcor) (0.0 * max-pycor)) < 10 [set foodSource? true]

end

to foodSource_3
 ;  if (distancexy (-0.6 * max-pxcor) (0.8 * max-pycor)) < 5 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (0.4 * max-pycor)) < 5 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (0.0 * max-pycor)) < 10 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (-0.4 * max-pycor)) < 5 [set foodSource? true]
 ;  if (distancexy (-0.6 * max-pxcor) (-0.8 * max-pycor)) < 5 [set foodSource? true]

end

to foodSource_5
  if (distancexy (-0.6 * max-pxcor) (0.8 * max-pycor)) < 5 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (0.4 * max-pycor)) < 5 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (0.0 * max-pycor)) < 10 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (-0.4 * max-pycor)) < 5 [set foodSource? true]
  if (distancexy (-0.6 * max-pxcor) (-0.8 * max-pycor)) < 5 [set foodSource? true]

end






@#$#@#$#@
GRAPHICS-WINDOW
463
10
976
524
-1
-1
5.0
1
10
1
1
1
0
0
0
1
-50
50
-50
50
0
0
1
ticks
30.0

BUTTON
113
10
176
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
22
53
194
86
population
population
0
5000
2000.0
100
1
NIL
HORIZONTAL

SLIDER
21
93
193
126
AntX
AntX
-50
50
45.0
5
1
NIL
HORIZONTAL

SLIDER
199
93
371
126
AntY
AntY
-50
50
-10.0
5
1
NIL
HORIZONTAL

SLIDER
19
132
191
165
TermiteX
TermiteX
-50
50
45.0
5
1
NIL
HORIZONTAL

SLIDER
200
131
372
164
TermiteY
TermiteY
-50
50
10.0
5
1
NIL
HORIZONTAL

BUTTON
33
11
99
44
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
19
177
191
210
diffusion-rate
diffusion-rate
0
100
3.0
1
1
NIL
HORIZONTAL

SLIDER
22
217
194
250
evaporation-rate
evaporation-rate
0
100
3.0
1
1
NIL
HORIZONTAL

CHOOSER
26
265
173
310
numberFoodSource
numberFoodSource
1 3 5
0

@#$#@#$#@
## WHAT IS IT?

This project is an extension of the Ants.nlogo by Prof Uri Welenski. In that original Ants.nlogo project, each ant from a colony forages for food at first randomly. Then by following a few rules, the colony of ants seems to be acting in an intelligent way. 

The modification this present project makes is in response to seeing this video on Youtube: https://www.youtube.com/watch?v=A1QEGNjDQ7U, which shows columns of ants and termites travelling along two routes, and the edge between the two route are guarded by rows of termites on the edge of the termites route, and ants on the edge of the ants route. 



## HOW IT WORKS

As in the original Ants.nlogo model, the ants emerges from the nest and move in random direction looking for food. Once it founds the food, it carries it back to the nest, dropping a chemical along the way. The ants will drop chemicalAnt and the termites chemicalTermite. When an ant lands on a square with chemicalAnt, it follows the chemial trail to the food, and as more ants carry food to the nest, the chemical trail will be maintained. Similar mechanism occurs in the case of the termites where they will react to the chemicalTermite. 

Note, with time, the chemica will evaporate. The chemical also diffuses outward from the spot where it was first laid down by the ant or the termite.

The additional rule added in this model to the behavior of the ants and by extension to the termites is this. When an ant senses chemicalTermite beyond certain level and at the same time, chemicalAnt at a certain level, which would indicate it is between the two corridors of movements of the ants and termites, it would stop moving. The same applies to the termites. Would that replicate what's seen in the video of Termites and Ants on Youtube as referenced by the link above?

## HOW TO USE IT

Click the SETUP button to set up the nests and the food pile(s). THe sliders AntX, AntY, TermiteX and TermiteY allow you to place the nests on any spot on the screen. The choice buttons allow you to choose whether to have 1, 3 or 5 food piles. 

The POPULATION slider allows you to set the number of ants/termites. The DIFFUSION-RATE slider allows you to regulate how far the chemicals (chemicalAnt and chemicalTermite) can diffuse, and the EVAPORATION-RATe slider allows you to regulate how fast or slow the chemicals will evaporate and disappear.

## THINGS TO NOTICE

At certain settings, you might see the pattern seen in the video being replicated by the model. 

## THINGS TO TRY

Try changing the distance of the nests from the food pile(s) and see what happens. Try varying the number of ants/termites.

## EXTENDING THE MODEL

What if ants and termites would fight each other to the death if they meet up? What if only if an ant or termite is carrying food that will be attacked by the worker ant/termite of the other specie? 

## NETLOGO FEATURES

The built-in diffuse primitive lets us diffuse the chemical easily without complicated code.
The primitive patch-right-and-ahead is used to make the ants smell in different directions without actually turning.

## RELATED MODELS

ants.nlogo

## CREDITS AND REFERENCES

This model is an expansion on the original model by * Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

The original model has one nest only. This model has two species of ants, Termites and ants, with multiple food source.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
