;; Welcome to the Battle of Trafalgar

;;initialise:
;;    Create two fleets with suitable dispositions
;; establish two fleets differentiated by colour, allow differences in size resilience etc.

;;at each tick
;; both fleets move
;; in range, ships determine if they have been damaged by the other fleet (stochastic element)
;;ships hit suffer damage
;; ships with no health are sunk
;; redships move at right angles to blue ships (known as crossing the T) for a set period before becoming 'control free' then red ships target blue ships, acting independently
;; red ability to target is governed by the radius at which they can sense blue ship to create informational superiority
;; red ships will be autonomous while blue ships can only move according to their orders or as manually controlled


globals[
bluecaptive;;blue and red captives create a tally of blue/red losses
redcaptive
]



breed [friends friend];; these will be red ships as the model is based on the red fleet perspective, friends and enemies are used soley to avoid confusion with netlogo primitives
breed [enemies enemy];;blue ships
breed [arrow arrows];;this will be for wind direction, at the moment this play no role in the sim so this can be removed.  Possible extensions can use wind speed and direction to aid or hinder ships depending on direction of travel.  This would create a more realistic battle




turtles-own [health speed age];; for both fleets we will use health and speed as variables in combat, age for specific timed operations

to setup
  clear-all
  ask patches [set pcolor 88];;create light blue background for sea
  set redcaptive 0;; losses at zero to start
  set bluecaptive 0;;losses at zero to start



  create-arrow 1[;;creates a windguage, this can be used in extensions to create a more realistic model
    set xcor -12
    set ycor 12;;top right corner like an old map
    set shape "arrow";;indicates direction of wind
    set color 90;;black
    set size 2;;big enough to stand out
    set heading wind_direction;; wind direction can be set at interface
    ]



  create-enemies blue_number [;;blue number is set as global using a slider
    set color blue
    set size 0.5
    set xcor 10;; situate enemy fleet to the east
    set ycor random -16 ;;situate enemy fleet to the south
    set heading 0;; can be north but just to get more distance covered
    set health blue_health;; set on slider
    set speed blue_speed / 10 ;; set on slider the division by 10 allows realistic speed in knots (nautical miles per hour) to translate to an observable speed in the model
    separate-enemies;;spreads enemies out
  ]
  create-friends red_number [;; friendly ship set up
    set color red
    set size 0.5
    set xcor random -16;;sets friendlies in eastern half of battle space
    set ycor random 2 ;;creates two columns
    set heading 90;; sets an initial heading of west
    set health red_health;;set on slider the division by 10 allows realistic speed in knots (nautical miles per hour) to translate to an observable speed in the model
    set speed red_speed / 10;; set on slider
    seperate-friends
  ];; set number of red ships, heading east along centre line

  reset-ticks
end



to go

  ask patches [set pcolor 88 ];; make sure the map remains sea coloured as firing creates yellow patches which should be temprary 'flashes'

  let bluecount count enemies;; end of game module
    if bluecount = 0 [;; blue ships destroyed
      print "Game Over"
      stop
    ]

   let redcount count friends;;end of game module
    if redcount = 0 [;; redships destroyed
      print "Game Over"
      stop
    ]

  ask friends [;; the red fleet is to move forward and also look for enemies to fire upon
    check-damage;; check if ship has been hit
      fd speed;; this will be the speed set as redspeed
    if age > delay[;; delays the point at which red ships act control free, this allows them to complete as many passes as necessary to show what happens in closely controlled battle.  The difference in red behaviour is noticed once the delay time has elapsed and red ships shift to control-free
      pursue;;engage the three rules: target/close range/fire sub routine in control-free mode
    ]
    increment-age;; allows a global measurement of time elapsed
  ]

  ask enemies [;;similar to friends module but using shells rather than balls and shoot rather than fire to prevent friendly fire
    check-damage-from-friends;; check if ship has been hit
    fd speed;; move forward at bluespeed

  ]



  tick
end

to check-damage;; red ships can be hit by a blue ship firing a 'broadside' i.e. canons firing to the left and right sides, additionally for this model red ships can be hit from astern by blue ships (this is a hack to make the 'face' primitve for targeting work for red and therefore the same conditions for blue to prevent bias in the model
  ask friends[
    if any? enemies-on patch-left-and-ahead 180 1[;;astern / behind
      if random-float 100 < blue_accuracy[;;hit?
        ask patches in-radius 1 [set pcolor yellow];;flash
        set health health - 1;;take damage
        set color 26;;change colour indicating damage (orange)
        if speed > 0 [set speed speed - 0.1];;slow down due to demasting
        if health = 0 [set redcaptive redcaptive + 1];;count losses
        if health = 0 [die];;destroyed or captured
        if speed = 0 [die];;destroyed or captured
    ]
  ]
     if any? enemies-on patch-left-and-ahead 90 1 [;; this checks for enemies abeam and port (i.e. at 90 degrees to the left) and in canon range
      if random-float 100 < blue_accuracy[;;check to see if the enemy has hit the target
        ask patches in-radius 1 [set pcolor yellow];;create a 'flash'
        set health health - 1;;take damage
        set color 26;;damaged ships are a different colour (orange)
        if speed > 0 [set speed speed - 0.1];;slow down because of damage
        if health = 0 [set redcaptive redcaptive + 1];; loss count
        if health = 0 [die];; destroyed/captured
        if speed = 0 [die];;destroyed/captured
    ]
  ]
    if any? enemies-on patch-right-and-ahead 90 1 [;; this checks for enemies abeam and port (i.e. at 90 degrees to the right) and in canon range
      if random-float 100 < blue_accuracy[;;check to see if the enemy has hit the target
        ask patches in-radius 1 [set pcolor yellow];;create a 'flash'
        set health health - 1;;take damage
        set color 26;; turn orange
        if speed > 0 [set speed speed - 0.1];; slow down because of damage
        if health = 0 [set redcaptive redcaptive + 1];;loss count
        if health = 0 [die];;destroyed / damaged
        if speed = 0 [die];;destroyed / damaged
    ]
  ]
  ]
end

to check-damage-from-friends;;blue ships can be attacked from the broadside attacks but also from a red ship astern (firing ahead). Strictly this wasn't a feature of the battle but in order to use the 'face' primitive to target blue ships red ships need to be able to fire ahead
   ask enemies[
    if any? friends-on patch-left-and-ahead 180 1[;;astern
      if random-float 100 < red_accuracy[;;hit?
        ask patches in-radius 1 [set pcolor yellow];;flash
        set health health - 1;;take damage
        set color 126;;change coloour
        if speed > 0 [set speed speed - 0.1];;slowed by damage
        if health = 0 [set bluecaptive bluecaptive + 1];;update losses
        if health = 0 [die];;destroyed/captured
        if speed = 0 [die];;destroyed/captured
    ]
  ]
     if any? friends-on patch-left-and-ahead 90 1[;;port beam
      if random-float 100 < red_accuracy[;;hit?
        ask patches in-radius 1 [set pcolor yellow];;flash
        set health health - 1;;take damage
        set color 126;; change colour
        if speed > 0 [set speed speed - 0.01];;slow down due to damage
        if health = 0 [set bluecaptive bluecaptive + 1];;count losses
        if health = 0 [die];;destroyed/captured
        if speed = 0 [die];;destroyed/captured
    ]
  ]
     if any? friends-on patch-right-and-ahead 90 1[;;starboard beam
      if random-float 100 < red_accuracy[;;hit?
        ask patches in-radius 1 [set pcolor yellow];;flash
        set health health - 1;;take damage
        set color 126;;change colour
        if speed > 0 [set speed speed - 0.1];;slow down due to damage
        if health = 0 [set bluecaptive bluecaptive + 1]
        if health = 0 [die];;destroyed/captured
        if speed = 0 [die];;destroyed/captured
    ]
  ]
  ]
end

to separate-enemies ;;space out enemies
  if any? other enemies-here [;; check for more enemies in same space
    set heading 270;;head west
    fd 2;;go two patches
    set heading 0;; return to original course
  ]
end

to seperate-friends;;space out friends
  if any? other friends-here[;;check for red ships in same space
    set heading 180;;head south
    fd 1;; move 2
    set heading 090;; back to original course
  ]
end

to increment-age;;method og calculating global time elapsed
  set age (1 + age)
end


to pursue;; red ships target blue ships and 'hunt' by linking, closing distance and firing
   ask friends [
    if control-free = "yes" [;;user input for control-free mode, red ships only act independently if this is selected
    if distance one-of enemies < sense [;;gives red ships a situational awareness range called sense (range and distance are netlogo primitives)
      if count link-neighbors > 0[;;do you have a target?
    let linked-target one-of link-neighbors;;assign target to variable linked-target
    face linked-target;;face the target
          if speed < 0.1 [set speed speed + 0.05];;increase speed (this will overcome a certain amount of damage
  ]
      if count link-neighbors < 1 [;;if there is no target
       create-link-to one-of enemies[hide-link]];;link to target
    ]
    ]
  ]
end

@#$#@#$#@
GRAPHICS-WINDOW
210
10
746
547
-1
-1
16.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

BUTTON
26
50
96
83
Set up
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
106
51
169
84
Go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
2195
704
2367
737
red_number
red_number
0
100
27.0
1
1
Ships
HORIZONTAL

SLIDER
1839
700
2011
733
blue_number
blue_number
0
100
33.0
1
1
Ships
HORIZONTAL

SLIDER
1840
742
2012
775
blue_health
blue_health
0
5
5.0
1
1
NIL
HORIZONTAL

SLIDER
2197
746
2369
779
red_health
red_health
0
5
5.0
1
1
NIL
HORIZONTAL

MONITOR
1899
68
1956
113
Blue
count enemies
17
1
11

MONITOR
1972
69
2029
114
Red
count friends
17
1
11

PLOT
1897
139
2331
491
Damage Plot
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Blue" 1.0 0 -13791810 true "" "plot count enemies"
"Red" 1.0 0 -2674135 true "" "plot count friends"

MONITOR
1898
580
2034
625
Captured Blue Ships
bluecaptive
17
1
11

MONITOR
2249
583
2383
628
Captured Red Ships
redcaptive
17
1
11

MONITOR
1899
512
2100
557
Number of targeted blue ships
count links
17
1
11

SLIDER
1841
785
2011
818
blue_accuracy
blue_accuracy
0
100
50.0
1
1
Percent
HORIZONTAL

SLIDER
2197
789
2372
822
red_accuracy
red_accuracy
0
100
75.0
1
1
Percent
HORIZONTAL

SLIDER
1841
832
2013
865
blue_speed
blue_speed
0
10
5.0
1
1
Knots
HORIZONTAL

SLIDER
2198
835
2370
868
red_speed
red_speed
0
10
8.0
0.1
1
Knots
HORIZONTAL

SLIDER
2199
880
2371
913
sense
sense
0
100
50.0
1
1
NIL
HORIZONTAL

CHOOSER
2220
982
2358
1027
control-free
control-free
"yes" "no"
0

TEXTBOX
1847
653
1997
671
Blue Fleet
14
0.0
1

TEXTBOX
2195
649
2345
667
Red Fleet
14
0.0
1

BUTTON
1849
936
1928
980
Left
ask enemies [lt 90]
NIL
1
T
OBSERVER
NIL
A
NIL
NIL
1

BUTTON
1951
936
2032
979
Right
ask enemies [rt 90]
NIL
1
T
OBSERVER
NIL
D
NIL
NIL
1

BUTTON
1899
875
1995
923
Accelerate
ask enemies[ if speed < 2[set speed speed + 0.5]]
NIL
1
T
OBSERVER
NIL
W
NIL
NIL
1

BUTTON
1905
990
1983
1043
Slow
ask enemies [set speed speed - 0.5]
NIL
1
T
OBSERVER
NIL
S
NIL
NIL
1

SLIDER
12
116
185
149
wind_direction
wind_direction
0
360
105.0
1
1
NIL
HORIZONTAL

SLIDER
9
160
182
193
wind_speed
wind_speed
0
5
2.0
1
1
NIL
HORIZONTAL

SLIDER
2198
927
2373
960
delay
delay
0
100
14.0
1
1
Ticks
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This simulation is inspired by the Battle of Trafalgar 1805 and the book Power to the Edge (Alberts and Hayes 2003).  As described by Alberts and Heyes (2003), when the Royal Navy Grand Fleet faced the combined French and Spanish fleets on 21st October 1805 they were outnumbered and outgunned.  Yet the Royal Navy captured 21 enemy ships with no ships lost themselves.   One reason for this may be the more flexible system of Command and Control (C2), used by the Royal Navy versus the rigid C2 system that was in common use.  Nelson's tactical unorthodoxy gave the Royal Navy ships more scope to behave autonomously, collaboratively and to act on information they had.  This is termed self-synchronisation by Alberts and Hayes (2003).  They argue that this type of decentralised decision making is particularly important in the 21st Century as data abundance makes decentralised decision making more effective.

This model abastracts the concept of power to the edge from military applications to consider decision making in the 21st Century more broadly.  The model is designed as a teaching aid, particularly for social science, business and military studies.  The model simulates two fleets, red and blue.  The disposition and characteristics of both fleets can be adjusted.  Th red fleet can be made more autonomous and the results of the battle can be seen when this option is taken.  The simulation demonstrates the advatages of switching to more decentralised decision making when there is sufficient information.

The model can be used to consider complexity more broadly especially:

  Self-organisation
  Emergence
  Thresholds (self organising criticality)

## HOW IT WORKS

Both fleets can be set to different sizes, speeds and health values.  The two fleets will advance at right angles until they meet (this was called the 'crossing the 'T' manouvre.  The ships will then detect enemies at close range (neighboring patches) and fire canon balls.  If ships are hit, damage is taken and speed is reduced as a result of the damage (simulating the de-masting of the ships).  The blue fleet aims to escape the red fleet, whilst the red fleet are aiming to stop the blue fleet escaping in large numbers.  Additionally the accuracy of the red and blue guns can be changed from 0 to 100%.

To set the battle up like the actual Battle of Trafalgar:

Red Fleet:  27 ships, health 4, accuracy 75%, speed 8 sense 50

Blue Fleet: 33 Ships, health 5, accuracy 50%, speed 5

To see the famous 'crossing the 'T'' manouvre set delay to 20

The red fleet can be swtiched in and out of control-free modes. In control-free mode a delay can be set to allow the red ships to proceed normally to begin with.  After the delay has passed, the red ships suddenly switch to control-free mode.  This allows users to see the effect of the 'crossing the 'T'' manouvre before witnessing control-free behaviour. Additionally the red ships have a range at which they can detect and target blue ships.  In control-free mode, the red ships will close the blue ships as described above.  However, once the first encounter is complete, the red ships follow 3 rules:


  Face target and close range

  Fire on target once in range

  Target a new blue ship once the first is destroyed

Self organisation	Once the red ships are control-free, they follow the three rules given above. this has the effect of self organisation as the ships appear to target ships, sometimes collaboratively.  The ships seems as if they are guided by some kind of leadership, but in fact they are not.  This was termed self-synchronisation by Alberts and Heyes (2003), which is a specific term used in C2 research.  This is more broadly comparable to self-organisation in complexity theory.

Emergence	One the problems in understanding complexity is the challenge of 'thinking in levels' (Wilensky and Rand 2015, p. 12).  The model demonstrates the emergence of red fleet behaviour from a few simple rules for individual agents.  

Thresholds	The sense variable can dialled up or down.  At a certain threshold level the agent behaviour becomes 'organised and purposeful'.

 

## HOW TO USE IT

Set health, number, speed  and size of the fleets using the sliders on the interface.  The health values (red_health or blue_health) are set from 1 - 5 as an arbitary value to allow some exchange of fire.  The speed values (red_speed and blue_speed) are set between 0 and 10 knots.  The number is the actual number of agents in each fleet.  

Additionally, the red fleeet has the ability to switch between control-free mode (or not) A delay can be set, measured in ticks, so that if, in control-free mode, there is a delay in switching to independent behaviour.  This allows the model to demonstrate the difference in bahaviours in either mode and for users to see the effect of the 'crossing the 'T''manouvre, if interested.  

Red ships can sense enemies according to a slider which determines the number of patches the red ship can detect an enemy over.  The maximum is 100 which allows the red ship to detect any of the blue ships.  

Once the battle has been set up, select go.  The model will run until either the red or blue fleets are destroyed.  A damage plot reports the number of remaining blue and red ships, while damage monitors report the units of battle damge in each fleet.  Two moniters also report the remaining totals for each fleet.  Another monitor reports the number of targeted blue ships.  Users can try controlling the blue fleet with the manual control buttons to change speed and direction.

Set paramters as reqiured, click setup and the go.


## THINGS TO NOTICE

Once the red fleet start exchanging fire (in control-free mode), there is a sudden and noticeable change in behaviour.  The red ships suddenly change direction and appear to hunt down the blue ships.  If not in control-free mode, toggling to autonomous mode also creates this change in behaviour.

The red fleet behave in a coordinated way, working together to target the blue ships with multiple red ships.  The red ships coordinate with blue ship direction and speed to target them.  Red ships may split into multiple groups to pick off blue ships who are isolated from the fleet.  This is self organising behaviour and not coded into the simulation.


## THINGS TO TRY

Try toggling between control-free and normal modes.  Notice the difference in outcome of the battle and the behaviour of the red fleet.

Try changing the range at which red ships can detect blue ships using sense.  What happens when red ships are starved of information.

Try stacking the odds for the blue fleet by increasing their numbers and gun accuracy.  If the red fleet are control-free, can the blue fleet win?

Try taking control of the blue ships to evade the red fleet.  How difficult is it? What happens when you loose focus even briefly?

## EXTENDING THE MODEL

The model could be extended by having more complex blue tactics coded into the model, for example the blue ships could periodically change direction.


## NETLOGO FEATURES

The netlogo switch allows a clear demonstration of the autonomous and non-automous behaviours.

## RELATED MODELS



## CREDITS AND REFERENCES

This model was developed by Dr Matt Offord 2022 at Adam Smith Business School as a teaching resource for 21st Century leadership.  The idea was inspired by:

Alberts, David & Hayes, R.E.. (2003). Power to the Edge. CCRP Publication Series. 

Wilensky, U., & Rand, W. (2015). An Introduction to Agent-Based Modeling: Modeling Natural, Social, and Engineered Complex Systems with NetLogo. The MIT Press. http://www.jstor.org/stable/j.ctt17kk851

Please cite the NetLogo software as:

Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
COPYRIGHT AND LICENSE
Copyright 2002 Uri Wilensky.

CC BY-NC-SA 3.0

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

This model and associated activities and materials were created as part of the project: MODELING ACROSS THE CURRICULUM. The project gratefully acknowledges the support of the National Science Foundation, the National Institute of Health, and the Department of Education (IERI program) -- grant number REC #0115699. Additional support was provided through the projects: PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and/or INTEGRATED SIMULATION AND MODELING ENVIRONMENT -- NSF (REPP & ROLE programs) grant numbers REC #9814682 and REC-0126227.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
