breed [ waters water ]          ;; water molecules
breed [ hydroxides hydroxide ]  ;; base molecules
breed [ hydroniums hydronium ]  ;; acid molecules

globals [
  pH
  base-added    ;; use to keep track of how much total base has been added
]

to setup
  clear-all
  set-default-shape waters "molecule2"
  set-default-shape hydroniums "molecule3"
  set-default-shape hydroxides "molecule1"
  create-waters 100           ;; creates constant volume of water in which to dilute acid
    [ set color blue ]
  create-hydroniums vol-acid  ;; creates VOL-ACID of hydronium ions
    [ set color green ]
  ask turtles                       ;; randomize position and heading of turtles
    [ setxy random-xcor random-ycor ]
  set base-added 0
  calculate-pH
  reset-ticks
  update-plots
end

to go
  ask hydroxides [ react ]
  ask turtles
    [ fd 1                                        ;; move turtles around randomly
      rt random 10
      lt random 10 ]    ;; around the world
  tick
  calculate-pH
end

;; adds hydroxide molecules to the solution
to add-base
  create-hydroxides vol-base
    [ set color red
      fd 1 ]
  set base-added base-added + vol-base
end

;; hydroxide procedure
to react
  let partner one-of hydroniums-here   ;; see if there are any hydroniums here
  if partner != nobody                 ;; if one is found
    [ set breed waters                 ;; become water
      set color blue
      ask partner
        [ set breed waters             ;; partner becomes water too
          set color blue ] ]
end

;; calculates the pH from the amount of the various ions in solution;
;; note that for simplicity the calculations don't take the true molar
;; concentration of water into account, but instead use an arbitrarily
;; chosen factor of 1000 to produce numbers lying in a reasonable range
to calculate-pH
  let volume count turtles
  let concH (count hydroniums / volume)
  let concOH (count hydroxides / volume)
  ifelse (concH = concOH)
    [ set pH 7 ]
    [ ifelse (concH > concOH)
      [ set pH (- log (concH / 1000) 10) ]
      [ let pOH (- log (concOH / 1000) 10)
        set pH 14 - pOH ] ]
end

;; plotting procedures

to record-pH
  set-current-plot "Titration Curve"
  plotxy base-added pH
end


; Copyright 2001 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
335
10
695
391
12
12
14.0
1
10
1
1
1
0
1
1
1
-12
12
-12
12
1
1
1
ticks
30.0

MONITOR
265
200
324
245
pH
pH
2
1
11

SLIDER
6
67
192
100
vol-acid
vol-acid
0
100
20
1
1
molecules
HORIZONTAL

SLIDER
6
101
192
134
vol-base
vol-base
1
100
100
1
1
molecules
HORIZONTAL

BUTTON
9
24
70
57
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
76
24
137
57
go
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
212
84
288
117
add-base
add-base
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
257
341
333
374
record pH
record-pH
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
11
310
254
486
Titration Curve
Volume base
pH
0.0
100.0
0.0
14.0
true
false
"" ""
PENS
"pH" 1.0 0 -13345367 true "" ""

PLOT
11
148
254
307
pH Curve
Time
pH
0.0
100.0
0.0
14.0
true
false
"" ""
PENS
"pH" 1.0 0 -2674135 true "" "plot pH"

@#$#@#$#@
## WHAT IS IT?

This model demonstrates how chemists and biologists measure the pH of a solution. The value of pH, like many other chemical measurements, emerges from the interactions and relative ratios of the composite molecules within a solution.

## HOW IT WORKS

Specifically, pH is a measurement of the amount of hydronium ions (H+ or H3O+) that are present in a solution. Hydronium ions are generated when an acid molecule donates a proton to a water molecule. Bases have the opposite effect on water -- they take a hydrogen from a water molecule and generate hydroxide ions (OH-). These two reactions are listed below. Note the balance of charge and conversion of atoms. H-A denotes a strong acid and B denotes a strong base.

> H<sub>2</sub>O + H-A —> H<sub>3</sub>O<sup>+</sup> + A<sup>-</sup>
> B + H<sub>2</sub>O —> OH<sup>-</sup> + H-B<sup>+</sup>

It is important to note that this model simulates a strong acid and a strong base interacting. Acids and bases that are classified as strong dissociate completely in water. That means that all the H-A is converted to hydronium ions and all of the B is protonated, so that concentration of the original acid is equal to the concentration of hydronium ion. pH meters are capable of detecting how many hydronium ions or hydroxide ions are present in a solution. The formula for measuring pH is listed below. One can also calculate the pOH in a similar manner. [] indicates concentration in MOLARITY.

> pH = -log [H+]
> pOH = -log [OH-]

Hydronium ions and hydroxide ions are oppositely charged and react readily together. When they react, a hydrogen atom is transferred and two water molecules are generated in the process. Chemists often titrate acids and bases together to determine how stable the pH of a particular acid or base is. This experiment is done by taking a known amount of acid and adding various amounts of base to it. The titration curve is generated by plotting the pH against the volume of base added.

## HOW TO USE IT

Decide how much acid should be present at the start of the simulation with the VOL-ACID slider and press SETUP. Turtles will be distributed randomly across the world. BLUE turtles represent water molecules and GREEN turtles represent hydronium ions. A set amount of water molecules is added each time to the solution.

Press GO. The turtles will move randomly across the world and the pH of the solution will be plotted over time and displayed in the pH monitor.

To observe the effect of adding base to the solution, set the volume of base to be added with the VOL-BASE slider and press ADD-BASE to add the red base molecules.

To perform a titration experiment, set the sliders to desired values and press GO. While the model is running, press ADD-BASE. This will add VOL-BASE to the acid in the world. Wait for the pH to stabilize as you would in a real experiment and then press RECORD-PH. A point is then plotted on the curve with each addition of base so that the user can observe how the value of pH is related to the amount of base added to the solution.

## THINGS TO NOTICE

Observe the shape of the titration curve, especially where the slope ap                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          