patches-own [
  chemical             ;; amount of chemical on this patch
  food                 ;; amount of food on this patch (0, 1, or 2)
  nest?                ;; true on nest patches, false elsewhere
  nest-scent           ;; number that is higher closer to the nest
  food-source-number   ;; number (1, 2, or 3) to identify the food sources
  xc                   ;; unwrapped xcor
  yc                   ;; unwrapped ycor
  dist                 ;; turtle distance from origin

]

globals [
  total-time           ;; total number of ticks since initiation
  nest-mark            ;; marks the nest
]

;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup procedures ;;;
;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  set-default-shape turtles "bug"
  create-turtles population
  [ set size 1         ;; easier to see
    set color red  ]   ;; red = not carrying food
  setup-patches
  reset-ticks
end

to setup-patches
  ask patches
  [ setup-nest
    setup-food
    recolor-patch ]
end

to setup-nest  ;; patch procedure
  ;; set nest? variable to true inside the nest, false elsewhere
  set nest? (distancexy 0 0) < 1
  ;; spread a nest-scent over the whole world -- stronger near the nest
  ;set nest-scent 200 - distancexy 0 0
end

to setup-food  ;; patch procedure
  ;; setup food source one
  if (distancexy food-x-coordinate food-y-coordinate) < 1
  [ set food-source-number 1 ]
  ;; setup food source two on the lower-left
  ;if (distancexy (-0.6 * max-pxcor) (-0.6 * max-pycor)) < 1
  ;[ set food-source-number 2 ]
  ;; setup food source three on the upper-left
  ;if (distancexy (-0.8 * max-pxcor) (0.8 * max-pycor)) < 1
  ;[ set food-source-number 3 ]
  ;; set "food" at sources to either 1 or 2, randomly
  if food-source-number > 0
  [ set food 1 ]
end

to recolor-patch  ;; patch procedure
  ;; give color to nest and food sources
  ifelse nest?
  [ set pcolor violet ]
  [ ifelse food > 0
    [ if food-source-number = 1 [ set pcolor green ]
      if food-source-number = 2 [ set pcolor green + 3  ]
      if food-source-number = 3 [ set pcolor green - 3 ] ]
    ;; scale color to show chemical concentration
    [ set pcolor scale-color green chemical 0.1 5 ] ]
end

;;;;;;;;;;;;;;;;;;;;;
;;; Go procedures ;;;
;;;;;;;;;;;;;;;;;;;;;

to go  ;; forever button
  ifelse ticks < reset-time ;; if time is less than reset time
   [ ask turtles
     [ if food > 0;; stop tracking ants that find food
        [ set nest-mark 1 ;; mark nest
          die ]
     wiggle
     fd 1]] ;; move
  [ ask turtles ;; time is more than reset time
     [ setxy 0 0 ;; send turtles back to origin
       if nest-mark > 0 ;; if nest is marked, stop tracking ants
         [ die ]]
    reset-ticks ] ;; reset ticks
   if count turtles = 0
    [stop] ;; stop when all ants have found food
  set total-time total-time + 1 ;; time increment
  tick
  ;diffuse chemical (diffusion-rate / 100)
  ;ask patches
  ;[ set chemical chemical * (100 - evaporation-rate) / 100  ;; slowly evaporate chemical
  ;  recolor-patch ]
end

to look-for-food  ;; turtle procedure
  if food > 0
   [set nest-mark 1
        die ]
  ;[ set color orange + 1     ;; pick up food
  ;  rt 180                   ;; and turn around
  ;  stop ]
  ;; go in the direction where the chemical smell is strongest
  ;if (chemical >= 0.05) and (chemical < 2)
  ;[ uphill-chemical ]
end

to return-to-nest  ;; turtle procedure
  ;; drop food and head out again
  ;  set color red
  ;  rt 180 ]
  ;[ set chemical chemical + 60  ;; drop some chemical
  ; uphill-nest-scent ]         ;; head toward the greatest value of nest-scent
end

;; sniff left and right, and go where the strongest smell is
to uphill-chemical  ;; turtle procedure
  ;let scent-ahead chemical-scent-at-angle   0
  ;let scent-right chemical-scent-at-angle  45
  ;let scent-left  chemical-scent-at-angle -45
  ;if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  ;[ ifelse scent-right > scent-left
  ;  [ rt 45 ]
  ;  [ lt 45 ] ]
end

;; sniff left and right, and go where the strongest smell is
to uphill-nest-scent  ;; turtle procedure
  ;let scent-ahead nest-scent-at-angle   0
  ;let scent-right nest-scent-at-angle  45
  ;let scent-left  nest-scent-at-angle -45
  ;if (scent-right > scent-ahead) or (scent-left > scent-ahead)
  ;[ ifelse scent-right > scent-left
  ;  [ rt 45 ]
  ;  [ lt 45 ] ]
end

to wiggle  ;; turtle procedure
  rt random-float 360
  lt random-float 360
  ifelse not can-move? 1
    [ hide-turtle ]
    [ show-turtle ]
  set dist xcor * xcor + ycor * ycor
end

to-report nest-scent-at-angle [angle]
  ;let p patch-right-and-ahead angle 1
  ;if p = nobody [ report 0 ]
  ;report [nest-scent] of p
end

to-report chemical-scent-at-angle [angle]
  ;let p patch-right-and-ahead angle 1
  ;if p = nobody [ report 0 ]
  ;report [chemical] of p
end

to-report replace-all [target replacement str] ;; screeshot button setup
  let acc str
  while [position target acc != false] [
    set acc (replace-item (position target acc) acc replacement)
  ]
  report acc
end


; Copyright 1997 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
361
10
971
621
-1
-1
2.0
1
10
1
1
1
0
0
0
1
-150
150
-150
150
1
1
1
ticks
30.0

BUTTON
12
51
113
84
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
10
91
200
124
diffusion-rate
diffusion-rate
0.0
99.0
0.0
1.0
1
NIL
HORIZONTAL

SLIDER
10
128
200
161
evaporation-rate
evaporation-rate
0.0
99.0
0.0
1.0
1
NIL
HORIZONTAL

BUTTON
139
50
234
83
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
10
10
355
43
population
population
0.0
1000.0
500.0
1.0
1
NIL
HORIZONTAL

PLOT
10
247
355
434
average distance squared
time
D^2
0.0
50.0
0.0
120.0
true
false
"" ""
PENS
"Rate of Change" 1.0 0 -7500403 true "" "plot ((sum [ dist ] of turtles) / count turtles)"

MONITOR
210
91
356
136
number of ants searching 
count turtles
17
1
11

BUTTON
260
50
354
83
Screenshot
export-interface (word \"Ant Simulation\" (replace-all \":\" \"-\" date-and-time) \".png\")
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
10
165
200
198
reset-time
reset-time
0
20000
1500.0
100
1
NIL
HORIZONTAL

SLIDER
10
207
179
240
food-x-coordinate
food-x-coordinate
- max-pxcor
max-pxcor
40.0
5
1
NIL
HORIZONTAL

SLIDER
185
207
356
240
food-y-coordinate
food-y-coordinate
- max-pycor
max-pycor
85.0
5
1
NIL
HORIZONTAL

MONITOR
211
149
277
194
total ticks
total-time
17
1
11

MONITOR
285
149
351
194
ticks
ticks
17
1
11

PLOT
11
443
352
619
number of ants searching
ticks
number of ants
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

@#$#@#$#@
## WHAT IS IT?

In this project a colony of artificial ants searches for a target at a set distance. Though each ant follows a set of simple rules, the colony as a whole acts in a sophisticated manner.


## HOW IT WORKS

Every ant starts at the origin simultaneously and walks in a random manner (this is verified by the linear output produced on the average distance from origin squared by time graph). When an ant locates the target, it returns to the nest, marking it with a pheromone. When the reset time is reached, all ants return to the nest. If they detect the pheromone, they follow the trail of the original scout to the target. Otherwise, they continue to search randomly from the origin.

The experiment aims to find the optimal reset time to reduce the total search time by "parameter sweeping" the values with the help of the BehaviourSpace extension of Netlogo.

## HOW TO USE IT

Click the SETUP button to set up the ant nest (in red, at the center) and target (in green, coordinates decided by the sliders FOOD-X-COORDINATE and FOOD-Y-COORDINATE). Click the GO button to start the simulation. 

The EVAPORATION-RATE slider controls the evaporation rate of the path pheromone. The DIFFUSION-RATE slider controls the diffusion rate of the pheromone.

If you want to change the number of ants, move the POPULATION slider before pressing SETUP. To change the reset time, toggle the RESET-TIME slider. To change the location of the target with respect to the origin, change the FOOD-X-COORDINATE and FOOD-Y-COORDINATE sliders. 

You can monitor the average distance moved by the ants using the average distance squared by time graph and the total number of ants searching on the graph below. 

## ACKNOWLEDGEMENTS

This model was built as an extension of the "ANTS" model from the Netlogo models library. The code was edited and written by Ayaan Dutt, with the help of Dr Sandeep Krishna from NCBS, Bangalore. 

@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
