;; note :
;; cycle jour/nuit avec green + + et - - 
;; chasse mais avec les arbres pour le bois
;; creation denfants, vieillissement
;; fd en fonction de lage

Breed [humans Human]
breed [tree wood]
breed [towns town]
breed [foods food]
breed [houses house]

directed-link-breed [hunters hunter]
directed-link-breed [parents parent]

undirected-link-breed [lovers love]

tree-own [ ressource ]

towns-own [
  stock-food
  stock-wood
]

humans-own [ 
  sexe 
  age
  metier
  energie
  energie-max
  max-transporte
  type-item
  quantity
  target
  my-home
  can_move?
  ]

houses-own[
 owner 
]

foods-own [ 
  ressource
  energie
  can_move?]

globals [
 year 
 day
 hour
 night?
 mort-vieu
 mort-number
]

to SETUP
  ;; (for this model to work with NetLogo's new plotting features,
  ;; __clear-all-and-reset-ticks should be replaced with clear-all at
  ;; the beginning of your setup procedure and reset-ticks at the end
  ;; of the procedure.)
  __clear-all-and-reset-ticks
  prepare-patch
  prepare-turtle
  set year 0
  set hour 10
  set night? false
  set mort-number 0
  set mort-vieu 0
end

to prepare-turtle
  ask n-of 1 patches WITH [pxcor < 70 and pxcor > -70 and pycor < 70 and pycor > -70 ][
    sprout 1[
     set breed towns 
     set shape "campsite"
     set size 5
     set color 52
     set stock-food 10000
    ]
    create_human humans-quantity 20
  ]
 create_tree 500
 create_food 1000
  
end

to prepare-patch
  ask patches[
   set pcolor green 
  ]
end

to affichage
ifelse show-couple? [ask lovers [show-link]][ask lovers [hide-link]]
ifelse show-hunters? [ask hunters [show-link]][ask hunters [hide-link]]
ifelse show-generation? [ask parents [show-link]][ask parents [hide-link]]
  
end

to graph
  set-current-plot "Population"

  set-current-plot-pen "total"
  plot (count humans)
  
  set-current-plot-pen "couples"
  plot (count lovers)
  
  set-current-plot "Mort"
  
  set-current-plot-pen "Total"
  plot (mort-number)
  
  set-current-plot-pen "Vieillesse"
  plot (mort-vieu)
  
  set-current-plot "Ressources"

  set-current-plot-pen "Stock"
  plot (sum [stock-food] of towns)
  
  set-current-plot-pen "Nature"
  plot (sum [ressource] of foods)
  
  
  set-current-plot "Population Age"

  set-current-plot-pen "Age_moyen"
  plot (sum [age] of humans / count humans)
  
  set-current-plot-pen "Esperance de vie"
  plot (sum [energie-max] of humans / count humans)
  
end


to GO
  affichage
  ifelse less-lag? [ ask turtles with [ breed != humans and breed != houses and breed != towns ] [ hide-turtle] ][ask turtles [show-turtle]]
  every Speed[
    go-town
    if not night? [
    take-target
    hunt
    relationship
    create-family
    ]
    move
    repop 
    mort
    if test-fast? [naissance]
    if night?  [
      naissance
      ask humans [
        set target nobody
        ask my-out-hunters [die]
      ]
    ]
  ]
  every (Speed + 0.1) * 1.2[
    graph
    set hour hour + (2 / 30)
    if test-fast? [ ask humans [if (not night?) or (night? and age < 20) [ set age age + 0.5]]]
        if night? [set hour hour + 1 / 30]
    if hour > 24 [ set hour 0 
      set day day + 1
      if not test-fast? [ask humans[ set age age + 2]]]
    if day > 365 [ set day 0 
      set year year + 1]

    set night? false
    if hour < 9 [set night? true]
    if hour < 9 and hour > 7[
    ask patches with [pcolor < 55][
     set pcolor pcolor + 0.3 
    ]]
    if hour > 19[
      set night? true
    ask patches with [pcolor > 53][
     set pcolor pcolor - 0.3 
    ]]
ask humans [ set size age / 100 
  if size > 2 [set size 2 ]]
  ]
  if count humans = 0 [ stop ]
end

to mort
ask turtles With [(breed = humans) or (breed = foods)][
  if energie < 0 [
    if breed = humans [ set mort-number mort-number + 1]
    die
    ]
]
ask humans [
;; if age > ( random 20 + 85 ) [die]
if (age > (energie-max / 5 ) and not test-fast?) or (age > ( energie-max) and test-fast? ) [
  set mort-number mort-number + 1 
  set mort-vieu mort-vieu + 1
  die]
]
ask hunters [
 ask end1 [ set target nobody ]
 if link-length > 10 or end2 = nobody or end1 = nobody [die]
]
ask houses[
  if owner != nobody [
 if count owner = 0 [die] ]
]
end

to move
  ask turtles With [((breed = humans) or (breed = foods)) and can_move?][
    if random 100 < 30 [
   left random 90
   right random 90
    ]
    
       
    
    if breed = foods and random 1000 < 10 [
      face min-one-of towns [distance myself]
    ]
    
    if breed = humans [
      let close-town my-home
     if target != nobody[
       face target
    ]

   if ([distance myself] of close-town >= ( (energie - (60 / 100 * energie)) / 2 - 10 / 100 * energie)) or (quantity > max-transporte) or night?
   [
     face close-town
   ]
   fd 0.5
    ]
if (breed = humans or (breed = foods and not night?))  [fd 0.2 ]

if not night?  [set energie energie - 1]
  ]
end

to repop
  if (random 1000 < 50) and (count tree < 600) [
  create_tree 3
  if night? [create_tree 7]
  ]
  if (random 1000 < 50) and (count foods < 600) [
  create_food 7
  if not night? [create_food 3]
  ]
end

to create_tree [ number ]
  ask n-of (random number) patches[
     sprout 1 [
     set breed tree
     set shape "tree"
     set color green - 2
     set ressource random 100
     set size (ressource / 10)
   ]
  ]
end

to create_human [number value-age]
  sprout number [
    set breed humans
    set shape "person"
    set size 1.1
    ifelse random 100 > 50 
    [set color red
      set sexe "male"]
    [set color blue
      set sexe "female"]
    
      set age ((random value-age) + 17 )
ifelse test-fast?   [set energie-max ((random (( hour + 2 + day * 24 ) * 100)) + 100)][   set energie-max ((random (( day + 2 ) * 100)) + 100)]
      set energie random energie-max + energie-max
      set max-transporte 1000
      set type-item ""
      set quantity 0
      set target nobody
      set my-home min-one-of towns [distance myself]
      set can_move? true
   ]
end

to create_food [number]
ask n-of (random number) patches[
  sprout 1 [
    set breed foods
    set shape "cow"
    set ressource random 1000 + 800
    set size ressource / 700
    set energie 5000
    set color white
    set can_move? true
   ]
]
end

to create_house
  hatch 1 [
    set color random 100
   set breed houses
   set shape "house efficiency"
   set size 2
   set owner nobody
  ]
end

to go-town
  
  let terrain nobody
  ask towns [
   set size ( count humans in-radius 100 ) / 50 
  ]
  ask houses[
    set owner (humans with [ my-home = myself])
    set size count owner
  ]
  ask humans[

    if [distance myself] of my-home < 3
    [
      let dechargement quantity
      let temp-type type-item
      let consommation-food energie-max - energie
      let regeneration 0
      
      ask min-one-of towns [distance myself] [
       if temp-type = foods and stock-food < count humans * 1000 [ set stock-food stock-food + dechargement ]
       if temp-type = tree and stock-wood < count humans * 100 [ set stock-wood stock-wood + dechargement ]
       ifelse consommation-food > stock-food [set regeneration stock-food] [set regeneration consommation-food]
       set stock-food stock-food - regeneration
      ]
      
      set quantity 0
      set energie energie + regeneration
      ]
  ]
  
end

to hunt
  ask humans with [(target != nobody)] [
  if target != nobody and [distance myself] of target < 1[
    move-to target
    if target != nobody and [breed] of target = foods [
      ajout-transport ([ressource] of target)
      ask target [die]
      ]
    
    if target != nobody and [breed] of target = tree [
      ajout-transport 10
      ask target [set ressource ressource - 10
        set size (ressource / 10)
        if ressource < 0 [die]]]
    ]
  ]
end
  
to ajout-transport [ value ]

ifelse quantity + value < max-transporte [
    set quantity quantity + value
][ set quantity max-transporte]
end

to take-target
  ask humans with [quantity < max-transporte and age > 18] [
    let temp-target []
    ifelse type-item = "" and (count humans with [type-item = foods] / count humans * 100) < 50 [set temp-target (turtle-set foods in-radius 5)  ][
ifelse type-item = "" and (count humans with [type-item = tree] / count humans * 100) < 50 [set temp-target (turtle-set tree in-radius 15) ]
[ 
  let temp-breed type-item
 set temp-target turtles in-radius 10 with [breed = temp-breed]
]]
set temp-target temp-target with [count my-in-hunters < 5]

 set temp-target min-one-of temp-target [distance myself]
 if temp-target != nobody[
  ask hunters with [end1 = myself] [die]
  set target temp-target
  create-hunter-to target [set color red
    ifelse show-hunters? [show-link][hide-link]]
  set type-item [breed] of target

   
  ]
  ]
end

to relationship
  ask humans[
  if age > (random 6 + 17) and random 100 < 5 and count my-lovers = 0 [
    let my-sexe sexe
    let my-age age
    let my-place my-home
    
    let possible-love humans with [distance myself < 5 and sexe != my-sexe and age > (random 6 + 17) and age > my-age - 20 and age < my-age + 20 and (my-home != my-place or [breed] of my-home = towns or [breed] of my-place = towns) and count my-lovers = 0 ]
    
    if count possible-love != 0[
    set possible-love min-one-of possible-love [distance myself]
    
     create-love-with possible-love [set color pink
           ifelse show-couple? [show-link][hide-link]] 
     
      let couple []
    
    ask my-lovers [
      set couple both-ends
    ]
    ask couple [
     set my-home min-one-of towns [distance myself]

    ]]]]
end

to create-family
  ask humans [
    if random 100 < 5 and count my-lovers != 0 and count houses in-radius 10 = 0 and count towns in-radius 5 = 0 [
      let family []
      let person1 nobody
      let person2 nobody
      ask my-lovers [
        set family both-ends
        set person1 end1
        set person2 end2
      ]      
      let breed1 0
      let breed2 0
      ask person1 [ set breed1 [breed] of my-home]
      ask person2 [ set breed2 [breed] of my-home]
      
      if (breed1 != breed2 or breed1 = towns or breed2 = towns) [
       create_house
       let new-house one-of houses-here
                     
       ask family[
         set my-home new-house
       ]]
    ]
  ]
end

to naissance
 ;; ask humans with [(count my-lovers != 0) and (count my-out-parents < 10) and (sexe = "female") and ([breed] of my-home = houses)][
  ask humans with [(count my-lovers != 0) and (sexe = "female") and ([breed] of my-home = houses)][
if random 1000 < 5 [

      let parent []
      let parent1 nobody
      let parent2 nobody
     ask my-lovers [
set parent both-ends
set parent1 end1
set parent2 end2
     ]
     
     let energie-average (( [energie-max] of parent1 + [energie-max] of parent1 ) / 2)
;;   print (word "parent1 : " parent1 ", parent2 : " parent2 ", average : " energie-average)
      
  hatch 1[
    ifelse random 100 > 50 
    [set color red
      set sexe "male"]
    [set color blue
      set sexe "female"]
    
      set age 0
      ifelse test-fast?   [ set energie-max ( random energie-average * 2 ) + ( hour + day * 24) * 5 + ( energie-average )][   set energie-max ( random energie-average * 2 ) + ( day * 5 ) + ( energie-average )]
      
      set energie random energie-max + energie-max / 2
      set type-item ""
      set quantity 0
      set target nobody
      set can_move? true
      create-parents-from parent [set color yellow
            ifelse show-generation? [show-link][hide-link]]
   ]

  ]]
end
@#$#@#$#@
GRAPHICS-WINDOW
311
15
924
649
100
100
3.0
1
3
1
1
1
0
1
1
1
-100
100
-100
100
0
0
1
ticks
30.0

BUTTON
7
12
70
45
Begin
SETUP
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
82
12
145
45
Start
GO
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
5
60
299
93
Speed
Speed
0
0.5
0
0.0001
1
NIL
HORIZONTAL

MONITOR
11
161
82
206
arbres
count tree
17
1
11

MONITOR
158
350
248
395
population
count humans
17
1
11

MONITOR
93
163
172
208
vaches
count foods
17
1
11

MONITOR
98
512
185
557
nouriture
sum [stock-food] of towns\n
17
1
11

MONITOR
8
106
65
151
NIL
year\n
17
1
11

MONITOR
8
405
86
450
hommes
count humans with [sexe = \"male\"]
17
1
11

MONITOR
195
281
282
326
maisons
count houses
17
1
11

MONITOR
7
351
74
396
bucheron
count humans with [type-item = tree]
17
1
11

MONITOR
8
511
91
556
descendants
count parents / 2\n
17
1
11

MONITOR
72
105
129
150
NIL
day
17
1
11

MONITOR
138
105
195
150
NIL
hour
17
1
11

MONITOR
157
462
214
507
bois
sum [stock-wood] of towns
17
1
11

MONITOR
92
406
149
451
femmes
count humans with [sexe = \"female\"]
17
1
11

MONITOR
83
460
140
505
couple
count lovers
17
1
11

MONITOR
79
352
142
397
chasseur
count humans with [type-item = foods]
17
1
11

SWITCH
14
215
172
248
show-couple?
show-couple?
0
1
-1000

SWITCH
16
260
170
293
show-hunters?
show-hunters?
1
1
-1000

SWITCH
15
302
171
335
show-generation?
show-generation?
1
1
-1000

MONITOR
12
458
69
503
adultes
count humans with [age > 18]
17
1
11

PLOT
28
675
864
828
Population
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"total" 1.0 0 -2674135 true "" ""
"couples" 1.0 0 -1664597 true "" ""

PLOT
30
838
864
988
Ressources
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Stock" 1.0 0 -13791810 true "" ""
"Nature" 1.0 0 -10899396 true "" ""

SLIDER
153
15
304
48
humans-quantity
humans-quantity
0
200
150
1
1
NIL
HORIZONTAL

MONITOR
15
617
150
662
moyenne energie max
(sum [energie-max] of humans) / (count humans)
17
1
11

SWITCH
200
113
310
146
test-fast?
test-fast?
0
1
-1000

MONITOR
20
565
77
610
Mort
mort-number
17
1
11

MONITOR
90
566
180
611
mort vieillesse
mort-vieu
17
1
11

MONITOR
192
570
266
615
age moyen
(sum [age] of humans) / (count humans)
17
1
11

PLOT
31
999
865
1149
Mort
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Total" 1.0 0 -16777216 true "" ""
"Vieillesse" 1.0 0 -11053225 true "" ""

SWITCH
177
166
280
199
less-lag?
less-lag?
1
1
-1000

MONITOR
165
407
235
452
celibataire
count humans - (count lovers * 2)
17
1
11

PLOT
33
1155
865
1305
Population Age
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Age_moyen" 1.0 0 -955883 true "" ""
"Esperance de vie" 1.0 0 -14835848 true "" ""

MONITOR
188
222
299
267
enfants par foyer
(count parents / 2) / count houses
17
1
11

MONITOR
198
515
271
560
le plus agee
[age] of max-one-of humans [age]
17
1
11

@#$#@#$#@
## WHAT IS IT?

This section could give a general understanding of what the model is trying to show or explain.

## HOW IT WORKS

This section could explain what rules the agents use to create the overall behavior of the model.

## HOW TO USE IT

This section could explain how to use the model, including a description of each of the items in the interface tab.

## THINGS TO NOTICE

This section could give some ideas of things for the user to notice while running the model.

## THINGS TO TRY

This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.

## EXTENDING THE MODEL

This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.

## NETLOGO FEATURES

This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

## RELATED MODELS

This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.

## CREDITS AND REFERENCES

This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

campsite
false
0
Polygon -7500403 true true 150 11 30 221 270 221
Polygon -16777216 true false 151 90 92 221 212 221
Line -7500403 true 150 30 150 225

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

house bungalow
false
0
Rectangle -7500403 true true 210 75 225 255
Rectangle -7500403 true true 90 135 210 255
Rectangle -16777216 true false 165 195 195 255
Line -16777216 false 210 135 210 255
Rectangle -16777216 true false 105 202 135 240
Polygon -7500403 true true 225 150 75 150 150 75
Line -16777216 false 75 150 225 150
Line -16777216 false 195 120 225 150
Polygon -16777216 false false 165 195 150 195 180 165 210 195
Rectangle -16777216 true false 135 105 165 135

house colonial
false
0
Rectangle -7500403 true true 270 75 285 255
Rectangle -7500403 true true 45 135 270 255
Rectangle -16777216 true false 124 195 187 256
Rectangle -16777216 true false 60 195 105 240
Rectangle -16777216 true false 60 150 105 180
Rectangle -16777216 true false 210 150 255 180
Line -16777216 false 270 135 270 255
Polygon -7500403 true true 30 135 285 135 240 90 75 90
Line -16777216 false 30 135 285 135
Line -16777216 false 255 105 285 135
Line -7500403 true 154 195 154 255
Rectangle -16777216 true false 210 195 255 240
Rectangle -16777216 true false 135 150 180 180

house efficiency
false
0
Rectangle -7500403 true true 180 90 195 195
Rectangle -7500403 true true 90 165 210 255
Rectangle -16777216 true false 165 195 195 255
Rectangle -16777216 true false 105 202 135 240
Polygon -7500403 true true 225 165 75 165 150 90
Line -16777216 false 75 165 225 165

house ranch
false
0
Rectangle -7500403 true true 270 120 285 255
Rectangle -7500403 true true 15 180 270 255
Polygon -7500403 true true 0 180 300 180 240 135 60 135 0 180
Rectangle -16777216 true false 120 195 180 255
Line -7500403 true 150 195 150 255
Rectangle -16777216 true false 45 195 105 240
Rectangle -16777216 true false 195 195 255 240
Line -7500403 true 75 195 75 240
Line -7500403 true 225 195 225 240
Line -16777216 false 270 180 270 255
Line -16777216 false 0 180 300 180

house two story
false
0
Polygon -7500403 true true 2 180 227 180 152 150 32 150
Rectangle -7500403 true true 270 75 285 255
Rectangle -7500403 true true 75 135 270 255
Rectangle -16777216 true false 124 195 187 256
Rectangle -16777216 true false 210 195 255 240
Rectangle -16777216 true false 90 150 135 180
Rectangle -16777216 true false 210 150 255 180
Line -16777216 false 270 135 270 255
Rectangle -7500403 true true 15 180 75 255
Polygon -7500403 true true 60 135 285 135 240 90 105 90
Line -16777216 false 75 135 75 180
Rectangle -16777216 true false 30 195 93 240
Line -16777216 false 60 135 285 135
Line -16777216 false 255 105 285 135
Line -16777216 false 0 180 75 180
Line -7500403 true 60 195 60 240
Line -7500403 true 154 195 154 255

lander
true
0
Polygon -7500403 true true 45 75 150 30 255 75 285 225 240 225 240 195 210 195 210 225 165 225 165 195 135 195 135 225 90 225 90 195 60 195 60 225 15 225 45 75

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.5
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
